// Copyright 2022 The CCGO Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

package ccgo // import "modernc.org/ccgo/v4/lib"

var testExecKnownFails = map[string]struct{}{
	// ==== EXEC FAIL - compiles and builds but fails when executed.

	// Won't fix: setjmp/longjmp
	`assets/github.com/vnmakarov/mir/c-benchmarks/except.c`: {},
	`assets/github.com/vnmakarov/mir/c-tests/new/setjmp2.c`: {},

	// Won't fix: sigfpe
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20101011-1.c`:                 {},
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20101011-1.c`: {},

	// Won't fix: Architecture specific conversion overflow.
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20031003-1.c`:                 {},
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20031003-1.c`: {},

	// Won't fix: implementation defined bit fields
	`assets/github.com/vnmakarov/mir/c-tests/lacc/bitfield-basic.c`:         {},
	`assets/github.com/vnmakarov/mir/c-tests/lacc/bitfield-trailing-zero.c`: {},
	`assets/github.com/vnmakarov/mir/c-tests/lacc/bitfield-types-init.c`:    {},

	// Won't fix: long double
	`assets/github.com/vnmakarov/mir/c-tests/lacc/long-double-load.c`: {},

	// Won't fix: return_addr
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/return-addr.c`: {},

	// Won't fix, puts particular return value isn't specified
	`assets/github.com/vnmakarov/mir/c-tests/lacc/macro-paste.c`: {},
	`assets/github.com/vnmakarov/mir/c-tests/lacc/whitespace.c`:  {},

	// Won't fix, unsupported alignment
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr36093.c`: {}, // EXEC FAIL: assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr36093.c: panic: 544

	//TODO investigate
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/align-3.c`:                                    {}, // EXEC FAIL: assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/align-3.c: : FAIL: signal: aborted
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/builtin-types-compatible-p.c`:                 {}, // EXEC FAIL: assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/builtin-types-compatible-p.c: : FAIL: signal: aborted
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/align-3.c`:                    {}, // EXEC FAIL: assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/align-3.c: : FAIL: signal: aborted
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/builtin-types-compatible-p.c`: {}, // EXEC FAIL: assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/builtin-types-compatible-p.c: : FAIL: signal: aborted
	`assets/tcc-0.9.27/tests/tests2/95_bitfields.c`:                                                     {}, // EXEC FAIL: assets/tcc-0.9.27/tests/tests2/95_bitfields.c: ---- TEST 1 ----
	`assets/tcc-0.9.27/tests/tests2/95_bitfields_ms.c`:                                                  {}, // EXEC FAIL: assets/tcc-0.9.27/tests/tests2/95_bitfields_ms.c: ---- TEST 1 - MS-BITFIELDS ----

	// ==== BUILD FAIL - compiles but does not build.

	`assets/benchmarksgame-team.pages.debian.net/reverse-complement-4.c`: {}, // BUILD FAIL: "exit status 1"
	`assets/ccgo/bug/sqlite.c`: {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20010122-1.c`:                        {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20040308-1.c`:                        {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20040411-1.c`:                        {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20040709-1.c`:                        {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20040709-2.c`:                        {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20040709-3.c`:                        {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20080502-1.c`:                        {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20090113-2.c`:                        {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20090113-3.c`:                        {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20180921-1.c`:                        {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/960405-1.c`:                          {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/991014-1.c`:                          {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/align-nest.c`:                        {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/built-in-setjmp.c`:                   {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/builtin-bitops-1.c`:                  {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/cbrt.c`:                              {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/frame-address.c`:                     {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/20030331-1.c`:                   {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/compare-fp-1.c`:                 {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-4.c`:                     {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-4f.c`:                    {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-4l.c`:                    {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-5.c`:                     {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-8.c`:                     {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-8f.c`:                    {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-8l.c`:                    {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/pr38016.c`:                      {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr17377.c`:                           {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr35456.c`:                           {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr39228.c`:                           {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr42570.c`:                           {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr47237.c`:                           {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr60003.c`:                           {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr67037.c`:                           {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr79286.c`:                           {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr82210.c`:                           {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/strlen-6.c`:                          {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/va-arg-pack-1.c`:                     {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20010122-1.c`:        {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20040308-1.c`:        {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20040411-1.c`:        {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20040709-1.c`:        {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20040709-2.c`:        {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20040709-3.c`:        {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20080502-1.c`:        {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20090113-2.c`:        {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20090113-3.c`:        {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20180921-1.c`:        {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/960405-1.c`:          {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/991014-1.c`:          {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/align-nest.c`:        {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/built-in-setjmp.c`:   {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/builtin-bitops-1.c`:  {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/cbrt.c`:              {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/frame-address.c`:     {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/20030331-1.c`:   {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/compare-fp-1.c`: {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-4.c`:     {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-4f.c`:    {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-4l.c`:    {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-5.c`:     {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-8.c`:     {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-8f.c`:    {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-8l.c`:    {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/pr38016.c`:      {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr17377.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr35456.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr39228.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr42570.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr47237.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr60003.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr64242.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr67037.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr79286.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr82210.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr84521.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr93249.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr93494.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/strlen-6.c`:          {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/va-arg-pack-1.c`:     {}, // BUILD FAIL: "exit status 1"

	// ==== COMPILE FAIL - does not compile.

	`assets/benchmarksgame-team.pages.debian.net/mandelbrot-3.c`:                                {}, // COMPILE FAIL: "\"mandelbrot-3.c:27:21: unsupported vector type: v2df (expr.go:561:expr0: expr.go:4288:primaryExpression: expr.go:4760:primaryExpressionFloatConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:is..."
	`assets/benchmarksgame-team.pages.debian.net/mandelbrot-4.c`:                                {}, // COMPILE FAIL: "\"mandelbrot-4.c:19:21: unsupported vector type: v2df (expr.go:561:expr0: expr.go:4288:primaryExpression: expr.go:4760:primaryExpressionFloatConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:is..."
	`assets/benchmarksgame-team.pages.debian.net/mandelbrot-8.c`:                                {}, // COMPILE FAIL: "\"mandelbrot-8.c:16:30: unsupported vector type: Vec (expr.go:1240:checkVolatileExpr: expr.go:101:expr: expr.go:567:expr0: expr.go:1730:unaryExpression: type.go:407:isValidType: type.go:440:isValidType..."
	`assets/benchmarksgame-team.pages.debian.net/mandelbrot.c`:                                  {}, // COMPILE FAIL: "\"mandelbrot.c:23:15: unsupported vector type: v2df (expr.go:561:expr0: expr.go:4288:primaryExpression: expr.go:4760:primaryExpressionFloatConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isVa..."
	`assets/benchmarksgame-team.pages.debian.net/nbody-4.c`:                                     {}, // COMPILE FAIL: "\"_Float16 not supported on linux/amd64 (check.go:2473:check:)\""
	`assets/benchmarksgame-team.pages.debian.net/nbody-8.c`:                                     {}, // COMPILE FAIL: "\"_Float16 not supported on linux/amd64 (check.go:2473:check:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20000211-1.c`:                         {}, // COMPILE FAIL: "\"TODO (compile.go:478:compile: decl.go:299:externalDeclaration: decl.go:986:declaration: decl.go:1151:initDeclarator: type.go:18:typedef: type.go:315:typ0:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20000326-2.c`:                         {}, // COMPILE FAIL: "\"20000326-2.c:7:3: label declarations not supported (compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:403:functionDefinition0: stmt.go:340:compoundState..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20000518-1.c`:                         {}, // COMPILE FAIL: "\"20000518-1.c:7:2: label declarations not supported (compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:403:functionDefinition0: stmt.go:340:compoundState..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20010202-1.c`:                         {}, // COMPILE FAIL: "\"20010202-1.c:3:5: incomplete type: array of array of char (decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:383:functionDefinition0: type.go:459:isValidType1: type.go:383:isVa..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20010226-1.c`:                         {}, // COMPILE FAIL: "\"20010226-1.c:16:12: nested functions not supported (stmt.go:376:blockItem: stmt.go:42:statement: stmt.go:412:selectionStatement: stmt.go:892:bracedStatement: stmt.go:901:unbracedStatement: stmt.go:37..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20010605-1.c`:                         {}, // COMPILE FAIL: "\"20010605-1.c:9:9: nested functions not supported (compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:459:functionDefinition0: stmt.go:340:compoundStateme..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20010903-2.c`:                         {}, // COMPILE FAIL: "\"20010903-2.c:9:14: nested functions not supported (compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:459:functionDefinition0: stmt.go:340:compoundStatem..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20011023-1.c`:                         {}, // COMPILE FAIL: "\"20011023-1.c:8:8: nested functions not supported (compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:459:functionDefinition0: stmt.go:340:compoundStateme..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20020309-1.c`:                         {}, // COMPILE FAIL: "\"20020309-1.c:8:5: nested functions not supported (decl.go:459:functionDefinition0: stmt.go:340:compoundStatement: stmt.go:376:blockItem: stmt.go:26:statement: stmt.go:901:unbracedStatement: stmt.go:3..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20021108-1.c`:                         {}, // COMPILE FAIL: "\"TODO UnaryExpressionLabelAddr (expr.go:1220:additiveExpression: expr.go:1235:binopArgs: expr.go:1240:checkVolatileExpr: expr.go:101:expr: expr.go:567:expr0: expr.go:1739:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20021204-1.c`:                         {}, // COMPILE FAIL: "\"20021204-1.c:8:7: nested functions not supported (compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:459:functionDefinition0: stmt.go:340:compoundStateme..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20030224-1.c`:                         {}, // COMPILE FAIL: "\"20030224-1.c:6:25: invalid type size: -1 (decl.go:459:functionDefinition0: stmt.go:261:compoundStatement: decl.go:241:declareLocals: type.go:42:typ: type.go:65:typ0: type.go:478:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20030418-1.c`:                         {}, // COMPILE FAIL: "\"20030418-1.c:13:8: nested functions not supported (compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:459:functionDefinition0: stmt.go:340:compoundStatem..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20030716-1.c`:                         {}, // COMPILE FAIL: "\"20030716-1.c:3:6: incomplete type: array of int (decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:383:functionDefinition0: type.go:459:isValidType1: type.go:383:isValidParamTy..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20030903-1.c`:                         {}, // COMPILE FAIL: "\"TODO UnaryExpressionReal (expr.go:101:expr: expr.go:531:expr0: expr.go:3899:assignmentExpression: expr.go:101:expr: expr.go:567:expr0: expr.go:1765:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20030910-1.c`:                         {}, // COMPILE FAIL: "\"TODO UnaryExpressionReal (expr.go:101:expr: expr.go:531:expr0: expr.go:3904:assignmentExpression: expr.go:101:expr: expr.go:567:expr0: expr.go:1765:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20031011-1.c`:                         {}, // COMPILE FAIL: "\"20031011-1.c:15:8: nested functions not supported (compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:459:functionDefinition0: stmt.go:340:compoundStatem..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20040310-1.c`:                         {}, // COMPILE FAIL: "\"20040310-1.c:4:7: nested functions not supported (compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:459:functionDefinition0: stmt.go:340:compoundStateme..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20040317-1.c`:                         {}, // COMPILE FAIL: "\"20040317-1.c:1:5: incomplete type: array of array of char (decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:383:functionDefinition0: type.go:459:isValidType1: type.go:383:isVa..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20040317-3.c`:                         {}, // COMPILE FAIL: "\"20040317-3.c:4:7: nested functions not supported (compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:459:functionDefinition0: stmt.go:340:compoundStateme..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20040323-1.c`:                         {}, // COMPILE FAIL: "\"20040323-1.c:10:16: nested functions not supported (compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:459:functionDefinition0: stmt.go:340:compoundState..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20040614-1.c`:                         {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1700:goexit: compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:389:functionDefinition0: decl.go:107:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20050113-1.c`:                         {}, // COMPILE FAIL: "\"20050113-1.c:11:20: unsupported vector type: V2SF (expr.go:561:expr0: expr.go:4288:primaryExpression: expr.go:4760:primaryExpressionFloatConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isVa..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20050119-1.c`:                         {}, // COMPILE FAIL: "\"20050119-1.c:7:8: nested functions not supported (compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:459:functionDefinition0: stmt.go:340:compoundStateme..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20050122-2.c`:                         {}, // COMPILE FAIL: "\"20050122-2.c:10:3: label declarations not supported (compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:403:functionDefinition0: stmt.go:340:compoundStat..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20050510-1.c`:                         {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1700:goexit: compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:389:functionDefinition0: decl.go:107:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20070603-1.c`:                         {}, // COMPILE FAIL: "\"TODO UnaryExpressionReal (expr.go:1203:additiveExpression: expr.go:1235:binopArgs: expr.go:1240:checkVolatileExpr: expr.go:101:expr: expr.go:567:expr0: expr.go:1765:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20070603-2.c`:                         {}, // COMPILE FAIL: "\"TODO UnaryExpressionReal (expr.go:1203:additiveExpression: expr.go:1235:binopArgs: expr.go:1240:checkVolatileExpr: expr.go:101:expr: expr.go:567:expr0: expr.go:1765:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20090907-1.c`:                         {}, // COMPILE FAIL: "\"TODO (decl.go:299:externalDeclaration: decl.go:976:declaration: type.go:559:defineStructType: type.go:494:structLiteral: type.go:263:typ0: type.go:315:typ0:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20110131-1.c`:                         {}, // COMPILE FAIL: "\"-: TODO (expr.go:1240:checkVolatileExpr: expr.go:101:expr: expr.go:543:expr0: expr.go:955:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20121107-1.c`:                         {}, // COMPILE FAIL: "\"-: TODO (expr.go:561:expr0: expr.go:4305:primaryExpression: expr.go:543:expr0: expr.go:955:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/920301-1.c`:                           {}, // COMPILE FAIL: "\"TODO UnaryExpressionLabelAddr (init.go:244:initializerArray: init.go:82:initializer: expr.go:70:topExpr: expr.go:101:expr: expr.go:567:expr0: expr.go:1739:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/920415-1.c`:                           {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1700:goexit: compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:389:functionDefinition0: decl.go:107:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/920428-3.c`:                           {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1700:goexit: compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:389:functionDefinition0: decl.go:107:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/920501-1.c`:                           {}, // COMPILE FAIL: "\"TODO UnaryExpressionLabelAddr (init.go:244:initializerArray: init.go:82:initializer: expr.go:70:topExpr: expr.go:101:expr: expr.go:567:expr0: expr.go:1739:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/920501-7.c`:                           {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1700:goexit: compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:389:functionDefinition0: decl.go:107:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/920502-1.c`:                           {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1700:goexit: compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:389:functionDefinition0: decl.go:107:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/930118-1.c`:                           {}, // COMPILE FAIL: "\"930118-1.c:3:1: label declarations not supported (compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:403:functionDefinition0: stmt.go:340:compoundStateme..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/930506-2.c`:                           {}, // COMPILE FAIL: "\"930506-2.c:5:9: nested functions not supported (decl.go:459:functionDefinition0: stmt.go:340:compoundStatement: stmt.go:376:blockItem: stmt.go:26:statement: stmt.go:901:unbracedStatement: stmt.go:379..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/941014-4.c`:                           {}, // COMPILE FAIL: "\"TODO UnaryExpressionLabelAddr (init.go:30:initializerOuter: init.go:82:initializer: expr.go:70:topExpr: expr.go:101:expr: expr.go:567:expr0: expr.go:1739:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/950610-1.c`:                           {}, // COMPILE FAIL: "\"950610-1.c:1:1: incomplete type: array of array of int (decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:383:functionDefinition0: type.go:459:isValidType1: type.go:383:isValid..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/950613-1.c`:                           {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1700:goexit: compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:389:functionDefinition0: decl.go:107:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/950919-1.c`:                           {}, // COMPILE FAIL: "\"950919-1.c:2:10: assertions are a deprecated extension\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/951116-1.c`:                           {}, // COMPILE FAIL: "\"951116-1.c:7:7: nested functions not supported (compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:459:functionDefinition0: stmt.go:340:compoundStatement..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/981001-4.c`:                           {}, // COMPILE FAIL: "\"-: TODO (expr.go:561:expr0: expr.go:4305:primaryExpression: expr.go:543:expr0: expr.go:955:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/981006-1.c`:                           {}, // COMPILE FAIL: "\"981006-1.c:14:3: label declarations not supported (compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:403:functionDefinition0: stmt.go:340:compoundStatem..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/981223-1.c`:                           {}, // COMPILE FAIL: "\"TODO UnaryExpressionReal (expr.go:1308:equalityExpression: expr.go:1235:binopArgs: expr.go:1240:checkVolatileExpr: expr.go:101:expr: expr.go:567:expr0: expr.go:1765:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/991213-1.c`:                           {}, // COMPILE FAIL: "\"TODO UnaryExpressionImag (expr.go:70:topExpr: expr.go:101:expr: expr.go:561:expr0: expr.go:4305:primaryExpression: expr.go:567:expr0: expr.go:1763:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/991213-3.c`:                           {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1700:goexit: compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:389:functionDefinition0: decl.go:107:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/complex-1.c`:                          {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex int _Complex int (expr.go:70:topExpr: expr.go:115:expr: expr.go:169:convert: expr.go:355:convertType: type.go:30:helper: type.go:159:typ0:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/complex-2.c`:                          {}, // COMPILE FAIL: "\"TODO UnaryExpressionImag (expr.go:101:expr: expr.go:531:expr0: expr.go:3899:assignmentExpression: expr.go:101:expr: expr.go:567:expr0: expr.go:1763:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/complex-3.c`:                          {}, // COMPILE FAIL: "\"TODO UnaryExpressionImag (expr.go:1203:additiveExpression: expr.go:1235:binopArgs: expr.go:1240:checkVolatileExpr: expr.go:101:expr: expr.go:567:expr0: expr.go:1763:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/complex-4.c`:                          {}, // COMPILE FAIL: "\"TODO UnaryExpressionReal (expr.go:101:expr: expr.go:531:expr0: expr.go:3899:assignmentExpression: expr.go:101:expr: expr.go:567:expr0: expr.go:1765:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/complex-5.c`:                          {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex int _Complex int (expr.go:101:expr: expr.go:561:expr0: expr.go:4286:primaryExpression: expr.go:4739:primaryExpressionIntConst: type.go:30:helper: type.go:159:typ0:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/complex-6.c`:                          {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex int _Complex int (expr.go:101:expr: expr.go:561:expr0: expr.go:4286:primaryExpression: expr.go:4739:primaryExpressionIntConst: type.go:30:helper: type.go:159:typ0:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/ex.c`:                                 {}, // COMPILE FAIL: "\"ex.c:12:19: too few arguments to function 'foo', type 'function(int, int) returning int' in 'foo ()' (expr.go:3600:postfixExpressionCall: expr.go:70:topExpr: expr.go:101:expr: expr.go:559:expr0: expr..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/icfmatch.c`:                           {}, // COMPILE FAIL: "\"icfmatch.c:4:14: unsupported vector type: v4qi (expr.go:115:expr: expr.go:169:convert: expr.go:353:convertType: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/labels-1.c`:                           {}, // COMPILE FAIL: "\"TODO UnaryExpressionLabelAddr (init.go:30:initializerOuter: init.go:82:initializer: expr.go:70:topExpr: expr.go:101:expr: expr.go:567:expr0: expr.go:1739:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/labels-2.c`:                           {}, // COMPILE FAIL: "\"TODO UnaryExpressionLabelAddr (init.go:354:initializerStruct: init.go:82:initializer: expr.go:70:topExpr: expr.go:101:expr: expr.go:567:expr0: expr.go:1739:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/labels-3.c`:                           {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1700:goexit: compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:389:functionDefinition0: decl.go:107:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/nested-1.c`:                           {}, // COMPILE FAIL: "\"nested-1.c:15:24: incomplete type: array of char (expr.go:101:expr: expr.go:567:expr0: expr.go:1706:unaryExpression: type.go:395:isValidType: type.go:407:isValidType: type.go:471:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/nested-2.c`:                           {}, // COMPILE FAIL: "\"nested-2.c:9:7: nested functions not supported (compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:459:functionDefinition0: stmt.go:340:compoundStatement..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/nested-3.c`:                           {}, // COMPILE FAIL: "\"nested-3.c:13:7: nested functions not supported (compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:459:functionDefinition0: stmt.go:340:compoundStatemen..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pass.c`:                               {}, // COMPILE FAIL: "\"pass.c:13:10: too many arguments to function 'foo', type 'function(int, int, int) returning int' in 'foo ((int) & q, q, w, e, q, (int) &w)' (stmt.go:1201:jumpStatement: expr.go:1240:checkVolatileExpr..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pc44485.c`:                            {}, // COMPILE FAIL: "\"-: TODO (expr.go:1240:checkVolatileExpr: expr.go:101:expr: expr.go:543:expr0: expr.go:955:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr17913.c`:                            {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1700:goexit: compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:389:functionDefinition0: decl.go:107:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr18903.c`:                            {}, // COMPILE FAIL: "\"TODO UnaryExpressionLabelAddr (stmt.go:376:blockItem: stmt.go:38:statement: expr.go:70:topExpr: expr.go:101:expr: expr.go:567:expr0: expr.go:1739:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr21356.c`:                            {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1700:goexit: compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:389:functionDefinition0: decl.go:107:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr21728.c`:                            {}, // COMPILE FAIL: "\"pr21728.c:5:3: label declarations not supported (compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:403:functionDefinition0: stmt.go:340:compoundStatemen..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr22422.c`:                            {}, // COMPILE FAIL: "\"TODO pr22422.c:27:3: from pointer to int, exprUintptr to pointer to int exprVoid, src '&d->c [d->n]', buf '((((aad))+4)+(((ppuintptr(((*tsD)(iqunsafe.ppPointer((aad))).fdn))))*4))' (stmt.go:376:block..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr25224.c`:                            {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1700:goexit: compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:389:functionDefinition0: decl.go:107:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr27341-1.c`:                          {}, // COMPILE FAIL: "\"TODO UnaryExpressionImag (expr.go:101:expr: expr.go:531:expr0: expr.go:3899:assignmentExpression: expr.go:101:expr: expr.go:567:expr0: expr.go:1763:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr27889.c`:                            {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex int _Complex int (decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:436:functionDefinition0: decl.go:950:signature: type.go:48:typ2: type.go:15..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr28489.c`:                            {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1700:goexit: compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:389:functionDefinition0: decl.go:107:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr29128.c`:                            {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1700:goexit: compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:389:functionDefinition0: decl.go:107:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr30984.c`:                            {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1700:goexit: compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:389:functionDefinition0: decl.go:107:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr32919.c`:                            {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1700:goexit: compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:389:functionDefinition0: decl.go:107:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr33382.c`:                            {}, // COMPILE FAIL: "\"-: TODO (expr.go:561:expr0: expr.go:4305:primaryExpression: expr.go:543:expr0: expr.go:955:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr33617.c`:                            {}, // COMPILE FAIL: "\".: unsupported vector type: V8SF (asm_amd64.s:1700:goexit: asm_amd64.s:1700:goexit: compile.go:531:compile: decl.go:911:signature: type.go:383:isValidParamType: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr34334.c`:                            {}, // COMPILE FAIL: "\"TODO (compile.go:478:compile: decl.go:299:externalDeclaration: decl.go:986:declaration: decl.go:1151:initDeclarator: type.go:18:typedef: type.go:315:typ0:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr34856.c`:                            {}, // COMPILE FAIL: "\"pr34856.c:11:16: unsupported vector type: VU32 (expr.go:115:expr: expr.go:169:convert: expr.go:353:convertType: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr35006.c`:                            {}, // COMPILE FAIL: "\"pr35006.c:9:8: nested functions not supported (compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:459:functionDefinition0: stmt.go:340:compoundStatement:..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr35431.c`:                            {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex int _Complex int (expr.go:101:expr: expr.go:561:expr0: expr.go:4286:primaryExpression: expr.go:4739:primaryExpressionIntConst: type.go:30:helper: type.go:159:typ0:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr38360.c`:                            {}, // COMPILE FAIL: "\"pr38360.c:7:3: too few arguments to function 'fputs', type 'function(pointer to const char, pointer to void) returning int' in 'fputs (\\\"\\\")' (stmt.go:38:statement: expr.go:70:topExpr: expr.go:101:ex..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr38771.c`:                            {}, // COMPILE FAIL: "\"-: TODO (expr.go:561:expr0: expr.go:4305:primaryExpression: expr.go:543:expr0: expr.go:955:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr41987.c`:                            {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex char _Complex char (expr.go:101:expr: expr.go:561:expr0: expr.go:4286:primaryExpression: expr.go:4739:primaryExpressionIntConst: type.go:30:helper: type.go:159:typ0:)..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr42196-1.c`:                          {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex int _Complex int (decl.go:299:externalDeclaration: decl.go:978:declaration: type.go:578:defineUnionType: type.go:488:unionLiteral: type.go:312:typ0: type.go:159:typ0:..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr42196-2.c`:                          {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex int _Complex int (decl.go:299:externalDeclaration: decl.go:978:declaration: type.go:578:defineUnionType: type.go:488:unionLiteral: type.go:323:typ0: type.go:159:typ0:..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr42196-3.c`:                          {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex int _Complex int (decl.go:299:externalDeclaration: decl.go:978:declaration: type.go:578:defineUnionType: type.go:488:unionLiteral: type.go:323:typ0: type.go:159:typ0:..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr42559.c`:                            {}, // COMPILE FAIL: "\"TODO UnaryExpressionLabelAddr (init.go:30:initializerOuter: init.go:82:initializer: expr.go:70:topExpr: expr.go:101:expr: expr.go:567:expr0: expr.go:1739:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr42716.c`:                            {}, // COMPILE FAIL: "\"-: TODO (expr.go:1240:checkVolatileExpr: expr.go:101:expr: expr.go:543:expr0: expr.go:955:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr42717.c`:                            {}, // COMPILE FAIL: "\"-: TODO (expr.go:1240:checkVolatileExpr: expr.go:101:expr: expr.go:543:expr0: expr.go:955:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr44119.c`:                            {}, // COMPILE FAIL: "\"-: TODO (expr.go:1240:checkVolatileExpr: expr.go:101:expr: expr.go:543:expr0: expr.go:955:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr46107.c`:                            {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1700:goexit: compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:389:functionDefinition0: decl.go:107:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr47428.c`:                            {}, // COMPILE FAIL: "\"pr47428.c:24:3: too few arguments to function 'fn', type 'function(const int, int) returning int' in 'fn (0)' (stmt.go:38:statement: expr.go:70:topExpr: expr.go:101:expr: expr.go:559:expr0: expr.go:2..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr51495.c`:                            {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1700:goexit: compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:389:functionDefinition0: decl.go:107:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr51694.c`:                            {}, // COMPILE FAIL: "\"pr51694.c:14:3: too few arguments to function 'foo', type 'function(int, pointer to function())' in 'foo (x)' (stmt.go:38:statement: expr.go:70:topExpr: expr.go:101:expr: expr.go:559:expr0: expr.go:2..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr52750.c`:                            {}, // COMPILE FAIL: "\"pr52750.c:8:11: unsupported vector type: V (expr.go:561:expr0: expr.go:4286:primaryExpression: expr.go:4739:primaryExpressionIntConst: type.go:30:helper: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr53410-2.c`:                          {}, // COMPILE FAIL: "\"pr53410-2.c:9:3: unsupported vector type: V (expr.go:101:expr: expr.go:567:expr0: expr.go:1653:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr53748.c`:                            {}, // COMPILE FAIL: "\"pr53748.c:8:3: unsupported vector type: V (expr.go:101:expr: expr.go:567:expr0: expr.go:1653:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr54713-1.c`:                          {}, // COMPILE FAIL: "\"pr54713-1.c:15:3: unsupported vector type: V (expr.go:101:expr: expr.go:567:expr0: expr.go:1653:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr54713-2.c`:                          {}, // COMPILE FAIL: "\"pr54713-1.c:15:3: unsupported vector type: V (expr.go:101:expr: expr.go:567:expr0: expr.go:1653:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr54713-3.c`:                          {}, // COMPILE FAIL: "\"pr54713-1.c:15:3: unsupported vector type: V (expr.go:101:expr: expr.go:567:expr0: expr.go:1653:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr56571.c`:                            {}, // COMPILE FAIL: "\"-: TODO (expr.go:561:expr0: expr.go:4305:primaryExpression: expr.go:543:expr0: expr.go:955:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr58164.c`:                            {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1700:goexit: compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:389:functionDefinition0: decl.go:107:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr60502.c`:                            {}, // COMPILE FAIL: "\"pr60502.c:9:16: unsupported vector type: v16i8 (expr.go:115:expr: expr.go:169:convert: expr.go:353:convertType: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr70199.c`:                            {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1700:goexit: compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:389:functionDefinition0: decl.go:107:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr70355.c`:                            {}, // COMPILE FAIL: "\"TODO vector (compile.go:478:compile: decl.go:299:externalDeclaration: decl.go:986:declaration: decl.go:1151:initDeclarator: type.go:18:typedef: type.go:89:typ0:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr70633.c`:                            {}, // COMPILE FAIL: "\"pr70633.c:10:5: unsupported vector type: V (decl.go:459:functionDefinition0: stmt.go:261:compoundStatement: decl.go:232:declareLocals: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr70916.c`:                            {}, // COMPILE FAIL: "\"-: TODO (expr.go:3904:assignmentExpression: expr.go:101:expr: expr.go:543:expr0: expr.go:955:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr71109.c`:                            {}, // COMPILE FAIL: "\"pr71109.c:15:7: too few arguments to function 'foo', type 'function(int, struct S, struct T)' in 'foo (bar, a)' (stmt.go:38:statement: expr.go:70:topExpr: expr.go:101:expr: expr.go:559:expr0: expr.go..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr77754-1.c`:                          {}, // COMPILE FAIL: "\"pr77754-1.c:5:13: incomplete type: array of array of int (asm_amd64.s:1700:goexit: asm_amd64.s:1700:goexit: compile.go:531:compile: decl.go:911:signature: type.go:383:isValidParamType: type.go:471:is..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr77754-2.c`:                          {}, // COMPILE FAIL: "\"pr77754-2.c:5:6: incomplete type: array of array of int (type.go:658:defineType0: type.go:658:defineType0: type.go:646:defineType0: type.go:459:isValidType1: type.go:383:isValidParamType: type.go:471..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr77754-3.c`:                          {}, // COMPILE FAIL: "\"pr77754-3.c:5:14: incomplete type: array of array of int (type.go:642:defineType: type.go:658:defineType0: type.go:646:defineType0: type.go:459:isValidType1: type.go:383:isValidParamType: type.go:471..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr77754-4.c`:                          {}, // COMPILE FAIL: "\"pr77754-4.c:5:14: incomplete type: array of array of int (type.go:642:defineType: type.go:658:defineType0: type.go:646:defineType0: type.go:459:isValidType1: type.go:383:isValidParamType: type.go:471..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr77754-5.c`:                          {}, // COMPILE FAIL: "\"pr77754-5.c:6:6: incomplete type: array of array of int (decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:383:functionDefinition0: type.go:459:isValidType1: type.go:383:isVali..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr82052.c`:                            {}, // COMPILE FAIL: "\"-: TODO (expr.go:1240:checkVolatileExpr: expr.go:101:expr: expr.go:543:expr0: expr.go:955:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr82564.c`:                            {}, // COMPILE FAIL: "\"pr82564.c:9:5: invalid type size: -1 (decl.go:459:functionDefinition0: stmt.go:261:compoundStatement: decl.go:241:declareLocals: type.go:42:typ: type.go:65:typ0: type.go:478:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr84136.c`:                            {}, // COMPILE FAIL: "\"TODO UnaryExpressionLabelAddr (expr.go:531:expr0: expr.go:3858:assignmentExpression: expr.go:1240:checkVolatileExpr: expr.go:101:expr: expr.go:567:expr0: expr.go:1739:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr84305.c`:                            {}, // COMPILE FAIL: "\"pr84305.c:3:34: TODO (expr.go:1921:postfixExpressionIndex: expr.go:101:expr: expr.go:559:expr0: expr.go:2004:postfixExpression: expr.go:1837:postfixExpressionIndex: expr.go:1787:mul:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr84960.c`:                            {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1700:goexit: compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:389:functionDefinition0: decl.go:107:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr85704.c`:                            {}, // COMPILE FAIL: "\"TODO *cc.StructType (expr.go:3904:assignmentExpression: expr.go:101:expr: expr.go:559:expr0: expr.go:2317:postfixExpression: init.go:105:initializer: init.go:275:initializerStruct:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr85945.c`:                            {}, // COMPILE FAIL: "\"pr85945.c:4:1: unsupported vector type: V (decl.go:978:declaration: type.go:578:defineUnionType: type.go:488:unionLiteral: type.go:323:typ0: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr86122.c`:                            {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex int _Complex int (expr.go:101:expr: expr.go:561:expr0: expr.go:4286:primaryExpression: expr.go:4739:primaryExpressionIntConst: type.go:30:helper: type.go:159:typ0:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr86123.c`:                            {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex unsigned _Complex unsigned (expr.go:101:expr: expr.go:561:expr0: expr.go:4286:primaryExpression: expr.go:4739:primaryExpressionIntConst: type.go:30:helper: type.go:15..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr89655.c`:                            {}, // COMPILE FAIL: "\"-: TODO (expr.go:561:expr0: expr.go:4305:primaryExpression: expr.go:543:expr0: expr.go:955:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr90139.c`:                            {}, // COMPILE FAIL: "\"pr90139.c:10:5: unsupported vector type: V (decl.go:459:functionDefinition0: stmt.go:261:compoundStatement: decl.go:241:declareLocals: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/simd-1.c`:                             {}, // COMPILE FAIL: "\"simd-1.c:5:16: unsupported vector type: v2si (expr.go:561:expr0: expr.go:4286:primaryExpression: expr.go:4722:primaryExpressionIntConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isValidType..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/simd-2.c`:                             {}, // COMPILE FAIL: "\"simd-2.c:14:9: unsupported vector type: floatvect2 (expr.go:559:expr0: expr.go:2122:postfixExpression: expr.go:2974:postfixExpressionSelect: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/simd-3.c`:                             {}, // COMPILE FAIL: "\"simd-3.c:19:9: unsupported vector type: floatvect2 (expr.go:559:expr0: expr.go:2122:postfixExpression: expr.go:2974:postfixExpressionSelect: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/simd-4.c`:                             {}, // COMPILE FAIL: "\"simd-4.c:11:26: unsupported vector type: floatvect2 (expr.go:101:expr: expr.go:567:expr0: expr.go:1653:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/simd-6.c`:                             {}, // COMPILE FAIL: "\"simd-6.c:5:11: unsupported vector type: vec (init.go:99:initializer: init.go:174:initializerArray: type.go:42:typ: type.go:337:typ0: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/sra-1.c`:                              {}, // COMPILE FAIL: "\"TODO UnaryExpressionReal (expr.go:1337:relationExpression: expr.go:1235:binopArgs: expr.go:1240:checkVolatileExpr: expr.go:101:expr: expr.go:567:expr0: expr.go:1765:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/struct-non-lval-2.c`:                  {}, // COMPILE FAIL: "\"TODO assertion failed (expr.go:101:expr: expr.go:559:expr0: expr.go:2122:postfixExpression: expr.go:3072:postfixExpressionSelect: expr.go:115:expr: expr.go:131:convert:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/struct-non-lval-3.c`:                  {}, // COMPILE FAIL: "\"TODO exprUintptr (expr.go:3072:postfixExpressionSelect: expr.go:101:expr: expr.go:561:expr0: expr.go:4305:primaryExpression: expr.go:531:expr0: expr.go:3909:assignmentExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/uuarg.c`:                              {}, // COMPILE FAIL: "\"uuarg.c:4:10: too few arguments to function 'foo', type 'function(int, int, int, int, int, int, int, int, int) returning int' in 'foo ()' (expr.go:1235:binopArgs: expr.go:1240:checkVolatileExpr: expr..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/vector-1.c`:                           {}, // COMPILE FAIL: "\"vector-1.c:3:1: unsupported vector type: float (decl.go:976:declaration: type.go:559:defineStructType: type.go:494:structLiteral: type.go:263:typ0: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/vector-2.c`:                           {}, // COMPILE FAIL: "\"vector-2.c:3:1: unsupported vector type: float (decl.go:976:declaration: type.go:559:defineStructType: type.go:494:structLiteral: type.go:263:typ0: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/vector-4.c`:                           {}, // COMPILE FAIL: "\"vector-4.c:7:47: unsupported vector type: signed char (decl.go:299:externalDeclaration: decl.go:986:declaration: decl.go:1181:initDeclarator: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/vector-align-1.c`:                     {}, // COMPILE FAIL: "\"TODO vector (compile.go:478:compile: decl.go:299:externalDeclaration: decl.go:986:declaration: decl.go:1181:initDeclarator: type.go:42:typ: type.go:89:typ0:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20000822-1.c`:                         {}, // COMPILE FAIL: "\"20000822-1.c:12:7: nested functions not supported (compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:459:functionDefinition0: stmt.go:340:compoundStatem..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20010209-1.c`:                         {}, // COMPILE FAIL: "\"20010209-1.c:6:7: nested functions not supported (compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:459:functionDefinition0: stmt.go:340:compoundStateme..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20010605-1.c`:                         {}, // COMPILE FAIL: "\"20010605-1.c:5:14: nested functions not supported (compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:459:functionDefinition0: stmt.go:340:compoundStatem..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20010605-2.c`:                         {}, // COMPILE FAIL: "\"TODO UnaryExpressionReal (expr.go:101:expr: expr.go:531:expr0: expr.go:3899:assignmentExpression: expr.go:101:expr: expr.go:567:expr0: expr.go:1765:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20020411-1.c`:                         {}, // COMPILE FAIL: "\"TODO UnaryExpressionReal (expr.go:101:expr: expr.go:531:expr0: expr.go:3899:assignmentExpression: expr.go:101:expr: expr.go:567:expr0: expr.go:1765:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20020412-1.c`:                         {}, // COMPILE FAIL: "\"20020412-1.c:31:7: invalid type size: -1 (expr.go:4305:primaryExpression: expr.go:567:expr0: expr.go:1634:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:478:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20030330-1.c`:                         {}, // COMPILE FAIL: "20030330-1.o.go:1002:4: undefined: \"link_error\" external (all_test.go:465:1: all_test.go:561:testExec1: ccgo.go:203:Main: ccgo.go:673:main: link.go:312:link: link.go:880:link:) (all_test.go:465:1: all..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20030501-1.c`:                         {}, // COMPILE FAIL: "\"20030501-1.c:7:9: nested functions not supported (decl.go:459:functionDefinition0: stmt.go:340:compoundStatement: stmt.go:376:blockItem: stmt.go:26:statement: stmt.go:901:unbracedStatement: stmt.go:3..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20030910-1.c`:                         {}, // COMPILE FAIL: "\"TODO UnaryExpressionReal (expr.go:1605:unaryExpression: expr.go:101:expr: expr.go:561:expr0: expr.go:4305:primaryExpression: expr.go:567:expr0: expr.go:1765:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20040302-1.c`:                         {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1700:goexit: compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:389:functionDefinition0: decl.go:107:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20040423-1.c`:                         {}, // COMPILE FAIL: "\"20040423-1.c:13:22: incomplete type: array of int (expr.go:101:expr: expr.go:567:expr0: expr.go:1730:unaryExpression: type.go:395:isValidType: type.go:407:isValidType: type.go:471:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20040520-1.c`:                         {}, // COMPILE FAIL: "\"20040520-1.c:6:13: nested functions not supported (compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:459:functionDefinition0: stmt.go:340:compoundStatem..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20041124-1.c`:                         {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex unsigned short _Complex unsigned short (decl.go:299:externalDeclaration: decl.go:976:declaration: type.go:559:defineStructType: type.go:494:structLiteral: type.go:263..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20041201-1.c`:                         {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex char _Complex char (decl.go:299:externalDeclaration: decl.go:986:declaration: decl.go:1151:initDeclarator: type.go:18:typedef: type.go:263:typ0: type.go:159:typ0:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20041214-1.c`:                         {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1700:goexit: compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:389:functionDefinition0: decl.go:107:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20041218-2.c`:                         {}, // COMPILE FAIL: "\"20041218-2.c:7:17: incomplete type: array of char (expr.go:101:expr: expr.go:567:expr0: expr.go:1730:unaryExpression: type.go:395:isValidType: type.go:407:isValidType: type.go:471:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20050121-1.c`:                         {}, // COMPILE FAIL: "\"TODO UnaryExpressionReal (expr.go:101:expr: expr.go:531:expr0: expr.go:3899:assignmentExpression: expr.go:101:expr: expr.go:567:expr0: expr.go:1765:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20050316-1.c`:                         {}, // COMPILE FAIL: "\"20050316-1.c:15:29: unsupported vector type: V2SI (expr.go:561:expr0: expr.go:4286:primaryExpression: expr.go:4739:primaryExpressionIntConst: type.go:30:helper: type.go:65:typ0: type.go:440:isValidTy..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20050316-2.c`:                         {}, // COMPILE FAIL: "\"20050316-2.c:38:14: unsupported vector type: V2SF (expr.go:561:expr0: expr.go:4288:primaryExpression: expr.go:4760:primaryExpressionFloatConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isVa..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20050316-3.c`:                         {}, // COMPILE FAIL: "\"20050316-3.c:29:3: unsupported vector type: V2USI (expr.go:559:expr0: expr.go:2122:postfixExpression: expr.go:2974:postfixExpressionSelect: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20050604-1.c`:                         {}, // COMPILE FAIL: "\"20050604-1.c:16:3: unsupported vector type: v4hi (decl.go:986:declaration: decl.go:1181:initDeclarator: type.go:42:typ: type.go:323:typ0: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20050607-1.c`:                         {}, // COMPILE FAIL: "\"20050607-1.c:12:32: unsupported vector type: V2SI (expr.go:561:expr0: expr.go:4286:primaryExpression: expr.go:4722:primaryExpressionIntConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isVali..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20060420-1.c`:                         {}, // COMPILE FAIL: "\"20060420-1.c:8:19: unsupported vector type: v4flt (expr.go:1240:checkVolatileExpr: expr.go:101:expr: expr.go:567:expr0: expr.go:1730:unaryExpression: type.go:407:isValidType: type.go:440:isValidType1..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20070919-1.c`:                         {}, // COMPILE FAIL: "\"20070919-1.c:31:7: invalid type size: -1 (expr.go:561:expr0: expr.go:4318:primaryExpression: decl.go:177:newAutovar: type.go:42:typ: type.go:65:typ0: type.go:478:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20071210-1.c`:                         {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1700:goexit: compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:389:functionDefinition0: decl.go:107:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20090219-1.c`:                         {}, // COMPILE FAIL: "\"20090219-1.c:12:8: nested functions not supported (compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:459:functionDefinition0: stmt.go:340:compoundStatem..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/920302-1.c`:                           {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1700:goexit: compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:389:functionDefinition0: decl.go:107:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/920415-1.c`:                           {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1700:goexit: compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:389:functionDefinition0: decl.go:107:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/920428-2.c`:                           {}, // COMPILE FAIL: "\"920428-2.c:4:14: label declarations not supported (stmt.go:376:blockItem: stmt.go:42:statement: stmt.go:412:selectionStatement: stmt.go:892:bracedStatement: stmt.go:901:unbracedStatement: stmt.go:374..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/920501-3.c`:                           {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1700:goexit: compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:389:functionDefinition0: decl.go:107:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/920501-4.c`:                           {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1700:goexit: compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:389:functionDefinition0: decl.go:107:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/920501-5.c`:                           {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1700:goexit: compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:389:functionDefinition0: decl.go:107:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/920501-7.c`:                           {}, // COMPILE FAIL: "\"920501-7.c:13:3: label declarations not supported (compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:403:functionDefinition0: stmt.go:340:compoundStatem..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/920612-2.c`:                           {}, // COMPILE FAIL: "\"920612-2.c:6:7: nested functions not supported (compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:459:functionDefinition0: stmt.go:340:compoundStatement..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/920721-4.c`:                           {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1700:goexit: compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:389:functionDefinition0: decl.go:107:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/921017-1.c`:                           {}, // COMPILE FAIL: "\"921017-1.c:7:7: nested functions not supported (compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:459:functionDefinition0: stmt.go:340:compoundStatement..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/921215-1.c`:                           {}, // COMPILE FAIL: "\"921215-1.c:5:8: nested functions not supported (compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:459:functionDefinition0: stmt.go:340:compoundStatement..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/930406-1.c`:                           {}, // COMPILE FAIL: "\"TODO *cc.LabelDeclaration (asm_amd64.s:1700:goexit: compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:389:functionDefinition0: decl.go:107:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/931002-1.c`:                           {}, // COMPILE FAIL: "\"931002-1.c:10:8: nested functions not supported (compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:459:functionDefinition0: stmt.go:340:compoundStatemen..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/960416-1.c`:                           {}, // COMPILE FAIL: "\"960416-1.c:57:23: helper: unsupported type: t_be (expr.go:1137:castExpression: expr.go:101:expr: expr.go:561:expr0: expr.go:4286:primaryExpression: expr.go:4739:primaryExpressionIntConst: type.go:28:..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/970217-1.c`:                           {}, // COMPILE FAIL: "\"970217-1.c:1:1: incomplete type: array of int (decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:383:functionDefinition0: type.go:459:isValidType1: type.go:383:isValidParamType..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/980526-1.c`:                           {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1700:goexit: compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:389:functionDefinition0: decl.go:107:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/980929-1.c`:                           {}, // COMPILE FAIL: "\"TODO 980929-1.c:17:5: from pointer to int, exprUintptr to pointer to int exprVoid, src '&n', buf 'ppuintptr(iqunsafe.ppPointer(&(aan)))' (stmt.go:376:blockItem: stmt.go:38:statement: expr.go:70:topEx..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/990208-1.c`:                           {}, // COMPILE FAIL: "\"TODO UnaryExpressionLabelAddr (expr.go:101:expr: expr.go:531:expr0: expr.go:3904:assignmentExpression: expr.go:101:expr: expr.go:567:expr0: expr.go:1739:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/builtin-prefetch-3.c`:                 {}, // COMPILE FAIL: "\"TODO exprUintptr (expr.go:567:expr0: expr.go:1605:unaryExpression: expr.go:101:expr: expr.go:559:expr0: expr.go:2122:postfixExpression: expr.go:3053:postfixExpressionSelect:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/comp-goto-1.c`:                        {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1700:goexit: compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:389:functionDefinition0: decl.go:107:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/comp-goto-2.c`:                        {}, // COMPILE FAIL: "\"comp-goto-2.c:15:3: label declarations not supported (compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:403:functionDefinition0: stmt.go:340:compoundSta..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/complex-1.c`:                          {}, // COMPILE FAIL: "\"TODO UnaryExpressionReal (expr.go:2119:postfixExpression: expr.go:3600:postfixExpressionCall: expr.go:70:topExpr: expr.go:101:expr: expr.go:567:expr0: expr.go:1765:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/complex-6.c`:                          {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex int _Complex int (decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:436:functionDefinition0: decl.go:929:signature: type.go:48:typ2: type.go:15..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/complex-7.c`:                          {}, // COMPILE FAIL: "\"TODO 2.2iL *cc.ComplexLongDoubleValue from=_Complex long t=long double mode=exprDefault (expr.go:1235:binopArgs: expr.go:1240:checkVolatileExpr: expr.go:101:expr: expr.go:561:expr0: expr.go:4288:prim..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/pr72824-2.c`:                     {}, // COMPILE FAIL: "\"pr72824-2.c:17:17: unsupported vector type: V (expr.go:561:expr0: expr.go:4288:primaryExpression: expr.go:4770:primaryExpressionFloatConst: type.go:30:helper: type.go:65:typ0: type.go:440:isValidType..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/medce-1.c`:                            {}, // COMPILE FAIL: "medce-1.o.go:1024:2: undefined: \"link_error\" external (all_test.go:465:1: all_test.go:561:testExec1: ccgo.go:203:Main: ccgo.go:673:main: link.go:312:link: link.go:880:link:) (all_test.go:465:1: all_te..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/nest-align-1.c`:                       {}, // COMPILE FAIL: "\"nest-align-1.c:25:8: nested functions not supported (compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:459:functionDefinition0: stmt.go:340:compoundStat..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/nest-stdar-1.c`:                       {}, // COMPILE FAIL: "\"nest-stdar-1.c:5:10: nested functions not supported (compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:459:functionDefinition0: stmt.go:340:compoundStat..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/nestfunc-1.c`:                         {}, // COMPILE FAIL: "\"nestfunc-1.c:15:7: nested functions not supported (compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:459:functionDefinition0: stmt.go:340:compoundStatem..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/nestfunc-2.c`:                         {}, // COMPILE FAIL: "\"nestfunc-2.c:13:7: nested functions not supported (compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:459:functionDefinition0: stmt.go:340:compoundStatem..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/nestfunc-3.c`:                         {}, // COMPILE FAIL: "\"nestfunc-3.c:12:8: nested functions not supported (compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:459:functionDefinition0: stmt.go:340:compoundStatem..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/nestfunc-5.c`:                         {}, // COMPILE FAIL: "\"nestfunc-5.c:8:3: label declarations not supported (compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:403:functionDefinition0: stmt.go:340:compoundState..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/nestfunc-6.c`:                         {}, // COMPILE FAIL: "\"nestfunc-6.c:13:3: label declarations not supported (compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:403:functionDefinition0: stmt.go:340:compoundStat..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/nestfunc-7.c`:                         {}, // COMPILE FAIL: "\"nestfunc-7.c:15:12: nested functions not supported (compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:459:functionDefinition0: stmt.go:340:compoundState..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr22061-1.c`:                          {}, // COMPILE FAIL: "\"pr22061-1.c:4:6: incomplete type: array of array of char (decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:383:functionDefinition0: type.go:459:isValidType1: type.go:383:isVal..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr22061-2.c`:                          {}, // COMPILE FAIL: "\"pr22061-2.c:2:13: incomplete type: array of array of char (decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:383:functionDefinition0: type.go:459:isValidType1: type.go:383:isVa..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr22061-3.c`:                          {}, // COMPILE FAIL: "\"pr22061-3.c:4:7: nested functions not supported (compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:459:functionDefinition0: stmt.go:340:compoundStatemen..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr22061-4.c`:                          {}, // COMPILE FAIL: "\"pr22061-4.c:5:8: nested functions not supported (compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:459:functionDefinition0: stmt.go:340:compoundStatemen..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr23135.c`:                            {}, // COMPILE FAIL: "\"pr23135.c:19:14: unsupported vector type: vecint (expr.go:561:expr0: expr.go:4286:primaryExpression: expr.go:4722:primaryExpressionIntConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isValid..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr23324.c`:                            {}, // COMPILE FAIL: "\"TODO (decl.go:1243:initDeclaratorInit: type.go:642:defineType: type.go:656:defineType0: type.go:578:defineUnionType: type.go:488:unionLiteral: type.go:315:typ0:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr24135.c`:                            {}, // COMPILE FAIL: "\"pr24135.c:7:3: label declarations not supported (compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:403:functionDefinition0: stmt.go:340:compoundStatemen..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr34154.c`:                            {}, // COMPILE FAIL: "\"TODO SelectionStatementSwitch (decl.go:403:functionDefinition0: stmt.go:340:compoundStatement: stmt.go:376:blockItem: stmt.go:42:statement: stmt.go:464:selectionStatement: stmt.go:868:selectionStatem..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr38151.c`:                            {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex int _Complex int (decl.go:299:externalDeclaration: decl.go:976:declaration: type.go:559:defineStructType: type.go:494:structLiteral: type.go:263:typ0: type.go:159:typ..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr38969.c`:                            {}, // COMPILE FAIL: "\"TODO UnaryExpressionReal (expr.go:101:expr: expr.go:531:expr0: expr.go:3899:assignmentExpression: expr.go:101:expr: expr.go:567:expr0: expr.go:1765:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr41935.c`:                            {}, // COMPILE FAIL: "\"pr41935.c:10:10: TODO (expr.go:1953:postfixExpressionIndex: expr.go:101:expr: expr.go:559:expr0: expr.go:2004:postfixExpression: expr.go:1837:postfixExpressionIndex: expr.go:1787:mul:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr49218.c`:                            {}, // COMPILE FAIL: "\"pr49218.c:11:9: TODO \\\"(Xf)\\\" from=float float 4 exprDefault -> to=L __int128 16 exprDefault (pr49218.c:11:9:) (init.go:30:initializerOuter: init.go:82:initializer: expr.go:70:topExpr: expr.go:115:ex..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr51447.c`:                            {}, // COMPILE FAIL: "\"pr51447.c:16:3: label declarations not supported (compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:403:functionDefinition0: stmt.go:340:compoundStateme..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr53645-2.c`:                          {}, // COMPILE FAIL: "\"pr53645-2.c:41:1: unsupported vector type: UV (expr.go:101:expr: expr.go:567:expr0: expr.go:1653:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr53645.c`:                            {}, // COMPILE FAIL: "\"pr53645.c:41:1: unsupported vector type: UV (expr.go:101:expr: expr.go:567:expr0: expr.go:1653:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr54471.c`:                            {}, // COMPILE FAIL: "\"pr54471.c:20:16: TODO \\\"(aaix)\\\" from=__int128 __int128 16 exprDefault -> to=unsigned __int128 unsigned __int128 16 exprDefault (pr54471.c:20:16:) (expr.go:531:expr0: expr.go:4017:assignmentExpressio..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr56837.c`:                            {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex int _Complex int (decl.go:299:externalDeclaration: decl.go:986:declaration: decl.go:1181:initDeclarator: type.go:42:typ: type.go:337:typ0: type.go:159:typ0:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr60960.c`:                            {}, // COMPILE FAIL: "\"pr60960.c:26:14: unsupported vector type: v4qi (expr.go:561:expr0: expr.go:4286:primaryExpression: expr.go:4728:primaryExpressionIntConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isValidTy..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr61375.c`:                            {}, // COMPILE FAIL: "\"pr61375.c:18:18: TODO \\\"(aamask)\\\" from=__int128 __int128 16 exprDefault -> to=unsigned __int128 unsigned __int128 16 exprDefault (pr61375.c:18:18:) (expr.go:586:andExpression: expr.go:1235:binopArgs..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr63302.c`:                            {}, // COMPILE FAIL: "\"pr63302.c:16:33: TODO \\\"(-((iqlibc.ppInt32FromInt32(1))))\\\" from=int int 4 exprDefault -> to=__int128 __int128 16 exprDefault (pr63302.c:16:33:) (expr.go:101:expr: expr.go:533:expr0: expr.go:1137:cas..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr65170.c`:                            {}, // COMPILE FAIL: "\"pr65170.c:15:8: TODO \\\"(iqlibc.ppUint64FromInt32((-((iqlibc.ppInt32FromInt32(1))))))\\\" from=H unsigned long long 8 exprDefault -> to=unsigned __int128 unsigned __int128 16 exprDefault (pr65170.c:15:8..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr65427.c`:                            {}, // COMPILE FAIL: "\"pr65427.c:4:3: unsupported vector type: V (decl.go:299:externalDeclaration: decl.go:986:declaration: decl.go:1181:initDeclarator: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr68249.c`:                            {}, // COMPILE FAIL: "\"-: TODO (expr.go:3904:assignmentExpression: expr.go:101:expr: expr.go:543:expr0: expr.go:955:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr68381.c`:                            {}, // COMPILE FAIL: "\"TODO unsigned short * unsigned short -> int (stmt.go:42:statement: stmt.go:411:selectionStatement: expr.go:101:expr: expr.go:559:expr0: expr.go:2062:postfixExpression: expr.go:2356:mulOverflow:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr70460.c`:                            {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1700:goexit: compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:389:functionDefinition0: decl.go:107:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr70903.c`:                            {}, // COMPILE FAIL: "\"TODO (expr.go:3600:postfixExpressionCall: expr.go:70:topExpr: expr.go:101:expr: expr.go:559:expr0: expr.go:2317:postfixExpression: init.go:51:initializer:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr71494.c`:                            {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1700:goexit: compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:389:functionDefinition0: decl.go:107:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr71554.c`:                            {}, // COMPILE FAIL: "\"TODO unsigned * int -> int (stmt.go:42:statement: stmt.go:411:selectionStatement: expr.go:101:expr: expr.go:559:expr0: expr.go:2062:postfixExpression: expr.go:2356:mulOverflow:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr71626-1.c`:                          {}, // COMPILE FAIL: "\"TODO PostfixExpressionIndex (expr.go:1311:equalityExpression: expr.go:1235:binopArgs: expr.go:1240:checkVolatileExpr: expr.go:101:expr: expr.go:559:expr0: expr.go:2011:postfixExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr71626-2.c`:                          {}, // COMPILE FAIL: "\"TODO PostfixExpressionIndex (expr.go:1311:equalityExpression: expr.go:1235:binopArgs: expr.go:1240:checkVolatileExpr: expr.go:101:expr: expr.go:559:expr0: expr.go:2011:postfixExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr77767.c`:                            {}, // COMPILE FAIL: "\"pr77767.c:4:1: incomplete type: array of int (decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:383:functionDefinition0: type.go:459:isValidType1: type.go:383:isValidParamType:..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr80692.c`:                            {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Decimal64 _Decimal64 (expr.go:101:expr: expr.go:561:expr0: expr.go:4288:primaryExpression: expr.go:4750:primaryExpressionFloatConst: type.go:30:helper: type.go:159:typ0:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr84169.c`:                            {}, // COMPILE FAIL: "\"TODO unsigned char * int -> T (stmt.go:38:statement: expr.go:70:topExpr: expr.go:101:expr: expr.go:559:expr0: expr.go:2062:postfixExpression: expr.go:2356:mulOverflow:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr84748.c`:                            {}, // COMPILE FAIL: "\"pr84748.c:20:8: TODO \\\"(Xa)\\\" from=int int 4 exprDefault -> to=unsigned __int128 unsigned __int128 16 exprDefault (pr84748.c:20:8:) (expr.go:531:expr0: expr.go:4017:assignmentExpression: expr.go:70:t..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr85169.c`:                            {}, // COMPILE FAIL: "\"pr85169.c:8:9: unsupported vector type: V (expr.go:101:expr: expr.go:567:expr0: expr.go:1653:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr85331.c`:                            {}, // COMPILE FAIL: "\"pr85331.c:9:11: unsupported vector type: V (expr.go:561:expr0: expr.go:4288:primaryExpression: expr.go:4760:primaryExpressionFloatConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isValidType..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr85582-2.c`:                          {}, // COMPILE FAIL: "\"pr85582-2.c:15:8: TODO \\\"(aay)\\\" from=int int 4 exprDefault -> to=__int128 __int128 16 exprDefault (pr85582-2.c:15:8:) (expr.go:531:expr0: expr.go:4017:assignmentExpression: expr.go:70:topExpr: expr...."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr85582-3.c`:                          {}, // COMPILE FAIL: "\"pr85582-3.c:35:9: TODO \\\"((iqlibc.pp]ppuint64FromInt32(0x101)) << ((((iqlibc.ppUint64FromInt64(16)) * (iqlibc.ppUint64FromInt32(mv__CHAR_BIT__))) / (iqlibc.ppUint64FromInt32(2))) - (iqlibc.ppUint64Fr..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr88739.c`:                            {}, // COMPILE FAIL: "\"TODO exprUintptr (expr.go:2122:postfixExpression: expr.go:2938:postfixExpressionSelect: expr.go:101:expr: expr.go:559:expr0: expr.go:2122:postfixExpression: expr.go:3053:postfixExpressionSelect:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr89434.c`:                            {}, // COMPILE FAIL: "\"TODO int * long -> unsigned (stmt.go:38:statement: expr.go:70:topExpr: expr.go:101:expr: expr.go:559:expr0: expr.go:2062:postfixExpression: expr.go:2356:mulOverflow:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/scal-to-vec1.c`:                       {}, // COMPILE FAIL: "scal-to-vec1.o.go:993:17: undefined: \"main\" external (all_test.go:465:1: all_test.go:561:testExec1: ccgo.go:203:Main: ccgo.go:673:main: link.go:312:link: link.go:880:link:) (all_test.go:465:1: all_tes..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/scal-to-vec2.c`:                       {}, // COMPILE FAIL: "scal-to-vec2.o.go:1023:17: undefined: \"main\" external (all_test.go:465:1: all_test.go:561:testExec1: ccgo.go:203:Main: ccgo.go:673:main: link.go:312:link: link.go:880:link:) (all_test.go:465:1: all_te..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/scal-to-vec3.c`:                       {}, // COMPILE FAIL: "scal-to-vec3.o.go:987:17: undefined: \"main\" external (all_test.go:465:1: all_test.go:561:testExec1: ccgo.go:203:Main: ccgo.go:673:main: link.go:312:link: link.go:880:link:) (all_test.go:465:1: all_tes..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/simd-1.c`:                             {}, // COMPILE FAIL: "\"simd-1.c:10:14: unsupported vector type: vecint (expr.go:561:expr0: expr.go:4286:primaryExpression: expr.go:4739:primaryExpressionIntConst: type.go:30:helper: type.go:65:typ0: type.go:440:isValidType..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/simd-2.c`:                             {}, // COMPILE FAIL: "\"simd-2.c:8:14: unsupported vector type: vecint (expr.go:561:expr0: expr.go:4286:primaryExpression: expr.go:4739:primaryExpressionIntConst: type.go:30:helper: type.go:65:typ0: type.go:440:isValidType1..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/simd-4.c`:                             {}, // COMPILE FAIL: "\"simd-4.c:17:34: unsupported vector type: v2si (expr.go:561:expr0: expr.go:4286:primaryExpression: expr.go:4722:primaryExpressionIntConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isValidTyp..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/simd-5.c`:                             {}, // COMPILE FAIL: "\"simd-5.c:5:9: unsupported vector type: Q (expr.go:561:expr0: expr.go:4286:primaryExpression: expr.go:4722:primaryExpressionIntConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/simd-6.c`:                             {}, // COMPILE FAIL: "\"simd-6.c:13:14: unsupported vector type: v8qi (expr.go:561:expr0: expr.go:4286:primaryExpression: expr.go:4728:primaryExpressionIntConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isValidTyp..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/zero-struct-2.c`:                      {}, // COMPILE FAIL: "\"zero-struct-2.c:15:48: TODO \\\"Xone_raw_spinlock(cgtls)\\\" from=raw_spinlock_t struct 0 exprDefault -> to=spinlock_t struct 0 exprDefault (zero-struct-2.c:15:48:) (expr.go:559:expr0: expr.go:2317:postf..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20000822-1.c`:         {}, // COMPILE FAIL: "\"gcc.c-torture/execute/20000822-1.c:12:7: nested functions not supported (compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:459:functionDefinition0: stmt..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20010209-1.c`:         {}, // COMPILE FAIL: "\"gcc.c-torture/execute/20010209-1.c:6:7: nested functions not supported (compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:459:functionDefinition0: stmt...."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20010605-1.c`:         {}, // COMPILE FAIL: "\"gcc.c-torture/execute/20010605-1.c:5:14: nested functions not supported (compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:459:functionDefinition0: stmt..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20010605-2.c`:         {}, // COMPILE FAIL: "\"TODO UnaryExpressionReal (expr.go:101:expr: expr.go:531:expr0: expr.go:3899:assignmentExpression: expr.go:101:expr: expr.go:567:expr0: expr.go:1765:unaryExpression:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20020411-1.c`:         {}, // COMPILE FAIL: "\"TODO UnaryExpressionReal (expr.go:101:expr: expr.go:531:expr0: expr.go:3899:assignmentExpression: expr.go:101:expr: expr.go:567:expr0: expr.go:1765:unaryExpression:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20020412-1.c`:         {}, // COMPILE FAIL: "\"20020412-1.c:31:7: invalid type size: -1 (expr.go:4305:primaryExpression: expr.go:567:expr0: expr.go:1634:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:478:isValidType1:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20030330-1.c`:         {}, // COMPILE FAIL: "20030330-1.o.go:1002:4: undefined: \"link_error\" external (all_test.go:465:1: all_test.go:561:testExec1: ccgo.go:203:Main: ccgo.go:673:main: link.go:312:link: link.go:880:link:) (all_test.go:465:1: all..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20030501-1.c`:         {}, // COMPILE FAIL: "\"gcc.c-torture/execute/20030501-1.c:7:9: nested functions not supported (decl.go:459:functionDefinition0: stmt.go:340:compoundStatement: stmt.go:376:blockItem: stmt.go:26:statement: stmt.go:901:unbrac..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20030910-1.c`:         {}, // COMPILE FAIL: "\"TODO UnaryExpressionReal (expr.go:1605:unaryExpression: expr.go:101:expr: expr.go:561:expr0: expr.go:4305:primaryExpression: expr.go:567:expr0: expr.go:1765:unaryExpression:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20040302-1.c`:         {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1700:goexit: compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:389:functionDefinition0: decl.go:107:newFnCtx:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20040423-1.c`:         {}, // COMPILE FAIL: "\"20040423-1.c:13:22: incomplete type: array of int (expr.go:101:expr: expr.go:567:expr0: expr.go:1730:unaryExpression: type.go:395:isValidType: type.go:407:isValidType: type.go:471:isValidType1:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20040520-1.c`:         {}, // COMPILE FAIL: "\"gcc.c-torture/execute/20040520-1.c:6:13: nested functions not supported (compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:459:functionDefinition0: stmt..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20041124-1.c`:         {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex unsigned short _Complex unsigned short (decl.go:299:externalDeclaration: decl.go:976:declaration: type.go:559:defineStructType: type.go:494:structLiteral: type.go:263..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20041201-1.c`:         {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex char _Complex char (decl.go:299:externalDeclaration: decl.go:986:declaration: decl.go:1151:initDeclarator: type.go:18:typedef: type.go:263:typ0: type.go:159:typ0:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20041214-1.c`:         {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1700:goexit: compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:389:functionDefinition0: decl.go:107:newFnCtx:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20041218-2.c`:         {}, // COMPILE FAIL: "\"20041218-2.c:7:17: incomplete type: array of char (expr.go:101:expr: expr.go:567:expr0: expr.go:1730:unaryExpression: type.go:395:isValidType: type.go:407:isValidType: type.go:471:isValidType1:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20050121-1.c`:         {}, // COMPILE FAIL: "\"TODO UnaryExpressionReal (expr.go:101:expr: expr.go:531:expr0: expr.go:3899:assignmentExpression: expr.go:101:expr: expr.go:567:expr0: expr.go:1765:unaryExpression:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20050316-1.c`:         {}, // COMPILE FAIL: "\"20050316-1.c:15:29: unsupported vector type: V2SI (expr.go:561:expr0: expr.go:4286:primaryExpression: expr.go:4739:primaryExpressionIntConst: type.go:30:helper: type.go:65:typ0: type.go:440:isValidTy..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20050316-2.c`:         {}, // COMPILE FAIL: "\"20050316-2.c:38:14: unsupported vector type: V2SF (expr.go:561:expr0: expr.go:4288:primaryExpression: expr.go:4760:primaryExpressionFloatConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isVa..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20050316-3.c`:         {}, // COMPILE FAIL: "\"20050316-3.c:29:3: unsupported vector type: V2USI (expr.go:559:expr0: expr.go:2122:postfixExpression: expr.go:2974:postfixExpressionSelect: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20050604-1.c`:         {}, // COMPILE FAIL: "\"20050604-1.c:16:3: unsupported vector type: v4hi (decl.go:986:declaration: decl.go:1181:initDeclarator: type.go:42:typ: type.go:323:typ0: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20050607-1.c`:         {}, // COMPILE FAIL: "\"20050607-1.c:12:32: unsupported vector type: V2SI (expr.go:561:expr0: expr.go:4286:primaryExpression: expr.go:4722:primaryExpressionIntConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isVali..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20060420-1.c`:         {}, // COMPILE FAIL: "\"20060420-1.c:8:19: unsupported vector type: v4flt (expr.go:1240:checkVolatileExpr: expr.go:101:expr: expr.go:567:expr0: expr.go:1730:unaryExpression: type.go:407:isValidType: type.go:440:isValidType1..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20070919-1.c`:         {}, // COMPILE FAIL: "\"20070919-1.c:31:7: invalid type size: -1 (expr.go:561:expr0: expr.go:4318:primaryExpression: decl.go:177:newAutovar: type.go:42:typ: type.go:65:typ0: type.go:478:isValidType1:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20071210-1.c`:         {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1700:goexit: compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:389:functionDefinition0: decl.go:107:newFnCtx:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20090219-1.c`:         {}, // COMPILE FAIL: "\"gcc.c-torture/execute/20090219-1.c:12:8: nested functions not supported (compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:459:functionDefinition0: stmt..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/920302-1.c`:           {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1700:goexit: compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:389:functionDefinition0: decl.go:107:newFnCtx:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/920415-1.c`:           {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1700:goexit: compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:389:functionDefinition0: decl.go:107:newFnCtx:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/920428-2.c`:           {}, // COMPILE FAIL: "\"gcc.c-torture/execute/920428-2.c:4:14: label declarations not supported (stmt.go:376:blockItem: stmt.go:42:statement: stmt.go:412:selectionStatement: stmt.go:892:bracedStatement: stmt.go:901:unbraced..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/920501-3.c`:           {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1700:goexit: compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:389:functionDefinition0: decl.go:107:newFnCtx:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/920501-4.c`:           {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1700:goexit: compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:389:functionDefinition0: decl.go:107:newFnCtx:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/920501-5.c`:           {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1700:goexit: compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:389:functionDefinition0: decl.go:107:newFnCtx:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/920501-7.c`:           {}, // COMPILE FAIL: "\"gcc.c-torture/execute/920501-7.c:13:3: label declarations not supported (compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:403:functionDefinition0: stmt..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/920612-2.c`:           {}, // COMPILE FAIL: "\"gcc.c-torture/execute/920612-2.c:6:7: nested functions not supported (compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:459:functionDefinition0: stmt.go..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/920721-4.c`:           {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1700:goexit: compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:389:functionDefinition0: decl.go:107:newFnCtx:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/921017-1.c`:           {}, // COMPILE FAIL: "\"gcc.c-torture/execute/921017-1.c:7:7: nested functions not supported (compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:459:functionDefinition0: stmt.go..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/921215-1.c`:           {}, // COMPILE FAIL: "\"gcc.c-torture/execute/921215-1.c:5:8: nested functions not supported (compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:459:functionDefinition0: stmt.go..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/930406-1.c`:           {}, // COMPILE FAIL: "\"TODO *cc.LabelDeclaration (asm_amd64.s:1700:goexit: compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:389:functionDefinition0: decl.go:107:newFnCtx:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/931002-1.c`:           {}, // COMPILE FAIL: "\"gcc.c-torture/execute/931002-1.c:10:8: nested functions not supported (compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:459:functionDefinition0: stmt.g..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/960416-1.c`:           {}, // COMPILE FAIL: "\"gcc.c-torture/execute/960416-1.c:57:23: helper: unsupported type: t_be (expr.go:1137:castExpression: expr.go:101:expr: expr.go:561:expr0: expr.go:4286:primaryExpression: expr.go:4739:primaryExpressio..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/970217-1.c`:           {}, // COMPILE FAIL: "\"970217-1.c:1:1: incomplete type: array of int (decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:383:functionDefinition0: type.go:459:isValidType1: type.go:383:isValidParamType..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/980526-1.c`:           {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1700:goexit: compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:389:functionDefinition0: decl.go:107:newFnCtx:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/980929-1.c`:           {}, // COMPILE FAIL: "\"TODO gcc.c-torture/execute/980929-1.c:17:5: from pointer to int, exprUintptr to pointer to int exprVoid, src '&n', buf 'ppuintptr(iqunsafe.ppPointer(&(aan)))' (stmt.go:376:blockItem: stmt.go:38:state..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/990208-1.c`:           {}, // COMPILE FAIL: "\"TODO UnaryExpressionLabelAddr (expr.go:101:expr: expr.go:531:expr0: expr.go:3904:assignmentExpression: expr.go:101:expr: expr.go:567:expr0: expr.go:1739:unaryExpression:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/builtin-prefetch-3.c`: {}, // COMPILE FAIL: "\"TODO exprUintptr (expr.go:567:expr0: expr.go:1605:unaryExpression: expr.go:101:expr: expr.go:559:expr0: expr.go:2122:postfixExpression: expr.go:3053:postfixExpressionSelect:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/comp-goto-1.c`:        {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1700:goexit: compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:389:functionDefinition0: decl.go:107:newFnCtx:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/comp-goto-2.c`:        {}, // COMPILE FAIL: "\"gcc.c-torture/execute/comp-goto-2.c:15:3: label declarations not supported (compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:403:functionDefinition0: s..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/complex-1.c`:          {}, // COMPILE FAIL: "\"TODO UnaryExpressionReal (expr.go:2119:postfixExpression: expr.go:3600:postfixExpressionCall: expr.go:70:topExpr: expr.go:101:expr: expr.go:567:expr0: expr.go:1765:unaryExpression:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/complex-6.c`:          {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex int _Complex int (decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:436:functionDefinition0: decl.go:929:signature: type.go:48:typ2: type.go:15..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/complex-7.c`:          {}, // COMPILE FAIL: "\"TODO 2.2iL *cc.ComplexLongDoubleValue from=_Complex long t=long double mode=exprDefault (expr.go:1235:binopArgs: expr.go:1240:checkVolatileExpr: expr.go:101:expr: expr.go:561:expr0: expr.go:4288:prim..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/pr72824-2.c`:     {}, // COMPILE FAIL: "\"pr72824-2.c:17:17: unsupported vector type: V (expr.go:561:expr0: expr.go:4288:primaryExpression: expr.go:4770:primaryExpressionFloatConst: type.go:30:helper: type.go:65:typ0: type.go:440:isValidType..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/medce-1.c`:            {}, // COMPILE FAIL: "medce-1.o.go:1024:2: undefined: \"link_error\" external (all_test.go:465:1: all_test.go:561:testExec1: ccgo.go:203:Main: ccgo.go:673:main: link.go:312:link: link.go:880:link:) (all_test.go:465:1: all_te..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/nest-align-1.c`:       {}, // COMPILE FAIL: "\"gcc.c-torture/execute/nest-align-1.c:25:8: nested functions not supported (compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:459:functionDefinition0: st..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/nest-stdar-1.c`:       {}, // COMPILE FAIL: "\"gcc.c-torture/execute/nest-stdar-1.c:5:10: nested functions not supported (compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:459:functionDefinition0: st..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/nestfunc-1.c`:         {}, // COMPILE FAIL: "\"gcc.c-torture/execute/nestfunc-1.c:15:7: nested functions not supported (compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:459:functionDefinition0: stmt..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/nestfunc-2.c`:         {}, // COMPILE FAIL: "\"gcc.c-torture/execute/nestfunc-2.c:13:7: nested functions not supported (compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:459:functionDefinition0: stmt..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/nestfunc-3.c`:         {}, // COMPILE FAIL: "\"gcc.c-torture/execute/nestfunc-3.c:12:8: nested functions not supported (compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:459:functionDefinition0: stmt..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/nestfunc-5.c`:         {}, // COMPILE FAIL: "\"gcc.c-torture/execute/nestfunc-5.c:8:3: label declarations not supported (compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:403:functionDefinition0: stm..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/nestfunc-6.c`:         {}, // COMPILE FAIL: "\"gcc.c-torture/execute/nestfunc-6.c:13:3: label declarations not supported (compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:403:functionDefinition0: st..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/nestfunc-7.c`:         {}, // COMPILE FAIL: "\"gcc.c-torture/execute/nestfunc-7.c:15:12: nested functions not supported (compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:459:functionDefinition0: stm..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr22061-1.c`:          {}, // COMPILE FAIL: "\"pr22061-1.c:4:6: incomplete type: array of array of char (decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:383:functionDefinition0: type.go:459:isValidType1: type.go:383:isVal..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr22061-2.c`:          {}, // COMPILE FAIL: "\"pr22061-2.c:2:13: incomplete type: array of array of char (decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:383:functionDefinition0: type.go:459:isValidType1: type.go:383:isVa..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr22061-3.c`:          {}, // COMPILE FAIL: "\"gcc.c-torture/execute/pr22061-3.c:4:7: nested functions not supported (compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:459:functionDefinition0: stmt.g..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr22061-4.c`:          {}, // COMPILE FAIL: "\"gcc.c-torture/execute/pr22061-4.c:5:8: nested functions not supported (compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:459:functionDefinition0: stmt.g..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr23135.c`:            {}, // COMPILE FAIL: "\"pr23135.c:19:14: unsupported vector type: vecint (expr.go:561:expr0: expr.go:4286:primaryExpression: expr.go:4722:primaryExpressionIntConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isValid..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr23324.c`:            {}, // COMPILE FAIL: "\"TODO (decl.go:1243:initDeclaratorInit: type.go:642:defineType: type.go:656:defineType0: type.go:578:defineUnionType: type.go:488:unionLiteral: type.go:315:typ0:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr24135.c`:            {}, // COMPILE FAIL: "\"gcc.c-torture/execute/pr24135.c:7:3: label declarations not supported (compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:403:functionDefinition0: stmt.g..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr34154.c`:            {}, // COMPILE FAIL: "\"TODO SelectionStatementSwitch (decl.go:403:functionDefinition0: stmt.go:340:compoundStatement: stmt.go:376:blockItem: stmt.go:42:statement: stmt.go:464:selectionStatement: stmt.go:868:selectionStatem..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr38151.c`:            {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex int _Complex int (decl.go:299:externalDeclaration: decl.go:976:declaration: type.go:559:defineStructType: type.go:494:structLiteral: type.go:263:typ0: type.go:159:typ..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr38969.c`:            {}, // COMPILE FAIL: "\"TODO UnaryExpressionReal (expr.go:101:expr: expr.go:531:expr0: expr.go:3899:assignmentExpression: expr.go:101:expr: expr.go:567:expr0: expr.go:1765:unaryExpression:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr41935.c`:            {}, // COMPILE FAIL: "\"pr41935.c:10:10: TODO (expr.go:1953:postfixExpressionIndex: expr.go:101:expr: expr.go:559:expr0: expr.go:2004:postfixExpression: expr.go:1837:postfixExpressionIndex: expr.go:1787:mul:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr49218.c`:            {}, // COMPILE FAIL: "\"pr49218.c:11:9: TODO \\\"(Xf)\\\" from=float float 4 exprDefault -> to=L __int128 16 exprDefault (gcc.c-torture/execute/pr49218.c:11:9:) (init.go:30:initializerOuter: init.go:82:initializer: expr.go:70:t..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr51447.c`:            {}, // COMPILE FAIL: "\"gcc.c-torture/execute/pr51447.c:16:3: label declarations not supported (compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:403:functionDefinition0: stmt...."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr53645-2.c`:          {}, // COMPILE FAIL: "\"pr53645-2.c:41:1: unsupported vector type: UV (expr.go:101:expr: expr.go:567:expr0: expr.go:1653:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr53645.c`:            {}, // COMPILE FAIL: "\"pr53645.c:41:1: unsupported vector type: UV (expr.go:101:expr: expr.go:567:expr0: expr.go:1653:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr54471.c`:            {}, // COMPILE FAIL: "\"pr54471.c:20:16: TODO \\\"(aaix)\\\" from=__int128 __int128 16 exprDefault -> to=unsigned __int128 unsigned __int128 16 exprDefault (gcc.c-torture/execute/pr54471.c:20:16:) (expr.go:531:expr0: expr.go:40..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr56837.c`:            {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex int _Complex int (decl.go:299:externalDeclaration: decl.go:986:declaration: decl.go:1181:initDeclarator: type.go:42:typ: type.go:337:typ0: type.go:159:typ0:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr60960.c`:            {}, // COMPILE FAIL: "\"pr60960.c:26:14: unsupported vector type: v4qi (expr.go:561:expr0: expr.go:4286:primaryExpression: expr.go:4728:primaryExpressionIntConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isValidTy..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr61375.c`:            {}, // COMPILE FAIL: "\"pr61375.c:18:18: TODO \\\"(aamask)\\\" from=__int128 __int128 16 exprDefault -> to=unsigned __int128 unsigned __int128 16 exprDefault (gcc.c-torture/execute/pr61375.c:18:18:) (expr.go:586:andExpression: ..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr63302.c`:            {}, // COMPILE FAIL: "\"pr63302.c:16:33: TODO \\\"(-((iqlibc.ppInt32FromInt32(1))))\\\" from=int int 4 exprDefault -> to=__int128 __int128 16 exprDefault (gcc.c-torture/execute/pr63302.c:16:33:) (expr.go:101:expr: expr.go:533:e..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr65170.c`:            {}, // COMPILE FAIL: "\"pr65170.c:15:8: TODO \\\"(iqlibc.ppUint64FromInt32((-((iqlibc.ppInt32FromInt32(1))))))\\\" from=H unsigned long long 8 exprDefault -> to=unsigned __int128 unsigned __int128 16 exprDefault (gcc.c-torture/..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr65427.c`:            {}, // COMPILE FAIL: "\"pr65427.c:4:3: unsupported vector type: V (decl.go:299:externalDeclaration: decl.go:986:declaration: decl.go:1181:initDeclarator: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr68249.c`:            {}, // COMPILE FAIL: "\"-: TODO (expr.go:3904:assignmentExpression: expr.go:101:expr: expr.go:543:expr0: expr.go:955:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr68381.c`:            {}, // COMPILE FAIL: "\"TODO unsigned short * unsigned short -> int (stmt.go:42:statement: stmt.go:411:selectionStatement: expr.go:101:expr: expr.go:559:expr0: expr.go:2062:postfixExpression: expr.go:2356:mulOverflow:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr70460.c`:            {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1700:goexit: compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:389:functionDefinition0: decl.go:107:newFnCtx:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr70903.c`:            {}, // COMPILE FAIL: "\"TODO (expr.go:3600:postfixExpressionCall: expr.go:70:topExpr: expr.go:101:expr: expr.go:559:expr0: expr.go:2317:postfixExpression: init.go:51:initializer:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr71494.c`:            {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1700:goexit: compile.go:478:compile: decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:389:functionDefinition0: decl.go:107:newFnCtx:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr71554.c`:            {}, // COMPILE FAIL: "\"TODO unsigned * int -> int (stmt.go:42:statement: stmt.go:411:selectionStatement: expr.go:101:expr: expr.go:559:expr0: expr.go:2062:postfixExpression: expr.go:2356:mulOverflow:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr71626-1.c`:          {}, // COMPILE FAIL: "\"TODO PostfixExpressionIndex (expr.go:1311:equalityExpression: expr.go:1235:binopArgs: expr.go:1240:checkVolatileExpr: expr.go:101:expr: expr.go:559:expr0: expr.go:2011:postfixExpression:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr71626-2.c`:          {}, // COMPILE FAIL: "\"TODO PostfixExpressionIndex (expr.go:1311:equalityExpression: expr.go:1235:binopArgs: expr.go:1240:checkVolatileExpr: expr.go:101:expr: expr.go:559:expr0: expr.go:2011:postfixExpression:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr77767.c`:            {}, // COMPILE FAIL: "\"pr77767.c:4:1: incomplete type: array of int (decl.go:297:externalDeclaration: decl.go:363:functionDefinition: decl.go:383:functionDefinition0: type.go:459:isValidType1: type.go:383:isValidParamType:..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr80692.c`:            {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Decimal64 _Decimal64 (expr.go:101:expr: expr.go:561:expr0: expr.go:4288:primaryExpression: expr.go:4750:primaryExpressionFloatConst: type.go:30:helper: type.go:159:typ0:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr84169.c`:            {}, // COMPILE FAIL: "\"TODO unsigned char * int -> T (stmt.go:38:statement: expr.go:70:topExpr: expr.go:101:expr: expr.go:559:expr0: expr.go:2062:postfixExpression: expr.go:2356:mulOverflow:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr84748.c`:            {}, // COMPILE FAIL: "\"pr84748.c:20:8: TODO \\\"(Xa)\\\" from=int int 4 exprDefault -> to=unsigned __int128 unsigned __int128 16 exprDefault (gcc.c-torture/execute/pr84748.c:20:8:) (expr.go:531:expr0: expr.go:4017:assignmentEx..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr85169.c`:            {}, // COMPILE FAIL: "\"pr85169.c:8:9: unsupported vector type: V (expr.go:101:expr: expr.go:567:expr0: expr.go:1653:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr85331.c`:            {}, // COMPILE FAIL: "\"pr85331.c:10:11: unsupported vector type: V (expr.go:561:expr0: expr.go:4288:primaryExpression: expr.go:4760:primaryExpressionFloatConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isValidTyp..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr85582-2.c`:          {}, // COMPILE FAIL: "\"pr85582-2.c:15:8: TODO \\\"(aay)\\\" from=int int 4 exprDefault -> to=__int128 __int128 16 exprDefault (gcc.c-torture/execute/pr85582-2.c:15:8:) (expr.go:531:expr0: expr.go:4017:assignmentExpression: exp..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr85582-3.c`:          {}, // COMPILE FAIL: "\"pr85582-3.c:35:9: TODO \\\"((iqlibc.pp]ppuint64FromInt32(0x101)) << ((((iqlibc.ppUint64FromInt64(16)) * (iqlibc.ppUint64FromInt32(mv__CHAR_BIT__))) / (iqlibc.ppUint64FromInt32(2))) - (iqlibc.ppUint64Fr..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr88739.c`:            {}, // COMPILE FAIL: "\"TODO exprUintptr (expr.go:2122:postfixExpression: expr.go:2938:postfixExpressionSelect: expr.go:101:expr: expr.go:559:expr0: expr.go:2122:postfixExpression: expr.go:3053:postfixExpressionSelect:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr89434.c`:            {}, // COMPILE FAIL: "\"TODO int * long -> unsigned (stmt.go:38:statement: expr.go:70:topExpr: expr.go:101:expr: expr.go:559:expr0: expr.go:2062:postfixExpression: expr.go:2356:mulOverflow:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr90311.c`:            {}, // COMPILE FAIL: "\"TODO unsigned char + int -> unsigned (stmt.go:38:statement: expr.go:70:topExpr: expr.go:101:expr: expr.go:559:expr0: expr.go:2064:postfixExpression: expr.go:2491:addOverflow:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr91450-1.c`:          {}, // COMPILE FAIL: "\"TODO int * int -> unsigned long long (expr.go:1686:unaryExpression: expr.go:1240:checkVolatileExpr: expr.go:101:expr: expr.go:559:expr0: expr.go:2062:postfixExpression: expr.go:2356:mulOverflow:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr91450-2.c`:          {}, // COMPILE FAIL: "\"TODO int * int -> unsigned long long (stmt.go:42:statement: stmt.go:411:selectionStatement: expr.go:101:expr: expr.go:559:expr0: expr.go:2062:postfixExpression: expr.go:2356:mulOverflow:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr91635.c`:            {}, // COMPILE FAIL: "\"TODO int + int -> unsigned short (expr.go:531:expr0: expr.go:4019:assignmentExpression: expr.go:101:expr: expr.go:559:expr0: expr.go:2064:postfixExpression: expr.go:2491:addOverflow:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr92618.c`:            {}, // COMPILE FAIL: "\"pr92618.c:33:3: unsupported vector type: __m128i (expr.go:101:expr: expr.go:567:expr0: expr.go:1653:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr92904.c`:            {}, // COMPILE FAIL: "\"gcc.c-torture/execute/pr92904.c: gofmt: exit status 2 (.:0:: asm_amd64.s:1700:goexit: asm_amd64.s:1700:goexit: asm_amd64.s:1700:goexit: compile.go:550:compile: compile.go:550:compile:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr93213.c`:            {}, // COMPILE FAIL: "\"pr93213.c:15:13: TODO \\\"X__builtin_mul_overflowUint32(cgtls, (aau32_1), (ppuint32((aau16_1))), ppuintptr(iqunsafe.ppPointer(&(aau32_1))))\\\" from=int int 4 exprDefault -> to=unsigned __int128 unsigned..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr94412.c`:            {}, // COMPILE FAIL: "\"pr94412.c:8:3: unsupported vector type: V (expr.go:101:expr: expr.go:567:expr0: expr.go:1653:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr94524-1.c`:          {}, // COMPILE FAIL: "\"pr94524-1.c:15:20: unsupported vector type: V (expr.go:561:expr0: expr.go:4286:primaryExpression: expr.go:4739:primaryExpressionIntConst: type.go:30:helper: type.go:65:typ0: type.go:440:isValidType1:..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr94524-2.c`:          {}, // COMPILE FAIL: "\"pr94524-2.c:15:20: unsupported vector type: V (expr.go:115:expr: expr.go:169:convert: expr.go:353:convertType: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr94591.c`:            {}, // COMPILE FAIL: "\"pr94591.c:9:3: unsupported vector type: V2SI_d (expr.go:101:expr: expr.go:567:expr0: expr.go:1653:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr98474.c`:            {}, // COMPILE FAIL: "\"pr98474.c:27:13: TODO \\\"((aan) >> (((iqlibc.ppInt32FromInt32(mv__SIZEOF_INT128__)) * (iqlibc.ppInt32FromInt32(mv__CHAR_BIT__))) / (iqlibc.ppInt32FromInt32(2))))\\\" from=T unsigned __int128 16 exprDefa..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/scal-to-vec1.c`:       {}, // COMPILE FAIL: "scal-to-vec1.o.go:993:17: undefined: \"main\" external (all_test.go:465:1: all_test.go:561:testExec1: ccgo.go:203:Main: ccgo.go:673:main: link.go:312:link: link.go:880:link:) (all_test.go:465:1: all_tes..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/scal-to-vec2.c`:       {}, // COMPILE FAIL: "scal-to-vec2.o.go:1023:17: undefined: \"main\" external (all_test.go:465:1: all_test.go:561:testExec1: ccgo.go:203:Main: ccgo.go:673:main: link.go:312:link: link.go:880:link:) (all_test.go:465:1: all_te..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/scal-to-vec3.c`:       {}, // COMPILE FAIL: "scal-to-vec3.o.go:987:17: undefined: \"main\" external (all_test.go:465:1: all_test.go:561:testExec1: ccgo.go:203:Main: ccgo.go:673:main: link.go:312:link: link.go:880:link:) (all_test.go:465:1: all_tes..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/simd-1.c`:             {}, // COMPILE FAIL: "\"simd-1.c:10:14: unsupported vector type: vecint (expr.go:561:expr0: expr.go:4286:primaryExpression: expr.go:4739:primaryExpressionIntConst: type.go:30:helper: type.go:65:typ0: type.go:440:isValidType..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/simd-2.c`:             {}, // COMPILE FAIL: "\"simd-2.c:8:14: unsupported vector type: vecint (expr.go:561:expr0: expr.go:4286:primaryExpression: expr.go:4739:primaryExpressionIntConst: type.go:30:helper: type.go:65:typ0: type.go:440:isValidType1..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/simd-4.c`:             {}, // COMPILE FAIL: "\"simd-4.c:17:34: unsupported vector type: v2si (expr.go:561:expr0: expr.go:4286:primaryExpression: expr.go:4722:primaryExpressionIntConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isValidTyp..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/simd-5.c`:             {}, // COMPILE FAIL: "\"simd-5.c:5:9: unsupported vector type: Q (expr.go:561:expr0: expr.go:4286:primaryExpression: expr.go:4722:primaryExpressionIntConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/simd-6.c`:             {}, // COMPILE FAIL: "\"simd-6.c:13:14: unsupported vector type: v8qi (expr.go:561:expr0: expr.go:4286:primaryExpression: expr.go:4728:primaryExpressionIntConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isValidTyp..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/zero-struct-2.c`:      {}, // COMPILE FAIL: "\"zero-struct-2.c:15:48: TODO \\\"Xone_raw_spinlock(cgtls)\\\" from=raw_spinlock_t struct 0 exprDefault -> to=spinlock_t struct 0 exprDefault (gcc.c-torture/execute/zero-struct-2.c:15:48:) (expr.go:559:exp..."
	`assets/github.com/vnmakarov/mir/c-tests/lacc/function-incomplete.c`:                        {}, // COMPILE FAIL: "\"mir/c-tests/lacc/function-incomplete.c:6:9: too few arguments to function 'foo', type 'function(pointer to char) returning int' in 'foo()' (expr.go:1235:binopArgs: expr.go:1240:checkVolatileExpr: exp..."
	`assets/github.com/vnmakarov/mir/c-tests/lacc/identifier.c`:                                 {}, // COMPILE FAIL: "invalid object file: multiple defintions of c (all_test.go:465:1: all_test.go:561:testExec1: ccgo.go:203:Main: ccgo.go:673:main: link.go:270:link: link.go:550:getFileSymbols:)"
	`assets/github.com/vnmakarov/mir/c-tests/lacc/initialize-call.c`:                            {}, // COMPILE FAIL: "\"initialize-call.c:25:9: TODO \\\"sigetobj(cgtls, (ppint32(2)), (ppint32(8)), (ppint32(1)))\\\" from=struct obj {s array of 3 short} struct 6 exprDefault -> to=struct {t struct obj} struct 6 exprDefault (..."
	`assets/github.com/vnmakarov/mir/c-tests/lacc/initialize-string.c`:                          {}, // COMPILE FAIL: "\"initialize-string.c:14:14: TODO \\\"\\\\\\\"wat\\\\\\\\x00\\\\\\\"\\\" from=pointer to char pointer 8 exprDefault -> to=array of 7 char array 7 exprDefault (mir/c-tests/lacc/initialize-string.c:14:14:) (decl.go:1321..."
	`assets/github.com/vnmakarov/mir/c-tests/lacc/string-addr.c`:                                {}, // COMPILE FAIL: "\"string-addr.c:4:16: TODO array of 6 char pointer to array of 6 char pointer to array of 6 char \\\"Hello\\\\x00\\\" (expr.go:567:expr0: expr.go:1605:unaryExpression: expr.go:101:expr: expr.go:561:expr0: ex..."
	`assets/github.com/vnmakarov/mir/c-tests/lacc/stringify.c`:                                  {}, // COMPILE FAIL: "\"TODO `'\\\\xA'` -> invalid syntax (expr.go:4017:assignmentExpression: expr.go:70:topExpr: expr.go:101:expr: expr.go:561:expr0: expr.go:4290:primaryExpression: expr.go:4568:primaryExpressionCharConst:)\""
	`assets/tcc-0.9.27/tests/tests2/76_dollars_in_identifiers.c`:                                {}, // COMPILE FAIL: "\"76_dollars_in_identifiers.c: gofmt: exit status 2 (.:0:: asm_amd64.s:1700:goexit: asm_amd64.s:1700:goexit: asm_amd64.s:1700:goexit: compile.go:550:compile: compile.go:550:compile:)\""
	`assets/tcc-0.9.27/tests/tests2/85_asm-outside-function.c`:                                  {}, // COMPILE FAIL: "85_asm-outside-function.o.go:992:2: undefined: \"vide\" external (all_test.go:465:1: all_test.go:561:testExec1: ccgo.go:203:Main: ccgo.go:673:main: link.go:312:link: link.go:880:link:) (all_test.go:465:..."
	`assets/tcc-0.9.27/tests/tests2/87_dead_code.c`:                                             {}, // COMPILE FAIL: "\"87_dead_code.c: gofmt: exit status 2 (.:0:: asm_amd64.s:1700:goexit: asm_amd64.s:1700:goexit: asm_amd64.s:1700:goexit: compile.go:550:compile: compile.go:550:compile:)\""
	`assets/tcc-0.9.27/tests/tests2/98_al_ax_extend.c`:                                          {}, // COMPILE FAIL: "98_al_ax_extend.o.go:1177:23: undefined: \"_us\" external (all_test.go:465:1: all_test.go:561:testExec1: ccgo.go:203:Main: ccgo.go:673:main: link.go:312:link: link.go:880:link:)"
}
