/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.dex.writer.item;

import com.googlecode.d2j.dex.writer.io.DataOut;
import com.googlecode.d2j.dex.writer.item.BaseItem;
import java.io.ByteArrayOutputStream;

public class StringDataItem
extends BaseItem
implements Comparable<StringDataItem> {
    public final String string;

    public static void encode(ByteArrayOutputStream out, String s) {
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            char ch = s.charAt(i);
            if (ch != '\u0000' && ch <= '\u007f') {
                out.write(ch);
                continue;
            }
            if (ch <= '\u07ff') {
                out.write(0xC0 | 0x1F & ch >> 6);
                out.write(0x80 | 0x3F & ch);
                continue;
            }
            out.write(0xE0 | 0xF & ch >> 12);
            out.write(0x80 | 0x3F & ch >> 6);
            out.write(0x80 | 0x3F & ch);
        }
    }

    public static int lengthOfMutf8(String s) {
        int result = 0;
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            char ch = s.charAt(i);
            if (ch != '\u0000' && ch <= '\u007f') {
                ++result;
                continue;
            }
            if (ch <= '\u07ff') {
                result += 2;
                continue;
            }
            result += 3;
        }
        return result;
    }

    public StringDataItem(String data) {
        this.string = data;
    }

    @Override
    public int compareTo(StringDataItem o) {
        return this.string.compareTo(o.string);
    }

    @Override
    public int place(int offset) {
        int length = StringDataItem.lengthOfMutf8(this.string);
        return offset + StringDataItem.lengthOfUleb128(this.string.length()) + length + 1;
    }

    public String toString() {
        return "StringDataItem [string=" + this.string + "]";
    }

    @Override
    public void write(DataOut out) {
        this.write(out, new Buffer());
    }

    public void write(DataOut out, Buffer buff) {
        out.uleb128("string_data_length", this.string.length());
        StringDataItem.encode(buff, this.string);
        buff.write(0);
        out.bytes("mutf8-string", buff.getBuf(), 0, buff.size());
    }

    public static class Buffer
    extends ByteArrayOutputStream {
        public byte[] getBuf() {
            return this.buf;
        }
    }
}

