// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/dialogflow/cx/v3beta1/webhook.proto

package cxpb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	Webhooks_ListWebhooks_FullMethodName  = "/google.cloud.dialogflow.cx.v3beta1.Webhooks/ListWebhooks"
	Webhooks_GetWebhook_FullMethodName    = "/google.cloud.dialogflow.cx.v3beta1.Webhooks/GetWebhook"
	Webhooks_CreateWebhook_FullMethodName = "/google.cloud.dialogflow.cx.v3beta1.Webhooks/CreateWebhook"
	Webhooks_UpdateWebhook_FullMethodName = "/google.cloud.dialogflow.cx.v3beta1.Webhooks/UpdateWebhook"
	Webhooks_DeleteWebhook_FullMethodName = "/google.cloud.dialogflow.cx.v3beta1.Webhooks/DeleteWebhook"
)

// WebhooksClient is the client API for Webhooks service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type WebhooksClient interface {
	// Returns the list of all webhooks in the specified agent.
	ListWebhooks(ctx context.Context, in *ListWebhooksRequest, opts ...grpc.CallOption) (*ListWebhooksResponse, error)
	// Retrieves the specified webhook.
	GetWebhook(ctx context.Context, in *GetWebhookRequest, opts ...grpc.CallOption) (*Webhook, error)
	// Creates a webhook in the specified agent.
	CreateWebhook(ctx context.Context, in *CreateWebhookRequest, opts ...grpc.CallOption) (*Webhook, error)
	// Updates the specified webhook.
	UpdateWebhook(ctx context.Context, in *UpdateWebhookRequest, opts ...grpc.CallOption) (*Webhook, error)
	// Deletes the specified webhook.
	DeleteWebhook(ctx context.Context, in *DeleteWebhookRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type webhooksClient struct {
	cc grpc.ClientConnInterface
}

func NewWebhooksClient(cc grpc.ClientConnInterface) WebhooksClient {
	return &webhooksClient{cc}
}

func (c *webhooksClient) ListWebhooks(ctx context.Context, in *ListWebhooksRequest, opts ...grpc.CallOption) (*ListWebhooksResponse, error) {
	out := new(ListWebhooksResponse)
	err := c.cc.Invoke(ctx, Webhooks_ListWebhooks_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *webhooksClient) GetWebhook(ctx context.Context, in *GetWebhookRequest, opts ...grpc.CallOption) (*Webhook, error) {
	out := new(Webhook)
	err := c.cc.Invoke(ctx, Webhooks_GetWebhook_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *webhooksClient) CreateWebhook(ctx context.Context, in *CreateWebhookRequest, opts ...grpc.CallOption) (*Webhook, error) {
	out := new(Webhook)
	err := c.cc.Invoke(ctx, Webhooks_CreateWebhook_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *webhooksClient) UpdateWebhook(ctx context.Context, in *UpdateWebhookRequest, opts ...grpc.CallOption) (*Webhook, error) {
	out := new(Webhook)
	err := c.cc.Invoke(ctx, Webhooks_UpdateWebhook_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *webhooksClient) DeleteWebhook(ctx context.Context, in *DeleteWebhookRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Webhooks_DeleteWebhook_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// WebhooksServer is the server API for Webhooks service.
// All implementations should embed UnimplementedWebhooksServer
// for forward compatibility
type WebhooksServer interface {
	// Returns the list of all webhooks in the specified agent.
	ListWebhooks(context.Context, *ListWebhooksRequest) (*ListWebhooksResponse, error)
	// Retrieves the specified webhook.
	GetWebhook(context.Context, *GetWebhookRequest) (*Webhook, error)
	// Creates a webhook in the specified agent.
	CreateWebhook(context.Context, *CreateWebhookRequest) (*Webhook, error)
	// Updates the specified webhook.
	UpdateWebhook(context.Context, *UpdateWebhookRequest) (*Webhook, error)
	// Deletes the specified webhook.
	DeleteWebhook(context.Context, *DeleteWebhookRequest) (*emptypb.Empty, error)
}

// UnimplementedWebhooksServer should be embedded to have forward compatible implementations.
type UnimplementedWebhooksServer struct {
}

func (UnimplementedWebhooksServer) ListWebhooks(context.Context, *ListWebhooksRequest) (*ListWebhooksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListWebhooks not implemented")
}
func (UnimplementedWebhooksServer) GetWebhook(context.Context, *GetWebhookRequest) (*Webhook, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetWebhook not implemented")
}
func (UnimplementedWebhooksServer) CreateWebhook(context.Context, *CreateWebhookRequest) (*Webhook, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateWebhook not implemented")
}
func (UnimplementedWebhooksServer) UpdateWebhook(context.Context, *UpdateWebhookRequest) (*Webhook, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateWebhook not implemented")
}
func (UnimplementedWebhooksServer) DeleteWebhook(context.Context, *DeleteWebhookRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteWebhook not implemented")
}

// UnsafeWebhooksServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to WebhooksServer will
// result in compilation errors.
type UnsafeWebhooksServer interface {
	mustEmbedUnimplementedWebhooksServer()
}

func RegisterWebhooksServer(s grpc.ServiceRegistrar, srv WebhooksServer) {
	s.RegisterService(&Webhooks_ServiceDesc, srv)
}

func _Webhooks_ListWebhooks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListWebhooksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WebhooksServer).ListWebhooks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Webhooks_ListWebhooks_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WebhooksServer).ListWebhooks(ctx, req.(*ListWebhooksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Webhooks_GetWebhook_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetWebhookRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WebhooksServer).GetWebhook(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Webhooks_GetWebhook_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WebhooksServer).GetWebhook(ctx, req.(*GetWebhookRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Webhooks_CreateWebhook_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateWebhookRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WebhooksServer).CreateWebhook(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Webhooks_CreateWebhook_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WebhooksServer).CreateWebhook(ctx, req.(*CreateWebhookRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Webhooks_UpdateWebhook_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateWebhookRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WebhooksServer).UpdateWebhook(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Webhooks_UpdateWebhook_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WebhooksServer).UpdateWebhook(ctx, req.(*UpdateWebhookRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Webhooks_DeleteWebhook_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteWebhookRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WebhooksServer).DeleteWebhook(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Webhooks_DeleteWebhook_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WebhooksServer).DeleteWebhook(ctx, req.(*DeleteWebhookRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Webhooks_ServiceDesc is the grpc.ServiceDesc for Webhooks service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Webhooks_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.cx.v3beta1.Webhooks",
	HandlerType: (*WebhooksServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListWebhooks",
			Handler:    _Webhooks_ListWebhooks_Handler,
		},
		{
			MethodName: "GetWebhook",
			Handler:    _Webhooks_GetWebhook_Handler,
		},
		{
			MethodName: "CreateWebhook",
			Handler:    _Webhooks_CreateWebhook_Handler,
		},
		{
			MethodName: "UpdateWebhook",
			Handler:    _Webhooks_UpdateWebhook_Handler,
		},
		{
			MethodName: "DeleteWebhook",
			Handler:    _Webhooks_DeleteWebhook_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dialogflow/cx/v3beta1/webhook.proto",
}
