// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/dialogflow/v2/document.proto

package dialogflowpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	Documents_ListDocuments_FullMethodName   = "/google.cloud.dialogflow.v2.Documents/ListDocuments"
	Documents_GetDocument_FullMethodName     = "/google.cloud.dialogflow.v2.Documents/GetDocument"
	Documents_CreateDocument_FullMethodName  = "/google.cloud.dialogflow.v2.Documents/CreateDocument"
	Documents_ImportDocuments_FullMethodName = "/google.cloud.dialogflow.v2.Documents/ImportDocuments"
	Documents_DeleteDocument_FullMethodName  = "/google.cloud.dialogflow.v2.Documents/DeleteDocument"
	Documents_UpdateDocument_FullMethodName  = "/google.cloud.dialogflow.v2.Documents/UpdateDocument"
	Documents_ReloadDocument_FullMethodName  = "/google.cloud.dialogflow.v2.Documents/ReloadDocument"
	Documents_ExportDocument_FullMethodName  = "/google.cloud.dialogflow.v2.Documents/ExportDocument"
)

// DocumentsClient is the client API for Documents service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type DocumentsClient interface {
	// Returns the list of all documents of the knowledge base.
	ListDocuments(ctx context.Context, in *ListDocumentsRequest, opts ...grpc.CallOption) (*ListDocumentsResponse, error)
	// Retrieves the specified document.
	GetDocument(ctx context.Context, in *GetDocumentRequest, opts ...grpc.CallOption) (*Document, error)
	// Creates a new document.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [KnowledgeOperationMetadata][google.cloud.dialogflow.v2.KnowledgeOperationMetadata]
	// - `response`: [Document][google.cloud.dialogflow.v2.Document]
	CreateDocument(ctx context.Context, in *CreateDocumentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates documents by importing data from external sources.
	// Dialogflow supports up to 350 documents in each request. If you try to
	// import more, Dialogflow will return an error.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [KnowledgeOperationMetadata][google.cloud.dialogflow.v2.KnowledgeOperationMetadata]
	// - `response`:
	// [ImportDocumentsResponse][google.cloud.dialogflow.v2.ImportDocumentsResponse]
	ImportDocuments(ctx context.Context, in *ImportDocumentsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes the specified document.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [KnowledgeOperationMetadata][google.cloud.dialogflow.v2.KnowledgeOperationMetadata]
	//   - `response`: An [Empty
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
	DeleteDocument(ctx context.Context, in *DeleteDocumentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the specified document.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [KnowledgeOperationMetadata][google.cloud.dialogflow.v2.KnowledgeOperationMetadata]
	// - `response`: [Document][google.cloud.dialogflow.v2.Document]
	UpdateDocument(ctx context.Context, in *UpdateDocumentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Reloads the specified document from its specified source, content_uri or
	// content. The previously loaded content of the document will be deleted.
	// Note: Even when the content of the document has not changed, there still
	// may be side effects because of internal implementation changes.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [KnowledgeOperationMetadata][google.cloud.dialogflow.v2.KnowledgeOperationMetadata]
	// - `response`: [Document][google.cloud.dialogflow.v2.Document]
	//
	// Note: The `projects.agent.knowledgeBases.documents` resource is deprecated;
	// only use `projects.knowledgeBases.documents`.
	ReloadDocument(ctx context.Context, in *ReloadDocumentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Exports a smart messaging candidate document into the specified
	// destination.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [KnowledgeOperationMetadata][google.cloud.dialogflow.v2.KnowledgeOperationMetadata]
	// - `response`: [Document][google.cloud.dialogflow.v2.Document]
	ExportDocument(ctx context.Context, in *ExportDocumentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type documentsClient struct {
	cc grpc.ClientConnInterface
}

func NewDocumentsClient(cc grpc.ClientConnInterface) DocumentsClient {
	return &documentsClient{cc}
}

func (c *documentsClient) ListDocuments(ctx context.Context, in *ListDocumentsRequest, opts ...grpc.CallOption) (*ListDocumentsResponse, error) {
	out := new(ListDocumentsResponse)
	err := c.cc.Invoke(ctx, Documents_ListDocuments_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentsClient) GetDocument(ctx context.Context, in *GetDocumentRequest, opts ...grpc.CallOption) (*Document, error) {
	out := new(Document)
	err := c.cc.Invoke(ctx, Documents_GetDocument_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentsClient) CreateDocument(ctx context.Context, in *CreateDocumentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Documents_CreateDocument_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentsClient) ImportDocuments(ctx context.Context, in *ImportDocumentsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Documents_ImportDocuments_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentsClient) DeleteDocument(ctx context.Context, in *DeleteDocumentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Documents_DeleteDocument_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentsClient) UpdateDocument(ctx context.Context, in *UpdateDocumentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Documents_UpdateDocument_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentsClient) ReloadDocument(ctx context.Context, in *ReloadDocumentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Documents_ReloadDocument_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentsClient) ExportDocument(ctx context.Context, in *ExportDocumentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Documents_ExportDocument_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DocumentsServer is the server API for Documents service.
// All implementations should embed UnimplementedDocumentsServer
// for forward compatibility
type DocumentsServer interface {
	// Returns the list of all documents of the knowledge base.
	ListDocuments(context.Context, *ListDocumentsRequest) (*ListDocumentsResponse, error)
	// Retrieves the specified document.
	GetDocument(context.Context, *GetDocumentRequest) (*Document, error)
	// Creates a new document.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [KnowledgeOperationMetadata][google.cloud.dialogflow.v2.KnowledgeOperationMetadata]
	// - `response`: [Document][google.cloud.dialogflow.v2.Document]
	CreateDocument(context.Context, *CreateDocumentRequest) (*longrunningpb.Operation, error)
	// Creates documents by importing data from external sources.
	// Dialogflow supports up to 350 documents in each request. If you try to
	// import more, Dialogflow will return an error.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [KnowledgeOperationMetadata][google.cloud.dialogflow.v2.KnowledgeOperationMetadata]
	// - `response`:
	// [ImportDocumentsResponse][google.cloud.dialogflow.v2.ImportDocumentsResponse]
	ImportDocuments(context.Context, *ImportDocumentsRequest) (*longrunningpb.Operation, error)
	// Deletes the specified document.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [KnowledgeOperationMetadata][google.cloud.dialogflow.v2.KnowledgeOperationMetadata]
	//   - `response`: An [Empty
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
	DeleteDocument(context.Context, *DeleteDocumentRequest) (*longrunningpb.Operation, error)
	// Updates the specified document.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [KnowledgeOperationMetadata][google.cloud.dialogflow.v2.KnowledgeOperationMetadata]
	// - `response`: [Document][google.cloud.dialogflow.v2.Document]
	UpdateDocument(context.Context, *UpdateDocumentRequest) (*longrunningpb.Operation, error)
	// Reloads the specified document from its specified source, content_uri or
	// content. The previously loaded content of the document will be deleted.
	// Note: Even when the content of the document has not changed, there still
	// may be side effects because of internal implementation changes.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [KnowledgeOperationMetadata][google.cloud.dialogflow.v2.KnowledgeOperationMetadata]
	// - `response`: [Document][google.cloud.dialogflow.v2.Document]
	//
	// Note: The `projects.agent.knowledgeBases.documents` resource is deprecated;
	// only use `projects.knowledgeBases.documents`.
	ReloadDocument(context.Context, *ReloadDocumentRequest) (*longrunningpb.Operation, error)
	// Exports a smart messaging candidate document into the specified
	// destination.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [KnowledgeOperationMetadata][google.cloud.dialogflow.v2.KnowledgeOperationMetadata]
	// - `response`: [Document][google.cloud.dialogflow.v2.Document]
	ExportDocument(context.Context, *ExportDocumentRequest) (*longrunningpb.Operation, error)
}

// UnimplementedDocumentsServer should be embedded to have forward compatible implementations.
type UnimplementedDocumentsServer struct {
}

func (UnimplementedDocumentsServer) ListDocuments(context.Context, *ListDocumentsRequest) (*ListDocumentsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDocuments not implemented")
}
func (UnimplementedDocumentsServer) GetDocument(context.Context, *GetDocumentRequest) (*Document, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDocument not implemented")
}
func (UnimplementedDocumentsServer) CreateDocument(context.Context, *CreateDocumentRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDocument not implemented")
}
func (UnimplementedDocumentsServer) ImportDocuments(context.Context, *ImportDocumentsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportDocuments not implemented")
}
func (UnimplementedDocumentsServer) DeleteDocument(context.Context, *DeleteDocumentRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDocument not implemented")
}
func (UnimplementedDocumentsServer) UpdateDocument(context.Context, *UpdateDocumentRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDocument not implemented")
}
func (UnimplementedDocumentsServer) ReloadDocument(context.Context, *ReloadDocumentRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReloadDocument not implemented")
}
func (UnimplementedDocumentsServer) ExportDocument(context.Context, *ExportDocumentRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportDocument not implemented")
}

// UnsafeDocumentsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to DocumentsServer will
// result in compilation errors.
type UnsafeDocumentsServer interface {
	mustEmbedUnimplementedDocumentsServer()
}

func RegisterDocumentsServer(s grpc.ServiceRegistrar, srv DocumentsServer) {
	s.RegisterService(&Documents_ServiceDesc, srv)
}

func _Documents_ListDocuments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDocumentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentsServer).ListDocuments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Documents_ListDocuments_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentsServer).ListDocuments(ctx, req.(*ListDocumentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Documents_GetDocument_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDocumentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentsServer).GetDocument(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Documents_GetDocument_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentsServer).GetDocument(ctx, req.(*GetDocumentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Documents_CreateDocument_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDocumentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentsServer).CreateDocument(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Documents_CreateDocument_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentsServer).CreateDocument(ctx, req.(*CreateDocumentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Documents_ImportDocuments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportDocumentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentsServer).ImportDocuments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Documents_ImportDocuments_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentsServer).ImportDocuments(ctx, req.(*ImportDocumentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Documents_DeleteDocument_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDocumentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentsServer).DeleteDocument(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Documents_DeleteDocument_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentsServer).DeleteDocument(ctx, req.(*DeleteDocumentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Documents_UpdateDocument_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDocumentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentsServer).UpdateDocument(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Documents_UpdateDocument_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentsServer).UpdateDocument(ctx, req.(*UpdateDocumentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Documents_ReloadDocument_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReloadDocumentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentsServer).ReloadDocument(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Documents_ReloadDocument_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentsServer).ReloadDocument(ctx, req.(*ReloadDocumentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Documents_ExportDocument_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportDocumentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentsServer).ExportDocument(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Documents_ExportDocument_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentsServer).ExportDocument(ctx, req.(*ExportDocumentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Documents_ServiceDesc is the grpc.ServiceDesc for Documents service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Documents_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.v2.Documents",
	HandlerType: (*DocumentsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListDocuments",
			Handler:    _Documents_ListDocuments_Handler,
		},
		{
			MethodName: "GetDocument",
			Handler:    _Documents_GetDocument_Handler,
		},
		{
			MethodName: "CreateDocument",
			Handler:    _Documents_CreateDocument_Handler,
		},
		{
			MethodName: "ImportDocuments",
			Handler:    _Documents_ImportDocuments_Handler,
		},
		{
			MethodName: "DeleteDocument",
			Handler:    _Documents_DeleteDocument_Handler,
		},
		{
			MethodName: "UpdateDocument",
			Handler:    _Documents_UpdateDocument_Handler,
		},
		{
			MethodName: "ReloadDocument",
			Handler:    _Documents_ReloadDocument_Handler,
		},
		{
			MethodName: "ExportDocument",
			Handler:    _Documents_ExportDocument_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dialogflow/v2/document.proto",
}
