// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/aiplatform/v1/usage_metadata.proto

package aiplatformpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The type of traffic that this request was processed with, indicating which
// quota gets consumed.
type UsageMetadata_TrafficType int32

const (
	// Unspecified request traffic type.
	UsageMetadata_TRAFFIC_TYPE_UNSPECIFIED UsageMetadata_TrafficType = 0
	// Type for Pay-As-You-Go traffic.
	UsageMetadata_ON_DEMAND UsageMetadata_TrafficType = 1
	// Type for Provisioned Throughput traffic.
	UsageMetadata_PROVISIONED_THROUGHPUT UsageMetadata_TrafficType = 2
)

// Enum value maps for UsageMetadata_TrafficType.
var (
	UsageMetadata_TrafficType_name = map[int32]string{
		0: "TRAFFIC_TYPE_UNSPECIFIED",
		1: "ON_DEMAND",
		2: "PROVISIONED_THROUGHPUT",
	}
	UsageMetadata_TrafficType_value = map[string]int32{
		"TRAFFIC_TYPE_UNSPECIFIED": 0,
		"ON_DEMAND":                1,
		"PROVISIONED_THROUGHPUT":   2,
	}
)

func (x UsageMetadata_TrafficType) Enum() *UsageMetadata_TrafficType {
	p := new(UsageMetadata_TrafficType)
	*p = x
	return p
}

func (x UsageMetadata_TrafficType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (UsageMetadata_TrafficType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1_usage_metadata_proto_enumTypes[0].Descriptor()
}

func (UsageMetadata_TrafficType) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1_usage_metadata_proto_enumTypes[0]
}

func (x UsageMetadata_TrafficType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use UsageMetadata_TrafficType.Descriptor instead.
func (UsageMetadata_TrafficType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_usage_metadata_proto_rawDescGZIP(), []int{0, 0}
}

// Usage metadata about the content generation request and response.
// This message provides a detailed breakdown of token usage and other
// relevant metrics.
type UsageMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The total number of tokens in the prompt. This includes any text, images,
	// or other media provided in the request. When `cached_content` is set,
	// this also includes the number of tokens in the cached content.
	PromptTokenCount int32 `protobuf:"varint,1,opt,name=prompt_token_count,json=promptTokenCount,proto3" json:"prompt_token_count,omitempty"`
	// The total number of tokens in the generated candidates.
	CandidatesTokenCount int32 `protobuf:"varint,2,opt,name=candidates_token_count,json=candidatesTokenCount,proto3" json:"candidates_token_count,omitempty"`
	// The total number of tokens for the entire request. This is the sum of
	// `prompt_token_count`, `candidates_token_count`,
	// `tool_use_prompt_token_count`, and `thoughts_token_count`.
	TotalTokenCount int32 `protobuf:"varint,3,opt,name=total_token_count,json=totalTokenCount,proto3" json:"total_token_count,omitempty"`
	// Output only. The number of tokens in the results from tool executions,
	// which are provided back to the model as input, if applicable.
	ToolUsePromptTokenCount int32 `protobuf:"varint,13,opt,name=tool_use_prompt_token_count,json=toolUsePromptTokenCount,proto3" json:"tool_use_prompt_token_count,omitempty"`
	// Output only. The number of tokens that were part of the model's generated
	// "thoughts" output, if applicable.
	ThoughtsTokenCount int32 `protobuf:"varint,14,opt,name=thoughts_token_count,json=thoughtsTokenCount,proto3" json:"thoughts_token_count,omitempty"`
	// Output only. The number of tokens in the cached content that was used for
	// this request.
	CachedContentTokenCount int32 `protobuf:"varint,5,opt,name=cached_content_token_count,json=cachedContentTokenCount,proto3" json:"cached_content_token_count,omitempty"`
	// Output only. A detailed breakdown of the token count for each modality in
	// the prompt.
	PromptTokensDetails []*ModalityTokenCount `protobuf:"bytes,9,rep,name=prompt_tokens_details,json=promptTokensDetails,proto3" json:"prompt_tokens_details,omitempty"`
	// Output only. A detailed breakdown of the token count for each modality in
	// the cached content.
	CacheTokensDetails []*ModalityTokenCount `protobuf:"bytes,10,rep,name=cache_tokens_details,json=cacheTokensDetails,proto3" json:"cache_tokens_details,omitempty"`
	// Output only. A detailed breakdown of the token count for each modality in
	// the generated candidates.
	CandidatesTokensDetails []*ModalityTokenCount `protobuf:"bytes,11,rep,name=candidates_tokens_details,json=candidatesTokensDetails,proto3" json:"candidates_tokens_details,omitempty"`
	// Output only. A detailed breakdown by modality of the token counts from the
	// results of tool executions, which are provided back to the model as input.
	ToolUsePromptTokensDetails []*ModalityTokenCount `protobuf:"bytes,12,rep,name=tool_use_prompt_tokens_details,json=toolUsePromptTokensDetails,proto3" json:"tool_use_prompt_tokens_details,omitempty"`
	// Output only. The traffic type for this request.
	TrafficType UsageMetadata_TrafficType `protobuf:"varint,8,opt,name=traffic_type,json=trafficType,proto3,enum=google.cloud.aiplatform.v1.UsageMetadata_TrafficType" json:"traffic_type,omitempty"`
}

func (x *UsageMetadata) Reset() {
	*x = UsageMetadata{}
	mi := &file_google_cloud_aiplatform_v1_usage_metadata_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UsageMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UsageMetadata) ProtoMessage() {}

func (x *UsageMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_usage_metadata_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UsageMetadata.ProtoReflect.Descriptor instead.
func (*UsageMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_usage_metadata_proto_rawDescGZIP(), []int{0}
}

func (x *UsageMetadata) GetPromptTokenCount() int32 {
	if x != nil {
		return x.PromptTokenCount
	}
	return 0
}

func (x *UsageMetadata) GetCandidatesTokenCount() int32 {
	if x != nil {
		return x.CandidatesTokenCount
	}
	return 0
}

func (x *UsageMetadata) GetTotalTokenCount() int32 {
	if x != nil {
		return x.TotalTokenCount
	}
	return 0
}

func (x *UsageMetadata) GetToolUsePromptTokenCount() int32 {
	if x != nil {
		return x.ToolUsePromptTokenCount
	}
	return 0
}

func (x *UsageMetadata) GetThoughtsTokenCount() int32 {
	if x != nil {
		return x.ThoughtsTokenCount
	}
	return 0
}

func (x *UsageMetadata) GetCachedContentTokenCount() int32 {
	if x != nil {
		return x.CachedContentTokenCount
	}
	return 0
}

func (x *UsageMetadata) GetPromptTokensDetails() []*ModalityTokenCount {
	if x != nil {
		return x.PromptTokensDetails
	}
	return nil
}

func (x *UsageMetadata) GetCacheTokensDetails() []*ModalityTokenCount {
	if x != nil {
		return x.CacheTokensDetails
	}
	return nil
}

func (x *UsageMetadata) GetCandidatesTokensDetails() []*ModalityTokenCount {
	if x != nil {
		return x.CandidatesTokensDetails
	}
	return nil
}

func (x *UsageMetadata) GetToolUsePromptTokensDetails() []*ModalityTokenCount {
	if x != nil {
		return x.ToolUsePromptTokensDetails
	}
	return nil
}

func (x *UsageMetadata) GetTrafficType() UsageMetadata_TrafficType {
	if x != nil {
		return x.TrafficType
	}
	return UsageMetadata_TRAFFIC_TYPE_UNSPECIFIED
}

var File_google_cloud_aiplatform_v1_usage_metadata_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1_usage_metadata_proto_rawDesc = []byte{
	0x0a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x75, 0x73, 0x61,
	0x67, 0x65, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x28,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xcc, 0x07, 0x0a, 0x0d, 0x55, 0x73, 0x61,
	0x67, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x2c, 0x0a, 0x12, 0x70, 0x72,
	0x6f, 0x6d, 0x70, 0x74, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x10, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x34, 0x0a, 0x16, 0x63, 0x61, 0x6e, 0x64,
	0x69, 0x64, 0x61, 0x74, 0x65, 0x73, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x14, 0x63, 0x61, 0x6e, 0x64, 0x69, 0x64,
	0x61, 0x74, 0x65, 0x73, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x2a,
	0x0a, 0x11, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0f, 0x74, 0x6f, 0x74, 0x61, 0x6c,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x41, 0x0a, 0x1b, 0x74, 0x6f,
	0x6f, 0x6c, 0x5f, 0x75, 0x73, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x05, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x17, 0x74, 0x6f, 0x6f, 0x6c, 0x55, 0x73, 0x65, 0x50, 0x72, 0x6f,
	0x6d, 0x70, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x35, 0x0a,
	0x14, 0x74, 0x68, 0x6f, 0x75, 0x67, 0x68, 0x74, 0x73, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x12, 0x74, 0x68, 0x6f, 0x75, 0x67, 0x68, 0x74, 0x73, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x12, 0x40, 0x0a, 0x1a, 0x63, 0x61, 0x63, 0x68, 0x65, 0x64, 0x5f, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x17, 0x63,
	0x61, 0x63, 0x68, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x67, 0x0a, 0x15, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18,
	0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x43, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x13, 0x70, 0x72, 0x6f, 0x6d,
	0x70, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12,
	0x65, 0x0a, 0x14, 0x63, 0x61, 0x63, 0x68, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x5f,
	0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x61, 0x6c,
	0x69, 0x74, 0x79, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x12, 0x63, 0x61, 0x63, 0x68, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x44,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x6f, 0x0a, 0x19, 0x63, 0x61, 0x6e, 0x64, 0x69, 0x64,
	0x61, 0x74, 0x65, 0x73, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x5f, 0x64, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x17,
	0x63, 0x61, 0x6e, 0x64, 0x69, 0x64, 0x61, 0x74, 0x65, 0x73, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x73,
	0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x77, 0x0a, 0x1e, 0x74, 0x6f, 0x6f, 0x6c, 0x5f,
	0x75, 0x73, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x73, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x0c, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x64,
	0x61, 0x6c, 0x69, 0x74, 0x79, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x1a, 0x74, 0x6f, 0x6f, 0x6c, 0x55, 0x73, 0x65, 0x50, 0x72, 0x6f,
	0x6d, 0x70, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x12, 0x5d, 0x0a, 0x0c, 0x74, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x2e, 0x55, 0x73, 0x61, 0x67, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x2e, 0x54, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0b, 0x74, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x54, 0x79, 0x70, 0x65, 0x22,
	0x56, 0x0a, 0x0b, 0x54, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1c,
	0x0a, 0x18, 0x54, 0x52, 0x41, 0x46, 0x46, 0x49, 0x43, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09,
	0x4f, 0x4e, 0x5f, 0x44, 0x45, 0x4d, 0x41, 0x4e, 0x44, 0x10, 0x01, 0x12, 0x1a, 0x0a, 0x16, 0x50,
	0x52, 0x4f, 0x56, 0x49, 0x53, 0x49, 0x4f, 0x4e, 0x45, 0x44, 0x5f, 0x54, 0x48, 0x52, 0x4f, 0x55,
	0x47, 0x48, 0x50, 0x55, 0x54, 0x10, 0x02, 0x42, 0xd0, 0x01, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x42, 0x12, 0x55, 0x73, 0x61, 0x67,
	0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x3e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x70, 0x62, 0x3b, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62,
	0xaa, 0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x1a,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x41, 0x49, 0x50,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x1d, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x41, 0x49, 0x50, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1_usage_metadata_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1_usage_metadata_proto_rawDescData = file_google_cloud_aiplatform_v1_usage_metadata_proto_rawDesc
)

func file_google_cloud_aiplatform_v1_usage_metadata_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1_usage_metadata_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1_usage_metadata_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1_usage_metadata_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1_usage_metadata_proto_rawDescData
}

var file_google_cloud_aiplatform_v1_usage_metadata_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_aiplatform_v1_usage_metadata_proto_msgTypes = make([]protoimpl.MessageInfo, 1)
var file_google_cloud_aiplatform_v1_usage_metadata_proto_goTypes = []any{
	(UsageMetadata_TrafficType)(0), // 0: google.cloud.aiplatform.v1.UsageMetadata.TrafficType
	(*UsageMetadata)(nil),          // 1: google.cloud.aiplatform.v1.UsageMetadata
	(*ModalityTokenCount)(nil),     // 2: google.cloud.aiplatform.v1.ModalityTokenCount
}
var file_google_cloud_aiplatform_v1_usage_metadata_proto_depIdxs = []int32{
	2, // 0: google.cloud.aiplatform.v1.UsageMetadata.prompt_tokens_details:type_name -> google.cloud.aiplatform.v1.ModalityTokenCount
	2, // 1: google.cloud.aiplatform.v1.UsageMetadata.cache_tokens_details:type_name -> google.cloud.aiplatform.v1.ModalityTokenCount
	2, // 2: google.cloud.aiplatform.v1.UsageMetadata.candidates_tokens_details:type_name -> google.cloud.aiplatform.v1.ModalityTokenCount
	2, // 3: google.cloud.aiplatform.v1.UsageMetadata.tool_use_prompt_tokens_details:type_name -> google.cloud.aiplatform.v1.ModalityTokenCount
	0, // 4: google.cloud.aiplatform.v1.UsageMetadata.traffic_type:type_name -> google.cloud.aiplatform.v1.UsageMetadata.TrafficType
	5, // [5:5] is the sub-list for method output_type
	5, // [5:5] is the sub-list for method input_type
	5, // [5:5] is the sub-list for extension type_name
	5, // [5:5] is the sub-list for extension extendee
	0, // [0:5] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1_usage_metadata_proto_init() }
func file_google_cloud_aiplatform_v1_usage_metadata_proto_init() {
	if File_google_cloud_aiplatform_v1_usage_metadata_proto != nil {
		return
	}
	file_google_cloud_aiplatform_v1_content_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1_usage_metadata_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   1,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_aiplatform_v1_usage_metadata_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1_usage_metadata_proto_depIdxs,
		EnumInfos:         file_google_cloud_aiplatform_v1_usage_metadata_proto_enumTypes,
		MessageInfos:      file_google_cloud_aiplatform_v1_usage_metadata_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1_usage_metadata_proto = out.File
	file_google_cloud_aiplatform_v1_usage_metadata_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1_usage_metadata_proto_goTypes = nil
	file_google_cloud_aiplatform_v1_usage_metadata_proto_depIdxs = nil
}
