//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package common

import (
	"fmt"
	"strconv"
)

// Yaw behaviour during orbit flight.
type ORBIT_YAW_BEHAVIOUR uint64

const (
	// Vehicle front points to the center (default).
	ORBIT_YAW_BEHAVIOUR_HOLD_FRONT_TO_CIRCLE_CENTER ORBIT_YAW_BEHAVIOUR = 0
	// Vehicle front holds heading when message received.
	ORBIT_YAW_BEHAVIOUR_HOLD_INITIAL_HEADING ORBIT_YAW_BEHAVIOUR = 1
	// Yaw uncontrolled.
	ORBIT_YAW_BEHAVIOUR_UNCONTROLLED ORBIT_YAW_BEHAVIOUR = 2
	// Vehicle front follows flight path (tangential to circle).
	ORBIT_YAW_BEHAVIOUR_HOLD_FRONT_TANGENT_TO_CIRCLE ORBIT_YAW_BEHAVIOUR = 3
	// Yaw controlled by RC input.
	ORBIT_YAW_BEHAVIOUR_RC_CONTROLLED ORBIT_YAW_BEHAVIOUR = 4
	// Vehicle uses current yaw behaviour (unchanged). The vehicle-default yaw behaviour is used if this value is specified when orbit is first commanded.
	ORBIT_YAW_BEHAVIOUR_UNCHANGED ORBIT_YAW_BEHAVIOUR = 5
)

var value_to_label_ORBIT_YAW_BEHAVIOUR = map[ORBIT_YAW_BEHAVIOUR]string{
	ORBIT_YAW_BEHAVIOUR_HOLD_FRONT_TO_CIRCLE_CENTER:  "ORBIT_YAW_BEHAVIOUR_HOLD_FRONT_TO_CIRCLE_CENTER",
	ORBIT_YAW_BEHAVIOUR_HOLD_INITIAL_HEADING:         "ORBIT_YAW_BEHAVIOUR_HOLD_INITIAL_HEADING",
	ORBIT_YAW_BEHAVIOUR_UNCONTROLLED:                 "ORBIT_YAW_BEHAVIOUR_UNCONTROLLED",
	ORBIT_YAW_BEHAVIOUR_HOLD_FRONT_TANGENT_TO_CIRCLE: "ORBIT_YAW_BEHAVIOUR_HOLD_FRONT_TANGENT_TO_CIRCLE",
	ORBIT_YAW_BEHAVIOUR_RC_CONTROLLED:                "ORBIT_YAW_BEHAVIOUR_RC_CONTROLLED",
	ORBIT_YAW_BEHAVIOUR_UNCHANGED:                    "ORBIT_YAW_BEHAVIOUR_UNCHANGED",
}

var label_to_value_ORBIT_YAW_BEHAVIOUR = map[string]ORBIT_YAW_BEHAVIOUR{
	"ORBIT_YAW_BEHAVIOUR_HOLD_FRONT_TO_CIRCLE_CENTER":  ORBIT_YAW_BEHAVIOUR_HOLD_FRONT_TO_CIRCLE_CENTER,
	"ORBIT_YAW_BEHAVIOUR_HOLD_INITIAL_HEADING":         ORBIT_YAW_BEHAVIOUR_HOLD_INITIAL_HEADING,
	"ORBIT_YAW_BEHAVIOUR_UNCONTROLLED":                 ORBIT_YAW_BEHAVIOUR_UNCONTROLLED,
	"ORBIT_YAW_BEHAVIOUR_HOLD_FRONT_TANGENT_TO_CIRCLE": ORBIT_YAW_BEHAVIOUR_HOLD_FRONT_TANGENT_TO_CIRCLE,
	"ORBIT_YAW_BEHAVIOUR_RC_CONTROLLED":                ORBIT_YAW_BEHAVIOUR_RC_CONTROLLED,
	"ORBIT_YAW_BEHAVIOUR_UNCHANGED":                    ORBIT_YAW_BEHAVIOUR_UNCHANGED,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e ORBIT_YAW_BEHAVIOUR) MarshalText() ([]byte, error) {
	if name, ok := value_to_label_ORBIT_YAW_BEHAVIOUR[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *ORBIT_YAW_BEHAVIOUR) UnmarshalText(text []byte) error {
	if value, ok := label_to_value_ORBIT_YAW_BEHAVIOUR[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = ORBIT_YAW_BEHAVIOUR(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e ORBIT_YAW_BEHAVIOUR) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
