/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resources;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.internal.resources.AbstractResourceLockRegistry;
import org.gradle.internal.resources.DefaultLease;
import org.gradle.internal.resources.LeaseHolder;
import org.gradle.internal.resources.ResourceLock;
import org.gradle.internal.resources.ResourceLockCoordinationService;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value={Scope.Build.class})
public class SharedResourceLeaseRegistry
extends AbstractResourceLockRegistry<String, ResourceLock> {
    private final Map<String, LeaseHolder> sharedResources = new ConcurrentHashMap<String, LeaseHolder>();
    private final ResourceLockCoordinationService coordinationService;

    public SharedResourceLeaseRegistry(ResourceLockCoordinationService coordinationService) {
        super(coordinationService);
        this.coordinationService = coordinationService;
    }

    public void registerSharedResource(String name, int leases) {
        this.sharedResources.put(name, new LeaseHolder(leases));
    }

    public ResourceLock getResourceLock(String sharedResource) {
        String displayName = "lease for " + sharedResource;
        return new DefaultLease(displayName, this.coordinationService, this, this.sharedResources.get(sharedResource));
    }
}

