/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.wlan;

import com.google.common.collect.ImmutableList;
import com.ubnt.model.L.B.C;
import com.ubnt.service.system.mA;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.slf4j.Logger;

public final class WlanBand
extends Enum<WlanBand> {
    public static final /* enum */ WlanBand BAND_2G = new WlanBand("2g", EnumSet.of(C.Stringsuper));
    public static final /* enum */ WlanBand BAND_5G = new WlanBand("5g", EnumSet.of(C.oo0000));
    public static final /* enum */ WlanBand BAND_6G = new WlanBand("6g", EnumSet.of(C.\u00f800000));
    @Deprecated
    public static final /* enum */ WlanBand BOTH = new WlanBand("both", EnumSet.of(C.Stringsuper, C.oo0000), (List<WlanBand>)ImmutableList.of((Object)((Object)BAND_2G), (Object)((Object)BAND_5G)));
    public static final /* enum */ WlanBand UNKNOWN = new WlanBand("unknown", Collections.emptySet());
    private static final Logger logger;
    private static final Set<WlanBand> UNIQUE_WLAN_BANDS;
    private final String value;
    private final Set<C> radioBands;
    private final List<WlanBand> asList;
    private static final /* synthetic */ WlanBand[] $VALUES;

    public static WlanBand[] values() {
        return (WlanBand[])$VALUES.clone();
    }

    public static WlanBand valueOf(String string) {
        return Enum.valueOf(WlanBand.class, string);
    }

    private WlanBand(String string2, Set<C> set) {
        this.value = string2;
        this.radioBands = set;
        this.asList = Collections.singletonList(this);
    }

    private WlanBand(String string2, Set<C> set, List<WlanBand> list) {
        this.value = string2;
        this.radioBands = set;
        this.asList = list;
    }

    public Set<C> getRadioBands() {
        return this.radioBands;
    }

    public List<WlanBand> toList() {
        return this.asList;
    }

    public boolean isOnRadio(String string) {
        return C.\u00f600000(string).map(this::isOnRadio).orElse(false);
    }

    public boolean isOnRadio(C c2) {
        return this.radioBands.contains(c2);
    }

    public String toString() {
        return this.value;
    }

    public static WlanBand ofStringValue(String string) {
        return Arrays.stream(WlanBand.values()).filter(wlanBand -> wlanBand.toString().equals(string)).findFirst().orElse(UNKNOWN);
    }

    public static WlanBand ofRadio(String string) {
        return C.\u00f600000(string).map(WlanBand::ofRadio).orElse(UNKNOWN);
    }

    public static WlanBand ofRadio(C c2) {
        return UNIQUE_WLAN_BANDS.stream().filter(wlanBand -> wlanBand.radioBands.contains(c2)).findFirst().orElse(UNKNOWN);
    }

    public static WlanBand toLegacySingleValueBand(List<WlanBand> list) {
        if (list.equals(Collections.singletonList(BAND_6G))) {
            return BAND_6G;
        }
        if (list.contains((Object)BAND_6G)) {
            logger.warn("Mapping list of bands {} to legacy single value, 6g band was dropped", list);
        }
        return Stream.of(BOTH, BAND_2G, BAND_5G, UNKNOWN).filter(wlanBand -> list.containsAll(wlanBand.asList)).findFirst().orElse(null);
    }

    private static /* synthetic */ WlanBand[] \u00d200000() {
        return new WlanBand[]{BAND_2G, BAND_5G, BAND_6G, BOTH, UNKNOWN};
    }

    static {
        $VALUES = WlanBand.\u00d200000();
        logger = mA.Oo0000;
        UNIQUE_WLAN_BANDS = EnumSet.of(BAND_2G, BAND_5G, BAND_6G);
    }
}

