/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.client.model.changestream.ChangeStreamDocument;
import com.mongodb.client.model.changestream.OperationType;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.bson.BsonTimestamp;
import org.bson.BsonValue;
import org.bson.Document;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class ChangeStreamEvent<T> {
    private static final AtomicReferenceFieldUpdater<ChangeStreamEvent, Object> CONVERTED_FULL_DOCUMENT_UPDATER = AtomicReferenceFieldUpdater.newUpdater(ChangeStreamEvent.class, Object.class, "convertedFullDocument");
    private static final AtomicReferenceFieldUpdater<ChangeStreamEvent, Object> CONVERTED_FULL_DOCUMENT_BEFORE_CHANGE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(ChangeStreamEvent.class, Object.class, "convertedFullDocumentBeforeChange");
    @Nullable
    private final ChangeStreamDocument<Document> raw;
    private final Class<T> targetType;
    private final MongoConverter converter;
    @Nullable
    private volatile T convertedFullDocument;
    @Nullable
    private volatile T convertedFullDocumentBeforeChange;

    public ChangeStreamEvent(@Nullable ChangeStreamDocument<Document> raw, Class<T> targetType, MongoConverter converter) {
        this.raw = raw;
        this.targetType = targetType;
        this.converter = converter;
    }

    @Nullable
    public ChangeStreamDocument<Document> getRaw() {
        return this.raw;
    }

    @Nullable
    public Instant getTimestamp() {
        return this.getBsonTimestamp() != null ? (Instant)this.converter.getConversionService().convert((Object)this.raw.getClusterTime(), Instant.class) : null;
    }

    @Nullable
    public BsonTimestamp getBsonTimestamp() {
        return this.raw != null ? this.raw.getClusterTime() : null;
    }

    @Nullable
    public BsonValue getResumeToken() {
        return this.raw != null ? this.raw.getResumeToken() : null;
    }

    @Nullable
    public OperationType getOperationType() {
        return this.raw != null ? this.raw.getOperationType() : null;
    }

    @Nullable
    public String getDatabaseName() {
        return this.raw != null ? this.raw.getNamespace().getDatabaseName() : null;
    }

    @Nullable
    public String getCollectionName() {
        return this.raw != null ? this.raw.getNamespace().getCollectionName() : null;
    }

    @Nullable
    public T getBody() {
        if (this.raw == null || this.raw.getFullDocument() == null) {
            return null;
        }
        return this.getConvertedFullDocument((Document)this.raw.getFullDocument());
    }

    @Nullable
    public T getBodyBeforeChange() {
        if (this.raw == null || this.raw.getFullDocumentBeforeChange() == null) {
            return null;
        }
        return this.getConvertedFullDocumentBeforeChange((Document)this.raw.getFullDocumentBeforeChange());
    }

    private T getConvertedFullDocumentBeforeChange(Document fullDocument) {
        return (T)this.doGetConverted(fullDocument, CONVERTED_FULL_DOCUMENT_BEFORE_CHANGE_UPDATER);
    }

    private T getConvertedFullDocument(Document fullDocument) {
        return (T)this.doGetConverted(fullDocument, CONVERTED_FULL_DOCUMENT_UPDATER);
    }

    private Object doGetConverted(Document fullDocument, AtomicReferenceFieldUpdater<ChangeStreamEvent, Object> updater) {
        Object result = updater.get(this);
        if (result != null) {
            return result;
        }
        if (ClassUtils.isAssignable(Document.class, fullDocument.getClass())) {
            result = this.converter.read(this.targetType, fullDocument);
            return updater.compareAndSet(this, null, result) ? result : updater.get(this);
        }
        if (this.converter.getConversionService().canConvert(fullDocument.getClass(), this.targetType)) {
            result = this.converter.getConversionService().convert((Object)fullDocument, this.targetType);
            return updater.compareAndSet(this, null, result) ? result : updater.get(this);
        }
        throw new IllegalArgumentException(String.format("No converter found capable of converting %s to %s", fullDocument.getClass(), this.targetType));
    }

    public String toString() {
        return "ChangeStreamEvent {raw=" + String.valueOf(this.raw) + ", targetType=" + String.valueOf(this.targetType) + "}";
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangeStreamEvent that = (ChangeStreamEvent)o;
        if (!ObjectUtils.nullSafeEquals(this.raw, that.raw)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals(this.targetType, that.targetType);
    }

    public int hashCode() {
        int result = this.raw != null ? this.raw.hashCode() : 0;
        result = 31 * result + ObjectUtils.nullSafeHashCode(this.targetType);
        return result;
    }
}

