/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.integration.api.hotspot.dto;

import com.ubnt.net.Dto;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.beans.ConstructorProperties;
import java.time.Instant;
import java.util.UUID;
import lombok.Generated;
import org.springframework.lang.Nullable;

@Schema(name="Hotspot voucher details")
public final class IntegrationVoucherDetailDto
implements Dto {
    @NotNull
    private final UUID id;
    @NotNull
    private final Instant createdAt;
    @NotNull
    @Schema(description="Voucher note, may contain duplicate values across multiple vouchers", example="hotel-guest")
    private final String name;
    @NotNull
    @Schema(description="Secret code to active the voucher using the Hotspot portal", example="4861409510")
    private final String code;
    @Nullable
    @Schema(description="(Optional) limit for how many different guests can use the same voucher to authorize network access", example="1")
    private final Long authorizedGuestLimit;
    @NotNull
    @Schema(description="For how many guests the voucher has been used to authorize network access", example="0")
    private final long authorizedGuestCount;
    @Nullable
    @Schema(description="(Optional) timestamp when the voucher has been activated (authorization time of the first guest)")
    private final Instant activatedAt;
    @Nullable
    @Schema(description="(Optional) timestamp when the voucher will become expired. All guests using the voucher will be unauthorized from network access")
    private final Instant expiresAt;
    @NotNull
    @Schema(description="Whether the voucher has been expired and can no longer be used to authorize network access")
    private final boolean expired;
    @NotNull
    @Schema(description="How long (in minutes) the voucher will provide access to the network since authorization of the first guest.\nSubsequently connected guests, if allowed, will share the same expiration time.", example="1440")
    private final long timeLimitMinutes;
    @Nullable
    @Schema(description="(Optional) data usage limit in megabytes", example="1024")
    private final Long dataUsageLimitMBytes;
    @Nullable
    @Schema(description="(Optional) download rate limit in kilobits per second", example="1000")
    private final Long rxRateLimitKbps;
    @Nullable
    @Schema(description="(Optional) upload rate limit in kilobits per second", example="1000")
    private final Long txRateLimitKbps;

    @ConstructorProperties(value={"id", "createdAt", "name", "code", "authorizedGuestLimit", "authorizedGuestCount", "activatedAt", "expiresAt", "expired", "timeLimitMinutes", "dataUsageLimitMBytes", "rxRateLimitKbps", "txRateLimitKbps"})
    @Generated
    IntegrationVoucherDetailDto(UUID uUID, Instant instant, String string, String string2, @Nullable Long l2, long l3, @Nullable Instant instant2, @Nullable Instant instant3, boolean bl, long l4, @Nullable Long l5, @Nullable Long l6, @Nullable Long l7) {
        this.id = uUID;
        this.createdAt = instant;
        this.name = string;
        this.code = string2;
        this.authorizedGuestLimit = l2;
        this.authorizedGuestCount = l3;
        this.activatedAt = instant2;
        this.expiresAt = instant3;
        this.expired = bl;
        this.timeLimitMinutes = l4;
        this.dataUsageLimitMBytes = l5;
        this.rxRateLimitKbps = l6;
        this.txRateLimitKbps = l7;
    }

    @Generated
    public static IntegrationVoucherDetailDtoBuilder builder() {
        return new IntegrationVoucherDetailDtoBuilder();
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getCode() {
        return this.code;
    }

    @Nullable
    @Generated
    public Long getAuthorizedGuestLimit() {
        return this.authorizedGuestLimit;
    }

    @Generated
    public long getAuthorizedGuestCount() {
        return this.authorizedGuestCount;
    }

    @Nullable
    @Generated
    public Instant getActivatedAt() {
        return this.activatedAt;
    }

    @Nullable
    @Generated
    public Instant getExpiresAt() {
        return this.expiresAt;
    }

    @Generated
    public boolean isExpired() {
        return this.expired;
    }

    @Generated
    public long getTimeLimitMinutes() {
        return this.timeLimitMinutes;
    }

    @Nullable
    @Generated
    public Long getDataUsageLimitMBytes() {
        return this.dataUsageLimitMBytes;
    }

    @Nullable
    @Generated
    public Long getRxRateLimitKbps() {
        return this.rxRateLimitKbps;
    }

    @Nullable
    @Generated
    public Long getTxRateLimitKbps() {
        return this.txRateLimitKbps;
    }

    @Generated
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IntegrationVoucherDetailDto)) {
            return false;
        }
        IntegrationVoucherDetailDto integrationVoucherDetailDto = (IntegrationVoucherDetailDto)object;
        if (this.getAuthorizedGuestCount() != integrationVoucherDetailDto.getAuthorizedGuestCount()) {
            return false;
        }
        if (this.isExpired() != integrationVoucherDetailDto.isExpired()) {
            return false;
        }
        if (this.getTimeLimitMinutes() != integrationVoucherDetailDto.getTimeLimitMinutes()) {
            return false;
        }
        Long l2 = this.getAuthorizedGuestLimit();
        Long l3 = integrationVoucherDetailDto.getAuthorizedGuestLimit();
        if (l2 == null ? l3 != null : !((Object)l2).equals(l3)) {
            return false;
        }
        Long l4 = this.getDataUsageLimitMBytes();
        Long l5 = integrationVoucherDetailDto.getDataUsageLimitMBytes();
        if (l4 == null ? l5 != null : !((Object)l4).equals(l5)) {
            return false;
        }
        Long l6 = this.getRxRateLimitKbps();
        Long l7 = integrationVoucherDetailDto.getRxRateLimitKbps();
        if (l6 == null ? l7 != null : !((Object)l6).equals(l7)) {
            return false;
        }
        Long l8 = this.getTxRateLimitKbps();
        Long l9 = integrationVoucherDetailDto.getTxRateLimitKbps();
        if (l8 == null ? l9 != null : !((Object)l8).equals(l9)) {
            return false;
        }
        UUID uUID = this.getId();
        UUID uUID2 = integrationVoucherDetailDto.getId();
        if (uUID == null ? uUID2 != null : !((Object)uUID).equals(uUID2)) {
            return false;
        }
        Instant instant = this.getCreatedAt();
        Instant instant2 = integrationVoucherDetailDto.getCreatedAt();
        if (instant == null ? instant2 != null : !((Object)instant).equals(instant2)) {
            return false;
        }
        String string = this.getName();
        String string2 = integrationVoucherDetailDto.getName();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        String string3 = this.getCode();
        String string4 = integrationVoucherDetailDto.getCode();
        if (string3 == null ? string4 != null : !string3.equals(string4)) {
            return false;
        }
        Instant instant3 = this.getActivatedAt();
        Instant instant4 = integrationVoucherDetailDto.getActivatedAt();
        if (instant3 == null ? instant4 != null : !((Object)instant3).equals(instant4)) {
            return false;
        }
        Instant instant5 = this.getExpiresAt();
        Instant instant6 = integrationVoucherDetailDto.getExpiresAt();
        return !(instant5 == null ? instant6 != null : !((Object)instant5).equals(instant6));
    }

    @Generated
    public int hashCode() {
        int n2 = 1;
        long l2 = this.getAuthorizedGuestCount();
        n2 = n2 * 59 + (int)(l2 >>> 32 ^ l2);
        n2 = n2 * 59 + (this.isExpired() ? 79 : 97);
        long l3 = this.getTimeLimitMinutes();
        n2 = n2 * 59 + (int)(l3 >>> 32 ^ l3);
        Long l4 = this.getAuthorizedGuestLimit();
        n2 = n2 * 59 + (l4 == null ? 43 : ((Object)l4).hashCode());
        Long l5 = this.getDataUsageLimitMBytes();
        n2 = n2 * 59 + (l5 == null ? 43 : ((Object)l5).hashCode());
        Long l6 = this.getRxRateLimitKbps();
        n2 = n2 * 59 + (l6 == null ? 43 : ((Object)l6).hashCode());
        Long l7 = this.getTxRateLimitKbps();
        n2 = n2 * 59 + (l7 == null ? 43 : ((Object)l7).hashCode());
        UUID uUID = this.getId();
        n2 = n2 * 59 + (uUID == null ? 43 : ((Object)uUID).hashCode());
        Instant instant = this.getCreatedAt();
        n2 = n2 * 59 + (instant == null ? 43 : ((Object)instant).hashCode());
        String string = this.getName();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        String string2 = this.getCode();
        n2 = n2 * 59 + (string2 == null ? 43 : string2.hashCode());
        Instant instant2 = this.getActivatedAt();
        n2 = n2 * 59 + (instant2 == null ? 43 : ((Object)instant2).hashCode());
        Instant instant3 = this.getExpiresAt();
        n2 = n2 * 59 + (instant3 == null ? 43 : ((Object)instant3).hashCode());
        return n2;
    }

    @Generated
    public String toString() {
        return "IntegrationVoucherDetailDto(id=" + String.valueOf(this.getId()) + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ", name=" + this.getName() + ", code=" + this.getCode() + ", authorizedGuestLimit=" + this.getAuthorizedGuestLimit() + ", authorizedGuestCount=" + this.getAuthorizedGuestCount() + ", activatedAt=" + String.valueOf(this.getActivatedAt()) + ", expiresAt=" + String.valueOf(this.getExpiresAt()) + ", expired=" + this.isExpired() + ", timeLimitMinutes=" + this.getTimeLimitMinutes() + ", dataUsageLimitMBytes=" + this.getDataUsageLimitMBytes() + ", rxRateLimitKbps=" + this.getRxRateLimitKbps() + ", txRateLimitKbps=" + this.getTxRateLimitKbps() + ")";
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Generated
    public static class IntegrationVoucherDetailDtoBuilder {
        @Generated
        private UUID \u00d300000;
        @Generated
        private Instant \u00f500000;
        @Generated
        private String \u00d200000;
        @Generated
        private String String;
        @Generated
        private Long \u00f600000;
        @Generated
        private long for;
        @Generated
        private Instant o00000;
        @Generated
        private Instant \u00d500000;
        @Generated
        private boolean \u00f800000;
        @Generated
        private long oO0000;
        @Generated
        private Long \u00d800000;
        @Generated
        private Long null;
        @Generated
        private Long \u00d600000;

        @Generated
        IntegrationVoucherDetailDtoBuilder() {
        }

        @Generated
        public IntegrationVoucherDetailDtoBuilder id(UUID uUID) {
            this.\u00d300000 = uUID;
            return this;
        }

        @Generated
        public IntegrationVoucherDetailDtoBuilder createdAt(Instant instant) {
            this.\u00f500000 = instant;
            return this;
        }

        @Generated
        public IntegrationVoucherDetailDtoBuilder name(String string) {
            this.\u00d200000 = string;
            return this;
        }

        @Generated
        public IntegrationVoucherDetailDtoBuilder code(String string) {
            this.String = string;
            return this;
        }

        @Generated
        public IntegrationVoucherDetailDtoBuilder authorizedGuestLimit(@Nullable Long l2) {
            this.\u00f600000 = l2;
            return this;
        }

        @Generated
        public IntegrationVoucherDetailDtoBuilder authorizedGuestCount(long l2) {
            this.for = l2;
            return this;
        }

        @Generated
        public IntegrationVoucherDetailDtoBuilder activatedAt(@Nullable Instant instant) {
            this.o00000 = instant;
            return this;
        }

        @Generated
        public IntegrationVoucherDetailDtoBuilder expiresAt(@Nullable Instant instant) {
            this.\u00d500000 = instant;
            return this;
        }

        @Generated
        public IntegrationVoucherDetailDtoBuilder expired(boolean bl) {
            this.\u00f800000 = bl;
            return this;
        }

        @Generated
        public IntegrationVoucherDetailDtoBuilder timeLimitMinutes(long l2) {
            this.oO0000 = l2;
            return this;
        }

        @Generated
        public IntegrationVoucherDetailDtoBuilder dataUsageLimitMBytes(@Nullable Long l2) {
            this.\u00d800000 = l2;
            return this;
        }

        @Generated
        public IntegrationVoucherDetailDtoBuilder rxRateLimitKbps(@Nullable Long l2) {
            this.null = l2;
            return this;
        }

        @Generated
        public IntegrationVoucherDetailDtoBuilder txRateLimitKbps(@Nullable Long l2) {
            this.\u00d600000 = l2;
            return this;
        }

        @Generated
        public IntegrationVoucherDetailDto build() {
            return new IntegrationVoucherDetailDto(this.\u00d300000, this.\u00f500000, this.\u00d200000, this.String, this.\u00f600000, this.for, this.o00000, this.\u00d500000, this.\u00f800000, this.oO0000, this.\u00d800000, this.null, this.\u00d600000);
        }

        @Generated
        public String toString() {
            return "IntegrationVoucherDetailDto.IntegrationVoucherDetailDtoBuilder(id=" + java.lang.String.valueOf(this.\u00d300000) + ", createdAt=" + java.lang.String.valueOf(this.\u00f500000) + ", name=" + this.\u00d200000 + ", code=" + this.String + ", authorizedGuestLimit=" + this.\u00f600000 + ", authorizedGuestCount=" + this.for + ", activatedAt=" + java.lang.String.valueOf(this.o00000) + ", expiresAt=" + java.lang.String.valueOf(this.\u00d500000) + ", expired=" + this.\u00f800000 + ", timeLimitMinutes=" + this.oO0000 + ", dataUsageLimitMBytes=" + this.\u00d800000 + ", rxRateLimitKbps=" + this.null + ", txRateLimitKbps=" + this.\u00d600000 + ")";
        }
    }
}

