/*
 * Decompiled with CFR 0.152.
 */
package org.vinniks.parsla.tokenizer.text;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.NoSuchElementException;
import lombok.NonNull;
import org.vinniks.parsla.tokenizer.Token;
import org.vinniks.parsla.tokenizer.TokenIterator;
import org.vinniks.parsla.tokenizer.text.CharacterIterator;
import org.vinniks.parsla.tokenizer.text.TextPosition;

public abstract class AbstractTextTokenIterator
implements TokenIterator<TextPosition> {
    private final CharacterIterator characterIterator;
    private final Deque<Token> tokens;
    private final Deque<TextPosition> positions;
    private int line;
    private int column;
    private TextPosition position;

    protected AbstractTextTokenIterator(@NonNull CharacterIterator characterIterator) {
        if (characterIterator == null) {
            throw new NullPointerException("characterIterator is marked non-null but is null");
        }
        this.characterIterator = characterIterator;
        this.tokens = new ArrayDeque<Token>();
        this.positions = new ArrayDeque<TextPosition>();
        this.line = 1;
        this.column = 1;
    }

    protected final void push(Token token, TextPosition position) {
        this.tokens.push(token);
        this.positions.push(position);
    }

    protected abstract void character(char var1);

    protected abstract void end();

    @Override
    public final boolean hasNext() throws IOException {
        this.ensureNextToken();
        return !this.tokens.isEmpty();
    }

    @Override
    public final Token next() throws IOException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.position = this.positions.pop();
        return this.tokens.pop();
    }

    @Override
    public TextPosition position() {
        return this.position;
    }

    @Override
    public void close() {
        this.characterIterator.close();
    }

    protected TextPosition characterPosition() {
        return new TextPosition(this.line, this.column);
    }

    private void ensureNextToken() throws IOException {
        if (this.tokens.isEmpty() && this.characterIterator.hasNext()) {
            while (this.tokens.isEmpty() && this.characterIterator.hasNext()) {
                char c = this.characterIterator.next();
                this.character(c);
                if (c == '\n') {
                    ++this.line;
                    this.column = 1;
                    continue;
                }
                ++this.column;
            }
            if (!this.characterIterator.hasNext()) {
                this.end();
            }
        }
    }
}

