/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.user;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.springframework.context.SmartLifecycle;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.messaging.core.MessageSendingOperations;
import org.springframework.messaging.simp.SimpLogging;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.messaging.simp.SimpMessageType;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.messaging.simp.broker.OrderedMessageChannelDecorator;
import org.springframework.messaging.simp.user.UserDestinationResolver;
import org.springframework.messaging.simp.user.UserDestinationResult;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.messaging.support.MessageHeaderAccessor;
import org.springframework.messaging.support.MessageHeaderInitializer;
import org.springframework.messaging.support.NativeMessageHeaderAccessor;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class UserDestinationMessageHandler
implements MessageHandler,
SmartLifecycle {
    private static final Log logger = SimpLogging.forLogName(UserDestinationMessageHandler.class);
    private final SubscribableChannel clientInboundChannel;
    private final SubscribableChannel brokerChannel;
    private final UserDestinationResolver destinationResolver;
    private final SendHelper sendHelper;
    @Nullable
    private BroadcastHandler broadcastHandler;
    @Nullable
    private MessageHeaderInitializer headerInitializer;
    private volatile boolean running;
    @Nullable
    private Integer phase;
    private final Object lifecycleMonitor = new Object();

    public UserDestinationMessageHandler(SubscribableChannel clientInboundChannel, SubscribableChannel brokerChannel, UserDestinationResolver destinationResolver) {
        Assert.notNull((Object)clientInboundChannel, (String)"'clientInChannel' must not be null");
        Assert.notNull((Object)brokerChannel, (String)"'brokerChannel' must not be null");
        Assert.notNull((Object)destinationResolver, (String)"resolver must not be null");
        this.clientInboundChannel = clientInboundChannel;
        this.brokerChannel = brokerChannel;
        this.sendHelper = new SendHelper(clientInboundChannel, brokerChannel);
        this.destinationResolver = destinationResolver;
    }

    public UserDestinationResolver getUserDestinationResolver() {
        return this.destinationResolver;
    }

    public void setBroadcastDestination(@Nullable String destination) {
        this.broadcastHandler = StringUtils.hasText((String)destination) ? new BroadcastHandler(this.sendHelper.getMessagingTemplate(), destination) : null;
    }

    @Nullable
    public String getBroadcastDestination() {
        return this.broadcastHandler != null ? this.broadcastHandler.getBroadcastDestination() : null;
    }

    public MessageSendingOperations<String> getBrokerMessagingTemplate() {
        return this.sendHelper.getMessagingTemplate();
    }

    public void setHeaderInitializer(@Nullable MessageHeaderInitializer headerInitializer) {
        this.headerInitializer = headerInitializer;
    }

    @Nullable
    public MessageHeaderInitializer getHeaderInitializer() {
        return this.headerInitializer;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public int getPhase() {
        return this.phase != null ? this.phase.intValue() : super.getPhase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.clientInboundChannel.subscribe(this);
            this.brokerChannel.subscribe(this);
            this.running = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.running = false;
            this.clientInboundChannel.unsubscribe(this);
            this.brokerChannel.unsubscribe(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop(Runnable callback) {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.stop();
            callback.run();
        }
    }

    public final boolean isRunning() {
        return this.running;
    }

    @Override
    public void handleMessage(Message<?> sourceMessage) throws MessagingException {
        Message<?> message = sourceMessage;
        if (this.broadcastHandler != null && (message = this.broadcastHandler.preHandle(sourceMessage)) == null) {
            return;
        }
        UserDestinationResult result = this.destinationResolver.resolveDestination(message);
        if (result == null) {
            this.sendHelper.checkDisconnect(message);
            return;
        }
        if (result.getTargetDestinations().isEmpty()) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("No active sessions for user destination: " + result.getSourceDestination()));
            }
            if (this.broadcastHandler != null) {
                this.broadcastHandler.handleUnresolved(message);
            }
            return;
        }
        SimpMessageHeaderAccessor accessor = SimpMessageHeaderAccessor.wrap(message);
        this.initHeaders(accessor);
        accessor.setNativeHeader("simpOrigDestination", result.getSubscribeDestination());
        accessor.setLeaveMutable(true);
        message = MessageBuilder.createMessage(message.getPayload(), accessor.getMessageHeaders());
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Translated " + result.getSourceDestination() + " -> " + String.valueOf(result.getTargetDestinations())));
        }
        this.sendHelper.send(result, message);
    }

    private void initHeaders(SimpMessageHeaderAccessor headerAccessor) {
        if (this.getHeaderInitializer() != null) {
            this.getHeaderInitializer().initHeaders(headerAccessor);
        }
    }

    public String toString() {
        return "UserDestinationMessageHandler[" + String.valueOf(this.destinationResolver) + "]";
    }

    private static class SendHelper {
        private final MessageChannel brokerChannel;
        private final MessageSendingOperations<String> messagingTemplate;
        @Nullable
        private final Map<String, MessageSendingOperations<String>> orderedMessagingTemplates;

        SendHelper(MessageChannel clientInboundChannel, MessageChannel brokerChannel) {
            this.brokerChannel = brokerChannel;
            this.messagingTemplate = new SimpMessagingTemplate(brokerChannel);
            if (OrderedMessageChannelDecorator.supportsOrderedMessages(clientInboundChannel)) {
                this.orderedMessagingTemplates = new ConcurrentHashMap<String, MessageSendingOperations<String>>();
                OrderedMessageChannelDecorator.configureInterceptor(brokerChannel, true);
            } else {
                this.orderedMessagingTemplates = null;
            }
        }

        public MessageSendingOperations<String> getMessagingTemplate() {
            return this.messagingTemplate;
        }

        public void send(UserDestinationResult result, Message<?> message) throws MessagingException {
            Iterator<String> itr = result.getSessionIds().iterator();
            for (String target : result.getTargetDestinations()) {
                String sessionId = itr.hasNext() ? itr.next() : null;
                this.getTemplateToUse(sessionId).send(target, message);
            }
        }

        private MessageSendingOperations<String> getTemplateToUse(@Nullable String sessionId) {
            if (this.orderedMessagingTemplates != null && sessionId != null) {
                return this.orderedMessagingTemplates.computeIfAbsent(sessionId, id -> new SimpMessagingTemplate(new OrderedMessageChannelDecorator(this.brokerChannel, logger)));
            }
            return this.messagingTemplate;
        }

        public void checkDisconnect(Message<?> message) {
            String sessionId;
            MessageHeaders headers;
            if (this.orderedMessagingTemplates != null && SimpMessageHeaderAccessor.getMessageType(headers = message.getHeaders()) == SimpMessageType.DISCONNECT && (sessionId = SimpMessageHeaderAccessor.getSessionId(headers)) != null) {
                this.orderedMessagingTemplates.remove(sessionId);
            }
        }
    }

    private static class BroadcastHandler {
        private static final List<String> NO_COPY_LIST = Arrays.asList("subscription", "message-id");
        private final MessageSendingOperations<String> messagingTemplate;
        private final String broadcastDestination;

        public BroadcastHandler(MessageSendingOperations<String> template, String destination) {
            this.messagingTemplate = template;
            this.broadcastDestination = destination;
        }

        public String getBroadcastDestination() {
            return this.broadcastDestination;
        }

        @Nullable
        public Message<?> preHandle(Message<?> message) throws MessagingException {
            String destination = SimpMessageHeaderAccessor.getDestination(message.getHeaders());
            if (!this.getBroadcastDestination().equals(destination)) {
                return message;
            }
            SimpMessageHeaderAccessor accessor = MessageHeaderAccessor.getAccessor(message, SimpMessageHeaderAccessor.class);
            Assert.state((accessor != null ? 1 : 0) != 0, (String)"No SimpMessageHeaderAccessor");
            if (accessor.getSessionId() == null) {
                return null;
            }
            destination = accessor.getFirstNativeHeader("simpOrigDestination");
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Checking unresolved user destination: " + destination));
            }
            SimpMessageHeaderAccessor newAccessor = SimpMessageHeaderAccessor.create(SimpMessageType.MESSAGE);
            for (String name : accessor.toNativeHeaderMap().keySet()) {
                if (NO_COPY_LIST.contains(name)) continue;
                newAccessor.setNativeHeader(name, accessor.getFirstNativeHeader(name));
            }
            if (destination != null) {
                newAccessor.setDestination(destination);
            }
            newAccessor.setHeader("simpIgnoreError", true);
            return MessageBuilder.createMessage(message.getPayload(), newAccessor.getMessageHeaders());
        }

        public void handleUnresolved(Message<?> message) {
            MessageHeaders headers = message.getHeaders();
            if (NativeMessageHeaderAccessor.getFirstNativeHeader("simpOrigDestination", headers) != null) {
                return;
            }
            SimpMessageHeaderAccessor accessor = SimpMessageHeaderAccessor.wrap(message);
            String destination = accessor.getDestination();
            accessor.setNativeHeader("simpOrigDestination", destination);
            accessor.setLeaveMutable(true);
            message = MessageBuilder.createMessage(message.getPayload(), accessor.getMessageHeaders());
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Translated " + destination + " -> " + this.getBroadcastDestination()));
            }
            this.messagingTemplate.send(this.getBroadcastDestination(), message);
        }
    }
}

