/*
 * Decompiled with CFR 0.152.
 */
package it.sauronsoftware.cron4j;

import it.sauronsoftware.cron4j.AlwaysTrueValueMatcher;
import it.sauronsoftware.cron4j.DayOfMonthValueMatcher;
import it.sauronsoftware.cron4j.IntArrayValueMatcher;
import it.sauronsoftware.cron4j.InvalidPatternException;
import it.sauronsoftware.cron4j.ValueMatcher;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class SchedulingPattern {
    private static final ValueParser MINUTE_VALUE_PARSER = new MinuteValueParser();
    private static final ValueParser HOUR_VALUE_PARSER = new HourValueParser();
    private static final ValueParser DAY_OF_MONTH_VALUE_PARSER = new DayOfMonthValueParser();
    private static final ValueParser MONTH_VALUE_PARSER = new MonthValueParser();
    private static final ValueParser DAY_OF_WEEK_VALUE_PARSER = new DayOfWeekValueParser();
    private String asString;
    protected ArrayList minuteMatchers = new ArrayList();
    protected ArrayList hourMatchers = new ArrayList();
    protected ArrayList dayOfMonthMatchers = new ArrayList();
    protected ArrayList monthMatchers = new ArrayList();
    protected ArrayList dayOfWeekMatchers = new ArrayList();
    protected int matcherSize = 0;

    public static boolean validate(String string) {
        try {
            new SchedulingPattern(string);
        }
        catch (InvalidPatternException invalidPatternException) {
            return false;
        }
        return true;
    }

    public SchedulingPattern(String string) throws InvalidPatternException {
        this.asString = string;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        if (stringTokenizer.countTokens() < 1) {
            throw new InvalidPatternException("invalid pattern: \"" + string + "\"");
        }
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, " \t");
            if (stringTokenizer2.countTokens() != 5) {
                throw new InvalidPatternException("invalid pattern: \"" + string2 + "\"");
            }
            try {
                this.minuteMatchers.add(this.buildValueMatcher(stringTokenizer2.nextToken(), MINUTE_VALUE_PARSER));
            }
            catch (Exception exception) {
                throw new InvalidPatternException("invalid pattern \"" + string2 + "\". Error parsing minutes field: " + exception.getMessage() + ".");
            }
            try {
                this.hourMatchers.add(this.buildValueMatcher(stringTokenizer2.nextToken(), HOUR_VALUE_PARSER));
            }
            catch (Exception exception) {
                throw new InvalidPatternException("invalid pattern \"" + string2 + "\". Error parsing hours field: " + exception.getMessage() + ".");
            }
            try {
                this.dayOfMonthMatchers.add(this.buildValueMatcher(stringTokenizer2.nextToken(), DAY_OF_MONTH_VALUE_PARSER));
            }
            catch (Exception exception) {
                throw new InvalidPatternException("invalid pattern \"" + string2 + "\". Error parsing days of month field: " + exception.getMessage() + ".");
            }
            try {
                this.monthMatchers.add(this.buildValueMatcher(stringTokenizer2.nextToken(), MONTH_VALUE_PARSER));
            }
            catch (Exception exception) {
                throw new InvalidPatternException("invalid pattern \"" + string2 + "\". Error parsing months field: " + exception.getMessage() + ".");
            }
            try {
                this.dayOfWeekMatchers.add(this.buildValueMatcher(stringTokenizer2.nextToken(), DAY_OF_WEEK_VALUE_PARSER));
            }
            catch (Exception exception) {
                throw new InvalidPatternException("invalid pattern \"" + string2 + "\". Error parsing days of week field: " + exception.getMessage() + ".");
            }
            ++this.matcherSize;
        }
    }

    private ValueMatcher buildValueMatcher(String string, ValueParser valueParser) throws Exception {
        if (string.length() == 1 && string.equals("*")) {
            return new AlwaysTrueValueMatcher();
        }
        ArrayList arrayList = new ArrayList();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            ArrayList arrayList2;
            String string2 = stringTokenizer.nextToken();
            try {
                arrayList2 = this.parseListElement(string2, valueParser);
            }
            catch (Exception exception) {
                throw new Exception("invalid field \"" + string + "\", invalid element \"" + string2 + "\", " + exception.getMessage());
            }
            Iterator iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (arrayList.contains(e)) continue;
                arrayList.add(e);
            }
        }
        if (arrayList.size() == 0) {
            throw new Exception("invalid field \"" + string + "\"");
        }
        if (valueParser == DAY_OF_MONTH_VALUE_PARSER) {
            return new DayOfMonthValueMatcher(arrayList);
        }
        return new IntArrayValueMatcher(arrayList);
    }

    private ArrayList parseListElement(String string, ValueParser valueParser) throws Exception {
        ArrayList arrayList;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        int n = stringTokenizer.countTokens();
        if (n < 1 || n > 2) {
            throw new Exception("syntax error");
        }
        try {
            arrayList = this.parseRange(stringTokenizer.nextToken(), valueParser);
        }
        catch (Exception exception) {
            throw new Exception("invalid range, " + exception.getMessage());
        }
        if (n == 2) {
            int n2;
            String string2 = stringTokenizer.nextToken();
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new Exception("invalid divisor \"" + string2 + "\"");
            }
            if (n2 < 1) {
                throw new Exception("non positive divisor \"" + n2 + "\"");
            }
            ArrayList arrayList2 = new ArrayList();
            for (int i = 0; i < arrayList.size(); i += n2) {
                arrayList2.add(arrayList.get(i));
            }
            return arrayList2;
        }
        return arrayList;
    }

    private ArrayList parseRange(String string, ValueParser valueParser) throws Exception {
        int n;
        int n2;
        if (string.equals("*")) {
            int n3 = valueParser.getMinValue();
            int n4 = valueParser.getMaxValue();
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (int i = n3; i <= n4; ++i) {
                arrayList.add(new Integer(i));
            }
            return arrayList;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "-");
        int n5 = stringTokenizer.countTokens();
        if (n5 < 1 || n5 > 2) {
            throw new Exception("syntax error");
        }
        String string2 = stringTokenizer.nextToken();
        try {
            n2 = valueParser.parse(string2);
        }
        catch (Exception exception) {
            throw new Exception("invalid value \"" + string2 + "\", " + exception.getMessage());
        }
        if (n5 == 1) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            arrayList.add(new Integer(n2));
            return arrayList;
        }
        String string3 = stringTokenizer.nextToken();
        try {
            n = valueParser.parse(string3);
        }
        catch (Exception exception) {
            throw new Exception("invalid value \"" + string3 + "\", " + exception.getMessage());
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (n2 < n) {
            for (int i = n2; i <= n; ++i) {
                arrayList.add(new Integer(i));
            }
        } else if (n2 > n) {
            int n6;
            int n7 = valueParser.getMinValue();
            int n8 = valueParser.getMaxValue();
            for (n6 = n2; n6 <= n8; ++n6) {
                arrayList.add(new Integer(n6));
            }
            for (n6 = n7; n6 <= n; ++n6) {
                arrayList.add(new Integer(n6));
            }
        } else {
            arrayList.add(new Integer(n2));
        }
        return arrayList;
    }

    public boolean match(TimeZone timeZone, long l) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeInMillis(l);
        gregorianCalendar.setTimeZone(timeZone);
        int n = gregorianCalendar.get(12);
        int n2 = gregorianCalendar.get(11);
        int n3 = gregorianCalendar.get(5);
        int n4 = gregorianCalendar.get(2) + 1;
        int n5 = gregorianCalendar.get(7) - 1;
        int n6 = gregorianCalendar.get(1);
        for (int i = 0; i < this.matcherSize; ++i) {
            boolean bl;
            ValueMatcher valueMatcher = (ValueMatcher)this.minuteMatchers.get(i);
            ValueMatcher valueMatcher2 = (ValueMatcher)this.hourMatchers.get(i);
            ValueMatcher valueMatcher3 = (ValueMatcher)this.dayOfMonthMatchers.get(i);
            ValueMatcher valueMatcher4 = (ValueMatcher)this.monthMatchers.get(i);
            ValueMatcher valueMatcher5 = (ValueMatcher)this.dayOfWeekMatchers.get(i);
            boolean bl2 = valueMatcher.match(n) && valueMatcher2.match(n2) && (valueMatcher3 instanceof DayOfMonthValueMatcher ? ((DayOfMonthValueMatcher)valueMatcher3).match(n3, n4, gregorianCalendar.isLeapYear(n6)) : valueMatcher3.match(n3)) && valueMatcher4.match(n4) && valueMatcher5.match(n5) ? true : (bl = false);
            if (!bl) continue;
            return true;
        }
        return false;
    }

    public boolean match(long l) {
        return this.match(TimeZone.getDefault(), l);
    }

    public String toString() {
        return this.asString;
    }

    private static int parseAlias(String string, String[] stringArray, int n) throws Exception {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase(string)) continue;
            return n + i;
        }
        throw new Exception("invalid alias \"" + string + "\"");
    }

    private static class DayOfWeekValueParser
    extends SimpleValueParser {
        private static String[] ALIASES = new String[]{"sun", "mon", "tue", "wed", "thu", "fri", "sat"};

        public DayOfWeekValueParser() {
            super(0, 7);
        }

        public int parse(String string) throws Exception {
            try {
                return super.parse(string) % 7;
            }
            catch (Exception exception) {
                return SchedulingPattern.parseAlias(string, DayOfWeekValueParser.ALIASES, 0);
            }
        }
    }

    private static class MonthValueParser
    extends SimpleValueParser {
        private static String[] ALIASES = new String[]{"jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec"};

        public MonthValueParser() {
            super(1, 12);
        }

        public int parse(String string) throws Exception {
            try {
                return super.parse(string);
            }
            catch (Exception exception) {
                return SchedulingPattern.parseAlias(string, MonthValueParser.ALIASES, 1);
            }
        }
    }

    private static class DayOfMonthValueParser
    extends SimpleValueParser {
        public DayOfMonthValueParser() {
            super(1, 31);
        }

        public int parse(String string) throws Exception {
            if (string.equalsIgnoreCase("L")) {
                return 32;
            }
            return super.parse(string);
        }
    }

    private static class HourValueParser
    extends SimpleValueParser {
        public HourValueParser() {
            super(0, 23);
        }
    }

    private static class MinuteValueParser
    extends SimpleValueParser {
        public MinuteValueParser() {
            super(0, 59);
        }
    }

    private static class SimpleValueParser
    implements ValueParser {
        protected int minValue;
        protected int maxValue;

        public SimpleValueParser(int n, int n2) {
            this.minValue = n;
            this.maxValue = n2;
        }

        public int parse(String string) throws Exception {
            int n;
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new Exception("invalid integer value");
            }
            if (n < this.minValue || n > this.maxValue) {
                throw new Exception("value out of range");
            }
            return n;
        }

        public int getMinValue() {
            return this.minValue;
        }

        public int getMaxValue() {
            return this.maxValue;
        }
    }

    private static interface ValueParser {
        public int parse(String var1) throws Exception;

        public int getMinValue();

        public int getMaxValue();
    }
}

