/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpHead;
import org.apache.hc.client5.http.classic.methods.HttpOptions;
import org.apache.hc.client5.http.classic.methods.HttpPatch;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpTrace;
import org.apache.hc.client5.http.config.Configurable;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequest;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class HttpComponentsClientHttpRequestFactory
implements ClientHttpRequestFactory,
DisposableBean {
    private HttpClient httpClient;
    @Nullable
    private BiFunction<HttpMethod, URI, HttpContext> httpContextFactory;
    private long connectTimeout = -1L;
    private long connectionRequestTimeout = -1L;

    public HttpComponentsClientHttpRequestFactory() {
        this.httpClient = HttpClients.createSystem();
    }

    public HttpComponentsClientHttpRequestFactory(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        Assert.notNull((Object)httpClient, (String)"HttpClient must not be null");
        this.httpClient = httpClient;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setConnectTimeout(int connectTimeout) {
        Assert.isTrue((connectTimeout >= 0 ? 1 : 0) != 0, (String)"Timeout must be a non-negative value");
        this.connectTimeout = connectTimeout;
    }

    public void setConnectTimeout(Duration connectTimeout) {
        Assert.notNull((Object)connectTimeout, (String)"ConnectTimeout must not be null");
        Assert.isTrue((!connectTimeout.isNegative() ? 1 : 0) != 0, (String)"Timeout must be a non-negative value");
        this.connectTimeout = connectTimeout.toMillis();
    }

    public void setConnectionRequestTimeout(int connectionRequestTimeout) {
        Assert.isTrue((connectionRequestTimeout >= 0 ? 1 : 0) != 0, (String)"Timeout must be a non-negative value");
        this.connectionRequestTimeout = connectionRequestTimeout;
    }

    public void setConnectionRequestTimeout(Duration connectionRequestTimeout) {
        Assert.notNull((Object)connectionRequestTimeout, (String)"ConnectionRequestTimeout must not be null");
        Assert.isTrue((!connectionRequestTimeout.isNegative() ? 1 : 0) != 0, (String)"Timeout must be a non-negative value");
        this.connectionRequestTimeout = connectionRequestTimeout.toMillis();
    }

    @Deprecated(since="6.1", forRemoval=true)
    public void setBufferRequestBody(boolean bufferRequestBody) {
    }

    public void setHttpContextFactory(BiFunction<HttpMethod, URI, HttpContext> httpContextFactory) {
        this.httpContextFactory = httpContextFactory;
    }

    @Override
    public ClientHttpRequest createRequest(URI uri, HttpMethod httpMethod) throws IOException {
        HttpClient client = this.getHttpClient();
        ClassicHttpRequest httpRequest = this.createHttpUriRequest(httpMethod, uri);
        this.postProcessHttpRequest(httpRequest);
        HttpContext context = this.createHttpContext(httpMethod, uri);
        if (context == null) {
            context = HttpClientContext.create();
        }
        if (!HttpComponentsClientHttpRequestFactory.hasCustomRequestConfig(context)) {
            RequestConfig config = null;
            if (httpRequest instanceof Configurable) {
                Configurable configurable = (Configurable)httpRequest;
                config = configurable.getConfig();
            }
            if (config == null) {
                config = this.createRequestConfig(client);
            }
            if (config != null) {
                if (context instanceof HttpClientContext) {
                    HttpClientContext clientContext = (HttpClientContext)context;
                    clientContext.setRequestConfig(config);
                }
                context.setAttribute("http.request-config", (Object)config);
            }
        }
        return new HttpComponentsClientHttpRequest(client, httpRequest, context);
    }

    private static boolean hasCustomRequestConfig(HttpContext context) {
        if (context instanceof HttpClientContext) {
            HttpClientContext clientContext = (HttpClientContext)context;
            RequestConfig requestConfig = clientContext.getRequestConfig();
            return requestConfig != null && !requestConfig.equals(RequestConfig.DEFAULT);
        }
        return context.getAttribute("http.request-config") != null;
    }

    @Nullable
    protected RequestConfig createRequestConfig(Object client) {
        if (client instanceof Configurable) {
            Configurable configurableClient = (Configurable)client;
            RequestConfig clientRequestConfig = configurableClient.getConfig();
            return this.mergeRequestConfig(clientRequestConfig);
        }
        return this.mergeRequestConfig(RequestConfig.DEFAULT);
    }

    protected RequestConfig mergeRequestConfig(RequestConfig clientConfig) {
        if (this.connectTimeout == -1L && this.connectionRequestTimeout == -1L) {
            return clientConfig;
        }
        RequestConfig.Builder builder = RequestConfig.copy((RequestConfig)clientConfig);
        if (this.connectTimeout >= 0L) {
            builder.setConnectTimeout(this.connectTimeout, TimeUnit.MILLISECONDS);
        }
        if (this.connectionRequestTimeout >= 0L) {
            builder.setConnectionRequestTimeout(this.connectionRequestTimeout, TimeUnit.MILLISECONDS);
        }
        return builder.build();
    }

    protected ClassicHttpRequest createHttpUriRequest(HttpMethod httpMethod, URI uri) {
        if (HttpMethod.GET.equals(httpMethod)) {
            return new HttpGet(uri);
        }
        if (HttpMethod.HEAD.equals(httpMethod)) {
            return new HttpHead(uri);
        }
        if (HttpMethod.POST.equals(httpMethod)) {
            return new HttpPost(uri);
        }
        if (HttpMethod.PUT.equals(httpMethod)) {
            return new HttpPut(uri);
        }
        if (HttpMethod.PATCH.equals(httpMethod)) {
            return new HttpPatch(uri);
        }
        if (HttpMethod.DELETE.equals(httpMethod)) {
            return new HttpDelete(uri);
        }
        if (HttpMethod.OPTIONS.equals(httpMethod)) {
            return new HttpOptions(uri);
        }
        if (HttpMethod.TRACE.equals(httpMethod)) {
            return new HttpTrace(uri);
        }
        throw new IllegalArgumentException("Invalid HTTP method: " + String.valueOf(httpMethod));
    }

    protected void postProcessHttpRequest(ClassicHttpRequest request) {
    }

    @Nullable
    protected HttpContext createHttpContext(HttpMethod httpMethod, URI uri) {
        return this.httpContextFactory != null ? this.httpContextFactory.apply(httpMethod, uri) : null;
    }

    public void destroy() throws Exception {
        HttpClient httpClient = this.getHttpClient();
        if (httpClient instanceof Closeable) {
            Closeable closeable = (Closeable)httpClient;
            closeable.close();
        }
    }
}

