/*
 * Decompiled with CFR 0.152.
 */
package com.axlradius.radclient4.attributes;

import com.axlradius.misc.b;
import com.axlradius.radclient4.attributes.A;
import com.axlradius.radclient4.attributes.AttributeList;
import com.axlradius.radclient4.attributes.VendorSpecific;
import com.axlradius.radclient4.dictionary.BD;
import com.axlradius.radclient4.radutil.Util;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Attribute
extends A {
    private int M = -1;
    protected int tag;
    private boolean f = false;
    protected int length;
    protected byte[] value;
    private int dataType = 0;

    protected Attribute() {
        this.tag = 0;
        this.length = 0;
        this.value = new byte[0];
    }

    public Attribute(int n2, byte[] byArray) {
        this.length = byArray.length + 2;
        if (this.length > 255) {
            this.length = 255;
        }
        this.tag = n2;
        if (byArray == null) {
            this.value = new byte[0];
            return;
        }
        this.value = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.value, 0, byArray.length);
    }

    public Attribute(int n2) {
        this.value = new byte[0];
        this.length = 2;
        this.tag = n2;
    }

    public Attribute(int n2, int n3) {
        this.length = 6;
        this.tag = n2;
        this.value = b.a(n3);
    }

    public Attribute(int n2, String string) {
        this.value = Util.toUTF8(string);
        this.length = 2 + this.value.length;
        this.tag = n2;
    }

    public Attribute(int n2, Date date) {
        this.length = 6;
        this.tag = n2;
        n2 = (int)(date.getTime() / 1000L);
        this.value = b.a(n2);
    }

    public Attribute(int n2, long l2) {
        this.length = 6;
        this.tag = n2;
        n2 = (int)(l2 / 1000L);
        this.value = b.a(n2);
    }

    public Attribute(int n2, InetAddress inetAddress) {
        this.tag = n2;
        this.value = inetAddress.getAddress();
        this.length = this.value.length + 2;
    }

    public Attribute(int n2, int n3, byte[] byArray) {
        this.length = byArray.length + 2 + 1;
        if (this.length > 255) {
            this.length = 255;
        }
        this.tag = n2;
        this.M = n3;
        if (byArray == null) {
            this.value = new byte[0];
            return;
        }
        this.value = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.value, 0, byArray.length);
    }

    public Attribute setLongTag(boolean bl) {
        if (!this.f && bl) {
            ++this.length;
        }
        this.f = bl;
        return this;
    }

    public boolean isLongTag() {
        return this.f;
    }

    public byte[] getAttribute() {
        byte[] byArray = new byte[this.length];
        if (this.M == -1) {
            if (this.f) {
                byArray[0] = (byte)(this.tag >> 8);
                byArray[1] = (byte)this.tag;
                byArray[2] = (byte)this.length;
                System.arraycopy(this.value, 0, byArray, 3, this.value.length);
            } else {
                byArray[0] = (byte)this.tag;
                byArray[1] = (byte)this.length;
                System.arraycopy(this.value, 0, byArray, 2, this.value.length);
            }
        } else {
            byArray[0] = (byte)this.tag;
            byArray[1] = (byte)this.length;
            byArray[2] = (byte)this.M;
            System.arraycopy(this.value, 0, byArray, 3, this.value.length);
        }
        return byArray;
    }

    public int getTag() {
        return this.tag;
    }

    public boolean isTunnelAttribute() {
        return this.M != -1;
    }

    public int getTunnelTag() {
        return this.M;
    }

    public byte[] getTunnelValue() {
        if (this.M == -1) {
            this.convertToTunnel();
        }
        return this.value;
    }

    public int getLength() {
        return this.length;
    }

    public int getDataLength() {
        return this.value.length;
    }

    public byte[] getData() {
        if (this.M == -1) {
            byte[] byArray = new byte[this.value.length];
            System.arraycopy(this.value, 0, byArray, 0, this.value.length);
            return byArray;
        }
        byte[] byArray = new byte[this.value.length + 1];
        byte[] byArray2 = byArray;
        byArray[0] = (byte)this.M;
        System.arraycopy(this.value, 0, byArray2, 1, this.value.length);
        return byArray2;
    }

    public void setAttributeData(byte[] byArray) {
        if (byArray == null) {
            this.value = new byte[0];
            this.length = 2;
            return;
        }
        int n2 = byArray.length;
        this.value = new byte[n2];
        if (n2 > 0) {
            System.arraycopy(byArray, 0, this.value, 0, n2);
        }
        this.length = n2 + 2;
    }

    public int getInt() {
        if (this.value.length != 4) {
            return 0;
        }
        return this.value[0] << 24 | (this.value[1] & 0xFF) << 16 | (this.value[2] & 0xFF) << 8 | this.value[3] & 0xFF;
    }

    public Date getDate() {
        return new Date((long)this.getInt() * 1000L);
    }

    public InetAddress getIP() {
        if (this.value.length != 4 && this.value.length != 16) {
            return null;
        }
        return AttributeList.parseIP(this.value);
    }

    public String getString() {
        return Util.toUTF8(this.value);
    }

    public int getVendorID() {
        if (this.length < 6) {
            return 0;
        }
        return b.a(this.getData());
    }

    public void clean() {
        Util.clean(this.value);
        this.length = 0;
        this.tag = 0;
        this.dataType = 0;
        this.value = null;
    }

    public Attribute copy() {
        byte[] byArray = new byte[this.value.length];
        System.arraycopy(this.value, 0, byArray, 0, this.value.length);
        return new Attribute(this.tag, byArray);
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int n2) {
        if (n2 == 0 && this.tag == 26) {
            try {
                return new VendorSpecific(this).toString();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        }
        byte[] byArray = this.value;
        this.dataType = this.getDataType(n2);
        int n3 = this.getTag();
        String string = BD.lookupTag(n2, n3);
        string = string + " (" + n3;
        if (this.f) {
            string = string + " -long";
        }
        string = string + "), Length: " + (this.f ? this.length - 1 : this.length);
        if (n2 == 0 && (this.dataType & 0x20) == 32) {
            this.convertToTunnel();
            byArray = this.value;
        }
        if (this.M != -1) {
            string = string + ", Tunnel Group: " + this.M;
        }
        if (n3 == 80 && this.getLength() == 2) {
            return string + ", Data: Not Defined Yet.";
        }
        return string + ", " + this.displayData(byArray);
    }

    public String displayData(byte[] byArray) {
        return this.displayData(0, byArray);
    }

    public String displayData(int n2, byte[] byArray) {
        Object object = "";
        object = (String)object + "Data: ";
        if (byArray.length == 0) {
            return (String)object + "None";
        }
        int n3 = BD.getDataType(n2, this.tag);
        if (n3 > 0) {
            switch (n3 & 0x1F) {
                case 1: {
                    StringBuilder stringBuilder = new StringBuilder().append((String)object);
                    object = byArray;
                    Object object2 = this;
                    long l2 = ((Attribute)object2).M != -1 ? (long)b.b((byte[])object) & 0xFFFFFFL : (long)b.a((byte[])object) & 0xFFFFFFFFL;
                    object2 = BD.lookupValue(((Attribute)object2).tag, (int)l2);
                    String string = ((String)object2).length() > 0 ? "(" + (String)object2 + ")" : Long.toString(l2);
                    object = stringBuilder.append(string).toString();
                    this.getInt();
                    break;
                }
                case 2: {
                    break;
                }
                case 4: {
                    StringBuilder stringBuilder = new StringBuilder().append((String)object);
                    byte[] byArray2 = byArray;
                    String string = "";
                    if (Attribute.isPrintable(byArray2, 0, byArray2.length)) {
                        string = "[" + Util.toUTF8(byArray2) + "], ";
                    }
                    object = stringBuilder.append(string).toString();
                    break;
                }
                case 8: {
                    long l3 = ((long)b.a(byArray) & 0xFFFFFFFFL) * 1000L;
                    object = (String)object + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date(l3));
                    break;
                }
                case 16: {
                    object = (String)object + Attribute.toIPString(byArray);
                }
            }
            return (String)object + " 0x" + Util.toHexString(byArray);
        }
        if (Attribute.isPrintable(byArray, 0, byArray.length)) {
            object = (String)object + "[" + Util.toUTF8(byArray) + "], ";
        }
        if (byArray.length == 16) {
            switch (this.tag) {
                case 95: 
                case 96: 
                case 97: 
                case 98: {
                    object = (String)object + "IP " + Attribute.toIPString(byArray) + ", ";
                }
            }
        }
        if (byArray.length == 4) {
            long l4 = (long)b.a(byArray) & 0xFFFFFFFFL;
            String string = BD.lookupValue(n2, this.tag, (int)l4);
            if (!string.equals("")) {
                string = l4 + " (" + string + ")";
                object = (String)object + "[# " + string + "]";
            } else {
                object = l4 >>> 24 == 0L ? (String)object + "[# " + l4 + "]" : (String)object + "[# " + l4 + "] / [IP " + Attribute.toIPString(byArray) + "]";
            }
            object = (String)object + ", ";
        }
        return (String)object + "0x" + Util.toHexString(byArray);
    }

    public boolean isPrintableAscii() {
        return Attribute.isPrintableAscii(this.value);
    }

    public static boolean isPrintableAscii(byte[] byArray) {
        return Attribute.isPrintableAscii(byArray, 0, byArray.length);
    }

    public static boolean isPrintableAscii(byte[] byArray, int n2, int n3) {
        n3 += n2;
        while (n2 < n3 && b.a(byArray[n2])) {
            ++n2;
        }
        return n2 == n3;
    }

    public boolean isPrintable() {
        return Attribute.isPrintable(this.value);
    }

    public static boolean isPrintable(byte[] byArray) {
        return Attribute.isPrintable(byArray, 0, byArray.length);
    }

    public static boolean isPrintable(byte[] byArray, int n2, int n3) {
        int n4;
        char[] cArray = new String(byArray, n2, n3).toCharArray();
        n3 = cArray.length;
        for (n4 = 0; n4 < n3 && !Character.isISOControl(cArray[n4]); ++n4) {
        }
        return n4 == n3;
    }

    public static String toIPString(byte[] byArray) {
        return Attribute.toIPString(byArray, 0);
    }

    public static String toIPString(byte[] byArray, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (byArray.length - n2 == 16) {
            byte[] byArray2 = new byte[16];
            System.arraycopy(byArray, n2, byArray2, 0, 16);
            int n3 = (byArray2[0] & 0xFF) << 8 | byArray2[1] & 0xFF;
            stringBuilder.append(Integer.toHexString(n3)).append(':');
            n3 = (byArray2[2] & 0xFF) << 8 | byArray2[3] & 0xFF;
            stringBuilder.append(Integer.toHexString(n3)).append(':');
            n3 = (byArray2[4] & 0xFF) << 8 | byArray2[5] & 0xFF;
            stringBuilder.append(Integer.toHexString(n3)).append(':');
            n3 = (byArray2[6] & 0xFF) << 8 | byArray2[7] & 0xFF;
            stringBuilder.append(Integer.toHexString(n3)).append(':');
            n3 = (byArray2[8] & 0xFF) << 8 | byArray2[9] & 0xFF;
            stringBuilder.append(Integer.toHexString(n3)).append(':');
            n3 = (byArray2[10] & 0xFF) << 8 | byArray2[11] & 0xFF;
            stringBuilder.append(Integer.toHexString(n3)).append(':');
            stringBuilder.append(byArray2[12] & 0xFF).append('.');
            stringBuilder.append(byArray2[13] & 0xFF).append('.');
            stringBuilder.append(byArray2[14] & 0xFF).append('.');
            stringBuilder.append(byArray2[15] & 0xFF);
        } else {
            stringBuilder.append(byArray[n2] & 0xFF).append('.');
            stringBuilder.append(byArray[n2 + 1] & 0xFF).append('.');
            stringBuilder.append(byArray[n2 + 2] & 0xFF).append('.');
            stringBuilder.append(byArray[n2 + 3] & 0xFF);
        }
        return stringBuilder.toString();
    }

    public void convertToTunnel() {
        byte[] byArray;
        if (this.M != -1) {
            return;
        }
        if (this.value.length > 1) {
            byArray = new byte[this.value.length - 1];
            System.arraycopy(this.value, 1, byArray, 0, byArray.length);
            this.M = this.value[0] & 0xFF;
        } else {
            byArray = new byte[]{};
            this.M = 0;
        }
        this.value = byArray;
    }

    public static String getName(int n2) {
        return BD.lookupTag(n2);
    }

    public String getName() {
        return BD.lookupTag(this.tag);
    }

    public static int getTag(String string) {
        return BD.lookupTag(string);
    }

    public static int getValueName(int n2, String string) {
        return BD.lookupTag(n2, string);
    }

    public String getValueName() {
        if (this.value.length != 4) {
            return null;
        }
        return BD.lookupTag(this.tag, b.a(this.value));
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        object = (Attribute)object;
        if (((Attribute)object).tag != this.tag || ((Attribute)object).length != this.length || ((Attribute)object).M != this.M) {
            return false;
        }
        return Util.cmp(((Attribute)object).value, this.value);
    }

    public int getDataType() {
        this.dataType = this.getDataType(0);
        return this.dataType;
    }

    public int getDataType(int n2) {
        this.dataType = BD.getDataType(n2, this.tag);
        return this.dataType;
    }

    public static int getDataType(int n2, int n3) {
        return BD.getDataType(n2, n3);
    }
}

