/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.ExplainVerbosity;
import com.mongodb.MongoNamespace;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.Collation;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.binding.AsyncWriteBinding;
import com.mongodb.internal.binding.WriteBinding;
import com.mongodb.internal.operation.AsyncOperationHelper;
import com.mongodb.internal.operation.AsyncReadOperation;
import com.mongodb.internal.operation.AsyncWriteOperation;
import com.mongodb.internal.operation.CommandReadOperation;
import com.mongodb.internal.operation.DocumentHelper;
import com.mongodb.internal.operation.ExplainHelper;
import com.mongodb.internal.operation.MapReduceHelper;
import com.mongodb.internal.operation.MapReduceStatistics;
import com.mongodb.internal.operation.OperationHelper;
import com.mongodb.internal.operation.ReadOperation;
import com.mongodb.internal.operation.SyncOperationHelper;
import com.mongodb.internal.operation.WriteConcernHelper;
import com.mongodb.internal.operation.WriteOperation;
import com.mongodb.lang.Nullable;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonJavaScript;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.Decoder;

public class MapReduceToCollectionOperation
implements AsyncWriteOperation<MapReduceStatistics>,
WriteOperation<MapReduceStatistics> {
    private final MongoNamespace namespace;
    private final BsonJavaScript mapFunction;
    private final BsonJavaScript reduceFunction;
    private final String collectionName;
    private final WriteConcern writeConcern;
    private BsonJavaScript finalizeFunction;
    private BsonDocument scope;
    private BsonDocument filter;
    private BsonDocument sort;
    private int limit;
    private boolean jsMode;
    private boolean verbose;
    private long maxTimeMS;
    private String action = "replace";
    private String databaseName;
    private Boolean bypassDocumentValidation;
    private Collation collation;
    private static final List<String> VALID_ACTIONS = Arrays.asList("replace", "merge", "reduce");

    public MapReduceToCollectionOperation(MongoNamespace namespace, BsonJavaScript mapFunction, BsonJavaScript reduceFunction, String collectionName) {
        this(namespace, mapFunction, reduceFunction, collectionName, null);
    }

    public MapReduceToCollectionOperation(MongoNamespace namespace, BsonJavaScript mapFunction, BsonJavaScript reduceFunction, @Nullable String collectionName, @Nullable WriteConcern writeConcern) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.mapFunction = Assertions.notNull("mapFunction", mapFunction);
        this.reduceFunction = Assertions.notNull("reduceFunction", reduceFunction);
        this.collectionName = Assertions.notNull("collectionName", collectionName);
        this.writeConcern = writeConcern;
    }

    public MongoNamespace getNamespace() {
        return this.namespace;
    }

    public BsonJavaScript getMapFunction() {
        return this.mapFunction;
    }

    public BsonJavaScript getReduceFunction() {
        return this.reduceFunction;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    public BsonJavaScript getFinalizeFunction() {
        return this.finalizeFunction;
    }

    public MapReduceToCollectionOperation finalizeFunction(BsonJavaScript finalizeFunction) {
        this.finalizeFunction = finalizeFunction;
        return this;
    }

    public BsonDocument getScope() {
        return this.scope;
    }

    public MapReduceToCollectionOperation scope(@Nullable BsonDocument scope) {
        this.scope = scope;
        return this;
    }

    public BsonDocument getFilter() {
        return this.filter;
    }

    public MapReduceToCollectionOperation filter(@Nullable BsonDocument filter) {
        this.filter = filter;
        return this;
    }

    public BsonDocument getSort() {
        return this.sort;
    }

    public MapReduceToCollectionOperation sort(@Nullable BsonDocument sort) {
        this.sort = sort;
        return this;
    }

    public int getLimit() {
        return this.limit;
    }

    public MapReduceToCollectionOperation limit(int limit) {
        this.limit = limit;
        return this;
    }

    public boolean isJsMode() {
        return this.jsMode;
    }

    public MapReduceToCollectionOperation jsMode(boolean jsMode) {
        this.jsMode = jsMode;
        return this;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public MapReduceToCollectionOperation verbose(boolean verbose) {
        this.verbose = verbose;
        return this;
    }

    public long getMaxTime(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        return timeUnit.convert(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    public MapReduceToCollectionOperation maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    public String getAction() {
        return this.action;
    }

    public MapReduceToCollectionOperation action(String action) {
        Assertions.notNull("action", action);
        Assertions.isTrue("action must be one of: \"replace\", \"merge\", \"reduce\"", VALID_ACTIONS.contains(action));
        this.action = action;
        return this;
    }

    @Nullable
    public String getDatabaseName() {
        return this.databaseName;
    }

    public MapReduceToCollectionOperation databaseName(@Nullable String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    public Boolean getBypassDocumentValidation() {
        return this.bypassDocumentValidation;
    }

    public MapReduceToCollectionOperation bypassDocumentValidation(@Nullable Boolean bypassDocumentValidation) {
        this.bypassDocumentValidation = bypassDocumentValidation;
        return this;
    }

    public Collation getCollation() {
        return this.collation;
    }

    public MapReduceToCollectionOperation collation(@Nullable Collation collation) {
        this.collation = collation;
        return this;
    }

    @Override
    public MapReduceStatistics execute(WriteBinding binding) {
        return SyncOperationHelper.withConnection(binding, connection -> Assertions.assertNotNull(SyncOperationHelper.executeCommand(binding, this.namespace.getDatabaseName(), this.getCommand(connection.getDescription()), connection, this.transformer())));
    }

    @Override
    public void executeAsync(AsyncWriteBinding binding, SingleResultCallback<MapReduceStatistics> callback) {
        AsyncOperationHelper.withAsyncConnection(binding, (connection, t) -> {
            SingleResultCallback<Object> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER);
            if (t != null) {
                errHandlingCallback.onResult(null, t);
            } else {
                AsyncOperationHelper.executeCommandAsync(binding, this.namespace.getDatabaseName(), this.getCommand(connection.getDescription()), connection, this.transformerAsync(), AsyncOperationHelper.releasingCallback(errHandlingCallback, connection));
            }
        });
    }

    public ReadOperation<BsonDocument> asExplainableOperation(ExplainVerbosity explainVerbosity) {
        return this.createExplainableOperation(explainVerbosity);
    }

    public AsyncReadOperation<BsonDocument> asExplainableOperationAsync(ExplainVerbosity explainVerbosity) {
        return this.createExplainableOperation(explainVerbosity);
    }

    private CommandReadOperation<BsonDocument> createExplainableOperation(ExplainVerbosity explainVerbosity) {
        return new CommandReadOperation<BsonDocument>(this.namespace.getDatabaseName(), ExplainHelper.asExplainCommand(this.getCommand(null), explainVerbosity), (Decoder<BsonDocument>)new BsonDocumentCodec());
    }

    private SyncOperationHelper.CommandWriteTransformer<BsonDocument, MapReduceStatistics> transformer() {
        return (result, connection) -> {
            WriteConcernHelper.throwOnWriteConcernError(result, connection.getDescription().getServerAddress(), connection.getDescription().getMaxWireVersion());
            return MapReduceHelper.createStatistics(result);
        };
    }

    private AsyncOperationHelper.CommandWriteTransformerAsync<BsonDocument, MapReduceStatistics> transformerAsync() {
        return (result, connection) -> {
            WriteConcernHelper.throwOnWriteConcernError(result, connection.getDescription().getServerAddress(), connection.getDescription().getMaxWireVersion());
            return MapReduceHelper.createStatistics(result);
        };
    }

    private BsonDocument getCommand(@Nullable ConnectionDescription description) {
        BsonDocument outputDocument = new BsonDocument(this.getAction(), (BsonValue)new BsonString(this.getCollectionName()));
        if (this.getDatabaseName() != null) {
            outputDocument.put("db", (BsonValue)new BsonString(this.getDatabaseName()));
        }
        BsonDocument commandDocument = new BsonDocument("mapreduce", (BsonValue)new BsonString(this.namespace.getCollectionName())).append("map", (BsonValue)this.getMapFunction()).append("reduce", (BsonValue)this.getReduceFunction()).append("out", (BsonValue)outputDocument);
        DocumentHelper.putIfNotNull(commandDocument, "query", (BsonValue)this.getFilter());
        DocumentHelper.putIfNotNull(commandDocument, "sort", (BsonValue)this.getSort());
        DocumentHelper.putIfNotNull(commandDocument, "finalize", (BsonValue)this.getFinalizeFunction());
        DocumentHelper.putIfNotNull(commandDocument, "scope", (BsonValue)this.getScope());
        DocumentHelper.putIfTrue(commandDocument, "verbose", this.isVerbose());
        DocumentHelper.putIfNotZero(commandDocument, "limit", this.getLimit());
        DocumentHelper.putIfNotZero(commandDocument, "maxTimeMS", this.getMaxTime(TimeUnit.MILLISECONDS));
        DocumentHelper.putIfTrue(commandDocument, "jsMode", this.isJsMode());
        if (this.bypassDocumentValidation != null && description != null) {
            commandDocument.put("bypassDocumentValidation", (BsonValue)BsonBoolean.valueOf((boolean)this.bypassDocumentValidation));
        }
        if (description != null) {
            WriteConcernHelper.appendWriteConcernToCommand(this.writeConcern, commandDocument);
        }
        if (this.collation != null) {
            commandDocument.put("collation", (BsonValue)this.collation.asDocument());
        }
        return commandDocument;
    }
}

