/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import java.util.Collections;
import java.util.List;
import org.springframework.data.mongodb.core.aggregation.AbstractAggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationExpression;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.util.Assert;

public class ComparisonOperators {
    public static ComparisonOperatorFactory valueOf(String fieldReference) {
        return new ComparisonOperatorFactory(fieldReference);
    }

    public static ComparisonOperatorFactory valueOf(AggregationExpression expression) {
        return new ComparisonOperatorFactory(expression);
    }

    public static class ComparisonOperatorFactory {
        private final String fieldReference;
        private final AggregationExpression expression;

        public ComparisonOperatorFactory(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null");
            this.fieldReference = fieldReference;
            this.expression = null;
        }

        public ComparisonOperatorFactory(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null");
            this.fieldReference = null;
            this.expression = expression;
        }

        public Cmp compareTo(String fieldReference) {
            return this.createCmp().compareTo(fieldReference);
        }

        public Cmp compareTo(AggregationExpression expression) {
            return this.createCmp().compareTo(expression);
        }

        public Cmp compareToValue(Object value) {
            return this.createCmp().compareToValue(value);
        }

        private Cmp createCmp() {
            return this.usesFieldRef() ? Cmp.valueOf(this.fieldReference) : Cmp.valueOf(this.expression);
        }

        public Eq equalTo(String fieldReference) {
            return this.createEq().equalTo(fieldReference);
        }

        public Eq equalTo(AggregationExpression expression) {
            return this.createEq().equalTo(expression);
        }

        public Eq equalToValue(Object value) {
            return this.createEq().equalToValue(value);
        }

        private Eq createEq() {
            return this.usesFieldRef() ? Eq.valueOf(this.fieldReference) : Eq.valueOf(this.expression);
        }

        public Gt greaterThan(String fieldReference) {
            return this.createGt().greaterThan(fieldReference);
        }

        public Gt greaterThan(AggregationExpression expression) {
            return this.createGt().greaterThan(expression);
        }

        public Gt greaterThanValue(Object value) {
            return this.createGt().greaterThanValue(value);
        }

        private Gt createGt() {
            return this.usesFieldRef() ? Gt.valueOf(this.fieldReference) : Gt.valueOf(this.expression);
        }

        public Gte greaterThanEqualTo(String fieldReference) {
            return this.createGte().greaterThanEqualTo(fieldReference);
        }

        public Gte greaterThanEqualTo(AggregationExpression expression) {
            return this.createGte().greaterThanEqualTo(expression);
        }

        public Gte greaterThanEqualToValue(Object value) {
            return this.createGte().greaterThanEqualToValue(value);
        }

        private Gte createGte() {
            return this.usesFieldRef() ? Gte.valueOf(this.fieldReference) : Gte.valueOf(this.expression);
        }

        public Lt lessThan(String fieldReference) {
            return this.createLt().lessThan(fieldReference);
        }

        public Lt lessThan(AggregationExpression expression) {
            return this.createLt().lessThan(expression);
        }

        public Lt lessThanValue(Object value) {
            return this.createLt().lessThanValue(value);
        }

        private Lt createLt() {
            return this.usesFieldRef() ? Lt.valueOf(this.fieldReference) : Lt.valueOf(this.expression);
        }

        public Lte lessThanEqualTo(String fieldReference) {
            return this.createLte().lessThanEqualTo(fieldReference);
        }

        public Lte lessThanEqualTo(AggregationExpression expression) {
            return this.createLte().lessThanEqualTo(expression);
        }

        public Lte lessThanEqualToValue(Object value) {
            return this.createLte().lessThanEqualToValue(value);
        }

        private Lte createLte() {
            return this.usesFieldRef() ? Lte.valueOf(this.fieldReference) : Lte.valueOf(this.expression);
        }

        public Ne notEqualTo(String fieldReference) {
            return this.createNe().notEqualTo(fieldReference);
        }

        public Ne notEqualTo(AggregationExpression expression) {
            return this.createNe().notEqualTo(expression);
        }

        public Ne notEqualToValue(Object value) {
            return this.createNe().notEqualToValue(value);
        }

        private Ne createNe() {
            return this.usesFieldRef() ? Ne.valueOf(this.fieldReference) : Ne.valueOf(this.expression);
        }

        private boolean usesFieldRef() {
            return this.fieldReference != null;
        }
    }

    public static class Ne
    extends AbstractAggregationExpression {
        private Ne(List<?> value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$ne";
        }

        public static Ne valueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null");
            return new Ne(Ne.asFields(fieldReference));
        }

        public static Ne valueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null");
            return new Ne(Collections.singletonList(expression));
        }

        public Ne notEqualTo(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null");
            return new Ne(this.append(Fields.field(fieldReference)));
        }

        public Ne notEqualTo(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null");
            return new Ne(this.append(expression));
        }

        public Ne notEqualToValue(Object value) {
            Assert.notNull((Object)value, (String)"Value must not be null");
            return new Ne(this.append(value, AbstractAggregationExpression.Expand.KEEP_SOURCE));
        }
    }

    public static class Lte
    extends AbstractAggregationExpression {
        private Lte(List<?> value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$lte";
        }

        public static Lte valueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null");
            return new Lte(Lte.asFields(fieldReference));
        }

        public static Lte valueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null");
            return new Lte(Collections.singletonList(expression));
        }

        public Lte lessThanEqualTo(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null");
            return new Lte(this.append(Fields.field(fieldReference)));
        }

        public Lte lessThanEqualTo(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null");
            return new Lte(this.append(expression));
        }

        public Lte lessThanEqualToValue(Object value) {
            Assert.notNull((Object)value, (String)"Value must not be null");
            return new Lte(this.append(value));
        }
    }

    public static class Gte
    extends AbstractAggregationExpression {
        private Gte(List<?> value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$gte";
        }

        public static Gte valueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null");
            return new Gte(Gte.asFields(fieldReference));
        }

        public static Gte valueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null");
            return new Gte(Collections.singletonList(expression));
        }

        public Gte greaterThanEqualTo(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null");
            return new Gte(this.append(Fields.field(fieldReference)));
        }

        public Gte greaterThanEqualTo(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null");
            return new Gte(this.append(expression));
        }

        public Gte greaterThanEqualToValue(Object value) {
            Assert.notNull((Object)value, (String)"Value must not be null");
            return new Gte(this.append(value));
        }
    }

    public static class Lt
    extends AbstractAggregationExpression {
        private Lt(List<?> value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$lt";
        }

        public static Lt valueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null");
            return new Lt(Lt.asFields(fieldReference));
        }

        public static Lt valueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null");
            return new Lt(Collections.singletonList(expression));
        }

        public Lt lessThan(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null");
            return new Lt(this.append(Fields.field(fieldReference)));
        }

        public Lt lessThan(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null");
            return new Lt(this.append(expression));
        }

        public Lt lessThanValue(Object value) {
            Assert.notNull((Object)value, (String)"Value must not be null");
            return new Lt(this.append(value));
        }
    }

    public static class Gt
    extends AbstractAggregationExpression {
        private Gt(List<?> value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$gt";
        }

        public static Gt valueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null");
            return new Gt(Gt.asFields(fieldReference));
        }

        public static Gt valueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null");
            return new Gt(Collections.singletonList(expression));
        }

        public Gt greaterThan(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null");
            return new Gt(this.append(Fields.field(fieldReference)));
        }

        public Gt greaterThan(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null");
            return new Gt(this.append(expression));
        }

        public Gt greaterThanValue(Object value) {
            Assert.notNull((Object)value, (String)"Value must not be null");
            return new Gt(this.append(value));
        }
    }

    public static class Eq
    extends AbstractAggregationExpression {
        private Eq(List<?> value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$eq";
        }

        public static Eq valueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null");
            return new Eq(Eq.asFields(fieldReference));
        }

        public static Eq valueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null");
            return new Eq(Collections.singletonList(expression));
        }

        public Eq equalTo(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null");
            return new Eq(this.append(Fields.field(fieldReference)));
        }

        public Eq equalTo(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null");
            return new Eq(this.append(expression));
        }

        public Eq equalToValue(Object value) {
            Assert.notNull((Object)value, (String)"Value must not be null");
            return new Eq(this.append(value, AbstractAggregationExpression.Expand.KEEP_SOURCE));
        }
    }

    public static class Cmp
    extends AbstractAggregationExpression {
        private Cmp(List<?> value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$cmp";
        }

        public static Cmp valueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null");
            return new Cmp(Cmp.asFields(fieldReference));
        }

        public static Cmp valueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null");
            return new Cmp(Collections.singletonList(expression));
        }

        public Cmp compareTo(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null");
            return new Cmp(this.append(Fields.field(fieldReference)));
        }

        public Cmp compareTo(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null");
            return new Cmp(this.append(expression));
        }

        public Cmp compareToValue(Object value) {
            Assert.notNull((Object)value, (String)"Value must not be null");
            return new Cmp(this.append(value, AbstractAggregationExpression.Expand.KEEP_SOURCE));
        }
    }
}

