/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.path;

import com.networknt.schema.path.Path;
import com.networknt.schema.path.PathType;
import java.util.ArrayDeque;
import java.util.Objects;

public class NodePath
implements Comparable<NodePath>,
Path {
    private final PathType type;
    private final NodePath parent;
    private final String pathSegment;
    private final int pathSegmentIndex;
    private volatile String value = null;
    private int hash = 0;

    public NodePath(PathType type) {
        this.type = type;
        this.parent = null;
        this.pathSegment = null;
        this.pathSegmentIndex = -1;
    }

    private NodePath(NodePath parent, String pathSegment) {
        this.parent = parent;
        this.type = parent.type;
        this.pathSegment = pathSegment;
        this.pathSegmentIndex = -1;
    }

    private NodePath(NodePath parent, int pathSegmentIndex) {
        this.parent = parent;
        this.type = parent.type;
        this.pathSegment = null;
        this.pathSegmentIndex = pathSegmentIndex;
    }

    public NodePath getParent() {
        return this.parent;
    }

    public NodePath append(String token) {
        return new NodePath(this, token);
    }

    public NodePath append(int index) {
        return new NodePath(this, index);
    }

    public PathType getPathType() {
        return this.type;
    }

    public String getName(int index) {
        Object element = this.getElement(index);
        if (element != null) {
            return element.toString();
        }
        return null;
    }

    public Object getElement(int index) {
        if (index == -1) {
            if (this.pathSegmentIndex != -1) {
                return this.pathSegmentIndex;
            }
            return this.pathSegment;
        }
        int nameCount = this.getNameCount();
        if (nameCount - 1 == index) {
            return this.getElement(-1);
        }
        int count = nameCount - index - 1;
        if (count < 0) {
            throw new IllegalArgumentException("");
        }
        NodePath current = this;
        for (int x = 0; x < count; ++x) {
            current = current.parent;
        }
        return current.getElement(-1);
    }

    public int getNameCount() {
        int current = this.pathSegmentIndex == -1 && this.pathSegment == null ? 0 : 1;
        int parent = this.parent != null ? this.parent.getNameCount() : 0;
        return current + parent;
    }

    public boolean startsWith(NodePath other) {
        int count = this.getNameCount();
        int otherCount = other.getNameCount();
        if (otherCount > count) {
            return false;
        }
        if (otherCount == count) {
            return this.equals(other);
        }
        NodePath compare = this;
        for (int x = count - otherCount; x > 0; --x) {
            compare = compare.getParent();
        }
        return other.equals(compare);
    }

    public boolean contains(String segment) {
        boolean result = segment.equals(this.pathSegment);
        if (result) {
            return true;
        }
        for (NodePath path = this.getParent(); path != null; path = path.getParent()) {
            if (!segment.equals(path.pathSegment)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        if (this.value == null) {
            if (this.pathSegmentIndex == -1 && this.pathSegment == null) {
                this.value = this.type.getRoot();
                return this.value;
            }
            ArrayDeque<Object> pathSegments = new ArrayDeque<Object>();
            if (this.pathSegmentIndex != -1) {
                pathSegments.push(this.pathSegmentIndex);
            } else if (this.pathSegment != null) {
                pathSegments.push(this.pathSegment);
            }
            for (NodePath parent = this.getParent(); parent != null; parent = parent.getParent()) {
                if (parent.pathSegmentIndex != -1) {
                    pathSegments.push(parent.pathSegmentIndex);
                    continue;
                }
                if (parent.pathSegment == null) continue;
                pathSegments.push(parent.pathSegment);
            }
            StringBuilder builder = new StringBuilder();
            String root = this.type.getRoot();
            if (root != null) {
                builder.append(root);
            }
            for (Object e : pathSegments) {
                if (e instanceof Number) {
                    this.type.append(builder, ((Number)e).intValue());
                    continue;
                }
                this.type.append(builder, e.toString());
            }
            this.value = builder.toString();
        }
        return this.value;
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            this.hash = h = Objects.hash(new Object[]{this.parent, this.pathSegment, this.pathSegmentIndex, this.type});
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NodePath other = (NodePath)obj;
        return Objects.equals(this.pathSegment, other.pathSegment) && this.pathSegmentIndex == other.pathSegmentIndex && this.type == other.type && Objects.equals(this.parent, other.parent);
    }

    @Override
    public int compareTo(NodePath other) {
        int result;
        if (this.parent != null && other.parent == null) {
            return 1;
        }
        if (this.parent == null && other.parent != null) {
            return -1;
        }
        if (this.parent != null && other.parent != null && (result = this.parent.compareTo(other.parent)) != 0) {
            return result;
        }
        String thisValue = this.getName(-1);
        String otherValue = other.getName(-1);
        if (thisValue == null && otherValue == null) {
            return 0;
        }
        if (thisValue != null && otherValue == null) {
            return 1;
        }
        if (thisValue == null && otherValue != null) {
            return -1;
        }
        return thisValue.compareTo(otherValue);
    }
}

