/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.mcf;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import redis.clients.jedis.annots.Experimental;
import redis.clients.jedis.mcf.MultiDbConnectionProvider;
import redis.clients.jedis.mcf.SwitchReason;
import redis.clients.jedis.util.IOUtils;

@Experimental
public class MultiDbFailoverBase
implements AutoCloseable {
    private final Lock lock = new ReentrantLock(true);
    protected final MultiDbConnectionProvider provider;

    public MultiDbFailoverBase(MultiDbConnectionProvider provider) {
        this.provider = provider;
    }

    @Override
    public void close() {
        IOUtils.closeQuietly(this.provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void databaseFailover(MultiDbConnectionProvider.Database database) {
        this.lock.lock();
        CircuitBreaker circuitBreaker = database.getCircuitBreaker();
        try {
            if (!CircuitBreaker.State.FORCED_OPEN.equals((Object)circuitBreaker.getState())) {
                MultiDbConnectionProvider.Database activeDatabase = this.provider.getDatabase();
                if (activeDatabase != database) {
                    return;
                }
                database.setGracePeriod();
                circuitBreaker.transitionToForcedOpenState();
                this.provider.switchToHealthyDatabase(SwitchReason.CIRCUIT_BREAKER, database);
            } else if (database == this.provider.getDatabase()) {
                this.provider.switchToHealthyDatabase(SwitchReason.CIRCUIT_BREAKER, database);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    boolean isActiveDatabase(MultiDbConnectionProvider.Database database) {
        MultiDbConnectionProvider.Database activeDatabase = this.provider.getDatabase();
        return activeDatabase != null && activeDatabase.equals(database);
    }

    static boolean isCircuitBreakerTrackedException(Exception e, MultiDbConnectionProvider.Database database) {
        return database.getCircuitBreaker().getCircuitBreakerConfig().getRecordExceptionPredicate().test(e);
    }
}

