// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/area120/tables/v1alpha1/tables.proto

package tablespb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	TablesService_GetTable_FullMethodName        = "/google.area120.tables.v1alpha1.TablesService/GetTable"
	TablesService_ListTables_FullMethodName      = "/google.area120.tables.v1alpha1.TablesService/ListTables"
	TablesService_GetWorkspace_FullMethodName    = "/google.area120.tables.v1alpha1.TablesService/GetWorkspace"
	TablesService_ListWorkspaces_FullMethodName  = "/google.area120.tables.v1alpha1.TablesService/ListWorkspaces"
	TablesService_GetRow_FullMethodName          = "/google.area120.tables.v1alpha1.TablesService/GetRow"
	TablesService_ListRows_FullMethodName        = "/google.area120.tables.v1alpha1.TablesService/ListRows"
	TablesService_CreateRow_FullMethodName       = "/google.area120.tables.v1alpha1.TablesService/CreateRow"
	TablesService_BatchCreateRows_FullMethodName = "/google.area120.tables.v1alpha1.TablesService/BatchCreateRows"
	TablesService_UpdateRow_FullMethodName       = "/google.area120.tables.v1alpha1.TablesService/UpdateRow"
	TablesService_BatchUpdateRows_FullMethodName = "/google.area120.tables.v1alpha1.TablesService/BatchUpdateRows"
	TablesService_DeleteRow_FullMethodName       = "/google.area120.tables.v1alpha1.TablesService/DeleteRow"
	TablesService_BatchDeleteRows_FullMethodName = "/google.area120.tables.v1alpha1.TablesService/BatchDeleteRows"
)

// TablesServiceClient is the client API for TablesService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type TablesServiceClient interface {
	// Gets a table. Returns NOT_FOUND if the table does not exist.
	GetTable(ctx context.Context, in *GetTableRequest, opts ...grpc.CallOption) (*Table, error)
	// Lists tables for the user.
	ListTables(ctx context.Context, in *ListTablesRequest, opts ...grpc.CallOption) (*ListTablesResponse, error)
	// Gets a workspace. Returns NOT_FOUND if the workspace does not exist.
	GetWorkspace(ctx context.Context, in *GetWorkspaceRequest, opts ...grpc.CallOption) (*Workspace, error)
	// Lists workspaces for the user.
	ListWorkspaces(ctx context.Context, in *ListWorkspacesRequest, opts ...grpc.CallOption) (*ListWorkspacesResponse, error)
	// Gets a row. Returns NOT_FOUND if the row does not exist in the table.
	GetRow(ctx context.Context, in *GetRowRequest, opts ...grpc.CallOption) (*Row, error)
	// Lists rows in a table. Returns NOT_FOUND if the table does not exist.
	ListRows(ctx context.Context, in *ListRowsRequest, opts ...grpc.CallOption) (*ListRowsResponse, error)
	// Creates a row.
	CreateRow(ctx context.Context, in *CreateRowRequest, opts ...grpc.CallOption) (*Row, error)
	// Creates multiple rows.
	BatchCreateRows(ctx context.Context, in *BatchCreateRowsRequest, opts ...grpc.CallOption) (*BatchCreateRowsResponse, error)
	// Updates a row.
	UpdateRow(ctx context.Context, in *UpdateRowRequest, opts ...grpc.CallOption) (*Row, error)
	// Updates multiple rows.
	BatchUpdateRows(ctx context.Context, in *BatchUpdateRowsRequest, opts ...grpc.CallOption) (*BatchUpdateRowsResponse, error)
	// Deletes a row.
	DeleteRow(ctx context.Context, in *DeleteRowRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Deletes multiple rows.
	BatchDeleteRows(ctx context.Context, in *BatchDeleteRowsRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type tablesServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewTablesServiceClient(cc grpc.ClientConnInterface) TablesServiceClient {
	return &tablesServiceClient{cc}
}

func (c *tablesServiceClient) GetTable(ctx context.Context, in *GetTableRequest, opts ...grpc.CallOption) (*Table, error) {
	out := new(Table)
	err := c.cc.Invoke(ctx, TablesService_GetTable_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tablesServiceClient) ListTables(ctx context.Context, in *ListTablesRequest, opts ...grpc.CallOption) (*ListTablesResponse, error) {
	out := new(ListTablesResponse)
	err := c.cc.Invoke(ctx, TablesService_ListTables_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tablesServiceClient) GetWorkspace(ctx context.Context, in *GetWorkspaceRequest, opts ...grpc.CallOption) (*Workspace, error) {
	out := new(Workspace)
	err := c.cc.Invoke(ctx, TablesService_GetWorkspace_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tablesServiceClient) ListWorkspaces(ctx context.Context, in *ListWorkspacesRequest, opts ...grpc.CallOption) (*ListWorkspacesResponse, error) {
	out := new(ListWorkspacesResponse)
	err := c.cc.Invoke(ctx, TablesService_ListWorkspaces_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tablesServiceClient) GetRow(ctx context.Context, in *GetRowRequest, opts ...grpc.CallOption) (*Row, error) {
	out := new(Row)
	err := c.cc.Invoke(ctx, TablesService_GetRow_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tablesServiceClient) ListRows(ctx context.Context, in *ListRowsRequest, opts ...grpc.CallOption) (*ListRowsResponse, error) {
	out := new(ListRowsResponse)
	err := c.cc.Invoke(ctx, TablesService_ListRows_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tablesServiceClient) CreateRow(ctx context.Context, in *CreateRowRequest, opts ...grpc.CallOption) (*Row, error) {
	out := new(Row)
	err := c.cc.Invoke(ctx, TablesService_CreateRow_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tablesServiceClient) BatchCreateRows(ctx context.Context, in *BatchCreateRowsRequest, opts ...grpc.CallOption) (*BatchCreateRowsResponse, error) {
	out := new(BatchCreateRowsResponse)
	err := c.cc.Invoke(ctx, TablesService_BatchCreateRows_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tablesServiceClient) UpdateRow(ctx context.Context, in *UpdateRowRequest, opts ...grpc.CallOption) (*Row, error) {
	out := new(Row)
	err := c.cc.Invoke(ctx, TablesService_UpdateRow_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tablesServiceClient) BatchUpdateRows(ctx context.Context, in *BatchUpdateRowsRequest, opts ...grpc.CallOption) (*BatchUpdateRowsResponse, error) {
	out := new(BatchUpdateRowsResponse)
	err := c.cc.Invoke(ctx, TablesService_BatchUpdateRows_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tablesServiceClient) DeleteRow(ctx context.Context, in *DeleteRowRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, TablesService_DeleteRow_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tablesServiceClient) BatchDeleteRows(ctx context.Context, in *BatchDeleteRowsRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, TablesService_BatchDeleteRows_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// TablesServiceServer is the server API for TablesService service.
// All implementations should embed UnimplementedTablesServiceServer
// for forward compatibility
type TablesServiceServer interface {
	// Gets a table. Returns NOT_FOUND if the table does not exist.
	GetTable(context.Context, *GetTableRequest) (*Table, error)
	// Lists tables for the user.
	ListTables(context.Context, *ListTablesRequest) (*ListTablesResponse, error)
	// Gets a workspace. Returns NOT_FOUND if the workspace does not exist.
	GetWorkspace(context.Context, *GetWorkspaceRequest) (*Workspace, error)
	// Lists workspaces for the user.
	ListWorkspaces(context.Context, *ListWorkspacesRequest) (*ListWorkspacesResponse, error)
	// Gets a row. Returns NOT_FOUND if the row does not exist in the table.
	GetRow(context.Context, *GetRowRequest) (*Row, error)
	// Lists rows in a table. Returns NOT_FOUND if the table does not exist.
	ListRows(context.Context, *ListRowsRequest) (*ListRowsResponse, error)
	// Creates a row.
	CreateRow(context.Context, *CreateRowRequest) (*Row, error)
	// Creates multiple rows.
	BatchCreateRows(context.Context, *BatchCreateRowsRequest) (*BatchCreateRowsResponse, error)
	// Updates a row.
	UpdateRow(context.Context, *UpdateRowRequest) (*Row, error)
	// Updates multiple rows.
	BatchUpdateRows(context.Context, *BatchUpdateRowsRequest) (*BatchUpdateRowsResponse, error)
	// Deletes a row.
	DeleteRow(context.Context, *DeleteRowRequest) (*emptypb.Empty, error)
	// Deletes multiple rows.
	BatchDeleteRows(context.Context, *BatchDeleteRowsRequest) (*emptypb.Empty, error)
}

// UnimplementedTablesServiceServer should be embedded to have forward compatible implementations.
type UnimplementedTablesServiceServer struct {
}

func (UnimplementedTablesServiceServer) GetTable(context.Context, *GetTableRequest) (*Table, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTable not implemented")
}
func (UnimplementedTablesServiceServer) ListTables(context.Context, *ListTablesRequest) (*ListTablesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTables not implemented")
}
func (UnimplementedTablesServiceServer) GetWorkspace(context.Context, *GetWorkspaceRequest) (*Workspace, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetWorkspace not implemented")
}
func (UnimplementedTablesServiceServer) ListWorkspaces(context.Context, *ListWorkspacesRequest) (*ListWorkspacesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListWorkspaces not implemented")
}
func (UnimplementedTablesServiceServer) GetRow(context.Context, *GetRowRequest) (*Row, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRow not implemented")
}
func (UnimplementedTablesServiceServer) ListRows(context.Context, *ListRowsRequest) (*ListRowsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRows not implemented")
}
func (UnimplementedTablesServiceServer) CreateRow(context.Context, *CreateRowRequest) (*Row, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateRow not implemented")
}
func (UnimplementedTablesServiceServer) BatchCreateRows(context.Context, *BatchCreateRowsRequest) (*BatchCreateRowsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchCreateRows not implemented")
}
func (UnimplementedTablesServiceServer) UpdateRow(context.Context, *UpdateRowRequest) (*Row, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateRow not implemented")
}
func (UnimplementedTablesServiceServer) BatchUpdateRows(context.Context, *BatchUpdateRowsRequest) (*BatchUpdateRowsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchUpdateRows not implemented")
}
func (UnimplementedTablesServiceServer) DeleteRow(context.Context, *DeleteRowRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteRow not implemented")
}
func (UnimplementedTablesServiceServer) BatchDeleteRows(context.Context, *BatchDeleteRowsRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchDeleteRows not implemented")
}

// UnsafeTablesServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to TablesServiceServer will
// result in compilation errors.
type UnsafeTablesServiceServer interface {
	mustEmbedUnimplementedTablesServiceServer()
}

func RegisterTablesServiceServer(s grpc.ServiceRegistrar, srv TablesServiceServer) {
	s.RegisterService(&TablesService_ServiceDesc, srv)
}

func _TablesService_GetTable_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTableRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TablesServiceServer).GetTable(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TablesService_GetTable_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TablesServiceServer).GetTable(ctx, req.(*GetTableRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TablesService_ListTables_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTablesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TablesServiceServer).ListTables(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TablesService_ListTables_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TablesServiceServer).ListTables(ctx, req.(*ListTablesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TablesService_GetWorkspace_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetWorkspaceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TablesServiceServer).GetWorkspace(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TablesService_GetWorkspace_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TablesServiceServer).GetWorkspace(ctx, req.(*GetWorkspaceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TablesService_ListWorkspaces_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListWorkspacesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TablesServiceServer).ListWorkspaces(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TablesService_ListWorkspaces_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TablesServiceServer).ListWorkspaces(ctx, req.(*ListWorkspacesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TablesService_GetRow_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRowRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TablesServiceServer).GetRow(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TablesService_GetRow_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TablesServiceServer).GetRow(ctx, req.(*GetRowRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TablesService_ListRows_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRowsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TablesServiceServer).ListRows(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TablesService_ListRows_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TablesServiceServer).ListRows(ctx, req.(*ListRowsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TablesService_CreateRow_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateRowRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TablesServiceServer).CreateRow(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TablesService_CreateRow_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TablesServiceServer).CreateRow(ctx, req.(*CreateRowRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TablesService_BatchCreateRows_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchCreateRowsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TablesServiceServer).BatchCreateRows(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TablesService_BatchCreateRows_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TablesServiceServer).BatchCreateRows(ctx, req.(*BatchCreateRowsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TablesService_UpdateRow_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateRowRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TablesServiceServer).UpdateRow(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TablesService_UpdateRow_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TablesServiceServer).UpdateRow(ctx, req.(*UpdateRowRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TablesService_BatchUpdateRows_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchUpdateRowsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TablesServiceServer).BatchUpdateRows(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TablesService_BatchUpdateRows_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TablesServiceServer).BatchUpdateRows(ctx, req.(*BatchUpdateRowsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TablesService_DeleteRow_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteRowRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TablesServiceServer).DeleteRow(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TablesService_DeleteRow_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TablesServiceServer).DeleteRow(ctx, req.(*DeleteRowRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TablesService_BatchDeleteRows_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchDeleteRowsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TablesServiceServer).BatchDeleteRows(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TablesService_BatchDeleteRows_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TablesServiceServer).BatchDeleteRows(ctx, req.(*BatchDeleteRowsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// TablesService_ServiceDesc is the grpc.ServiceDesc for TablesService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var TablesService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.area120.tables.v1alpha1.TablesService",
	HandlerType: (*TablesServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetTable",
			Handler:    _TablesService_GetTable_Handler,
		},
		{
			MethodName: "ListTables",
			Handler:    _TablesService_ListTables_Handler,
		},
		{
			MethodName: "GetWorkspace",
			Handler:    _TablesService_GetWorkspace_Handler,
		},
		{
			MethodName: "ListWorkspaces",
			Handler:    _TablesService_ListWorkspaces_Handler,
		},
		{
			MethodName: "GetRow",
			Handler:    _TablesService_GetRow_Handler,
		},
		{
			MethodName: "ListRows",
			Handler:    _TablesService_ListRows_Handler,
		},
		{
			MethodName: "CreateRow",
			Handler:    _TablesService_CreateRow_Handler,
		},
		{
			MethodName: "BatchCreateRows",
			Handler:    _TablesService_BatchCreateRows_Handler,
		},
		{
			MethodName: "UpdateRow",
			Handler:    _TablesService_UpdateRow_Handler,
		},
		{
			MethodName: "BatchUpdateRows",
			Handler:    _TablesService_BatchUpdateRows_Handler,
		},
		{
			MethodName: "DeleteRow",
			Handler:    _TablesService_DeleteRow_Handler,
		},
		{
			MethodName: "BatchDeleteRows",
			Handler:    _TablesService_BatchDeleteRows_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/area120/tables/v1alpha1/tables.proto",
}
