// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/dialogflow/cx/v3beta1/safety_settings.proto

package cxpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Strategy for matching phrases.
type SafetySettings_PhraseMatchStrategy int32

const (
	// Unspecified, defaults to PARTIAL_MATCH.
	SafetySettings_PHRASE_MATCH_STRATEGY_UNSPECIFIED SafetySettings_PhraseMatchStrategy = 0
	// Text that contains the phrase as a substring will be matched, e.g. "foo"
	// will match "afoobar".
	SafetySettings_PARTIAL_MATCH SafetySettings_PhraseMatchStrategy = 1
	// Text that contains the tokenized words of the phrase will be matched,
	// e.g. "foo" will match "a foo bar" and "foo bar", but not "foobar".
	SafetySettings_WORD_MATCH SafetySettings_PhraseMatchStrategy = 2
)

// Enum value maps for SafetySettings_PhraseMatchStrategy.
var (
	SafetySettings_PhraseMatchStrategy_name = map[int32]string{
		0: "PHRASE_MATCH_STRATEGY_UNSPECIFIED",
		1: "PARTIAL_MATCH",
		2: "WORD_MATCH",
	}
	SafetySettings_PhraseMatchStrategy_value = map[string]int32{
		"PHRASE_MATCH_STRATEGY_UNSPECIFIED": 0,
		"PARTIAL_MATCH":                     1,
		"WORD_MATCH":                        2,
	}
)

func (x SafetySettings_PhraseMatchStrategy) Enum() *SafetySettings_PhraseMatchStrategy {
	p := new(SafetySettings_PhraseMatchStrategy)
	*p = x
	return p
}

func (x SafetySettings_PhraseMatchStrategy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SafetySettings_PhraseMatchStrategy) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_cx_v3beta1_safety_settings_proto_enumTypes[0].Descriptor()
}

func (SafetySettings_PhraseMatchStrategy) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_cx_v3beta1_safety_settings_proto_enumTypes[0]
}

func (x SafetySettings_PhraseMatchStrategy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SafetySettings_PhraseMatchStrategy.Descriptor instead.
func (SafetySettings_PhraseMatchStrategy) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_safety_settings_proto_rawDescGZIP(), []int{0, 0}
}

// Sensitivity level for RAI categories.
type SafetySettings_RaiSettings_SafetyFilterLevel int32

const (
	// Unspecified -- uses default sensitivity levels.
	SafetySettings_RaiSettings_SAFETY_FILTER_LEVEL_UNSPECIFIED SafetySettings_RaiSettings_SafetyFilterLevel = 0
	// Block no text -- effectively disables the category.
	SafetySettings_RaiSettings_BLOCK_NONE SafetySettings_RaiSettings_SafetyFilterLevel = 1
	// Block a few suspicious texts.
	SafetySettings_RaiSettings_BLOCK_FEW SafetySettings_RaiSettings_SafetyFilterLevel = 2
	// Block some suspicious texts.
	SafetySettings_RaiSettings_BLOCK_SOME SafetySettings_RaiSettings_SafetyFilterLevel = 3
	// Block most suspicious texts.
	SafetySettings_RaiSettings_BLOCK_MOST SafetySettings_RaiSettings_SafetyFilterLevel = 4
)

// Enum value maps for SafetySettings_RaiSettings_SafetyFilterLevel.
var (
	SafetySettings_RaiSettings_SafetyFilterLevel_name = map[int32]string{
		0: "SAFETY_FILTER_LEVEL_UNSPECIFIED",
		1: "BLOCK_NONE",
		2: "BLOCK_FEW",
		3: "BLOCK_SOME",
		4: "BLOCK_MOST",
	}
	SafetySettings_RaiSettings_SafetyFilterLevel_value = map[string]int32{
		"SAFETY_FILTER_LEVEL_UNSPECIFIED": 0,
		"BLOCK_NONE":                      1,
		"BLOCK_FEW":                       2,
		"BLOCK_SOME":                      3,
		"BLOCK_MOST":                      4,
	}
)

func (x SafetySettings_RaiSettings_SafetyFilterLevel) Enum() *SafetySettings_RaiSettings_SafetyFilterLevel {
	p := new(SafetySettings_RaiSettings_SafetyFilterLevel)
	*p = x
	return p
}

func (x SafetySettings_RaiSettings_SafetyFilterLevel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SafetySettings_RaiSettings_SafetyFilterLevel) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_cx_v3beta1_safety_settings_proto_enumTypes[1].Descriptor()
}

func (SafetySettings_RaiSettings_SafetyFilterLevel) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_cx_v3beta1_safety_settings_proto_enumTypes[1]
}

func (x SafetySettings_RaiSettings_SafetyFilterLevel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SafetySettings_RaiSettings_SafetyFilterLevel.Descriptor instead.
func (SafetySettings_RaiSettings_SafetyFilterLevel) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_safety_settings_proto_rawDescGZIP(), []int{0, 1, 0}
}

// RAI categories to configure.
type SafetySettings_RaiSettings_SafetyCategory int32

const (
	// Unspecified.
	SafetySettings_RaiSettings_SAFETY_CATEGORY_UNSPECIFIED SafetySettings_RaiSettings_SafetyCategory = 0
	// Dangerous content.
	SafetySettings_RaiSettings_DANGEROUS_CONTENT SafetySettings_RaiSettings_SafetyCategory = 1
	// Hate speech.
	SafetySettings_RaiSettings_HATE_SPEECH SafetySettings_RaiSettings_SafetyCategory = 2
	// Harassment.
	SafetySettings_RaiSettings_HARASSMENT SafetySettings_RaiSettings_SafetyCategory = 3
	// Sexually explicit content.
	SafetySettings_RaiSettings_SEXUALLY_EXPLICIT_CONTENT SafetySettings_RaiSettings_SafetyCategory = 4
)

// Enum value maps for SafetySettings_RaiSettings_SafetyCategory.
var (
	SafetySettings_RaiSettings_SafetyCategory_name = map[int32]string{
		0: "SAFETY_CATEGORY_UNSPECIFIED",
		1: "DANGEROUS_CONTENT",
		2: "HATE_SPEECH",
		3: "HARASSMENT",
		4: "SEXUALLY_EXPLICIT_CONTENT",
	}
	SafetySettings_RaiSettings_SafetyCategory_value = map[string]int32{
		"SAFETY_CATEGORY_UNSPECIFIED": 0,
		"DANGEROUS_CONTENT":           1,
		"HATE_SPEECH":                 2,
		"HARASSMENT":                  3,
		"SEXUALLY_EXPLICIT_CONTENT":   4,
	}
)

func (x SafetySettings_RaiSettings_SafetyCategory) Enum() *SafetySettings_RaiSettings_SafetyCategory {
	p := new(SafetySettings_RaiSettings_SafetyCategory)
	*p = x
	return p
}

func (x SafetySettings_RaiSettings_SafetyCategory) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SafetySettings_RaiSettings_SafetyCategory) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_cx_v3beta1_safety_settings_proto_enumTypes[2].Descriptor()
}

func (SafetySettings_RaiSettings_SafetyCategory) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_cx_v3beta1_safety_settings_proto_enumTypes[2]
}

func (x SafetySettings_RaiSettings_SafetyCategory) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SafetySettings_RaiSettings_SafetyCategory.Descriptor instead.
func (SafetySettings_RaiSettings_SafetyCategory) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_safety_settings_proto_rawDescGZIP(), []int{0, 1, 1}
}

// Settings for Generative Safety.
type SafetySettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Default phrase match strategy for banned phrases.
	DefaultBannedPhraseMatchStrategy SafetySettings_PhraseMatchStrategy `protobuf:"varint,4,opt,name=default_banned_phrase_match_strategy,json=defaultBannedPhraseMatchStrategy,proto3,enum=google.cloud.dialogflow.cx.v3beta1.SafetySettings_PhraseMatchStrategy" json:"default_banned_phrase_match_strategy,omitempty"`
	// Banned phrases for generated text.
	BannedPhrases []*SafetySettings_Phrase `protobuf:"bytes,1,rep,name=banned_phrases,json=bannedPhrases,proto3" json:"banned_phrases,omitempty"`
	// Optional. Settings for Responsible AI checks.
	RaiSettings *SafetySettings_RaiSettings `protobuf:"bytes,2,opt,name=rai_settings,json=raiSettings,proto3" json:"rai_settings,omitempty"`
	// Optional. Immutable. Default RAI settings to be annotated on the agent, so
	// that users will be able to restore their RAI configurations to the default
	// settings. Read-only field for the API proto only.
	DefaultRaiSettings *SafetySettings_RaiSettings `protobuf:"bytes,3,opt,name=default_rai_settings,json=defaultRaiSettings,proto3" json:"default_rai_settings,omitempty"`
	// Optional. Settings for prompt security checks.
	PromptSecuritySettings *SafetySettings_PromptSecuritySettings `protobuf:"bytes,8,opt,name=prompt_security_settings,json=promptSecuritySettings,proto3" json:"prompt_security_settings,omitempty"`
}

func (x *SafetySettings) Reset() {
	*x = SafetySettings{}
	mi := &file_google_cloud_dialogflow_cx_v3beta1_safety_settings_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SafetySettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SafetySettings) ProtoMessage() {}

func (x *SafetySettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_safety_settings_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SafetySettings.ProtoReflect.Descriptor instead.
func (*SafetySettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_safety_settings_proto_rawDescGZIP(), []int{0}
}

func (x *SafetySettings) GetDefaultBannedPhraseMatchStrategy() SafetySettings_PhraseMatchStrategy {
	if x != nil {
		return x.DefaultBannedPhraseMatchStrategy
	}
	return SafetySettings_PHRASE_MATCH_STRATEGY_UNSPECIFIED
}

func (x *SafetySettings) GetBannedPhrases() []*SafetySettings_Phrase {
	if x != nil {
		return x.BannedPhrases
	}
	return nil
}

func (x *SafetySettings) GetRaiSettings() *SafetySettings_RaiSettings {
	if x != nil {
		return x.RaiSettings
	}
	return nil
}

func (x *SafetySettings) GetDefaultRaiSettings() *SafetySettings_RaiSettings {
	if x != nil {
		return x.DefaultRaiSettings
	}
	return nil
}

func (x *SafetySettings) GetPromptSecuritySettings() *SafetySettings_PromptSecuritySettings {
	if x != nil {
		return x.PromptSecuritySettings
	}
	return nil
}

// Text input which can be used for prompt or banned phrases.
type SafetySettings_Phrase struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Text input which can be used for prompt or banned phrases.
	Text string `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
	// Required. Language code of the phrase.
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *SafetySettings_Phrase) Reset() {
	*x = SafetySettings_Phrase{}
	mi := &file_google_cloud_dialogflow_cx_v3beta1_safety_settings_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SafetySettings_Phrase) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SafetySettings_Phrase) ProtoMessage() {}

func (x *SafetySettings_Phrase) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_safety_settings_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SafetySettings_Phrase.ProtoReflect.Descriptor instead.
func (*SafetySettings_Phrase) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_safety_settings_proto_rawDescGZIP(), []int{0, 0}
}

func (x *SafetySettings_Phrase) GetText() string {
	if x != nil {
		return x.Text
	}
	return ""
}

func (x *SafetySettings_Phrase) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

// Settings for Responsible AI.
type SafetySettings_RaiSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. RAI blocking configurations.
	CategoryFilters []*SafetySettings_RaiSettings_CategoryFilter `protobuf:"bytes,3,rep,name=category_filters,json=categoryFilters,proto3" json:"category_filters,omitempty"`
}

func (x *SafetySettings_RaiSettings) Reset() {
	*x = SafetySettings_RaiSettings{}
	mi := &file_google_cloud_dialogflow_cx_v3beta1_safety_settings_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SafetySettings_RaiSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SafetySettings_RaiSettings) ProtoMessage() {}

func (x *SafetySettings_RaiSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_safety_settings_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SafetySettings_RaiSettings.ProtoReflect.Descriptor instead.
func (*SafetySettings_RaiSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_safety_settings_proto_rawDescGZIP(), []int{0, 1}
}

func (x *SafetySettings_RaiSettings) GetCategoryFilters() []*SafetySettings_RaiSettings_CategoryFilter {
	if x != nil {
		return x.CategoryFilters
	}
	return nil
}

// Settings for prompt security checks.
type SafetySettings_PromptSecuritySettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Enable prompt security checks.
	EnablePromptSecurity bool `protobuf:"varint,1,opt,name=enable_prompt_security,json=enablePromptSecurity,proto3" json:"enable_prompt_security,omitempty"`
}

func (x *SafetySettings_PromptSecuritySettings) Reset() {
	*x = SafetySettings_PromptSecuritySettings{}
	mi := &file_google_cloud_dialogflow_cx_v3beta1_safety_settings_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SafetySettings_PromptSecuritySettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SafetySettings_PromptSecuritySettings) ProtoMessage() {}

func (x *SafetySettings_PromptSecuritySettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_safety_settings_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SafetySettings_PromptSecuritySettings.ProtoReflect.Descriptor instead.
func (*SafetySettings_PromptSecuritySettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_safety_settings_proto_rawDescGZIP(), []int{0, 2}
}

func (x *SafetySettings_PromptSecuritySettings) GetEnablePromptSecurity() bool {
	if x != nil {
		return x.EnablePromptSecurity
	}
	return false
}

// Configuration of the sensitivity level for blocking an RAI category.
type SafetySettings_RaiSettings_CategoryFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// RAI category to configure.
	Category SafetySettings_RaiSettings_SafetyCategory `protobuf:"varint,1,opt,name=category,proto3,enum=google.cloud.dialogflow.cx.v3beta1.SafetySettings_RaiSettings_SafetyCategory" json:"category,omitempty"`
	// Blocking sensitivity level to configure for the RAI category.
	FilterLevel SafetySettings_RaiSettings_SafetyFilterLevel `protobuf:"varint,2,opt,name=filter_level,json=filterLevel,proto3,enum=google.cloud.dialogflow.cx.v3beta1.SafetySettings_RaiSettings_SafetyFilterLevel" json:"filter_level,omitempty"`
}

func (x *SafetySettings_RaiSettings_CategoryFilter) Reset() {
	*x = SafetySettings_RaiSettings_CategoryFilter{}
	mi := &file_google_cloud_dialogflow_cx_v3beta1_safety_settings_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SafetySettings_RaiSettings_CategoryFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SafetySettings_RaiSettings_CategoryFilter) ProtoMessage() {}

func (x *SafetySettings_RaiSettings_CategoryFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_safety_settings_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SafetySettings_RaiSettings_CategoryFilter.ProtoReflect.Descriptor instead.
func (*SafetySettings_RaiSettings_CategoryFilter) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_safety_settings_proto_rawDescGZIP(), []int{0, 1, 0}
}

func (x *SafetySettings_RaiSettings_CategoryFilter) GetCategory() SafetySettings_RaiSettings_SafetyCategory {
	if x != nil {
		return x.Category
	}
	return SafetySettings_RaiSettings_SAFETY_CATEGORY_UNSPECIFIED
}

func (x *SafetySettings_RaiSettings_CategoryFilter) GetFilterLevel() SafetySettings_RaiSettings_SafetyFilterLevel {
	if x != nil {
		return x.FilterLevel
	}
	return SafetySettings_RaiSettings_SAFETY_FILTER_LEVEL_UNSPECIFIED
}

var File_google_cloud_dialogflow_cx_v3beta1_safety_settings_proto protoreflect.FileDescriptor

var file_google_cloud_dialogflow_cx_v3beta1_safety_settings_proto_rawDesc = []byte{
	0x0a, 0x38, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x73, 0x61, 0x66, 0x65, 0x74, 0x79, 0x5f, 0x73, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x22, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22,
	0x86, 0x0c, 0x0a, 0x0e, 0x53, 0x61, 0x66, 0x65, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x12, 0x9b, 0x01, 0x0a, 0x24, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x62,
	0x61, 0x6e, 0x6e, 0x65, 0x64, 0x5f, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x5f, 0x6d, 0x61, 0x74,
	0x63, 0x68, 0x5f, 0x73, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76,
	0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x61, 0x66, 0x65, 0x74, 0x79, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63,
	0x68, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x20,
	0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x42, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x50, 0x68, 0x72,
	0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79,
	0x12, 0x60, 0x0a, 0x0e, 0x62, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x5f, 0x70, 0x68, 0x72, 0x61, 0x73,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x61,
	0x66, 0x65, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x50, 0x68, 0x72,
	0x61, 0x73, 0x65, 0x52, 0x0d, 0x62, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x50, 0x68, 0x72, 0x61, 0x73,
	0x65, 0x73, 0x12, 0x66, 0x0a, 0x0c, 0x72, 0x61, 0x69, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x61,
	0x66, 0x65, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x52, 0x61, 0x69,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x72,
	0x61, 0x69, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x78, 0x0a, 0x14, 0x64, 0x65,
	0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x72, 0x61, 0x69, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x61,
	0x66, 0x65, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x52, 0x61, 0x69,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x42, 0x06, 0xe0, 0x41, 0x01, 0xe0, 0x41, 0x05,
	0x52, 0x12, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x52, 0x61, 0x69, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x12, 0x88, 0x01, 0x0a, 0x18, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x5f,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x61, 0x66,
	0x65, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x50, 0x72, 0x6f, 0x6d,
	0x70, 0x74, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x16, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x53,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x1a,
	0x4b, 0x0a, 0x06, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x74, 0x65, 0x78,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x74, 0x65,
	0x78, 0x74, 0x12, 0x28, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63,
	0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c,
	0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x1a, 0x83, 0x05, 0x0a,
	0x0b, 0x52, 0x61, 0x69, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x7d, 0x0a, 0x10,
	0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x61, 0x66, 0x65,
	0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x52, 0x61, 0x69, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x63, 0x61, 0x74, 0x65,
	0x67, 0x6f, 0x72, 0x79, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x1a, 0xf0, 0x01, 0x0a, 0x0e,
	0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x69,
	0x0a, 0x08, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x61, 0x66, 0x65, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x2e, 0x52, 0x61, 0x69, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x2e, 0x53, 0x61, 0x66, 0x65, 0x74, 0x79, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x52,
	0x08, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x12, 0x73, 0x0a, 0x0c, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x61, 0x66, 0x65, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x2e, 0x52, 0x61, 0x69, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e,
	0x53, 0x61, 0x66, 0x65, 0x74, 0x79, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x4c, 0x65, 0x76, 0x65,
	0x6c, 0x52, 0x0b, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x22, 0x77,
	0x0a, 0x11, 0x53, 0x61, 0x66, 0x65, 0x74, 0x79, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x4c, 0x65,
	0x76, 0x65, 0x6c, 0x12, 0x23, 0x0a, 0x1f, 0x53, 0x41, 0x46, 0x45, 0x54, 0x59, 0x5f, 0x46, 0x49,
	0x4c, 0x54, 0x45, 0x52, 0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x42, 0x4c, 0x4f, 0x43,
	0x4b, 0x5f, 0x4e, 0x4f, 0x4e, 0x45, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x42, 0x4c, 0x4f, 0x43,
	0x4b, 0x5f, 0x46, 0x45, 0x57, 0x10, 0x02, 0x12, 0x0e, 0x0a, 0x0a, 0x42, 0x4c, 0x4f, 0x43, 0x4b,
	0x5f, 0x53, 0x4f, 0x4d, 0x45, 0x10, 0x03, 0x12, 0x0e, 0x0a, 0x0a, 0x42, 0x4c, 0x4f, 0x43, 0x4b,
	0x5f, 0x4d, 0x4f, 0x53, 0x54, 0x10, 0x04, 0x22, 0x88, 0x01, 0x0a, 0x0e, 0x53, 0x61, 0x66, 0x65,
	0x74, 0x79, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x12, 0x1f, 0x0a, 0x1b, 0x53, 0x41,
	0x46, 0x45, 0x54, 0x59, 0x5f, 0x43, 0x41, 0x54, 0x45, 0x47, 0x4f, 0x52, 0x59, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x15, 0x0a, 0x11, 0x44,
	0x41, 0x4e, 0x47, 0x45, 0x52, 0x4f, 0x55, 0x53, 0x5f, 0x43, 0x4f, 0x4e, 0x54, 0x45, 0x4e, 0x54,
	0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x48, 0x41, 0x54, 0x45, 0x5f, 0x53, 0x50, 0x45, 0x45, 0x43,
	0x48, 0x10, 0x02, 0x12, 0x0e, 0x0a, 0x0a, 0x48, 0x41, 0x52, 0x41, 0x53, 0x53, 0x4d, 0x45, 0x4e,
	0x54, 0x10, 0x03, 0x12, 0x1d, 0x0a, 0x19, 0x53, 0x45, 0x58, 0x55, 0x41, 0x4c, 0x4c, 0x59, 0x5f,
	0x45, 0x58, 0x50, 0x4c, 0x49, 0x43, 0x49, 0x54, 0x5f, 0x43, 0x4f, 0x4e, 0x54, 0x45, 0x4e, 0x54,
	0x10, 0x04, 0x1a, 0x53, 0x0a, 0x16, 0x50, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x53, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x39, 0x0a, 0x16,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x5f, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x14, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x53,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x22, 0x5f, 0x0a, 0x13, 0x50, 0x68, 0x72, 0x61, 0x73,
	0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x12, 0x25,
	0x0a, 0x21, 0x50, 0x48, 0x52, 0x41, 0x53, 0x45, 0x5f, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x5f, 0x53,
	0x54, 0x52, 0x41, 0x54, 0x45, 0x47, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x11, 0x0a, 0x0d, 0x50, 0x41, 0x52, 0x54, 0x49, 0x41, 0x4c,
	0x5f, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x57, 0x4f, 0x52, 0x44,
	0x5f, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x10, 0x02, 0x42, 0xca, 0x01, 0x0a, 0x26, 0x63, 0x6f, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x42, 0x13, 0x53, 0x61, 0x66, 0x65, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x36, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x61, 0x70,
	0x69, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x63, 0x78, 0x70, 0x62, 0x3b, 0x63, 0x78,
	0x70, 0x62, 0xa2, 0x02, 0x02, 0x44, 0x46, 0xaa, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x43, 0x78, 0x2e, 0x56, 0x33, 0x42, 0x65, 0x74, 0x61, 0x31, 0xea, 0x02, 0x26, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x44, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x3a, 0x3a, 0x43, 0x58, 0x3a, 0x3a, 0x56, 0x33,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_dialogflow_cx_v3beta1_safety_settings_proto_rawDescOnce sync.Once
	file_google_cloud_dialogflow_cx_v3beta1_safety_settings_proto_rawDescData = file_google_cloud_dialogflow_cx_v3beta1_safety_settings_proto_rawDesc
)

func file_google_cloud_dialogflow_cx_v3beta1_safety_settings_proto_rawDescGZIP() []byte {
	file_google_cloud_dialogflow_cx_v3beta1_safety_settings_proto_rawDescOnce.Do(func() {
		file_google_cloud_dialogflow_cx_v3beta1_safety_settings_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_dialogflow_cx_v3beta1_safety_settings_proto_rawDescData)
	})
	return file_google_cloud_dialogflow_cx_v3beta1_safety_settings_proto_rawDescData
}

var file_google_cloud_dialogflow_cx_v3beta1_safety_settings_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_cloud_dialogflow_cx_v3beta1_safety_settings_proto_msgTypes = make([]protoimpl.MessageInfo, 5)
var file_google_cloud_dialogflow_cx_v3beta1_safety_settings_proto_goTypes = []any{
	(SafetySettings_PhraseMatchStrategy)(0),           // 0: google.cloud.dialogflow.cx.v3beta1.SafetySettings.PhraseMatchStrategy
	(SafetySettings_RaiSettings_SafetyFilterLevel)(0), // 1: google.cloud.dialogflow.cx.v3beta1.SafetySettings.RaiSettings.SafetyFilterLevel
	(SafetySettings_RaiSettings_SafetyCategory)(0),    // 2: google.cloud.dialogflow.cx.v3beta1.SafetySettings.RaiSettings.SafetyCategory
	(*SafetySettings)(nil),                            // 3: google.cloud.dialogflow.cx.v3beta1.SafetySettings
	(*SafetySettings_Phrase)(nil),                     // 4: google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase
	(*SafetySettings_RaiSettings)(nil),                // 5: google.cloud.dialogflow.cx.v3beta1.SafetySettings.RaiSettings
	(*SafetySettings_PromptSecuritySettings)(nil),     // 6: google.cloud.dialogflow.cx.v3beta1.SafetySettings.PromptSecuritySettings
	(*SafetySettings_RaiSettings_CategoryFilter)(nil), // 7: google.cloud.dialogflow.cx.v3beta1.SafetySettings.RaiSettings.CategoryFilter
}
var file_google_cloud_dialogflow_cx_v3beta1_safety_settings_proto_depIdxs = []int32{
	0, // 0: google.cloud.dialogflow.cx.v3beta1.SafetySettings.default_banned_phrase_match_strategy:type_name -> google.cloud.dialogflow.cx.v3beta1.SafetySettings.PhraseMatchStrategy
	4, // 1: google.cloud.dialogflow.cx.v3beta1.SafetySettings.banned_phrases:type_name -> google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase
	5, // 2: google.cloud.dialogflow.cx.v3beta1.SafetySettings.rai_settings:type_name -> google.cloud.dialogflow.cx.v3beta1.SafetySettings.RaiSettings
	5, // 3: google.cloud.dialogflow.cx.v3beta1.SafetySettings.default_rai_settings:type_name -> google.cloud.dialogflow.cx.v3beta1.SafetySettings.RaiSettings
	6, // 4: google.cloud.dialogflow.cx.v3beta1.SafetySettings.prompt_security_settings:type_name -> google.cloud.dialogflow.cx.v3beta1.SafetySettings.PromptSecuritySettings
	7, // 5: google.cloud.dialogflow.cx.v3beta1.SafetySettings.RaiSettings.category_filters:type_name -> google.cloud.dialogflow.cx.v3beta1.SafetySettings.RaiSettings.CategoryFilter
	2, // 6: google.cloud.dialogflow.cx.v3beta1.SafetySettings.RaiSettings.CategoryFilter.category:type_name -> google.cloud.dialogflow.cx.v3beta1.SafetySettings.RaiSettings.SafetyCategory
	1, // 7: google.cloud.dialogflow.cx.v3beta1.SafetySettings.RaiSettings.CategoryFilter.filter_level:type_name -> google.cloud.dialogflow.cx.v3beta1.SafetySettings.RaiSettings.SafetyFilterLevel
	8, // [8:8] is the sub-list for method output_type
	8, // [8:8] is the sub-list for method input_type
	8, // [8:8] is the sub-list for extension type_name
	8, // [8:8] is the sub-list for extension extendee
	0, // [0:8] is the sub-list for field type_name
}

func init() { file_google_cloud_dialogflow_cx_v3beta1_safety_settings_proto_init() }
func file_google_cloud_dialogflow_cx_v3beta1_safety_settings_proto_init() {
	if File_google_cloud_dialogflow_cx_v3beta1_safety_settings_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_dialogflow_cx_v3beta1_safety_settings_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   5,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_dialogflow_cx_v3beta1_safety_settings_proto_goTypes,
		DependencyIndexes: file_google_cloud_dialogflow_cx_v3beta1_safety_settings_proto_depIdxs,
		EnumInfos:         file_google_cloud_dialogflow_cx_v3beta1_safety_settings_proto_enumTypes,
		MessageInfos:      file_google_cloud_dialogflow_cx_v3beta1_safety_settings_proto_msgTypes,
	}.Build()
	File_google_cloud_dialogflow_cx_v3beta1_safety_settings_proto = out.File
	file_google_cloud_dialogflow_cx_v3beta1_safety_settings_proto_rawDesc = nil
	file_google_cloud_dialogflow_cx_v3beta1_safety_settings_proto_goTypes = nil
	file_google_cloud_dialogflow_cx_v3beta1_safety_settings_proto_depIdxs = nil
}
