// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/dialogflow/v2/sip_trunk.proto

package dialogflowpb

import (
	context "context"

	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	SipTrunks_CreateSipTrunk_FullMethodName = "/google.cloud.dialogflow.v2.SipTrunks/CreateSipTrunk"
	SipTrunks_DeleteSipTrunk_FullMethodName = "/google.cloud.dialogflow.v2.SipTrunks/DeleteSipTrunk"
	SipTrunks_ListSipTrunks_FullMethodName  = "/google.cloud.dialogflow.v2.SipTrunks/ListSipTrunks"
	SipTrunks_GetSipTrunk_FullMethodName    = "/google.cloud.dialogflow.v2.SipTrunks/GetSipTrunk"
	SipTrunks_UpdateSipTrunk_FullMethodName = "/google.cloud.dialogflow.v2.SipTrunks/UpdateSipTrunk"
)

// SipTrunksClient is the client API for SipTrunks service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type SipTrunksClient interface {
	// Creates a SipTrunk for a specified location.
	CreateSipTrunk(ctx context.Context, in *CreateSipTrunkRequest, opts ...grpc.CallOption) (*SipTrunk, error)
	// Deletes a specified SipTrunk.
	DeleteSipTrunk(ctx context.Context, in *DeleteSipTrunkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Returns a list of SipTrunks in the specified location.
	ListSipTrunks(ctx context.Context, in *ListSipTrunksRequest, opts ...grpc.CallOption) (*ListSipTrunksResponse, error)
	// Retrieves the specified SipTrunk.
	GetSipTrunk(ctx context.Context, in *GetSipTrunkRequest, opts ...grpc.CallOption) (*SipTrunk, error)
	// Updates the specified SipTrunk.
	UpdateSipTrunk(ctx context.Context, in *UpdateSipTrunkRequest, opts ...grpc.CallOption) (*SipTrunk, error)
}

type sipTrunksClient struct {
	cc grpc.ClientConnInterface
}

func NewSipTrunksClient(cc grpc.ClientConnInterface) SipTrunksClient {
	return &sipTrunksClient{cc}
}

func (c *sipTrunksClient) CreateSipTrunk(ctx context.Context, in *CreateSipTrunkRequest, opts ...grpc.CallOption) (*SipTrunk, error) {
	out := new(SipTrunk)
	err := c.cc.Invoke(ctx, SipTrunks_CreateSipTrunk_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sipTrunksClient) DeleteSipTrunk(ctx context.Context, in *DeleteSipTrunkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, SipTrunks_DeleteSipTrunk_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sipTrunksClient) ListSipTrunks(ctx context.Context, in *ListSipTrunksRequest, opts ...grpc.CallOption) (*ListSipTrunksResponse, error) {
	out := new(ListSipTrunksResponse)
	err := c.cc.Invoke(ctx, SipTrunks_ListSipTrunks_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sipTrunksClient) GetSipTrunk(ctx context.Context, in *GetSipTrunkRequest, opts ...grpc.CallOption) (*SipTrunk, error) {
	out := new(SipTrunk)
	err := c.cc.Invoke(ctx, SipTrunks_GetSipTrunk_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sipTrunksClient) UpdateSipTrunk(ctx context.Context, in *UpdateSipTrunkRequest, opts ...grpc.CallOption) (*SipTrunk, error) {
	out := new(SipTrunk)
	err := c.cc.Invoke(ctx, SipTrunks_UpdateSipTrunk_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SipTrunksServer is the server API for SipTrunks service.
// All implementations should embed UnimplementedSipTrunksServer
// for forward compatibility
type SipTrunksServer interface {
	// Creates a SipTrunk for a specified location.
	CreateSipTrunk(context.Context, *CreateSipTrunkRequest) (*SipTrunk, error)
	// Deletes a specified SipTrunk.
	DeleteSipTrunk(context.Context, *DeleteSipTrunkRequest) (*emptypb.Empty, error)
	// Returns a list of SipTrunks in the specified location.
	ListSipTrunks(context.Context, *ListSipTrunksRequest) (*ListSipTrunksResponse, error)
	// Retrieves the specified SipTrunk.
	GetSipTrunk(context.Context, *GetSipTrunkRequest) (*SipTrunk, error)
	// Updates the specified SipTrunk.
	UpdateSipTrunk(context.Context, *UpdateSipTrunkRequest) (*SipTrunk, error)
}

// UnimplementedSipTrunksServer should be embedded to have forward compatible implementations.
type UnimplementedSipTrunksServer struct {
}

func (UnimplementedSipTrunksServer) CreateSipTrunk(context.Context, *CreateSipTrunkRequest) (*SipTrunk, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSipTrunk not implemented")
}
func (UnimplementedSipTrunksServer) DeleteSipTrunk(context.Context, *DeleteSipTrunkRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteSipTrunk not implemented")
}
func (UnimplementedSipTrunksServer) ListSipTrunks(context.Context, *ListSipTrunksRequest) (*ListSipTrunksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSipTrunks not implemented")
}
func (UnimplementedSipTrunksServer) GetSipTrunk(context.Context, *GetSipTrunkRequest) (*SipTrunk, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSipTrunk not implemented")
}
func (UnimplementedSipTrunksServer) UpdateSipTrunk(context.Context, *UpdateSipTrunkRequest) (*SipTrunk, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSipTrunk not implemented")
}

// UnsafeSipTrunksServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to SipTrunksServer will
// result in compilation errors.
type UnsafeSipTrunksServer interface {
	mustEmbedUnimplementedSipTrunksServer()
}

func RegisterSipTrunksServer(s grpc.ServiceRegistrar, srv SipTrunksServer) {
	s.RegisterService(&SipTrunks_ServiceDesc, srv)
}

func _SipTrunks_CreateSipTrunk_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSipTrunkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SipTrunksServer).CreateSipTrunk(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SipTrunks_CreateSipTrunk_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SipTrunksServer).CreateSipTrunk(ctx, req.(*CreateSipTrunkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SipTrunks_DeleteSipTrunk_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSipTrunkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SipTrunksServer).DeleteSipTrunk(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SipTrunks_DeleteSipTrunk_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SipTrunksServer).DeleteSipTrunk(ctx, req.(*DeleteSipTrunkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SipTrunks_ListSipTrunks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSipTrunksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SipTrunksServer).ListSipTrunks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SipTrunks_ListSipTrunks_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SipTrunksServer).ListSipTrunks(ctx, req.(*ListSipTrunksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SipTrunks_GetSipTrunk_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSipTrunkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SipTrunksServer).GetSipTrunk(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SipTrunks_GetSipTrunk_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SipTrunksServer).GetSipTrunk(ctx, req.(*GetSipTrunkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SipTrunks_UpdateSipTrunk_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSipTrunkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SipTrunksServer).UpdateSipTrunk(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SipTrunks_UpdateSipTrunk_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SipTrunksServer).UpdateSipTrunk(ctx, req.(*UpdateSipTrunkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// SipTrunks_ServiceDesc is the grpc.ServiceDesc for SipTrunks service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var SipTrunks_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.v2.SipTrunks",
	HandlerType: (*SipTrunksServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateSipTrunk",
			Handler:    _SipTrunks_CreateSipTrunk_Handler,
		},
		{
			MethodName: "DeleteSipTrunk",
			Handler:    _SipTrunks_DeleteSipTrunk_Handler,
		},
		{
			MethodName: "ListSipTrunks",
			Handler:    _SipTrunks_ListSipTrunks_Handler,
		},
		{
			MethodName: "GetSipTrunk",
			Handler:    _SipTrunks_GetSipTrunk_Handler,
		},
		{
			MethodName: "UpdateSipTrunk",
			Handler:    _SipTrunks_UpdateSipTrunk_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dialogflow/v2/sip_trunk.proto",
}
