// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/dialogflow/v2/fulfillment.proto

package dialogflowpb

import (
	context "context"

	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	Fulfillments_GetFulfillment_FullMethodName    = "/google.cloud.dialogflow.v2.Fulfillments/GetFulfillment"
	Fulfillments_UpdateFulfillment_FullMethodName = "/google.cloud.dialogflow.v2.Fulfillments/UpdateFulfillment"
)

// FulfillmentsClient is the client API for Fulfillments service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type FulfillmentsClient interface {
	// Retrieves the fulfillment.
	GetFulfillment(ctx context.Context, in *GetFulfillmentRequest, opts ...grpc.CallOption) (*Fulfillment, error)
	// Updates the fulfillment.
	UpdateFulfillment(ctx context.Context, in *UpdateFulfillmentRequest, opts ...grpc.CallOption) (*Fulfillment, error)
}

type fulfillmentsClient struct {
	cc grpc.ClientConnInterface
}

func NewFulfillmentsClient(cc grpc.ClientConnInterface) FulfillmentsClient {
	return &fulfillmentsClient{cc}
}

func (c *fulfillmentsClient) GetFulfillment(ctx context.Context, in *GetFulfillmentRequest, opts ...grpc.CallOption) (*Fulfillment, error) {
	out := new(Fulfillment)
	err := c.cc.Invoke(ctx, Fulfillments_GetFulfillment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *fulfillmentsClient) UpdateFulfillment(ctx context.Context, in *UpdateFulfillmentRequest, opts ...grpc.CallOption) (*Fulfillment, error) {
	out := new(Fulfillment)
	err := c.cc.Invoke(ctx, Fulfillments_UpdateFulfillment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// FulfillmentsServer is the server API for Fulfillments service.
// All implementations should embed UnimplementedFulfillmentsServer
// for forward compatibility
type FulfillmentsServer interface {
	// Retrieves the fulfillment.
	GetFulfillment(context.Context, *GetFulfillmentRequest) (*Fulfillment, error)
	// Updates the fulfillment.
	UpdateFulfillment(context.Context, *UpdateFulfillmentRequest) (*Fulfillment, error)
}

// UnimplementedFulfillmentsServer should be embedded to have forward compatible implementations.
type UnimplementedFulfillmentsServer struct {
}

func (UnimplementedFulfillmentsServer) GetFulfillment(context.Context, *GetFulfillmentRequest) (*Fulfillment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetFulfillment not implemented")
}
func (UnimplementedFulfillmentsServer) UpdateFulfillment(context.Context, *UpdateFulfillmentRequest) (*Fulfillment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateFulfillment not implemented")
}

// UnsafeFulfillmentsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to FulfillmentsServer will
// result in compilation errors.
type UnsafeFulfillmentsServer interface {
	mustEmbedUnimplementedFulfillmentsServer()
}

func RegisterFulfillmentsServer(s grpc.ServiceRegistrar, srv FulfillmentsServer) {
	s.RegisterService(&Fulfillments_ServiceDesc, srv)
}

func _Fulfillments_GetFulfillment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFulfillmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FulfillmentsServer).GetFulfillment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Fulfillments_GetFulfillment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FulfillmentsServer).GetFulfillment(ctx, req.(*GetFulfillmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Fulfillments_UpdateFulfillment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateFulfillmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FulfillmentsServer).UpdateFulfillment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Fulfillments_UpdateFulfillment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FulfillmentsServer).UpdateFulfillment(ctx, req.(*UpdateFulfillmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Fulfillments_ServiceDesc is the grpc.ServiceDesc for Fulfillments service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Fulfillments_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.v2.Fulfillments",
	HandlerType: (*FulfillmentsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetFulfillment",
			Handler:    _Fulfillments_GetFulfillment_Handler,
		},
		{
			MethodName: "UpdateFulfillment",
			Handler:    _Fulfillments_UpdateFulfillment_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dialogflow/v2/fulfillment.proto",
}
