// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/apigeeconnect/v1/tether.proto

package apigeeconnectpb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	Tether_Egress_FullMethodName = "/google.cloud.apigeeconnect.v1.Tether/Egress"
)

// TetherClient is the client API for Tether service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type TetherClient interface {
	// Egress streams egress requests and responses. Logically, this is not
	// actually a streaming request, but uses streaming as a mechanism to flip
	// the client-server relationship of gRPC so that the server can act as a
	// client.
	// The listener, the RPC server, accepts connections from the dialer,
	// the RPC client.
	// The listener streams http requests and the dialer streams http responses.
	Egress(ctx context.Context, opts ...grpc.CallOption) (Tether_EgressClient, error)
}

type tetherClient struct {
	cc grpc.ClientConnInterface
}

func NewTetherClient(cc grpc.ClientConnInterface) TetherClient {
	return &tetherClient{cc}
}

func (c *tetherClient) Egress(ctx context.Context, opts ...grpc.CallOption) (Tether_EgressClient, error) {
	stream, err := c.cc.NewStream(ctx, &Tether_ServiceDesc.Streams[0], Tether_Egress_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &tetherEgressClient{stream}
	return x, nil
}

type Tether_EgressClient interface {
	Send(*EgressResponse) error
	Recv() (*EgressRequest, error)
	grpc.ClientStream
}

type tetherEgressClient struct {
	grpc.ClientStream
}

func (x *tetherEgressClient) Send(m *EgressResponse) error {
	return x.ClientStream.SendMsg(m)
}

func (x *tetherEgressClient) Recv() (*EgressRequest, error) {
	m := new(EgressRequest)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// TetherServer is the server API for Tether service.
// All implementations should embed UnimplementedTetherServer
// for forward compatibility
type TetherServer interface {
	// Egress streams egress requests and responses. Logically, this is not
	// actually a streaming request, but uses streaming as a mechanism to flip
	// the client-server relationship of gRPC so that the server can act as a
	// client.
	// The listener, the RPC server, accepts connections from the dialer,
	// the RPC client.
	// The listener streams http requests and the dialer streams http responses.
	Egress(Tether_EgressServer) error
}

// UnimplementedTetherServer should be embedded to have forward compatible implementations.
type UnimplementedTetherServer struct {
}

func (UnimplementedTetherServer) Egress(Tether_EgressServer) error {
	return status.Errorf(codes.Unimplemented, "method Egress not implemented")
}

// UnsafeTetherServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to TetherServer will
// result in compilation errors.
type UnsafeTetherServer interface {
	mustEmbedUnimplementedTetherServer()
}

func RegisterTetherServer(s grpc.ServiceRegistrar, srv TetherServer) {
	s.RegisterService(&Tether_ServiceDesc, srv)
}

func _Tether_Egress_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(TetherServer).Egress(&tetherEgressServer{stream})
}

type Tether_EgressServer interface {
	Send(*EgressRequest) error
	Recv() (*EgressResponse, error)
	grpc.ServerStream
}

type tetherEgressServer struct {
	grpc.ServerStream
}

func (x *tetherEgressServer) Send(m *EgressRequest) error {
	return x.ServerStream.SendMsg(m)
}

func (x *tetherEgressServer) Recv() (*EgressResponse, error) {
	m := new(EgressResponse)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// Tether_ServiceDesc is the grpc.ServiceDesc for Tether service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Tether_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.apigeeconnect.v1.Tether",
	HandlerType: (*TetherServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Egress",
			Handler:       _Tether_Egress_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "google/cloud/apigeeconnect/v1/tether.proto",
}
