// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/aiplatform/v1beta1/feature_registry_service.proto

package aiplatformpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	FeatureRegistryService_CreateFeatureGroup_FullMethodName      = "/google.cloud.aiplatform.v1beta1.FeatureRegistryService/CreateFeatureGroup"
	FeatureRegistryService_GetFeatureGroup_FullMethodName         = "/google.cloud.aiplatform.v1beta1.FeatureRegistryService/GetFeatureGroup"
	FeatureRegistryService_ListFeatureGroups_FullMethodName       = "/google.cloud.aiplatform.v1beta1.FeatureRegistryService/ListFeatureGroups"
	FeatureRegistryService_UpdateFeatureGroup_FullMethodName      = "/google.cloud.aiplatform.v1beta1.FeatureRegistryService/UpdateFeatureGroup"
	FeatureRegistryService_DeleteFeatureGroup_FullMethodName      = "/google.cloud.aiplatform.v1beta1.FeatureRegistryService/DeleteFeatureGroup"
	FeatureRegistryService_CreateFeature_FullMethodName           = "/google.cloud.aiplatform.v1beta1.FeatureRegistryService/CreateFeature"
	FeatureRegistryService_BatchCreateFeatures_FullMethodName     = "/google.cloud.aiplatform.v1beta1.FeatureRegistryService/BatchCreateFeatures"
	FeatureRegistryService_GetFeature_FullMethodName              = "/google.cloud.aiplatform.v1beta1.FeatureRegistryService/GetFeature"
	FeatureRegistryService_ListFeatures_FullMethodName            = "/google.cloud.aiplatform.v1beta1.FeatureRegistryService/ListFeatures"
	FeatureRegistryService_UpdateFeature_FullMethodName           = "/google.cloud.aiplatform.v1beta1.FeatureRegistryService/UpdateFeature"
	FeatureRegistryService_DeleteFeature_FullMethodName           = "/google.cloud.aiplatform.v1beta1.FeatureRegistryService/DeleteFeature"
	FeatureRegistryService_CreateFeatureMonitor_FullMethodName    = "/google.cloud.aiplatform.v1beta1.FeatureRegistryService/CreateFeatureMonitor"
	FeatureRegistryService_GetFeatureMonitor_FullMethodName       = "/google.cloud.aiplatform.v1beta1.FeatureRegistryService/GetFeatureMonitor"
	FeatureRegistryService_ListFeatureMonitors_FullMethodName     = "/google.cloud.aiplatform.v1beta1.FeatureRegistryService/ListFeatureMonitors"
	FeatureRegistryService_UpdateFeatureMonitor_FullMethodName    = "/google.cloud.aiplatform.v1beta1.FeatureRegistryService/UpdateFeatureMonitor"
	FeatureRegistryService_DeleteFeatureMonitor_FullMethodName    = "/google.cloud.aiplatform.v1beta1.FeatureRegistryService/DeleteFeatureMonitor"
	FeatureRegistryService_CreateFeatureMonitorJob_FullMethodName = "/google.cloud.aiplatform.v1beta1.FeatureRegistryService/CreateFeatureMonitorJob"
	FeatureRegistryService_GetFeatureMonitorJob_FullMethodName    = "/google.cloud.aiplatform.v1beta1.FeatureRegistryService/GetFeatureMonitorJob"
	FeatureRegistryService_ListFeatureMonitorJobs_FullMethodName  = "/google.cloud.aiplatform.v1beta1.FeatureRegistryService/ListFeatureMonitorJobs"
)

// FeatureRegistryServiceClient is the client API for FeatureRegistryService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type FeatureRegistryServiceClient interface {
	// Creates a new FeatureGroup in a given project and location.
	CreateFeatureGroup(ctx context.Context, in *CreateFeatureGroupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets details of a single FeatureGroup.
	GetFeatureGroup(ctx context.Context, in *GetFeatureGroupRequest, opts ...grpc.CallOption) (*FeatureGroup, error)
	// Lists FeatureGroups in a given project and location.
	ListFeatureGroups(ctx context.Context, in *ListFeatureGroupsRequest, opts ...grpc.CallOption) (*ListFeatureGroupsResponse, error)
	// Updates the parameters of a single FeatureGroup.
	UpdateFeatureGroup(ctx context.Context, in *UpdateFeatureGroupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single FeatureGroup.
	DeleteFeatureGroup(ctx context.Context, in *DeleteFeatureGroupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a new Feature in a given FeatureGroup.
	CreateFeature(ctx context.Context, in *CreateFeatureRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a batch of Features in a given FeatureGroup.
	BatchCreateFeatures(ctx context.Context, in *BatchCreateFeaturesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets details of a single Feature.
	GetFeature(ctx context.Context, in *GetFeatureRequest, opts ...grpc.CallOption) (*Feature, error)
	// Lists Features in a given FeatureGroup.
	ListFeatures(ctx context.Context, in *ListFeaturesRequest, opts ...grpc.CallOption) (*ListFeaturesResponse, error)
	// Updates the parameters of a single Feature.
	UpdateFeature(ctx context.Context, in *UpdateFeatureRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single Feature.
	DeleteFeature(ctx context.Context, in *DeleteFeatureRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a new FeatureMonitor in a given project, location and FeatureGroup.
	CreateFeatureMonitor(ctx context.Context, in *CreateFeatureMonitorRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets details of a single FeatureMonitor.
	GetFeatureMonitor(ctx context.Context, in *GetFeatureMonitorRequest, opts ...grpc.CallOption) (*FeatureMonitor, error)
	// Lists FeatureGroups in a given project and location.
	ListFeatureMonitors(ctx context.Context, in *ListFeatureMonitorsRequest, opts ...grpc.CallOption) (*ListFeatureMonitorsResponse, error)
	// Updates the parameters of a single FeatureMonitor.
	UpdateFeatureMonitor(ctx context.Context, in *UpdateFeatureMonitorRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single FeatureMonitor.
	DeleteFeatureMonitor(ctx context.Context, in *DeleteFeatureMonitorRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a new feature monitor job.
	CreateFeatureMonitorJob(ctx context.Context, in *CreateFeatureMonitorJobRequest, opts ...grpc.CallOption) (*FeatureMonitorJob, error)
	// Get a feature monitor job.
	GetFeatureMonitorJob(ctx context.Context, in *GetFeatureMonitorJobRequest, opts ...grpc.CallOption) (*FeatureMonitorJob, error)
	// List feature monitor jobs.
	ListFeatureMonitorJobs(ctx context.Context, in *ListFeatureMonitorJobsRequest, opts ...grpc.CallOption) (*ListFeatureMonitorJobsResponse, error)
}

type featureRegistryServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewFeatureRegistryServiceClient(cc grpc.ClientConnInterface) FeatureRegistryServiceClient {
	return &featureRegistryServiceClient{cc}
}

func (c *featureRegistryServiceClient) CreateFeatureGroup(ctx context.Context, in *CreateFeatureGroupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, FeatureRegistryService_CreateFeatureGroup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featureRegistryServiceClient) GetFeatureGroup(ctx context.Context, in *GetFeatureGroupRequest, opts ...grpc.CallOption) (*FeatureGroup, error) {
	out := new(FeatureGroup)
	err := c.cc.Invoke(ctx, FeatureRegistryService_GetFeatureGroup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featureRegistryServiceClient) ListFeatureGroups(ctx context.Context, in *ListFeatureGroupsRequest, opts ...grpc.CallOption) (*ListFeatureGroupsResponse, error) {
	out := new(ListFeatureGroupsResponse)
	err := c.cc.Invoke(ctx, FeatureRegistryService_ListFeatureGroups_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featureRegistryServiceClient) UpdateFeatureGroup(ctx context.Context, in *UpdateFeatureGroupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, FeatureRegistryService_UpdateFeatureGroup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featureRegistryServiceClient) DeleteFeatureGroup(ctx context.Context, in *DeleteFeatureGroupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, FeatureRegistryService_DeleteFeatureGroup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featureRegistryServiceClient) CreateFeature(ctx context.Context, in *CreateFeatureRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, FeatureRegistryService_CreateFeature_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featureRegistryServiceClient) BatchCreateFeatures(ctx context.Context, in *BatchCreateFeaturesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, FeatureRegistryService_BatchCreateFeatures_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featureRegistryServiceClient) GetFeature(ctx context.Context, in *GetFeatureRequest, opts ...grpc.CallOption) (*Feature, error) {
	out := new(Feature)
	err := c.cc.Invoke(ctx, FeatureRegistryService_GetFeature_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featureRegistryServiceClient) ListFeatures(ctx context.Context, in *ListFeaturesRequest, opts ...grpc.CallOption) (*ListFeaturesResponse, error) {
	out := new(ListFeaturesResponse)
	err := c.cc.Invoke(ctx, FeatureRegistryService_ListFeatures_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featureRegistryServiceClient) UpdateFeature(ctx context.Context, in *UpdateFeatureRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, FeatureRegistryService_UpdateFeature_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featureRegistryServiceClient) DeleteFeature(ctx context.Context, in *DeleteFeatureRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, FeatureRegistryService_DeleteFeature_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featureRegistryServiceClient) CreateFeatureMonitor(ctx context.Context, in *CreateFeatureMonitorRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, FeatureRegistryService_CreateFeatureMonitor_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featureRegistryServiceClient) GetFeatureMonitor(ctx context.Context, in *GetFeatureMonitorRequest, opts ...grpc.CallOption) (*FeatureMonitor, error) {
	out := new(FeatureMonitor)
	err := c.cc.Invoke(ctx, FeatureRegistryService_GetFeatureMonitor_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featureRegistryServiceClient) ListFeatureMonitors(ctx context.Context, in *ListFeatureMonitorsRequest, opts ...grpc.CallOption) (*ListFeatureMonitorsResponse, error) {
	out := new(ListFeatureMonitorsResponse)
	err := c.cc.Invoke(ctx, FeatureRegistryService_ListFeatureMonitors_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featureRegistryServiceClient) UpdateFeatureMonitor(ctx context.Context, in *UpdateFeatureMonitorRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, FeatureRegistryService_UpdateFeatureMonitor_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featureRegistryServiceClient) DeleteFeatureMonitor(ctx context.Context, in *DeleteFeatureMonitorRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, FeatureRegistryService_DeleteFeatureMonitor_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featureRegistryServiceClient) CreateFeatureMonitorJob(ctx context.Context, in *CreateFeatureMonitorJobRequest, opts ...grpc.CallOption) (*FeatureMonitorJob, error) {
	out := new(FeatureMonitorJob)
	err := c.cc.Invoke(ctx, FeatureRegistryService_CreateFeatureMonitorJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featureRegistryServiceClient) GetFeatureMonitorJob(ctx context.Context, in *GetFeatureMonitorJobRequest, opts ...grpc.CallOption) (*FeatureMonitorJob, error) {
	out := new(FeatureMonitorJob)
	err := c.cc.Invoke(ctx, FeatureRegistryService_GetFeatureMonitorJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featureRegistryServiceClient) ListFeatureMonitorJobs(ctx context.Context, in *ListFeatureMonitorJobsRequest, opts ...grpc.CallOption) (*ListFeatureMonitorJobsResponse, error) {
	out := new(ListFeatureMonitorJobsResponse)
	err := c.cc.Invoke(ctx, FeatureRegistryService_ListFeatureMonitorJobs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// FeatureRegistryServiceServer is the server API for FeatureRegistryService service.
// All implementations should embed UnimplementedFeatureRegistryServiceServer
// for forward compatibility
type FeatureRegistryServiceServer interface {
	// Creates a new FeatureGroup in a given project and location.
	CreateFeatureGroup(context.Context, *CreateFeatureGroupRequest) (*longrunningpb.Operation, error)
	// Gets details of a single FeatureGroup.
	GetFeatureGroup(context.Context, *GetFeatureGroupRequest) (*FeatureGroup, error)
	// Lists FeatureGroups in a given project and location.
	ListFeatureGroups(context.Context, *ListFeatureGroupsRequest) (*ListFeatureGroupsResponse, error)
	// Updates the parameters of a single FeatureGroup.
	UpdateFeatureGroup(context.Context, *UpdateFeatureGroupRequest) (*longrunningpb.Operation, error)
	// Deletes a single FeatureGroup.
	DeleteFeatureGroup(context.Context, *DeleteFeatureGroupRequest) (*longrunningpb.Operation, error)
	// Creates a new Feature in a given FeatureGroup.
	CreateFeature(context.Context, *CreateFeatureRequest) (*longrunningpb.Operation, error)
	// Creates a batch of Features in a given FeatureGroup.
	BatchCreateFeatures(context.Context, *BatchCreateFeaturesRequest) (*longrunningpb.Operation, error)
	// Gets details of a single Feature.
	GetFeature(context.Context, *GetFeatureRequest) (*Feature, error)
	// Lists Features in a given FeatureGroup.
	ListFeatures(context.Context, *ListFeaturesRequest) (*ListFeaturesResponse, error)
	// Updates the parameters of a single Feature.
	UpdateFeature(context.Context, *UpdateFeatureRequest) (*longrunningpb.Operation, error)
	// Deletes a single Feature.
	DeleteFeature(context.Context, *DeleteFeatureRequest) (*longrunningpb.Operation, error)
	// Creates a new FeatureMonitor in a given project, location and FeatureGroup.
	CreateFeatureMonitor(context.Context, *CreateFeatureMonitorRequest) (*longrunningpb.Operation, error)
	// Gets details of a single FeatureMonitor.
	GetFeatureMonitor(context.Context, *GetFeatureMonitorRequest) (*FeatureMonitor, error)
	// Lists FeatureGroups in a given project and location.
	ListFeatureMonitors(context.Context, *ListFeatureMonitorsRequest) (*ListFeatureMonitorsResponse, error)
	// Updates the parameters of a single FeatureMonitor.
	UpdateFeatureMonitor(context.Context, *UpdateFeatureMonitorRequest) (*longrunningpb.Operation, error)
	// Deletes a single FeatureMonitor.
	DeleteFeatureMonitor(context.Context, *DeleteFeatureMonitorRequest) (*longrunningpb.Operation, error)
	// Creates a new feature monitor job.
	CreateFeatureMonitorJob(context.Context, *CreateFeatureMonitorJobRequest) (*FeatureMonitorJob, error)
	// Get a feature monitor job.
	GetFeatureMonitorJob(context.Context, *GetFeatureMonitorJobRequest) (*FeatureMonitorJob, error)
	// List feature monitor jobs.
	ListFeatureMonitorJobs(context.Context, *ListFeatureMonitorJobsRequest) (*ListFeatureMonitorJobsResponse, error)
}

// UnimplementedFeatureRegistryServiceServer should be embedded to have forward compatible implementations.
type UnimplementedFeatureRegistryServiceServer struct {
}

func (UnimplementedFeatureRegistryServiceServer) CreateFeatureGroup(context.Context, *CreateFeatureGroupRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateFeatureGroup not implemented")
}
func (UnimplementedFeatureRegistryServiceServer) GetFeatureGroup(context.Context, *GetFeatureGroupRequest) (*FeatureGroup, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetFeatureGroup not implemented")
}
func (UnimplementedFeatureRegistryServiceServer) ListFeatureGroups(context.Context, *ListFeatureGroupsRequest) (*ListFeatureGroupsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListFeatureGroups not implemented")
}
func (UnimplementedFeatureRegistryServiceServer) UpdateFeatureGroup(context.Context, *UpdateFeatureGroupRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateFeatureGroup not implemented")
}
func (UnimplementedFeatureRegistryServiceServer) DeleteFeatureGroup(context.Context, *DeleteFeatureGroupRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteFeatureGroup not implemented")
}
func (UnimplementedFeatureRegistryServiceServer) CreateFeature(context.Context, *CreateFeatureRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateFeature not implemented")
}
func (UnimplementedFeatureRegistryServiceServer) BatchCreateFeatures(context.Context, *BatchCreateFeaturesRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchCreateFeatures not implemented")
}
func (UnimplementedFeatureRegistryServiceServer) GetFeature(context.Context, *GetFeatureRequest) (*Feature, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetFeature not implemented")
}
func (UnimplementedFeatureRegistryServiceServer) ListFeatures(context.Context, *ListFeaturesRequest) (*ListFeaturesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListFeatures not implemented")
}
func (UnimplementedFeatureRegistryServiceServer) UpdateFeature(context.Context, *UpdateFeatureRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateFeature not implemented")
}
func (UnimplementedFeatureRegistryServiceServer) DeleteFeature(context.Context, *DeleteFeatureRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteFeature not implemented")
}
func (UnimplementedFeatureRegistryServiceServer) CreateFeatureMonitor(context.Context, *CreateFeatureMonitorRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateFeatureMonitor not implemented")
}
func (UnimplementedFeatureRegistryServiceServer) GetFeatureMonitor(context.Context, *GetFeatureMonitorRequest) (*FeatureMonitor, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetFeatureMonitor not implemented")
}
func (UnimplementedFeatureRegistryServiceServer) ListFeatureMonitors(context.Context, *ListFeatureMonitorsRequest) (*ListFeatureMonitorsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListFeatureMonitors not implemented")
}
func (UnimplementedFeatureRegistryServiceServer) UpdateFeatureMonitor(context.Context, *UpdateFeatureMonitorRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateFeatureMonitor not implemented")
}
func (UnimplementedFeatureRegistryServiceServer) DeleteFeatureMonitor(context.Context, *DeleteFeatureMonitorRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteFeatureMonitor not implemented")
}
func (UnimplementedFeatureRegistryServiceServer) CreateFeatureMonitorJob(context.Context, *CreateFeatureMonitorJobRequest) (*FeatureMonitorJob, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateFeatureMonitorJob not implemented")
}
func (UnimplementedFeatureRegistryServiceServer) GetFeatureMonitorJob(context.Context, *GetFeatureMonitorJobRequest) (*FeatureMonitorJob, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetFeatureMonitorJob not implemented")
}
func (UnimplementedFeatureRegistryServiceServer) ListFeatureMonitorJobs(context.Context, *ListFeatureMonitorJobsRequest) (*ListFeatureMonitorJobsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListFeatureMonitorJobs not implemented")
}

// UnsafeFeatureRegistryServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to FeatureRegistryServiceServer will
// result in compilation errors.
type UnsafeFeatureRegistryServiceServer interface {
	mustEmbedUnimplementedFeatureRegistryServiceServer()
}

func RegisterFeatureRegistryServiceServer(s grpc.ServiceRegistrar, srv FeatureRegistryServiceServer) {
	s.RegisterService(&FeatureRegistryService_ServiceDesc, srv)
}

func _FeatureRegistryService_CreateFeatureGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateFeatureGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeatureRegistryServiceServer).CreateFeatureGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FeatureRegistryService_CreateFeatureGroup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeatureRegistryServiceServer).CreateFeatureGroup(ctx, req.(*CreateFeatureGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeatureRegistryService_GetFeatureGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFeatureGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeatureRegistryServiceServer).GetFeatureGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FeatureRegistryService_GetFeatureGroup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeatureRegistryServiceServer).GetFeatureGroup(ctx, req.(*GetFeatureGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeatureRegistryService_ListFeatureGroups_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFeatureGroupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeatureRegistryServiceServer).ListFeatureGroups(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FeatureRegistryService_ListFeatureGroups_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeatureRegistryServiceServer).ListFeatureGroups(ctx, req.(*ListFeatureGroupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeatureRegistryService_UpdateFeatureGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateFeatureGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeatureRegistryServiceServer).UpdateFeatureGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FeatureRegistryService_UpdateFeatureGroup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeatureRegistryServiceServer).UpdateFeatureGroup(ctx, req.(*UpdateFeatureGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeatureRegistryService_DeleteFeatureGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteFeatureGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeatureRegistryServiceServer).DeleteFeatureGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FeatureRegistryService_DeleteFeatureGroup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeatureRegistryServiceServer).DeleteFeatureGroup(ctx, req.(*DeleteFeatureGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeatureRegistryService_CreateFeature_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateFeatureRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeatureRegistryServiceServer).CreateFeature(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FeatureRegistryService_CreateFeature_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeatureRegistryServiceServer).CreateFeature(ctx, req.(*CreateFeatureRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeatureRegistryService_BatchCreateFeatures_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchCreateFeaturesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeatureRegistryServiceServer).BatchCreateFeatures(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FeatureRegistryService_BatchCreateFeatures_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeatureRegistryServiceServer).BatchCreateFeatures(ctx, req.(*BatchCreateFeaturesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeatureRegistryService_GetFeature_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFeatureRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeatureRegistryServiceServer).GetFeature(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FeatureRegistryService_GetFeature_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeatureRegistryServiceServer).GetFeature(ctx, req.(*GetFeatureRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeatureRegistryService_ListFeatures_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFeaturesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeatureRegistryServiceServer).ListFeatures(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FeatureRegistryService_ListFeatures_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeatureRegistryServiceServer).ListFeatures(ctx, req.(*ListFeaturesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeatureRegistryService_UpdateFeature_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateFeatureRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeatureRegistryServiceServer).UpdateFeature(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FeatureRegistryService_UpdateFeature_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeatureRegistryServiceServer).UpdateFeature(ctx, req.(*UpdateFeatureRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeatureRegistryService_DeleteFeature_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteFeatureRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeatureRegistryServiceServer).DeleteFeature(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FeatureRegistryService_DeleteFeature_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeatureRegistryServiceServer).DeleteFeature(ctx, req.(*DeleteFeatureRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeatureRegistryService_CreateFeatureMonitor_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateFeatureMonitorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeatureRegistryServiceServer).CreateFeatureMonitor(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FeatureRegistryService_CreateFeatureMonitor_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeatureRegistryServiceServer).CreateFeatureMonitor(ctx, req.(*CreateFeatureMonitorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeatureRegistryService_GetFeatureMonitor_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFeatureMonitorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeatureRegistryServiceServer).GetFeatureMonitor(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FeatureRegistryService_GetFeatureMonitor_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeatureRegistryServiceServer).GetFeatureMonitor(ctx, req.(*GetFeatureMonitorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeatureRegistryService_ListFeatureMonitors_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFeatureMonitorsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeatureRegistryServiceServer).ListFeatureMonitors(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FeatureRegistryService_ListFeatureMonitors_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeatureRegistryServiceServer).ListFeatureMonitors(ctx, req.(*ListFeatureMonitorsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeatureRegistryService_UpdateFeatureMonitor_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateFeatureMonitorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeatureRegistryServiceServer).UpdateFeatureMonitor(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FeatureRegistryService_UpdateFeatureMonitor_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeatureRegistryServiceServer).UpdateFeatureMonitor(ctx, req.(*UpdateFeatureMonitorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeatureRegistryService_DeleteFeatureMonitor_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteFeatureMonitorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeatureRegistryServiceServer).DeleteFeatureMonitor(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FeatureRegistryService_DeleteFeatureMonitor_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeatureRegistryServiceServer).DeleteFeatureMonitor(ctx, req.(*DeleteFeatureMonitorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeatureRegistryService_CreateFeatureMonitorJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateFeatureMonitorJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeatureRegistryServiceServer).CreateFeatureMonitorJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FeatureRegistryService_CreateFeatureMonitorJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeatureRegistryServiceServer).CreateFeatureMonitorJob(ctx, req.(*CreateFeatureMonitorJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeatureRegistryService_GetFeatureMonitorJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFeatureMonitorJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeatureRegistryServiceServer).GetFeatureMonitorJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FeatureRegistryService_GetFeatureMonitorJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeatureRegistryServiceServer).GetFeatureMonitorJob(ctx, req.(*GetFeatureMonitorJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeatureRegistryService_ListFeatureMonitorJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFeatureMonitorJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeatureRegistryServiceServer).ListFeatureMonitorJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FeatureRegistryService_ListFeatureMonitorJobs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeatureRegistryServiceServer).ListFeatureMonitorJobs(ctx, req.(*ListFeatureMonitorJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// FeatureRegistryService_ServiceDesc is the grpc.ServiceDesc for FeatureRegistryService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var FeatureRegistryService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.aiplatform.v1beta1.FeatureRegistryService",
	HandlerType: (*FeatureRegistryServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateFeatureGroup",
			Handler:    _FeatureRegistryService_CreateFeatureGroup_Handler,
		},
		{
			MethodName: "GetFeatureGroup",
			Handler:    _FeatureRegistryService_GetFeatureGroup_Handler,
		},
		{
			MethodName: "ListFeatureGroups",
			Handler:    _FeatureRegistryService_ListFeatureGroups_Handler,
		},
		{
			MethodName: "UpdateFeatureGroup",
			Handler:    _FeatureRegistryService_UpdateFeatureGroup_Handler,
		},
		{
			MethodName: "DeleteFeatureGroup",
			Handler:    _FeatureRegistryService_DeleteFeatureGroup_Handler,
		},
		{
			MethodName: "CreateFeature",
			Handler:    _FeatureRegistryService_CreateFeature_Handler,
		},
		{
			MethodName: "BatchCreateFeatures",
			Handler:    _FeatureRegistryService_BatchCreateFeatures_Handler,
		},
		{
			MethodName: "GetFeature",
			Handler:    _FeatureRegistryService_GetFeature_Handler,
		},
		{
			MethodName: "ListFeatures",
			Handler:    _FeatureRegistryService_ListFeatures_Handler,
		},
		{
			MethodName: "UpdateFeature",
			Handler:    _FeatureRegistryService_UpdateFeature_Handler,
		},
		{
			MethodName: "DeleteFeature",
			Handler:    _FeatureRegistryService_DeleteFeature_Handler,
		},
		{
			MethodName: "CreateFeatureMonitor",
			Handler:    _FeatureRegistryService_CreateFeatureMonitor_Handler,
		},
		{
			MethodName: "GetFeatureMonitor",
			Handler:    _FeatureRegistryService_GetFeatureMonitor_Handler,
		},
		{
			MethodName: "ListFeatureMonitors",
			Handler:    _FeatureRegistryService_ListFeatureMonitors_Handler,
		},
		{
			MethodName: "UpdateFeatureMonitor",
			Handler:    _FeatureRegistryService_UpdateFeatureMonitor_Handler,
		},
		{
			MethodName: "DeleteFeatureMonitor",
			Handler:    _FeatureRegistryService_DeleteFeatureMonitor_Handler,
		},
		{
			MethodName: "CreateFeatureMonitorJob",
			Handler:    _FeatureRegistryService_CreateFeatureMonitorJob_Handler,
		},
		{
			MethodName: "GetFeatureMonitorJob",
			Handler:    _FeatureRegistryService_GetFeatureMonitorJob_Handler,
		},
		{
			MethodName: "ListFeatureMonitorJobs",
			Handler:    _FeatureRegistryService_ListFeatureMonitorJobs_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/aiplatform/v1beta1/feature_registry_service.proto",
}
