// Copyright 2025 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package migrationcenter provides access to the Migration Center API.
//
// For product documentation, see: https://cloud.google.com/migration-center
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/migrationcenter/v1"
//	...
//	ctx := context.Background()
//	migrationcenterService, err := migrationcenter.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	migrationcenterService, err := migrationcenter.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	migrationcenterService, err := migrationcenter.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package migrationcenter // import "google.golang.org/api/migrationcenter/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "migrationcenter:v1"
const apiName = "migrationcenter"
const apiVersion = "v1"
const basePath = "https://migrationcenter.googleapis.com/"
const basePathTemplate = "https://migrationcenter.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://migrationcenter.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Projects = NewProjectsService(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Locations = NewProjectsLocationsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Locations *ProjectsLocationsService
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.Assets = NewProjectsLocationsAssetsService(s)
	rs.DiscoveryClients = NewProjectsLocationsDiscoveryClientsService(s)
	rs.Groups = NewProjectsLocationsGroupsService(s)
	rs.ImportJobs = NewProjectsLocationsImportJobsService(s)
	rs.Operations = NewProjectsLocationsOperationsService(s)
	rs.PreferenceSets = NewProjectsLocationsPreferenceSetsService(s)
	rs.Relations = NewProjectsLocationsRelationsService(s)
	rs.ReportConfigs = NewProjectsLocationsReportConfigsService(s)
	rs.Sources = NewProjectsLocationsSourcesService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	Assets *ProjectsLocationsAssetsService

	DiscoveryClients *ProjectsLocationsDiscoveryClientsService

	Groups *ProjectsLocationsGroupsService

	ImportJobs *ProjectsLocationsImportJobsService

	Operations *ProjectsLocationsOperationsService

	PreferenceSets *ProjectsLocationsPreferenceSetsService

	Relations *ProjectsLocationsRelationsService

	ReportConfigs *ProjectsLocationsReportConfigsService

	Sources *ProjectsLocationsSourcesService
}

func NewProjectsLocationsAssetsService(s *Service) *ProjectsLocationsAssetsService {
	rs := &ProjectsLocationsAssetsService{s: s}
	return rs
}

type ProjectsLocationsAssetsService struct {
	s *Service
}

func NewProjectsLocationsDiscoveryClientsService(s *Service) *ProjectsLocationsDiscoveryClientsService {
	rs := &ProjectsLocationsDiscoveryClientsService{s: s}
	return rs
}

type ProjectsLocationsDiscoveryClientsService struct {
	s *Service
}

func NewProjectsLocationsGroupsService(s *Service) *ProjectsLocationsGroupsService {
	rs := &ProjectsLocationsGroupsService{s: s}
	return rs
}

type ProjectsLocationsGroupsService struct {
	s *Service
}

func NewProjectsLocationsImportJobsService(s *Service) *ProjectsLocationsImportJobsService {
	rs := &ProjectsLocationsImportJobsService{s: s}
	rs.ImportDataFiles = NewProjectsLocationsImportJobsImportDataFilesService(s)
	return rs
}

type ProjectsLocationsImportJobsService struct {
	s *Service

	ImportDataFiles *ProjectsLocationsImportJobsImportDataFilesService
}

func NewProjectsLocationsImportJobsImportDataFilesService(s *Service) *ProjectsLocationsImportJobsImportDataFilesService {
	rs := &ProjectsLocationsImportJobsImportDataFilesService{s: s}
	return rs
}

type ProjectsLocationsImportJobsImportDataFilesService struct {
	s *Service
}

func NewProjectsLocationsOperationsService(s *Service) *ProjectsLocationsOperationsService {
	rs := &ProjectsLocationsOperationsService{s: s}
	return rs
}

type ProjectsLocationsOperationsService struct {
	s *Service
}

func NewProjectsLocationsPreferenceSetsService(s *Service) *ProjectsLocationsPreferenceSetsService {
	rs := &ProjectsLocationsPreferenceSetsService{s: s}
	return rs
}

type ProjectsLocationsPreferenceSetsService struct {
	s *Service
}

func NewProjectsLocationsRelationsService(s *Service) *ProjectsLocationsRelationsService {
	rs := &ProjectsLocationsRelationsService{s: s}
	return rs
}

type ProjectsLocationsRelationsService struct {
	s *Service
}

func NewProjectsLocationsReportConfigsService(s *Service) *ProjectsLocationsReportConfigsService {
	rs := &ProjectsLocationsReportConfigsService{s: s}
	rs.Reports = NewProjectsLocationsReportConfigsReportsService(s)
	return rs
}

type ProjectsLocationsReportConfigsService struct {
	s *Service

	Reports *ProjectsLocationsReportConfigsReportsService
}

func NewProjectsLocationsReportConfigsReportsService(s *Service) *ProjectsLocationsReportConfigsReportsService {
	rs := &ProjectsLocationsReportConfigsReportsService{s: s}
	return rs
}

type ProjectsLocationsReportConfigsReportsService struct {
	s *Service
}

func NewProjectsLocationsSourcesService(s *Service) *ProjectsLocationsSourcesService {
	rs := &ProjectsLocationsSourcesService{s: s}
	rs.ErrorFrames = NewProjectsLocationsSourcesErrorFramesService(s)
	return rs
}

type ProjectsLocationsSourcesService struct {
	s *Service

	ErrorFrames *ProjectsLocationsSourcesErrorFramesService
}

func NewProjectsLocationsSourcesErrorFramesService(s *Service) *ProjectsLocationsSourcesErrorFramesService {
	rs := &ProjectsLocationsSourcesErrorFramesService{s: s}
	return rs
}

type ProjectsLocationsSourcesErrorFramesService struct {
	s *Service
}

// AddAssetsToGroupRequest: A request to add assets to a group.
type AddAssetsToGroupRequest struct {
	// AllowExisting: Optional. When this value is set to `false` and one of the
	// given assets is already an existing member of the group, the operation fails
	// with an `Already Exists` error. When set to `true` this situation is
	// silently ignored by the server. Default value is `false`.
	AllowExisting bool `json:"allowExisting,omitempty"`
	// Assets: Required. List of assets to be added. The maximum number of assets
	// that can be added in a single request is 2000.
	Assets *AssetList `json:"assets,omitempty"`
	// RequestId: Optional. An optional request ID to identify requests. Specify a
	// unique request ID so that if you must retry your request, the server will
	// know to ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes after the first request. For example,
	// consider a situation where you make an initial request and the request times
	// out. If you make the request again with the same request ID, the server can
	// check if original operation with the same request ID was received, and if
	// so, will ignore the second request. This prevents clients from accidentally
	// creating duplicate commitments. The request ID must be a valid UUID with the
	// exception that zero UUID is not supported
	// (00000000-0000-0000-0000-000000000000).
	RequestId string `json:"requestId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowExisting") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowExisting") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AddAssetsToGroupRequest) MarshalJSON() ([]byte, error) {
	type NoMethod AddAssetsToGroupRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AggregateAssetsValuesRequest: A request to aggregate one or more values.
type AggregateAssetsValuesRequest struct {
	// Aggregations: Array of aggregations to perform. Up to 25 aggregations can be
	// defined.
	Aggregations []*Aggregation `json:"aggregations,omitempty"`
	// Filter: Optional. The aggregation will be performed on assets that match the
	// provided filter.
	Filter string `json:"filter,omitempty"`
	// ShowHidden: Optional. When this value is set to 'true,' the response will
	// include all assets, including those that are hidden.
	ShowHidden bool `json:"showHidden,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Aggregations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Aggregations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AggregateAssetsValuesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod AggregateAssetsValuesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AggregateAssetsValuesResponse: A response to a request to aggregated assets
// values.
type AggregateAssetsValuesResponse struct {
	// Results: The aggregation results.
	Results []*AggregationResult `json:"results,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Results") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Results") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AggregateAssetsValuesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod AggregateAssetsValuesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Aggregation: Message describing an aggregation. The message includes the
// aggregation type, parameters, and the field on which to perform the
// aggregation.
type Aggregation struct {
	// Count: Count the number of matching objects.
	Count *AggregationCount `json:"count,omitempty"`
	// Field: The name of the field on which to aggregate.
	Field string `json:"field,omitempty"`
	// Frequency: Creates a frequency distribution of all field values.
	Frequency *AggregationFrequency `json:"frequency,omitempty"`
	// Histogram: Creates a bucketed histogram of field values.
	Histogram *AggregationHistogram `json:"histogram,omitempty"`
	// Sum: Sum over a numeric field.
	Sum *AggregationSum `json:"sum,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Count") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Count") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Aggregation) MarshalJSON() ([]byte, error) {
	type NoMethod Aggregation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AggregationCount: Object count.
type AggregationCount struct {
}

// AggregationFrequency: Frequency distribution of all field values.
type AggregationFrequency struct {
}

// AggregationHistogram: Histogram of bucketed assets counts by field value.
type AggregationHistogram struct {
	// LowerBounds: Lower bounds of buckets. The response will contain `n+1`
	// buckets for `n` bounds. The first bucket will count all assets for which the
	// field value is smaller than the first bound. Subsequent buckets will count
	// assets for which the field value is greater or equal to a lower bound and
	// smaller than the next one. The last bucket will count assets for which the
	// field value is greater or equal to the final lower bound. You can define up
	// to 20 lower bounds.
	LowerBounds []float64 `json:"lowerBounds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LowerBounds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LowerBounds") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AggregationHistogram) MarshalJSON() ([]byte, error) {
	type NoMethod AggregationHistogram
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *AggregationHistogram) UnmarshalJSON(data []byte) error {
	type NoMethod AggregationHistogram
	var s1 struct {
		LowerBounds []gensupport.JSONFloat64 `json:"lowerBounds"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.LowerBounds = make([]float64, len(s1.LowerBounds))
	for i := range s1.LowerBounds {
		s.LowerBounds[i] = float64(s1.LowerBounds[i])
	}
	return nil
}

// AggregationResult: Message describing a result of an aggregation.
type AggregationResult struct {
	Count     *AggregationResultCount     `json:"count,omitempty"`
	Field     string                      `json:"field,omitempty"`
	Frequency *AggregationResultFrequency `json:"frequency,omitempty"`
	Histogram *AggregationResultHistogram `json:"histogram,omitempty"`
	Sum       *AggregationResultSum       `json:"sum,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Count") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Count") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AggregationResult) MarshalJSON() ([]byte, error) {
	type NoMethod AggregationResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AggregationResultCount: The result of a count aggregation.
type AggregationResultCount struct {
	Value int64 `json:"value,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "Value") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Value") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AggregationResultCount) MarshalJSON() ([]byte, error) {
	type NoMethod AggregationResultCount
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AggregationResultFrequency: The result of a frequency distribution
// aggregation.
type AggregationResultFrequency struct {
	Values map[string]string `json:"values,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Values") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Values") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AggregationResultFrequency) MarshalJSON() ([]byte, error) {
	type NoMethod AggregationResultFrequency
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AggregationResultHistogram: The result of a bucketed histogram aggregation.
type AggregationResultHistogram struct {
	// Buckets: Buckets in the histogram. There will be `n+1` buckets matching `n`
	// lower bounds in the request. The first bucket will be from -infinity to the
	// first bound. Subsequent buckets will be between one bound and the next. The
	// final bucket will be from the final bound to infinity.
	Buckets []*AggregationResultHistogramBucket `json:"buckets,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Buckets") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Buckets") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AggregationResultHistogram) MarshalJSON() ([]byte, error) {
	type NoMethod AggregationResultHistogram
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AggregationResultHistogramBucket: A histogram bucket with a lower and upper
// bound, and a count of items with a field value between those bounds. The
// lower bound is inclusive and the upper bound is exclusive. Lower bound may
// be -infinity and upper bound may be infinity.
type AggregationResultHistogramBucket struct {
	// Count: Count of items in the bucket.
	Count int64 `json:"count,omitempty,string"`
	// LowerBound: Lower bound - inclusive.
	LowerBound float64 `json:"lowerBound,omitempty"`
	// UpperBound: Upper bound - exclusive.
	UpperBound float64 `json:"upperBound,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Count") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Count") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AggregationResultHistogramBucket) MarshalJSON() ([]byte, error) {
	type NoMethod AggregationResultHistogramBucket
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *AggregationResultHistogramBucket) UnmarshalJSON(data []byte) error {
	type NoMethod AggregationResultHistogramBucket
	var s1 struct {
		LowerBound gensupport.JSONFloat64 `json:"lowerBound"`
		UpperBound gensupport.JSONFloat64 `json:"upperBound"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.LowerBound = float64(s1.LowerBound)
	s.UpperBound = float64(s1.UpperBound)
	return nil
}

// AggregationResultSum: The result of a sum aggregation.
type AggregationResultSum struct {
	Value float64 `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Value") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Value") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AggregationResultSum) MarshalJSON() ([]byte, error) {
	type NoMethod AggregationResultSum
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *AggregationResultSum) UnmarshalJSON(data []byte) error {
	type NoMethod AggregationResultSum
	var s1 struct {
		Value gensupport.JSONFloat64 `json:"value"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Value = float64(s1.Value)
	return nil
}

// AggregationSum: Sum of field values.
type AggregationSum struct {
}

// Asset: An asset represents a resource in your environment. Asset types
// include virtual machines and databases.
type Asset struct {
	// AssignedGroups: Output only. The list of groups that the asset is assigned
	// to.
	AssignedGroups []string `json:"assignedGroups,omitempty"`
	// Attributes: Generic asset attributes.
	Attributes map[string]string `json:"attributes,omitempty"`
	// CreateTime: Output only. The timestamp when the asset was created.
	CreateTime string `json:"createTime,omitempty"`
	// DatabaseDeploymentDetails: Output only. Asset information specific for
	// database deployments.
	DatabaseDeploymentDetails *DatabaseDeploymentDetails `json:"databaseDeploymentDetails,omitempty"`
	// DatabaseDetails: Output only. Asset information specific for logical
	// databases.
	DatabaseDetails *DatabaseDetails `json:"databaseDetails,omitempty"`
	// Hidden: Optional. Indicates if the asset is hidden.
	Hidden bool `json:"hidden,omitempty"`
	// HideReason: Optional. An optional reason for marking this asset as hidden.
	HideReason string `json:"hideReason,omitempty"`
	// HideTime: Output only. The timestamp when the asset was marked as hidden.
	HideTime string `json:"hideTime,omitempty"`
	// InsightList: Output only. The list of insights associated with the asset.
	InsightList *InsightList `json:"insightList,omitempty"`
	// Labels: Labels as key value pairs.
	Labels map[string]string `json:"labels,omitempty"`
	// MachineDetails: Output only. Asset information specific for virtual and
	// physical machines.
	MachineDetails *MachineDetails `json:"machineDetails,omitempty"`
	// Name: Output only. The full name of the asset.
	Name string `json:"name,omitempty"`
	// PerformanceData: Output only. Performance data for the asset.
	PerformanceData *AssetPerformanceData `json:"performanceData,omitempty"`
	// Sources: Output only. The list of sources contributing to the asset.
	Sources []string `json:"sources,omitempty"`
	// Title: Output only. Server generated human readable name of the asset.
	Title string `json:"title,omitempty"`
	// UpdateTime: Output only. The timestamp when the asset was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AssignedGroups") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AssignedGroups") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Asset) MarshalJSON() ([]byte, error) {
	type NoMethod Asset
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AssetFrame: Contains data reported from an inventory source on an asset.
type AssetFrame struct {
	// Attributes: Generic asset attributes.
	Attributes map[string]string `json:"attributes,omitempty"`
	// CollectionType: Optional. Frame collection type, if not specified the
	// collection type will be based on the source type of the source the frame was
	// reported on.
	//
	// Possible values:
	//   "SOURCE_TYPE_UNKNOWN" - Unspecified
	//   "SOURCE_TYPE_UPLOAD" - Manually uploaded file (e.g. CSV)
	//   "SOURCE_TYPE_GUEST_OS_SCAN" - Guest-level info
	//   "SOURCE_TYPE_INVENTORY_SCAN" - Inventory-level scan
	//   "SOURCE_TYPE_CUSTOM" - Third-party owned sources.
	//   "SOURCE_TYPE_DISCOVERY_CLIENT" - Discovery clients
	CollectionType string `json:"collectionType,omitempty"`
	// DatabaseDeploymentDetails: Asset information specific for database
	// deployments.
	DatabaseDeploymentDetails *DatabaseDeploymentDetails `json:"databaseDeploymentDetails,omitempty"`
	// DatabaseDetails: Asset information specific for logical databases.
	DatabaseDetails *DatabaseDetails `json:"databaseDetails,omitempty"`
	// Labels: Labels as key value pairs.
	Labels map[string]string `json:"labels,omitempty"`
	// MachineDetails: Asset information specific for virtual machines.
	MachineDetails *MachineDetails `json:"machineDetails,omitempty"`
	// PerformanceSamples: Asset performance data samples. Samples that are from
	// more than 40 days ago or after tomorrow are ignored.
	PerformanceSamples []*PerformanceSample `json:"performanceSamples,omitempty"`
	// ReportTime: The time the data was reported.
	ReportTime string `json:"reportTime,omitempty"`
	// TraceToken: Optional. Trace token is optionally provided to assist with
	// debugging and traceability.
	TraceToken string `json:"traceToken,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Attributes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Attributes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AssetFrame) MarshalJSON() ([]byte, error) {
	type NoMethod AssetFrame
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AssetList: Lists the asset IDs of all assets.
type AssetList struct {
	// AssetIds: Required. A list of asset IDs
	AssetIds []string `json:"assetIds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AssetIds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AssetIds") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AssetList) MarshalJSON() ([]byte, error) {
	type NoMethod AssetList
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AssetPerformanceData: Performance data for an asset.
type AssetPerformanceData struct {
	// DailyResourceUsageAggregations: Daily resource usage aggregations. Contains
	// all of the data available for an asset, up to the last 420 days.
	// Aggregations are sorted from oldest to most recent.
	DailyResourceUsageAggregations []*DailyResourceUsageAggregation `json:"dailyResourceUsageAggregations,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "DailyResourceUsageAggregations") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DailyResourceUsageAggregations")
	// to include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AssetPerformanceData) MarshalJSON() ([]byte, error) {
	type NoMethod AssetPerformanceData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AwsEc2PlatformDetails: AWS EC2 specific details.
type AwsEc2PlatformDetails struct {
	// Hyperthreading: Optional. Whether the machine is hyperthreaded.
	//
	// Possible values:
	//   "HYPERTHREADING_STATUS_UNSPECIFIED" - Simultaneous Multithreading status
	// unknown.
	//   "HYPERTHREADING_STATUS_DISABLED" - Simultaneous Multithreading is disabled
	// or unavailable.
	//   "HYPERTHREADING_STATUS_ENABLED" - Simultaneous Multithreading is enabled.
	Hyperthreading string `json:"hyperthreading,omitempty"`
	// Location: The location of the machine in the AWS format.
	Location string `json:"location,omitempty"`
	// MachineTypeLabel: AWS platform's machine type label.
	MachineTypeLabel string `json:"machineTypeLabel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Hyperthreading") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Hyperthreading") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AwsEc2PlatformDetails) MarshalJSON() ([]byte, error) {
	type NoMethod AwsEc2PlatformDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AwsRds: Specific details for an AWS RDS database deployment.
type AwsRds struct {
}

// AzureVmPlatformDetails: Azure VM specific details.
type AzureVmPlatformDetails struct {
	// Hyperthreading: Whether the machine is hyperthreaded.
	//
	// Possible values:
	//   "HYPERTHREADING_STATUS_UNSPECIFIED" - Simultaneous Multithreading status
	// unknown.
	//   "HYPERTHREADING_STATUS_DISABLED" - Simultaneous Multithreading is disabled
	// or unavailable.
	//   "HYPERTHREADING_STATUS_ENABLED" - Simultaneous Multithreading is enabled.
	Hyperthreading string `json:"hyperthreading,omitempty"`
	// Location: The location of the machine in the Azure format.
	Location string `json:"location,omitempty"`
	// MachineTypeLabel: Azure platform's machine type label.
	MachineTypeLabel string `json:"machineTypeLabel,omitempty"`
	// ProvisioningState: Azure platform's provisioning state.
	ProvisioningState string `json:"provisioningState,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Hyperthreading") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Hyperthreading") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AzureVmPlatformDetails) MarshalJSON() ([]byte, error) {
	type NoMethod AzureVmPlatformDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BatchDeleteAssetsRequest: A request to delete a list of asset.
type BatchDeleteAssetsRequest struct {
	// AllowMissing: Optional. When this value is set to `true` the request is a
	// no-op for non-existing assets. See
	// https://google.aip.dev/135#delete-if-existing for additional details.
	// Default value is `false`.
	AllowMissing bool `json:"allowMissing,omitempty"`
	// CascadingRules: Optional. Optional cascading rules for deleting related
	// assets.
	CascadingRules []*CascadingRule `json:"cascadingRules,omitempty"`
	// Names: Required. The IDs of the assets to delete. A maximum of 1000 assets
	// can be deleted in a batch. Format:
	// projects/{project}/locations/{location}/assets/{name}.
	Names []string `json:"names,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowMissing") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowMissing") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BatchDeleteAssetsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod BatchDeleteAssetsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BatchUpdateAssetsRequest: A request to update a list of assets.
type BatchUpdateAssetsRequest struct {
	// Requests: Required. The request message specifying the resources to update.
	// A maximum of 1000 assets can be modified in a batch.
	Requests []*UpdateAssetRequest `json:"requests,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Requests") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Requests") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BatchUpdateAssetsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod BatchUpdateAssetsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BatchUpdateAssetsResponse: Response for updating a list of assets.
type BatchUpdateAssetsResponse struct {
	// Assets: Update asset content. The content only includes values after field
	// mask being applied.
	Assets []*Asset `json:"assets,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Assets") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Assets") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BatchUpdateAssetsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod BatchUpdateAssetsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BiosDetails: Details about the BIOS.
type BiosDetails struct {
	// BiosName: BIOS name. This fields is deprecated. Please use the `id` field
	// instead.
	BiosName string `json:"biosName,omitempty"`
	// Id: BIOS ID.
	Id string `json:"id,omitempty"`
	// Manufacturer: BIOS manufacturer.
	Manufacturer string `json:"manufacturer,omitempty"`
	// ReleaseDate: BIOS release date.
	ReleaseDate *Date `json:"releaseDate,omitempty"`
	// SmbiosUuid: SMBIOS UUID.
	SmbiosUuid string `json:"smbiosUuid,omitempty"`
	// Version: BIOS version.
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BiosName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BiosName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BiosDetails) MarshalJSON() ([]byte, error) {
	type NoMethod BiosDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CancelOperationRequest: The request message for Operations.CancelOperation.
type CancelOperationRequest struct {
}

// CascadeLogicalDBsRule: Cascading rule for related logical DBs.
type CascadeLogicalDBsRule struct {
}

// CascadingRule: Specifies cascading rules for traversing relations.
type CascadingRule struct {
	// CascadeLogicalDbs: Cascading rule for related logical DBs.
	CascadeLogicalDbs *CascadeLogicalDBsRule `json:"cascadeLogicalDbs,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CascadeLogicalDbs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CascadeLogicalDbs") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CascadingRule) MarshalJSON() ([]byte, error) {
	type NoMethod CascadingRule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ComputeEngineMigrationTarget: Compute engine migration target.
type ComputeEngineMigrationTarget struct {
	// Shape: Description of the suggested shape for the migration target.
	Shape *ComputeEngineShapeDescriptor `json:"shape,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Shape") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Shape") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ComputeEngineMigrationTarget) MarshalJSON() ([]byte, error) {
	type NoMethod ComputeEngineMigrationTarget
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ComputeEnginePreferences: The user preferences relating to Compute Engine
// target platform.
type ComputeEnginePreferences struct {
	// LicenseType: License type to consider when calculating costs for virtual
	// machine insights and recommendations. If unspecified, costs are calculated
	// based on the default licensing plan.
	//
	// Possible values:
	//   "LICENSE_TYPE_UNSPECIFIED" - Unspecified (default value).
	//   "LICENSE_TYPE_DEFAULT" - Default Google Cloud licensing plan. Licensing is
	// charged per usage. This a good value to start with.
	//   "LICENSE_TYPE_BRING_YOUR_OWN_LICENSE" - Bring-your-own-license (BYOL)
	// plan. User provides the OS license.
	LicenseType string `json:"licenseType,omitempty"`
	// MachinePreferences: Preferences concerning the machine types to consider on
	// Compute Engine.
	MachinePreferences *MachinePreferences `json:"machinePreferences,omitempty"`
	// PersistentDiskType: Persistent disk type to use. If unspecified (default),
	// all types are considered, based on available usage data.
	//
	// Possible values:
	//   "PERSISTENT_DISK_TYPE_UNSPECIFIED" - Unspecified. Fallback to default
	// value based on context.
	//   "PERSISTENT_DISK_TYPE_STANDARD" - Standard HDD Persistent Disk.
	//   "PERSISTENT_DISK_TYPE_BALANCED" - Balanced Persistent Disk.
	//   "PERSISTENT_DISK_TYPE_SSD" - SSD Persistent Disk.
	PersistentDiskType string `json:"persistentDiskType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LicenseType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LicenseType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ComputeEnginePreferences) MarshalJSON() ([]byte, error) {
	type NoMethod ComputeEnginePreferences
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ComputeEngineShapeDescriptor: Compute Engine target shape descriptor.
type ComputeEngineShapeDescriptor struct {
	// LogicalCoreCount: Output only. Number of logical cores.
	LogicalCoreCount int64 `json:"logicalCoreCount,omitempty"`
	// MachineType: Output only. Compute Engine machine type.
	MachineType string `json:"machineType,omitempty"`
	// MemoryMb: Memory in mebibytes.
	MemoryMb int64 `json:"memoryMb,omitempty"`
	// PhysicalCoreCount: Number of physical cores.
	PhysicalCoreCount int64 `json:"physicalCoreCount,omitempty"`
	// Series: Output only. Compute Engine machine series.
	Series string `json:"series,omitempty"`
	// Storage: Output only. Compute Engine storage. Never empty.
	Storage []*ComputeStorageDescriptor `json:"storage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LogicalCoreCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LogicalCoreCount") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ComputeEngineShapeDescriptor) MarshalJSON() ([]byte, error) {
	type NoMethod ComputeEngineShapeDescriptor
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ComputeStorageDescriptor: Compute Engine storage option descriptor.
type ComputeStorageDescriptor struct {
	// SizeGb: Output only. Disk size in GiB.
	SizeGb int64 `json:"sizeGb,omitempty"`
	// Type: Output only. Disk type backing the storage.
	//
	// Possible values:
	//   "PERSISTENT_DISK_TYPE_UNSPECIFIED" - Unspecified. Fallback to default
	// value based on context.
	//   "PERSISTENT_DISK_TYPE_STANDARD" - Standard HDD Persistent Disk.
	//   "PERSISTENT_DISK_TYPE_BALANCED" - Balanced Persistent Disk.
	//   "PERSISTENT_DISK_TYPE_SSD" - SSD Persistent Disk.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SizeGb") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SizeGb") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ComputeStorageDescriptor) MarshalJSON() ([]byte, error) {
	type NoMethod ComputeStorageDescriptor
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CpuUsageSample: CPU usage sample.
type CpuUsageSample struct {
	// UtilizedPercentage: Percentage of total CPU capacity utilized. Must be in
	// the interval [0, 100]. On most systems can be calculated using 100 - idle
	// percentage.
	UtilizedPercentage float64 `json:"utilizedPercentage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "UtilizedPercentage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "UtilizedPercentage") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CpuUsageSample) MarshalJSON() ([]byte, error) {
	type NoMethod CpuUsageSample
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *CpuUsageSample) UnmarshalJSON(data []byte) error {
	type NoMethod CpuUsageSample
	var s1 struct {
		UtilizedPercentage gensupport.JSONFloat64 `json:"utilizedPercentage"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.UtilizedPercentage = float64(s1.UtilizedPercentage)
	return nil
}

// DailyResourceUsageAggregation: Usage data aggregation for a single day.
type DailyResourceUsageAggregation struct {
	// Cpu: CPU usage.
	Cpu *DailyResourceUsageAggregationCPU `json:"cpu,omitempty"`
	// Date: Aggregation date. Day boundaries are at midnight UTC.
	Date *Date `json:"date,omitempty"`
	// Disk: Disk usage.
	Disk *DailyResourceUsageAggregationDisk `json:"disk,omitempty"`
	// Memory: Memory usage.
	Memory *DailyResourceUsageAggregationMemory `json:"memory,omitempty"`
	// Network: Network usage.
	Network *DailyResourceUsageAggregationNetwork `json:"network,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Cpu") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Cpu") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DailyResourceUsageAggregation) MarshalJSON() ([]byte, error) {
	type NoMethod DailyResourceUsageAggregation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DailyResourceUsageAggregationCPU: Statistical aggregation of CPU usage.
type DailyResourceUsageAggregationCPU struct {
	// UtilizationPercentage: CPU utilization percentage.
	UtilizationPercentage *DailyResourceUsageAggregationStats `json:"utilizationPercentage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "UtilizationPercentage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "UtilizationPercentage") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DailyResourceUsageAggregationCPU) MarshalJSON() ([]byte, error) {
	type NoMethod DailyResourceUsageAggregationCPU
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DailyResourceUsageAggregationDisk: Statistical aggregation of disk usage.
type DailyResourceUsageAggregationDisk struct {
	// Iops: Optional. Disk I/O operations per second.
	Iops *DailyResourceUsageAggregationStats `json:"iops,omitempty"`
	// ReadIops: Optional. Disk read I/O operations per second.
	ReadIops *DailyResourceUsageAggregationStats `json:"readIops,omitempty"`
	// WriteIops: Optional. Disk write I/O operations per second.
	WriteIops *DailyResourceUsageAggregationStats `json:"writeIops,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Iops") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Iops") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DailyResourceUsageAggregationDisk) MarshalJSON() ([]byte, error) {
	type NoMethod DailyResourceUsageAggregationDisk
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DailyResourceUsageAggregationMemory: Statistical aggregation of memory
// usage.
type DailyResourceUsageAggregationMemory struct {
	// UtilizationPercentage: Memory utilization percentage.
	UtilizationPercentage *DailyResourceUsageAggregationStats `json:"utilizationPercentage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "UtilizationPercentage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "UtilizationPercentage") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DailyResourceUsageAggregationMemory) MarshalJSON() ([]byte, error) {
	type NoMethod DailyResourceUsageAggregationMemory
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DailyResourceUsageAggregationNetwork: Statistical aggregation of network
// usage.
type DailyResourceUsageAggregationNetwork struct {
	// EgressBps: Network egress in B/s.
	EgressBps *DailyResourceUsageAggregationStats `json:"egressBps,omitempty"`
	// IngressBps: Network ingress in B/s.
	IngressBps *DailyResourceUsageAggregationStats `json:"ingressBps,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EgressBps") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EgressBps") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DailyResourceUsageAggregationNetwork) MarshalJSON() ([]byte, error) {
	type NoMethod DailyResourceUsageAggregationNetwork
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DailyResourceUsageAggregationStats: Statistical aggregation of samples for a
// single resource usage.
type DailyResourceUsageAggregationStats struct {
	// Average: Average usage value.
	Average float64 `json:"average,omitempty"`
	// Median: Median usage value.
	Median float64 `json:"median,omitempty"`
	// NinteyFifthPercentile: 95th percentile usage value.
	NinteyFifthPercentile float64 `json:"ninteyFifthPercentile,omitempty"`
	// Peak: Peak usage value.
	Peak float64 `json:"peak,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Average") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Average") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DailyResourceUsageAggregationStats) MarshalJSON() ([]byte, error) {
	type NoMethod DailyResourceUsageAggregationStats
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *DailyResourceUsageAggregationStats) UnmarshalJSON(data []byte) error {
	type NoMethod DailyResourceUsageAggregationStats
	var s1 struct {
		Average               gensupport.JSONFloat64 `json:"average"`
		Median                gensupport.JSONFloat64 `json:"median"`
		NinteyFifthPercentile gensupport.JSONFloat64 `json:"ninteyFifthPercentile"`
		Peak                  gensupport.JSONFloat64 `json:"peak"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Average = float64(s1.Average)
	s.Median = float64(s1.Median)
	s.NinteyFifthPercentile = float64(s1.NinteyFifthPercentile)
	s.Peak = float64(s1.Peak)
	return nil
}

// DatabaseDeploymentDetails: The details of a database deployment asset.
type DatabaseDeploymentDetails struct {
	// AggregatedStats: Output only. Aggregated stats for the database deployment.
	AggregatedStats *DatabaseDeploymentDetailsAggregatedStats `json:"aggregatedStats,omitempty"`
	// AwsRds: Optional. Details of an AWS RDS instance.
	AwsRds *AwsRds `json:"awsRds,omitempty"`
	// Edition: Optional. The database deployment edition.
	Edition string `json:"edition,omitempty"`
	// GeneratedId: Optional. The database deployment generated ID.
	GeneratedId string `json:"generatedId,omitempty"`
	// ManualUniqueId: Optional. A manual unique ID set by the user.
	ManualUniqueId string `json:"manualUniqueId,omitempty"`
	// Mysql: Optional. Details of a MYSQL database deployment.
	Mysql *MysqlDatabaseDeployment `json:"mysql,omitempty"`
	// Postgresql: Optional. Details of a PostgreSQL database deployment.
	Postgresql *PostgreSqlDatabaseDeployment `json:"postgresql,omitempty"`
	// SqlServer: Optional. Details of a Microsoft SQL Server database deployment.
	SqlServer *SqlServerDatabaseDeployment `json:"sqlServer,omitempty"`
	// Topology: Optional. Details of the database deployment topology.
	Topology *DatabaseDeploymentTopology `json:"topology,omitempty"`
	// Version: Optional. The database deployment version.
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AggregatedStats") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AggregatedStats") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DatabaseDeploymentDetails) MarshalJSON() ([]byte, error) {
	type NoMethod DatabaseDeploymentDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DatabaseDeploymentDetailsAggregatedStats: Aggregated stats for the database
// deployment.
type DatabaseDeploymentDetailsAggregatedStats struct {
	// DatabaseCount: Output only. The number of databases in the deployment.
	DatabaseCount int64 `json:"databaseCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DatabaseCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DatabaseCount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DatabaseDeploymentDetailsAggregatedStats) MarshalJSON() ([]byte, error) {
	type NoMethod DatabaseDeploymentDetailsAggregatedStats
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DatabaseDeploymentTopology: Details of database deployment's topology.
type DatabaseDeploymentTopology struct {
	// CoreCount: Optional. Number of total logical cores.
	CoreCount int64 `json:"coreCount,omitempty"`
	// CoreLimit: Optional. Number of total logical cores limited by db deployment.
	CoreLimit int64 `json:"coreLimit,omitempty"`
	// DiskAllocatedBytes: Optional. Disk allocated in bytes.
	DiskAllocatedBytes int64 `json:"diskAllocatedBytes,omitempty,string"`
	// DiskUsedBytes: Optional. Disk used in bytes.
	DiskUsedBytes int64 `json:"diskUsedBytes,omitempty,string"`
	// Instances: Optional. List of database instances.
	Instances []*DatabaseInstance `json:"instances,omitempty"`
	// MemoryBytes: Optional. Total memory in bytes.
	MemoryBytes int64 `json:"memoryBytes,omitempty,string"`
	// MemoryLimitBytes: Optional. Total memory in bytes limited by db deployment.
	MemoryLimitBytes int64 `json:"memoryLimitBytes,omitempty,string"`
	// PhysicalCoreCount: Optional. Number of total physical cores.
	PhysicalCoreCount int64 `json:"physicalCoreCount,omitempty"`
	// PhysicalCoreLimit: Optional. Number of total physical cores limited by db
	// deployment.
	PhysicalCoreLimit int64 `json:"physicalCoreLimit,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CoreCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CoreCount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DatabaseDeploymentTopology) MarshalJSON() ([]byte, error) {
	type NoMethod DatabaseDeploymentTopology
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DatabaseDetails: Details of a logical database.
type DatabaseDetails struct {
	// AllocatedStorageBytes: Optional. The allocated storage for the database in
	// bytes.
	AllocatedStorageBytes int64 `json:"allocatedStorageBytes,omitempty,string"`
	// DatabaseName: Required. The name of the database.
	DatabaseName string `json:"databaseName,omitempty"`
	// ParentDatabaseDeployment: Required. The parent database deployment that
	// contains the logical database.
	ParentDatabaseDeployment *DatabaseDetailsParentDatabaseDeployment `json:"parentDatabaseDeployment,omitempty"`
	// Schemas: Optional. The database schemas.
	Schemas []*DatabaseSchema `json:"schemas,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllocatedStorageBytes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllocatedStorageBytes") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DatabaseDetails) MarshalJSON() ([]byte, error) {
	type NoMethod DatabaseDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DatabaseDetailsParentDatabaseDeployment: The identifiers of the parent
// database deployment.
type DatabaseDetailsParentDatabaseDeployment struct {
	// GeneratedId: Optional. The parent database deployment generated ID.
	GeneratedId string `json:"generatedId,omitempty"`
	// ManualUniqueId: Optional. The parent database deployment optional manual
	// unique ID set by the user.
	ManualUniqueId string `json:"manualUniqueId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GeneratedId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GeneratedId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DatabaseDetailsParentDatabaseDeployment) MarshalJSON() ([]byte, error) {
	type NoMethod DatabaseDetailsParentDatabaseDeployment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DatabaseInstance: Details of a database instance.
type DatabaseInstance struct {
	// InstanceName: Optional. The instance's name.
	InstanceName string `json:"instanceName,omitempty"`
	// Network: Optional. Networking details.
	Network *DatabaseInstanceNetwork `json:"network,omitempty"`
	// Role: Optional. The instance role in the database engine.
	//
	// Possible values:
	//   "ROLE_UNSPECIFIED" - Unspecified.
	//   "PRIMARY" - Primary.
	//   "SECONDARY" - Secondary.
	//   "ARBITER" - Arbiter.
	Role string `json:"role,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InstanceName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InstanceName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DatabaseInstance) MarshalJSON() ([]byte, error) {
	type NoMethod DatabaseInstance
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DatabaseInstanceNetwork: Network details of a database instance.
type DatabaseInstanceNetwork struct {
	// HostNames: Optional. The instance's host names.
	HostNames []string `json:"hostNames,omitempty"`
	// IpAddresses: Optional. The instance's IP addresses.
	IpAddresses []string `json:"ipAddresses,omitempty"`
	// PrimaryMacAddress: Optional. The instance's primary MAC address.
	PrimaryMacAddress string `json:"primaryMacAddress,omitempty"`
	// ForceSendFields is a list of field names (e.g. "HostNames") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "HostNames") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DatabaseInstanceNetwork) MarshalJSON() ([]byte, error) {
	type NoMethod DatabaseInstanceNetwork
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DatabaseObjects: Details of a group of database objects.
type DatabaseObjects struct {
	// Category: Optional. The category of the objects.
	//
	// Possible values:
	//   "CATEGORY_UNSPECIFIED" - Unspecified type.
	//   "TABLE" - Table.
	//   "INDEX" - Index.
	//   "CONSTRAINTS" - Constraints.
	//   "VIEWS" - Views.
	//   "SOURCE_CODE" - Source code, e.g. procedures.
	//   "OTHER" - Uncategorized objects.
	Category string `json:"category,omitempty"`
	// Count: Optional. The number of objects.
	Count int64 `json:"count,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "Category") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Category") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DatabaseObjects) MarshalJSON() ([]byte, error) {
	type NoMethod DatabaseObjects
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DatabaseSchema: Details of a database schema.
type DatabaseSchema struct {
	// Mysql: Optional. Details of a Mysql schema.
	Mysql *MySqlSchemaDetails `json:"mysql,omitempty"`
	// Objects: Optional. List of details of objects by category.
	Objects []*DatabaseObjects `json:"objects,omitempty"`
	// Postgresql: Optional. Details of a PostgreSql schema.
	Postgresql *PostgreSqlSchemaDetails `json:"postgresql,omitempty"`
	// SchemaName: Required. The name of the schema.
	SchemaName string `json:"schemaName,omitempty"`
	// SqlServer: Optional. Details of a SqlServer schema.
	SqlServer *SqlServerSchemaDetails `json:"sqlServer,omitempty"`
	// TablesSizeBytes: Optional. The total size of tables in bytes.
	TablesSizeBytes int64 `json:"tablesSizeBytes,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "Mysql") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Mysql") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DatabaseSchema) MarshalJSON() ([]byte, error) {
	type NoMethod DatabaseSchema
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Date: Represents a whole or partial calendar date, such as a birthday. The
// time of day and time zone are either specified elsewhere or are
// insignificant. The date is relative to the Gregorian Calendar. This can
// represent one of the following: * A full date, with non-zero year, month,
// and day values. * A month and day, with a zero year (for example, an
// anniversary). * A year on its own, with a zero month and a zero day. * A
// year and month, with a zero day (for example, a credit card expiration
// date). Related types: * google.type.TimeOfDay * google.type.DateTime *
// google.protobuf.Timestamp
type Date struct {
	// Day: Day of a month. Must be from 1 to 31 and valid for the year and month,
	// or 0 to specify a year by itself or a year and month where the day isn't
	// significant.
	Day int64 `json:"day,omitempty"`
	// Month: Month of a year. Must be from 1 to 12, or 0 to specify a year without
	// a month and day.
	Month int64 `json:"month,omitempty"`
	// Year: Year of the date. Must be from 1 to 9999, or 0 to specify a date
	// without a year.
	Year int64 `json:"year,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Day") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Day") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Date) MarshalJSON() ([]byte, error) {
	type NoMethod Date
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DiscoveryClient: Represents an installed Migration Center Discovery Client
// instance.
type DiscoveryClient struct {
	// CreateTime: Output only. Time when the discovery client was first created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. Free text description. Maximum length is 1000
	// characters.
	Description string `json:"description,omitempty"`
	// DisplayName: Optional. Free text display name. Maximum length is 63
	// characters.
	DisplayName string `json:"displayName,omitempty"`
	// Errors: Output only. Errors affecting client functionality.
	Errors []*Status `json:"errors,omitempty"`
	// ExpireTime: Optional. Client expiration time in UTC. If specified, the
	// backend will not accept new frames after this time.
	ExpireTime string `json:"expireTime,omitempty"`
	// HeartbeatTime: Output only. Last heartbeat time. Healthy clients are
	// expected to send heartbeats regularly (normally every few minutes).
	HeartbeatTime string `json:"heartbeatTime,omitempty"`
	// Labels: Optional. Labels as key value pairs.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Output only. Identifier. Full name of this discovery client.
	Name string `json:"name,omitempty"`
	// ServiceAccount: Required. Service account used by the discovery client for
	// various operation.
	ServiceAccount string `json:"serviceAccount,omitempty"`
	// SignalsEndpoint: Output only. This field is intended for internal use.
	SignalsEndpoint string `json:"signalsEndpoint,omitempty"`
	// Source: Required. Immutable. Full name of the source object associated with
	// this discovery client.
	Source string `json:"source,omitempty"`
	// State: Output only. Current state of the discovery client.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Client state is unspecified.
	//   "ACTIVE" - Client is active.
	//   "OFFLINE" - Client is offline.
	//   "DEGRADED" - Client is in a degraded state. See the `errors` field for
	// details.
	//   "EXPIRED" - Client has expired. See the expire_time field for the expire
	// time.
	State string `json:"state,omitempty"`
	// Ttl: Optional. Input only. Client time-to-live. If specified, the backend
	// will not accept new frames after this time. This field is input only. The
	// derived expiration time is provided as output through the `expire_time`
	// field.
	Ttl string `json:"ttl,omitempty"`
	// UpdateTime: Output only. Time when the discovery client was last updated.
	// This value is not updated by heartbeats, to view the last heartbeat time
	// please refer to the `heartbeat_time` field.
	UpdateTime string `json:"updateTime,omitempty"`
	// Version: Output only. Client version, as reported in recent heartbeat.
	Version string `json:"version,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DiscoveryClient) MarshalJSON() ([]byte, error) {
	type NoMethod DiscoveryClient
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DiskEntry: Single disk entry.
type DiskEntry struct {
	// CapacityBytes: Disk capacity.
	CapacityBytes int64 `json:"capacityBytes,omitempty,string"`
	// DiskLabel: Disk label.
	DiskLabel string `json:"diskLabel,omitempty"`
	// DiskLabelType: Disk label type (e.g. BIOS/GPT)
	DiskLabelType string `json:"diskLabelType,omitempty"`
	// FreeBytes: Disk free space.
	FreeBytes int64 `json:"freeBytes,omitempty,string"`
	// HwAddress: Disk hardware address (e.g. 0:1 for SCSI).
	HwAddress string `json:"hwAddress,omitempty"`
	// InterfaceType: Disks interface type.
	//
	// Possible values:
	//   "INTERFACE_TYPE_UNSPECIFIED" - Interface type unknown or unspecified.
	//   "IDE" - IDE interface type.
	//   "SATA" - SATA interface type.
	//   "SAS" - SAS interface type.
	//   "SCSI" - SCSI interface type.
	//   "NVME" - NVME interface type.
	//   "FC" - FC interface type.
	//   "ISCSI" - iSCSI interface type.
	InterfaceType string `json:"interfaceType,omitempty"`
	// Partitions: Partition layout.
	Partitions *DiskPartitionList `json:"partitions,omitempty"`
	// Vmware: VMware disk details.
	Vmware *VmwareDiskConfig `json:"vmware,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CapacityBytes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CapacityBytes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DiskEntry) MarshalJSON() ([]byte, error) {
	type NoMethod DiskEntry
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DiskEntryList: VM disks.
type DiskEntryList struct {
	// Entries: Disk entries.
	Entries []*DiskEntry `json:"entries,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Entries") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entries") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DiskEntryList) MarshalJSON() ([]byte, error) {
	type NoMethod DiskEntryList
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DiskPartition: Disk Partition details.
type DiskPartition struct {
	// CapacityBytes: Partition capacity.
	CapacityBytes int64 `json:"capacityBytes,omitempty,string"`
	// FileSystem: Partition file system.
	FileSystem string `json:"fileSystem,omitempty"`
	// FreeBytes: Partition free space.
	FreeBytes int64 `json:"freeBytes,omitempty,string"`
	// MountPoint: Mount point (Linux/Windows) or drive letter (Windows).
	MountPoint string `json:"mountPoint,omitempty"`
	// SubPartitions: Sub-partitions.
	SubPartitions *DiskPartitionList `json:"subPartitions,omitempty"`
	// Type: Partition type.
	Type string `json:"type,omitempty"`
	// Uuid: Partition UUID.
	Uuid string `json:"uuid,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CapacityBytes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CapacityBytes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DiskPartition) MarshalJSON() ([]byte, error) {
	type NoMethod DiskPartition
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DiskPartitionDetails: Disk partition details.
type DiskPartitionDetails struct {
	// FreeSpaceBytes: Output only. Total free space of all partitions.
	FreeSpaceBytes int64 `json:"freeSpaceBytes,omitempty,string"`
	// Partitions: Optional. List of partitions.
	Partitions *DiskPartitionList `json:"partitions,omitempty"`
	// TotalCapacityBytes: Output only. Total capacity of all partitions.
	TotalCapacityBytes int64 `json:"totalCapacityBytes,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "FreeSpaceBytes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FreeSpaceBytes") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DiskPartitionDetails) MarshalJSON() ([]byte, error) {
	type NoMethod DiskPartitionDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DiskPartitionList: Disk partition list.
type DiskPartitionList struct {
	// Entries: Partition entries.
	Entries []*DiskPartition `json:"entries,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Entries") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entries") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DiskPartitionList) MarshalJSON() ([]byte, error) {
	type NoMethod DiskPartitionList
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DiskUsageSample: Disk usage sample. Values are across all disks.
type DiskUsageSample struct {
	// AverageIops: Optional. Average IOPS sampled over a short window. Must be
	// non-negative. If read or write are set, the sum of read and write will
	// override the value of the average_iops.
	AverageIops float64 `json:"averageIops,omitempty"`
	// AverageReadIops: Optional. Average read IOPS sampled over a short window.
	// Must be non-negative. If both read and write are zero they are ignored.
	AverageReadIops float64 `json:"averageReadIops,omitempty"`
	// AverageWriteIops: Optional. Average write IOPS sampled over a short window.
	// Must be non-negative. If both read and write are zero they are ignored.
	AverageWriteIops float64 `json:"averageWriteIops,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AverageIops") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AverageIops") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DiskUsageSample) MarshalJSON() ([]byte, error) {
	type NoMethod DiskUsageSample
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *DiskUsageSample) UnmarshalJSON(data []byte) error {
	type NoMethod DiskUsageSample
	var s1 struct {
		AverageIops      gensupport.JSONFloat64 `json:"averageIops"`
		AverageReadIops  gensupport.JSONFloat64 `json:"averageReadIops"`
		AverageWriteIops gensupport.JSONFloat64 `json:"averageWriteIops"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.AverageIops = float64(s1.AverageIops)
	s.AverageReadIops = float64(s1.AverageReadIops)
	s.AverageWriteIops = float64(s1.AverageWriteIops)
	return nil
}

// Empty: A generic empty message that you can re-use to avoid defining
// duplicated empty messages in your APIs. A typical example is to use it as
// the request or the response type of an API method. For instance: service Foo
// { rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
type Empty struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// ErrorFrame: Message representing a frame which failed to be processed due to
// an error.
type ErrorFrame struct {
	// IngestionTime: Output only. Frame ingestion time.
	IngestionTime string `json:"ingestionTime,omitempty"`
	// Name: Output only. The identifier of the ErrorFrame.
	Name string `json:"name,omitempty"`
	// OriginalFrame: Output only. The frame that was originally reported.
	OriginalFrame *AssetFrame `json:"originalFrame,omitempty"`
	// Violations: Output only. All the violations that were detected for the
	// frame.
	Violations []*FrameViolationEntry `json:"violations,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "IngestionTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IngestionTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ErrorFrame) MarshalJSON() ([]byte, error) {
	type NoMethod ErrorFrame
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExecutionReport: A resource that reports result of the import job execution.
type ExecutionReport struct {
	// ExecutionErrors: Validation errors encountered during the execution of the
	// import job.
	ExecutionErrors *ValidationReport `json:"executionErrors,omitempty"`
	// FramesReported: Total number of asset frames reported for the import job.
	FramesReported int64 `json:"framesReported,omitempty"`
	// TotalRowsCount: Output only. Total number of rows in the import job.
	TotalRowsCount int64 `json:"totalRowsCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExecutionErrors") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExecutionErrors") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExecutionReport) MarshalJSON() ([]byte, error) {
	type NoMethod ExecutionReport
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FileValidationReport: A resource that aggregates the validation errors found
// in an import job file.
type FileValidationReport struct {
	// FileErrors: List of file level errors.
	FileErrors []*ImportError `json:"fileErrors,omitempty"`
	// FileName: The name of the file.
	FileName string `json:"fileName,omitempty"`
	// PartialReport: Flag indicating that processing was aborted due to maximum
	// number of errors.
	PartialReport bool `json:"partialReport,omitempty"`
	// RowErrors: Partial list of rows that encountered validation error.
	RowErrors []*ImportRowError `json:"rowErrors,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FileErrors") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FileErrors") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FileValidationReport) MarshalJSON() ([]byte, error) {
	type NoMethod FileValidationReport
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FitDescriptor: Describes the fit level of an asset for migration to a
// specific target.
type FitDescriptor struct {
	// FitLevel: Output only. Fit level.
	//
	// Possible values:
	//   "FIT_LEVEL_UNSPECIFIED" - Not enough information.
	//   "FIT" - Fit.
	//   "NO_FIT" - No Fit.
	//   "REQUIRES_EFFORT" - Fit with effort.
	FitLevel string `json:"fitLevel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FitLevel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FitLevel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FitDescriptor) MarshalJSON() ([]byte, error) {
	type NoMethod FitDescriptor
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FrameViolationEntry: A resource that contains a single violation of a
// reported `AssetFrame` resource.
type FrameViolationEntry struct {
	// Field: The field of the original frame where the violation occurred.
	Field string `json:"field,omitempty"`
	// Violation: A message describing the violation.
	Violation string `json:"violation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Field") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Field") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FrameViolationEntry) MarshalJSON() ([]byte, error) {
	type NoMethod FrameViolationEntry
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Frames: Collection of frame data.
type Frames struct {
	// FramesData: A repeated field of asset data.
	FramesData []*AssetFrame `json:"framesData,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FramesData") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FramesData") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Frames) MarshalJSON() ([]byte, error) {
	type NoMethod Frames
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FstabEntry: Single fstab entry.
type FstabEntry struct {
	// File: The mount point for the filesystem.
	File string `json:"file,omitempty"`
	// Freq: Used by dump to determine which filesystems need to be dumped.
	Freq int64 `json:"freq,omitempty"`
	// Mntops: Mount options associated with the filesystem.
	Mntops string `json:"mntops,omitempty"`
	// Passno: Used by the fsck(8) program to determine the order in which
	// filesystem checks are done at reboot time.
	Passno int64 `json:"passno,omitempty"`
	// Spec: The block special device or remote filesystem to be mounted.
	Spec string `json:"spec,omitempty"`
	// Vfstype: The type of the filesystem.
	Vfstype string `json:"vfstype,omitempty"`
	// ForceSendFields is a list of field names (e.g. "File") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "File") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FstabEntry) MarshalJSON() ([]byte, error) {
	type NoMethod FstabEntry
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FstabEntryList: Fstab content.
type FstabEntryList struct {
	// Entries: Fstab entries.
	Entries []*FstabEntry `json:"entries,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Entries") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entries") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FstabEntryList) MarshalJSON() ([]byte, error) {
	type NoMethod FstabEntryList
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GenerateReportArtifactLinkRequest: A request to generate a link to an
// artifact for a Report.
type GenerateReportArtifactLinkRequest struct {
	// ArtifactType: Required. Type of the artifact requested.
	//
	// Possible values:
	//   "ARTIFACT_TYPE_UNSPECIFIED" - Unspecified (default value).
	//   "PRESENTATION" - Google Slides presentation.
	//   "SPREADSHEET" - Google Sheets document.
	//   "CSV" - Comma Separated Value Text File.
	ArtifactType string `json:"artifactType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ArtifactType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ArtifactType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GenerateReportArtifactLinkRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GenerateReportArtifactLinkRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GenericInsight: A generic insight about an asset.
type GenericInsight struct {
	// AdditionalInformation: Output only. Additional information about the
	// insight, each entry can be a logical entry and must make sense if it is
	// displayed with line breaks between each entry. Text can contain md style
	// links.
	AdditionalInformation []string `json:"additionalInformation,omitempty"`
	// DefaultMessage: Output only. In case message_code is not yet known by the
	// client default_message will be the message to be used instead.
	DefaultMessage string `json:"defaultMessage,omitempty"`
	// MessageId: Output only. Represents a globally unique message id for this
	// insight, can be used for localization purposes, in case message_code is not
	// yet known by the client use default_message instead.
	MessageId int64 `json:"messageId,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "AdditionalInformation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdditionalInformation") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GenericInsight) MarshalJSON() ([]byte, error) {
	type NoMethod GenericInsight
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GenericPlatformDetails: Generic platform details.
type GenericPlatformDetails struct {
	// Hyperthreading: Whether the machine is hyperthreaded.
	//
	// Possible values:
	//   "HYPERTHREADING_STATUS_UNSPECIFIED" - Simultaneous Multithreading status
	// unknown.
	//   "HYPERTHREADING_STATUS_DISABLED" - Simultaneous Multithreading is disabled
	// or unavailable.
	//   "HYPERTHREADING_STATUS_ENABLED" - Simultaneous Multithreading is enabled.
	Hyperthreading string `json:"hyperthreading,omitempty"`
	// Location: Free text representation of the machine location. The format of
	// this field should not be relied on. Different VMs in the same location may
	// have different string values for this field.
	Location string `json:"location,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Hyperthreading") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Hyperthreading") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GenericPlatformDetails) MarshalJSON() ([]byte, error) {
	type NoMethod GenericPlatformDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Group: A resource that represents an asset group. The purpose of an asset
// group is to bundle a set of assets that have something in common, while
// allowing users to add annotations to the group. An asset can belong to
// multiple groups.
type Group struct {
	// CreateTime: Output only. The timestamp when the group was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. The description of the group.
	Description string `json:"description,omitempty"`
	// DisplayName: Optional. User-friendly display name.
	DisplayName string `json:"displayName,omitempty"`
	// Labels: Labels as key value pairs.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Output only. The name of the group.
	Name string `json:"name,omitempty"`
	// UpdateTime: Output only. The timestamp when the group was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Group) MarshalJSON() ([]byte, error) {
	type NoMethod Group
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GuestConfigDetails: Guest OS config information.
type GuestConfigDetails struct {
	// Fstab: Mount list (Linux fstab).
	Fstab *FstabEntryList `json:"fstab,omitempty"`
	// Hosts: Hosts file (/etc/hosts).
	Hosts *HostsEntryList `json:"hosts,omitempty"`
	// Issue: OS issue (typically /etc/issue in Linux).
	Issue string `json:"issue,omitempty"`
	// NfsExports: NFS exports.
	NfsExports *NfsExportList `json:"nfsExports,omitempty"`
	// SelinuxMode: Security-Enhanced Linux (SELinux) mode.
	//
	// Possible values:
	//   "SE_LINUX_MODE_UNSPECIFIED" - SELinux mode unknown or unspecified.
	//   "SE_LINUX_MODE_DISABLED" - SELinux is disabled.
	//   "SE_LINUX_MODE_PERMISSIVE" - SELinux permissive mode.
	//   "SE_LINUX_MODE_ENFORCING" - SELinux enforcing mode.
	SelinuxMode string `json:"selinuxMode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Fstab") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Fstab") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GuestConfigDetails) MarshalJSON() ([]byte, error) {
	type NoMethod GuestConfigDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GuestInstalledApplication: Guest installed application information.
type GuestInstalledApplication struct {
	// ApplicationName: Installed application name.
	ApplicationName string `json:"applicationName,omitempty"`
	// InstallTime: The time when the application was installed.
	InstallTime string `json:"installTime,omitempty"`
	// Licenses: License strings associated with the installed application.
	Licenses []string `json:"licenses,omitempty"`
	// Path: Source path.
	Path string `json:"path,omitempty"`
	// Vendor: Installed application vendor.
	Vendor string `json:"vendor,omitempty"`
	// Version: Installed application version.
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApplicationName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApplicationName") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GuestInstalledApplication) MarshalJSON() ([]byte, error) {
	type NoMethod GuestInstalledApplication
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GuestInstalledApplicationList: Guest installed application list.
type GuestInstalledApplicationList struct {
	// Entries: Application entries.
	Entries []*GuestInstalledApplication `json:"entries,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Entries") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entries") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GuestInstalledApplicationList) MarshalJSON() ([]byte, error) {
	type NoMethod GuestInstalledApplicationList
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GuestOsDetails: Information from Guest-level collections.
type GuestOsDetails struct {
	// Config: OS and app configuration.
	Config *GuestConfigDetails `json:"config,omitempty"`
	// Family: What family the OS belong to, if known.
	//
	// Possible values:
	//   "OS_FAMILY_UNKNOWN"
	//   "OS_FAMILY_WINDOWS" - Microsoft Windows Server and Desktop.
	//   "OS_FAMILY_LINUX" - Various Linux flavors.
	//   "OS_FAMILY_UNIX" - Non-Linux Unix flavors.
	Family string `json:"family,omitempty"`
	// OsName: The name of the operating system.
	OsName string `json:"osName,omitempty"`
	// Runtime: Runtime information.
	Runtime *GuestRuntimeDetails `json:"runtime,omitempty"`
	// Version: The version of the operating system.
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Config") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Config") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GuestOsDetails) MarshalJSON() ([]byte, error) {
	type NoMethod GuestOsDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GuestRuntimeDetails: Guest OS runtime information.
type GuestRuntimeDetails struct {
	// Domain: Domain, e.g. c.stratozone-development.internal.
	Domain string `json:"domain,omitempty"`
	// InstalledApps: Installed applications information.
	InstalledApps *GuestInstalledApplicationList `json:"installedApps,omitempty"`
	// LastBootTime: Last time the OS was booted.
	LastBootTime string `json:"lastBootTime,omitempty"`
	// MachineName: Machine name.
	MachineName string `json:"machineName,omitempty"`
	// Network: Runtime network information (connections, ports).
	Network *RuntimeNetworkInfo `json:"network,omitempty"`
	// OpenFileList: Open files information.
	OpenFileList *OpenFileList `json:"openFileList,omitempty"`
	// Processes: Running processes.
	Processes *RunningProcessList `json:"processes,omitempty"`
	// Services: Running background services.
	Services *RunningServiceList `json:"services,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Domain") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Domain") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GuestRuntimeDetails) MarshalJSON() ([]byte, error) {
	type NoMethod GuestRuntimeDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// HostsEntry: Single /etc/hosts entry.
type HostsEntry struct {
	// HostNames: List of host names / aliases.
	HostNames []string `json:"hostNames,omitempty"`
	// Ip: IP (raw, IPv4/6 agnostic).
	Ip string `json:"ip,omitempty"`
	// ForceSendFields is a list of field names (e.g. "HostNames") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "HostNames") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s HostsEntry) MarshalJSON() ([]byte, error) {
	type NoMethod HostsEntry
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// HostsEntryList: Hosts content.
type HostsEntryList struct {
	// Entries: Hosts entries.
	Entries []*HostsEntry `json:"entries,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Entries") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entries") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s HostsEntryList) MarshalJSON() ([]byte, error) {
	type NoMethod HostsEntryList
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ImportDataFile: A resource that represents a payload file in an import job.
type ImportDataFile struct {
	// CreateTime: Output only. The timestamp when the file was created.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: User-friendly display name. Maximum length is 63 characters.
	DisplayName string `json:"displayName,omitempty"`
	// Format: Required. The payload format.
	//
	// Possible values:
	//   "IMPORT_JOB_FORMAT_UNSPECIFIED" - Default value.
	//   "IMPORT_JOB_FORMAT_RVTOOLS_XLSX" - RVTools format (XLSX).
	//   "IMPORT_JOB_FORMAT_RVTOOLS_CSV" - RVTools format (CSV).
	//   "IMPORT_JOB_FORMAT_EXPORTED_AWS_CSV" - CSV format exported from AWS using
	// the AWS collection script.
	//   "IMPORT_JOB_FORMAT_EXPORTED_AZURE_CSV" - CSV format exported from Azure
	// using the Azure collection script.
	//   "IMPORT_JOB_FORMAT_STRATOZONE_CSV" - CSV format created manually and
	// following the StratoZone format. For more information, see Manually create
	// and upload data tables.
	//   "IMPORT_JOB_FORMAT_DATABASE_ZIP" - ZIP file with nested CSV files
	// generated by a database collector.
	Format string `json:"format,omitempty"`
	// Name: Output only. The name of the file.
	Name string `json:"name,omitempty"`
	// State: Output only. The state of the import data file.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Default value.
	//   "CREATING" - The data file is being created.
	//   "ACTIVE" - The data file completed initialization.
	State string `json:"state,omitempty"`
	// UploadFileInfo: Information about a file that is uploaded to a storage
	// service.
	UploadFileInfo *UploadFileInfo `json:"uploadFileInfo,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ImportDataFile) MarshalJSON() ([]byte, error) {
	type NoMethod ImportDataFile
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ImportError: A resource that reports the errors encountered while processing
// an import job.
type ImportError struct {
	// ErrorDetails: The error information.
	ErrorDetails string `json:"errorDetails,omitempty"`
	// Severity: The severity of the error.
	//
	// Possible values:
	//   "SEVERITY_UNSPECIFIED"
	//   "ERROR"
	//   "WARNING"
	//   "INFO"
	Severity string `json:"severity,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorDetails") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorDetails") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ImportError) MarshalJSON() ([]byte, error) {
	type NoMethod ImportError
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ImportJob: A resource that represents the background job that imports asset
// frames.
type ImportJob struct {
	// AssetSource: Required. Reference to a source.
	AssetSource string `json:"assetSource,omitempty"`
	// CompleteTime: Output only. The timestamp when the import job was completed.
	CompleteTime string `json:"completeTime,omitempty"`
	// CreateTime: Output only. The timestamp when the import job was created.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: Optional. User-friendly display name. Maximum length is 256
	// characters.
	DisplayName string `json:"displayName,omitempty"`
	// ExecutionReport: Output only. The report with the results of running the
	// import job.
	ExecutionReport *ExecutionReport `json:"executionReport,omitempty"`
	// Labels: Labels as key value pairs.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Output only. The full name of the import job.
	Name string `json:"name,omitempty"`
	// State: Output only. The state of the import job.
	//
	// Possible values:
	//   "IMPORT_JOB_STATE_UNSPECIFIED" - Default value.
	//   "IMPORT_JOB_STATE_PENDING" - The import job is pending.
	//   "IMPORT_JOB_STATE_RUNNING" - The processing of the import job is ongoing.
	//   "IMPORT_JOB_STATE_COMPLETED" - The import job processing has completed.
	//   "IMPORT_JOB_STATE_FAILED" - The import job failed to be processed.
	//   "IMPORT_JOB_STATE_VALIDATING" - The import job is being validated.
	//   "IMPORT_JOB_STATE_FAILED_VALIDATION" - The import job contains blocking
	// errors.
	//   "IMPORT_JOB_STATE_READY" - The validation of the job completed with no
	// blocking errors.
	State string `json:"state,omitempty"`
	// UpdateTime: Output only. The timestamp when the import job was last updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// ValidationReport: Output only. The report with the validation results of the
	// import job.
	ValidationReport *ValidationReport `json:"validationReport,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AssetSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AssetSource") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ImportJob) MarshalJSON() ([]byte, error) {
	type NoMethod ImportJob
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ImportRowError: A resource that reports the import job errors at row level.
type ImportRowError struct {
	// ArchiveError: Error details for an archive file.
	ArchiveError *ImportRowErrorArchiveErrorDetails `json:"archiveError,omitempty"`
	// AssetTitle: Output only. The asset title.
	AssetTitle string `json:"assetTitle,omitempty"`
	// CsvError: Error details for a CSV file.
	CsvError *ImportRowErrorCsvErrorDetails `json:"csvError,omitempty"`
	// Errors: The list of errors detected in the row.
	Errors []*ImportError `json:"errors,omitempty"`
	// RowNumber: The row number where the error was detected.
	RowNumber int64 `json:"rowNumber,omitempty"`
	// VmName: The name of the VM in the row.
	VmName string `json:"vmName,omitempty"`
	// VmUuid: The VM UUID.
	VmUuid string `json:"vmUuid,omitempty"`
	// XlsxError: Error details for an XLSX file.
	XlsxError *ImportRowErrorXlsxErrorDetails `json:"xlsxError,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ArchiveError") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ArchiveError") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ImportRowError) MarshalJSON() ([]byte, error) {
	type NoMethod ImportRowError
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ImportRowErrorArchiveErrorDetails: Error details for an archive file.
type ImportRowErrorArchiveErrorDetails struct {
	// CsvError: Error details for a CSV file.
	CsvError *ImportRowErrorCsvErrorDetails `json:"csvError,omitempty"`
	// FilePath: Output only. The file path inside the archive where the error was
	// detected.
	FilePath string `json:"filePath,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CsvError") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CsvError") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ImportRowErrorArchiveErrorDetails) MarshalJSON() ([]byte, error) {
	type NoMethod ImportRowErrorArchiveErrorDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ImportRowErrorCsvErrorDetails: Error details for a CSV file.
type ImportRowErrorCsvErrorDetails struct {
	// RowNumber: The row number where the error was detected.
	RowNumber int64 `json:"rowNumber,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RowNumber") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RowNumber") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ImportRowErrorCsvErrorDetails) MarshalJSON() ([]byte, error) {
	type NoMethod ImportRowErrorCsvErrorDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ImportRowErrorXlsxErrorDetails: Error details for an XLSX file.
type ImportRowErrorXlsxErrorDetails struct {
	// RowNumber: The row number where the error was detected.
	RowNumber int64 `json:"rowNumber,omitempty"`
	// Sheet: The name of the sheet where the error was detected.
	Sheet string `json:"sheet,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RowNumber") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RowNumber") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ImportRowErrorXlsxErrorDetails) MarshalJSON() ([]byte, error) {
	type NoMethod ImportRowErrorXlsxErrorDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Insight: An insight about an asset.
type Insight struct {
	// GenericInsight: Output only. A generic insight about an asset.
	GenericInsight *GenericInsight `json:"genericInsight,omitempty"`
	// MigrationInsight: Output only. An insight about potential migrations for an
	// asset.
	MigrationInsight *MigrationInsight `json:"migrationInsight,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericInsight") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericInsight") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Insight) MarshalJSON() ([]byte, error) {
	type NoMethod Insight
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InsightList: Message containing insights list.
type InsightList struct {
	// Insights: Output only. Insights of the list.
	Insights []*Insight `json:"insights,omitempty"`
	// UpdateTime: Output only. Update timestamp.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Insights") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Insights") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InsightList) MarshalJSON() ([]byte, error) {
	type NoMethod InsightList
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListAssetsResponse: Response message for listing assets.
type ListAssetsResponse struct {
	// Assets: A list of assets.
	Assets []*Asset `json:"assets,omitempty"`
	// NextPageToken: A token identifying a page of results the server should
	// return.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Assets") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Assets") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListAssetsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListAssetsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListDiscoveryClientsResponse: Response message for listing discovery
// clients.
type ListDiscoveryClientsResponse struct {
	// DiscoveryClients: List of discovery clients.
	DiscoveryClients []*DiscoveryClient `json:"discoveryClients,omitempty"`
	// NextPageToken: A token that can be sent as `page_token` to retrieve the next
	// page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DiscoveryClients") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DiscoveryClients") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListDiscoveryClientsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListDiscoveryClientsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListErrorFramesResponse: A response for listing error frames.
type ListErrorFramesResponse struct {
	// ErrorFrames: The list of error frames.
	ErrorFrames []*ErrorFrame `json:"errorFrames,omitempty"`
	// NextPageToken: A token identifying a page of results the server should
	// return.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ErrorFrames") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorFrames") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListErrorFramesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListErrorFramesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListGroupsResponse: A response for listing groups.
type ListGroupsResponse struct {
	// Groups: The list of Group
	Groups []*Group `json:"groups,omitempty"`
	// NextPageToken: A token identifying a page of results the server should
	// return.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Groups") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Groups") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListGroupsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListGroupsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListImportDataFilesResponse: Response for listing payload files of an import
// job.
type ListImportDataFilesResponse struct {
	// ImportDataFiles: The list of import data files.
	ImportDataFiles []*ImportDataFile `json:"importDataFiles,omitempty"`
	// NextPageToken: A token that can be sent as `page_token` to retrieve the next
	// page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ImportDataFiles") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ImportDataFiles") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListImportDataFilesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListImportDataFilesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListImportJobsResponse: A response for listing import jobs.
type ListImportJobsResponse struct {
	// ImportJobs: The list of import jobs.
	ImportJobs []*ImportJob `json:"importJobs,omitempty"`
	// NextPageToken: A token identifying a page of results the server should
	// return.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ImportJobs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ImportJobs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListImportJobsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListImportJobsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListLocationsResponse: The response message for Locations.ListLocations.
type ListLocationsResponse struct {
	// Locations: A list of locations that matches the specified filter in the
	// request.
	Locations []*Location `json:"locations,omitempty"`
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Locations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Locations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListLocationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListLocationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListOperationsResponse: The response message for Operations.ListOperations.
type ListOperationsResponse struct {
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Operations: A list of operations that matches the specified filter in the
	// request.
	Operations []*Operation `json:"operations,omitempty"`
	// Unreachable: Unordered list. Unreachable resources. Populated when the
	// request sets `ListOperationsRequest.return_partial_success` and reads across
	// collections e.g. when attempting to list all resources across all supported
	// locations.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListOperationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListOperationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListPreferenceSetsResponse: Response message for listing preference sets.
type ListPreferenceSetsResponse struct {
	// NextPageToken: A token identifying a page of results the server should
	// return.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// PreferenceSets: The list of PreferenceSets
	PreferenceSets []*PreferenceSet `json:"preferenceSets,omitempty"`
	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListPreferenceSetsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListPreferenceSetsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListRelationsResponse: Response message for listing relations.
type ListRelationsResponse struct {
	// NextPageToken: A token identifying a page of results the server should
	// return.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Relations: A list of relations.
	Relations []*Relation `json:"relations,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListRelationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListRelationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListReportConfigsResponse: Response message for listing report configs.
type ListReportConfigsResponse struct {
	// NextPageToken: A token identifying a page of results the server should
	// return.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// ReportConfigs: A list of report configs.
	ReportConfigs []*ReportConfig `json:"reportConfigs,omitempty"`
	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListReportConfigsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListReportConfigsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListReportsResponse: Response message for listing Reports.
type ListReportsResponse struct {
	// NextPageToken: A token identifying a page of results the server should
	// return.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Reports: The list of Reports.
	Reports []*Report `json:"reports,omitempty"`
	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListReportsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListReportsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListSourcesResponse: Response message for listing sources.
type ListSourcesResponse struct {
	// NextPageToken: A token identifying a page of results the server should
	// return.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Sources: The list of sources.
	Sources []*Source `json:"sources,omitempty"`
	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListSourcesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListSourcesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Location: A resource that represents a Google Cloud location.
type Location struct {
	// DisplayName: The friendly name for this location, typically a nearby city
	// name. For example, "Tokyo".
	DisplayName string `json:"displayName,omitempty"`
	// Labels: Cross-service attributes for the location. For example
	// {"cloud.googleapis.com/region": "us-east1"}
	Labels map[string]string `json:"labels,omitempty"`
	// LocationId: The canonical id for this location. For example: "us-east1".
	LocationId string `json:"locationId,omitempty"`
	// Metadata: Service-specific metadata. For example the available capacity at
	// the given location.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: Resource name for the location, which may vary between
	// implementations. For example:
	// "projects/example-project/locations/us-east1"
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Location) MarshalJSON() ([]byte, error) {
	type NoMethod Location
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MachineArchitectureDetails: Details of the machine architecture.
type MachineArchitectureDetails struct {
	// Bios: BIOS Details.
	Bios *BiosDetails `json:"bios,omitempty"`
	// CpuArchitecture: CPU architecture, e.g., "x64-based PC", "x86_64", "i686"
	// etc.
	CpuArchitecture string `json:"cpuArchitecture,omitempty"`
	// CpuManufacturer: Optional. CPU manufacturer, e.g., "Intel", "AMD".
	CpuManufacturer string `json:"cpuManufacturer,omitempty"`
	// CpuName: CPU name, e.g., "Intel Xeon E5-2690", "AMD EPYC 7571" etc.
	CpuName string `json:"cpuName,omitempty"`
	// CpuSocketCount: Number of processor sockets allocated to the machine.
	CpuSocketCount int64 `json:"cpuSocketCount,omitempty"`
	// CpuThreadCount: Deprecated: use MachineDetails.core_count instead. Number of
	// CPU threads allocated to the machine.
	CpuThreadCount int64 `json:"cpuThreadCount,omitempty"`
	// FirmwareType: Firmware type.
	//
	// Possible values:
	//   "FIRMWARE_TYPE_UNSPECIFIED" - Unspecified or unknown.
	//   "BIOS" - BIOS firmware.
	//   "EFI" - EFI firmware.
	FirmwareType string `json:"firmwareType,omitempty"`
	// Hyperthreading: CPU hyper-threading support.
	//
	// Possible values:
	//   "CPU_HYPER_THREADING_UNSPECIFIED" - Unspecified or unknown.
	//   "DISABLED" - Hyper-threading is disabled.
	//   "ENABLED" - Hyper-threading is enabled.
	Hyperthreading string `json:"hyperthreading,omitempty"`
	// Vendor: Hardware vendor.
	Vendor string `json:"vendor,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Bios") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Bios") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MachineArchitectureDetails) MarshalJSON() ([]byte, error) {
	type NoMethod MachineArchitectureDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MachineDetails: Details of a machine.
type MachineDetails struct {
	// Architecture: Architecture details (vendor, CPU architecture).
	Architecture *MachineArchitectureDetails `json:"architecture,omitempty"`
	// CoreCount: Number of logical CPU cores in the machine. Must be non-negative.
	CoreCount int64 `json:"coreCount,omitempty"`
	// CreateTime: Machine creation time.
	CreateTime string `json:"createTime,omitempty"`
	// DiskPartitions: Optional. Disk partitions details. Note: Partitions are not
	// necessarily mounted on local disks and therefore might not have a one-to-one
	// correspondence with local disks.
	DiskPartitions *DiskPartitionDetails `json:"diskPartitions,omitempty"`
	// Disks: Disk details.
	Disks *MachineDiskDetails `json:"disks,omitempty"`
	// GuestOs: Guest OS information.
	GuestOs *GuestOsDetails `json:"guestOs,omitempty"`
	// MachineName: Machine name.
	MachineName string `json:"machineName,omitempty"`
	// MemoryMb: The amount of memory in the machine. Must be non-negative.
	MemoryMb int64 `json:"memoryMb,omitempty"`
	// Network: Network details.
	Network *MachineNetworkDetails `json:"network,omitempty"`
	// Platform: Platform specific information.
	Platform *PlatformDetails `json:"platform,omitempty"`
	// PowerState: Power state of the machine.
	//
	// Possible values:
	//   "POWER_STATE_UNSPECIFIED" - Power state is unknown.
	//   "PENDING" - The machine is preparing to enter the ACTIVE state. An
	// instance may enter the PENDING state when it launches for the first time, or
	// when it is started after being in the SUSPENDED state.
	//   "ACTIVE" - The machine is active.
	//   "SUSPENDING" - The machine is being turned off.
	//   "SUSPENDED" - The machine is off.
	//   "DELETING" - The machine is being deleted from the hosting platform.
	//   "DELETED" - The machine is deleted from the hosting platform.
	PowerState string `json:"powerState,omitempty"`
	// Uuid: Machine unique identifier.
	Uuid string `json:"uuid,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Architecture") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Architecture") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MachineDetails) MarshalJSON() ([]byte, error) {
	type NoMethod MachineDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MachineDiskDetails: Details of machine disks.
type MachineDiskDetails struct {
	// Disks: List of disks.
	Disks *DiskEntryList `json:"disks,omitempty"`
	// TotalCapacityBytes: Disk total Capacity.
	TotalCapacityBytes int64 `json:"totalCapacityBytes,omitempty,string"`
	// TotalFreeBytes: Total disk free space.
	TotalFreeBytes int64 `json:"totalFreeBytes,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "Disks") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Disks") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MachineDiskDetails) MarshalJSON() ([]byte, error) {
	type NoMethod MachineDiskDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MachineNetworkDetails: Details of network adapters and settings.
type MachineNetworkDetails struct {
	// Adapters: List of network adapters.
	Adapters *NetworkAdapterList `json:"adapters,omitempty"`
	// DefaultGateway: Optional. Default gateway address.
	DefaultGateway string `json:"defaultGateway,omitempty"`
	// PrimaryIpAddress: The primary IP address of the machine.
	PrimaryIpAddress string `json:"primaryIpAddress,omitempty"`
	// PrimaryMacAddress: MAC address of the machine. This property is used to
	// uniqly identify the machine.
	PrimaryMacAddress string `json:"primaryMacAddress,omitempty"`
	// PublicIpAddress: The public IP address of the machine.
	PublicIpAddress string `json:"publicIpAddress,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Adapters") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Adapters") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MachineNetworkDetails) MarshalJSON() ([]byte, error) {
	type NoMethod MachineNetworkDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MachinePreferences: The type of machines to consider when calculating
// virtual machine migration insights and recommendations. Not all machine
// types are available in all zones and regions.
type MachinePreferences struct {
	// AllowedMachineSeries: Compute Engine machine series to consider for insights
	// and recommendations. If empty, no restriction is applied on the machine
	// series.
	AllowedMachineSeries []*MachineSeries `json:"allowedMachineSeries,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowedMachineSeries") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowedMachineSeries") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MachinePreferences) MarshalJSON() ([]byte, error) {
	type NoMethod MachinePreferences
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MachineSeries: A machine series, for a target product (e.g. Compute Engine,
// Google Cloud VMware Engine).
type MachineSeries struct {
	// Code: Code to identify a machine series. Consult this for more details on
	// the available series for Compute Engine:
	// https://cloud.google.com/compute/docs/machine-resource#machine_type_comparison
	// Consult this for more details on the available series for Google Cloud
	// VMware Engine: https://cloud.google.com/vmware-engine/pricing
	Code string `json:"code,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MachineSeries) MarshalJSON() ([]byte, error) {
	type NoMethod MachineSeries
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MemoryUsageSample: Memory usage sample.
type MemoryUsageSample struct {
	// UtilizedPercentage: Percentage of system memory utilized. Must be in the
	// interval [0, 100].
	UtilizedPercentage float64 `json:"utilizedPercentage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "UtilizedPercentage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "UtilizedPercentage") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MemoryUsageSample) MarshalJSON() ([]byte, error) {
	type NoMethod MemoryUsageSample
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *MemoryUsageSample) UnmarshalJSON(data []byte) error {
	type NoMethod MemoryUsageSample
	var s1 struct {
		UtilizedPercentage gensupport.JSONFloat64 `json:"utilizedPercentage"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.UtilizedPercentage = float64(s1.UtilizedPercentage)
	return nil
}

// MigrationInsight: An insight about potential migrations for an asset.
type MigrationInsight struct {
	// ComputeEngineTarget: Output only. A Google Compute Engine target.
	ComputeEngineTarget *ComputeEngineMigrationTarget `json:"computeEngineTarget,omitempty"`
	// Fit: Output only. Description of how well the asset this insight is
	// associated with fits the proposed migration.
	Fit *FitDescriptor `json:"fit,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ComputeEngineTarget") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ComputeEngineTarget") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MigrationInsight) MarshalJSON() ([]byte, error) {
	type NoMethod MigrationInsight
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Money: Represents an amount of money with its currency type.
type Money struct {
	// CurrencyCode: The three-letter currency code defined in ISO 4217.
	CurrencyCode string `json:"currencyCode,omitempty"`
	// Nanos: Number of nano (10^-9) units of the amount. The value must be between
	// -999,999,999 and +999,999,999 inclusive. If `units` is positive, `nanos`
	// must be positive or zero. If `units` is zero, `nanos` can be positive, zero,
	// or negative. If `units` is negative, `nanos` must be negative or zero. For
	// example $-1.75 is represented as `units`=-1 and `nanos`=-750,000,000.
	Nanos int64 `json:"nanos,omitempty"`
	// Units: The whole units of the amount. For example if `currencyCode` is
	// "USD", then 1 unit is one US dollar.
	Units int64 `json:"units,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "CurrencyCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CurrencyCode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Money) MarshalJSON() ([]byte, error) {
	type NoMethod Money
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MySqlPlugin: MySql plugin.
type MySqlPlugin struct {
	// Enabled: Required. The plugin is active.
	Enabled bool `json:"enabled,omitempty"`
	// Plugin: Required. The plugin name.
	Plugin string `json:"plugin,omitempty"`
	// Version: Required. The plugin version.
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enabled") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MySqlPlugin) MarshalJSON() ([]byte, error) {
	type NoMethod MySqlPlugin
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MySqlProperty: MySql property.
type MySqlProperty struct {
	// Enabled: Required. The property is enabled.
	Enabled bool `json:"enabled,omitempty"`
	// NumericValue: Required. The property numeric value.
	NumericValue int64 `json:"numericValue,omitempty,string"`
	// Property: Required. The property name.
	Property string `json:"property,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enabled") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MySqlProperty) MarshalJSON() ([]byte, error) {
	type NoMethod MySqlProperty
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MySqlSchemaDetails: Specific details for a Mysql database.
type MySqlSchemaDetails struct {
	// StorageEngines: Optional. Mysql storage engine tables.
	StorageEngines []*MySqlStorageEngineDetails `json:"storageEngines,omitempty"`
	// ForceSendFields is a list of field names (e.g. "StorageEngines") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "StorageEngines") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MySqlSchemaDetails) MarshalJSON() ([]byte, error) {
	type NoMethod MySqlSchemaDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MySqlStorageEngineDetails: Mysql storage engine tables.
type MySqlStorageEngineDetails struct {
	// EncryptedTableCount: Optional. The number of encrypted tables.
	EncryptedTableCount int64 `json:"encryptedTableCount,omitempty"`
	// Engine: Required. The storage engine.
	//
	// Possible values:
	//   "ENGINE_UNSPECIFIED" - Unspecified storage engine.
	//   "INNODB" - InnoDB.
	//   "MYISAM" - MyISAM.
	//   "MEMORY" - Memory.
	//   "CSV" - CSV.
	//   "ARCHIVE" - Archive.
	//   "BLACKHOLE" - Blackhole.
	//   "NDB" - NDB.
	//   "MERGE" - Merge.
	//   "FEDERATED" - Federated.
	//   "EXAMPLE" - Example.
	//   "OTHER" - Other.
	Engine string `json:"engine,omitempty"`
	// TableCount: Optional. The number of tables.
	TableCount int64 `json:"tableCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EncryptedTableCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EncryptedTableCount") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MySqlStorageEngineDetails) MarshalJSON() ([]byte, error) {
	type NoMethod MySqlStorageEngineDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MySqlVariable: MySql variable.
type MySqlVariable struct {
	// Category: Required. The variable category.
	Category string `json:"category,omitempty"`
	// Value: Required. The variable value.
	Value string `json:"value,omitempty"`
	// Variable: Required. The variable name.
	Variable string `json:"variable,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Category") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Category") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MySqlVariable) MarshalJSON() ([]byte, error) {
	type NoMethod MySqlVariable
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MysqlDatabaseDeployment: Specific details for a Mysql database deployment.
type MysqlDatabaseDeployment struct {
	// Plugins: Optional. List of MySql plugins.
	Plugins []*MySqlPlugin `json:"plugins,omitempty"`
	// Properties: Optional. List of MySql properties.
	Properties []*MySqlProperty `json:"properties,omitempty"`
	// ResourceGroupsCount: Optional. Number of resource groups.
	ResourceGroupsCount int64 `json:"resourceGroupsCount,omitempty"`
	// Variables: Optional. List of MySql variables.
	Variables []*MySqlVariable `json:"variables,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Plugins") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Plugins") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MysqlDatabaseDeployment) MarshalJSON() ([]byte, error) {
	type NoMethod MysqlDatabaseDeployment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// NetworkAdapterDetails: Details of network adapter.
type NetworkAdapterDetails struct {
	// AdapterType: Network adapter type (e.g. VMXNET3).
	AdapterType string `json:"adapterType,omitempty"`
	// Addresses: NetworkAddressList
	Addresses *NetworkAddressList `json:"addresses,omitempty"`
	// MacAddress: MAC address.
	MacAddress string `json:"macAddress,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdapterType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdapterType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NetworkAdapterDetails) MarshalJSON() ([]byte, error) {
	type NoMethod NetworkAdapterDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// NetworkAdapterList: List of network adapters.
type NetworkAdapterList struct {
	// Entries: Network adapter entries.
	Entries []*NetworkAdapterDetails `json:"entries,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Entries") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entries") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NetworkAdapterList) MarshalJSON() ([]byte, error) {
	type NoMethod NetworkAdapterList
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// NetworkAddress: Details of network address.
type NetworkAddress struct {
	// Assignment: Whether DHCP is used to assign addresses.
	//
	// Possible values:
	//   "ADDRESS_ASSIGNMENT_UNSPECIFIED" - Unknown (default value).
	//   "ADDRESS_ASSIGNMENT_STATIC" - Statically assigned IP.
	//   "ADDRESS_ASSIGNMENT_DHCP" - Dynamically assigned IP (DHCP).
	Assignment string `json:"assignment,omitempty"`
	// Bcast: Broadcast address.
	Bcast string `json:"bcast,omitempty"`
	// Fqdn: Fully qualified domain name.
	Fqdn string `json:"fqdn,omitempty"`
	// IpAddress: Assigned or configured IP Address.
	IpAddress string `json:"ipAddress,omitempty"`
	// SubnetMask: Subnet mask.
	SubnetMask string `json:"subnetMask,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Assignment") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Assignment") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NetworkAddress) MarshalJSON() ([]byte, error) {
	type NoMethod NetworkAddress
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// NetworkAddressList: List of allocated/assigned network addresses.
type NetworkAddressList struct {
	// Entries: Network address entries.
	Entries []*NetworkAddress `json:"entries,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Entries") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entries") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NetworkAddressList) MarshalJSON() ([]byte, error) {
	type NoMethod NetworkAddressList
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type NetworkConnection struct {
	// LocalIpAddress: Local IP address.
	LocalIpAddress string `json:"localIpAddress,omitempty"`
	// LocalPort: Local port.
	LocalPort int64 `json:"localPort,omitempty"`
	// Pid: Process ID.
	Pid int64 `json:"pid,omitempty,string"`
	// ProcessName: Process or service name.
	ProcessName string `json:"processName,omitempty"`
	// Protocol: Connection protocol (e.g. TCP/UDP).
	Protocol string `json:"protocol,omitempty"`
	// RemoteIpAddress: Remote IP address.
	RemoteIpAddress string `json:"remoteIpAddress,omitempty"`
	// RemotePort: Remote port.
	RemotePort int64 `json:"remotePort,omitempty"`
	// State: Network connection state.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Connection state is unknown or unspecified.
	//   "OPENING" - The connection is being opened.
	//   "OPEN" - The connection is open.
	//   "LISTEN" - Listening for incoming connections.
	//   "CLOSING" - The connection is being closed.
	//   "CLOSED" - The connection is closed.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LocalIpAddress") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LocalIpAddress") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NetworkConnection) MarshalJSON() ([]byte, error) {
	type NoMethod NetworkConnection
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// NetworkConnectionList: Network connection list.
type NetworkConnectionList struct {
	// Entries: Network connection entries.
	Entries []*NetworkConnection `json:"entries,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Entries") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entries") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NetworkConnectionList) MarshalJSON() ([]byte, error) {
	type NoMethod NetworkConnectionList
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// NetworkUsageSample: Network usage sample. Values are across all network
// interfaces.
type NetworkUsageSample struct {
	// AverageEgressBps: Average network egress in B/s sampled over a short window.
	// Must be non-negative.
	AverageEgressBps float64 `json:"averageEgressBps,omitempty"`
	// AverageIngressBps: Average network ingress in B/s sampled over a short
	// window. Must be non-negative.
	AverageIngressBps float64 `json:"averageIngressBps,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AverageEgressBps") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AverageEgressBps") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NetworkUsageSample) MarshalJSON() ([]byte, error) {
	type NoMethod NetworkUsageSample
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *NetworkUsageSample) UnmarshalJSON(data []byte) error {
	type NoMethod NetworkUsageSample
	var s1 struct {
		AverageEgressBps  gensupport.JSONFloat64 `json:"averageEgressBps"`
		AverageIngressBps gensupport.JSONFloat64 `json:"averageIngressBps"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.AverageEgressBps = float64(s1.AverageEgressBps)
	s.AverageIngressBps = float64(s1.AverageIngressBps)
	return nil
}

// NfsExport: NFS export.
type NfsExport struct {
	// ExportDirectory: The directory being exported.
	ExportDirectory string `json:"exportDirectory,omitempty"`
	// Hosts: The hosts or networks to which the export is being shared.
	Hosts []string `json:"hosts,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExportDirectory") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExportDirectory") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NfsExport) MarshalJSON() ([]byte, error) {
	type NoMethod NfsExport
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// NfsExportList: NFS exports.
type NfsExportList struct {
	// Entries: NFS export entries.
	Entries []*NfsExport `json:"entries,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Entries") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entries") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NfsExportList) MarshalJSON() ([]byte, error) {
	type NoMethod NfsExportList
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OpenFileDetails: Open file Information.
type OpenFileDetails struct {
	// Command: Opened file command.
	Command string `json:"command,omitempty"`
	// FilePath: Opened file file path.
	FilePath string `json:"filePath,omitempty"`
	// FileType: Opened file file type.
	FileType string `json:"fileType,omitempty"`
	// User: Opened file user.
	User string `json:"user,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Command") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Command") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OpenFileDetails) MarshalJSON() ([]byte, error) {
	type NoMethod OpenFileDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OpenFileList: Open file list.
type OpenFileList struct {
	// Entries: Open file details entries.
	Entries []*OpenFileDetails `json:"entries,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Entries") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entries") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OpenFileList) MarshalJSON() ([]byte, error) {
	type NoMethod OpenFileList
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Operation: This resource represents a long-running operation that is the
// result of a network API call.
type Operation struct {
	// Done: If the value is `false`, it means the operation is still in progress.
	// If `true`, the operation is completed, and either `error` or `response` is
	// available.
	Done bool `json:"done,omitempty"`
	// Error: The error result of the operation in case of failure or cancellation.
	Error *Status `json:"error,omitempty"`
	// Metadata: Service-specific metadata associated with the operation. It
	// typically contains progress information and common metadata such as create
	// time. Some services might not provide such metadata. Any method that returns
	// a long-running operation should document the metadata type, if any.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: The server-assigned name, which is only unique within the same service
	// that originally returns it. If you use the default HTTP mapping, the `name`
	// should be a resource name ending with `operations/{unique_id}`.
	Name string `json:"name,omitempty"`
	// Response: The normal, successful response of the operation. If the original
	// method returns no data on success, such as `Delete`, the response is
	// `google.protobuf.Empty`. If the original method is standard
	// `Get`/`Create`/`Update`, the response should be the resource. For other
	// methods, the response should have the type `XxxResponse`, where `Xxx` is the
	// original method name. For example, if the original method name is
	// `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Done") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Done") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Operation) MarshalJSON() ([]byte, error) {
	type NoMethod Operation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OperationMetadata: Represents the metadata of the long-running operation.
type OperationMetadata struct {
	// ApiVersion: Output only. API version used to start the operation.
	ApiVersion string `json:"apiVersion,omitempty"`
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// RequestedCancellation: Output only. Identifies whether the user has
	// requested cancellation of the operation. Operations that have been cancelled
	// successfully have Operation.error value with a google.rpc.Status.code of 1,
	// corresponding to `Code.CANCELLED`.
	RequestedCancellation bool `json:"requestedCancellation,omitempty"`
	// StatusMessage: Output only. Human-readable status of the operation, if any.
	StatusMessage string `json:"statusMessage,omitempty"`
	// Target: Output only. Server-defined resource path for the target of the
	// operation.
	Target string `json:"target,omitempty"`
	// Verb: Output only. Name of the verb executed by the operation.
	Verb string `json:"verb,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApiVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod OperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PerformanceSample: Performance data sample.
type PerformanceSample struct {
	// Cpu: CPU usage sample.
	Cpu *CpuUsageSample `json:"cpu,omitempty"`
	// Disk: Disk usage sample.
	Disk *DiskUsageSample `json:"disk,omitempty"`
	// Memory: Memory usage sample.
	Memory *MemoryUsageSample `json:"memory,omitempty"`
	// Network: Network usage sample.
	Network *NetworkUsageSample `json:"network,omitempty"`
	// SampleTime: Time the sample was collected. If omitted, the frame report time
	// will be used.
	SampleTime string `json:"sampleTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Cpu") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Cpu") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PerformanceSample) MarshalJSON() ([]byte, error) {
	type NoMethod PerformanceSample
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PhysicalPlatformDetails: Platform specific details for Physical Machines.
type PhysicalPlatformDetails struct {
	// Hyperthreading: Whether the machine is hyperthreaded.
	//
	// Possible values:
	//   "HYPERTHREADING_STATUS_UNSPECIFIED" - Simultaneous Multithreading status
	// unknown.
	//   "HYPERTHREADING_STATUS_DISABLED" - Simultaneous Multithreading is disabled
	// or unavailable.
	//   "HYPERTHREADING_STATUS_ENABLED" - Simultaneous Multithreading is enabled.
	Hyperthreading string `json:"hyperthreading,omitempty"`
	// Location: Free text representation of the machine location. The format of
	// this field should not be relied on. Different machines in the same location
	// may have different string values for this field.
	Location string `json:"location,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Hyperthreading") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Hyperthreading") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PhysicalPlatformDetails) MarshalJSON() ([]byte, error) {
	type NoMethod PhysicalPlatformDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PlatformDetails: Information about the platform.
type PlatformDetails struct {
	// AwsEc2Details: AWS EC2 specific details.
	AwsEc2Details *AwsEc2PlatformDetails `json:"awsEc2Details,omitempty"`
	// AzureVmDetails: Azure VM specific details.
	AzureVmDetails *AzureVmPlatformDetails `json:"azureVmDetails,omitempty"`
	// GenericDetails: Generic platform details.
	GenericDetails *GenericPlatformDetails `json:"genericDetails,omitempty"`
	// PhysicalDetails: Physical machines platform details.
	PhysicalDetails *PhysicalPlatformDetails `json:"physicalDetails,omitempty"`
	// VmwareDetails: VMware specific details.
	VmwareDetails *VmwarePlatformDetails `json:"vmwareDetails,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AwsEc2Details") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AwsEc2Details") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PlatformDetails) MarshalJSON() ([]byte, error) {
	type NoMethod PlatformDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PostgreSqlDatabaseDeployment: Specific details for a PostgreSQL database
// deployment.
type PostgreSqlDatabaseDeployment struct {
	// Properties: Optional. List of PostgreSql properties.
	Properties []*PostgreSqlProperty `json:"properties,omitempty"`
	// Settings: Optional. List of PostgreSql settings.
	Settings []*PostgreSqlSetting `json:"settings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Properties") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Properties") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PostgreSqlDatabaseDeployment) MarshalJSON() ([]byte, error) {
	type NoMethod PostgreSqlDatabaseDeployment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PostgreSqlExtension: PostgreSql extension.
type PostgreSqlExtension struct {
	// Extension: Required. The extension name.
	Extension string `json:"extension,omitempty"`
	// Version: Required. The extension version.
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Extension") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Extension") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PostgreSqlExtension) MarshalJSON() ([]byte, error) {
	type NoMethod PostgreSqlExtension
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PostgreSqlProperty: PostgreSql property.
type PostgreSqlProperty struct {
	// Enabled: Required. The property is enabled.
	Enabled bool `json:"enabled,omitempty"`
	// NumericValue: Required. The property numeric value.
	NumericValue int64 `json:"numericValue,omitempty,string"`
	// Property: Required. The property name.
	Property string `json:"property,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enabled") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PostgreSqlProperty) MarshalJSON() ([]byte, error) {
	type NoMethod PostgreSqlProperty
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PostgreSqlSchemaDetails: Specific details for a PostgreSql schema.
type PostgreSqlSchemaDetails struct {
	// ForeignTablesCount: Optional. PostgreSql foreign tables.
	ForeignTablesCount int64 `json:"foreignTablesCount,omitempty"`
	// PostgresqlExtensions: Optional. PostgreSql extensions.
	PostgresqlExtensions []*PostgreSqlExtension `json:"postgresqlExtensions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ForeignTablesCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ForeignTablesCount") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PostgreSqlSchemaDetails) MarshalJSON() ([]byte, error) {
	type NoMethod PostgreSqlSchemaDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PostgreSqlSetting: PostgreSql setting.
type PostgreSqlSetting struct {
	// BoolValue: Required. The setting boolean value.
	BoolValue bool `json:"boolValue,omitempty"`
	// IntValue: Required. The setting int value.
	IntValue int64 `json:"intValue,omitempty,string"`
	// RealValue: Required. The setting real value.
	RealValue float64 `json:"realValue,omitempty"`
	// Setting: Required. The setting name.
	Setting string `json:"setting,omitempty"`
	// Source: Required. The setting source.
	Source string `json:"source,omitempty"`
	// StringValue: Required. The setting string value. Notice that enum values are
	// stored as strings.
	StringValue string `json:"stringValue,omitempty"`
	// Unit: Optional. The setting unit.
	Unit string `json:"unit,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BoolValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BoolValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PostgreSqlSetting) MarshalJSON() ([]byte, error) {
	type NoMethod PostgreSqlSetting
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *PostgreSqlSetting) UnmarshalJSON(data []byte) error {
	type NoMethod PostgreSqlSetting
	var s1 struct {
		RealValue gensupport.JSONFloat64 `json:"realValue"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.RealValue = float64(s1.RealValue)
	return nil
}

// PreferenceSet: The preferences that apply to all assets in a given context.
type PreferenceSet struct {
	// CreateTime: Output only. The timestamp when the preference set was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: A description of the preference set.
	Description string `json:"description,omitempty"`
	// DisplayName: User-friendly display name. Maximum length is 63 characters.
	DisplayName string `json:"displayName,omitempty"`
	// Name: Output only. Name of the preference set.
	Name string `json:"name,omitempty"`
	// UpdateTime: Output only. The timestamp when the preference set was last
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// VirtualMachinePreferences: Optional. A set of preferences that applies to
	// all virtual machines in the context.
	VirtualMachinePreferences *VirtualMachinePreferences `json:"virtualMachinePreferences,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PreferenceSet) MarshalJSON() ([]byte, error) {
	type NoMethod PreferenceSet
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RegionPreferences: The user preferences relating to target regions.
type RegionPreferences struct {
	// PreferredRegions: A list of preferred regions, ordered by the most preferred
	// region first. Set only valid Google Cloud region names. See
	// https://cloud.google.com/compute/docs/regions-zones for available regions.
	PreferredRegions []string `json:"preferredRegions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PreferredRegions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PreferredRegions") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RegionPreferences) MarshalJSON() ([]byte, error) {
	type NoMethod RegionPreferences
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Relation: Message representing a relation between 2 resource.
type Relation struct {
	// CreateTime: Output only. The timestamp when the relation was created.
	CreateTime string `json:"createTime,omitempty"`
	// DstAsset: Output only. The destination asset name in the relation.
	DstAsset string `json:"dstAsset,omitempty"`
	// Name: Output only. Identifier. The identifier of the relation.
	Name string `json:"name,omitempty"`
	// SrcAsset: Output only. The source asset name in the relation.
	SrcAsset string `json:"srcAsset,omitempty"`
	// Type: Optional. The type of the relation.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Default value.
	//   "LOGICAL_DATABASE" - DBDeployment -> Database
	//   "DATABASE_DEPLOYMENT_HOSTING_SERVER" - A relation between a machine/VM and
	// the database deployment it hosts.
	Type string `json:"type,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Relation) MarshalJSON() ([]byte, error) {
	type NoMethod Relation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RemoveAssetsFromGroupRequest: A request to remove assets from a group.
type RemoveAssetsFromGroupRequest struct {
	// AllowMissing: Optional. When this value is set to `false` and one of the
	// given assets is not an existing member of the group, the operation fails
	// with a `Not Found` error. When set to `true` this situation is silently
	// ignored by the server. Default value is `false`.
	AllowMissing bool `json:"allowMissing,omitempty"`
	// Assets: Required. List of assets to be removed. The maximum number of assets
	// that can be removed in a single request is 1000.
	Assets *AssetList `json:"assets,omitempty"`
	// RequestId: Optional. An optional request ID to identify requests. Specify a
	// unique request ID so that if you must retry your request, the server will
	// know to ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes after the first request. For example,
	// consider a situation where you make an initial request and the request times
	// out. If you make the request again with the same request ID, the server can
	// check if original operation with the same request ID was received, and if
	// so, will ignore the second request. This prevents clients from accidentally
	// creating duplicate commitments. The request ID must be a valid UUID with the
	// exception that zero UUID is not supported
	// (00000000-0000-0000-0000-000000000000).
	RequestId string `json:"requestId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowMissing") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowMissing") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RemoveAssetsFromGroupRequest) MarshalJSON() ([]byte, error) {
	type NoMethod RemoveAssetsFromGroupRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Report: Report represents a point-in-time rendering of the ReportConfig
// results.
type Report struct {
	// CreateTime: Output only. Creation timestamp.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Free-text description.
	Description string `json:"description,omitempty"`
	// DisplayName: User-friendly display name. Maximum length is 63 characters.
	DisplayName string `json:"displayName,omitempty"`
	// Name: Output only. Name of resource.
	Name string `json:"name,omitempty"`
	// State: Report creation state.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Default Report creation state.
	//   "PENDING" - Creating Report.
	//   "SUCCEEDED" - Successfully created Report.
	//   "FAILED" - Failed to create Report.
	State string `json:"state,omitempty"`
	// Summary: Output only. Summary view of the Report.
	Summary *ReportSummary `json:"summary,omitempty"`
	// Type: Report type.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Default Report type.
	//   "TOTAL_COST_OF_OWNERSHIP" - Total cost of ownership Report type.
	Type string `json:"type,omitempty"`
	// UpdateTime: Output only. Last update timestamp.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Report) MarshalJSON() ([]byte, error) {
	type NoMethod Report
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ReportArtifactLink: Describes a link to a generated artifact of the report.
type ReportArtifactLink struct {
	// Uri: Output only. URI of the artifact.
	Uri string `json:"uri,omitempty"`
	// UriExpirationTime: Output only. Expiration time of the URI.
	UriExpirationTime string `json:"uriExpirationTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Uri") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Uri") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReportArtifactLink) MarshalJSON() ([]byte, error) {
	type NoMethod ReportArtifactLink
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ReportAssetFramesResponse: A response to a call to `ReportAssetFrame`.
type ReportAssetFramesResponse struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// ReportConfig: The groups and associated preference sets on which we can
// generate reports.
type ReportConfig struct {
	// CreateTime: Output only. The timestamp when the resource was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Free-text description.
	Description string `json:"description,omitempty"`
	// DisplayName: User-friendly display name. Maximum length is 63 characters.
	DisplayName string `json:"displayName,omitempty"`
	// GroupPreferencesetAssignments: Required. Collection of combinations of
	// groups and preference sets.
	GroupPreferencesetAssignments []*ReportConfigGroupPreferenceSetAssignment `json:"groupPreferencesetAssignments,omitempty"`
	// Name: Output only. Name of resource.
	Name string `json:"name,omitempty"`
	// UpdateTime: Output only. The timestamp when the resource was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReportConfig) MarshalJSON() ([]byte, error) {
	type NoMethod ReportConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ReportConfigGroupPreferenceSetAssignment: Represents a combination of a
// group with a preference set.
type ReportConfigGroupPreferenceSetAssignment struct {
	// Group: Required. Name of the group.
	Group string `json:"group,omitempty"`
	// PreferenceSet: Required. Name of the Preference Set.
	PreferenceSet string `json:"preferenceSet,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Group") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Group") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReportConfigGroupPreferenceSetAssignment) MarshalJSON() ([]byte, error) {
	type NoMethod ReportConfigGroupPreferenceSetAssignment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ReportSummary: Describes the Summary view of a Report, which contains
// aggregated values for all the groups and preference sets included in this
// Report.
type ReportSummary struct {
	// AllAssetsStats: Aggregate statistics for all the assets across all the
	// groups.
	AllAssetsStats *ReportSummaryAssetAggregateStats `json:"allAssetsStats,omitempty"`
	// GroupFindings: Findings for each Group included in this report.
	GroupFindings []*ReportSummaryGroupFinding `json:"groupFindings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllAssetsStats") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllAssetsStats") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReportSummary) MarshalJSON() ([]byte, error) {
	type NoMethod ReportSummary
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ReportSummaryAssetAggregateStats: Aggregate statistics for a collection of
// assets.
type ReportSummaryAssetAggregateStats struct {
	// CoreCountHistogram: Histogram showing a distribution of logical CPU core
	// counts.
	CoreCountHistogram *ReportSummaryHistogramChartData `json:"coreCountHistogram,omitempty"`
	// MemoryBytesHistogram: Histogram showing a distribution of memory sizes.
	MemoryBytesHistogram *ReportSummaryHistogramChartData `json:"memoryBytesHistogram,omitempty"`
	// MemoryUtilizationChart: Total memory split into Used/Free buckets.
	MemoryUtilizationChart *ReportSummaryUtilizationChartData `json:"memoryUtilizationChart,omitempty"`
	// OperatingSystem: Count of assets grouped by Operating System families.
	OperatingSystem *ReportSummaryChartData `json:"operatingSystem,omitempty"`
	// StorageBytesHistogram: Histogram showing a distribution of storage sizes.
	StorageBytesHistogram *ReportSummaryHistogramChartData `json:"storageBytesHistogram,omitempty"`
	// StorageUtilizationChart: Total memory split into Used/Free buckets.
	StorageUtilizationChart *ReportSummaryUtilizationChartData `json:"storageUtilizationChart,omitempty"`
	// TotalAssets: Count of the number of unique assets in this collection.
	TotalAssets int64 `json:"totalAssets,omitempty,string"`
	// TotalCores: Sum of the CPU core count of all the assets in this collection.
	TotalCores int64 `json:"totalCores,omitempty,string"`
	// TotalMemoryBytes: Sum of the memory in bytes of all the assets in this
	// collection.
	TotalMemoryBytes int64 `json:"totalMemoryBytes,omitempty,string"`
	// TotalStorageBytes: Sum of persistent storage in bytes of all the assets in
	// this collection.
	TotalStorageBytes int64 `json:"totalStorageBytes,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "CoreCountHistogram") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CoreCountHistogram") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReportSummaryAssetAggregateStats) MarshalJSON() ([]byte, error) {
	type NoMethod ReportSummaryAssetAggregateStats
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ReportSummaryChartData: Describes a collection of data points rendered as a
// Chart.
type ReportSummaryChartData struct {
	// DataPoints: Each data point in the chart is represented as a name-value pair
	// with the name being the x-axis label, and the value being the y-axis value.
	DataPoints []*ReportSummaryChartDataDataPoint `json:"dataPoints,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataPoints") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataPoints") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReportSummaryChartData) MarshalJSON() ([]byte, error) {
	type NoMethod ReportSummaryChartData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ReportSummaryChartDataDataPoint: Describes a single data point in the Chart.
type ReportSummaryChartDataDataPoint struct {
	// Label: The X-axis label for this data point.
	Label string `json:"label,omitempty"`
	// Value: The Y-axis value for this data point.
	Value float64 `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Label") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Label") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReportSummaryChartDataDataPoint) MarshalJSON() ([]byte, error) {
	type NoMethod ReportSummaryChartDataDataPoint
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *ReportSummaryChartDataDataPoint) UnmarshalJSON(data []byte) error {
	type NoMethod ReportSummaryChartDataDataPoint
	var s1 struct {
		Value gensupport.JSONFloat64 `json:"value"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Value = float64(s1.Value)
	return nil
}

// ReportSummaryComputeEngineFinding: A set of findings that applies to assets
// destined for Compute Engine.
type ReportSummaryComputeEngineFinding struct {
	// AllocatedAssetCount: Count of assets which were allocated.
	AllocatedAssetCount int64 `json:"allocatedAssetCount,omitempty,string"`
	// AllocatedDiskTypes: Set of disk types allocated to assets.
	//
	// Possible values:
	//   "PERSISTENT_DISK_TYPE_UNSPECIFIED" - Unspecified. Fallback to default
	// value based on context.
	//   "PERSISTENT_DISK_TYPE_STANDARD" - Standard HDD Persistent Disk.
	//   "PERSISTENT_DISK_TYPE_BALANCED" - Balanced Persistent Disk.
	//   "PERSISTENT_DISK_TYPE_SSD" - SSD Persistent Disk.
	AllocatedDiskTypes []string `json:"allocatedDiskTypes,omitempty"`
	// AllocatedRegions: Set of regions in which the assets were allocated.
	AllocatedRegions []string `json:"allocatedRegions,omitempty"`
	// MachineSeriesAllocations: Distribution of assets based on the Machine
	// Series.
	MachineSeriesAllocations []*ReportSummaryMachineSeriesAllocation `json:"machineSeriesAllocations,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllocatedAssetCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllocatedAssetCount") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReportSummaryComputeEngineFinding) MarshalJSON() ([]byte, error) {
	type NoMethod ReportSummaryComputeEngineFinding
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ReportSummaryGroupFinding: Summary Findings for a specific Group.
type ReportSummaryGroupFinding struct {
	// AssetAggregateStats: Summary statistics for all the assets in this group.
	AssetAggregateStats *ReportSummaryAssetAggregateStats `json:"assetAggregateStats,omitempty"`
	// Description: Description for the Group.
	Description string `json:"description,omitempty"`
	// DisplayName: Display Name for the Group.
	DisplayName string `json:"displayName,omitempty"`
	// OverlappingAssetCount: This field is deprecated, do not rely on it having a
	// value.
	OverlappingAssetCount int64 `json:"overlappingAssetCount,omitempty,string"`
	// PreferenceSetFindings: Findings for each of the PreferenceSets for this
	// group.
	PreferenceSetFindings []*ReportSummaryGroupPreferenceSetFinding `json:"preferenceSetFindings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AssetAggregateStats") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AssetAggregateStats") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReportSummaryGroupFinding) MarshalJSON() ([]byte, error) {
	type NoMethod ReportSummaryGroupFinding
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ReportSummaryGroupPreferenceSetFinding: Summary Findings for a specific
// Group/PreferenceSet combination.
type ReportSummaryGroupPreferenceSetFinding struct {
	// ComputeEngineFinding: A set of findings that applies to Compute Engine
	// machines in the input.
	ComputeEngineFinding *ReportSummaryComputeEngineFinding `json:"computeEngineFinding,omitempty"`
	// Description: Description for the Preference Set.
	Description string `json:"description,omitempty"`
	// DisplayName: Display Name of the Preference Set
	DisplayName string `json:"displayName,omitempty"`
	// MachinePreferences: A set of preferences that applies to all machines in the
	// context.
	MachinePreferences *VirtualMachinePreferences `json:"machinePreferences,omitempty"`
	// MonthlyCostCompute: Compute monthly cost for this preference set.
	MonthlyCostCompute *Money `json:"monthlyCostCompute,omitempty"`
	// MonthlyCostNetworkEgress: Network Egress monthly cost for this preference
	// set.
	MonthlyCostNetworkEgress *Money `json:"monthlyCostNetworkEgress,omitempty"`
	// MonthlyCostOsLicense: Licensing monthly cost for this preference set.
	MonthlyCostOsLicense *Money `json:"monthlyCostOsLicense,omitempty"`
	// MonthlyCostOther: Miscellaneous monthly cost for this preference set.
	MonthlyCostOther *Money `json:"monthlyCostOther,omitempty"`
	// MonthlyCostStorage: Storage monthly cost for this preference set.
	MonthlyCostStorage *Money `json:"monthlyCostStorage,omitempty"`
	// MonthlyCostTotal: Total monthly cost for this preference set.
	MonthlyCostTotal *Money `json:"monthlyCostTotal,omitempty"`
	// SoleTenantFinding: A set of findings that applies to Sole-Tenant machines in
	// the input.
	SoleTenantFinding *ReportSummarySoleTenantFinding `json:"soleTenantFinding,omitempty"`
	// VmwareEngineFinding: A set of findings that applies to VMWare machines in
	// the input.
	VmwareEngineFinding *ReportSummaryVmwareEngineFinding `json:"vmwareEngineFinding,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ComputeEngineFinding") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ComputeEngineFinding") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReportSummaryGroupPreferenceSetFinding) MarshalJSON() ([]byte, error) {
	type NoMethod ReportSummaryGroupPreferenceSetFinding
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ReportSummaryHistogramChartData: A Histogram Chart shows a distribution of
// values into buckets, showing a count of values which fall into a bucket.
type ReportSummaryHistogramChartData struct {
	// Buckets: Buckets in the histogram. There will be `n+1` buckets matching `n`
	// lower bounds in the request. The first bucket will be from -infinity to the
	// first bound. Subsequent buckets will be between one bound and the next. The
	// final bucket will be from the final bound to infinity.
	Buckets []*ReportSummaryHistogramChartDataBucket `json:"buckets,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Buckets") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Buckets") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReportSummaryHistogramChartData) MarshalJSON() ([]byte, error) {
	type NoMethod ReportSummaryHistogramChartData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ReportSummaryHistogramChartDataBucket: A histogram bucket with a lower and
// upper bound, and a count of items with a field value between those bounds.
// The lower bound is inclusive and the upper bound is exclusive. Lower bound
// may be -infinity and upper bound may be infinity.
type ReportSummaryHistogramChartDataBucket struct {
	// Count: Count of items in the bucket.
	Count int64 `json:"count,omitempty,string"`
	// LowerBound: Lower bound - inclusive.
	LowerBound int64 `json:"lowerBound,omitempty,string"`
	// UpperBound: Upper bound - exclusive.
	UpperBound int64 `json:"upperBound,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "Count") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Count") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReportSummaryHistogramChartDataBucket) MarshalJSON() ([]byte, error) {
	type NoMethod ReportSummaryHistogramChartDataBucket
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ReportSummaryMachineSeriesAllocation: Represents a data point tracking the
// count of assets allocated for a specific Machine Series.
type ReportSummaryMachineSeriesAllocation struct {
	// AllocatedAssetCount: Count of assets allocated to this machine series.
	AllocatedAssetCount int64 `json:"allocatedAssetCount,omitempty,string"`
	// MachineSeries: The Machine Series (e.g. "E2", "N2")
	MachineSeries *MachineSeries `json:"machineSeries,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllocatedAssetCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllocatedAssetCount") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReportSummaryMachineSeriesAllocation) MarshalJSON() ([]byte, error) {
	type NoMethod ReportSummaryMachineSeriesAllocation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ReportSummarySoleTenantFinding: A set of findings that applies to assets
// destined for Sole-Tenant nodes.
type ReportSummarySoleTenantFinding struct {
	// AllocatedAssetCount: Count of assets which are allocated
	AllocatedAssetCount int64 `json:"allocatedAssetCount,omitempty,string"`
	// AllocatedRegions: Set of regions in which the assets are allocated
	AllocatedRegions []string `json:"allocatedRegions,omitempty"`
	// NodeAllocations: Set of per-nodetype allocation records
	NodeAllocations []*ReportSummarySoleTenantNodeAllocation `json:"nodeAllocations,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllocatedAssetCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllocatedAssetCount") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReportSummarySoleTenantFinding) MarshalJSON() ([]byte, error) {
	type NoMethod ReportSummarySoleTenantFinding
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ReportSummarySoleTenantNodeAllocation: Represents the assets allocated to a
// specific Sole-Tenant node type.
type ReportSummarySoleTenantNodeAllocation struct {
	// AllocatedAssetCount: Count of assets allocated to these nodes
	AllocatedAssetCount int64 `json:"allocatedAssetCount,omitempty,string"`
	// Node: Sole Tenant node type, e.g. "m3-node-128-3904"
	Node *SoleTenantNodeType `json:"node,omitempty"`
	// NodeCount: Count of this node type to be provisioned
	NodeCount int64 `json:"nodeCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "AllocatedAssetCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllocatedAssetCount") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReportSummarySoleTenantNodeAllocation) MarshalJSON() ([]byte, error) {
	type NoMethod ReportSummarySoleTenantNodeAllocation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ReportSummaryUtilizationChartData: Utilization Chart is a specific type of
// visualization which displays a metric classified into "Used" and "Free"
// buckets.
type ReportSummaryUtilizationChartData struct {
	// Free: Aggregate value which falls into the "Free" bucket.
	Free int64 `json:"free,omitempty,string"`
	// Used: Aggregate value which falls into the "Used" bucket.
	Used int64 `json:"used,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "Free") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Free") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReportSummaryUtilizationChartData) MarshalJSON() ([]byte, error) {
	type NoMethod ReportSummaryUtilizationChartData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ReportSummaryVmwareEngineFinding: A set of findings that applies to assets
// destined for VMWare Engine.
type ReportSummaryVmwareEngineFinding struct {
	// AllocatedAssetCount: Count of assets which are allocated
	AllocatedAssetCount int64 `json:"allocatedAssetCount,omitempty,string"`
	// AllocatedRegions: Set of regions in which the assets were allocated
	AllocatedRegions []string `json:"allocatedRegions,omitempty"`
	// NodeAllocations: Set of per-nodetype allocation records
	NodeAllocations []*ReportSummaryVmwareNodeAllocation `json:"nodeAllocations,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllocatedAssetCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllocatedAssetCount") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReportSummaryVmwareEngineFinding) MarshalJSON() ([]byte, error) {
	type NoMethod ReportSummaryVmwareEngineFinding
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ReportSummaryVmwareNode: A VMWare Engine Node
type ReportSummaryVmwareNode struct {
	// Code: Code to identify VMware Engine node series, e.g. "ve1-standard-72".
	// Based on the displayName of
	// cloud.google.com/vmware-engine/docs/reference/rest/v1/projects.locations.node
	// Types
	Code string `json:"code,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReportSummaryVmwareNode) MarshalJSON() ([]byte, error) {
	type NoMethod ReportSummaryVmwareNode
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ReportSummaryVmwareNodeAllocation: Represents assets allocated to a specific
// VMWare Node type.
type ReportSummaryVmwareNodeAllocation struct {
	// AllocatedAssetCount: Count of assets allocated to these nodes
	AllocatedAssetCount int64 `json:"allocatedAssetCount,omitempty,string"`
	// NodeCount: Count of this node type to be provisioned
	NodeCount int64 `json:"nodeCount,omitempty,string"`
	// VmwareNode: VMWare node type, e.g. "ve1-standard-72"
	VmwareNode *ReportSummaryVmwareNode `json:"vmwareNode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllocatedAssetCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllocatedAssetCount") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReportSummaryVmwareNodeAllocation) MarshalJSON() ([]byte, error) {
	type NoMethod ReportSummaryVmwareNodeAllocation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RunImportJobRequest: A request to run an import job.
type RunImportJobRequest struct {
	// RequestId: Optional. An optional request ID to identify requests. Specify a
	// unique request ID so that if you must retry your request, the server will
	// know to ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes after the first request. For example,
	// consider a situation where you make an initial request and the request times
	// out. If you make the request again with the same request ID, the server can
	// check if original operation with the same request ID was received, and if
	// so, will ignore the second request. This prevents clients from accidentally
	// creating duplicate commitments. The request ID must be a valid UUID with the
	// exception that zero UUID is not supported
	// (00000000-0000-0000-0000-000000000000).
	RequestId string `json:"requestId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RequestId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RequestId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RunImportJobRequest) MarshalJSON() ([]byte, error) {
	type NoMethod RunImportJobRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RunningProcess: Guest OS running process details.
type RunningProcess struct {
	// Attributes: Process extended attributes.
	Attributes map[string]string `json:"attributes,omitempty"`
	// Cmdline: Process full command line.
	Cmdline string `json:"cmdline,omitempty"`
	// ExePath: Process binary path.
	ExePath string `json:"exePath,omitempty"`
	// Pid: Process ID.
	Pid int64 `json:"pid,omitempty,string"`
	// User: User running the process.
	User string `json:"user,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Attributes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Attributes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RunningProcess) MarshalJSON() ([]byte, error) {
	type NoMethod RunningProcess
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RunningProcessList: List of running guest OS processes.
type RunningProcessList struct {
	// Entries: Running process entries.
	Entries []*RunningProcess `json:"entries,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Entries") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entries") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RunningProcessList) MarshalJSON() ([]byte, error) {
	type NoMethod RunningProcessList
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RunningService: Guest OS running service details.
type RunningService struct {
	// Cmdline: Service command line.
	Cmdline string `json:"cmdline,omitempty"`
	// ExePath: Service binary path.
	ExePath string `json:"exePath,omitempty"`
	// Pid: Service pid.
	Pid int64 `json:"pid,omitempty,string"`
	// ServiceName: Service name.
	ServiceName string `json:"serviceName,omitempty"`
	// StartMode: Service start mode (OS-agnostic).
	//
	// Possible values:
	//   "START_MODE_UNSPECIFIED" - Start mode unspecified.
	//   "BOOT" - The service is a device driver started by the system loader.
	//   "SYSTEM" - The service is a device driver started by the IOInitSystem
	// function.
	//   "AUTO" - The service is started by the operating system, at system
	// start-up
	//   "MANUAL" - The service is started only manually, by a user.
	//   "DISABLED" - The service is disabled.
	StartMode string `json:"startMode,omitempty"`
	// State: Service state (OS-agnostic).
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Service state unspecified.
	//   "ACTIVE" - Service is active.
	//   "PAUSED" - Service is paused.
	//   "STOPPED" - Service is stopped.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Cmdline") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Cmdline") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RunningService) MarshalJSON() ([]byte, error) {
	type NoMethod RunningService
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RunningServiceList: List of running guest OS services.
type RunningServiceList struct {
	// Entries: Running service entries.
	Entries []*RunningService `json:"entries,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Entries") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entries") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RunningServiceList) MarshalJSON() ([]byte, error) {
	type NoMethod RunningServiceList
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RuntimeNetworkInfo: Runtime networking information.
type RuntimeNetworkInfo struct {
	// Connections: Network connections.
	Connections *NetworkConnectionList `json:"connections,omitempty"`
	// ScanTime: Time of the last network scan.
	ScanTime string `json:"scanTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Connections") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Connections") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RuntimeNetworkInfo) MarshalJSON() ([]byte, error) {
	type NoMethod RuntimeNetworkInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SendDiscoveryClientHeartbeatRequest: A request to send a discovery client
// heartbeat.
type SendDiscoveryClientHeartbeatRequest struct {
	// Errors: Optional. Errors affecting client functionality.
	Errors []*Status `json:"errors,omitempty"`
	// Version: Optional. Client application version.
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Errors") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Errors") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SendDiscoveryClientHeartbeatRequest) MarshalJSON() ([]byte, error) {
	type NoMethod SendDiscoveryClientHeartbeatRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Settings: Describes the Migration Center settings related to the project.
type Settings struct {
	// DisableCloudLogging: Disable Cloud Logging for the Migration Center API.
	// Users are billed for the logs.
	DisableCloudLogging bool `json:"disableCloudLogging,omitempty"`
	// Name: Output only. The name of the resource.
	Name string `json:"name,omitempty"`
	// PreferenceSet: The preference set used by default for a project.
	PreferenceSet string `json:"preferenceSet,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DisableCloudLogging") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisableCloudLogging") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Settings) MarshalJSON() ([]byte, error) {
	type NoMethod Settings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SoleTenancyPreferences: Preferences concerning Sole Tenancy nodes and VMs.
type SoleTenancyPreferences struct {
	// CommitmentPlan: Commitment plan to consider when calculating costs for
	// virtual machine insights and recommendations. If you are unsure which value
	// to set, a 3 year commitment plan is often a good value to start with.
	//
	// Possible values:
	//   "COMMITMENT_PLAN_UNSPECIFIED" - Unspecified commitment plan.
	//   "ON_DEMAND" - No commitment plan (on-demand usage).
	//   "COMMITMENT_1_YEAR" - 1 year commitment.
	//   "COMMITMENT_3_YEAR" - 3 years commitment.
	CommitmentPlan string `json:"commitmentPlan,omitempty"`
	// CpuOvercommitRatio: CPU overcommit ratio. Acceptable values are between 1.0
	// and 2.0 inclusive.
	CpuOvercommitRatio float64 `json:"cpuOvercommitRatio,omitempty"`
	// HostMaintenancePolicy: Sole Tenancy nodes maintenance policy.
	//
	// Possible values:
	//   "HOST_MAINTENANCE_POLICY_UNSPECIFIED" - Unspecified host maintenance
	// policy.
	//   "HOST_MAINTENANCE_POLICY_DEFAULT" - Default host maintenance policy.
	//   "HOST_MAINTENANCE_POLICY_RESTART_IN_PLACE" - Restart in place host
	// maintenance policy.
	//   "HOST_MAINTENANCE_POLICY_MIGRATE_WITHIN_NODE_GROUP" - Migrate within node
	// group host maintenance policy.
	HostMaintenancePolicy string `json:"hostMaintenancePolicy,omitempty"`
	// NodeTypes: A list of sole tenant node types. An empty list means that all
	// possible node types will be considered.
	NodeTypes []*SoleTenantNodeType `json:"nodeTypes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommitmentPlan") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommitmentPlan") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SoleTenancyPreferences) MarshalJSON() ([]byte, error) {
	type NoMethod SoleTenancyPreferences
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *SoleTenancyPreferences) UnmarshalJSON(data []byte) error {
	type NoMethod SoleTenancyPreferences
	var s1 struct {
		CpuOvercommitRatio gensupport.JSONFloat64 `json:"cpuOvercommitRatio"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.CpuOvercommitRatio = float64(s1.CpuOvercommitRatio)
	return nil
}

// SoleTenantNodeType: A Sole Tenant node type.
type SoleTenantNodeType struct {
	// NodeName: Name of the Sole Tenant node. Consult
	// https://cloud.google.com/compute/docs/nodes/sole-tenant-nodes
	NodeName string `json:"nodeName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NodeName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NodeName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SoleTenantNodeType) MarshalJSON() ([]byte, error) {
	type NoMethod SoleTenantNodeType
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Source: Source represents an object from which asset information is streamed
// to Migration Center.
type Source struct {
	// CreateTime: Output only. The timestamp when the source was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Free-text description.
	Description string `json:"description,omitempty"`
	// DisplayName: User-friendly display name.
	DisplayName string `json:"displayName,omitempty"`
	// ErrorFrameCount: Output only. The number of frames that were reported by the
	// source and contained errors.
	ErrorFrameCount int64 `json:"errorFrameCount,omitempty"`
	// Managed: If `true`, the source is managed by other service(s).
	Managed bool `json:"managed,omitempty"`
	// Name: Output only. The full name of the source.
	Name string `json:"name,omitempty"`
	// PendingFrameCount: Output only. Number of frames that are still being
	// processed.
	PendingFrameCount int64 `json:"pendingFrameCount,omitempty"`
	// Priority: The information confidence of the source. The higher the value,
	// the higher the confidence.
	Priority int64 `json:"priority,omitempty"`
	// State: Output only. The state of the source.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified.
	//   "ACTIVE" - The source is active and ready to be used.
	//   "DELETING" - In the process of being deleted.
	//   "INVALID" - Source is in an invalid state. Asset frames reported to it
	// will be ignored.
	State string `json:"state,omitempty"`
	// Type: Data source type.
	//
	// Possible values:
	//   "SOURCE_TYPE_UNKNOWN" - Unspecified
	//   "SOURCE_TYPE_UPLOAD" - Manually uploaded file (e.g. CSV)
	//   "SOURCE_TYPE_GUEST_OS_SCAN" - Guest-level info
	//   "SOURCE_TYPE_INVENTORY_SCAN" - Inventory-level scan
	//   "SOURCE_TYPE_CUSTOM" - Third-party owned sources.
	//   "SOURCE_TYPE_DISCOVERY_CLIENT" - Discovery clients
	Type string `json:"type,omitempty"`
	// UpdateTime: Output only. The timestamp when the source was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Source) MarshalJSON() ([]byte, error) {
	type NoMethod Source
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SqlServerDatabaseDeployment: Specific details for a Microsoft SQL Server
// database deployment.
type SqlServerDatabaseDeployment struct {
	// Features: Optional. List of SQL Server features.
	Features []*SqlServerFeature `json:"features,omitempty"`
	// ServerFlags: Optional. List of SQL Server server flags.
	ServerFlags []*SqlServerServerFlag `json:"serverFlags,omitempty"`
	// TraceFlags: Optional. List of SQL Server trace flags.
	TraceFlags []*SqlServerTraceFlag `json:"traceFlags,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Features") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Features") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SqlServerDatabaseDeployment) MarshalJSON() ([]byte, error) {
	type NoMethod SqlServerDatabaseDeployment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SqlServerFeature: SQL Server feature details.
type SqlServerFeature struct {
	// Enabled: Required. Field enabled is set when a feature is used on the source
	// deployment.
	Enabled bool `json:"enabled,omitempty"`
	// FeatureName: Required. The feature name.
	FeatureName string `json:"featureName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enabled") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SqlServerFeature) MarshalJSON() ([]byte, error) {
	type NoMethod SqlServerFeature
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SqlServerSchemaDetails: Specific details for a SqlServer database.
type SqlServerSchemaDetails struct {
	// ClrObjectCount: Optional. SqlServer number of CLR objects.
	ClrObjectCount int64 `json:"clrObjectCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClrObjectCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClrObjectCount") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SqlServerSchemaDetails) MarshalJSON() ([]byte, error) {
	type NoMethod SqlServerSchemaDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SqlServerServerFlag: SQL Server server flag details.
type SqlServerServerFlag struct {
	// ServerFlagName: Required. The server flag name.
	ServerFlagName string `json:"serverFlagName,omitempty"`
	// Value: Required. The server flag value set by the user.
	Value string `json:"value,omitempty"`
	// ValueInUse: Required. The server flag actual value. If `value_in_use` is
	// different from `value` it means that either the configuration change was not
	// applied or it is an expected behavior. See SQL Server documentation for more
	// details.
	ValueInUse string `json:"valueInUse,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ServerFlagName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ServerFlagName") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SqlServerServerFlag) MarshalJSON() ([]byte, error) {
	type NoMethod SqlServerServerFlag
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SqlServerTraceFlag: SQL Server trace flag details.
type SqlServerTraceFlag struct {
	// Scope: Required. The trace flag scope.
	//
	// Possible values:
	//   "SCOPE_UNSPECIFIED" - Unspecified.
	//   "OFF" - Off.
	//   "GLOBAL" - Global.
	//   "SESSION" - Session.
	Scope string `json:"scope,omitempty"`
	// TraceFlagName: Required. The trace flag name.
	TraceFlagName string `json:"traceFlagName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Scope") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Scope") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SqlServerTraceFlag) MarshalJSON() ([]byte, error) {
	type NoMethod SqlServerTraceFlag
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Status: The `Status` type defines a logical error model that is suitable for
// different programming environments, including REST APIs and RPC APIs. It is
// used by gRPC (https://github.com/grpc). Each `Status` message contains three
// pieces of data: error code, error message, and error details. You can find
// out more about this error model and how to work with it in the API Design
// Guide (https://cloud.google.com/apis/design/errors).
type Status struct {
	// Code: The status code, which should be an enum value of google.rpc.Code.
	Code int64 `json:"code,omitempty"`
	// Details: A list of messages that carry the error details. There is a common
	// set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`
	// Message: A developer-facing error message, which should be in English. Any
	// user-facing error message should be localized and sent in the
	// google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Status) MarshalJSON() ([]byte, error) {
	type NoMethod Status
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UpdateAssetRequest: A request to update an asset.
type UpdateAssetRequest struct {
	// Asset: Required. The resource being updated.
	Asset *Asset `json:"asset,omitempty"`
	// RequestId: Optional. An optional request ID to identify requests. Specify a
	// unique request ID so that if you must retry your request, the server will
	// know to ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes since the first request. For example,
	// consider a situation where you make an initial request and the request times
	// out. If you make the request again with the same request ID, the server can
	// check if original operation with the same request ID was received, and if
	// so, will ignore the second request. This prevents clients from accidentally
	// creating duplicate commitments. The request ID must be a valid UUID with the
	// exception that zero UUID is not supported
	// (00000000-0000-0000-0000-000000000000).
	RequestId string `json:"requestId,omitempty"`
	// UpdateMask: Required. Field mask is used to specify the fields to be
	// overwritten in the `Asset` resource by the update. The values specified in
	// the `update_mask` field are relative to the resource, not the full request.
	// A field will be overwritten if it is in the mask. A single * value in the
	// mask lets you to overwrite all fields.
	UpdateMask string `json:"updateMask,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Asset") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Asset") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UpdateAssetRequest) MarshalJSON() ([]byte, error) {
	type NoMethod UpdateAssetRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UploadFileInfo: A resource that contains a URI to which a data file can be
// uploaded.
type UploadFileInfo struct {
	// Headers: Output only. The headers that were used to sign the URI.
	Headers map[string]string `json:"headers,omitempty"`
	// SignedUri: Output only. Upload URI for the file.
	SignedUri string `json:"signedUri,omitempty"`
	// UriExpirationTime: Output only. Expiration time of the upload URI.
	UriExpirationTime string `json:"uriExpirationTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Headers") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Headers") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UploadFileInfo) MarshalJSON() ([]byte, error) {
	type NoMethod UploadFileInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ValidateImportJobRequest: A request to validate an import job.
type ValidateImportJobRequest struct {
	// RequestId: Optional. An optional request ID to identify requests. Specify a
	// unique request ID so that if you must retry your request, the server will
	// know to ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes after the first request. For example,
	// consider a situation where you make an initial request and the request times
	// out. If you make the request again with the same request ID, the server can
	// check if original operation with the same request ID was received, and if
	// so, will ignore the second request. This prevents clients from accidentally
	// creating duplicate commitments. The request ID must be a valid UUID with the
	// exception that zero UUID is not supported
	// (00000000-0000-0000-0000-000000000000).
	RequestId string `json:"requestId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RequestId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RequestId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ValidateImportJobRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ValidateImportJobRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ValidationReport: A resource that aggregates errors across import job files.
type ValidationReport struct {
	// FileValidations: List of errors found in files.
	FileValidations []*FileValidationReport `json:"fileValidations,omitempty"`
	// JobErrors: List of job level errors.
	JobErrors []*ImportError `json:"jobErrors,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FileValidations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FileValidations") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ValidationReport) MarshalJSON() ([]byte, error) {
	type NoMethod ValidationReport
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// VirtualMachinePreferences: VirtualMachinePreferences enables you to create
// sets of assumptions, for example, a geographical location and pricing track,
// for your migrated virtual machines. The set of preferences influence
// recommendations for migrating virtual machine assets.
type VirtualMachinePreferences struct {
	// CommitmentPlan: Commitment plan to consider when calculating costs for
	// virtual machine insights and recommendations. If you are unsure which value
	// to set, a 3 year commitment plan is often a good value to start with.
	//
	// Possible values:
	//   "COMMITMENT_PLAN_UNSPECIFIED" - Unspecified commitment plan.
	//   "COMMITMENT_PLAN_NONE" - No commitment plan.
	//   "COMMITMENT_PLAN_ONE_YEAR" - 1 year commitment.
	//   "COMMITMENT_PLAN_THREE_YEARS" - 3 years commitment.
	CommitmentPlan string `json:"commitmentPlan,omitempty"`
	// ComputeEnginePreferences: Compute Engine preferences concern insights and
	// recommendations for Compute Engine target.
	ComputeEnginePreferences *ComputeEnginePreferences `json:"computeEnginePreferences,omitempty"`
	// RegionPreferences: Region preferences for assets using this preference set.
	// If you are unsure which value to set, the migration service API region is
	// often a good value to start with.
	RegionPreferences *RegionPreferences `json:"regionPreferences,omitempty"`
	// SizingOptimizationStrategy: Sizing optimization strategy specifies the
	// preferred strategy used when extrapolating usage data to calculate insights
	// and recommendations for a virtual machine. If you are unsure which value to
	// set, a moderate sizing optimization strategy is often a good value to start
	// with.
	//
	// Possible values:
	//   "SIZING_OPTIMIZATION_STRATEGY_UNSPECIFIED" - Unspecified (default value).
	//   "SIZING_OPTIMIZATION_STRATEGY_SAME_AS_SOURCE" - No optimization applied.
	// Virtual machine sizing matches as closely as possible the machine shape on
	// the source site, not considering any actual performance data.
	//   "SIZING_OPTIMIZATION_STRATEGY_MODERATE" - Virtual machine sizing will
	// match the reported usage and shape, with some slack. This a good value to
	// start with.
	//   "SIZING_OPTIMIZATION_STRATEGY_AGGRESSIVE" - Virtual machine sizing will
	// match the reported usage, with little slack. Using this option can help
	// reduce costs.
	SizingOptimizationStrategy string `json:"sizingOptimizationStrategy,omitempty"`
	// SoleTenancyPreferences: Preferences concerning Sole Tenant nodes and virtual
	// machines.
	SoleTenancyPreferences *SoleTenancyPreferences `json:"soleTenancyPreferences,omitempty"`
	// TargetProduct: Target product for assets using this preference set. Specify
	// either target product or business goal, but not both.
	//
	// Possible values:
	//   "COMPUTE_MIGRATION_TARGET_PRODUCT_UNSPECIFIED" - Unspecified (default
	// value).
	//   "COMPUTE_MIGRATION_TARGET_PRODUCT_COMPUTE_ENGINE" - Prefer to migrate to
	// Google Cloud Compute Engine.
	//   "COMPUTE_MIGRATION_TARGET_PRODUCT_VMWARE_ENGINE" - Prefer to migrate to
	// Google Cloud VMware Engine.6278
	//   "COMPUTE_MIGRATION_TARGET_PRODUCT_SOLE_TENANCY" - Prefer to migrate to
	// Google Cloud Sole Tenant Nodes.
	TargetProduct string `json:"targetProduct,omitempty"`
	// VmwareEnginePreferences: Preferences concerning insights and recommendations
	// for Google Cloud VMware Engine.
	VmwareEnginePreferences *VmwareEnginePreferences `json:"vmwareEnginePreferences,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommitmentPlan") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommitmentPlan") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s VirtualMachinePreferences) MarshalJSON() ([]byte, error) {
	type NoMethod VirtualMachinePreferences
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// VmwareDiskConfig: VMware disk config details.
type VmwareDiskConfig struct {
	// BackingType: VMDK backing type.
	//
	// Possible values:
	//   "BACKING_TYPE_UNSPECIFIED" - Default value.
	//   "BACKING_TYPE_FLAT_V1" - Flat v1.
	//   "BACKING_TYPE_FLAT_V2" - Flat v2.
	//   "BACKING_TYPE_PMEM" - Persistent memory, also known as Non-Volatile Memory
	// (NVM).
	//   "BACKING_TYPE_RDM_V1" - Raw Disk Memory v1.
	//   "BACKING_TYPE_RDM_V2" - Raw Disk Memory v2.
	//   "BACKING_TYPE_SESPARSE" - SEsparse is a snapshot format introduced in
	// vSphere 5.5 for large disks.
	//   "BACKING_TYPE_SESPARSE_V1" - SEsparse v1.
	//   "BACKING_TYPE_SESPARSE_V2" - SEsparse v1.
	BackingType string `json:"backingType,omitempty"`
	// RdmCompatibility: RDM compatibility mode.
	//
	// Possible values:
	//   "RDM_COMPATIBILITY_UNSPECIFIED" - Compatibility mode unspecified or
	// unknown.
	//   "PHYSICAL_COMPATIBILITY" - Physical compatibility mode.
	//   "VIRTUAL_COMPATIBILITY" - Virtual compatibility mode.
	RdmCompatibility string `json:"rdmCompatibility,omitempty"`
	// Shared: Is VMDK shared with other VMs.
	Shared bool `json:"shared,omitempty"`
	// VmdkMode: VMDK disk mode.
	//
	// Possible values:
	//   "VMDK_MODE_UNSPECIFIED" - VMDK disk mode unspecified or unknown.
	//   "DEPENDENT" - Dependent disk mode.
	//   "INDEPENDENT_PERSISTENT" - Independent - Persistent disk mode.
	//   "INDEPENDENT_NONPERSISTENT" - Independent - Nonpersistent disk mode.
	VmdkMode string `json:"vmdkMode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BackingType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BackingType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s VmwareDiskConfig) MarshalJSON() ([]byte, error) {
	type NoMethod VmwareDiskConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// VmwareEnginePreferences: The user preferences relating to Google Cloud
// VMware Engine target platform.
type VmwareEnginePreferences struct {
	// CommitmentPlan: Commitment plan to consider when calculating costs for
	// virtual machine insights and recommendations. If you are unsure which value
	// to set, a 3 year commitment plan is often a good value to start with.
	//
	// Possible values:
	//   "COMMITMENT_PLAN_UNSPECIFIED" - Unspecified commitment plan.
	//   "ON_DEMAND" - No commitment plan (on-demand usage).
	//   "COMMITMENT_1_YEAR_MONTHLY_PAYMENTS" - 1 year commitment (monthly
	// payments).
	//   "COMMITMENT_3_YEAR_MONTHLY_PAYMENTS" - 3 year commitment (monthly
	// payments).
	//   "COMMITMENT_1_YEAR_UPFRONT_PAYMENT" - 1 year commitment (upfront payment).
	//   "COMMITMENT_3_YEAR_UPFRONT_PAYMENT" - 3 years commitment (upfront
	// payment).
	CommitmentPlan string `json:"commitmentPlan,omitempty"`
	// CpuOvercommitRatio: CPU overcommit ratio. Acceptable values are between 1.0
	// and 8.0, with 0.1 increment.
	CpuOvercommitRatio float64 `json:"cpuOvercommitRatio,omitempty"`
	// MemoryOvercommitRatio: Memory overcommit ratio. Acceptable values are 1.0,
	// 1.25, 1.5, 1.75 and 2.0.
	MemoryOvercommitRatio float64 `json:"memoryOvercommitRatio,omitempty"`
	// StorageDeduplicationCompressionRatio: The Deduplication and Compression
	// ratio is based on the logical (Used Before) space required to store data
	// before applying deduplication and compression, in relation to the physical
	// (Used After) space required after applying deduplication and compression.
	// Specifically, the ratio is the Used Before space divided by the Used After
	// space. For example, if the Used Before space is 3 GB, but the physical Used
	// After space is 1 GB, the deduplication and compression ratio is 3x.
	// Acceptable values are between 1.0 and 4.0.
	StorageDeduplicationCompressionRatio float64 `json:"storageDeduplicationCompressionRatio,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommitmentPlan") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommitmentPlan") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s VmwareEnginePreferences) MarshalJSON() ([]byte, error) {
	type NoMethod VmwareEnginePreferences
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *VmwareEnginePreferences) UnmarshalJSON(data []byte) error {
	type NoMethod VmwareEnginePreferences
	var s1 struct {
		CpuOvercommitRatio                   gensupport.JSONFloat64 `json:"cpuOvercommitRatio"`
		MemoryOvercommitRatio                gensupport.JSONFloat64 `json:"memoryOvercommitRatio"`
		StorageDeduplicationCompressionRatio gensupport.JSONFloat64 `json:"storageDeduplicationCompressionRatio"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.CpuOvercommitRatio = float64(s1.CpuOvercommitRatio)
	s.MemoryOvercommitRatio = float64(s1.MemoryOvercommitRatio)
	s.StorageDeduplicationCompressionRatio = float64(s1.StorageDeduplicationCompressionRatio)
	return nil
}

// VmwarePlatformDetails: VMware specific details.
type VmwarePlatformDetails struct {
	// EsxHyperthreading: Whether the ESX is hyperthreaded.
	//
	// Possible values:
	//   "HYPERTHREADING_STATUS_UNSPECIFIED" - Simultaneous Multithreading status
	// unknown.
	//   "HYPERTHREADING_STATUS_DISABLED" - Simultaneous Multithreading is disabled
	// or unavailable.
	//   "HYPERTHREADING_STATUS_ENABLED" - Simultaneous Multithreading is enabled.
	EsxHyperthreading string `json:"esxHyperthreading,omitempty"`
	// EsxVersion: ESX version.
	EsxVersion string `json:"esxVersion,omitempty"`
	// Osid: VMware os enum -
	// https://vdc-repo.vmware.com/vmwb-repository/dcr-public/da47f910-60ac-438b-8b9b-6122f4d14524/16b7274a-bf8b-4b4c-a05e-746f2aa93c8c/doc/vim.vm.GuestOsDescriptor.GuestOsIdentifier.html.
	Osid string `json:"osid,omitempty"`
	// VcenterFolder: Folder name in vCenter where asset resides.
	VcenterFolder string `json:"vcenterFolder,omitempty"`
	// VcenterUri: vCenter URI used in collection.
	VcenterUri string `json:"vcenterUri,omitempty"`
	// VcenterVersion: vCenter version.
	VcenterVersion string `json:"vcenterVersion,omitempty"`
	// VcenterVmId: vCenter VM ID.
	VcenterVmId string `json:"vcenterVmId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EsxHyperthreading") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EsxHyperthreading") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s VmwarePlatformDetails) MarshalJSON() ([]byte, error) {
	type NoMethod VmwarePlatformDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ProjectsLocationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about a location.
//
// - name: Resource name for the location.
func (r *ProjectsLocationsService) Get(name string) *ProjectsLocationsGetCall {
	c := &ProjectsLocationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGetCall) Context(ctx context.Context) *ProjectsLocationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "migrationcenter.projects.locations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Location.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsGetCall) Do(opts ...googleapi.CallOption) (*Location, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Location{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsGetSettingsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetSettings: Gets the details of regional settings.
//
// - name: Name of the resource.
func (r *ProjectsLocationsService) GetSettings(name string) *ProjectsLocationsGetSettingsCall {
	c := &ProjectsLocationsGetSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGetSettingsCall) Fields(s ...googleapi.Field) *ProjectsLocationsGetSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsGetSettingsCall) IfNoneMatch(entityTag string) *ProjectsLocationsGetSettingsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGetSettingsCall) Context(ctx context.Context) *ProjectsLocationsGetSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGetSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGetSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.getSettings", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "migrationcenter.projects.locations.getSettings" call.
// Any non-2xx status code is an error. Response headers are in either
// *Settings.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsGetSettingsCall) Do(opts ...googleapi.CallOption) (*Settings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Settings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.getSettings", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists information about the supported locations for this service.
//
// - name: The resource that owns the locations collection, if applicable.
func (r *ProjectsLocationsService) List(name string) *ProjectsLocationsListCall {
	c := &ProjectsLocationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// ExtraLocationTypes sets the optional parameter "extraLocationTypes": Do not
// use this field. It is unsupported and is ignored unless explicitly
// documented otherwise. This is primarily for internal usage.
func (c *ProjectsLocationsListCall) ExtraLocationTypes(extraLocationTypes ...string) *ProjectsLocationsListCall {
	c.urlParams_.SetMulti("extraLocationTypes", append([]string{}, extraLocationTypes...))
	return c
}

// Filter sets the optional parameter "filter": A filter to narrow down results
// to a preferred subset. The filtering language accepts strings like
// "displayName=tokyo", and is documented in more detail in AIP-160
// (https://google.aip.dev/160).
func (c *ProjectsLocationsListCall) Filter(filter string) *ProjectsLocationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return. If not set, the service selects a default.
func (c *ProjectsLocationsListCall) PageSize(pageSize int64) *ProjectsLocationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token received
// from the `next_page_token` field in the response. Send that page token to
// receive the subsequent page.
func (c *ProjectsLocationsListCall) PageToken(pageToken string) *ProjectsLocationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsListCall) Context(ctx context.Context) *ProjectsLocationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}/locations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "migrationcenter.projects.locations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListLocationsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsListCall) Do(opts ...googleapi.CallOption) (*ListLocationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListLocationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsListCall) Pages(ctx context.Context, f func(*ListLocationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsUpdateSettingsCall struct {
	s          *Service
	name       string
	settings   *Settings
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// UpdateSettings: Updates the regional-level project settings.
//
// - name: Output only. The name of the resource.
func (r *ProjectsLocationsService) UpdateSettings(name string, settings *Settings) *ProjectsLocationsUpdateSettingsCall {
	c := &ProjectsLocationsUpdateSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.settings = settings
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes since
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsUpdateSettingsCall) RequestId(requestId string) *ProjectsLocationsUpdateSettingsCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Field mask is
// used to specify the fields to be overwritten in the `Settings` resource by
// the update. The values specified in the `update_mask` field are relative to
// the resource, not the full request. A field will be overwritten if it is in
// the mask. A single * value in the mask lets you to overwrite all fields.
func (c *ProjectsLocationsUpdateSettingsCall) UpdateMask(updateMask string) *ProjectsLocationsUpdateSettingsCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsUpdateSettingsCall) Fields(s ...googleapi.Field) *ProjectsLocationsUpdateSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsUpdateSettingsCall) Context(ctx context.Context) *ProjectsLocationsUpdateSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsUpdateSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsUpdateSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.settings)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.updateSettings", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "migrationcenter.projects.locations.updateSettings" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsUpdateSettingsCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.updateSettings", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAssetsAggregateValuesCall struct {
	s                            *Service
	parent                       string
	aggregateassetsvaluesrequest *AggregateAssetsValuesRequest
	urlParams_                   gensupport.URLParams
	ctx_                         context.Context
	header_                      http.Header
}

// AggregateValues: Aggregates the requested fields based on provided function.
//
// - parent: Parent value for `AggregateAssetsValuesRequest`.
func (r *ProjectsLocationsAssetsService) AggregateValues(parent string, aggregateassetsvaluesrequest *AggregateAssetsValuesRequest) *ProjectsLocationsAssetsAggregateValuesCall {
	c := &ProjectsLocationsAssetsAggregateValuesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.aggregateassetsvaluesrequest = aggregateassetsvaluesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAssetsAggregateValuesCall) Fields(s ...googleapi.Field) *ProjectsLocationsAssetsAggregateValuesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAssetsAggregateValuesCall) Context(ctx context.Context) *ProjectsLocationsAssetsAggregateValuesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAssetsAggregateValuesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAssetsAggregateValuesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.aggregateassetsvaluesrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/assets:aggregateValues")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.assets.aggregateValues", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "migrationcenter.projects.locations.assets.aggregateValues" call.
// Any non-2xx status code is an error. Response headers are in either
// *AggregateAssetsValuesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAssetsAggregateValuesCall) Do(opts ...googleapi.CallOption) (*AggregateAssetsValuesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AggregateAssetsValuesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.assets.aggregateValues", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAssetsBatchDeleteCall struct {
	s                        *Service
	parent                   string
	batchdeleteassetsrequest *BatchDeleteAssetsRequest
	urlParams_               gensupport.URLParams
	ctx_                     context.Context
	header_                  http.Header
}

// BatchDelete: Deletes list of Assets.
//
// - parent: Parent value for batch asset delete.
func (r *ProjectsLocationsAssetsService) BatchDelete(parent string, batchdeleteassetsrequest *BatchDeleteAssetsRequest) *ProjectsLocationsAssetsBatchDeleteCall {
	c := &ProjectsLocationsAssetsBatchDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.batchdeleteassetsrequest = batchdeleteassetsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAssetsBatchDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsAssetsBatchDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAssetsBatchDeleteCall) Context(ctx context.Context) *ProjectsLocationsAssetsBatchDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAssetsBatchDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAssetsBatchDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.batchdeleteassetsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/assets:batchDelete")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.assets.batchDelete", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "migrationcenter.projects.locations.assets.batchDelete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAssetsBatchDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.assets.batchDelete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAssetsBatchUpdateCall struct {
	s                        *Service
	parent                   string
	batchupdateassetsrequest *BatchUpdateAssetsRequest
	urlParams_               gensupport.URLParams
	ctx_                     context.Context
	header_                  http.Header
}

// BatchUpdate: Updates the parameters of a list of assets.
//
// - parent: Parent value for batch asset update.
func (r *ProjectsLocationsAssetsService) BatchUpdate(parent string, batchupdateassetsrequest *BatchUpdateAssetsRequest) *ProjectsLocationsAssetsBatchUpdateCall {
	c := &ProjectsLocationsAssetsBatchUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.batchupdateassetsrequest = batchupdateassetsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAssetsBatchUpdateCall) Fields(s ...googleapi.Field) *ProjectsLocationsAssetsBatchUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAssetsBatchUpdateCall) Context(ctx context.Context) *ProjectsLocationsAssetsBatchUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAssetsBatchUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAssetsBatchUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.batchupdateassetsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/assets:batchUpdate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.assets.batchUpdate", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "migrationcenter.projects.locations.assets.batchUpdate" call.
// Any non-2xx status code is an error. Response headers are in either
// *BatchUpdateAssetsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAssetsBatchUpdateCall) Do(opts ...googleapi.CallOption) (*BatchUpdateAssetsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &BatchUpdateAssetsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.assets.batchUpdate", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAssetsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an asset.
//
// - name: Name of the resource.
func (r *ProjectsLocationsAssetsService) Delete(name string) *ProjectsLocationsAssetsDeleteCall {
	c := &ProjectsLocationsAssetsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes after
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsAssetsDeleteCall) RequestId(requestId string) *ProjectsLocationsAssetsDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAssetsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsAssetsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAssetsDeleteCall) Context(ctx context.Context) *ProjectsLocationsAssetsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAssetsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAssetsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.assets.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "migrationcenter.projects.locations.assets.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAssetsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.assets.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAssetsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the details of an asset.
//
// - name: Name of the resource.
func (r *ProjectsLocationsAssetsService) Get(name string) *ProjectsLocationsAssetsGetCall {
	c := &ProjectsLocationsAssetsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// View sets the optional parameter "view": View of the assets. Defaults to
// BASIC.
//
// Possible values:
//
//	"ASSET_VIEW_UNSPECIFIED" - The asset view is not specified. The API
//
// displays the basic view by default.
//
//	"ASSET_VIEW_BASIC" - The asset view includes only basic metadata of the
//
// asset.
//
//	"ASSET_VIEW_FULL" - The asset view includes all the metadata of an asset
//
// and performance data.
//
//	"ASSET_VIEW_STANDARD" - The asset view includes the standard metadata of
//
// an asset.
//
//	"ASSET_VIEW_UI" - The asset view includes fields needed by UI.
//	"ASSET_VIEW_LABELS" - The asset view includes asset name and labels.
func (c *ProjectsLocationsAssetsGetCall) View(view string) *ProjectsLocationsAssetsGetCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAssetsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsAssetsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAssetsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsAssetsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAssetsGetCall) Context(ctx context.Context) *ProjectsLocationsAssetsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAssetsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAssetsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.assets.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "migrationcenter.projects.locations.assets.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Asset.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAssetsGetCall) Do(opts ...googleapi.CallOption) (*Asset, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Asset{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.assets.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAssetsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all the assets in a given project and location.
//
// - parent: Parent value for `ListAssetsRequest`.
func (r *ProjectsLocationsAssetsService) List(parent string) *ProjectsLocationsAssetsListCall {
	c := &ProjectsLocationsAssetsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filtering results.
func (c *ProjectsLocationsAssetsListCall) Filter(filter string) *ProjectsLocationsAssetsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Field to sort by. See
// https://google.aip.dev/132#ordering for more details.
func (c *ProjectsLocationsAssetsListCall) OrderBy(orderBy string) *ProjectsLocationsAssetsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. Server
// may return fewer items than requested. If unspecified, server will pick an
// appropriate default.
func (c *ProjectsLocationsAssetsListCall) PageSize(pageSize int64) *ProjectsLocationsAssetsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results the server should return.
func (c *ProjectsLocationsAssetsListCall) PageToken(pageToken string) *ProjectsLocationsAssetsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ShowHidden sets the optional parameter "showHidden": When this value is set
// to 'true,' the response will include all assets, including those that are
// hidden.
func (c *ProjectsLocationsAssetsListCall) ShowHidden(showHidden bool) *ProjectsLocationsAssetsListCall {
	c.urlParams_.Set("showHidden", fmt.Sprint(showHidden))
	return c
}

// View sets the optional parameter "view": View of the assets. Defaults to
// BASIC.
//
// Possible values:
//
//	"ASSET_VIEW_UNSPECIFIED" - The asset view is not specified. The API
//
// displays the basic view by default.
//
//	"ASSET_VIEW_BASIC" - The asset view includes only basic metadata of the
//
// asset.
//
//	"ASSET_VIEW_FULL" - The asset view includes all the metadata of an asset
//
// and performance data.
//
//	"ASSET_VIEW_STANDARD" - The asset view includes the standard metadata of
//
// an asset.
//
//	"ASSET_VIEW_UI" - The asset view includes fields needed by UI.
//	"ASSET_VIEW_LABELS" - The asset view includes asset name and labels.
func (c *ProjectsLocationsAssetsListCall) View(view string) *ProjectsLocationsAssetsListCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAssetsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsAssetsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAssetsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsAssetsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAssetsListCall) Context(ctx context.Context) *ProjectsLocationsAssetsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAssetsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAssetsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/assets")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.assets.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "migrationcenter.projects.locations.assets.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListAssetsResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsAssetsListCall) Do(opts ...googleapi.CallOption) (*ListAssetsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListAssetsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.assets.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsAssetsListCall) Pages(ctx context.Context, f func(*ListAssetsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsAssetsPatchCall struct {
	s          *Service
	name       string
	asset      *Asset
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates the parameters of an asset.
//
// - name: Output only. The full name of the asset.
func (r *ProjectsLocationsAssetsService) Patch(name string, asset *Asset) *ProjectsLocationsAssetsPatchCall {
	c := &ProjectsLocationsAssetsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.asset = asset
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes since
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsAssetsPatchCall) RequestId(requestId string) *ProjectsLocationsAssetsPatchCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Field mask is
// used to specify the fields to be overwritten in the `Asset` resource by the
// update. The values specified in the `update_mask` field are relative to the
// resource, not the full request. A field will be overwritten if it is in the
// mask. A single * value in the mask lets you to overwrite all fields.
func (c *ProjectsLocationsAssetsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsAssetsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAssetsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsAssetsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAssetsPatchCall) Context(ctx context.Context) *ProjectsLocationsAssetsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAssetsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAssetsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.asset)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.assets.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "migrationcenter.projects.locations.assets.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Asset.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAssetsPatchCall) Do(opts ...googleapi.CallOption) (*Asset, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Asset{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.assets.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAssetsReportAssetFramesCall struct {
	s          *Service
	parent     string
	frames     *Frames
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// ReportAssetFrames: Reports a set of frames.
//
// - parent: Parent of the resource.
func (r *ProjectsLocationsAssetsService) ReportAssetFrames(parent string, frames *Frames) *ProjectsLocationsAssetsReportAssetFramesCall {
	c := &ProjectsLocationsAssetsReportAssetFramesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.frames = frames
	return c
}

// Source sets the optional parameter "source": Required. Reference to a
// source.
func (c *ProjectsLocationsAssetsReportAssetFramesCall) Source(source string) *ProjectsLocationsAssetsReportAssetFramesCall {
	c.urlParams_.Set("source", source)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAssetsReportAssetFramesCall) Fields(s ...googleapi.Field) *ProjectsLocationsAssetsReportAssetFramesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAssetsReportAssetFramesCall) Context(ctx context.Context) *ProjectsLocationsAssetsReportAssetFramesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAssetsReportAssetFramesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAssetsReportAssetFramesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.frames)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/assets:reportAssetFrames")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.assets.reportAssetFrames", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "migrationcenter.projects.locations.assets.reportAssetFrames" call.
// Any non-2xx status code is an error. Response headers are in either
// *ReportAssetFramesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAssetsReportAssetFramesCall) Do(opts ...googleapi.CallOption) (*ReportAssetFramesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ReportAssetFramesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.assets.reportAssetFrames", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDiscoveryClientsCreateCall struct {
	s               *Service
	parent          string
	discoveryclient *DiscoveryClient
	urlParams_      gensupport.URLParams
	ctx_            context.Context
	header_         http.Header
}

// Create: Creates a new discovery client.
//
// - parent: Parent resource.
func (r *ProjectsLocationsDiscoveryClientsService) Create(parent string, discoveryclient *DiscoveryClient) *ProjectsLocationsDiscoveryClientsCreateCall {
	c := &ProjectsLocationsDiscoveryClientsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.discoveryclient = discoveryclient
	return c
}

// DiscoveryClientId sets the optional parameter "discoveryClientId": Required.
// User specified ID for the discovery client. It will become the last
// component of the discovery client name. The ID must be unique within the
// project, is restricted to lower-cased letters and has a maximum length of 63
// characters. The ID must match the regular expression:
// `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`.
func (c *ProjectsLocationsDiscoveryClientsCreateCall) DiscoveryClientId(discoveryClientId string) *ProjectsLocationsDiscoveryClientsCreateCall {
	c.urlParams_.Set("discoveryClientId", discoveryClientId)
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes since
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsDiscoveryClientsCreateCall) RequestId(requestId string) *ProjectsLocationsDiscoveryClientsCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDiscoveryClientsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsDiscoveryClientsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDiscoveryClientsCreateCall) Context(ctx context.Context) *ProjectsLocationsDiscoveryClientsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDiscoveryClientsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDiscoveryClientsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.discoveryclient)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/discoveryClients")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.discoveryClients.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "migrationcenter.projects.locations.discoveryClients.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDiscoveryClientsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.discoveryClients.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDiscoveryClientsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a discovery client.
//
// - name: The discovery client name.
func (r *ProjectsLocationsDiscoveryClientsService) Delete(name string) *ProjectsLocationsDiscoveryClientsDeleteCall {
	c := &ProjectsLocationsDiscoveryClientsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes after
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsDiscoveryClientsDeleteCall) RequestId(requestId string) *ProjectsLocationsDiscoveryClientsDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDiscoveryClientsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsDiscoveryClientsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDiscoveryClientsDeleteCall) Context(ctx context.Context) *ProjectsLocationsDiscoveryClientsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDiscoveryClientsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDiscoveryClientsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.discoveryClients.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "migrationcenter.projects.locations.discoveryClients.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDiscoveryClientsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.discoveryClients.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDiscoveryClientsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the details of a discovery client.
//
// - name: The discovery client name.
func (r *ProjectsLocationsDiscoveryClientsService) Get(name string) *ProjectsLocationsDiscoveryClientsGetCall {
	c := &ProjectsLocationsDiscoveryClientsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDiscoveryClientsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsDiscoveryClientsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDiscoveryClientsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsDiscoveryClientsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDiscoveryClientsGetCall) Context(ctx context.Context) *ProjectsLocationsDiscoveryClientsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDiscoveryClientsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDiscoveryClientsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.discoveryClients.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "migrationcenter.projects.locations.discoveryClients.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *DiscoveryClient.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsDiscoveryClientsGetCall) Do(opts ...googleapi.CallOption) (*DiscoveryClient, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &DiscoveryClient{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.discoveryClients.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDiscoveryClientsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all the discovery clients in a given project and location.
//
// - parent: Parent resource.
func (r *ProjectsLocationsDiscoveryClientsService) List(parent string) *ProjectsLocationsDiscoveryClientsListCall {
	c := &ProjectsLocationsDiscoveryClientsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filter expression to filter
// results by.
func (c *ProjectsLocationsDiscoveryClientsListCall) Filter(filter string) *ProjectsLocationsDiscoveryClientsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Field to sort by.
func (c *ProjectsLocationsDiscoveryClientsListCall) OrderBy(orderBy string) *ProjectsLocationsDiscoveryClientsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of items
// to return. The server may return fewer items than requested. If unspecified,
// the server will pick an appropriate default value.
func (c *ProjectsLocationsDiscoveryClientsListCall) PageSize(pageSize int64) *ProjectsLocationsDiscoveryClientsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListDiscoveryClients` call. Provide this to retrieve the
// subsequent page. When paginating, all other parameters provided to
// `ListDiscoveryClients` must match the call that provided the page token.
func (c *ProjectsLocationsDiscoveryClientsListCall) PageToken(pageToken string) *ProjectsLocationsDiscoveryClientsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDiscoveryClientsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsDiscoveryClientsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDiscoveryClientsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsDiscoveryClientsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDiscoveryClientsListCall) Context(ctx context.Context) *ProjectsLocationsDiscoveryClientsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDiscoveryClientsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDiscoveryClientsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/discoveryClients")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.discoveryClients.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "migrationcenter.projects.locations.discoveryClients.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListDiscoveryClientsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDiscoveryClientsListCall) Do(opts ...googleapi.CallOption) (*ListDiscoveryClientsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListDiscoveryClientsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.discoveryClients.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsDiscoveryClientsListCall) Pages(ctx context.Context, f func(*ListDiscoveryClientsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsDiscoveryClientsPatchCall struct {
	s               *Service
	name            string
	discoveryclient *DiscoveryClient
	urlParams_      gensupport.URLParams
	ctx_            context.Context
	header_         http.Header
}

// Patch: Updates a discovery client.
//
// - name: Output only. Identifier. Full name of this discovery client.
func (r *ProjectsLocationsDiscoveryClientsService) Patch(name string, discoveryclient *DiscoveryClient) *ProjectsLocationsDiscoveryClientsPatchCall {
	c := &ProjectsLocationsDiscoveryClientsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.discoveryclient = discoveryclient
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes since
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsDiscoveryClientsPatchCall) RequestId(requestId string) *ProjectsLocationsDiscoveryClientsPatchCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Update mask
// is used to specify the fields to be overwritten in the `DiscoveryClient`
// resource by the update. The values specified in the `update_mask` field are
// relative to the resource, not the full request. A field will be overwritten
// if it is in the mask. A single * value in the mask lets you to overwrite all
// fields.
func (c *ProjectsLocationsDiscoveryClientsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsDiscoveryClientsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDiscoveryClientsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsDiscoveryClientsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDiscoveryClientsPatchCall) Context(ctx context.Context) *ProjectsLocationsDiscoveryClientsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDiscoveryClientsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDiscoveryClientsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.discoveryclient)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.discoveryClients.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "migrationcenter.projects.locations.discoveryClients.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDiscoveryClientsPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.discoveryClients.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDiscoveryClientsSendHeartbeatCall struct {
	s                                   *Service
	name                                string
	senddiscoveryclientheartbeatrequest *SendDiscoveryClientHeartbeatRequest
	urlParams_                          gensupport.URLParams
	ctx_                                context.Context
	header_                             http.Header
}

// SendHeartbeat: Sends a discovery client heartbeat. Healthy clients are
// expected to send heartbeats regularly (normally every few minutes).
//
// - name: The discovery client name.
func (r *ProjectsLocationsDiscoveryClientsService) SendHeartbeat(name string, senddiscoveryclientheartbeatrequest *SendDiscoveryClientHeartbeatRequest) *ProjectsLocationsDiscoveryClientsSendHeartbeatCall {
	c := &ProjectsLocationsDiscoveryClientsSendHeartbeatCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.senddiscoveryclientheartbeatrequest = senddiscoveryclientheartbeatrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDiscoveryClientsSendHeartbeatCall) Fields(s ...googleapi.Field) *ProjectsLocationsDiscoveryClientsSendHeartbeatCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDiscoveryClientsSendHeartbeatCall) Context(ctx context.Context) *ProjectsLocationsDiscoveryClientsSendHeartbeatCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDiscoveryClientsSendHeartbeatCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDiscoveryClientsSendHeartbeatCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.senddiscoveryclientheartbeatrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:sendHeartbeat")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.discoveryClients.sendHeartbeat", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "migrationcenter.projects.locations.discoveryClients.sendHeartbeat" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDiscoveryClientsSendHeartbeatCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.discoveryClients.sendHeartbeat", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsGroupsAddAssetsCall struct {
	s                       *Service
	group                   string
	addassetstogrouprequest *AddAssetsToGroupRequest
	urlParams_              gensupport.URLParams
	ctx_                    context.Context
	header_                 http.Header
}

// AddAssets: Adds assets to a group.
//
// - group: Group reference.
func (r *ProjectsLocationsGroupsService) AddAssets(group string, addassetstogrouprequest *AddAssetsToGroupRequest) *ProjectsLocationsGroupsAddAssetsCall {
	c := &ProjectsLocationsGroupsAddAssetsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.group = group
	c.addassetstogrouprequest = addassetstogrouprequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGroupsAddAssetsCall) Fields(s ...googleapi.Field) *ProjectsLocationsGroupsAddAssetsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGroupsAddAssetsCall) Context(ctx context.Context) *ProjectsLocationsGroupsAddAssetsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGroupsAddAssetsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGroupsAddAssetsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.addassetstogrouprequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+group}:addAssets")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"group": c.group,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.groups.addAssets", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "migrationcenter.projects.locations.groups.addAssets" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsGroupsAddAssetsCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.groups.addAssets", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsGroupsCreateCall struct {
	s          *Service
	parent     string
	group      *Group
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a new group in a given project and location.
//
// - parent: Value for parent.
func (r *ProjectsLocationsGroupsService) Create(parent string, group *Group) *ProjectsLocationsGroupsCreateCall {
	c := &ProjectsLocationsGroupsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.group = group
	return c
}

// GroupId sets the optional parameter "groupId": Required. User specified ID
// for the group. It will become the last component of the group name. The ID
// must be unique within the project, must conform with RFC-1034, is restricted
// to lower-cased letters, and has a maximum length of 63 characters. The ID
// must match the regular expression: `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`.
func (c *ProjectsLocationsGroupsCreateCall) GroupId(groupId string) *ProjectsLocationsGroupsCreateCall {
	c.urlParams_.Set("groupId", groupId)
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes since
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsGroupsCreateCall) RequestId(requestId string) *ProjectsLocationsGroupsCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGroupsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsGroupsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGroupsCreateCall) Context(ctx context.Context) *ProjectsLocationsGroupsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGroupsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGroupsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.group)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/groups")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.groups.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "migrationcenter.projects.locations.groups.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsGroupsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.groups.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsGroupsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a group.
//
// - name: Name of the group resource.
func (r *ProjectsLocationsGroupsService) Delete(name string) *ProjectsLocationsGroupsDeleteCall {
	c := &ProjectsLocationsGroupsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes after
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsGroupsDeleteCall) RequestId(requestId string) *ProjectsLocationsGroupsDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGroupsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsGroupsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGroupsDeleteCall) Context(ctx context.Context) *ProjectsLocationsGroupsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGroupsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGroupsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.groups.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "migrationcenter.projects.locations.groups.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsGroupsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.groups.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsGroupsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the details of a group.
//
// - name: Name of the resource.
func (r *ProjectsLocationsGroupsService) Get(name string) *ProjectsLocationsGroupsGetCall {
	c := &ProjectsLocationsGroupsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGroupsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsGroupsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsGroupsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsGroupsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGroupsGetCall) Context(ctx context.Context) *ProjectsLocationsGroupsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGroupsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGroupsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.groups.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "migrationcenter.projects.locations.groups.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Group.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsGroupsGetCall) Do(opts ...googleapi.CallOption) (*Group, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Group{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.groups.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsGroupsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all groups in a given project and location.
//
// - parent: Parent value for `ListGroupsRequest`.
func (r *ProjectsLocationsGroupsService) List(parent string) *ProjectsLocationsGroupsListCall {
	c := &ProjectsLocationsGroupsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filtering results.
func (c *ProjectsLocationsGroupsListCall) Filter(filter string) *ProjectsLocationsGroupsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Field to sort by. See
// https://google.aip.dev/132#ordering for more details.
func (c *ProjectsLocationsGroupsListCall) OrderBy(orderBy string) *ProjectsLocationsGroupsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. Server
// may return fewer items than requested. If unspecified, server will pick an
// appropriate default.
func (c *ProjectsLocationsGroupsListCall) PageSize(pageSize int64) *ProjectsLocationsGroupsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results the server should return.
func (c *ProjectsLocationsGroupsListCall) PageToken(pageToken string) *ProjectsLocationsGroupsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGroupsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsGroupsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsGroupsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsGroupsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGroupsListCall) Context(ctx context.Context) *ProjectsLocationsGroupsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGroupsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGroupsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/groups")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.groups.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "migrationcenter.projects.locations.groups.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListGroupsResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsGroupsListCall) Do(opts ...googleapi.CallOption) (*ListGroupsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListGroupsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.groups.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsGroupsListCall) Pages(ctx context.Context, f func(*ListGroupsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsGroupsPatchCall struct {
	s          *Service
	name       string
	group      *Group
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates the parameters of a group.
//
// - name: Output only. The name of the group.
func (r *ProjectsLocationsGroupsService) Patch(name string, group *Group) *ProjectsLocationsGroupsPatchCall {
	c := &ProjectsLocationsGroupsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.group = group
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes since
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsGroupsPatchCall) RequestId(requestId string) *ProjectsLocationsGroupsPatchCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Field mask is
// used to specify the fields to be overwritten in the `Group` resource by the
// update. The values specified in the `update_mask` are relative to the
// resource, not the full request. A field will be overwritten if it is in the
// mask. A single * value in the mask lets you to overwrite all fields.
func (c *ProjectsLocationsGroupsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsGroupsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGroupsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsGroupsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGroupsPatchCall) Context(ctx context.Context) *ProjectsLocationsGroupsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGroupsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGroupsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.group)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.groups.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "migrationcenter.projects.locations.groups.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsGroupsPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.groups.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsGroupsRemoveAssetsCall struct {
	s                            *Service
	group                        string
	removeassetsfromgrouprequest *RemoveAssetsFromGroupRequest
	urlParams_                   gensupport.URLParams
	ctx_                         context.Context
	header_                      http.Header
}

// RemoveAssets: Removes assets from a group.
//
// - group: Group reference.
func (r *ProjectsLocationsGroupsService) RemoveAssets(group string, removeassetsfromgrouprequest *RemoveAssetsFromGroupRequest) *ProjectsLocationsGroupsRemoveAssetsCall {
	c := &ProjectsLocationsGroupsRemoveAssetsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.group = group
	c.removeassetsfromgrouprequest = removeassetsfromgrouprequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGroupsRemoveAssetsCall) Fields(s ...googleapi.Field) *ProjectsLocationsGroupsRemoveAssetsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGroupsRemoveAssetsCall) Context(ctx context.Context) *ProjectsLocationsGroupsRemoveAssetsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGroupsRemoveAssetsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGroupsRemoveAssetsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.removeassetsfromgrouprequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+group}:removeAssets")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"group": c.group,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.groups.removeAssets", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "migrationcenter.projects.locations.groups.removeAssets" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsGroupsRemoveAssetsCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.groups.removeAssets", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsImportJobsCreateCall struct {
	s          *Service
	parent     string
	importjob  *ImportJob
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates an import job.
//
// - parent: Value for parent.
func (r *ProjectsLocationsImportJobsService) Create(parent string, importjob *ImportJob) *ProjectsLocationsImportJobsCreateCall {
	c := &ProjectsLocationsImportJobsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.importjob = importjob
	return c
}

// ImportJobId sets the optional parameter "importJobId": Required. ID of the
// import job.
func (c *ProjectsLocationsImportJobsCreateCall) ImportJobId(importJobId string) *ProjectsLocationsImportJobsCreateCall {
	c.urlParams_.Set("importJobId", importJobId)
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes since
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsImportJobsCreateCall) RequestId(requestId string) *ProjectsLocationsImportJobsCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsImportJobsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsImportJobsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsImportJobsCreateCall) Context(ctx context.Context) *ProjectsLocationsImportJobsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsImportJobsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsImportJobsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.importjob)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/importJobs")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.importJobs.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "migrationcenter.projects.locations.importJobs.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsImportJobsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.importJobs.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsImportJobsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an import job.
//
// - name: Name of the resource.
func (r *ProjectsLocationsImportJobsService) Delete(name string) *ProjectsLocationsImportJobsDeleteCall {
	c := &ProjectsLocationsImportJobsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Force sets the optional parameter "force": If set to `true`, any
// `ImportDataFiles` of this job will also be deleted If set to `false`, the
// request only works if the job has no data files.
func (c *ProjectsLocationsImportJobsDeleteCall) Force(force bool) *ProjectsLocationsImportJobsDeleteCall {
	c.urlParams_.Set("force", fmt.Sprint(force))
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes after
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsImportJobsDeleteCall) RequestId(requestId string) *ProjectsLocationsImportJobsDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsImportJobsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsImportJobsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsImportJobsDeleteCall) Context(ctx context.Context) *ProjectsLocationsImportJobsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsImportJobsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsImportJobsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.importJobs.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "migrationcenter.projects.locations.importJobs.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsImportJobsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.importJobs.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsImportJobsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the details of an import job.
//
// - name: Name of the resource.
func (r *ProjectsLocationsImportJobsService) Get(name string) *ProjectsLocationsImportJobsGetCall {
	c := &ProjectsLocationsImportJobsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// View sets the optional parameter "view": The level of details of the import
// job. Default value is FULL.
//
// Possible values:
//
//	"IMPORT_JOB_VIEW_UNSPECIFIED" - The import job view is not specified. The
//
// API displays the basic view by default.
//
//	"IMPORT_JOB_VIEW_BASIC" - The import job view includes basic metadata of
//
// an import job. This view does not include payload information.
//
//	"IMPORT_JOB_VIEW_FULL" - The import job view includes all metadata of an
//
// import job.
func (c *ProjectsLocationsImportJobsGetCall) View(view string) *ProjectsLocationsImportJobsGetCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsImportJobsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsImportJobsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsImportJobsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsImportJobsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsImportJobsGetCall) Context(ctx context.Context) *ProjectsLocationsImportJobsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsImportJobsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsImportJobsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.importJobs.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "migrationcenter.projects.locations.importJobs.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *ImportJob.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsImportJobsGetCall) Do(opts ...googleapi.CallOption) (*ImportJob, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ImportJob{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.importJobs.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsImportJobsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all import jobs.
//
// - parent: Parent value for `ListImportJobsRequest`.
func (r *ProjectsLocationsImportJobsService) List(parent string) *ProjectsLocationsImportJobsListCall {
	c := &ProjectsLocationsImportJobsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filtering results.
func (c *ProjectsLocationsImportJobsListCall) Filter(filter string) *ProjectsLocationsImportJobsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Field to sort by. See
// https://google.aip.dev/132#ordering for more details.
func (c *ProjectsLocationsImportJobsListCall) OrderBy(orderBy string) *ProjectsLocationsImportJobsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. Server
// may return fewer items than requested. If unspecified, server will pick an
// appropriate default.
func (c *ProjectsLocationsImportJobsListCall) PageSize(pageSize int64) *ProjectsLocationsImportJobsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results the server should return.
func (c *ProjectsLocationsImportJobsListCall) PageToken(pageToken string) *ProjectsLocationsImportJobsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// View sets the optional parameter "view": The level of details of each import
// job. Default value is BASIC.
//
// Possible values:
//
//	"IMPORT_JOB_VIEW_UNSPECIFIED" - The import job view is not specified. The
//
// API displays the basic view by default.
//
//	"IMPORT_JOB_VIEW_BASIC" - The import job view includes basic metadata of
//
// an import job. This view does not include payload information.
//
//	"IMPORT_JOB_VIEW_FULL" - The import job view includes all metadata of an
//
// import job.
func (c *ProjectsLocationsImportJobsListCall) View(view string) *ProjectsLocationsImportJobsListCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsImportJobsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsImportJobsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsImportJobsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsImportJobsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsImportJobsListCall) Context(ctx context.Context) *ProjectsLocationsImportJobsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsImportJobsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsImportJobsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/importJobs")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.importJobs.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "migrationcenter.projects.locations.importJobs.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListImportJobsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsImportJobsListCall) Do(opts ...googleapi.CallOption) (*ListImportJobsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListImportJobsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.importJobs.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsImportJobsListCall) Pages(ctx context.Context, f func(*ListImportJobsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsImportJobsPatchCall struct {
	s          *Service
	name       string
	importjob  *ImportJob
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates an import job.
//
// - name: Output only. The full name of the import job.
func (r *ProjectsLocationsImportJobsService) Patch(name string, importjob *ImportJob) *ProjectsLocationsImportJobsPatchCall {
	c := &ProjectsLocationsImportJobsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.importjob = importjob
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes since
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsImportJobsPatchCall) RequestId(requestId string) *ProjectsLocationsImportJobsPatchCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Field mask is
// used to specify the fields to be overwritten in the `Asset` resource by the
// update. The values specified in the `update_mask` field are relative to the
// resource, not the full request. A field will be overwritten if it is in the
// mask. A single * value in the mask lets you to overwrite all fields.
func (c *ProjectsLocationsImportJobsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsImportJobsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsImportJobsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsImportJobsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsImportJobsPatchCall) Context(ctx context.Context) *ProjectsLocationsImportJobsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsImportJobsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsImportJobsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.importjob)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.importJobs.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "migrationcenter.projects.locations.importJobs.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsImportJobsPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.importJobs.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsImportJobsRunCall struct {
	s                   *Service
	name                string
	runimportjobrequest *RunImportJobRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// Run: Runs an import job.
//
// - name: The name of the import job to run.
func (r *ProjectsLocationsImportJobsService) Run(name string, runimportjobrequest *RunImportJobRequest) *ProjectsLocationsImportJobsRunCall {
	c := &ProjectsLocationsImportJobsRunCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.runimportjobrequest = runimportjobrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsImportJobsRunCall) Fields(s ...googleapi.Field) *ProjectsLocationsImportJobsRunCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsImportJobsRunCall) Context(ctx context.Context) *ProjectsLocationsImportJobsRunCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsImportJobsRunCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsImportJobsRunCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.runimportjobrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:run")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.importJobs.run", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "migrationcenter.projects.locations.importJobs.run" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsImportJobsRunCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.importJobs.run", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsImportJobsValidateCall struct {
	s                        *Service
	name                     string
	validateimportjobrequest *ValidateImportJobRequest
	urlParams_               gensupport.URLParams
	ctx_                     context.Context
	header_                  http.Header
}

// Validate: Validates an import job.
//
// - name: The name of the import job to validate.
func (r *ProjectsLocationsImportJobsService) Validate(name string, validateimportjobrequest *ValidateImportJobRequest) *ProjectsLocationsImportJobsValidateCall {
	c := &ProjectsLocationsImportJobsValidateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.validateimportjobrequest = validateimportjobrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsImportJobsValidateCall) Fields(s ...googleapi.Field) *ProjectsLocationsImportJobsValidateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsImportJobsValidateCall) Context(ctx context.Context) *ProjectsLocationsImportJobsValidateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsImportJobsValidateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsImportJobsValidateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.validateimportjobrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:validate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.importJobs.validate", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "migrationcenter.projects.locations.importJobs.validate" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsImportJobsValidateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.importJobs.validate", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsImportJobsImportDataFilesCreateCall struct {
	s              *Service
	parent         string
	importdatafile *ImportDataFile
	urlParams_     gensupport.URLParams
	ctx_           context.Context
	header_        http.Header
}

// Create: Creates an import data file.
//
// - parent: Name of the parent of the ImportDataFile.
func (r *ProjectsLocationsImportJobsImportDataFilesService) Create(parent string, importdatafile *ImportDataFile) *ProjectsLocationsImportJobsImportDataFilesCreateCall {
	c := &ProjectsLocationsImportJobsImportDataFilesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.importdatafile = importdatafile
	return c
}

// ImportDataFileId sets the optional parameter "importDataFileId": Required.
// The ID of the new data file.
func (c *ProjectsLocationsImportJobsImportDataFilesCreateCall) ImportDataFileId(importDataFileId string) *ProjectsLocationsImportJobsImportDataFilesCreateCall {
	c.urlParams_.Set("importDataFileId", importDataFileId)
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes since
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsImportJobsImportDataFilesCreateCall) RequestId(requestId string) *ProjectsLocationsImportJobsImportDataFilesCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsImportJobsImportDataFilesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsImportJobsImportDataFilesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsImportJobsImportDataFilesCreateCall) Context(ctx context.Context) *ProjectsLocationsImportJobsImportDataFilesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsImportJobsImportDataFilesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsImportJobsImportDataFilesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.importdatafile)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/importDataFiles")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.importJobs.importDataFiles.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "migrationcenter.projects.locations.importJobs.importDataFiles.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsImportJobsImportDataFilesCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.importJobs.importDataFiles.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsImportJobsImportDataFilesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Delete an import data file.
//
// - name: Name of the ImportDataFile to delete.
func (r *ProjectsLocationsImportJobsImportDataFilesService) Delete(name string) *ProjectsLocationsImportJobsImportDataFilesDeleteCall {
	c := &ProjectsLocationsImportJobsImportDataFilesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes after
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsImportJobsImportDataFilesDeleteCall) RequestId(requestId string) *ProjectsLocationsImportJobsImportDataFilesDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsImportJobsImportDataFilesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsImportJobsImportDataFilesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsImportJobsImportDataFilesDeleteCall) Context(ctx context.Context) *ProjectsLocationsImportJobsImportDataFilesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsImportJobsImportDataFilesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsImportJobsImportDataFilesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.importJobs.importDataFiles.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "migrationcenter.projects.locations.importJobs.importDataFiles.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsImportJobsImportDataFilesDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.importJobs.importDataFiles.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsImportJobsImportDataFilesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets an import data file.
//
// - name: Name of the ImportDataFile.
func (r *ProjectsLocationsImportJobsImportDataFilesService) Get(name string) *ProjectsLocationsImportJobsImportDataFilesGetCall {
	c := &ProjectsLocationsImportJobsImportDataFilesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsImportJobsImportDataFilesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsImportJobsImportDataFilesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsImportJobsImportDataFilesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsImportJobsImportDataFilesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsImportJobsImportDataFilesGetCall) Context(ctx context.Context) *ProjectsLocationsImportJobsImportDataFilesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsImportJobsImportDataFilesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsImportJobsImportDataFilesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.importJobs.importDataFiles.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "migrationcenter.projects.locations.importJobs.importDataFiles.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *ImportDataFile.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsImportJobsImportDataFilesGetCall) Do(opts ...googleapi.CallOption) (*ImportDataFile, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ImportDataFile{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.importJobs.importDataFiles.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsImportJobsImportDataFilesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List import data files.
//
// - parent: Name of the parent of the `ImportDataFiles` resource.
func (r *ProjectsLocationsImportJobsImportDataFilesService) List(parent string) *ProjectsLocationsImportJobsImportDataFilesListCall {
	c := &ProjectsLocationsImportJobsImportDataFilesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filtering results.
func (c *ProjectsLocationsImportJobsImportDataFilesListCall) Filter(filter string) *ProjectsLocationsImportJobsImportDataFilesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Field to sort by. See
// https://google.aip.dev/132#ordering for more details.
func (c *ProjectsLocationsImportJobsImportDataFilesListCall) OrderBy(orderBy string) *ProjectsLocationsImportJobsImportDataFilesListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of data
// files to return. The service may return fewer than this value. If
// unspecified, at most 500 data files will be returned. The maximum value is
// 1000; values above 1000 will be coerced to 1000.
func (c *ProjectsLocationsImportJobsImportDataFilesListCall) PageSize(pageSize int64) *ProjectsLocationsImportJobsImportDataFilesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListImportDataFiles` call. Provide this to retrieve the
// subsequent page. When paginating, all other parameters provided to
// `ListImportDataFiles` must match the call that provided the page token.
func (c *ProjectsLocationsImportJobsImportDataFilesListCall) PageToken(pageToken string) *ProjectsLocationsImportJobsImportDataFilesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsImportJobsImportDataFilesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsImportJobsImportDataFilesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsImportJobsImportDataFilesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsImportJobsImportDataFilesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsImportJobsImportDataFilesListCall) Context(ctx context.Context) *ProjectsLocationsImportJobsImportDataFilesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsImportJobsImportDataFilesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsImportJobsImportDataFilesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/importDataFiles")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.importJobs.importDataFiles.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "migrationcenter.projects.locations.importJobs.importDataFiles.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListImportDataFilesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsImportJobsImportDataFilesListCall) Do(opts ...googleapi.CallOption) (*ListImportDataFilesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListImportDataFilesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.importJobs.importDataFiles.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsImportJobsImportDataFilesListCall) Pages(ctx context.Context, f func(*ListImportDataFilesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsOperationsCancelCall struct {
	s                      *Service
	name                   string
	canceloperationrequest *CancelOperationRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// Cancel: Starts asynchronous cancellation on a long-running operation. The
// server makes a best effort to cancel the operation, but success is not
// guaranteed. If the server doesn't support this method, it returns
// `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or
// other methods to check whether the cancellation succeeded or whether the
// operation completed despite cancellation. On successful cancellation, the
// operation is not deleted; instead, it becomes an operation with an
// Operation.error value with a google.rpc.Status.code of `1`, corresponding to
// `Code.CANCELLED`.
//
// - name: The name of the operation resource to be cancelled.
func (r *ProjectsLocationsOperationsService) Cancel(name string, canceloperationrequest *CancelOperationRequest) *ProjectsLocationsOperationsCancelCall {
	c := &ProjectsLocationsOperationsCancelCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.canceloperationrequest = canceloperationrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsCancelCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsCancelCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsCancelCall) Context(ctx context.Context) *ProjectsLocationsOperationsCancelCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsCancelCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsCancelCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.canceloperationrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:cancel")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.operations.cancel", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "migrationcenter.projects.locations.operations.cancel" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsCancelCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.operations.cancel", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOperationsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a long-running operation. This method indicates that the
// client is no longer interested in the operation result. It does not cancel
// the operation. If the server doesn't support this method, it returns
// `google.rpc.Code.UNIMPLEMENTED`.
//
// - name: The name of the operation resource to be deleted.
func (r *ProjectsLocationsOperationsService) Delete(name string) *ProjectsLocationsOperationsDeleteCall {
	c := &ProjectsLocationsOperationsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsDeleteCall) Context(ctx context.Context) *ProjectsLocationsOperationsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.operations.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "migrationcenter.projects.locations.operations.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.operations.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can use this
// method to poll the operation result at intervals as recommended by the API
// service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsOperationsService) Get(name string) *ProjectsLocationsOperationsGetCall {
	c := &ProjectsLocationsOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.operations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "migrationcenter.projects.locations.operations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsGetCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.operations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the request. If
// the server doesn't support this method, it returns `UNIMPLEMENTED`.
//
// - name: The name of the operation's parent resource.
func (r *ProjectsLocationsOperationsService) List(name string) *ProjectsLocationsOperationsListCall {
	c := &ProjectsLocationsOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list filter.
func (c *ProjectsLocationsOperationsListCall) Filter(filter string) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list page
// size.
func (c *ProjectsLocationsOperationsListCall) PageSize(pageSize int64) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list page
// token.
func (c *ProjectsLocationsOperationsListCall) PageToken(pageToken string) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReturnPartialSuccess sets the optional parameter "returnPartialSuccess":
// When set to `true`, operations that are reachable are returned as normal,
// and those that are unreachable are returned in the
// [ListOperationsResponse.unreachable] field. This can only be `true` when
// reading across collections e.g. when `parent` is set to
// "projects/example/locations/-". This field is not by default supported and
// will result in an `UNIMPLEMENTED` error if set unless explicitly documented
// otherwise in service or product specific documentation.
func (c *ProjectsLocationsOperationsListCall) ReturnPartialSuccess(returnPartialSuccess bool) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("returnPartialSuccess", fmt.Sprint(returnPartialSuccess))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsOperationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsListCall) Context(ctx context.Context) *ProjectsLocationsOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.operations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "migrationcenter.projects.locations.operations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListOperationsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsOperationsListCall) Do(opts ...googleapi.CallOption) (*ListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.operations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsOperationsListCall) Pages(ctx context.Context, f func(*ListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsPreferenceSetsCreateCall struct {
	s             *Service
	parent        string
	preferenceset *PreferenceSet
	urlParams_    gensupport.URLParams
	ctx_          context.Context
	header_       http.Header
}

// Create: Creates a new preference set in a given project and location.
//
// - parent: Value for parent.
func (r *ProjectsLocationsPreferenceSetsService) Create(parent string, preferenceset *PreferenceSet) *ProjectsLocationsPreferenceSetsCreateCall {
	c := &ProjectsLocationsPreferenceSetsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.preferenceset = preferenceset
	return c
}

// PreferenceSetId sets the optional parameter "preferenceSetId": Required.
// User specified ID for the preference set. It will become the last component
// of the preference set name. The ID must be unique within the project, must
// conform with RFC-1034, is restricted to lower-cased letters, and has a
// maximum length of 63 characters. The ID must match the regular expression
// `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`.
func (c *ProjectsLocationsPreferenceSetsCreateCall) PreferenceSetId(preferenceSetId string) *ProjectsLocationsPreferenceSetsCreateCall {
	c.urlParams_.Set("preferenceSetId", preferenceSetId)
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes since
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsPreferenceSetsCreateCall) RequestId(requestId string) *ProjectsLocationsPreferenceSetsCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsPreferenceSetsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsPreferenceSetsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsPreferenceSetsCreateCall) Context(ctx context.Context) *ProjectsLocationsPreferenceSetsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsPreferenceSetsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPreferenceSetsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.preferenceset)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/preferenceSets")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.preferenceSets.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "migrationcenter.projects.locations.preferenceSets.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsPreferenceSetsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.preferenceSets.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsPreferenceSetsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a preference set.
//
// - name: Name of the group resource.
func (r *ProjectsLocationsPreferenceSetsService) Delete(name string) *ProjectsLocationsPreferenceSetsDeleteCall {
	c := &ProjectsLocationsPreferenceSetsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes after
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsPreferenceSetsDeleteCall) RequestId(requestId string) *ProjectsLocationsPreferenceSetsDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsPreferenceSetsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsPreferenceSetsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsPreferenceSetsDeleteCall) Context(ctx context.Context) *ProjectsLocationsPreferenceSetsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsPreferenceSetsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPreferenceSetsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.preferenceSets.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "migrationcenter.projects.locations.preferenceSets.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsPreferenceSetsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.preferenceSets.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsPreferenceSetsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the details of a preference set.
//
// - name: Name of the resource.
func (r *ProjectsLocationsPreferenceSetsService) Get(name string) *ProjectsLocationsPreferenceSetsGetCall {
	c := &ProjectsLocationsPreferenceSetsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsPreferenceSetsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsPreferenceSetsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsPreferenceSetsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsPreferenceSetsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsPreferenceSetsGetCall) Context(ctx context.Context) *ProjectsLocationsPreferenceSetsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsPreferenceSetsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPreferenceSetsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.preferenceSets.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "migrationcenter.projects.locations.preferenceSets.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *PreferenceSet.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsPreferenceSetsGetCall) Do(opts ...googleapi.CallOption) (*PreferenceSet, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &PreferenceSet{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.preferenceSets.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsPreferenceSetsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all the preference sets in a given project and location.
//
// - parent: Parent value for `ListPreferenceSetsRequest`.
func (r *ProjectsLocationsPreferenceSetsService) List(parent string) *ProjectsLocationsPreferenceSetsListCall {
	c := &ProjectsLocationsPreferenceSetsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// OrderBy sets the optional parameter "orderBy": Field to sort by. See
// https://google.aip.dev/132#ordering for more details.
func (c *ProjectsLocationsPreferenceSetsListCall) OrderBy(orderBy string) *ProjectsLocationsPreferenceSetsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. Server
// may return fewer items than requested. If unspecified, at most 500
// preference sets will be returned. The maximum value is 1000; values above
// 1000 will be coerced to 1000.
func (c *ProjectsLocationsPreferenceSetsListCall) PageSize(pageSize int64) *ProjectsLocationsPreferenceSetsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results the server should return.
func (c *ProjectsLocationsPreferenceSetsListCall) PageToken(pageToken string) *ProjectsLocationsPreferenceSetsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsPreferenceSetsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsPreferenceSetsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsPreferenceSetsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsPreferenceSetsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsPreferenceSetsListCall) Context(ctx context.Context) *ProjectsLocationsPreferenceSetsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsPreferenceSetsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPreferenceSetsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/preferenceSets")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.preferenceSets.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "migrationcenter.projects.locations.preferenceSets.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListPreferenceSetsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsPreferenceSetsListCall) Do(opts ...googleapi.CallOption) (*ListPreferenceSetsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListPreferenceSetsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.preferenceSets.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsPreferenceSetsListCall) Pages(ctx context.Context, f func(*ListPreferenceSetsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsPreferenceSetsPatchCall struct {
	s             *Service
	name          string
	preferenceset *PreferenceSet
	urlParams_    gensupport.URLParams
	ctx_          context.Context
	header_       http.Header
}

// Patch: Updates the parameters of a preference set.
//
// - name: Output only. Name of the preference set.
func (r *ProjectsLocationsPreferenceSetsService) Patch(name string, preferenceset *PreferenceSet) *ProjectsLocationsPreferenceSetsPatchCall {
	c := &ProjectsLocationsPreferenceSetsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.preferenceset = preferenceset
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes since
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsPreferenceSetsPatchCall) RequestId(requestId string) *ProjectsLocationsPreferenceSetsPatchCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Field mask is
// used to specify the fields to be overwritten in the `PreferenceSet` resource
// by the update. The values specified in the `update_mask` field are relative
// to the resource, not the full request. A field will be overwritten if it is
// in the mask. A single * value in the mask lets you to overwrite all fields.
func (c *ProjectsLocationsPreferenceSetsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsPreferenceSetsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsPreferenceSetsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsPreferenceSetsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsPreferenceSetsPatchCall) Context(ctx context.Context) *ProjectsLocationsPreferenceSetsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsPreferenceSetsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPreferenceSetsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.preferenceset)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.preferenceSets.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "migrationcenter.projects.locations.preferenceSets.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsPreferenceSetsPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.preferenceSets.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsRelationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the details of an relation.
//
// - name: Name of the resource.
func (r *ProjectsLocationsRelationsService) Get(name string) *ProjectsLocationsRelationsGetCall {
	c := &ProjectsLocationsRelationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRelationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsRelationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsRelationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsRelationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRelationsGetCall) Context(ctx context.Context) *ProjectsLocationsRelationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRelationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRelationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.relations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "migrationcenter.projects.locations.relations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Relation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsRelationsGetCall) Do(opts ...googleapi.CallOption) (*Relation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Relation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.relations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsRelationsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all the relations in a given project and location.
//
// - parent: Parent value for `ListRelationsRequest`.
func (r *ProjectsLocationsRelationsService) List(parent string) *ProjectsLocationsRelationsListCall {
	c := &ProjectsLocationsRelationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filtering results.
func (c *ProjectsLocationsRelationsListCall) Filter(filter string) *ProjectsLocationsRelationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Field to sort by. See
// https://google.aip.dev/132#ordering for more details.
func (c *ProjectsLocationsRelationsListCall) OrderBy(orderBy string) *ProjectsLocationsRelationsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. Server
// may return fewer items than requested. If unspecified, server will pick an
// appropriate default.
func (c *ProjectsLocationsRelationsListCall) PageSize(pageSize int64) *ProjectsLocationsRelationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results the server should return.
func (c *ProjectsLocationsRelationsListCall) PageToken(pageToken string) *ProjectsLocationsRelationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRelationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsRelationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsRelationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsRelationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRelationsListCall) Context(ctx context.Context) *ProjectsLocationsRelationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRelationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRelationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/relations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.relations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "migrationcenter.projects.locations.relations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListRelationsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsRelationsListCall) Do(opts ...googleapi.CallOption) (*ListRelationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListRelationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.relations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsRelationsListCall) Pages(ctx context.Context, f func(*ListRelationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsReportConfigsCreateCall struct {
	s            *Service
	parent       string
	reportconfig *ReportConfig
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Create: Creates a report configuration.
//
// - parent: Value for parent.
func (r *ProjectsLocationsReportConfigsService) Create(parent string, reportconfig *ReportConfig) *ProjectsLocationsReportConfigsCreateCall {
	c := &ProjectsLocationsReportConfigsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.reportconfig = reportconfig
	return c
}

// ReportConfigId sets the optional parameter "reportConfigId": Required. User
// specified ID for the report config. It will become the last component of the
// report config name. The ID must be unique within the project, must conform
// with RFC-1034, is restricted to lower-cased letters, and has a maximum
// length of 63 characters. The ID must match the regular expression: a-z
// ([a-z0-9-]{0,61}[a-z0-9])?.
func (c *ProjectsLocationsReportConfigsCreateCall) ReportConfigId(reportConfigId string) *ProjectsLocationsReportConfigsCreateCall {
	c.urlParams_.Set("reportConfigId", reportConfigId)
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes since
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsReportConfigsCreateCall) RequestId(requestId string) *ProjectsLocationsReportConfigsCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsReportConfigsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsReportConfigsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsReportConfigsCreateCall) Context(ctx context.Context) *ProjectsLocationsReportConfigsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsReportConfigsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsReportConfigsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.reportconfig)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/reportConfigs")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.reportConfigs.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "migrationcenter.projects.locations.reportConfigs.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsReportConfigsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.reportConfigs.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsReportConfigsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a ReportConfig.
//
// - name: Name of the resource.
func (r *ProjectsLocationsReportConfigsService) Delete(name string) *ProjectsLocationsReportConfigsDeleteCall {
	c := &ProjectsLocationsReportConfigsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Force sets the optional parameter "force": If set to `true`, any child
// `Reports` of this entity will also be deleted. If set to `false`, the
// request only works if the resource has no children.
func (c *ProjectsLocationsReportConfigsDeleteCall) Force(force bool) *ProjectsLocationsReportConfigsDeleteCall {
	c.urlParams_.Set("force", fmt.Sprint(force))
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes after
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsReportConfigsDeleteCall) RequestId(requestId string) *ProjectsLocationsReportConfigsDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsReportConfigsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsReportConfigsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsReportConfigsDeleteCall) Context(ctx context.Context) *ProjectsLocationsReportConfigsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsReportConfigsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsReportConfigsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.reportConfigs.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "migrationcenter.projects.locations.reportConfigs.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsReportConfigsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.reportConfigs.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsReportConfigsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of a single ReportConfig.
//
// - name: Name of the resource.
func (r *ProjectsLocationsReportConfigsService) Get(name string) *ProjectsLocationsReportConfigsGetCall {
	c := &ProjectsLocationsReportConfigsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsReportConfigsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsReportConfigsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsReportConfigsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsReportConfigsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsReportConfigsGetCall) Context(ctx context.Context) *ProjectsLocationsReportConfigsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsReportConfigsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsReportConfigsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.reportConfigs.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "migrationcenter.projects.locations.reportConfigs.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *ReportConfig.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsReportConfigsGetCall) Do(opts ...googleapi.CallOption) (*ReportConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ReportConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.reportConfigs.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsReportConfigsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists ReportConfigs in a given project and location.
//
// - parent: Parent value for `ListReportConfigsRequest`.
func (r *ProjectsLocationsReportConfigsService) List(parent string) *ProjectsLocationsReportConfigsListCall {
	c := &ProjectsLocationsReportConfigsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filtering results.
func (c *ProjectsLocationsReportConfigsListCall) Filter(filter string) *ProjectsLocationsReportConfigsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Field to sort by. See
// https://google.aip.dev/132#ordering for more details.
func (c *ProjectsLocationsReportConfigsListCall) OrderBy(orderBy string) *ProjectsLocationsReportConfigsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. Server
// may return fewer items than requested. If unspecified, server will pick an
// appropriate default.
func (c *ProjectsLocationsReportConfigsListCall) PageSize(pageSize int64) *ProjectsLocationsReportConfigsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results the server should return.
func (c *ProjectsLocationsReportConfigsListCall) PageToken(pageToken string) *ProjectsLocationsReportConfigsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsReportConfigsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsReportConfigsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsReportConfigsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsReportConfigsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsReportConfigsListCall) Context(ctx context.Context) *ProjectsLocationsReportConfigsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsReportConfigsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsReportConfigsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/reportConfigs")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.reportConfigs.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "migrationcenter.projects.locations.reportConfigs.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListReportConfigsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsReportConfigsListCall) Do(opts ...googleapi.CallOption) (*ListReportConfigsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListReportConfigsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.reportConfigs.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsReportConfigsListCall) Pages(ctx context.Context, f func(*ListReportConfigsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsReportConfigsReportsArtifactLinkCall struct {
	s                                 *Service
	name                              string
	generatereportartifactlinkrequest *GenerateReportArtifactLinkRequest
	urlParams_                        gensupport.URLParams
	ctx_                              context.Context
	header_                           http.Header
}

// ArtifactLink: Gets the link to the generated artifact of a given type for a
// Report.
//
// - name: Name of the resource.
func (r *ProjectsLocationsReportConfigsReportsService) ArtifactLink(name string, generatereportartifactlinkrequest *GenerateReportArtifactLinkRequest) *ProjectsLocationsReportConfigsReportsArtifactLinkCall {
	c := &ProjectsLocationsReportConfigsReportsArtifactLinkCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.generatereportartifactlinkrequest = generatereportartifactlinkrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsReportConfigsReportsArtifactLinkCall) Fields(s ...googleapi.Field) *ProjectsLocationsReportConfigsReportsArtifactLinkCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsReportConfigsReportsArtifactLinkCall) Context(ctx context.Context) *ProjectsLocationsReportConfigsReportsArtifactLinkCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsReportConfigsReportsArtifactLinkCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsReportConfigsReportsArtifactLinkCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.generatereportartifactlinkrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:artifactLink")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.reportConfigs.reports.artifactLink", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "migrationcenter.projects.locations.reportConfigs.reports.artifactLink" call.
// Any non-2xx status code is an error. Response headers are in either
// *ReportArtifactLink.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsReportConfigsReportsArtifactLinkCall) Do(opts ...googleapi.CallOption) (*ReportArtifactLink, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ReportArtifactLink{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.reportConfigs.reports.artifactLink", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsReportConfigsReportsCreateCall struct {
	s          *Service
	parent     string
	report     *Report
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a report.
//
// - parent: Value for parent.
func (r *ProjectsLocationsReportConfigsReportsService) Create(parent string, report *Report) *ProjectsLocationsReportConfigsReportsCreateCall {
	c := &ProjectsLocationsReportConfigsReportsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.report = report
	return c
}

// ReportId sets the optional parameter "reportId": Required. User specified id
// for the report. It will become the last component of the report name. The id
// must be unique within the project, must conform with RFC-1034, is restricted
// to lower-cased letters, and has a maximum length of 63 characters. The id
// must match the regular expression: a-z ([a-z0-9-]{0,61}[a-z0-9])?.
func (c *ProjectsLocationsReportConfigsReportsCreateCall) ReportId(reportId string) *ProjectsLocationsReportConfigsReportsCreateCall {
	c.urlParams_.Set("reportId", reportId)
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes since
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsReportConfigsReportsCreateCall) RequestId(requestId string) *ProjectsLocationsReportConfigsReportsCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsReportConfigsReportsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsReportConfigsReportsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsReportConfigsReportsCreateCall) Context(ctx context.Context) *ProjectsLocationsReportConfigsReportsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsReportConfigsReportsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsReportConfigsReportsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.report)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/reports")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.reportConfigs.reports.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "migrationcenter.projects.locations.reportConfigs.reports.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsReportConfigsReportsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.reportConfigs.reports.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsReportConfigsReportsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a Report.
//
// - name: Name of the resource.
func (r *ProjectsLocationsReportConfigsReportsService) Delete(name string) *ProjectsLocationsReportConfigsReportsDeleteCall {
	c := &ProjectsLocationsReportConfigsReportsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes after
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsReportConfigsReportsDeleteCall) RequestId(requestId string) *ProjectsLocationsReportConfigsReportsDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsReportConfigsReportsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsReportConfigsReportsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsReportConfigsReportsDeleteCall) Context(ctx context.Context) *ProjectsLocationsReportConfigsReportsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsReportConfigsReportsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsReportConfigsReportsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.reportConfigs.reports.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "migrationcenter.projects.locations.reportConfigs.reports.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsReportConfigsReportsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.reportConfigs.reports.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsReportConfigsReportsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of a single Report.
//
// - name: Name of the resource.
func (r *ProjectsLocationsReportConfigsReportsService) Get(name string) *ProjectsLocationsReportConfigsReportsGetCall {
	c := &ProjectsLocationsReportConfigsReportsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// View sets the optional parameter "view": Determines what information to
// retrieve for the Report.
//
// Possible values:
//
//	"REPORT_VIEW_UNSPECIFIED" - The report view is not specified. The API
//
// displays the basic view by default.
//
//	"REPORT_VIEW_BASIC" - The report view includes only basic metadata of the
//
// Report. Useful for list views.
//
//	"REPORT_VIEW_FULL" - The report view includes all the metadata of the
//
// Report. Useful for preview.
//
//	"REPORT_VIEW_STANDARD" - The report view includes the standard metadata of
//
// an report. Useful for detail view.
func (c *ProjectsLocationsReportConfigsReportsGetCall) View(view string) *ProjectsLocationsReportConfigsReportsGetCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsReportConfigsReportsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsReportConfigsReportsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsReportConfigsReportsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsReportConfigsReportsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsReportConfigsReportsGetCall) Context(ctx context.Context) *ProjectsLocationsReportConfigsReportsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsReportConfigsReportsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsReportConfigsReportsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.reportConfigs.reports.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "migrationcenter.projects.locations.reportConfigs.reports.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Report.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsReportConfigsReportsGetCall) Do(opts ...googleapi.CallOption) (*Report, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Report{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.reportConfigs.reports.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsReportConfigsReportsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists Reports in a given ReportConfig.
//
// - parent: Parent value for `ListReportsRequest`.
func (r *ProjectsLocationsReportConfigsReportsService) List(parent string) *ProjectsLocationsReportConfigsReportsListCall {
	c := &ProjectsLocationsReportConfigsReportsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filtering results.
func (c *ProjectsLocationsReportConfigsReportsListCall) Filter(filter string) *ProjectsLocationsReportConfigsReportsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Field to sort by. See
// https://google.aip.dev/132#ordering for more details.
func (c *ProjectsLocationsReportConfigsReportsListCall) OrderBy(orderBy string) *ProjectsLocationsReportConfigsReportsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. The
// server may return fewer items than requested. If unspecified, the server
// will pick an appropriate default value.
func (c *ProjectsLocationsReportConfigsReportsListCall) PageSize(pageSize int64) *ProjectsLocationsReportConfigsReportsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results that the server should return.
func (c *ProjectsLocationsReportConfigsReportsListCall) PageToken(pageToken string) *ProjectsLocationsReportConfigsReportsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// View sets the optional parameter "view": Determines what information to
// retrieve for each Report.
//
// Possible values:
//
//	"REPORT_VIEW_UNSPECIFIED" - The report view is not specified. The API
//
// displays the basic view by default.
//
//	"REPORT_VIEW_BASIC" - The report view includes only basic metadata of the
//
// Report. Useful for list views.
//
//	"REPORT_VIEW_FULL" - The report view includes all the metadata of the
//
// Report. Useful for preview.
//
//	"REPORT_VIEW_STANDARD" - The report view includes the standard metadata of
//
// an report. Useful for detail view.
func (c *ProjectsLocationsReportConfigsReportsListCall) View(view string) *ProjectsLocationsReportConfigsReportsListCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsReportConfigsReportsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsReportConfigsReportsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsReportConfigsReportsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsReportConfigsReportsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsReportConfigsReportsListCall) Context(ctx context.Context) *ProjectsLocationsReportConfigsReportsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsReportConfigsReportsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsReportConfigsReportsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/reports")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.reportConfigs.reports.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "migrationcenter.projects.locations.reportConfigs.reports.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListReportsResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsReportConfigsReportsListCall) Do(opts ...googleapi.CallOption) (*ListReportsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListReportsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.reportConfigs.reports.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsReportConfigsReportsListCall) Pages(ctx context.Context, f func(*ListReportsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsSourcesCreateCall struct {
	s          *Service
	parent     string
	source     *Source
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a new source in a given project and location.
//
// - parent: Value for parent.
func (r *ProjectsLocationsSourcesService) Create(parent string, source *Source) *ProjectsLocationsSourcesCreateCall {
	c := &ProjectsLocationsSourcesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.source = source
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes since
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsSourcesCreateCall) RequestId(requestId string) *ProjectsLocationsSourcesCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// SourceId sets the optional parameter "sourceId": Required. User specified ID
// for the source. It will become the last component of the source name. The ID
// must be unique within the project, must conform with RFC-1034, is restricted
// to lower-cased letters, and has a maximum length of 63 characters. The ID
// must match the regular expression: `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`.
func (c *ProjectsLocationsSourcesCreateCall) SourceId(sourceId string) *ProjectsLocationsSourcesCreateCall {
	c.urlParams_.Set("sourceId", sourceId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsSourcesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsSourcesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsSourcesCreateCall) Context(ctx context.Context) *ProjectsLocationsSourcesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsSourcesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsSourcesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.source)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/sources")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.sources.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "migrationcenter.projects.locations.sources.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsSourcesCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.sources.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsSourcesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a source.
//
// - name: Name of the resource.
func (r *ProjectsLocationsSourcesService) Delete(name string) *ProjectsLocationsSourcesDeleteCall {
	c := &ProjectsLocationsSourcesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes after
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsSourcesDeleteCall) RequestId(requestId string) *ProjectsLocationsSourcesDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsSourcesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsSourcesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsSourcesDeleteCall) Context(ctx context.Context) *ProjectsLocationsSourcesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsSourcesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsSourcesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.sources.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "migrationcenter.projects.locations.sources.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsSourcesDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.sources.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsSourcesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the details of a source.
//
// - name: Name of the resource.
func (r *ProjectsLocationsSourcesService) Get(name string) *ProjectsLocationsSourcesGetCall {
	c := &ProjectsLocationsSourcesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsSourcesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsSourcesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsSourcesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsSourcesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsSourcesGetCall) Context(ctx context.Context) *ProjectsLocationsSourcesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsSourcesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsSourcesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.sources.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "migrationcenter.projects.locations.sources.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Source.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsSourcesGetCall) Do(opts ...googleapi.CallOption) (*Source, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Source{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.sources.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsSourcesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all the sources in a given project and location.
//
// - parent: Parent value for `ListSourcesRequest`.
func (r *ProjectsLocationsSourcesService) List(parent string) *ProjectsLocationsSourcesListCall {
	c := &ProjectsLocationsSourcesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filtering results.
func (c *ProjectsLocationsSourcesListCall) Filter(filter string) *ProjectsLocationsSourcesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Field to sort by. See
// https://google.aip.dev/132#ordering for more details.
func (c *ProjectsLocationsSourcesListCall) OrderBy(orderBy string) *ProjectsLocationsSourcesListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. The
// server may return fewer items than requested. If unspecified, the server
// will pick an appropriate default value.
func (c *ProjectsLocationsSourcesListCall) PageSize(pageSize int64) *ProjectsLocationsSourcesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results that the server should return.
func (c *ProjectsLocationsSourcesListCall) PageToken(pageToken string) *ProjectsLocationsSourcesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsSourcesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsSourcesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsSourcesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsSourcesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsSourcesListCall) Context(ctx context.Context) *ProjectsLocationsSourcesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsSourcesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsSourcesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/sources")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.sources.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "migrationcenter.projects.locations.sources.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListSourcesResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsSourcesListCall) Do(opts ...googleapi.CallOption) (*ListSourcesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListSourcesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.sources.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsSourcesListCall) Pages(ctx context.Context, f func(*ListSourcesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsSourcesPatchCall struct {
	s          *Service
	name       string
	source     *Source
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates the parameters of a source.
//
// - name: Output only. The full name of the source.
func (r *ProjectsLocationsSourcesService) Patch(name string, source *Source) *ProjectsLocationsSourcesPatchCall {
	c := &ProjectsLocationsSourcesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.source = source
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes since
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsSourcesPatchCall) RequestId(requestId string) *ProjectsLocationsSourcesPatchCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Field mask is
// used to specify the fields to be overwritten in the `Source` resource by the
// update. The values specified in the `update_mask` field are relative to the
// resource, not the full request. A field will be overwritten if it is in the
// mask. A single * value in the mask lets you to overwrite all fields.
func (c *ProjectsLocationsSourcesPatchCall) UpdateMask(updateMask string) *ProjectsLocationsSourcesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsSourcesPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsSourcesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsSourcesPatchCall) Context(ctx context.Context) *ProjectsLocationsSourcesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsSourcesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsSourcesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.source)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.sources.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "migrationcenter.projects.locations.sources.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsSourcesPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.sources.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsSourcesErrorFramesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the details of an error frame.
//
//   - name: The name of the frame to retrieve. Format:
//     projects/{project}/locations/{location}/sources/{source}/errorFrames/{error
//     _frame}.
func (r *ProjectsLocationsSourcesErrorFramesService) Get(name string) *ProjectsLocationsSourcesErrorFramesGetCall {
	c := &ProjectsLocationsSourcesErrorFramesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// View sets the optional parameter "view": An optional view mode to control
// the level of details for the frame. The default is a basic frame view.
//
// Possible values:
//
//	"ERROR_FRAME_VIEW_UNSPECIFIED" - Value is unset. The system will fallback
//
// to the default value.
//
//	"ERROR_FRAME_VIEW_BASIC" - Include basic frame data, but not the full
//
// contents.
//
//	"ERROR_FRAME_VIEW_FULL" - Include everything.
func (c *ProjectsLocationsSourcesErrorFramesGetCall) View(view string) *ProjectsLocationsSourcesErrorFramesGetCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsSourcesErrorFramesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsSourcesErrorFramesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsSourcesErrorFramesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsSourcesErrorFramesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsSourcesErrorFramesGetCall) Context(ctx context.Context) *ProjectsLocationsSourcesErrorFramesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsSourcesErrorFramesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsSourcesErrorFramesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.sources.errorFrames.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "migrationcenter.projects.locations.sources.errorFrames.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *ErrorFrame.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsSourcesErrorFramesGetCall) Do(opts ...googleapi.CallOption) (*ErrorFrame, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ErrorFrame{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.sources.errorFrames.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsSourcesErrorFramesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all error frames in a given source and location.
//
// - parent: Parent value (the source) for `ListErrorFramesRequest`.
func (r *ProjectsLocationsSourcesErrorFramesService) List(parent string) *ProjectsLocationsSourcesErrorFramesListCall {
	c := &ProjectsLocationsSourcesErrorFramesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. Server
// may return fewer items than requested. If unspecified, server will pick an
// appropriate default.
func (c *ProjectsLocationsSourcesErrorFramesListCall) PageSize(pageSize int64) *ProjectsLocationsSourcesErrorFramesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results the server should return.
func (c *ProjectsLocationsSourcesErrorFramesListCall) PageToken(pageToken string) *ProjectsLocationsSourcesErrorFramesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// View sets the optional parameter "view": An optional view mode to control
// the level of details of each error frame. The default is a BASIC frame view.
//
// Possible values:
//
//	"ERROR_FRAME_VIEW_UNSPECIFIED" - Value is unset. The system will fallback
//
// to the default value.
//
//	"ERROR_FRAME_VIEW_BASIC" - Include basic frame data, but not the full
//
// contents.
//
//	"ERROR_FRAME_VIEW_FULL" - Include everything.
func (c *ProjectsLocationsSourcesErrorFramesListCall) View(view string) *ProjectsLocationsSourcesErrorFramesListCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsSourcesErrorFramesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsSourcesErrorFramesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsSourcesErrorFramesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsSourcesErrorFramesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsSourcesErrorFramesListCall) Context(ctx context.Context) *ProjectsLocationsSourcesErrorFramesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsSourcesErrorFramesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsSourcesErrorFramesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/errorFrames")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.sources.errorFrames.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "migrationcenter.projects.locations.sources.errorFrames.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListErrorFramesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsSourcesErrorFramesListCall) Do(opts ...googleapi.CallOption) (*ListErrorFramesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListErrorFramesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "migrationcenter.projects.locations.sources.errorFrames.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsSourcesErrorFramesListCall) Pages(ctx context.Context, f func(*ListErrorFramesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}
