// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/documentai/v1beta3/document_service.proto

package documentaipb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	DocumentService_UpdateDataset_FullMethodName        = "/google.cloud.documentai.v1beta3.DocumentService/UpdateDataset"
	DocumentService_ImportDocuments_FullMethodName      = "/google.cloud.documentai.v1beta3.DocumentService/ImportDocuments"
	DocumentService_GetDocument_FullMethodName          = "/google.cloud.documentai.v1beta3.DocumentService/GetDocument"
	DocumentService_ListDocuments_FullMethodName        = "/google.cloud.documentai.v1beta3.DocumentService/ListDocuments"
	DocumentService_BatchDeleteDocuments_FullMethodName = "/google.cloud.documentai.v1beta3.DocumentService/BatchDeleteDocuments"
	DocumentService_GetDatasetSchema_FullMethodName     = "/google.cloud.documentai.v1beta3.DocumentService/GetDatasetSchema"
	DocumentService_UpdateDatasetSchema_FullMethodName  = "/google.cloud.documentai.v1beta3.DocumentService/UpdateDatasetSchema"
)

// DocumentServiceClient is the client API for DocumentService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type DocumentServiceClient interface {
	// Updates metadata associated with a dataset.
	// Note that this method requires the
	// `documentai.googleapis.com/datasets.update` permission on the project,
	// which is highly privileged. A user or service account with this permission
	// can create new processors that can interact with any gcs bucket in your
	// project.
	UpdateDataset(ctx context.Context, in *UpdateDatasetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Import documents into a dataset.
	ImportDocuments(ctx context.Context, in *ImportDocumentsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Returns relevant fields present in the requested document.
	GetDocument(ctx context.Context, in *GetDocumentRequest, opts ...grpc.CallOption) (*GetDocumentResponse, error)
	// Returns a list of documents present in the dataset.
	ListDocuments(ctx context.Context, in *ListDocumentsRequest, opts ...grpc.CallOption) (*ListDocumentsResponse, error)
	// Deletes a set of documents.
	BatchDeleteDocuments(ctx context.Context, in *BatchDeleteDocumentsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets the `DatasetSchema` of a `Dataset`.
	GetDatasetSchema(ctx context.Context, in *GetDatasetSchemaRequest, opts ...grpc.CallOption) (*DatasetSchema, error)
	// Updates a `DatasetSchema`.
	UpdateDatasetSchema(ctx context.Context, in *UpdateDatasetSchemaRequest, opts ...grpc.CallOption) (*DatasetSchema, error)
}

type documentServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewDocumentServiceClient(cc grpc.ClientConnInterface) DocumentServiceClient {
	return &documentServiceClient{cc}
}

func (c *documentServiceClient) UpdateDataset(ctx context.Context, in *UpdateDatasetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DocumentService_UpdateDataset_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentServiceClient) ImportDocuments(ctx context.Context, in *ImportDocumentsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DocumentService_ImportDocuments_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentServiceClient) GetDocument(ctx context.Context, in *GetDocumentRequest, opts ...grpc.CallOption) (*GetDocumentResponse, error) {
	out := new(GetDocumentResponse)
	err := c.cc.Invoke(ctx, DocumentService_GetDocument_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentServiceClient) ListDocuments(ctx context.Context, in *ListDocumentsRequest, opts ...grpc.CallOption) (*ListDocumentsResponse, error) {
	out := new(ListDocumentsResponse)
	err := c.cc.Invoke(ctx, DocumentService_ListDocuments_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentServiceClient) BatchDeleteDocuments(ctx context.Context, in *BatchDeleteDocumentsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DocumentService_BatchDeleteDocuments_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentServiceClient) GetDatasetSchema(ctx context.Context, in *GetDatasetSchemaRequest, opts ...grpc.CallOption) (*DatasetSchema, error) {
	out := new(DatasetSchema)
	err := c.cc.Invoke(ctx, DocumentService_GetDatasetSchema_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentServiceClient) UpdateDatasetSchema(ctx context.Context, in *UpdateDatasetSchemaRequest, opts ...grpc.CallOption) (*DatasetSchema, error) {
	out := new(DatasetSchema)
	err := c.cc.Invoke(ctx, DocumentService_UpdateDatasetSchema_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DocumentServiceServer is the server API for DocumentService service.
// All implementations should embed UnimplementedDocumentServiceServer
// for forward compatibility
type DocumentServiceServer interface {
	// Updates metadata associated with a dataset.
	// Note that this method requires the
	// `documentai.googleapis.com/datasets.update` permission on the project,
	// which is highly privileged. A user or service account with this permission
	// can create new processors that can interact with any gcs bucket in your
	// project.
	UpdateDataset(context.Context, *UpdateDatasetRequest) (*longrunningpb.Operation, error)
	// Import documents into a dataset.
	ImportDocuments(context.Context, *ImportDocumentsRequest) (*longrunningpb.Operation, error)
	// Returns relevant fields present in the requested document.
	GetDocument(context.Context, *GetDocumentRequest) (*GetDocumentResponse, error)
	// Returns a list of documents present in the dataset.
	ListDocuments(context.Context, *ListDocumentsRequest) (*ListDocumentsResponse, error)
	// Deletes a set of documents.
	BatchDeleteDocuments(context.Context, *BatchDeleteDocumentsRequest) (*longrunningpb.Operation, error)
	// Gets the `DatasetSchema` of a `Dataset`.
	GetDatasetSchema(context.Context, *GetDatasetSchemaRequest) (*DatasetSchema, error)
	// Updates a `DatasetSchema`.
	UpdateDatasetSchema(context.Context, *UpdateDatasetSchemaRequest) (*DatasetSchema, error)
}

// UnimplementedDocumentServiceServer should be embedded to have forward compatible implementations.
type UnimplementedDocumentServiceServer struct {
}

func (UnimplementedDocumentServiceServer) UpdateDataset(context.Context, *UpdateDatasetRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDataset not implemented")
}
func (UnimplementedDocumentServiceServer) ImportDocuments(context.Context, *ImportDocumentsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportDocuments not implemented")
}
func (UnimplementedDocumentServiceServer) GetDocument(context.Context, *GetDocumentRequest) (*GetDocumentResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDocument not implemented")
}
func (UnimplementedDocumentServiceServer) ListDocuments(context.Context, *ListDocumentsRequest) (*ListDocumentsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDocuments not implemented")
}
func (UnimplementedDocumentServiceServer) BatchDeleteDocuments(context.Context, *BatchDeleteDocumentsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchDeleteDocuments not implemented")
}
func (UnimplementedDocumentServiceServer) GetDatasetSchema(context.Context, *GetDatasetSchemaRequest) (*DatasetSchema, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDatasetSchema not implemented")
}
func (UnimplementedDocumentServiceServer) UpdateDatasetSchema(context.Context, *UpdateDatasetSchemaRequest) (*DatasetSchema, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDatasetSchema not implemented")
}

// UnsafeDocumentServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to DocumentServiceServer will
// result in compilation errors.
type UnsafeDocumentServiceServer interface {
	mustEmbedUnimplementedDocumentServiceServer()
}

func RegisterDocumentServiceServer(s grpc.ServiceRegistrar, srv DocumentServiceServer) {
	s.RegisterService(&DocumentService_ServiceDesc, srv)
}

func _DocumentService_UpdateDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDatasetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentServiceServer).UpdateDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DocumentService_UpdateDataset_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentServiceServer).UpdateDataset(ctx, req.(*UpdateDatasetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentService_ImportDocuments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportDocumentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentServiceServer).ImportDocuments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DocumentService_ImportDocuments_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentServiceServer).ImportDocuments(ctx, req.(*ImportDocumentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentService_GetDocument_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDocumentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentServiceServer).GetDocument(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DocumentService_GetDocument_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentServiceServer).GetDocument(ctx, req.(*GetDocumentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentService_ListDocuments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDocumentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentServiceServer).ListDocuments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DocumentService_ListDocuments_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentServiceServer).ListDocuments(ctx, req.(*ListDocumentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentService_BatchDeleteDocuments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchDeleteDocumentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentServiceServer).BatchDeleteDocuments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DocumentService_BatchDeleteDocuments_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentServiceServer).BatchDeleteDocuments(ctx, req.(*BatchDeleteDocumentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentService_GetDatasetSchema_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDatasetSchemaRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentServiceServer).GetDatasetSchema(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DocumentService_GetDatasetSchema_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentServiceServer).GetDatasetSchema(ctx, req.(*GetDatasetSchemaRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentService_UpdateDatasetSchema_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDatasetSchemaRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentServiceServer).UpdateDatasetSchema(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DocumentService_UpdateDatasetSchema_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentServiceServer).UpdateDatasetSchema(ctx, req.(*UpdateDatasetSchemaRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// DocumentService_ServiceDesc is the grpc.ServiceDesc for DocumentService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var DocumentService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.documentai.v1beta3.DocumentService",
	HandlerType: (*DocumentServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "UpdateDataset",
			Handler:    _DocumentService_UpdateDataset_Handler,
		},
		{
			MethodName: "ImportDocuments",
			Handler:    _DocumentService_ImportDocuments_Handler,
		},
		{
			MethodName: "GetDocument",
			Handler:    _DocumentService_GetDocument_Handler,
		},
		{
			MethodName: "ListDocuments",
			Handler:    _DocumentService_ListDocuments_Handler,
		},
		{
			MethodName: "BatchDeleteDocuments",
			Handler:    _DocumentService_BatchDeleteDocuments_Handler,
		},
		{
			MethodName: "GetDatasetSchema",
			Handler:    _DocumentService_GetDatasetSchema_Handler,
		},
		{
			MethodName: "UpdateDatasetSchema",
			Handler:    _DocumentService_UpdateDatasetSchema_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/documentai/v1beta3/document_service.proto",
}
