// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/aiplatform/v1/metadata_service.proto

package aiplatformpb

import (
	context "context"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	MetadataService_CreateMetadataStore_FullMethodName              = "/google.cloud.aiplatform.v1.MetadataService/CreateMetadataStore"
	MetadataService_GetMetadataStore_FullMethodName                 = "/google.cloud.aiplatform.v1.MetadataService/GetMetadataStore"
	MetadataService_ListMetadataStores_FullMethodName               = "/google.cloud.aiplatform.v1.MetadataService/ListMetadataStores"
	MetadataService_DeleteMetadataStore_FullMethodName              = "/google.cloud.aiplatform.v1.MetadataService/DeleteMetadataStore"
	MetadataService_CreateArtifact_FullMethodName                   = "/google.cloud.aiplatform.v1.MetadataService/CreateArtifact"
	MetadataService_GetArtifact_FullMethodName                      = "/google.cloud.aiplatform.v1.MetadataService/GetArtifact"
	MetadataService_ListArtifacts_FullMethodName                    = "/google.cloud.aiplatform.v1.MetadataService/ListArtifacts"
	MetadataService_UpdateArtifact_FullMethodName                   = "/google.cloud.aiplatform.v1.MetadataService/UpdateArtifact"
	MetadataService_DeleteArtifact_FullMethodName                   = "/google.cloud.aiplatform.v1.MetadataService/DeleteArtifact"
	MetadataService_PurgeArtifacts_FullMethodName                   = "/google.cloud.aiplatform.v1.MetadataService/PurgeArtifacts"
	MetadataService_CreateContext_FullMethodName                    = "/google.cloud.aiplatform.v1.MetadataService/CreateContext"
	MetadataService_GetContext_FullMethodName                       = "/google.cloud.aiplatform.v1.MetadataService/GetContext"
	MetadataService_ListContexts_FullMethodName                     = "/google.cloud.aiplatform.v1.MetadataService/ListContexts"
	MetadataService_UpdateContext_FullMethodName                    = "/google.cloud.aiplatform.v1.MetadataService/UpdateContext"
	MetadataService_DeleteContext_FullMethodName                    = "/google.cloud.aiplatform.v1.MetadataService/DeleteContext"
	MetadataService_PurgeContexts_FullMethodName                    = "/google.cloud.aiplatform.v1.MetadataService/PurgeContexts"
	MetadataService_AddContextArtifactsAndExecutions_FullMethodName = "/google.cloud.aiplatform.v1.MetadataService/AddContextArtifactsAndExecutions"
	MetadataService_AddContextChildren_FullMethodName               = "/google.cloud.aiplatform.v1.MetadataService/AddContextChildren"
	MetadataService_RemoveContextChildren_FullMethodName            = "/google.cloud.aiplatform.v1.MetadataService/RemoveContextChildren"
	MetadataService_QueryContextLineageSubgraph_FullMethodName      = "/google.cloud.aiplatform.v1.MetadataService/QueryContextLineageSubgraph"
	MetadataService_CreateExecution_FullMethodName                  = "/google.cloud.aiplatform.v1.MetadataService/CreateExecution"
	MetadataService_GetExecution_FullMethodName                     = "/google.cloud.aiplatform.v1.MetadataService/GetExecution"
	MetadataService_ListExecutions_FullMethodName                   = "/google.cloud.aiplatform.v1.MetadataService/ListExecutions"
	MetadataService_UpdateExecution_FullMethodName                  = "/google.cloud.aiplatform.v1.MetadataService/UpdateExecution"
	MetadataService_DeleteExecution_FullMethodName                  = "/google.cloud.aiplatform.v1.MetadataService/DeleteExecution"
	MetadataService_PurgeExecutions_FullMethodName                  = "/google.cloud.aiplatform.v1.MetadataService/PurgeExecutions"
	MetadataService_AddExecutionEvents_FullMethodName               = "/google.cloud.aiplatform.v1.MetadataService/AddExecutionEvents"
	MetadataService_QueryExecutionInputsAndOutputs_FullMethodName   = "/google.cloud.aiplatform.v1.MetadataService/QueryExecutionInputsAndOutputs"
	MetadataService_CreateMetadataSchema_FullMethodName             = "/google.cloud.aiplatform.v1.MetadataService/CreateMetadataSchema"
	MetadataService_GetMetadataSchema_FullMethodName                = "/google.cloud.aiplatform.v1.MetadataService/GetMetadataSchema"
	MetadataService_ListMetadataSchemas_FullMethodName              = "/google.cloud.aiplatform.v1.MetadataService/ListMetadataSchemas"
	MetadataService_QueryArtifactLineageSubgraph_FullMethodName     = "/google.cloud.aiplatform.v1.MetadataService/QueryArtifactLineageSubgraph"
)

// MetadataServiceClient is the client API for MetadataService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type MetadataServiceClient interface {
	// Initializes a MetadataStore, including allocation of resources.
	CreateMetadataStore(ctx context.Context, in *CreateMetadataStoreRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Retrieves a specific MetadataStore.
	GetMetadataStore(ctx context.Context, in *GetMetadataStoreRequest, opts ...grpc.CallOption) (*MetadataStore, error)
	// Lists MetadataStores for a Location.
	ListMetadataStores(ctx context.Context, in *ListMetadataStoresRequest, opts ...grpc.CallOption) (*ListMetadataStoresResponse, error)
	// Deletes a single MetadataStore and all its child resources (Artifacts,
	// Executions, and Contexts).
	DeleteMetadataStore(ctx context.Context, in *DeleteMetadataStoreRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates an Artifact associated with a MetadataStore.
	CreateArtifact(ctx context.Context, in *CreateArtifactRequest, opts ...grpc.CallOption) (*Artifact, error)
	// Retrieves a specific Artifact.
	GetArtifact(ctx context.Context, in *GetArtifactRequest, opts ...grpc.CallOption) (*Artifact, error)
	// Lists Artifacts in the MetadataStore.
	ListArtifacts(ctx context.Context, in *ListArtifactsRequest, opts ...grpc.CallOption) (*ListArtifactsResponse, error)
	// Updates a stored Artifact.
	UpdateArtifact(ctx context.Context, in *UpdateArtifactRequest, opts ...grpc.CallOption) (*Artifact, error)
	// Deletes an Artifact.
	DeleteArtifact(ctx context.Context, in *DeleteArtifactRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Purges Artifacts.
	PurgeArtifacts(ctx context.Context, in *PurgeArtifactsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a Context associated with a MetadataStore.
	CreateContext(ctx context.Context, in *CreateContextRequest, opts ...grpc.CallOption) (*Context, error)
	// Retrieves a specific Context.
	GetContext(ctx context.Context, in *GetContextRequest, opts ...grpc.CallOption) (*Context, error)
	// Lists Contexts on the MetadataStore.
	ListContexts(ctx context.Context, in *ListContextsRequest, opts ...grpc.CallOption) (*ListContextsResponse, error)
	// Updates a stored Context.
	UpdateContext(ctx context.Context, in *UpdateContextRequest, opts ...grpc.CallOption) (*Context, error)
	// Deletes a stored Context.
	DeleteContext(ctx context.Context, in *DeleteContextRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Purges Contexts.
	PurgeContexts(ctx context.Context, in *PurgeContextsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Adds a set of Artifacts and Executions to a Context. If any of the
	// Artifacts or Executions have already been added to a Context, they are
	// simply skipped.
	AddContextArtifactsAndExecutions(ctx context.Context, in *AddContextArtifactsAndExecutionsRequest, opts ...grpc.CallOption) (*AddContextArtifactsAndExecutionsResponse, error)
	// Adds a set of Contexts as children to a parent Context. If any of the
	// child Contexts have already been added to the parent Context, they are
	// simply skipped. If this call would create a cycle or cause any Context to
	// have more than 10 parents, the request will fail with an INVALID_ARGUMENT
	// error.
	AddContextChildren(ctx context.Context, in *AddContextChildrenRequest, opts ...grpc.CallOption) (*AddContextChildrenResponse, error)
	// Remove a set of children contexts from a parent Context. If any of the
	// child Contexts were NOT added to the parent Context, they are
	// simply skipped.
	RemoveContextChildren(ctx context.Context, in *RemoveContextChildrenRequest, opts ...grpc.CallOption) (*RemoveContextChildrenResponse, error)
	// Retrieves Artifacts and Executions within the specified Context, connected
	// by Event edges and returned as a LineageSubgraph.
	QueryContextLineageSubgraph(ctx context.Context, in *QueryContextLineageSubgraphRequest, opts ...grpc.CallOption) (*LineageSubgraph, error)
	// Creates an Execution associated with a MetadataStore.
	CreateExecution(ctx context.Context, in *CreateExecutionRequest, opts ...grpc.CallOption) (*Execution, error)
	// Retrieves a specific Execution.
	GetExecution(ctx context.Context, in *GetExecutionRequest, opts ...grpc.CallOption) (*Execution, error)
	// Lists Executions in the MetadataStore.
	ListExecutions(ctx context.Context, in *ListExecutionsRequest, opts ...grpc.CallOption) (*ListExecutionsResponse, error)
	// Updates a stored Execution.
	UpdateExecution(ctx context.Context, in *UpdateExecutionRequest, opts ...grpc.CallOption) (*Execution, error)
	// Deletes an Execution.
	DeleteExecution(ctx context.Context, in *DeleteExecutionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Purges Executions.
	PurgeExecutions(ctx context.Context, in *PurgeExecutionsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Adds Events to the specified Execution. An Event indicates whether an
	// Artifact was used as an input or output for an Execution. If an Event
	// already exists between the Execution and the Artifact, the Event is
	// skipped.
	AddExecutionEvents(ctx context.Context, in *AddExecutionEventsRequest, opts ...grpc.CallOption) (*AddExecutionEventsResponse, error)
	// Obtains the set of input and output Artifacts for this Execution, in the
	// form of LineageSubgraph that also contains the Execution and connecting
	// Events.
	QueryExecutionInputsAndOutputs(ctx context.Context, in *QueryExecutionInputsAndOutputsRequest, opts ...grpc.CallOption) (*LineageSubgraph, error)
	// Creates a MetadataSchema.
	CreateMetadataSchema(ctx context.Context, in *CreateMetadataSchemaRequest, opts ...grpc.CallOption) (*MetadataSchema, error)
	// Retrieves a specific MetadataSchema.
	GetMetadataSchema(ctx context.Context, in *GetMetadataSchemaRequest, opts ...grpc.CallOption) (*MetadataSchema, error)
	// Lists MetadataSchemas.
	ListMetadataSchemas(ctx context.Context, in *ListMetadataSchemasRequest, opts ...grpc.CallOption) (*ListMetadataSchemasResponse, error)
	// Retrieves lineage of an Artifact represented through Artifacts and
	// Executions connected by Event edges and returned as a LineageSubgraph.
	QueryArtifactLineageSubgraph(ctx context.Context, in *QueryArtifactLineageSubgraphRequest, opts ...grpc.CallOption) (*LineageSubgraph, error)
}

type metadataServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewMetadataServiceClient(cc grpc.ClientConnInterface) MetadataServiceClient {
	return &metadataServiceClient{cc}
}

func (c *metadataServiceClient) CreateMetadataStore(ctx context.Context, in *CreateMetadataStoreRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, MetadataService_CreateMetadataStore_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) GetMetadataStore(ctx context.Context, in *GetMetadataStoreRequest, opts ...grpc.CallOption) (*MetadataStore, error) {
	out := new(MetadataStore)
	err := c.cc.Invoke(ctx, MetadataService_GetMetadataStore_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) ListMetadataStores(ctx context.Context, in *ListMetadataStoresRequest, opts ...grpc.CallOption) (*ListMetadataStoresResponse, error) {
	out := new(ListMetadataStoresResponse)
	err := c.cc.Invoke(ctx, MetadataService_ListMetadataStores_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) DeleteMetadataStore(ctx context.Context, in *DeleteMetadataStoreRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, MetadataService_DeleteMetadataStore_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) CreateArtifact(ctx context.Context, in *CreateArtifactRequest, opts ...grpc.CallOption) (*Artifact, error) {
	out := new(Artifact)
	err := c.cc.Invoke(ctx, MetadataService_CreateArtifact_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) GetArtifact(ctx context.Context, in *GetArtifactRequest, opts ...grpc.CallOption) (*Artifact, error) {
	out := new(Artifact)
	err := c.cc.Invoke(ctx, MetadataService_GetArtifact_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) ListArtifacts(ctx context.Context, in *ListArtifactsRequest, opts ...grpc.CallOption) (*ListArtifactsResponse, error) {
	out := new(ListArtifactsResponse)
	err := c.cc.Invoke(ctx, MetadataService_ListArtifacts_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) UpdateArtifact(ctx context.Context, in *UpdateArtifactRequest, opts ...grpc.CallOption) (*Artifact, error) {
	out := new(Artifact)
	err := c.cc.Invoke(ctx, MetadataService_UpdateArtifact_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) DeleteArtifact(ctx context.Context, in *DeleteArtifactRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, MetadataService_DeleteArtifact_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) PurgeArtifacts(ctx context.Context, in *PurgeArtifactsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, MetadataService_PurgeArtifacts_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) CreateContext(ctx context.Context, in *CreateContextRequest, opts ...grpc.CallOption) (*Context, error) {
	out := new(Context)
	err := c.cc.Invoke(ctx, MetadataService_CreateContext_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) GetContext(ctx context.Context, in *GetContextRequest, opts ...grpc.CallOption) (*Context, error) {
	out := new(Context)
	err := c.cc.Invoke(ctx, MetadataService_GetContext_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) ListContexts(ctx context.Context, in *ListContextsRequest, opts ...grpc.CallOption) (*ListContextsResponse, error) {
	out := new(ListContextsResponse)
	err := c.cc.Invoke(ctx, MetadataService_ListContexts_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) UpdateContext(ctx context.Context, in *UpdateContextRequest, opts ...grpc.CallOption) (*Context, error) {
	out := new(Context)
	err := c.cc.Invoke(ctx, MetadataService_UpdateContext_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) DeleteContext(ctx context.Context, in *DeleteContextRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, MetadataService_DeleteContext_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) PurgeContexts(ctx context.Context, in *PurgeContextsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, MetadataService_PurgeContexts_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) AddContextArtifactsAndExecutions(ctx context.Context, in *AddContextArtifactsAndExecutionsRequest, opts ...grpc.CallOption) (*AddContextArtifactsAndExecutionsResponse, error) {
	out := new(AddContextArtifactsAndExecutionsResponse)
	err := c.cc.Invoke(ctx, MetadataService_AddContextArtifactsAndExecutions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) AddContextChildren(ctx context.Context, in *AddContextChildrenRequest, opts ...grpc.CallOption) (*AddContextChildrenResponse, error) {
	out := new(AddContextChildrenResponse)
	err := c.cc.Invoke(ctx, MetadataService_AddContextChildren_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) RemoveContextChildren(ctx context.Context, in *RemoveContextChildrenRequest, opts ...grpc.CallOption) (*RemoveContextChildrenResponse, error) {
	out := new(RemoveContextChildrenResponse)
	err := c.cc.Invoke(ctx, MetadataService_RemoveContextChildren_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) QueryContextLineageSubgraph(ctx context.Context, in *QueryContextLineageSubgraphRequest, opts ...grpc.CallOption) (*LineageSubgraph, error) {
	out := new(LineageSubgraph)
	err := c.cc.Invoke(ctx, MetadataService_QueryContextLineageSubgraph_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) CreateExecution(ctx context.Context, in *CreateExecutionRequest, opts ...grpc.CallOption) (*Execution, error) {
	out := new(Execution)
	err := c.cc.Invoke(ctx, MetadataService_CreateExecution_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) GetExecution(ctx context.Context, in *GetExecutionRequest, opts ...grpc.CallOption) (*Execution, error) {
	out := new(Execution)
	err := c.cc.Invoke(ctx, MetadataService_GetExecution_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) ListExecutions(ctx context.Context, in *ListExecutionsRequest, opts ...grpc.CallOption) (*ListExecutionsResponse, error) {
	out := new(ListExecutionsResponse)
	err := c.cc.Invoke(ctx, MetadataService_ListExecutions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) UpdateExecution(ctx context.Context, in *UpdateExecutionRequest, opts ...grpc.CallOption) (*Execution, error) {
	out := new(Execution)
	err := c.cc.Invoke(ctx, MetadataService_UpdateExecution_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) DeleteExecution(ctx context.Context, in *DeleteExecutionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, MetadataService_DeleteExecution_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) PurgeExecutions(ctx context.Context, in *PurgeExecutionsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, MetadataService_PurgeExecutions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) AddExecutionEvents(ctx context.Context, in *AddExecutionEventsRequest, opts ...grpc.CallOption) (*AddExecutionEventsResponse, error) {
	out := new(AddExecutionEventsResponse)
	err := c.cc.Invoke(ctx, MetadataService_AddExecutionEvents_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) QueryExecutionInputsAndOutputs(ctx context.Context, in *QueryExecutionInputsAndOutputsRequest, opts ...grpc.CallOption) (*LineageSubgraph, error) {
	out := new(LineageSubgraph)
	err := c.cc.Invoke(ctx, MetadataService_QueryExecutionInputsAndOutputs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) CreateMetadataSchema(ctx context.Context, in *CreateMetadataSchemaRequest, opts ...grpc.CallOption) (*MetadataSchema, error) {
	out := new(MetadataSchema)
	err := c.cc.Invoke(ctx, MetadataService_CreateMetadataSchema_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) GetMetadataSchema(ctx context.Context, in *GetMetadataSchemaRequest, opts ...grpc.CallOption) (*MetadataSchema, error) {
	out := new(MetadataSchema)
	err := c.cc.Invoke(ctx, MetadataService_GetMetadataSchema_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) ListMetadataSchemas(ctx context.Context, in *ListMetadataSchemasRequest, opts ...grpc.CallOption) (*ListMetadataSchemasResponse, error) {
	out := new(ListMetadataSchemasResponse)
	err := c.cc.Invoke(ctx, MetadataService_ListMetadataSchemas_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) QueryArtifactLineageSubgraph(ctx context.Context, in *QueryArtifactLineageSubgraphRequest, opts ...grpc.CallOption) (*LineageSubgraph, error) {
	out := new(LineageSubgraph)
	err := c.cc.Invoke(ctx, MetadataService_QueryArtifactLineageSubgraph_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// MetadataServiceServer is the server API for MetadataService service.
// All implementations should embed UnimplementedMetadataServiceServer
// for forward compatibility
type MetadataServiceServer interface {
	// Initializes a MetadataStore, including allocation of resources.
	CreateMetadataStore(context.Context, *CreateMetadataStoreRequest) (*longrunningpb.Operation, error)
	// Retrieves a specific MetadataStore.
	GetMetadataStore(context.Context, *GetMetadataStoreRequest) (*MetadataStore, error)
	// Lists MetadataStores for a Location.
	ListMetadataStores(context.Context, *ListMetadataStoresRequest) (*ListMetadataStoresResponse, error)
	// Deletes a single MetadataStore and all its child resources (Artifacts,
	// Executions, and Contexts).
	DeleteMetadataStore(context.Context, *DeleteMetadataStoreRequest) (*longrunningpb.Operation, error)
	// Creates an Artifact associated with a MetadataStore.
	CreateArtifact(context.Context, *CreateArtifactRequest) (*Artifact, error)
	// Retrieves a specific Artifact.
	GetArtifact(context.Context, *GetArtifactRequest) (*Artifact, error)
	// Lists Artifacts in the MetadataStore.
	ListArtifacts(context.Context, *ListArtifactsRequest) (*ListArtifactsResponse, error)
	// Updates a stored Artifact.
	UpdateArtifact(context.Context, *UpdateArtifactRequest) (*Artifact, error)
	// Deletes an Artifact.
	DeleteArtifact(context.Context, *DeleteArtifactRequest) (*longrunningpb.Operation, error)
	// Purges Artifacts.
	PurgeArtifacts(context.Context, *PurgeArtifactsRequest) (*longrunningpb.Operation, error)
	// Creates a Context associated with a MetadataStore.
	CreateContext(context.Context, *CreateContextRequest) (*Context, error)
	// Retrieves a specific Context.
	GetContext(context.Context, *GetContextRequest) (*Context, error)
	// Lists Contexts on the MetadataStore.
	ListContexts(context.Context, *ListContextsRequest) (*ListContextsResponse, error)
	// Updates a stored Context.
	UpdateContext(context.Context, *UpdateContextRequest) (*Context, error)
	// Deletes a stored Context.
	DeleteContext(context.Context, *DeleteContextRequest) (*longrunningpb.Operation, error)
	// Purges Contexts.
	PurgeContexts(context.Context, *PurgeContextsRequest) (*longrunningpb.Operation, error)
	// Adds a set of Artifacts and Executions to a Context. If any of the
	// Artifacts or Executions have already been added to a Context, they are
	// simply skipped.
	AddContextArtifactsAndExecutions(context.Context, *AddContextArtifactsAndExecutionsRequest) (*AddContextArtifactsAndExecutionsResponse, error)
	// Adds a set of Contexts as children to a parent Context. If any of the
	// child Contexts have already been added to the parent Context, they are
	// simply skipped. If this call would create a cycle or cause any Context to
	// have more than 10 parents, the request will fail with an INVALID_ARGUMENT
	// error.
	AddContextChildren(context.Context, *AddContextChildrenRequest) (*AddContextChildrenResponse, error)
	// Remove a set of children contexts from a parent Context. If any of the
	// child Contexts were NOT added to the parent Context, they are
	// simply skipped.
	RemoveContextChildren(context.Context, *RemoveContextChildrenRequest) (*RemoveContextChildrenResponse, error)
	// Retrieves Artifacts and Executions within the specified Context, connected
	// by Event edges and returned as a LineageSubgraph.
	QueryContextLineageSubgraph(context.Context, *QueryContextLineageSubgraphRequest) (*LineageSubgraph, error)
	// Creates an Execution associated with a MetadataStore.
	CreateExecution(context.Context, *CreateExecutionRequest) (*Execution, error)
	// Retrieves a specific Execution.
	GetExecution(context.Context, *GetExecutionRequest) (*Execution, error)
	// Lists Executions in the MetadataStore.
	ListExecutions(context.Context, *ListExecutionsRequest) (*ListExecutionsResponse, error)
	// Updates a stored Execution.
	UpdateExecution(context.Context, *UpdateExecutionRequest) (*Execution, error)
	// Deletes an Execution.
	DeleteExecution(context.Context, *DeleteExecutionRequest) (*longrunningpb.Operation, error)
	// Purges Executions.
	PurgeExecutions(context.Context, *PurgeExecutionsRequest) (*longrunningpb.Operation, error)
	// Adds Events to the specified Execution. An Event indicates whether an
	// Artifact was used as an input or output for an Execution. If an Event
	// already exists between the Execution and the Artifact, the Event is
	// skipped.
	AddExecutionEvents(context.Context, *AddExecutionEventsRequest) (*AddExecutionEventsResponse, error)
	// Obtains the set of input and output Artifacts for this Execution, in the
	// form of LineageSubgraph that also contains the Execution and connecting
	// Events.
	QueryExecutionInputsAndOutputs(context.Context, *QueryExecutionInputsAndOutputsRequest) (*LineageSubgraph, error)
	// Creates a MetadataSchema.
	CreateMetadataSchema(context.Context, *CreateMetadataSchemaRequest) (*MetadataSchema, error)
	// Retrieves a specific MetadataSchema.
	GetMetadataSchema(context.Context, *GetMetadataSchemaRequest) (*MetadataSchema, error)
	// Lists MetadataSchemas.
	ListMetadataSchemas(context.Context, *ListMetadataSchemasRequest) (*ListMetadataSchemasResponse, error)
	// Retrieves lineage of an Artifact represented through Artifacts and
	// Executions connected by Event edges and returned as a LineageSubgraph.
	QueryArtifactLineageSubgraph(context.Context, *QueryArtifactLineageSubgraphRequest) (*LineageSubgraph, error)
}

// UnimplementedMetadataServiceServer should be embedded to have forward compatible implementations.
type UnimplementedMetadataServiceServer struct {
}

func (UnimplementedMetadataServiceServer) CreateMetadataStore(context.Context, *CreateMetadataStoreRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateMetadataStore not implemented")
}
func (UnimplementedMetadataServiceServer) GetMetadataStore(context.Context, *GetMetadataStoreRequest) (*MetadataStore, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetMetadataStore not implemented")
}
func (UnimplementedMetadataServiceServer) ListMetadataStores(context.Context, *ListMetadataStoresRequest) (*ListMetadataStoresResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListMetadataStores not implemented")
}
func (UnimplementedMetadataServiceServer) DeleteMetadataStore(context.Context, *DeleteMetadataStoreRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteMetadataStore not implemented")
}
func (UnimplementedMetadataServiceServer) CreateArtifact(context.Context, *CreateArtifactRequest) (*Artifact, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateArtifact not implemented")
}
func (UnimplementedMetadataServiceServer) GetArtifact(context.Context, *GetArtifactRequest) (*Artifact, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetArtifact not implemented")
}
func (UnimplementedMetadataServiceServer) ListArtifacts(context.Context, *ListArtifactsRequest) (*ListArtifactsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListArtifacts not implemented")
}
func (UnimplementedMetadataServiceServer) UpdateArtifact(context.Context, *UpdateArtifactRequest) (*Artifact, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateArtifact not implemented")
}
func (UnimplementedMetadataServiceServer) DeleteArtifact(context.Context, *DeleteArtifactRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteArtifact not implemented")
}
func (UnimplementedMetadataServiceServer) PurgeArtifacts(context.Context, *PurgeArtifactsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PurgeArtifacts not implemented")
}
func (UnimplementedMetadataServiceServer) CreateContext(context.Context, *CreateContextRequest) (*Context, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateContext not implemented")
}
func (UnimplementedMetadataServiceServer) GetContext(context.Context, *GetContextRequest) (*Context, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetContext not implemented")
}
func (UnimplementedMetadataServiceServer) ListContexts(context.Context, *ListContextsRequest) (*ListContextsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListContexts not implemented")
}
func (UnimplementedMetadataServiceServer) UpdateContext(context.Context, *UpdateContextRequest) (*Context, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateContext not implemented")
}
func (UnimplementedMetadataServiceServer) DeleteContext(context.Context, *DeleteContextRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteContext not implemented")
}
func (UnimplementedMetadataServiceServer) PurgeContexts(context.Context, *PurgeContextsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PurgeContexts not implemented")
}
func (UnimplementedMetadataServiceServer) AddContextArtifactsAndExecutions(context.Context, *AddContextArtifactsAndExecutionsRequest) (*AddContextArtifactsAndExecutionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddContextArtifactsAndExecutions not implemented")
}
func (UnimplementedMetadataServiceServer) AddContextChildren(context.Context, *AddContextChildrenRequest) (*AddContextChildrenResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddContextChildren not implemented")
}
func (UnimplementedMetadataServiceServer) RemoveContextChildren(context.Context, *RemoveContextChildrenRequest) (*RemoveContextChildrenResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoveContextChildren not implemented")
}
func (UnimplementedMetadataServiceServer) QueryContextLineageSubgraph(context.Context, *QueryContextLineageSubgraphRequest) (*LineageSubgraph, error) {
	return nil, status.Errorf(codes.Unimplemented, "method QueryContextLineageSubgraph not implemented")
}
func (UnimplementedMetadataServiceServer) CreateExecution(context.Context, *CreateExecutionRequest) (*Execution, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateExecution not implemented")
}
func (UnimplementedMetadataServiceServer) GetExecution(context.Context, *GetExecutionRequest) (*Execution, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetExecution not implemented")
}
func (UnimplementedMetadataServiceServer) ListExecutions(context.Context, *ListExecutionsRequest) (*ListExecutionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListExecutions not implemented")
}
func (UnimplementedMetadataServiceServer) UpdateExecution(context.Context, *UpdateExecutionRequest) (*Execution, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateExecution not implemented")
}
func (UnimplementedMetadataServiceServer) DeleteExecution(context.Context, *DeleteExecutionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteExecution not implemented")
}
func (UnimplementedMetadataServiceServer) PurgeExecutions(context.Context, *PurgeExecutionsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PurgeExecutions not implemented")
}
func (UnimplementedMetadataServiceServer) AddExecutionEvents(context.Context, *AddExecutionEventsRequest) (*AddExecutionEventsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddExecutionEvents not implemented")
}
func (UnimplementedMetadataServiceServer) QueryExecutionInputsAndOutputs(context.Context, *QueryExecutionInputsAndOutputsRequest) (*LineageSubgraph, error) {
	return nil, status.Errorf(codes.Unimplemented, "method QueryExecutionInputsAndOutputs not implemented")
}
func (UnimplementedMetadataServiceServer) CreateMetadataSchema(context.Context, *CreateMetadataSchemaRequest) (*MetadataSchema, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateMetadataSchema not implemented")
}
func (UnimplementedMetadataServiceServer) GetMetadataSchema(context.Context, *GetMetadataSchemaRequest) (*MetadataSchema, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetMetadataSchema not implemented")
}
func (UnimplementedMetadataServiceServer) ListMetadataSchemas(context.Context, *ListMetadataSchemasRequest) (*ListMetadataSchemasResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListMetadataSchemas not implemented")
}
func (UnimplementedMetadataServiceServer) QueryArtifactLineageSubgraph(context.Context, *QueryArtifactLineageSubgraphRequest) (*LineageSubgraph, error) {
	return nil, status.Errorf(codes.Unimplemented, "method QueryArtifactLineageSubgraph not implemented")
}

// UnsafeMetadataServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to MetadataServiceServer will
// result in compilation errors.
type UnsafeMetadataServiceServer interface {
	mustEmbedUnimplementedMetadataServiceServer()
}

func RegisterMetadataServiceServer(s grpc.ServiceRegistrar, srv MetadataServiceServer) {
	s.RegisterService(&MetadataService_ServiceDesc, srv)
}

func _MetadataService_CreateMetadataStore_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateMetadataStoreRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).CreateMetadataStore(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetadataService_CreateMetadataStore_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).CreateMetadataStore(ctx, req.(*CreateMetadataStoreRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_GetMetadataStore_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMetadataStoreRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).GetMetadataStore(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetadataService_GetMetadataStore_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).GetMetadataStore(ctx, req.(*GetMetadataStoreRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_ListMetadataStores_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListMetadataStoresRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).ListMetadataStores(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetadataService_ListMetadataStores_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).ListMetadataStores(ctx, req.(*ListMetadataStoresRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_DeleteMetadataStore_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteMetadataStoreRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).DeleteMetadataStore(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetadataService_DeleteMetadataStore_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).DeleteMetadataStore(ctx, req.(*DeleteMetadataStoreRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_CreateArtifact_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateArtifactRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).CreateArtifact(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetadataService_CreateArtifact_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).CreateArtifact(ctx, req.(*CreateArtifactRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_GetArtifact_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetArtifactRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).GetArtifact(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetadataService_GetArtifact_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).GetArtifact(ctx, req.(*GetArtifactRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_ListArtifacts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListArtifactsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).ListArtifacts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetadataService_ListArtifacts_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).ListArtifacts(ctx, req.(*ListArtifactsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_UpdateArtifact_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateArtifactRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).UpdateArtifact(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetadataService_UpdateArtifact_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).UpdateArtifact(ctx, req.(*UpdateArtifactRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_DeleteArtifact_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteArtifactRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).DeleteArtifact(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetadataService_DeleteArtifact_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).DeleteArtifact(ctx, req.(*DeleteArtifactRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_PurgeArtifacts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PurgeArtifactsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).PurgeArtifacts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetadataService_PurgeArtifacts_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).PurgeArtifacts(ctx, req.(*PurgeArtifactsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_CreateContext_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateContextRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).CreateContext(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetadataService_CreateContext_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).CreateContext(ctx, req.(*CreateContextRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_GetContext_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetContextRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).GetContext(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetadataService_GetContext_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).GetContext(ctx, req.(*GetContextRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_ListContexts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListContextsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).ListContexts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetadataService_ListContexts_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).ListContexts(ctx, req.(*ListContextsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_UpdateContext_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateContextRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).UpdateContext(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetadataService_UpdateContext_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).UpdateContext(ctx, req.(*UpdateContextRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_DeleteContext_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteContextRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).DeleteContext(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetadataService_DeleteContext_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).DeleteContext(ctx, req.(*DeleteContextRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_PurgeContexts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PurgeContextsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).PurgeContexts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetadataService_PurgeContexts_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).PurgeContexts(ctx, req.(*PurgeContextsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_AddContextArtifactsAndExecutions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddContextArtifactsAndExecutionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).AddContextArtifactsAndExecutions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetadataService_AddContextArtifactsAndExecutions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).AddContextArtifactsAndExecutions(ctx, req.(*AddContextArtifactsAndExecutionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_AddContextChildren_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddContextChildrenRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).AddContextChildren(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetadataService_AddContextChildren_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).AddContextChildren(ctx, req.(*AddContextChildrenRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_RemoveContextChildren_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveContextChildrenRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).RemoveContextChildren(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetadataService_RemoveContextChildren_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).RemoveContextChildren(ctx, req.(*RemoveContextChildrenRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_QueryContextLineageSubgraph_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueryContextLineageSubgraphRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).QueryContextLineageSubgraph(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetadataService_QueryContextLineageSubgraph_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).QueryContextLineageSubgraph(ctx, req.(*QueryContextLineageSubgraphRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_CreateExecution_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateExecutionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).CreateExecution(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetadataService_CreateExecution_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).CreateExecution(ctx, req.(*CreateExecutionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_GetExecution_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetExecutionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).GetExecution(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetadataService_GetExecution_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).GetExecution(ctx, req.(*GetExecutionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_ListExecutions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListExecutionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).ListExecutions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetadataService_ListExecutions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).ListExecutions(ctx, req.(*ListExecutionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_UpdateExecution_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateExecutionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).UpdateExecution(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetadataService_UpdateExecution_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).UpdateExecution(ctx, req.(*UpdateExecutionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_DeleteExecution_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteExecutionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).DeleteExecution(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetadataService_DeleteExecution_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).DeleteExecution(ctx, req.(*DeleteExecutionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_PurgeExecutions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PurgeExecutionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).PurgeExecutions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetadataService_PurgeExecutions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).PurgeExecutions(ctx, req.(*PurgeExecutionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_AddExecutionEvents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddExecutionEventsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).AddExecutionEvents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetadataService_AddExecutionEvents_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).AddExecutionEvents(ctx, req.(*AddExecutionEventsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_QueryExecutionInputsAndOutputs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueryExecutionInputsAndOutputsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).QueryExecutionInputsAndOutputs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetadataService_QueryExecutionInputsAndOutputs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).QueryExecutionInputsAndOutputs(ctx, req.(*QueryExecutionInputsAndOutputsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_CreateMetadataSchema_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateMetadataSchemaRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).CreateMetadataSchema(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetadataService_CreateMetadataSchema_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).CreateMetadataSchema(ctx, req.(*CreateMetadataSchemaRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_GetMetadataSchema_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMetadataSchemaRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).GetMetadataSchema(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetadataService_GetMetadataSchema_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).GetMetadataSchema(ctx, req.(*GetMetadataSchemaRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_ListMetadataSchemas_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListMetadataSchemasRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).ListMetadataSchemas(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetadataService_ListMetadataSchemas_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).ListMetadataSchemas(ctx, req.(*ListMetadataSchemasRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_QueryArtifactLineageSubgraph_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueryArtifactLineageSubgraphRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).QueryArtifactLineageSubgraph(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetadataService_QueryArtifactLineageSubgraph_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).QueryArtifactLineageSubgraph(ctx, req.(*QueryArtifactLineageSubgraphRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// MetadataService_ServiceDesc is the grpc.ServiceDesc for MetadataService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var MetadataService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.aiplatform.v1.MetadataService",
	HandlerType: (*MetadataServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateMetadataStore",
			Handler:    _MetadataService_CreateMetadataStore_Handler,
		},
		{
			MethodName: "GetMetadataStore",
			Handler:    _MetadataService_GetMetadataStore_Handler,
		},
		{
			MethodName: "ListMetadataStores",
			Handler:    _MetadataService_ListMetadataStores_Handler,
		},
		{
			MethodName: "DeleteMetadataStore",
			Handler:    _MetadataService_DeleteMetadataStore_Handler,
		},
		{
			MethodName: "CreateArtifact",
			Handler:    _MetadataService_CreateArtifact_Handler,
		},
		{
			MethodName: "GetArtifact",
			Handler:    _MetadataService_GetArtifact_Handler,
		},
		{
			MethodName: "ListArtifacts",
			Handler:    _MetadataService_ListArtifacts_Handler,
		},
		{
			MethodName: "UpdateArtifact",
			Handler:    _MetadataService_UpdateArtifact_Handler,
		},
		{
			MethodName: "DeleteArtifact",
			Handler:    _MetadataService_DeleteArtifact_Handler,
		},
		{
			MethodName: "PurgeArtifacts",
			Handler:    _MetadataService_PurgeArtifacts_Handler,
		},
		{
			MethodName: "CreateContext",
			Handler:    _MetadataService_CreateContext_Handler,
		},
		{
			MethodName: "GetContext",
			Handler:    _MetadataService_GetContext_Handler,
		},
		{
			MethodName: "ListContexts",
			Handler:    _MetadataService_ListContexts_Handler,
		},
		{
			MethodName: "UpdateContext",
			Handler:    _MetadataService_UpdateContext_Handler,
		},
		{
			MethodName: "DeleteContext",
			Handler:    _MetadataService_DeleteContext_Handler,
		},
		{
			MethodName: "PurgeContexts",
			Handler:    _MetadataService_PurgeContexts_Handler,
		},
		{
			MethodName: "AddContextArtifactsAndExecutions",
			Handler:    _MetadataService_AddContextArtifactsAndExecutions_Handler,
		},
		{
			MethodName: "AddContextChildren",
			Handler:    _MetadataService_AddContextChildren_Handler,
		},
		{
			MethodName: "RemoveContextChildren",
			Handler:    _MetadataService_RemoveContextChildren_Handler,
		},
		{
			MethodName: "QueryContextLineageSubgraph",
			Handler:    _MetadataService_QueryContextLineageSubgraph_Handler,
		},
		{
			MethodName: "CreateExecution",
			Handler:    _MetadataService_CreateExecution_Handler,
		},
		{
			MethodName: "GetExecution",
			Handler:    _MetadataService_GetExecution_Handler,
		},
		{
			MethodName: "ListExecutions",
			Handler:    _MetadataService_ListExecutions_Handler,
		},
		{
			MethodName: "UpdateExecution",
			Handler:    _MetadataService_UpdateExecution_Handler,
		},
		{
			MethodName: "DeleteExecution",
			Handler:    _MetadataService_DeleteExecution_Handler,
		},
		{
			MethodName: "PurgeExecutions",
			Handler:    _MetadataService_PurgeExecutions_Handler,
		},
		{
			MethodName: "AddExecutionEvents",
			Handler:    _MetadataService_AddExecutionEvents_Handler,
		},
		{
			MethodName: "QueryExecutionInputsAndOutputs",
			Handler:    _MetadataService_QueryExecutionInputsAndOutputs_Handler,
		},
		{
			MethodName: "CreateMetadataSchema",
			Handler:    _MetadataService_CreateMetadataSchema_Handler,
		},
		{
			MethodName: "GetMetadataSchema",
			Handler:    _MetadataService_GetMetadataSchema_Handler,
		},
		{
			MethodName: "ListMetadataSchemas",
			Handler:    _MetadataService_ListMetadataSchemas_Handler,
		},
		{
			MethodName: "QueryArtifactLineageSubgraph",
			Handler:    _MetadataService_QueryArtifactLineageSubgraph_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/aiplatform/v1/metadata_service.proto",
}
