// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/webrisk/v1beta1/webrisk.proto

package webriskpb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	WebRiskServiceV1Beta1_ComputeThreatListDiff_FullMethodName = "/google.cloud.webrisk.v1beta1.WebRiskServiceV1Beta1/ComputeThreatListDiff"
	WebRiskServiceV1Beta1_SearchUris_FullMethodName            = "/google.cloud.webrisk.v1beta1.WebRiskServiceV1Beta1/SearchUris"
	WebRiskServiceV1Beta1_SearchHashes_FullMethodName          = "/google.cloud.webrisk.v1beta1.WebRiskServiceV1Beta1/SearchHashes"
)

// WebRiskServiceV1Beta1Client is the client API for WebRiskServiceV1Beta1 service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type WebRiskServiceV1Beta1Client interface {
	// Gets the most recent threat list diffs.
	ComputeThreatListDiff(ctx context.Context, in *ComputeThreatListDiffRequest, opts ...grpc.CallOption) (*ComputeThreatListDiffResponse, error)
	// This method is used to check whether a URI is on a given threatList.
	SearchUris(ctx context.Context, in *SearchUrisRequest, opts ...grpc.CallOption) (*SearchUrisResponse, error)
	// Gets the full hashes that match the requested hash prefix.
	// This is used after a hash prefix is looked up in a threatList
	// and there is a match. The client side threatList only holds partial hashes
	// so the client must query this method to determine if there is a full
	// hash match of a threat.
	SearchHashes(ctx context.Context, in *SearchHashesRequest, opts ...grpc.CallOption) (*SearchHashesResponse, error)
}

type webRiskServiceV1Beta1Client struct {
	cc grpc.ClientConnInterface
}

func NewWebRiskServiceV1Beta1Client(cc grpc.ClientConnInterface) WebRiskServiceV1Beta1Client {
	return &webRiskServiceV1Beta1Client{cc}
}

func (c *webRiskServiceV1Beta1Client) ComputeThreatListDiff(ctx context.Context, in *ComputeThreatListDiffRequest, opts ...grpc.CallOption) (*ComputeThreatListDiffResponse, error) {
	out := new(ComputeThreatListDiffResponse)
	err := c.cc.Invoke(ctx, WebRiskServiceV1Beta1_ComputeThreatListDiff_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *webRiskServiceV1Beta1Client) SearchUris(ctx context.Context, in *SearchUrisRequest, opts ...grpc.CallOption) (*SearchUrisResponse, error) {
	out := new(SearchUrisResponse)
	err := c.cc.Invoke(ctx, WebRiskServiceV1Beta1_SearchUris_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *webRiskServiceV1Beta1Client) SearchHashes(ctx context.Context, in *SearchHashesRequest, opts ...grpc.CallOption) (*SearchHashesResponse, error) {
	out := new(SearchHashesResponse)
	err := c.cc.Invoke(ctx, WebRiskServiceV1Beta1_SearchHashes_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// WebRiskServiceV1Beta1Server is the server API for WebRiskServiceV1Beta1 service.
// All implementations should embed UnimplementedWebRiskServiceV1Beta1Server
// for forward compatibility
type WebRiskServiceV1Beta1Server interface {
	// Gets the most recent threat list diffs.
	ComputeThreatListDiff(context.Context, *ComputeThreatListDiffRequest) (*ComputeThreatListDiffResponse, error)
	// This method is used to check whether a URI is on a given threatList.
	SearchUris(context.Context, *SearchUrisRequest) (*SearchUrisResponse, error)
	// Gets the full hashes that match the requested hash prefix.
	// This is used after a hash prefix is looked up in a threatList
	// and there is a match. The client side threatList only holds partial hashes
	// so the client must query this method to determine if there is a full
	// hash match of a threat.
	SearchHashes(context.Context, *SearchHashesRequest) (*SearchHashesResponse, error)
}

// UnimplementedWebRiskServiceV1Beta1Server should be embedded to have forward compatible implementations.
type UnimplementedWebRiskServiceV1Beta1Server struct {
}

func (UnimplementedWebRiskServiceV1Beta1Server) ComputeThreatListDiff(context.Context, *ComputeThreatListDiffRequest) (*ComputeThreatListDiffResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ComputeThreatListDiff not implemented")
}
func (UnimplementedWebRiskServiceV1Beta1Server) SearchUris(context.Context, *SearchUrisRequest) (*SearchUrisResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchUris not implemented")
}
func (UnimplementedWebRiskServiceV1Beta1Server) SearchHashes(context.Context, *SearchHashesRequest) (*SearchHashesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchHashes not implemented")
}

// UnsafeWebRiskServiceV1Beta1Server may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to WebRiskServiceV1Beta1Server will
// result in compilation errors.
type UnsafeWebRiskServiceV1Beta1Server interface {
	mustEmbedUnimplementedWebRiskServiceV1Beta1Server()
}

func RegisterWebRiskServiceV1Beta1Server(s grpc.ServiceRegistrar, srv WebRiskServiceV1Beta1Server) {
	s.RegisterService(&WebRiskServiceV1Beta1_ServiceDesc, srv)
}

func _WebRiskServiceV1Beta1_ComputeThreatListDiff_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ComputeThreatListDiffRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WebRiskServiceV1Beta1Server).ComputeThreatListDiff(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: WebRiskServiceV1Beta1_ComputeThreatListDiff_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WebRiskServiceV1Beta1Server).ComputeThreatListDiff(ctx, req.(*ComputeThreatListDiffRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WebRiskServiceV1Beta1_SearchUris_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchUrisRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WebRiskServiceV1Beta1Server).SearchUris(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: WebRiskServiceV1Beta1_SearchUris_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WebRiskServiceV1Beta1Server).SearchUris(ctx, req.(*SearchUrisRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WebRiskServiceV1Beta1_SearchHashes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchHashesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WebRiskServiceV1Beta1Server).SearchHashes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: WebRiskServiceV1Beta1_SearchHashes_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WebRiskServiceV1Beta1Server).SearchHashes(ctx, req.(*SearchHashesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// WebRiskServiceV1Beta1_ServiceDesc is the grpc.ServiceDesc for WebRiskServiceV1Beta1 service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var WebRiskServiceV1Beta1_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.webrisk.v1beta1.WebRiskServiceV1Beta1",
	HandlerType: (*WebRiskServiceV1Beta1Server)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ComputeThreatListDiff",
			Handler:    _WebRiskServiceV1Beta1_ComputeThreatListDiff_Handler,
		},
		{
			MethodName: "SearchUris",
			Handler:    _WebRiskServiceV1Beta1_SearchUris_Handler,
		},
		{
			MethodName: "SearchHashes",
			Handler:    _WebRiskServiceV1Beta1_SearchHashes_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/webrisk/v1beta1/webrisk.proto",
}
