# JD V2

## What should before and after context look like for nested lists?

- need context for producing minimal diffs
- so we can insert an element into the middle of a list
- patch must apply only once so we need to add enough context

A:

```json
[[1,2,3],[4,6],[7,8,9]]

```

B:

```json
[[1,2,3],[4,5,6],[7,8,9]]
```

D:

```diff
@ [1,1]
  4
+ 5
  6
```

- the `4` and `6` are compared for equality
- no context means "end of list" or "beginning of list"

A:

```json
[2,3]
```

B:

```json
[1,2,3]
```

D:

```diff
@ [0]
+ 1
  2
```

- if a patch doesn't have enough context to prevent double application, more context is added

A:

```json
[1,2,2,3]
```

B:

```json
[1,2,2,2,3]
```

D:

```diff
@ [2]
  1
+ 2
  2
  2
  3
```

- the `3` prevents double application

## What should metadata look like?

- metadata applying to entire hunk (not just path) is a separate line
- version (2)
- merge patch behavior

```diff
^ {"version":"2"}
@ ["foo"]
- "bar"
+ "baz"
```

```diff
^ {"version":2,"merge":true}
@ ["foo"]
- "bar"
+ "baz"
```

```diff
^ {"version":2}
^ {"merge":true}
@ ["foo"]
- "bar"
+ "baz"
```

```diff
^ {"version":2}
^ {"merge":true}
^ {"tolerance": {"path": ["foo","number"], e: 0.000001}}
@ ["foo"]
- "bar"
+ "baz"
```

- metadata lines are additive
- so you can say `^ {"version":"2"}` once at the top of the file
- and it will be inherited by all subsequent hunks
- this leaves things more open for extension in the future

## What about in-path metadata?

- no more metadata in a list (`[["multiset"],{}]`)
- still objects mean set
- object in list means multiset
- object with keys means object identity
- other use cases are now in the line-level `^` metadata object

Set:

```diff
@ ["foo",{"id":"bar"}]
```

Multiset:

```diff
@ ["foo",[{"id":"bar"}]]
```

## Set and Multiset paths

- sets a noted as `{}` or another object with keys
- example: `@ ["foo", {}]`
- example: `@ ["foo", {"bar":1}, "baz"]`
- multisets are noted as `[]` or an array with an object with keys
- example: `@ ["foo", []]`
- example: `@ ["foo", [{"bar":1}], "baz"]`

