/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.util;

import java.io.Serializable;
import java.util.stream.IntStream;

public final class IntRange
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int _min;
    private final int _max;

    private IntRange(int min, int max) {
        if (min > max) {
            throw new IllegalArgumentException(String.format("Min greater than max: %s > %s", min, max));
        }
        this._min = min;
        this._max = max;
    }

    public int getMin() {
        return this._min;
    }

    public int getMax() {
        return this._max;
    }

    public int size() {
        return this._max - this._min;
    }

    public IntStream stream() {
        return IntStream.range(this._min, this._max);
    }

    public static IntRange of(int min, int max) {
        return new IntRange(min, max);
    }

    public static IntRange of(int value) {
        return IntRange.of(value, value + 1);
    }

    public int hashCode() {
        return this._min + 31 * this._max;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof IntRange && this._min == ((IntRange)obj)._min && this._max == ((IntRange)obj)._max;
    }

    public String toString() {
        return "[" + this._min + ", " + this._max + "]";
    }
}

