/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.engine;

import io.jenetics.Gene;
import io.jenetics.Genotype;
import io.jenetics.Phenotype;
import io.jenetics.engine.EvolutionInit;
import io.jenetics.engine.EvolutionResult;
import io.jenetics.engine.EvolutionStart;
import io.jenetics.engine.EvolutionStream;
import io.jenetics.engine.Limits;
import io.jenetics.util.ISeq;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;

public interface EvolutionStreamable<G extends Gene<?, G>, C extends Comparable<? super C>> {
    public EvolutionStream<G, C> stream(Supplier<EvolutionStart<G, C>> var1);

    public EvolutionStream<G, C> stream(EvolutionInit<G> var1);

    default public EvolutionStream<G, C> stream() {
        return this.stream(() -> EvolutionStart.of(ISeq.empty(), 1L));
    }

    default public EvolutionStream<G, C> stream(EvolutionStart<G, C> start) {
        return this.stream(() -> start);
    }

    default public EvolutionStream<G, C> stream(EvolutionResult<G, C> result) {
        return this.stream(EvolutionStart.of(result.getPopulation(), result.getGeneration()));
    }

    default public EvolutionStream<G, C> stream(ISeq<Phenotype<G, C>> population, long generation) {
        return this.stream(EvolutionStart.of(population, generation));
    }

    default public EvolutionStream<G, C> stream(ISeq<Phenotype<G, C>> population) {
        return this.stream(EvolutionStart.of(population, 1L));
    }

    default public EvolutionStream<G, C> stream(Iterable<Genotype<G>> genotypes, long generation) {
        return this.stream(EvolutionInit.of(ISeq.of(genotypes), generation));
    }

    default public EvolutionStream<G, C> stream(Iterable<Genotype<G>> genotypes) {
        return this.stream(genotypes, 1L);
    }

    default public EvolutionStreamable<G, C> limit(final Supplier<Predicate<? super EvolutionResult<G, C>>> proceed) {
        Objects.requireNonNull(proceed);
        return new EvolutionStreamable<G, C>(){

            @Override
            public EvolutionStream<G, C> stream(Supplier<EvolutionStart<G, C>> start) {
                return EvolutionStreamable.this.stream(start).limit((Predicate)proceed.get());
            }

            @Override
            public EvolutionStream<G, C> stream(EvolutionInit<G> init) {
                return EvolutionStreamable.this.stream(init).limit((Predicate)proceed.get());
            }
        };
    }

    default public EvolutionStreamable<G, C> limit(long generations) {
        return this.limit(() -> Limits.byFixedGeneration(generations));
    }
}

