package graphemes_test

// generated by github.com/clipperhouse/uax29/v2
// from https://www.unicode.org/Public/17.0.0/ucd/auxiliary/GraphemeBreakTest.txt

type unicodeTest struct {
	input    []byte
	expected [][]byte
	comment  string
}

var unicodeTests = [766]unicodeTest{
	{
		input:    []byte{0xd, 0xd},
		expected: [][]byte{{0xd}, {0xd}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xa},
		expected: [][]byte{{0xd, 0xa}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) × [3.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0x0},
		expected: [][]byte{{0xd}, {0x0}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] <NULL> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0x0},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0x0}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <NULL> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xe0, 0xa5, 0x8d},
		expected: [][]byte{{0xd}, {0xe0, 0xa5, 0x8d}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0xe0, 0xa5, 0x8d},
		expected: [][]byte{{0xd}, {0xcc, 0x88, 0xe0, 0xa5, 0x8d}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x80},
		expected: [][]byte{{0xd}, {0xcc, 0x80}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0xd}, {0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xe2, 0x80, 0x8c},
		expected: [][]byte{{0xd}, {0xe2, 0x80, 0x8c}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0xe2, 0x80, 0x8c},
		expected: [][]byte{{0xd}, {0xcc, 0x88, 0xe2, 0x80, 0x8c}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xd}, {0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xd}, {0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xd}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xdb, 0x9d},
		expected: [][]byte{{0xd}, {0xdb, 0x9d}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0xdb, 0x9d},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0xdb, 0x9d}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0xd}, {0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0xd}, {0xcc, 0x88, 0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xd}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0xd}, {0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0xd}, {0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0xd}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0xd}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xe0, 0xa4, 0x95},
		expected: [][]byte{{0xd}, {0xe0, 0xa4, 0x95}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0xe0, 0xa4, 0x95},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0xe0, 0xa4, 0x95}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xc2, 0xa9},
		expected: [][]byte{{0xd}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0xc2, 0xa9},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0x20},
		expected: [][]byte{{0xd}, {0x20}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcd, 0xb8},
		expected: [][]byte{{0xd}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0xcd, 0xb8},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xd},
		expected: [][]byte{{0xa}, {0xd}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xa},
		expected: [][]byte{{0xa}, {0xa}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0x0},
		expected: [][]byte{{0xa}, {0x0}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] <NULL> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0x0},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0x0}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <NULL> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xe0, 0xa5, 0x8d},
		expected: [][]byte{{0xa}, {0xe0, 0xa5, 0x8d}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0xe0, 0xa5, 0x8d},
		expected: [][]byte{{0xa}, {0xcc, 0x88, 0xe0, 0xa5, 0x8d}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x80},
		expected: [][]byte{{0xa}, {0xcc, 0x80}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0xa}, {0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xe2, 0x80, 0x8c},
		expected: [][]byte{{0xa}, {0xe2, 0x80, 0x8c}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0xe2, 0x80, 0x8c},
		expected: [][]byte{{0xa}, {0xcc, 0x88, 0xe2, 0x80, 0x8c}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xa}, {0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xa}, {0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xa}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xdb, 0x9d},
		expected: [][]byte{{0xa}, {0xdb, 0x9d}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0xdb, 0x9d},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0xdb, 0x9d}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0xa}, {0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0xa}, {0xcc, 0x88, 0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xa}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0xa}, {0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0xa}, {0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0xa}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0xa}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xe0, 0xa4, 0x95},
		expected: [][]byte{{0xa}, {0xe0, 0xa4, 0x95}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0xe0, 0xa4, 0x95},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0xe0, 0xa4, 0x95}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xc2, 0xa9},
		expected: [][]byte{{0xa}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0xc2, 0xa9},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0x20},
		expected: [][]byte{{0xa}, {0x20}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcd, 0xb8},
		expected: [][]byte{{0xa}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0xcd, 0xb8},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xd},
		expected: [][]byte{{0x0}, {0xd}},
		comment:  "÷ [0.2] <NULL> (Control) ÷ [4.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0x0}, {0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] <NULL> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xa},
		expected: [][]byte{{0x0}, {0xa}},
		comment:  "÷ [0.2] <NULL> (Control) ÷ [4.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0x0}, {0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] <NULL> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0x0},
		expected: [][]byte{{0x0}, {0x0}},
		comment:  "÷ [0.2] <NULL> (Control) ÷ [4.0] <NULL> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x88, 0x0},
		expected: [][]byte{{0x0}, {0xcc, 0x88}, {0x0}},
		comment:  "÷ [0.2] <NULL> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <NULL> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xe0, 0xa5, 0x8d},
		expected: [][]byte{{0x0}, {0xe0, 0xa5, 0x8d}},
		comment:  "÷ [0.2] <NULL> (Control) ÷ [4.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x88, 0xe0, 0xa5, 0x8d},
		expected: [][]byte{{0x0}, {0xcc, 0x88, 0xe0, 0xa5, 0x8d}},
		comment:  "÷ [0.2] <NULL> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x80},
		expected: [][]byte{{0x0}, {0xcc, 0x80}},
		comment:  "÷ [0.2] <NULL> (Control) ÷ [4.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0x0}, {0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] <NULL> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xe2, 0x80, 0x8c},
		expected: [][]byte{{0x0}, {0xe2, 0x80, 0x8c}},
		comment:  "÷ [0.2] <NULL> (Control) ÷ [4.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x88, 0xe2, 0x80, 0x8c},
		expected: [][]byte{{0x0}, {0xcc, 0x88, 0xe2, 0x80, 0x8c}},
		comment:  "÷ [0.2] <NULL> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x0}, {0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] <NULL> (Control) ÷ [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x0}, {0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] <NULL> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x0}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] <NULL> (Control) ÷ [4.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x0}, {0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] <NULL> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xdb, 0x9d},
		expected: [][]byte{{0x0}, {0xdb, 0x9d}},
		comment:  "÷ [0.2] <NULL> (Control) ÷ [4.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x88, 0xdb, 0x9d},
		expected: [][]byte{{0x0}, {0xcc, 0x88}, {0xdb, 0x9d}},
		comment:  "÷ [0.2] <NULL> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0x0}, {0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] <NULL> (Control) ÷ [4.0] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x88, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0x0}, {0xcc, 0x88, 0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] <NULL> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0x0}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] <NULL> (Control) ÷ [4.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x88, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0x0}, {0xcc, 0x88}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] <NULL> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0x0}, {0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] <NULL> (Control) ÷ [4.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x88, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0x0}, {0xcc, 0x88}, {0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] <NULL> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0x0}, {0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] <NULL> (Control) ÷ [4.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x88, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0x0}, {0xcc, 0x88}, {0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] <NULL> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0x0}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] <NULL> (Control) ÷ [4.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x88, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0x0}, {0xcc, 0x88}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] <NULL> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0x0}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] <NULL> (Control) ÷ [4.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x88, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0x0}, {0xcc, 0x88}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] <NULL> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xe0, 0xa4, 0x95},
		expected: [][]byte{{0x0}, {0xe0, 0xa4, 0x95}},
		comment:  "÷ [0.2] <NULL> (Control) ÷ [4.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x88, 0xe0, 0xa4, 0x95},
		expected: [][]byte{{0x0}, {0xcc, 0x88}, {0xe0, 0xa4, 0x95}},
		comment:  "÷ [0.2] <NULL> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xc2, 0xa9},
		expected: [][]byte{{0x0}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] <NULL> (Control) ÷ [4.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x88, 0xc2, 0xa9},
		expected: [][]byte{{0x0}, {0xcc, 0x88}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] <NULL> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0x20},
		expected: [][]byte{{0x0}, {0x20}},
		comment:  "÷ [0.2] <NULL> (Control) ÷ [4.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0x0}, {0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] <NULL> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcd, 0xb8},
		expected: [][]byte{{0x0}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] <NULL> (Control) ÷ [4.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x88, 0xcd, 0xb8},
		expected: [][]byte{{0x0}, {0xcc, 0x88}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] <NULL> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa5, 0x8d, 0xd},
		expected: [][]byte{{0xe0, 0xa5, 0x8d}, {0xd}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa5, 0x8d, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0xe0, 0xa5, 0x8d, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa5, 0x8d, 0xa},
		expected: [][]byte{{0xe0, 0xa5, 0x8d}, {0xa}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa5, 0x8d, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0xe0, 0xa5, 0x8d, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa5, 0x8d, 0x0},
		expected: [][]byte{{0xe0, 0xa5, 0x8d}, {0x0}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [5.0] <NULL> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa5, 0x8d, 0xcc, 0x88, 0x0},
		expected: [][]byte{{0xe0, 0xa5, 0x8d, 0xcc, 0x88}, {0x0}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <NULL> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa5, 0x8d, 0xe0, 0xa5, 0x8d},
		expected: [][]byte{{0xe0, 0xa5, 0x8d, 0xe0, 0xa5, 0x8d}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa5, 0x8d, 0xcc, 0x88, 0xe0, 0xa5, 0x8d},
		expected: [][]byte{{0xe0, 0xa5, 0x8d, 0xcc, 0x88, 0xe0, 0xa5, 0x8d}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa5, 0x8d, 0xcc, 0x80},
		expected: [][]byte{{0xe0, 0xa5, 0x8d, 0xcc, 0x80}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa5, 0x8d, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0xe0, 0xa5, 0x8d, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa5, 0x8d, 0xe2, 0x80, 0x8c},
		expected: [][]byte{{0xe0, 0xa5, 0x8d, 0xe2, 0x80, 0x8c}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa5, 0x8d, 0xcc, 0x88, 0xe2, 0x80, 0x8c},
		expected: [][]byte{{0xe0, 0xa5, 0x8d, 0xcc, 0x88, 0xe2, 0x80, 0x8c}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa5, 0x8d, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xe0, 0xa5, 0x8d, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa5, 0x8d, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xe0, 0xa5, 0x8d, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa5, 0x8d, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xe0, 0xa5, 0x8d}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa5, 0x8d, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xe0, 0xa5, 0x8d, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa5, 0x8d, 0xdb, 0x9d},
		expected: [][]byte{{0xe0, 0xa5, 0x8d}, {0xdb, 0x9d}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa5, 0x8d, 0xcc, 0x88, 0xdb, 0x9d},
		expected: [][]byte{{0xe0, 0xa5, 0x8d, 0xcc, 0x88}, {0xdb, 0x9d}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa5, 0x8d, 0xcc, 0x88, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0xe0, 0xa5, 0x8d, 0xcc, 0x88, 0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa5, 0x8d, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xe0, 0xa5, 0x8d}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa5, 0x8d, 0xcc, 0x88, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xe0, 0xa5, 0x8d, 0xcc, 0x88}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa5, 0x8d, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0xe0, 0xa5, 0x8d}, {0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa5, 0x8d, 0xcc, 0x88, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0xe0, 0xa5, 0x8d, 0xcc, 0x88}, {0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa5, 0x8d, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0xe0, 0xa5, 0x8d}, {0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa5, 0x8d, 0xcc, 0x88, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0xe0, 0xa5, 0x8d, 0xcc, 0x88}, {0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa5, 0x8d, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0xe0, 0xa5, 0x8d}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa5, 0x8d, 0xcc, 0x88, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0xe0, 0xa5, 0x8d, 0xcc, 0x88}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa5, 0x8d, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0xe0, 0xa5, 0x8d}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa5, 0x8d, 0xcc, 0x88, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0xe0, 0xa5, 0x8d, 0xcc, 0x88}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0x95},
		expected: [][]byte{{0xe0, 0xa5, 0x8d}, {0xe0, 0xa4, 0x95}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa5, 0x8d, 0xcc, 0x88, 0xe0, 0xa4, 0x95},
		expected: [][]byte{{0xe0, 0xa5, 0x8d, 0xcc, 0x88}, {0xe0, 0xa4, 0x95}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa5, 0x8d, 0xc2, 0xa9},
		expected: [][]byte{{0xe0, 0xa5, 0x8d}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa5, 0x8d, 0xcc, 0x88, 0xc2, 0xa9},
		expected: [][]byte{{0xe0, 0xa5, 0x8d, 0xcc, 0x88}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa5, 0x8d, 0x20},
		expected: [][]byte{{0xe0, 0xa5, 0x8d}, {0x20}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa5, 0x8d, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0xe0, 0xa5, 0x8d, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa5, 0x8d, 0xcd, 0xb8},
		expected: [][]byte{{0xe0, 0xa5, 0x8d}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa5, 0x8d, 0xcc, 0x88, 0xcd, 0xb8},
		expected: [][]byte{{0xe0, 0xa5, 0x8d, 0xcc, 0x88}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xd},
		expected: [][]byte{{0xcc, 0x80}, {0xd}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xa},
		expected: [][]byte{{0xcc, 0x80}, {0xa}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0x0},
		expected: [][]byte{{0xcc, 0x80}, {0x0}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <NULL> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0x0},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0x0}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <NULL> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xe0, 0xa5, 0x8d},
		expected: [][]byte{{0xcc, 0x80, 0xe0, 0xa5, 0x8d}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0xe0, 0xa5, 0x8d},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88, 0xe0, 0xa5, 0x8d}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x80},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x80}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xe2, 0x80, 0x8c},
		expected: [][]byte{{0xcc, 0x80, 0xe2, 0x80, 0x8c}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0xe2, 0x80, 0x8c},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88, 0xe2, 0x80, 0x8c}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xcc, 0x80, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xcc, 0x80}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xdb, 0x9d},
		expected: [][]byte{{0xcc, 0x80}, {0xdb, 0x9d}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0xdb, 0x9d},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0xdb, 0x9d}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0xcc, 0x80, 0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88, 0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xcc, 0x80}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0xcc, 0x80}, {0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0xcc, 0x80}, {0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0xcc, 0x80}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0xcc, 0x80}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xe0, 0xa4, 0x95},
		expected: [][]byte{{0xcc, 0x80}, {0xe0, 0xa4, 0x95}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0xe0, 0xa4, 0x95},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0xe0, 0xa4, 0x95}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xc2, 0xa9},
		expected: [][]byte{{0xcc, 0x80}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0xc2, 0xa9},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0x20},
		expected: [][]byte{{0xcc, 0x80}, {0x20}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcd, 0xb8},
		expected: [][]byte{{0xcc, 0x80}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0xcd, 0xb8},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8c, 0xd},
		expected: [][]byte{{0xe2, 0x80, 0x8c}, {0xd}},
		comment:  "÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8c, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0xe2, 0x80, 0x8c, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8c, 0xa},
		expected: [][]byte{{0xe2, 0x80, 0x8c}, {0xa}},
		comment:  "÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8c, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0xe2, 0x80, 0x8c, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8c, 0x0},
		expected: [][]byte{{0xe2, 0x80, 0x8c}, {0x0}},
		comment:  "÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [5.0] <NULL> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8c, 0xcc, 0x88, 0x0},
		expected: [][]byte{{0xe2, 0x80, 0x8c, 0xcc, 0x88}, {0x0}},
		comment:  "÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <NULL> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8c, 0xe0, 0xa5, 0x8d},
		expected: [][]byte{{0xe2, 0x80, 0x8c, 0xe0, 0xa5, 0x8d}},
		comment:  "÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8c, 0xcc, 0x88, 0xe0, 0xa5, 0x8d},
		expected: [][]byte{{0xe2, 0x80, 0x8c, 0xcc, 0x88, 0xe0, 0xa5, 0x8d}},
		comment:  "÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8c, 0xcc, 0x80},
		expected: [][]byte{{0xe2, 0x80, 0x8c, 0xcc, 0x80}},
		comment:  "÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8c, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0xe2, 0x80, 0x8c, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8c, 0xe2, 0x80, 0x8c},
		expected: [][]byte{{0xe2, 0x80, 0x8c, 0xe2, 0x80, 0x8c}},
		comment:  "÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8c, 0xcc, 0x88, 0xe2, 0x80, 0x8c},
		expected: [][]byte{{0xe2, 0x80, 0x8c, 0xcc, 0x88, 0xe2, 0x80, 0x8c}},
		comment:  "÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8c, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xe2, 0x80, 0x8c, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8c, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xe2, 0x80, 0x8c, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8c, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xe2, 0x80, 0x8c}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8c, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xe2, 0x80, 0x8c, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8c, 0xdb, 0x9d},
		expected: [][]byte{{0xe2, 0x80, 0x8c}, {0xdb, 0x9d}},
		comment:  "÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8c, 0xcc, 0x88, 0xdb, 0x9d},
		expected: [][]byte{{0xe2, 0x80, 0x8c, 0xcc, 0x88}, {0xdb, 0x9d}},
		comment:  "÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8c, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0xe2, 0x80, 0x8c, 0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8c, 0xcc, 0x88, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0xe2, 0x80, 0x8c, 0xcc, 0x88, 0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8c, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xe2, 0x80, 0x8c}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8c, 0xcc, 0x88, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xe2, 0x80, 0x8c, 0xcc, 0x88}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8c, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0xe2, 0x80, 0x8c}, {0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8c, 0xcc, 0x88, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0xe2, 0x80, 0x8c, 0xcc, 0x88}, {0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8c, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0xe2, 0x80, 0x8c}, {0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8c, 0xcc, 0x88, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0xe2, 0x80, 0x8c, 0xcc, 0x88}, {0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8c, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0xe2, 0x80, 0x8c}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8c, 0xcc, 0x88, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0xe2, 0x80, 0x8c, 0xcc, 0x88}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8c, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0xe2, 0x80, 0x8c}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8c, 0xcc, 0x88, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0xe2, 0x80, 0x8c, 0xcc, 0x88}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8c, 0xe0, 0xa4, 0x95},
		expected: [][]byte{{0xe2, 0x80, 0x8c}, {0xe0, 0xa4, 0x95}},
		comment:  "÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8c, 0xcc, 0x88, 0xe0, 0xa4, 0x95},
		expected: [][]byte{{0xe2, 0x80, 0x8c, 0xcc, 0x88}, {0xe0, 0xa4, 0x95}},
		comment:  "÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8c, 0xc2, 0xa9},
		expected: [][]byte{{0xe2, 0x80, 0x8c}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8c, 0xcc, 0x88, 0xc2, 0xa9},
		expected: [][]byte{{0xe2, 0x80, 0x8c, 0xcc, 0x88}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8c, 0x20},
		expected: [][]byte{{0xe2, 0x80, 0x8c}, {0x20}},
		comment:  "÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8c, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0xe2, 0x80, 0x8c, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8c, 0xcd, 0xb8},
		expected: [][]byte{{0xe2, 0x80, 0x8c}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8c, 0xcc, 0x88, 0xcd, 0xb8},
		expected: [][]byte{{0xe2, 0x80, 0x8c, 0xcc, 0x88}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xd},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0xd}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xa},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0xa}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0x0},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0x0}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) ÷ [5.0] <NULL> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0x0},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0x0}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <NULL> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xe0, 0xa5, 0x8d},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xe0, 0xa5, 0x8d}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xe0, 0xa5, 0x8d},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xe0, 0xa5, 0x8d}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x80},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x80}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xe2, 0x80, 0x8c},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xe2, 0x80, 0x8c}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xe2, 0x80, 0x8c},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xe2, 0x80, 0x8c}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xdb, 0x9d},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0xdb, 0x9d}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xdb, 0x9d},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0xdb, 0x9d}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xe0, 0xa4, 0x95},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0xe0, 0xa4, 0x95}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xe0, 0xa4, 0x95},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0xe0, 0xa4, 0x95}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xc2, 0xa9},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xc2, 0xa9},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0x20},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0x20}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcd, 0xb8},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xcd, 0xb8},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xd},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0xd}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xa},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0xa}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0x0},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0x0}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [5.0] <NULL> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0x0},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0x0}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <NULL> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xe0, 0xa5, 0x8d},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xe0, 0xa5, 0x8d}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xe0, 0xa5, 0x8d},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xe0, 0xa5, 0x8d}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x80},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x80}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xe2, 0x80, 0x8c},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xe2, 0x80, 0x8c}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xe2, 0x80, 0x8c},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xe2, 0x80, 0x8c}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [12.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xdb, 0x9d},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0xdb, 0x9d}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xdb, 0x9d},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0xdb, 0x9d}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xe0, 0xa4, 0x95},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0xe0, 0xa4, 0x95}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xe0, 0xa4, 0x95},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0xe0, 0xa4, 0x95}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xc2, 0xa9},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xc2, 0xa9},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0x20},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0x20}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcd, 0xb8},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xcd, 0xb8},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xdb, 0x9d, 0xd},
		expected: [][]byte{{0xdb, 0x9d}, {0xd}},
		comment:  "÷ [0.2] ARABIC END OF AYAH (Prepend) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xdb, 0x9d, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0xdb, 0x9d, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xdb, 0x9d, 0xa},
		expected: [][]byte{{0xdb, 0x9d}, {0xa}},
		comment:  "÷ [0.2] ARABIC END OF AYAH (Prepend) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xdb, 0x9d, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0xdb, 0x9d, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xdb, 0x9d, 0x0},
		expected: [][]byte{{0xdb, 0x9d}, {0x0}},
		comment:  "÷ [0.2] ARABIC END OF AYAH (Prepend) ÷ [5.0] <NULL> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0xdb, 0x9d, 0xcc, 0x88, 0x0},
		expected: [][]byte{{0xdb, 0x9d, 0xcc, 0x88}, {0x0}},
		comment:  "÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <NULL> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0xdb, 0x9d, 0xe0, 0xa5, 0x8d},
		expected: [][]byte{{0xdb, 0x9d, 0xe0, 0xa5, 0x8d}},
		comment:  "÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xdb, 0x9d, 0xcc, 0x88, 0xe0, 0xa5, 0x8d},
		expected: [][]byte{{0xdb, 0x9d, 0xcc, 0x88, 0xe0, 0xa5, 0x8d}},
		comment:  "÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xdb, 0x9d, 0xcc, 0x80},
		expected: [][]byte{{0xdb, 0x9d, 0xcc, 0x80}},
		comment:  "÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xdb, 0x9d, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0xdb, 0x9d, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xdb, 0x9d, 0xe2, 0x80, 0x8c},
		expected: [][]byte{{0xdb, 0x9d, 0xe2, 0x80, 0x8c}},
		comment:  "÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]",
	},
	{
		input:    []byte{0xdb, 0x9d, 0xcc, 0x88, 0xe2, 0x80, 0x8c},
		expected: [][]byte{{0xdb, 0x9d, 0xcc, 0x88, 0xe2, 0x80, 0x8c}},
		comment:  "÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]",
	},
	{
		input:    []byte{0xdb, 0x9d, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xdb, 0x9d, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0xdb, 0x9d, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xdb, 0x9d, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0xdb, 0x9d, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xdb, 0x9d, 0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xdb, 0x9d, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xdb, 0x9d, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xdb, 0x9d, 0xdb, 0x9d},
		expected: [][]byte{{0xdb, 0x9d, 0xdb, 0x9d}},
		comment:  "÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.2] ARABIC END OF AYAH (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0xdb, 0x9d, 0xcc, 0x88, 0xdb, 0x9d},
		expected: [][]byte{{0xdb, 0x9d, 0xcc, 0x88}, {0xdb, 0x9d}},
		comment:  "÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0xdb, 0x9d, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0xdb, 0x9d, 0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0xdb, 0x9d, 0xcc, 0x88, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0xdb, 0x9d, 0xcc, 0x88, 0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0xdb, 0x9d, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xdb, 0x9d, 0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.2] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xdb, 0x9d, 0xcc, 0x88, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xdb, 0x9d, 0xcc, 0x88}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xdb, 0x9d, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0xdb, 0x9d, 0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.2] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0xdb, 0x9d, 0xcc, 0x88, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0xdb, 0x9d, 0xcc, 0x88}, {0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0xdb, 0x9d, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0xdb, 0x9d, 0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.2] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0xdb, 0x9d, 0xcc, 0x88, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0xdb, 0x9d, 0xcc, 0x88}, {0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0xdb, 0x9d, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0xdb, 0x9d, 0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.2] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0xdb, 0x9d, 0xcc, 0x88, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0xdb, 0x9d, 0xcc, 0x88}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0xdb, 0x9d, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0xdb, 0x9d, 0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.2] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0xdb, 0x9d, 0xcc, 0x88, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0xdb, 0x9d, 0xcc, 0x88}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0xdb, 0x9d, 0xe0, 0xa4, 0x95},
		expected: [][]byte{{0xdb, 0x9d, 0xe0, 0xa4, 0x95}},
		comment:  "÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.2] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]",
	},
	{
		input:    []byte{0xdb, 0x9d, 0xcc, 0x88, 0xe0, 0xa4, 0x95},
		expected: [][]byte{{0xdb, 0x9d, 0xcc, 0x88}, {0xe0, 0xa4, 0x95}},
		comment:  "÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]",
	},
	{
		input:    []byte{0xdb, 0x9d, 0xc2, 0xa9},
		expected: [][]byte{{0xdb, 0x9d, 0xc2, 0xa9}},
		comment:  "÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.2] COPYRIGHT SIGN (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xdb, 0x9d, 0xcc, 0x88, 0xc2, 0xa9},
		expected: [][]byte{{0xdb, 0x9d, 0xcc, 0x88}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xdb, 0x9d, 0x20},
		expected: [][]byte{{0xdb, 0x9d, 0x20}},
		comment:  "÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.2] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xdb, 0x9d, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0xdb, 0x9d, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xdb, 0x9d, 0xcd, 0xb8},
		expected: [][]byte{{0xdb, 0x9d, 0xcd, 0xb8}},
		comment:  "÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.2] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xdb, 0x9d, 0xcc, 0x88, 0xcd, 0xb8},
		expected: [][]byte{{0xdb, 0x9d, 0xcc, 0x88}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xd},
		expected: [][]byte{{0xe0, 0xa4, 0x83}, {0xd}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0xe0, 0xa4, 0x83, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xa},
		expected: [][]byte{{0xe0, 0xa4, 0x83}, {0xa}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0xe0, 0xa4, 0x83, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0x0},
		expected: [][]byte{{0xe0, 0xa4, 0x83}, {0x0}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [5.0] <NULL> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xcc, 0x88, 0x0},
		expected: [][]byte{{0xe0, 0xa4, 0x83, 0xcc, 0x88}, {0x0}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <NULL> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xe0, 0xa5, 0x8d},
		expected: [][]byte{{0xe0, 0xa4, 0x83, 0xe0, 0xa5, 0x8d}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xcc, 0x88, 0xe0, 0xa5, 0x8d},
		expected: [][]byte{{0xe0, 0xa4, 0x83, 0xcc, 0x88, 0xe0, 0xa5, 0x8d}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xcc, 0x80},
		expected: [][]byte{{0xe0, 0xa4, 0x83, 0xcc, 0x80}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0xe0, 0xa4, 0x83, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xe2, 0x80, 0x8c},
		expected: [][]byte{{0xe0, 0xa4, 0x83, 0xe2, 0x80, 0x8c}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xcc, 0x88, 0xe2, 0x80, 0x8c},
		expected: [][]byte{{0xe0, 0xa4, 0x83, 0xcc, 0x88, 0xe2, 0x80, 0x8c}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xe0, 0xa4, 0x83, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xe0, 0xa4, 0x83, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xe0, 0xa4, 0x83}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xe0, 0xa4, 0x83, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xdb, 0x9d},
		expected: [][]byte{{0xe0, 0xa4, 0x83}, {0xdb, 0x9d}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xcc, 0x88, 0xdb, 0x9d},
		expected: [][]byte{{0xe0, 0xa4, 0x83, 0xcc, 0x88}, {0xdb, 0x9d}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0xe0, 0xa4, 0x83, 0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xcc, 0x88, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0xe0, 0xa4, 0x83, 0xcc, 0x88, 0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xe0, 0xa4, 0x83}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xcc, 0x88, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xe0, 0xa4, 0x83, 0xcc, 0x88}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0xe0, 0xa4, 0x83}, {0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xcc, 0x88, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0xe0, 0xa4, 0x83, 0xcc, 0x88}, {0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0xe0, 0xa4, 0x83}, {0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xcc, 0x88, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0xe0, 0xa4, 0x83, 0xcc, 0x88}, {0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0xe0, 0xa4, 0x83}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xcc, 0x88, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0xe0, 0xa4, 0x83, 0xcc, 0x88}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0xe0, 0xa4, 0x83}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xcc, 0x88, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0xe0, 0xa4, 0x83, 0xcc, 0x88}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xe0, 0xa4, 0x95},
		expected: [][]byte{{0xe0, 0xa4, 0x83}, {0xe0, 0xa4, 0x95}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xcc, 0x88, 0xe0, 0xa4, 0x95},
		expected: [][]byte{{0xe0, 0xa4, 0x83, 0xcc, 0x88}, {0xe0, 0xa4, 0x95}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xc2, 0xa9},
		expected: [][]byte{{0xe0, 0xa4, 0x83}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xcc, 0x88, 0xc2, 0xa9},
		expected: [][]byte{{0xe0, 0xa4, 0x83, 0xcc, 0x88}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0x20},
		expected: [][]byte{{0xe0, 0xa4, 0x83}, {0x20}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0xe0, 0xa4, 0x83, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xcd, 0xb8},
		expected: [][]byte{{0xe0, 0xa4, 0x83}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xcc, 0x88, 0xcd, 0xb8},
		expected: [][]byte{{0xe0, 0xa4, 0x83, 0xcc, 0x88}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xd},
		expected: [][]byte{{0xe1, 0x84, 0x80}, {0xd}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0xe1, 0x84, 0x80, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xa},
		expected: [][]byte{{0xe1, 0x84, 0x80}, {0xa}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0xe1, 0x84, 0x80, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0x0},
		expected: [][]byte{{0xe1, 0x84, 0x80}, {0x0}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) ÷ [5.0] <NULL> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xcc, 0x88, 0x0},
		expected: [][]byte{{0xe1, 0x84, 0x80, 0xcc, 0x88}, {0x0}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <NULL> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xe0, 0xa5, 0x8d},
		expected: [][]byte{{0xe1, 0x84, 0x80, 0xe0, 0xa5, 0x8d}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xcc, 0x88, 0xe0, 0xa5, 0x8d},
		expected: [][]byte{{0xe1, 0x84, 0x80, 0xcc, 0x88, 0xe0, 0xa5, 0x8d}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xcc, 0x80},
		expected: [][]byte{{0xe1, 0x84, 0x80, 0xcc, 0x80}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0xe1, 0x84, 0x80, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xe2, 0x80, 0x8c},
		expected: [][]byte{{0xe1, 0x84, 0x80, 0xe2, 0x80, 0x8c}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xcc, 0x88, 0xe2, 0x80, 0x8c},
		expected: [][]byte{{0xe1, 0x84, 0x80, 0xcc, 0x88, 0xe2, 0x80, 0x8c}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xe1, 0x84, 0x80, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xe1, 0x84, 0x80, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xe1, 0x84, 0x80}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xe1, 0x84, 0x80, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xdb, 0x9d},
		expected: [][]byte{{0xe1, 0x84, 0x80}, {0xdb, 0x9d}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xcc, 0x88, 0xdb, 0x9d},
		expected: [][]byte{{0xe1, 0x84, 0x80, 0xcc, 0x88}, {0xdb, 0x9d}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0xe1, 0x84, 0x80, 0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xcc, 0x88, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0xe1, 0x84, 0x80, 0xcc, 0x88, 0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xe1, 0x84, 0x80, 0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [6.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xcc, 0x88, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xe1, 0x84, 0x80, 0xcc, 0x88}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0xe1, 0x84, 0x80, 0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [6.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xcc, 0x88, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0xe1, 0x84, 0x80, 0xcc, 0x88}, {0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0xe1, 0x84, 0x80}, {0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xcc, 0x88, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0xe1, 0x84, 0x80, 0xcc, 0x88}, {0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0xe1, 0x84, 0x80, 0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [6.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xcc, 0x88, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0xe1, 0x84, 0x80, 0xcc, 0x88}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0xe1, 0x84, 0x80, 0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [6.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xcc, 0x88, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0xe1, 0x84, 0x80, 0xcc, 0x88}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xe0, 0xa4, 0x95},
		expected: [][]byte{{0xe1, 0x84, 0x80}, {0xe0, 0xa4, 0x95}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xcc, 0x88, 0xe0, 0xa4, 0x95},
		expected: [][]byte{{0xe1, 0x84, 0x80, 0xcc, 0x88}, {0xe0, 0xa4, 0x95}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xc2, 0xa9},
		expected: [][]byte{{0xe1, 0x84, 0x80}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xcc, 0x88, 0xc2, 0xa9},
		expected: [][]byte{{0xe1, 0x84, 0x80, 0xcc, 0x88}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0x20},
		expected: [][]byte{{0xe1, 0x84, 0x80}, {0x20}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0xe1, 0x84, 0x80, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xcd, 0xb8},
		expected: [][]byte{{0xe1, 0x84, 0x80}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xcc, 0x88, 0xcd, 0xb8},
		expected: [][]byte{{0xe1, 0x84, 0x80, 0xcc, 0x88}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xd},
		expected: [][]byte{{0xe1, 0x85, 0xa0}, {0xd}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0xe1, 0x85, 0xa0, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xa},
		expected: [][]byte{{0xe1, 0x85, 0xa0}, {0xa}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0xe1, 0x85, 0xa0, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0x0},
		expected: [][]byte{{0xe1, 0x85, 0xa0}, {0x0}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [5.0] <NULL> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xcc, 0x88, 0x0},
		expected: [][]byte{{0xe1, 0x85, 0xa0, 0xcc, 0x88}, {0x0}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <NULL> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xe0, 0xa5, 0x8d},
		expected: [][]byte{{0xe1, 0x85, 0xa0, 0xe0, 0xa5, 0x8d}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xcc, 0x88, 0xe0, 0xa5, 0x8d},
		expected: [][]byte{{0xe1, 0x85, 0xa0, 0xcc, 0x88, 0xe0, 0xa5, 0x8d}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xcc, 0x80},
		expected: [][]byte{{0xe1, 0x85, 0xa0, 0xcc, 0x80}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0xe1, 0x85, 0xa0, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xe2, 0x80, 0x8c},
		expected: [][]byte{{0xe1, 0x85, 0xa0, 0xe2, 0x80, 0x8c}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xcc, 0x88, 0xe2, 0x80, 0x8c},
		expected: [][]byte{{0xe1, 0x85, 0xa0, 0xcc, 0x88, 0xe2, 0x80, 0x8c}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xe1, 0x85, 0xa0, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xe1, 0x85, 0xa0, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xe1, 0x85, 0xa0}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xe1, 0x85, 0xa0, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xdb, 0x9d},
		expected: [][]byte{{0xe1, 0x85, 0xa0}, {0xdb, 0x9d}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xcc, 0x88, 0xdb, 0x9d},
		expected: [][]byte{{0xe1, 0x85, 0xa0, 0xcc, 0x88}, {0xdb, 0x9d}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0xe1, 0x85, 0xa0, 0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xcc, 0x88, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0xe1, 0x85, 0xa0, 0xcc, 0x88, 0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xe1, 0x85, 0xa0}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xcc, 0x88, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xe1, 0x85, 0xa0, 0xcc, 0x88}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0xe1, 0x85, 0xa0, 0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [7.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xcc, 0x88, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0xe1, 0x85, 0xa0, 0xcc, 0x88}, {0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0xe1, 0x85, 0xa0, 0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [7.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xcc, 0x88, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0xe1, 0x85, 0xa0, 0xcc, 0x88}, {0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0xe1, 0x85, 0xa0}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xcc, 0x88, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0xe1, 0x85, 0xa0, 0xcc, 0x88}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0xe1, 0x85, 0xa0}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xcc, 0x88, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0xe1, 0x85, 0xa0, 0xcc, 0x88}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xe0, 0xa4, 0x95},
		expected: [][]byte{{0xe1, 0x85, 0xa0}, {0xe0, 0xa4, 0x95}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xcc, 0x88, 0xe0, 0xa4, 0x95},
		expected: [][]byte{{0xe1, 0x85, 0xa0, 0xcc, 0x88}, {0xe0, 0xa4, 0x95}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xc2, 0xa9},
		expected: [][]byte{{0xe1, 0x85, 0xa0}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xcc, 0x88, 0xc2, 0xa9},
		expected: [][]byte{{0xe1, 0x85, 0xa0, 0xcc, 0x88}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0x20},
		expected: [][]byte{{0xe1, 0x85, 0xa0}, {0x20}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0xe1, 0x85, 0xa0, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xcd, 0xb8},
		expected: [][]byte{{0xe1, 0x85, 0xa0}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xcc, 0x88, 0xcd, 0xb8},
		expected: [][]byte{{0xe1, 0x85, 0xa0, 0xcc, 0x88}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xd},
		expected: [][]byte{{0xe1, 0x86, 0xa8}, {0xd}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0xe1, 0x86, 0xa8, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xa},
		expected: [][]byte{{0xe1, 0x86, 0xa8}, {0xa}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0xe1, 0x86, 0xa8, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0x0},
		expected: [][]byte{{0xe1, 0x86, 0xa8}, {0x0}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [5.0] <NULL> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xcc, 0x88, 0x0},
		expected: [][]byte{{0xe1, 0x86, 0xa8, 0xcc, 0x88}, {0x0}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <NULL> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xe0, 0xa5, 0x8d},
		expected: [][]byte{{0xe1, 0x86, 0xa8, 0xe0, 0xa5, 0x8d}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xcc, 0x88, 0xe0, 0xa5, 0x8d},
		expected: [][]byte{{0xe1, 0x86, 0xa8, 0xcc, 0x88, 0xe0, 0xa5, 0x8d}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xcc, 0x80},
		expected: [][]byte{{0xe1, 0x86, 0xa8, 0xcc, 0x80}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0xe1, 0x86, 0xa8, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xe2, 0x80, 0x8c},
		expected: [][]byte{{0xe1, 0x86, 0xa8, 0xe2, 0x80, 0x8c}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xcc, 0x88, 0xe2, 0x80, 0x8c},
		expected: [][]byte{{0xe1, 0x86, 0xa8, 0xcc, 0x88, 0xe2, 0x80, 0x8c}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xe1, 0x86, 0xa8, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xe1, 0x86, 0xa8, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xe1, 0x86, 0xa8}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xe1, 0x86, 0xa8, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xdb, 0x9d},
		expected: [][]byte{{0xe1, 0x86, 0xa8}, {0xdb, 0x9d}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xcc, 0x88, 0xdb, 0x9d},
		expected: [][]byte{{0xe1, 0x86, 0xa8, 0xcc, 0x88}, {0xdb, 0x9d}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0xe1, 0x86, 0xa8, 0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xcc, 0x88, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0xe1, 0x86, 0xa8, 0xcc, 0x88, 0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xe1, 0x86, 0xa8}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xcc, 0x88, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xe1, 0x86, 0xa8, 0xcc, 0x88}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0xe1, 0x86, 0xa8}, {0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xcc, 0x88, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0xe1, 0x86, 0xa8, 0xcc, 0x88}, {0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0xe1, 0x86, 0xa8, 0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [8.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xcc, 0x88, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0xe1, 0x86, 0xa8, 0xcc, 0x88}, {0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0xe1, 0x86, 0xa8}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xcc, 0x88, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0xe1, 0x86, 0xa8, 0xcc, 0x88}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0xe1, 0x86, 0xa8}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xcc, 0x88, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0xe1, 0x86, 0xa8, 0xcc, 0x88}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xe0, 0xa4, 0x95},
		expected: [][]byte{{0xe1, 0x86, 0xa8}, {0xe0, 0xa4, 0x95}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xcc, 0x88, 0xe0, 0xa4, 0x95},
		expected: [][]byte{{0xe1, 0x86, 0xa8, 0xcc, 0x88}, {0xe0, 0xa4, 0x95}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xc2, 0xa9},
		expected: [][]byte{{0xe1, 0x86, 0xa8}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xcc, 0x88, 0xc2, 0xa9},
		expected: [][]byte{{0xe1, 0x86, 0xa8, 0xcc, 0x88}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0x20},
		expected: [][]byte{{0xe1, 0x86, 0xa8}, {0x20}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0xe1, 0x86, 0xa8, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xcd, 0xb8},
		expected: [][]byte{{0xe1, 0x86, 0xa8}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xcc, 0x88, 0xcd, 0xb8},
		expected: [][]byte{{0xe1, 0x86, 0xa8, 0xcc, 0x88}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xd},
		expected: [][]byte{{0xea, 0xb0, 0x80}, {0xd}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0xea, 0xb0, 0x80, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xa},
		expected: [][]byte{{0xea, 0xb0, 0x80}, {0xa}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0xea, 0xb0, 0x80, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0x0},
		expected: [][]byte{{0xea, 0xb0, 0x80}, {0x0}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [5.0] <NULL> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xcc, 0x88, 0x0},
		expected: [][]byte{{0xea, 0xb0, 0x80, 0xcc, 0x88}, {0x0}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <NULL> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xe0, 0xa5, 0x8d},
		expected: [][]byte{{0xea, 0xb0, 0x80, 0xe0, 0xa5, 0x8d}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xcc, 0x88, 0xe0, 0xa5, 0x8d},
		expected: [][]byte{{0xea, 0xb0, 0x80, 0xcc, 0x88, 0xe0, 0xa5, 0x8d}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xcc, 0x80},
		expected: [][]byte{{0xea, 0xb0, 0x80, 0xcc, 0x80}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0xea, 0xb0, 0x80, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xe2, 0x80, 0x8c},
		expected: [][]byte{{0xea, 0xb0, 0x80, 0xe2, 0x80, 0x8c}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xcc, 0x88, 0xe2, 0x80, 0x8c},
		expected: [][]byte{{0xea, 0xb0, 0x80, 0xcc, 0x88, 0xe2, 0x80, 0x8c}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xea, 0xb0, 0x80, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xea, 0xb0, 0x80, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xea, 0xb0, 0x80}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xea, 0xb0, 0x80, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xdb, 0x9d},
		expected: [][]byte{{0xea, 0xb0, 0x80}, {0xdb, 0x9d}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xcc, 0x88, 0xdb, 0x9d},
		expected: [][]byte{{0xea, 0xb0, 0x80, 0xcc, 0x88}, {0xdb, 0x9d}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0xea, 0xb0, 0x80, 0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xcc, 0x88, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0xea, 0xb0, 0x80, 0xcc, 0x88, 0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xea, 0xb0, 0x80}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xcc, 0x88, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xea, 0xb0, 0x80, 0xcc, 0x88}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0xea, 0xb0, 0x80, 0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) × [7.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xcc, 0x88, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0xea, 0xb0, 0x80, 0xcc, 0x88}, {0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0xea, 0xb0, 0x80, 0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) × [7.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xcc, 0x88, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0xea, 0xb0, 0x80, 0xcc, 0x88}, {0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0xea, 0xb0, 0x80}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xcc, 0x88, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0xea, 0xb0, 0x80, 0xcc, 0x88}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0xea, 0xb0, 0x80}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xcc, 0x88, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0xea, 0xb0, 0x80, 0xcc, 0x88}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xe0, 0xa4, 0x95},
		expected: [][]byte{{0xea, 0xb0, 0x80}, {0xe0, 0xa4, 0x95}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xcc, 0x88, 0xe0, 0xa4, 0x95},
		expected: [][]byte{{0xea, 0xb0, 0x80, 0xcc, 0x88}, {0xe0, 0xa4, 0x95}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xc2, 0xa9},
		expected: [][]byte{{0xea, 0xb0, 0x80}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xcc, 0x88, 0xc2, 0xa9},
		expected: [][]byte{{0xea, 0xb0, 0x80, 0xcc, 0x88}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0x20},
		expected: [][]byte{{0xea, 0xb0, 0x80}, {0x20}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0xea, 0xb0, 0x80, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xcd, 0xb8},
		expected: [][]byte{{0xea, 0xb0, 0x80}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xcc, 0x88, 0xcd, 0xb8},
		expected: [][]byte{{0xea, 0xb0, 0x80, 0xcc, 0x88}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xd},
		expected: [][]byte{{0xea, 0xb0, 0x81}, {0xd}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0xea, 0xb0, 0x81, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xa},
		expected: [][]byte{{0xea, 0xb0, 0x81}, {0xa}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0xea, 0xb0, 0x81, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0x0},
		expected: [][]byte{{0xea, 0xb0, 0x81}, {0x0}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [5.0] <NULL> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xcc, 0x88, 0x0},
		expected: [][]byte{{0xea, 0xb0, 0x81, 0xcc, 0x88}, {0x0}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <NULL> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xe0, 0xa5, 0x8d},
		expected: [][]byte{{0xea, 0xb0, 0x81, 0xe0, 0xa5, 0x8d}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xcc, 0x88, 0xe0, 0xa5, 0x8d},
		expected: [][]byte{{0xea, 0xb0, 0x81, 0xcc, 0x88, 0xe0, 0xa5, 0x8d}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xcc, 0x80},
		expected: [][]byte{{0xea, 0xb0, 0x81, 0xcc, 0x80}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0xea, 0xb0, 0x81, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xe2, 0x80, 0x8c},
		expected: [][]byte{{0xea, 0xb0, 0x81, 0xe2, 0x80, 0x8c}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xcc, 0x88, 0xe2, 0x80, 0x8c},
		expected: [][]byte{{0xea, 0xb0, 0x81, 0xcc, 0x88, 0xe2, 0x80, 0x8c}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xea, 0xb0, 0x81, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xea, 0xb0, 0x81, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xea, 0xb0, 0x81}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xea, 0xb0, 0x81, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xdb, 0x9d},
		expected: [][]byte{{0xea, 0xb0, 0x81}, {0xdb, 0x9d}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xcc, 0x88, 0xdb, 0x9d},
		expected: [][]byte{{0xea, 0xb0, 0x81, 0xcc, 0x88}, {0xdb, 0x9d}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0xea, 0xb0, 0x81, 0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xcc, 0x88, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0xea, 0xb0, 0x81, 0xcc, 0x88, 0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xea, 0xb0, 0x81}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xcc, 0x88, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xea, 0xb0, 0x81, 0xcc, 0x88}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0xea, 0xb0, 0x81}, {0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xcc, 0x88, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0xea, 0xb0, 0x81, 0xcc, 0x88}, {0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0xea, 0xb0, 0x81, 0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [8.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xcc, 0x88, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0xea, 0xb0, 0x81, 0xcc, 0x88}, {0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0xea, 0xb0, 0x81}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xcc, 0x88, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0xea, 0xb0, 0x81, 0xcc, 0x88}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0xea, 0xb0, 0x81}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xcc, 0x88, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0xea, 0xb0, 0x81, 0xcc, 0x88}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xe0, 0xa4, 0x95},
		expected: [][]byte{{0xea, 0xb0, 0x81}, {0xe0, 0xa4, 0x95}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xcc, 0x88, 0xe0, 0xa4, 0x95},
		expected: [][]byte{{0xea, 0xb0, 0x81, 0xcc, 0x88}, {0xe0, 0xa4, 0x95}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xc2, 0xa9},
		expected: [][]byte{{0xea, 0xb0, 0x81}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xcc, 0x88, 0xc2, 0xa9},
		expected: [][]byte{{0xea, 0xb0, 0x81, 0xcc, 0x88}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0x20},
		expected: [][]byte{{0xea, 0xb0, 0x81}, {0x20}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0xea, 0xb0, 0x81, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xcd, 0xb8},
		expected: [][]byte{{0xea, 0xb0, 0x81}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xcc, 0x88, 0xcd, 0xb8},
		expected: [][]byte{{0xea, 0xb0, 0x81, 0xcc, 0x88}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x95, 0xd},
		expected: [][]byte{{0xe0, 0xa4, 0x95}, {0xd}},
		comment:  "÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x95, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0xe0, 0xa4, 0x95, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x95, 0xa},
		expected: [][]byte{{0xe0, 0xa4, 0x95}, {0xa}},
		comment:  "÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x95, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0xe0, 0xa4, 0x95, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x95, 0x0},
		expected: [][]byte{{0xe0, 0xa4, 0x95}, {0x0}},
		comment:  "÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [5.0] <NULL> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x95, 0xcc, 0x88, 0x0},
		expected: [][]byte{{0xe0, 0xa4, 0x95, 0xcc, 0x88}, {0x0}},
		comment:  "÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <NULL> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x8d},
		expected: [][]byte{{0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x8d}},
		comment:  "÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x95, 0xcc, 0x88, 0xe0, 0xa5, 0x8d},
		expected: [][]byte{{0xe0, 0xa4, 0x95, 0xcc, 0x88, 0xe0, 0xa5, 0x8d}},
		comment:  "÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x95, 0xcc, 0x80},
		expected: [][]byte{{0xe0, 0xa4, 0x95, 0xcc, 0x80}},
		comment:  "÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x95, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0xe0, 0xa4, 0x95, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x95, 0xe2, 0x80, 0x8c},
		expected: [][]byte{{0xe0, 0xa4, 0x95, 0xe2, 0x80, 0x8c}},
		comment:  "÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x95, 0xcc, 0x88, 0xe2, 0x80, 0x8c},
		expected: [][]byte{{0xe0, 0xa4, 0x95, 0xcc, 0x88, 0xe2, 0x80, 0x8c}},
		comment:  "÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x95, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xe0, 0xa4, 0x95, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x95, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xe0, 0xa4, 0x95, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x95, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xe0, 0xa4, 0x95}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x95, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xe0, 0xa4, 0x95, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x95, 0xdb, 0x9d},
		expected: [][]byte{{0xe0, 0xa4, 0x95}, {0xdb, 0x9d}},
		comment:  "÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x95, 0xcc, 0x88, 0xdb, 0x9d},
		expected: [][]byte{{0xe0, 0xa4, 0x95, 0xcc, 0x88}, {0xdb, 0x9d}},
		comment:  "÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x95, 0xcc, 0x88, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0xe0, 0xa4, 0x95, 0xcc, 0x88, 0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x95, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xe0, 0xa4, 0x95}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x95, 0xcc, 0x88, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xe0, 0xa4, 0x95, 0xcc, 0x88}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x95, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0xe0, 0xa4, 0x95}, {0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x95, 0xcc, 0x88, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0xe0, 0xa4, 0x95, 0xcc, 0x88}, {0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x95, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0xe0, 0xa4, 0x95}, {0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x95, 0xcc, 0x88, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0xe0, 0xa4, 0x95, 0xcc, 0x88}, {0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x95, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0xe0, 0xa4, 0x95}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x95, 0xcc, 0x88, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0xe0, 0xa4, 0x95, 0xcc, 0x88}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x95, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0xe0, 0xa4, 0x95}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x95, 0xcc, 0x88, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0xe0, 0xa4, 0x95, 0xcc, 0x88}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0x95},
		expected: [][]byte{{0xe0, 0xa4, 0x95}, {0xe0, 0xa4, 0x95}},
		comment:  "÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x95, 0xcc, 0x88, 0xe0, 0xa4, 0x95},
		expected: [][]byte{{0xe0, 0xa4, 0x95, 0xcc, 0x88}, {0xe0, 0xa4, 0x95}},
		comment:  "÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x95, 0xc2, 0xa9},
		expected: [][]byte{{0xe0, 0xa4, 0x95}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x95, 0xcc, 0x88, 0xc2, 0xa9},
		expected: [][]byte{{0xe0, 0xa4, 0x95, 0xcc, 0x88}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x95, 0x20},
		expected: [][]byte{{0xe0, 0xa4, 0x95}, {0x20}},
		comment:  "÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x95, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0xe0, 0xa4, 0x95, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x95, 0xcd, 0xb8},
		expected: [][]byte{{0xe0, 0xa4, 0x95}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x95, 0xcc, 0x88, 0xcd, 0xb8},
		expected: [][]byte{{0xe0, 0xa4, 0x95, 0xcc, 0x88}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xd},
		expected: [][]byte{{0xc2, 0xa9}, {0xd}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPict) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0xc2, 0xa9, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xa},
		expected: [][]byte{{0xc2, 0xa9}, {0xa}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPict) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0xc2, 0xa9, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0x0},
		expected: [][]byte{{0xc2, 0xa9}, {0x0}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPict) ÷ [5.0] <NULL> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xcc, 0x88, 0x0},
		expected: [][]byte{{0xc2, 0xa9, 0xcc, 0x88}, {0x0}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <NULL> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xe0, 0xa5, 0x8d},
		expected: [][]byte{{0xc2, 0xa9, 0xe0, 0xa5, 0x8d}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPict) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xcc, 0x88, 0xe0, 0xa5, 0x8d},
		expected: [][]byte{{0xc2, 0xa9, 0xcc, 0x88, 0xe0, 0xa5, 0x8d}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xcc, 0x80},
		expected: [][]byte{{0xc2, 0xa9, 0xcc, 0x80}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPict) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0xc2, 0xa9, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xe2, 0x80, 0x8c},
		expected: [][]byte{{0xc2, 0xa9, 0xe2, 0x80, 0x8c}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPict) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xcc, 0x88, 0xe2, 0x80, 0x8c},
		expected: [][]byte{{0xc2, 0xa9, 0xcc, 0x88, 0xe2, 0x80, 0x8c}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xc2, 0xa9, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPict) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xc2, 0xa9, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xc2, 0xa9}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPict) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xc2, 0xa9, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xdb, 0x9d},
		expected: [][]byte{{0xc2, 0xa9}, {0xdb, 0x9d}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPict) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xcc, 0x88, 0xdb, 0x9d},
		expected: [][]byte{{0xc2, 0xa9, 0xcc, 0x88}, {0xdb, 0x9d}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0xc2, 0xa9, 0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPict) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xcc, 0x88, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0xc2, 0xa9, 0xcc, 0x88, 0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xc2, 0xa9}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPict) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xcc, 0x88, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xc2, 0xa9, 0xcc, 0x88}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0xc2, 0xa9}, {0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPict) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xcc, 0x88, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0xc2, 0xa9, 0xcc, 0x88}, {0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0xc2, 0xa9}, {0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPict) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xcc, 0x88, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0xc2, 0xa9, 0xcc, 0x88}, {0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0xc2, 0xa9}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPict) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xcc, 0x88, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0xc2, 0xa9, 0xcc, 0x88}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0xc2, 0xa9}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPict) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xcc, 0x88, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0xc2, 0xa9, 0xcc, 0x88}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xe0, 0xa4, 0x95},
		expected: [][]byte{{0xc2, 0xa9}, {0xe0, 0xa4, 0x95}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPict) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xcc, 0x88, 0xe0, 0xa4, 0x95},
		expected: [][]byte{{0xc2, 0xa9, 0xcc, 0x88}, {0xe0, 0xa4, 0x95}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xc2, 0xa9},
		expected: [][]byte{{0xc2, 0xa9}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPict) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xcc, 0x88, 0xc2, 0xa9},
		expected: [][]byte{{0xc2, 0xa9, 0xcc, 0x88}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0x20},
		expected: [][]byte{{0xc2, 0xa9}, {0x20}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPict) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0xc2, 0xa9, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xcd, 0xb8},
		expected: [][]byte{{0xc2, 0xa9}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPict) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xcc, 0x88, 0xcd, 0xb8},
		expected: [][]byte{{0xc2, 0xa9, 0xcc, 0x88}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xd},
		expected: [][]byte{{0x20}, {0xd}},
		comment:  "÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xa},
		expected: [][]byte{{0x20}, {0xa}},
		comment:  "÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0x0},
		expected: [][]byte{{0x20}, {0x0}},
		comment:  "÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) ÷ [5.0] <NULL> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0x0},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0x0}},
		comment:  "÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <NULL> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xe0, 0xa5, 0x8d},
		expected: [][]byte{{0x20, 0xe0, 0xa5, 0x8d}},
		comment:  "÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0xe0, 0xa5, 0x8d},
		expected: [][]byte{{0x20, 0xcc, 0x88, 0xe0, 0xa5, 0x8d}},
		comment:  "÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x80},
		expected: [][]byte{{0x20, 0xcc, 0x80}},
		comment:  "÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0x20, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xe2, 0x80, 0x8c},
		expected: [][]byte{{0x20, 0xe2, 0x80, 0x8c}},
		comment:  "÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0xe2, 0x80, 0x8c},
		expected: [][]byte{{0x20, 0xcc, 0x88, 0xe2, 0x80, 0x8c}},
		comment:  "÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x20, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x20, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x20}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xdb, 0x9d},
		expected: [][]byte{{0x20}, {0xdb, 0x9d}},
		comment:  "÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0xdb, 0x9d},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0xdb, 0x9d}},
		comment:  "÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0x20, 0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0x20, 0xcc, 0x88, 0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0x20}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0x20}, {0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0x20}, {0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0x20}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0x20}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xe0, 0xa4, 0x95},
		expected: [][]byte{{0x20}, {0xe0, 0xa4, 0x95}},
		comment:  "÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0xe0, 0xa4, 0x95},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0xe0, 0xa4, 0x95}},
		comment:  "÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xc2, 0xa9},
		expected: [][]byte{{0x20}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0xc2, 0xa9},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0x20},
		expected: [][]byte{{0x20}, {0x20}},
		comment:  "÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcd, 0xb8},
		expected: [][]byte{{0x20}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0xcd, 0xb8},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xd},
		expected: [][]byte{{0xcd, 0xb8}, {0xd}},
		comment:  "÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0xcd, 0xb8, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xa},
		expected: [][]byte{{0xcd, 0xb8}, {0xa}},
		comment:  "÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0xcd, 0xb8, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0x0},
		expected: [][]byte{{0xcd, 0xb8}, {0x0}},
		comment:  "÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [5.0] <NULL> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xcc, 0x88, 0x0},
		expected: [][]byte{{0xcd, 0xb8, 0xcc, 0x88}, {0x0}},
		comment:  "÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <NULL> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xe0, 0xa5, 0x8d},
		expected: [][]byte{{0xcd, 0xb8, 0xe0, 0xa5, 0x8d}},
		comment:  "÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xcc, 0x88, 0xe0, 0xa5, 0x8d},
		expected: [][]byte{{0xcd, 0xb8, 0xcc, 0x88, 0xe0, 0xa5, 0x8d}},
		comment:  "÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xcc, 0x80},
		expected: [][]byte{{0xcd, 0xb8, 0xcc, 0x80}},
		comment:  "÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0xcd, 0xb8, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xe2, 0x80, 0x8c},
		expected: [][]byte{{0xcd, 0xb8, 0xe2, 0x80, 0x8c}},
		comment:  "÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xcc, 0x88, 0xe2, 0x80, 0x8c},
		expected: [][]byte{{0xcd, 0xb8, 0xcc, 0x88, 0xe2, 0x80, 0x8c}},
		comment:  "÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xcd, 0xb8, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xcd, 0xb8, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xcd, 0xb8}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xcd, 0xb8, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xdb, 0x9d},
		expected: [][]byte{{0xcd, 0xb8}, {0xdb, 0x9d}},
		comment:  "÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xcc, 0x88, 0xdb, 0x9d},
		expected: [][]byte{{0xcd, 0xb8, 0xcc, 0x88}, {0xdb, 0x9d}},
		comment:  "÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0xcd, 0xb8, 0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xcc, 0x88, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0xcd, 0xb8, 0xcc, 0x88, 0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xcd, 0xb8}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xcc, 0x88, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xcd, 0xb8, 0xcc, 0x88}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0xcd, 0xb8}, {0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xcc, 0x88, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0xcd, 0xb8, 0xcc, 0x88}, {0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0xcd, 0xb8}, {0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xcc, 0x88, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0xcd, 0xb8, 0xcc, 0x88}, {0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0xcd, 0xb8}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xcc, 0x88, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0xcd, 0xb8, 0xcc, 0x88}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0xcd, 0xb8}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xcc, 0x88, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0xcd, 0xb8, 0xcc, 0x88}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xe0, 0xa4, 0x95},
		expected: [][]byte{{0xcd, 0xb8}, {0xe0, 0xa4, 0x95}},
		comment:  "÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xcc, 0x88, 0xe0, 0xa4, 0x95},
		expected: [][]byte{{0xcd, 0xb8, 0xcc, 0x88}, {0xe0, 0xa4, 0x95}},
		comment:  "÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xc2, 0xa9},
		expected: [][]byte{{0xcd, 0xb8}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xcc, 0x88, 0xc2, 0xa9},
		expected: [][]byte{{0xcd, 0xb8, 0xcc, 0x88}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0x20},
		expected: [][]byte{{0xcd, 0xb8}, {0x20}},
		comment:  "÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0xcd, 0xb8, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xcd, 0xb8},
		expected: [][]byte{{0xcd, 0xb8}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xcc, 0x88, 0xcd, 0xb8},
		expected: [][]byte{{0xcd, 0xb8, 0xcc, 0x88}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xa, 0x61, 0xa, 0xcc, 0x88},
		expected: [][]byte{{0xd, 0xa}, {0x61}, {0xa}, {0xcc, 0x88}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) × [3.0] <LINE FEED (LF)> (LF) ÷ [4.0] LATIN SMALL LETTER A (XXmLinkingConsonantmExtPict) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xcc, 0x88},
		expected: [][]byte{{0x61, 0xcc, 0x88}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xe2, 0x80, 0x8d, 0xd9, 0x86},
		expected: [][]byte{{0x20, 0xe2, 0x80, 0x8d}, {0xd9, 0x86}},
		comment:  "÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [999.0] ARABIC LETTER NOON (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xd9, 0x86, 0xe2, 0x80, 0x8d, 0x20},
		expected: [][]byte{{0xd9, 0x86, 0xe2, 0x80, 0x8d}, {0x20}},
		comment:  "÷ [0.2] ARABIC LETTER NOON (XXmLinkingConsonantmExtPict) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xe1, 0x84, 0x80, 0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [6.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xe1, 0x86, 0xa8, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xea, 0xb0, 0x80, 0xe1, 0x86, 0xa8}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) × [7.0] HANGUL JONGSEONG KIYEOK (T) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xe1, 0x86, 0xa8, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xea, 0xb0, 0x81, 0xe1, 0x86, 0xa8}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [8.0] HANGUL JONGSEONG KIYEOK (T) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xf0, 0x9f, 0x87, 0xa7, 0xf0, 0x9f, 0x87, 0xa8, 0x62},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xf0, 0x9f, 0x87, 0xa7}, {0xf0, 0x9f, 0x87, 0xa8}, {0x62}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [12.0] REGIONAL INDICATOR SYMBOL LETTER B (RI) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER C (RI) ÷ [999.0] LATIN SMALL LETTER B (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xf0, 0x9f, 0x87, 0xa6, 0xf0, 0x9f, 0x87, 0xa7, 0xf0, 0x9f, 0x87, 0xa8, 0x62},
		expected: [][]byte{{0x61}, {0xf0, 0x9f, 0x87, 0xa6, 0xf0, 0x9f, 0x87, 0xa7}, {0xf0, 0x9f, 0x87, 0xa8}, {0x62}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (XXmLinkingConsonantmExtPict) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [13.0] REGIONAL INDICATOR SYMBOL LETTER B (RI) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER C (RI) ÷ [999.0] LATIN SMALL LETTER B (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xf0, 0x9f, 0x87, 0xa6, 0xf0, 0x9f, 0x87, 0xa7, 0xe2, 0x80, 0x8d, 0xf0, 0x9f, 0x87, 0xa8, 0x62},
		expected: [][]byte{{0x61}, {0xf0, 0x9f, 0x87, 0xa6, 0xf0, 0x9f, 0x87, 0xa7, 0xe2, 0x80, 0x8d}, {0xf0, 0x9f, 0x87, 0xa8}, {0x62}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (XXmLinkingConsonantmExtPict) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [13.0] REGIONAL INDICATOR SYMBOL LETTER B (RI) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER C (RI) ÷ [999.0] LATIN SMALL LETTER B (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xf0, 0x9f, 0x87, 0xa6, 0xe2, 0x80, 0x8d, 0xf0, 0x9f, 0x87, 0xa7, 0xf0, 0x9f, 0x87, 0xa8, 0x62},
		expected: [][]byte{{0x61}, {0xf0, 0x9f, 0x87, 0xa6, 0xe2, 0x80, 0x8d}, {0xf0, 0x9f, 0x87, 0xa7, 0xf0, 0x9f, 0x87, 0xa8}, {0x62}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (XXmLinkingConsonantmExtPict) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER B (RI) × [13.0] REGIONAL INDICATOR SYMBOL LETTER C (RI) ÷ [999.0] LATIN SMALL LETTER B (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xf0, 0x9f, 0x87, 0xa6, 0xf0, 0x9f, 0x87, 0xa7, 0xf0, 0x9f, 0x87, 0xa8, 0xf0, 0x9f, 0x87, 0xa9, 0x62},
		expected: [][]byte{{0x61}, {0xf0, 0x9f, 0x87, 0xa6, 0xf0, 0x9f, 0x87, 0xa7}, {0xf0, 0x9f, 0x87, 0xa8, 0xf0, 0x9f, 0x87, 0xa9}, {0x62}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (XXmLinkingConsonantmExtPict) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [13.0] REGIONAL INDICATOR SYMBOL LETTER B (RI) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER C (RI) × [13.0] REGIONAL INDICATOR SYMBOL LETTER D (RI) ÷ [999.0] LATIN SMALL LETTER B (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x61, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (XXmLinkingConsonantmExtPict) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xcc, 0x88, 0x62},
		expected: [][]byte{{0x61, 0xcc, 0x88}, {0x62}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] LATIN SMALL LETTER B (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe0, 0xa4, 0x83, 0x62},
		expected: [][]byte{{0x61, 0xe0, 0xa4, 0x83}, {0x62}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (XXmLinkingConsonantmExtPict) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [999.0] LATIN SMALL LETTER B (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xd8, 0x80, 0x62},
		expected: [][]byte{{0x61}, {0xd8, 0x80, 0x62}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (XXmLinkingConsonantmExtPict) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) × [9.2] LATIN SMALL LETTER B (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x91, 0xb6, 0xf0, 0x9f, 0x8f, 0xbf, 0xf0, 0x9f, 0x91, 0xb6},
		expected: [][]byte{{0xf0, 0x9f, 0x91, 0xb6, 0xf0, 0x9f, 0x8f, 0xbf}, {0xf0, 0x9f, 0x91, 0xb6}},
		comment:  "÷ [0.2] BABY (ExtPict) × [9.0] EMOJI MODIFIER FITZPATRICK TYPE-6 (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] BABY (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xf0, 0x9f, 0x8f, 0xbf, 0xf0, 0x9f, 0x91, 0xb6},
		expected: [][]byte{{0x61, 0xf0, 0x9f, 0x8f, 0xbf}, {0xf0, 0x9f, 0x91, 0xb6}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (XXmLinkingConsonantmExtPict) × [9.0] EMOJI MODIFIER FITZPATRICK TYPE-6 (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] BABY (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xf0, 0x9f, 0x8f, 0xbf, 0xf0, 0x9f, 0x91, 0xb6, 0xe2, 0x80, 0x8d, 0xf0, 0x9f, 0x9b, 0x91},
		expected: [][]byte{{0x61, 0xf0, 0x9f, 0x8f, 0xbf}, {0xf0, 0x9f, 0x91, 0xb6, 0xe2, 0x80, 0x8d, 0xf0, 0x9f, 0x9b, 0x91}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (XXmLinkingConsonantmExtPict) × [9.0] EMOJI MODIFIER FITZPATRICK TYPE-6 (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] BABY (ExtPict) × [9.0] ZERO WIDTH JOINER (ZWJ) × [11.0] OCTAGONAL SIGN (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x91, 0xb6, 0xf0, 0x9f, 0x8f, 0xbf, 0xcc, 0x88, 0xe2, 0x80, 0x8d, 0xf0, 0x9f, 0x91, 0xb6, 0xf0, 0x9f, 0x8f, 0xbf},
		expected: [][]byte{{0xf0, 0x9f, 0x91, 0xb6, 0xf0, 0x9f, 0x8f, 0xbf, 0xcc, 0x88, 0xe2, 0x80, 0x8d, 0xf0, 0x9f, 0x91, 0xb6, 0xf0, 0x9f, 0x8f, 0xbf}},
		comment:  "÷ [0.2] BABY (ExtPict) × [9.0] EMOJI MODIFIER FITZPATRICK TYPE-6 (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH JOINER (ZWJ) × [11.0] BABY (ExtPict) × [9.0] EMOJI MODIFIER FITZPATRICK TYPE-6 (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x9b, 0x91, 0xe2, 0x80, 0x8d, 0xf0, 0x9f, 0x9b, 0x91},
		expected: [][]byte{{0xf0, 0x9f, 0x9b, 0x91, 0xe2, 0x80, 0x8d, 0xf0, 0x9f, 0x9b, 0x91}},
		comment:  "÷ [0.2] OCTAGONAL SIGN (ExtPict) × [9.0] ZERO WIDTH JOINER (ZWJ) × [11.0] OCTAGONAL SIGN (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x80, 0x8d, 0xf0, 0x9f, 0x9b, 0x91},
		expected: [][]byte{{0x61, 0xe2, 0x80, 0x8d}, {0xf0, 0x9f, 0x9b, 0x91}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (XXmLinkingConsonantmExtPict) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [999.0] OCTAGONAL SIGN (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x9c, 0x81, 0xe2, 0x80, 0x8d, 0xe2, 0x9c, 0x81},
		expected: [][]byte{{0xe2, 0x9c, 0x81, 0xe2, 0x80, 0x8d}, {0xe2, 0x9c, 0x81}},
		comment:  "÷ [0.2] UPPER BLADE SCISSORS (XXmLinkingConsonantmExtPict) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [999.0] UPPER BLADE SCISSORS (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x80, 0x8d, 0xe2, 0x9c, 0x81},
		expected: [][]byte{{0x61, 0xe2, 0x80, 0x8d}, {0xe2, 0x9c, 0x81}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (XXmLinkingConsonantmExtPict) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [999.0] UPPER BLADE SCISSORS (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xa4},
		expected: [][]byte{{0xe0, 0xa4, 0x95}, {0xe0, 0xa4, 0xa4}},
		comment:  "÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [999.0] DEVANAGARI LETTER TA (LinkingConsonant) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xa4},
		expected: [][]byte{{0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xa4}},
		comment:  "÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.3] DEVANAGARI LETTER TA (LinkingConsonant) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x8d, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xa4},
		expected: [][]byte{{0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x8d, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xa4}},
		comment:  "÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.3] DEVANAGARI LETTER TA (LinkingConsonant) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x8d, 0xe2, 0x80, 0x8d, 0xe0, 0xa4, 0xa4},
		expected: [][]byte{{0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x8d, 0xe2, 0x80, 0x8d, 0xe0, 0xa4, 0xa4}},
		comment:  "÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.0] ZERO WIDTH JOINER (ZWJ) × [9.3] DEVANAGARI LETTER TA (LinkingConsonant) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xbc, 0xe2, 0x80, 0x8d, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xa4},
		expected: [][]byte{{0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xbc, 0xe2, 0x80, 0x8d, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xa4}},
		comment:  "÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) × [9.0] DEVANAGARI SIGN NUKTA (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH JOINER (ZWJ) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.3] DEVANAGARI LETTER TA (LinkingConsonant) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xbc, 0xe0, 0xa5, 0x8d, 0xe2, 0x80, 0x8d, 0xe0, 0xa4, 0xa4},
		expected: [][]byte{{0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xbc, 0xe0, 0xa5, 0x8d, 0xe2, 0x80, 0x8d, 0xe0, 0xa4, 0xa4}},
		comment:  "÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) × [9.0] DEVANAGARI SIGN NUKTA (Extend_ConjunctExtendermConjunctLinker) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.0] ZERO WIDTH JOINER (ZWJ) × [9.3] DEVANAGARI LETTER TA (LinkingConsonant) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xa4, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xaf},
		expected: [][]byte{{0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xa4, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xaf}},
		comment:  "÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.3] DEVANAGARI LETTER TA (LinkingConsonant) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.3] DEVANAGARI LETTER YA (LinkingConsonant) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x8d, 0x61},
		expected: [][]byte{{0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x8d}, {0x61}},
		comment:  "÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [999.0] LATIN SMALL LETTER A (XXmLinkingConsonantmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xa4},
		expected: [][]byte{{0x61, 0xe0, 0xa5, 0x8d}, {0xe0, 0xa4, 0xa4}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (XXmLinkingConsonantmExtPict) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [999.0] DEVANAGARI LETTER TA (LinkingConsonant) ÷ [0.3]",
	},
	{
		input:    []byte{0x3f, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xa4},
		expected: [][]byte{{0x3f, 0xe0, 0xa5, 0x8d}, {0xe0, 0xa4, 0xa4}},
		comment:  "÷ [0.2] QUESTION MARK (XXmLinkingConsonantmExtPict) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [999.0] DEVANAGARI LETTER TA (LinkingConsonant) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x8d, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xa4},
		expected: [][]byte{{0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x8d, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xa4}},
		comment:  "÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.3] DEVANAGARI LETTER TA (LinkingConsonant) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xaa, 0xb8, 0xe0, 0xab, 0xbb, 0xe0, 0xab, 0x8d, 0xe0, 0xaa, 0xb8, 0xe0, 0xab, 0xbb},
		expected: [][]byte{{0xe0, 0xaa, 0xb8, 0xe0, 0xab, 0xbb, 0xe0, 0xab, 0x8d, 0xe0, 0xaa, 0xb8, 0xe0, 0xab, 0xbb}},
		comment:  "÷ [0.2] GUJARATI LETTER SA (LinkingConsonant) × [9.0] GUJARATI SIGN SHADDA (Extend_ConjunctExtendermConjunctLinker) × [9.0] GUJARATI SIGN VIRAMA (Extend_ConjunctLinker) × [9.3] GUJARATI LETTER SA (LinkingConsonant) × [9.0] GUJARATI SIGN SHADDA (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x80, 0x99, 0xe1, 0x80, 0xb9, 0xe1, 0x80, 0x98, 0xe1, 0x80, 0xac, 0xe1, 0x80, 0xb7},
		expected: [][]byte{{0xe1, 0x80, 0x99, 0xe1, 0x80, 0xb9, 0xe1, 0x80, 0x98}, {0xe1, 0x80, 0xac, 0xe1, 0x80, 0xb7}},
		comment:  "÷ [0.2] MYANMAR LETTER MA (LinkingConsonant) × [9.0] MYANMAR SIGN VIRAMA (Extend_ConjunctLinker) × [9.3] MYANMAR LETTER BHA (LinkingConsonant) ÷ [999.0] MYANMAR VOWEL SIGN AA (XXmLinkingConsonantmExtPict) × [9.0] MYANMAR SIGN DOT BELOW (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x80, 0x84, 0xe1, 0x80, 0xba, 0xe1, 0x80, 0xb9, 0xe1, 0x80, 0x91, 0xe1, 0x80, 0xb9, 0xe1, 0x80, 0x91},
		expected: [][]byte{{0xe1, 0x80, 0x84, 0xe1, 0x80, 0xba, 0xe1, 0x80, 0xb9, 0xe1, 0x80, 0x91, 0xe1, 0x80, 0xb9, 0xe1, 0x80, 0x91}},
		comment:  "÷ [0.2] MYANMAR LETTER NGA (LinkingConsonant) × [9.0] MYANMAR SIGN ASAT (Extend_ConjunctExtendermConjunctLinker) × [9.0] MYANMAR SIGN VIRAMA (Extend_ConjunctLinker) × [9.3] MYANMAR LETTER THA (LinkingConsonant) × [9.0] MYANMAR SIGN VIRAMA (Extend_ConjunctLinker) × [9.3] MYANMAR LETTER THA (LinkingConsonant) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0xac, 0x92, 0xe1, 0xac, 0x81, 0xe1, 0xac, 0xb2, 0xe1, 0xad, 0x84, 0xe1, 0xac, 0xaf, 0xe1, 0xac, 0xb2, 0xe1, 0xad, 0x84, 0xe1, 0xac, 0xa2, 0xe1, 0xad, 0x84, 0xe1, 0xac, 0xac, 0xe1, 0xac, 0xb2, 0xe1, 0xad, 0x84, 0xe1, 0xac, 0xa2, 0xe1, 0xac, 0xb8},
		expected: [][]byte{{0xe1, 0xac, 0x92, 0xe1, 0xac, 0x81}, {0xe1, 0xac, 0xb2, 0xe1, 0xad, 0x84, 0xe1, 0xac, 0xaf}, {0xe1, 0xac, 0xb2, 0xe1, 0xad, 0x84, 0xe1, 0xac, 0xa2, 0xe1, 0xad, 0x84, 0xe1, 0xac, 0xac}, {0xe1, 0xac, 0xb2, 0xe1, 0xad, 0x84, 0xe1, 0xac, 0xa2, 0xe1, 0xac, 0xb8}},
		comment:  "÷ [0.2] BALINESE LETTER OKARA TEDUNG (XXmLinkingConsonantmExtPict) × [9.0] BALINESE SIGN ULU CANDRA (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] BALINESE LETTER SA (LinkingConsonant) × [9.0] BALINESE ADEG ADEG (Extend_ConjunctLinker) × [9.3] BALINESE LETTER WA (LinkingConsonant) ÷ [999.0] BALINESE LETTER SA (LinkingConsonant) × [9.0] BALINESE ADEG ADEG (Extend_ConjunctLinker) × [9.3] BALINESE LETTER TA (LinkingConsonant) × [9.0] BALINESE ADEG ADEG (Extend_ConjunctLinker) × [9.3] BALINESE LETTER YA (LinkingConsonant) ÷ [999.0] BALINESE LETTER SA (LinkingConsonant) × [9.0] BALINESE ADEG ADEG (Extend_ConjunctLinker) × [9.3] BALINESE LETTER TA (LinkingConsonant) × [9.0] BALINESE VOWEL SIGN SUKU (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x9e, 0x9f, 0xe1, 0x9f, 0x92, 0xe1, 0x9e, 0x8f, 0xe1, 0x9f, 0x92, 0xe1, 0x9e, 0x9a, 0xe1, 0x9e, 0xb8},
		expected: [][]byte{{0xe1, 0x9e, 0x9f, 0xe1, 0x9f, 0x92, 0xe1, 0x9e, 0x8f, 0xe1, 0x9f, 0x92, 0xe1, 0x9e, 0x9a, 0xe1, 0x9e, 0xb8}},
		comment:  "÷ [0.2] KHMER LETTER SA (LinkingConsonant) × [9.0] KHMER SIGN COENG (Extend_ConjunctLinker) × [9.3] KHMER LETTER TA (LinkingConsonant) × [9.0] KHMER SIGN COENG (Extend_ConjunctLinker) × [9.3] KHMER LETTER RO (LinkingConsonant) × [9.0] KHMER VOWEL SIGN II (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0xac, 0xa6, 0xe1, 0xac, 0x97, 0xe1, 0xad, 0x84, 0xe1, 0xac, 0x93},
		expected: [][]byte{{0xe1, 0xac, 0xa6}, {0xe1, 0xac, 0x97, 0xe1, 0xad, 0x84, 0xe1, 0xac, 0x93}},
		comment:  "÷ [0.2] BALINESE LETTER NA (LinkingConsonant) ÷ [999.0] BALINESE LETTER NGA (LinkingConsonant) × [9.0] BALINESE ADEG ADEG (Extend_ConjunctLinker) × [9.3] BALINESE LETTER KA (LinkingConsonant) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0xac, 0xa7, 0xe1, 0xac, 0x93, 0xe1, 0xad, 0x84, 0xe1, 0xac, 0x8b, 0xe1, 0xac, 0x8b, 0xe1, 0xac, 0x84},
		expected: [][]byte{{0xe1, 0xac, 0xa7}, {0xe1, 0xac, 0x93, 0xe1, 0xad, 0x84, 0xe1, 0xac, 0x8b}, {0xe1, 0xac, 0x8b, 0xe1, 0xac, 0x84}},
		comment:  "÷ [0.2] BALINESE LETTER PA (LinkingConsonant) ÷ [999.0] BALINESE LETTER KA (LinkingConsonant) × [9.0] BALINESE ADEG ADEG (Extend_ConjunctLinker) × [9.3] BALINESE LETTER RA REPA (LinkingConsonant) ÷ [999.0] BALINESE LETTER RA REPA (LinkingConsonant) × [9.1] BALINESE SIGN BISAH (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x9e, 0x95, 0xe1, 0x9f, 0x92, 0xe1, 0x9e, 0xaf, 0xe1, 0x9e, 0x98},
		expected: [][]byte{{0xe1, 0x9e, 0x95, 0xe1, 0x9f, 0x92, 0xe1, 0x9e, 0xaf}, {0xe1, 0x9e, 0x98}},
		comment:  "÷ [0.2] KHMER LETTER PHA (LinkingConsonant) × [9.0] KHMER SIGN COENG (Extend_ConjunctLinker) × [9.3] KHMER INDEPENDENT VOWEL QE (LinkingConsonant) ÷ [999.0] KHMER LETTER MO (LinkingConsonant) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x9e, 0xa0, 0xe1, 0x9f, 0x92, 0xe1, 0x9e, 0xab, 0xe1, 0x9e, 0x91, 0xe1, 0x9f, 0x90, 0xe1, 0x9e, 0x99},
		expected: [][]byte{{0xe1, 0x9e, 0xa0, 0xe1, 0x9f, 0x92, 0xe1, 0x9e, 0xab}, {0xe1, 0x9e, 0x91, 0xe1, 0x9f, 0x90}, {0xe1, 0x9e, 0x99}},
		comment:  "÷ [0.2] KHMER LETTER HA (LinkingConsonant) × [9.0] KHMER SIGN COENG (Extend_ConjunctLinker) × [9.3] KHMER INDEPENDENT VOWEL RY (LinkingConsonant) ÷ [999.0] KHMER LETTER TO (LinkingConsonant) × [9.0] KHMER SIGN SAMYOK SANNYA (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] KHMER LETTER YO (LinkingConsonant) ÷ [0.3]",
	},
}
