// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/bigquery/storage/v1beta/partition.proto

package storagepb

import (
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Schema description of a metastore partition column.
type FieldSchema struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the column.
	// The maximum length of the name is 1024 characters
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The type of the metastore partition column. Maximum allowed
	// length is 1024 characters.
	Type string `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
}

func (x *FieldSchema) Reset() {
	*x = FieldSchema{}
	mi := &file_google_cloud_bigquery_storage_v1beta_partition_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FieldSchema) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FieldSchema) ProtoMessage() {}

func (x *FieldSchema) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_storage_v1beta_partition_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FieldSchema.ProtoReflect.Descriptor instead.
func (*FieldSchema) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_storage_v1beta_partition_proto_rawDescGZIP(), []int{0}
}

func (x *FieldSchema) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *FieldSchema) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

// Contains information about the physical storage of the data in the metastore
// partition.
type StorageDescriptor struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The physical location of the metastore partition
	// (e.g. `gs://spark-dataproc-data/pangea-data/case_sensitive/` or
	// `gs://spark-dataproc-data/pangea-data/*`).
	LocationUri string `protobuf:"bytes,1,opt,name=location_uri,json=locationUri,proto3" json:"location_uri,omitempty"`
	// Optional. Specifies the fully qualified class name of the InputFormat
	// (e.g. "org.apache.hadoop.hive.ql.io.orc.OrcInputFormat").
	// The maximum length is 128 characters.
	InputFormat string `protobuf:"bytes,2,opt,name=input_format,json=inputFormat,proto3" json:"input_format,omitempty"`
	// Optional. Specifies the fully qualified class name of the OutputFormat
	// (e.g. "org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat").
	// The maximum length is 128 characters.
	OutputFormat string `protobuf:"bytes,3,opt,name=output_format,json=outputFormat,proto3" json:"output_format,omitempty"`
	// Optional. Serializer and deserializer information.
	SerdeInfo *SerDeInfo `protobuf:"bytes,4,opt,name=serde_info,json=serdeInfo,proto3" json:"serde_info,omitempty"`
}

func (x *StorageDescriptor) Reset() {
	*x = StorageDescriptor{}
	mi := &file_google_cloud_bigquery_storage_v1beta_partition_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StorageDescriptor) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StorageDescriptor) ProtoMessage() {}

func (x *StorageDescriptor) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_storage_v1beta_partition_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StorageDescriptor.ProtoReflect.Descriptor instead.
func (*StorageDescriptor) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_storage_v1beta_partition_proto_rawDescGZIP(), []int{1}
}

func (x *StorageDescriptor) GetLocationUri() string {
	if x != nil {
		return x.LocationUri
	}
	return ""
}

func (x *StorageDescriptor) GetInputFormat() string {
	if x != nil {
		return x.InputFormat
	}
	return ""
}

func (x *StorageDescriptor) GetOutputFormat() string {
	if x != nil {
		return x.OutputFormat
	}
	return ""
}

func (x *StorageDescriptor) GetSerdeInfo() *SerDeInfo {
	if x != nil {
		return x.SerdeInfo
	}
	return nil
}

// Serializer and deserializer information.
type SerDeInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Name of the SerDe.
	// The maximum length is 256 characters.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Specifies a fully-qualified class name of the serialization
	// library that is responsible for the translation of data between table
	// representation and the underlying low-level input and output format
	// structures. The maximum length is 256 characters.
	SerializationLibrary string `protobuf:"bytes,2,opt,name=serialization_library,json=serializationLibrary,proto3" json:"serialization_library,omitempty"`
	// Optional. Key-value pairs that define the initialization parameters for the
	// serialization library.
	// Maximum size 10 Kib.
	Parameters map[string]string `protobuf:"bytes,3,rep,name=parameters,proto3" json:"parameters,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *SerDeInfo) Reset() {
	*x = SerDeInfo{}
	mi := &file_google_cloud_bigquery_storage_v1beta_partition_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SerDeInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SerDeInfo) ProtoMessage() {}

func (x *SerDeInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_storage_v1beta_partition_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SerDeInfo.ProtoReflect.Descriptor instead.
func (*SerDeInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_storage_v1beta_partition_proto_rawDescGZIP(), []int{2}
}

func (x *SerDeInfo) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SerDeInfo) GetSerializationLibrary() string {
	if x != nil {
		return x.SerializationLibrary
	}
	return ""
}

func (x *SerDeInfo) GetParameters() map[string]string {
	if x != nil {
		return x.Parameters
	}
	return nil
}

// Information about a Hive partition.
type MetastorePartition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Represents the values of the partition keys, where each value
	// corresponds to a specific partition key in the order in which the keys are
	// defined. Each value is limited to 1024 characters.
	Values []string `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
	// Output only. The creation time of the partition.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Optional. Contains information about the physical storage of the data in
	// the partition.
	StorageDescriptor *StorageDescriptor `protobuf:"bytes,3,opt,name=storage_descriptor,json=storageDescriptor,proto3" json:"storage_descriptor,omitempty"`
	// Optional. Additional parameters or metadata associated with the partition.
	// Maximum size 10 KiB.
	Parameters map[string]string `protobuf:"bytes,4,rep,name=parameters,proto3" json:"parameters,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. List of columns.
	Fields []*FieldSchema `protobuf:"bytes,5,rep,name=fields,proto3" json:"fields,omitempty"`
}

func (x *MetastorePartition) Reset() {
	*x = MetastorePartition{}
	mi := &file_google_cloud_bigquery_storage_v1beta_partition_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MetastorePartition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetastorePartition) ProtoMessage() {}

func (x *MetastorePartition) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_storage_v1beta_partition_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MetastorePartition.ProtoReflect.Descriptor instead.
func (*MetastorePartition) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_storage_v1beta_partition_proto_rawDescGZIP(), []int{3}
}

func (x *MetastorePartition) GetValues() []string {
	if x != nil {
		return x.Values
	}
	return nil
}

func (x *MetastorePartition) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *MetastorePartition) GetStorageDescriptor() *StorageDescriptor {
	if x != nil {
		return x.StorageDescriptor
	}
	return nil
}

func (x *MetastorePartition) GetParameters() map[string]string {
	if x != nil {
		return x.Parameters
	}
	return nil
}

func (x *MetastorePartition) GetFields() []*FieldSchema {
	if x != nil {
		return x.Fields
	}
	return nil
}

// List of metastore partitions.
type MetastorePartitionList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. List of partitions.
	Partitions []*MetastorePartition `protobuf:"bytes,1,rep,name=partitions,proto3" json:"partitions,omitempty"`
}

func (x *MetastorePartitionList) Reset() {
	*x = MetastorePartitionList{}
	mi := &file_google_cloud_bigquery_storage_v1beta_partition_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MetastorePartitionList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetastorePartitionList) ProtoMessage() {}

func (x *MetastorePartitionList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_storage_v1beta_partition_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MetastorePartitionList.ProtoReflect.Descriptor instead.
func (*MetastorePartitionList) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_storage_v1beta_partition_proto_rawDescGZIP(), []int{4}
}

func (x *MetastorePartitionList) GetPartitions() []*MetastorePartition {
	if x != nil {
		return x.Partitions
	}
	return nil
}

// Information about a single stream that is used to read partitions.
type ReadStream struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Identifier. Name of the stream, in the form
	// `projects/{project_id}/locations/{location}/sessions/{session_id}/streams/{stream_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *ReadStream) Reset() {
	*x = ReadStream{}
	mi := &file_google_cloud_bigquery_storage_v1beta_partition_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReadStream) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadStream) ProtoMessage() {}

func (x *ReadStream) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_storage_v1beta_partition_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadStream.ProtoReflect.Descriptor instead.
func (*ReadStream) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_storage_v1beta_partition_proto_rawDescGZIP(), []int{5}
}

func (x *ReadStream) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// List of streams.
type StreamList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. List of streams.
	Streams []*ReadStream `protobuf:"bytes,1,rep,name=streams,proto3" json:"streams,omitempty"`
}

func (x *StreamList) Reset() {
	*x = StreamList{}
	mi := &file_google_cloud_bigquery_storage_v1beta_partition_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StreamList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamList) ProtoMessage() {}

func (x *StreamList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_storage_v1beta_partition_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamList.ProtoReflect.Descriptor instead.
func (*StreamList) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_storage_v1beta_partition_proto_rawDescGZIP(), []int{6}
}

func (x *StreamList) GetStreams() []*ReadStream {
	if x != nil {
		return x.Streams
	}
	return nil
}

// Represents the values of a metastore partition.
type MetastorePartitionValues struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The values of the partition keys, where each value corresponds to
	// a specific partition key in the order in which the keys are defined.
	Values []string `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *MetastorePartitionValues) Reset() {
	*x = MetastorePartitionValues{}
	mi := &file_google_cloud_bigquery_storage_v1beta_partition_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MetastorePartitionValues) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetastorePartitionValues) ProtoMessage() {}

func (x *MetastorePartitionValues) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_storage_v1beta_partition_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MetastorePartitionValues.ProtoReflect.Descriptor instead.
func (*MetastorePartitionValues) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_storage_v1beta_partition_proto_rawDescGZIP(), []int{7}
}

func (x *MetastorePartitionValues) GetValues() []string {
	if x != nil {
		return x.Values
	}
	return nil
}

var File_google_cloud_bigquery_storage_v1beta_partition_proto protoreflect.FileDescriptor

var file_google_cloud_bigquery_storage_v1beta_partition_proto_rawDesc = []byte{
	0x0a, 0x34, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x24, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62,
	0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x3f, 0x0a, 0x0b, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x17, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0xe2, 0x01, 0x0a, 0x11, 0x53,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72,
	0x12, 0x26, 0x0a, 0x0c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x75, 0x72, 0x69,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x72, 0x69, 0x12, 0x26, 0x0a, 0x0c, 0x69, 0x6e, 0x70, 0x75,
	0x74, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0b, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74,
	0x12, 0x28, 0x0a, 0x0d, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61,
	0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x6f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x53, 0x0a, 0x0a, 0x73, 0x65,
	0x72, 0x64, 0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69,
	0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x65, 0x72, 0x44, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x73, 0x65, 0x72, 0x64, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x22,
	0x83, 0x02, 0x0a, 0x09, 0x53, 0x65, 0x72, 0x44, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x17, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x38, 0x0a, 0x15, 0x73, 0x65, 0x72, 0x69, 0x61, 0x6c,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x14, 0x73, 0x65, 0x72, 0x69,
	0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79,
	0x12, 0x64, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x65, 0x72, 0x44,
	0x65, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x70, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x1a, 0x3d, 0x0a, 0x0f, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xde, 0x03, 0x0a, 0x12, 0x4d, 0x65, 0x74, 0x61, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1b, 0x0a, 0x06,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x6b, 0x0a, 0x12, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f,
	0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x44, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x12, 0x6d, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x48, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x61, 0x72,
	0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x70, 0x61, 0x72,
	0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x4e, 0x0a, 0x06, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x06, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x1a, 0x3d, 0x0a, 0x0f, 0x50, 0x61, 0x72, 0x61, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x77, 0x0a, 0x16, 0x4d, 0x65, 0x74, 0x61, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x73, 0x74,
	0x12, 0x5d, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4d, 0x65, 0x74, 0x61,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0a, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22,
	0xc0, 0x01, 0x0a, 0x0a, 0x52, 0x65, 0x61, 0x64, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x1a,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41,
	0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x3a, 0x95, 0x01, 0xea, 0x41, 0x91,
	0x01, 0x0a, 0x29, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x52, 0x65, 0x61, 0x64, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x4b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73,
	0x2f, 0x7b, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x7d, 0x2a, 0x0b, 0x72, 0x65, 0x61, 0x64, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x32, 0x0a, 0x72, 0x65, 0x61, 0x64, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x22, 0x5d, 0x0a, 0x0a, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x4c, 0x69, 0x73, 0x74,
	0x12, 0x4f, 0x0a, 0x07, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x52, 0x65, 0x61, 0x64, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x73, 0x22, 0x37, 0x0a, 0x18, 0x4d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x1b, 0x0a,
	0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x42, 0xd7, 0x01, 0x0a, 0x28, 0x63,
	0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x42, 0x17, 0x4d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x50, 0x01, 0x5a, 0x42, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x70, 0x62, 0x3b, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x70, 0x62, 0xaa, 0x02, 0x24, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x53,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0xca, 0x02, 0x24,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x42, 0x69, 0x67,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x5c, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5c, 0x56, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_bigquery_storage_v1beta_partition_proto_rawDescOnce sync.Once
	file_google_cloud_bigquery_storage_v1beta_partition_proto_rawDescData = file_google_cloud_bigquery_storage_v1beta_partition_proto_rawDesc
)

func file_google_cloud_bigquery_storage_v1beta_partition_proto_rawDescGZIP() []byte {
	file_google_cloud_bigquery_storage_v1beta_partition_proto_rawDescOnce.Do(func() {
		file_google_cloud_bigquery_storage_v1beta_partition_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_bigquery_storage_v1beta_partition_proto_rawDescData)
	})
	return file_google_cloud_bigquery_storage_v1beta_partition_proto_rawDescData
}

var file_google_cloud_bigquery_storage_v1beta_partition_proto_msgTypes = make([]protoimpl.MessageInfo, 10)
var file_google_cloud_bigquery_storage_v1beta_partition_proto_goTypes = []any{
	(*FieldSchema)(nil),              // 0: google.cloud.bigquery.storage.v1beta.FieldSchema
	(*StorageDescriptor)(nil),        // 1: google.cloud.bigquery.storage.v1beta.StorageDescriptor
	(*SerDeInfo)(nil),                // 2: google.cloud.bigquery.storage.v1beta.SerDeInfo
	(*MetastorePartition)(nil),       // 3: google.cloud.bigquery.storage.v1beta.MetastorePartition
	(*MetastorePartitionList)(nil),   // 4: google.cloud.bigquery.storage.v1beta.MetastorePartitionList
	(*ReadStream)(nil),               // 5: google.cloud.bigquery.storage.v1beta.ReadStream
	(*StreamList)(nil),               // 6: google.cloud.bigquery.storage.v1beta.StreamList
	(*MetastorePartitionValues)(nil), // 7: google.cloud.bigquery.storage.v1beta.MetastorePartitionValues
	nil,                              // 8: google.cloud.bigquery.storage.v1beta.SerDeInfo.ParametersEntry
	nil,                              // 9: google.cloud.bigquery.storage.v1beta.MetastorePartition.ParametersEntry
	(*timestamppb.Timestamp)(nil),    // 10: google.protobuf.Timestamp
}
var file_google_cloud_bigquery_storage_v1beta_partition_proto_depIdxs = []int32{
	2,  // 0: google.cloud.bigquery.storage.v1beta.StorageDescriptor.serde_info:type_name -> google.cloud.bigquery.storage.v1beta.SerDeInfo
	8,  // 1: google.cloud.bigquery.storage.v1beta.SerDeInfo.parameters:type_name -> google.cloud.bigquery.storage.v1beta.SerDeInfo.ParametersEntry
	10, // 2: google.cloud.bigquery.storage.v1beta.MetastorePartition.create_time:type_name -> google.protobuf.Timestamp
	1,  // 3: google.cloud.bigquery.storage.v1beta.MetastorePartition.storage_descriptor:type_name -> google.cloud.bigquery.storage.v1beta.StorageDescriptor
	9,  // 4: google.cloud.bigquery.storage.v1beta.MetastorePartition.parameters:type_name -> google.cloud.bigquery.storage.v1beta.MetastorePartition.ParametersEntry
	0,  // 5: google.cloud.bigquery.storage.v1beta.MetastorePartition.fields:type_name -> google.cloud.bigquery.storage.v1beta.FieldSchema
	3,  // 6: google.cloud.bigquery.storage.v1beta.MetastorePartitionList.partitions:type_name -> google.cloud.bigquery.storage.v1beta.MetastorePartition
	5,  // 7: google.cloud.bigquery.storage.v1beta.StreamList.streams:type_name -> google.cloud.bigquery.storage.v1beta.ReadStream
	8,  // [8:8] is the sub-list for method output_type
	8,  // [8:8] is the sub-list for method input_type
	8,  // [8:8] is the sub-list for extension type_name
	8,  // [8:8] is the sub-list for extension extendee
	0,  // [0:8] is the sub-list for field type_name
}

func init() { file_google_cloud_bigquery_storage_v1beta_partition_proto_init() }
func file_google_cloud_bigquery_storage_v1beta_partition_proto_init() {
	if File_google_cloud_bigquery_storage_v1beta_partition_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_bigquery_storage_v1beta_partition_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   10,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_bigquery_storage_v1beta_partition_proto_goTypes,
		DependencyIndexes: file_google_cloud_bigquery_storage_v1beta_partition_proto_depIdxs,
		MessageInfos:      file_google_cloud_bigquery_storage_v1beta_partition_proto_msgTypes,
	}.Build()
	File_google_cloud_bigquery_storage_v1beta_partition_proto = out.File
	file_google_cloud_bigquery_storage_v1beta_partition_proto_rawDesc = nil
	file_google_cloud_bigquery_storage_v1beta_partition_proto_goTypes = nil
	file_google_cloud_bigquery_storage_v1beta_partition_proto_depIdxs = nil
}
