/*
Copyright The cert-manager Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1 "github.com/cert-manager/cert-manager/pkg/apis/certmanager/v1"
	certmanagerv1 "github.com/cert-manager/cert-manager/pkg/client/clientset/versioned/typed/certmanager/v1"
	gentype "k8s.io/client-go/gentype"
)

// fakeIssuers implements IssuerInterface
type fakeIssuers struct {
	*gentype.FakeClientWithList[*v1.Issuer, *v1.IssuerList]
	Fake *FakeCertmanagerV1
}

func newFakeIssuers(fake *FakeCertmanagerV1, namespace string) certmanagerv1.IssuerInterface {
	return &fakeIssuers{
		gentype.NewFakeClientWithList[*v1.Issuer, *v1.IssuerList](
			fake.Fake,
			namespace,
			v1.SchemeGroupVersion.WithResource("issuers"),
			v1.SchemeGroupVersion.WithKind("Issuer"),
			func() *v1.Issuer { return &v1.Issuer{} },
			func() *v1.IssuerList { return &v1.IssuerList{} },
			func(dst, src *v1.IssuerList) { dst.ListMeta = src.ListMeta },
			func(list *v1.IssuerList) []*v1.Issuer { return gentype.ToPointerSlice(list.Items) },
			func(list *v1.IssuerList, items []*v1.Issuer) { list.Items = gentype.FromPointerSlice(items) },
		),
		fake,
	}
}
