// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/gsuiteaddons/v1/gsuiteaddons.proto

package gsuiteaddonspb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	GSuiteAddOns_GetAuthorization_FullMethodName    = "/google.cloud.gsuiteaddons.v1.GSuiteAddOns/GetAuthorization"
	GSuiteAddOns_CreateDeployment_FullMethodName    = "/google.cloud.gsuiteaddons.v1.GSuiteAddOns/CreateDeployment"
	GSuiteAddOns_ReplaceDeployment_FullMethodName   = "/google.cloud.gsuiteaddons.v1.GSuiteAddOns/ReplaceDeployment"
	GSuiteAddOns_GetDeployment_FullMethodName       = "/google.cloud.gsuiteaddons.v1.GSuiteAddOns/GetDeployment"
	GSuiteAddOns_ListDeployments_FullMethodName     = "/google.cloud.gsuiteaddons.v1.GSuiteAddOns/ListDeployments"
	GSuiteAddOns_DeleteDeployment_FullMethodName    = "/google.cloud.gsuiteaddons.v1.GSuiteAddOns/DeleteDeployment"
	GSuiteAddOns_InstallDeployment_FullMethodName   = "/google.cloud.gsuiteaddons.v1.GSuiteAddOns/InstallDeployment"
	GSuiteAddOns_UninstallDeployment_FullMethodName = "/google.cloud.gsuiteaddons.v1.GSuiteAddOns/UninstallDeployment"
	GSuiteAddOns_GetInstallStatus_FullMethodName    = "/google.cloud.gsuiteaddons.v1.GSuiteAddOns/GetInstallStatus"
)

// GSuiteAddOnsClient is the client API for GSuiteAddOns service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type GSuiteAddOnsClient interface {
	// Gets the authorization information for deployments in a given project.
	GetAuthorization(ctx context.Context, in *GetAuthorizationRequest, opts ...grpc.CallOption) (*Authorization, error)
	// Creates a deployment with the specified name and configuration.
	CreateDeployment(ctx context.Context, in *CreateDeploymentRequest, opts ...grpc.CallOption) (*Deployment, error)
	// Creates or replaces a deployment with the specified name.
	ReplaceDeployment(ctx context.Context, in *ReplaceDeploymentRequest, opts ...grpc.CallOption) (*Deployment, error)
	// Gets the deployment with the specified name.
	GetDeployment(ctx context.Context, in *GetDeploymentRequest, opts ...grpc.CallOption) (*Deployment, error)
	// Lists all deployments in a particular project.
	ListDeployments(ctx context.Context, in *ListDeploymentsRequest, opts ...grpc.CallOption) (*ListDeploymentsResponse, error)
	// Deletes the deployment with the given name.
	DeleteDeployment(ctx context.Context, in *DeleteDeploymentRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Installs a deployment in developer mode.
	// See:
	// https://developers.google.com/gsuite/add-ons/how-tos/testing-gsuite-addons.
	InstallDeployment(ctx context.Context, in *InstallDeploymentRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Uninstalls a developer mode deployment.
	// See:
	// https://developers.google.com/gsuite/add-ons/how-tos/testing-gsuite-addons.
	UninstallDeployment(ctx context.Context, in *UninstallDeploymentRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Fetches the install status of a developer mode deployment.
	GetInstallStatus(ctx context.Context, in *GetInstallStatusRequest, opts ...grpc.CallOption) (*InstallStatus, error)
}

type gSuiteAddOnsClient struct {
	cc grpc.ClientConnInterface
}

func NewGSuiteAddOnsClient(cc grpc.ClientConnInterface) GSuiteAddOnsClient {
	return &gSuiteAddOnsClient{cc}
}

func (c *gSuiteAddOnsClient) GetAuthorization(ctx context.Context, in *GetAuthorizationRequest, opts ...grpc.CallOption) (*Authorization, error) {
	out := new(Authorization)
	err := c.cc.Invoke(ctx, GSuiteAddOns_GetAuthorization_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gSuiteAddOnsClient) CreateDeployment(ctx context.Context, in *CreateDeploymentRequest, opts ...grpc.CallOption) (*Deployment, error) {
	out := new(Deployment)
	err := c.cc.Invoke(ctx, GSuiteAddOns_CreateDeployment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gSuiteAddOnsClient) ReplaceDeployment(ctx context.Context, in *ReplaceDeploymentRequest, opts ...grpc.CallOption) (*Deployment, error) {
	out := new(Deployment)
	err := c.cc.Invoke(ctx, GSuiteAddOns_ReplaceDeployment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gSuiteAddOnsClient) GetDeployment(ctx context.Context, in *GetDeploymentRequest, opts ...grpc.CallOption) (*Deployment, error) {
	out := new(Deployment)
	err := c.cc.Invoke(ctx, GSuiteAddOns_GetDeployment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gSuiteAddOnsClient) ListDeployments(ctx context.Context, in *ListDeploymentsRequest, opts ...grpc.CallOption) (*ListDeploymentsResponse, error) {
	out := new(ListDeploymentsResponse)
	err := c.cc.Invoke(ctx, GSuiteAddOns_ListDeployments_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gSuiteAddOnsClient) DeleteDeployment(ctx context.Context, in *DeleteDeploymentRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, GSuiteAddOns_DeleteDeployment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gSuiteAddOnsClient) InstallDeployment(ctx context.Context, in *InstallDeploymentRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, GSuiteAddOns_InstallDeployment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gSuiteAddOnsClient) UninstallDeployment(ctx context.Context, in *UninstallDeploymentRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, GSuiteAddOns_UninstallDeployment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gSuiteAddOnsClient) GetInstallStatus(ctx context.Context, in *GetInstallStatusRequest, opts ...grpc.CallOption) (*InstallStatus, error) {
	out := new(InstallStatus)
	err := c.cc.Invoke(ctx, GSuiteAddOns_GetInstallStatus_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// GSuiteAddOnsServer is the server API for GSuiteAddOns service.
// All implementations should embed UnimplementedGSuiteAddOnsServer
// for forward compatibility
type GSuiteAddOnsServer interface {
	// Gets the authorization information for deployments in a given project.
	GetAuthorization(context.Context, *GetAuthorizationRequest) (*Authorization, error)
	// Creates a deployment with the specified name and configuration.
	CreateDeployment(context.Context, *CreateDeploymentRequest) (*Deployment, error)
	// Creates or replaces a deployment with the specified name.
	ReplaceDeployment(context.Context, *ReplaceDeploymentRequest) (*Deployment, error)
	// Gets the deployment with the specified name.
	GetDeployment(context.Context, *GetDeploymentRequest) (*Deployment, error)
	// Lists all deployments in a particular project.
	ListDeployments(context.Context, *ListDeploymentsRequest) (*ListDeploymentsResponse, error)
	// Deletes the deployment with the given name.
	DeleteDeployment(context.Context, *DeleteDeploymentRequest) (*emptypb.Empty, error)
	// Installs a deployment in developer mode.
	// See:
	// https://developers.google.com/gsuite/add-ons/how-tos/testing-gsuite-addons.
	InstallDeployment(context.Context, *InstallDeploymentRequest) (*emptypb.Empty, error)
	// Uninstalls a developer mode deployment.
	// See:
	// https://developers.google.com/gsuite/add-ons/how-tos/testing-gsuite-addons.
	UninstallDeployment(context.Context, *UninstallDeploymentRequest) (*emptypb.Empty, error)
	// Fetches the install status of a developer mode deployment.
	GetInstallStatus(context.Context, *GetInstallStatusRequest) (*InstallStatus, error)
}

// UnimplementedGSuiteAddOnsServer should be embedded to have forward compatible implementations.
type UnimplementedGSuiteAddOnsServer struct {
}

func (UnimplementedGSuiteAddOnsServer) GetAuthorization(context.Context, *GetAuthorizationRequest) (*Authorization, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAuthorization not implemented")
}
func (UnimplementedGSuiteAddOnsServer) CreateDeployment(context.Context, *CreateDeploymentRequest) (*Deployment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDeployment not implemented")
}
func (UnimplementedGSuiteAddOnsServer) ReplaceDeployment(context.Context, *ReplaceDeploymentRequest) (*Deployment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReplaceDeployment not implemented")
}
func (UnimplementedGSuiteAddOnsServer) GetDeployment(context.Context, *GetDeploymentRequest) (*Deployment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDeployment not implemented")
}
func (UnimplementedGSuiteAddOnsServer) ListDeployments(context.Context, *ListDeploymentsRequest) (*ListDeploymentsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDeployments not implemented")
}
func (UnimplementedGSuiteAddOnsServer) DeleteDeployment(context.Context, *DeleteDeploymentRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDeployment not implemented")
}
func (UnimplementedGSuiteAddOnsServer) InstallDeployment(context.Context, *InstallDeploymentRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method InstallDeployment not implemented")
}
func (UnimplementedGSuiteAddOnsServer) UninstallDeployment(context.Context, *UninstallDeploymentRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UninstallDeployment not implemented")
}
func (UnimplementedGSuiteAddOnsServer) GetInstallStatus(context.Context, *GetInstallStatusRequest) (*InstallStatus, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetInstallStatus not implemented")
}

// UnsafeGSuiteAddOnsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to GSuiteAddOnsServer will
// result in compilation errors.
type UnsafeGSuiteAddOnsServer interface {
	mustEmbedUnimplementedGSuiteAddOnsServer()
}

func RegisterGSuiteAddOnsServer(s grpc.ServiceRegistrar, srv GSuiteAddOnsServer) {
	s.RegisterService(&GSuiteAddOns_ServiceDesc, srv)
}

func _GSuiteAddOns_GetAuthorization_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAuthorizationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GSuiteAddOnsServer).GetAuthorization(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GSuiteAddOns_GetAuthorization_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GSuiteAddOnsServer).GetAuthorization(ctx, req.(*GetAuthorizationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GSuiteAddOns_CreateDeployment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDeploymentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GSuiteAddOnsServer).CreateDeployment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GSuiteAddOns_CreateDeployment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GSuiteAddOnsServer).CreateDeployment(ctx, req.(*CreateDeploymentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GSuiteAddOns_ReplaceDeployment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReplaceDeploymentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GSuiteAddOnsServer).ReplaceDeployment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GSuiteAddOns_ReplaceDeployment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GSuiteAddOnsServer).ReplaceDeployment(ctx, req.(*ReplaceDeploymentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GSuiteAddOns_GetDeployment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDeploymentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GSuiteAddOnsServer).GetDeployment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GSuiteAddOns_GetDeployment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GSuiteAddOnsServer).GetDeployment(ctx, req.(*GetDeploymentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GSuiteAddOns_ListDeployments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDeploymentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GSuiteAddOnsServer).ListDeployments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GSuiteAddOns_ListDeployments_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GSuiteAddOnsServer).ListDeployments(ctx, req.(*ListDeploymentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GSuiteAddOns_DeleteDeployment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDeploymentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GSuiteAddOnsServer).DeleteDeployment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GSuiteAddOns_DeleteDeployment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GSuiteAddOnsServer).DeleteDeployment(ctx, req.(*DeleteDeploymentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GSuiteAddOns_InstallDeployment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InstallDeploymentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GSuiteAddOnsServer).InstallDeployment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GSuiteAddOns_InstallDeployment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GSuiteAddOnsServer).InstallDeployment(ctx, req.(*InstallDeploymentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GSuiteAddOns_UninstallDeployment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UninstallDeploymentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GSuiteAddOnsServer).UninstallDeployment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GSuiteAddOns_UninstallDeployment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GSuiteAddOnsServer).UninstallDeployment(ctx, req.(*UninstallDeploymentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GSuiteAddOns_GetInstallStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInstallStatusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GSuiteAddOnsServer).GetInstallStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GSuiteAddOns_GetInstallStatus_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GSuiteAddOnsServer).GetInstallStatus(ctx, req.(*GetInstallStatusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// GSuiteAddOns_ServiceDesc is the grpc.ServiceDesc for GSuiteAddOns service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var GSuiteAddOns_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.gsuiteaddons.v1.GSuiteAddOns",
	HandlerType: (*GSuiteAddOnsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetAuthorization",
			Handler:    _GSuiteAddOns_GetAuthorization_Handler,
		},
		{
			MethodName: "CreateDeployment",
			Handler:    _GSuiteAddOns_CreateDeployment_Handler,
		},
		{
			MethodName: "ReplaceDeployment",
			Handler:    _GSuiteAddOns_ReplaceDeployment_Handler,
		},
		{
			MethodName: "GetDeployment",
			Handler:    _GSuiteAddOns_GetDeployment_Handler,
		},
		{
			MethodName: "ListDeployments",
			Handler:    _GSuiteAddOns_ListDeployments_Handler,
		},
		{
			MethodName: "DeleteDeployment",
			Handler:    _GSuiteAddOns_DeleteDeployment_Handler,
		},
		{
			MethodName: "InstallDeployment",
			Handler:    _GSuiteAddOns_InstallDeployment_Handler,
		},
		{
			MethodName: "UninstallDeployment",
			Handler:    _GSuiteAddOns_UninstallDeployment_Handler,
		},
		{
			MethodName: "GetInstallStatus",
			Handler:    _GSuiteAddOns_GetInstallStatus_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/gsuiteaddons/v1/gsuiteaddons.proto",
}
