/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics;

import io.jenetics.Chromosome;
import io.jenetics.Gene;
import io.jenetics.Genotype;
import io.jenetics.Phenotype;
import io.jenetics.Recombinator;
import io.jenetics.internal.util.Hash;
import io.jenetics.util.ISeq;
import io.jenetics.util.MSeq;
import io.jenetics.util.Mean;
import io.jenetics.util.RandomRegistry;
import io.jenetics.util.Seq;
import java.util.Random;

public final class MeanAlterer<G extends Gene<?, G> & Mean<G>, C extends Comparable<? super C>>
extends Recombinator<G, C> {
    public MeanAlterer(double probability2) {
        super(probability2, 2);
    }

    public MeanAlterer() {
        this(0.05);
    }

    @Override
    protected int recombine(MSeq<Phenotype<G, C>> population, int[] individuals, long generation) {
        Random random2 = RandomRegistry.getRandom();
        Phenotype pt1 = (Phenotype)population.get(individuals[0]);
        Phenotype pt2 = (Phenotype)population.get(individuals[1]);
        Genotype gt1 = pt1.getGenotype();
        Genotype gt2 = pt2.getGenotype();
        int cindex = random2.nextInt(Math.min(gt1.length(), gt2.length()));
        Object c1 = gt1.toSeq().copy();
        ISeq c2 = gt2.toSeq();
        MSeq mean = MeanAlterer.mean(((Chromosome)c1.get(cindex)).toSeq().copy(), ((Chromosome)c2.get(cindex)).toSeq());
        c1.set(cindex, ((Chromosome)c1.get(cindex)).newInstance(mean.toISeq()));
        population.set(individuals[0], pt1.newInstance(Genotype.of(c1), generation));
        return 1;
    }

    private static <G extends Gene<?, G> & Mean<G>> MSeq<G> mean(MSeq<G> a, Seq<G> b) {
        int i = a.length();
        while (--i >= 0) {
            a.set(i, ((Mean)((Object)((Gene)a.get(i)))).mean(b.get(i)));
        }
        return a;
    }

    @Override
    public int hashCode() {
        return Hash.of(this.getClass()).and(super.hashCode()).value();
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this || obj instanceof MeanAlterer && super.equals(obj);
    }

    public String toString() {
        return String.format("%s[p=%f]", this.getClass().getSimpleName(), this._probability);
    }
}

