import React, { FC, memo, useMemo } from 'react';
import { Motif } from '@ubnt/ui-components/utils/commonTypes';
import { ThemeContextValue } from '@ubnt/ui-components/ThemeContext/ThemeContext';
import useMotif from '@ubnt/ui-components/utils/useMotif';

import { Theme } from 'shared/constants/theme';

const GraphPlaceholder: FC = () => {
  const { motif }: ThemeContextValue = useMotif();
  const { verticalLine, background, bar } = useMemo<{ verticalLine: string; background: string; bar: string }>(
    () =>
      ((isDark: boolean) => ({
        verticalLine: isDark ? '#191919' : '#EDEDF0',
        background: isDark ? '#232323' : '#DBDCE1',
        bar: isDark ? '#3F3F3F' : '#FBFBFC',
      }))(motif === Theme.DARK),
    [motif],
  );
  return (
    <svg height="100%" preserveAspectRatio="none" viewBox="0 0 981 220" fill="none">
      <rect y="74" width="981" height="1" fill={verticalLine} />
      <rect y="110" width="981" height="1" fill={verticalLine} />
      <rect y="145" width="981" height="1" fill={verticalLine} />
      <rect y="181" width="981" height="1" fill={verticalLine} />
      <path
        opacity="0.8"
        fillRule="evenodd"
        clipRule="evenodd"
        d="M0 220V39.5135C0 37.9577 1.69825 36.9976 3.03126 37.7998L8.68024 41.1994C9.55543 41.7261 10.6869 41.5086 11.3045 40.6951L20.4375 28.6643L29.5917 15.6368C30.1924 14.7818 31.35 14.5334 32.2486 15.0666L40.6058 20.025C40.7842 20.1309 40.945 20.2638 41.0825 20.4191L50.1298 30.6357C50.7045 31.2847 51.6319 31.4895 52.4266 31.143L61.1797 27.3256C61.2681 27.2871 61.3536 27.2421 61.4356 27.1912L69.8997 21.9332C70.8113 21.3669 72.0073 21.621 72.6099 22.5089L81.1549 35.0988C81.5271 35.6472 82.1469 35.9756 82.8097 35.9756H91.373C91.7617 35.9756 92.142 35.8623 92.4674 35.6496L102.188 29.2949L111.61 22.9819C112.113 22.6446 112.743 22.5537 113.321 22.735L122.625 25.6508L132.639 28.9429C132.775 28.9876 132.906 29.0467 133.029 29.1192L141.581 34.1511C142.433 34.6526 143.523 34.456 144.147 33.6887L152.714 23.1463C153.075 22.7024 153.608 22.4342 154.18 22.4095L162.689 22.0418C163.209 22.0194 163.717 22.2006 164.106 22.5471L172.782 30.2817C173.355 30.7924 174.169 30.9303 174.878 30.6366L183.938 26.8837L192.785 22.581C193.595 22.1872 194.568 22.3831 195.162 23.0596L203.8 32.8917C204.167 33.3091 204.691 33.5552 205.246 33.5709L214.322 33.8273C214.502 33.8324 214.683 33.8131 214.858 33.7699L224.116 31.4856C224.566 31.3745 224.964 31.1103 225.241 30.7383L234.374 18.4725C234.783 17.9228 235.445 17.6209 236.129 17.6726L245.25 18.3627L254.63 19.1856C255.167 19.2326 255.661 19.4937 256.002 19.91L265.353 31.3157C265.572 31.5835 265.718 31.9037 265.777 32.2449L274.718 84.273C275.059 86.2567 277.786 86.5511 278.542 84.6858L283.646 72.0975C283.87 71.5448 284.329 71.1209 284.898 70.9415L295.681 67.5424C296.11 67.4069 296.573 67.4205 296.994 67.5807L304.382 70.3942C305.528 70.8307 306.793 70.142 307.049 68.9424L316.536 24.4684C316.687 23.7585 317.212 23.1864 317.906 22.9735L326.641 20.2949C326.878 20.2221 327.1 20.1057 327.295 19.9517L336.81 12.4288C337.078 12.2168 337.396 12.077 337.734 12.0229L346.639 10.5953C347.151 10.5132 347.675 10.6332 348.1 10.9299L357.534 17.5127C357.615 17.5694 357.692 17.6321 357.764 17.7002L366.623 26.0831C367.343 26.7639 368.452 26.8155 369.232 26.2046L377.307 19.8761C377.802 19.4877 378.452 19.3553 379.06 19.5188L387.525 21.795C388.03 21.9308 388.568 21.8635 389.024 21.6075L397.515 16.8396C398.143 16.4868 398.912 16.4992 399.529 16.872L408.236 22.1375C408.571 22.3402 408.84 22.637 409.008 22.9909L417.173 40.1842C417.895 41.7029 420.054 41.708 420.782 40.1929L428.938 23.2294C429.101 22.8906 429.356 22.6046 429.674 22.4041L438.203 17.0276C438.923 16.5733 439.852 16.6253 440.518 17.1572L448.62 23.633C449.232 24.1222 450.074 24.2089 450.773 23.8547L458.738 19.8195C459.415 19.4762 460.229 19.5464 460.838 20.0006L468.513 25.7278C469.377 26.3725 470.597 26.2164 471.271 25.375L479.269 15.3861C479.859 14.6489 480.885 14.4251 481.728 14.8493L490.112 19.0639C490.368 19.1925 490.593 19.3747 490.772 19.598L498.989 29.8232C499.842 30.8842 501.482 30.802 502.225 29.661L509.999 17.7113C510.539 16.882 511.603 16.5718 512.504 16.9817L520.693 20.7086C520.997 20.8471 521.331 20.9071 521.664 20.8831L530.266 20.2645C530.956 20.2149 531.571 19.8126 531.893 19.2007L540.848 2.17465C541.284 1.34584 542.236 0.930488 543.14 1.17512L550.845 3.26023C551.454 3.425 551.949 3.8673 552.182 4.45362L562.031 29.2949L571.04 53.9232C571.573 55.3814 573.492 55.7022 574.471 54.4966L581.125 46.2984C581.853 45.4017 583.187 45.3061 584.035 46.0899L591.971 53.4219C592.423 53.8399 593.043 54.0261 593.651 53.9266L602.628 52.4573C602.813 52.4271 602.992 52.3713 603.161 52.2914L611.161 48.506C612.219 48.0057 613.478 48.5156 613.889 49.6106L623.235 74.4965C623.307 74.6877 623.408 74.8668 623.534 75.0275L631.611 85.3264C632.517 86.4821 634.319 86.2993 634.974 84.9851L642.725 69.4504C643.277 68.343 644.693 67.9981 645.693 68.7273L652.209 73.4787C653.167 74.1773 654.519 73.8937 655.116 72.869L663.366 58.6971C663.858 57.852 664.889 57.4866 665.803 57.8331L672.695 60.4452C673.677 60.8172 674.779 60.3672 675.22 59.4147L684.581 39.1745C684.631 39.0666 684.691 38.9634 684.759 38.866L694.355 25.1777C694.686 24.7064 695.203 24.4003 695.775 24.3377L704.519 23.3812C704.894 23.3401 705.274 23.4063 705.614 23.5721L714.235 27.7807C714.898 28.1044 715.686 28.0366 716.284 27.6042L725.265 21.1121C725.441 20.9847 725.637 20.8868 725.845 20.8225L734.754 18.0638C735.378 17.8706 736.057 17.9944 736.573 18.3954L745.412 25.2679C745.772 25.5481 746.218 25.6966 746.674 25.6887L755.875 25.5287C756.082 25.5251 756.287 25.4893 756.484 25.4225L765.439 22.3772C766.046 22.1706 766.716 22.2681 767.24 22.6393L775.628 28.5877C776.24 29.0218 777.044 29.0767 777.709 28.7299L786.476 24.1605C786.719 24.0342 786.984 23.9589 787.257 23.9392L797.062 23.2328L806.597 21.5223C807.04 21.4428 807.497 21.5151 807.894 21.7273L817.106 26.655C817.366 26.7936 817.652 26.8734 817.946 26.8887L827.529 27.3876C827.655 27.3941 827.782 27.3887 827.907 27.3714L837.385 26.0614C837.746 26.0114 838.115 26.0613 838.45 26.2057L847.364 30.0455C847.87 30.2634 848.263 30.6803 848.452 31.1979L856.496 53.2869C857.135 55.041 859.615 55.041 860.254 53.2869L868.298 31.1979C868.487 30.6803 868.881 30.2634 869.386 30.0455L878.021 26.3258C878.526 26.1083 879.099 26.1083 879.604 26.3258L888.759 30.2697C888.94 30.3474 889.108 30.4514 889.258 30.5781L897.489 37.5261C898.419 38.3107 899.828 38.0907 900.474 37.06L908.722 23.902C909.17 23.1874 910.018 22.8306 910.842 23.01L918.722 24.726C919.331 24.8586 919.966 24.7 920.441 24.2971L929.906 16.2688L938.66 10.2588C939.495 9.68494 940.628 9.82717 941.296 10.5898L948.904 19.2758C949.678 20.1592 951.042 20.189 951.854 19.3403L961.5 9.25264L969.697 1.08105C970.337 0.443097 971.325 0.313455 972.108 0.764752L979.999 5.31399C980.618 5.67109 981 6.33169 981 7.04668V220"
        fill={background}
      />
      <path
        opacity="0.5"
        d="M8 98.5741C8 97.4695 8.89543 96.5741 10 96.5741C11.1046 96.5741 12 97.4695 12 98.5741V220H8V98.5741Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M40 98.5741C40 97.4695 40.8954 96.5741 42 96.5741C43.1046 96.5741 44 97.4695 44 98.5741V220H40V98.5741Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M32 98.5741C32 97.4695 32.8954 96.5741 34 96.5741C35.1046 96.5741 36 97.4695 36 98.5741V220H32V98.5741Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M16 172.197C16 171.092 16.8954 170.197 18 170.197C19.1046 170.197 20 171.092 20 172.197V220H16V172.197Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M48 172.197C48 171.092 48.8954 170.197 50 170.197C51.1046 170.197 52 171.092 52 172.197V220H48V172.197Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M24 128.889C24 127.785 24.8954 126.889 26 126.889C27.1046 126.889 28 127.785 28 128.889V220H24V128.889Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M57 128.889C57 127.785 57.8954 126.889 59 126.889C60.1046 126.889 61 127.785 61 128.889V220H57V128.889Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M65 71.507C65 70.4024 65.8954 69.507 67 69.507C68.1046 69.507 69 70.4024 69 71.507V220H65V71.507Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M73 46.6052C73 45.5007 73.8954 44.6052 75 44.6052C76.1046 44.6052 77 45.5007 77 46.6052V220H73V46.6052Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M81 144.047C81 142.942 81.8954 142.047 83 142.047C84.1046 142.047 85 142.942 85 144.047V220H81V144.047Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M89 79.0858C89 77.9812 89.8954 77.0858 91 77.0858C92.1046 77.0858 93 77.9812 93 79.0858V220H89V79.0858Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M97 173.279C97 172.175 97.8954 171.279 99 171.279C100.105 171.279 101 172.175 101 173.279V220H97V173.279Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M105 61.7628C105 60.6582 105.895 59.7628 107 59.7628C108.105 59.7628 109 60.6582 109 61.7628V220H105V61.7628Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M113 144.047C113 142.942 113.895 142.047 115 142.047C116.105 142.047 117 142.942 117 144.047V220H113V144.047Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M121 46.6052C121 45.5007 121.895 44.6052 123 44.6052C124.105 44.6052 125 45.5007 125 46.6052V220H121V46.6052Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M129 177.61C129 176.505 129.895 175.61 131 175.61C132.105 175.61 133 176.505 133 177.61V220H129V177.61Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M137 139.716C137 138.611 137.895 137.716 139 137.716C140.105 137.716 141 138.611 141 139.716V220H137V139.716Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M145 80.1684C145 79.0639 145.895 78.1684 147 78.1684C148.105 78.1684 149 79.0639 149 80.1684V220H145V80.1684Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M153.407 160.36C153.407 159.256 154.321 158.36 155.426 158.36C156.531 158.36 157.445 159.256 157.445 160.36V220H153.407V160.36Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M161.481 186.929C161.481 185.824 162.395 184.929 163.5 184.929C164.605 184.929 165.518 185.824 165.518 186.929V220H161.481V186.929Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M169.556 106.159C169.556 105.055 170.469 104.159 171.574 104.159C172.679 104.159 173.593 105.055 173.593 106.159V220H169.556V106.159Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M177.63 96.5947C177.63 95.4901 178.544 94.5947 179.648 94.5947C180.753 94.5947 181.667 95.4901 181.667 96.5947V220H177.63V96.5947Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M185.704 79.5905C185.704 78.486 186.618 77.5905 187.722 77.5905C188.827 77.5905 189.741 78.486 189.741 79.5905V220H185.704V79.5905Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M193.778 85.9671C193.778 84.8625 194.692 83.9671 195.796 83.9671C196.901 83.9671 197.815 84.8625 197.815 85.9671V220H193.778V85.9671Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M201.852 85.9671C201.852 84.8625 202.766 83.9671 203.87 83.9671C204.975 83.9671 205.889 84.8625 205.889 85.9671V220H201.852V85.9671Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M209.926 85.9671C209.926 84.8625 210.84 83.9671 211.944 83.9671C213.049 83.9671 213.963 84.8625 213.963 85.9671V220H209.926V85.9671Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M218 96.5947C218 95.4901 218.914 94.5947 220.019 94.5947C221.123 94.5947 222.037 95.4901 222.037 96.5947V220H218V96.5947Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M226.074 106.159C226.074 105.055 226.988 104.159 228.093 104.159C229.197 104.159 230.111 105.055 230.111 106.159V220H226.074V106.159Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M234.148 126.352C234.148 125.247 235.062 124.352 236.167 124.352C237.271 124.352 238.185 125.247 238.185 126.352V220H234.148V126.352Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M242.222 153.984C242.222 152.879 243.136 151.984 244.241 151.984C245.345 151.984 246.259 152.879 246.259 153.984V220H242.222V153.984Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M250.296 144.419C250.296 143.314 251.21 142.419 252.315 142.419C253.419 142.419 254.333 143.314 254.333 144.419V220H250.296V144.419Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M258.37 131.666C258.37 130.561 259.284 129.666 260.389 129.666C261.493 129.666 262.407 130.561 262.407 131.666V220H258.37V131.666Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M266.444 122.101C266.444 120.996 267.358 120.101 268.463 120.101C269.568 120.101 270.481 120.996 270.481 122.101V220H266.444V122.101Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M275 131.055C275 129.95 275.895 129.055 277 129.055C278.105 129.055 279 129.95 279 131.055V220H275V131.055Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M283 125.641C283 124.537 283.895 123.641 285 123.641C286.105 123.641 287 124.537 287 125.641V220H283V125.641Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M291 112.649C291 111.544 291.895 110.649 293 110.649C294.105 110.649 295 111.544 295 112.649V220H291V112.649Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M299 103.987C299 102.883 299.895 101.987 301 101.987C302.105 101.987 303 102.883 303 103.987V220H299V103.987Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M307 82.3338C307 81.2292 307.895 80.3338 309 80.3338C310.105 80.3338 311 81.2292 311 82.3338V220H307V82.3338Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M315 131.055C315 129.95 315.895 129.055 317 129.055C318.105 129.055 319 129.95 319 131.055V220H315V131.055Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M323 88.8299C323 87.7253 323.895 86.8299 325 86.8299C326.105 86.8299 327 87.7253 327 88.8299V220H323V88.8299Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M331 67.1762C331 66.0717 331.895 65.1762 333 65.1762C334.105 65.1762 335 66.0717 335 67.1762V220H331V67.1762Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M339 116.98C339 115.875 339.895 114.98 341 114.98C342.105 114.98 343 115.875 343 116.98V220H339V116.98Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M347 88.8299C347 87.7253 347.895 86.8299 349 86.8299C350.105 86.8299 351 87.7253 351 88.8299V220H347V88.8299Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M355 111.566C355 110.462 355.895 109.566 357 109.566C358.105 109.566 359 110.462 359 111.566V220H355V111.566Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M363 73.6723C363 72.5678 363.895 71.6723 365 71.6723C366.105 71.6723 367 72.5678 367 73.6723V220H363V73.6723Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M371 116.98C371 115.875 371.895 114.98 373 114.98C374.105 114.98 375 115.875 375 116.98V220H371V116.98Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M379 54.184C379 53.0795 379.895 52.184 381 52.184H382C383.105 52.184 384 53.0795 384 54.184V220H379V54.184Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M388 137.551C388 136.446 388.895 135.551 390 135.551C391.105 135.551 392 136.446 392 137.551V220H388V137.551Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M396 88.8299C396 87.7253 396.895 86.8299 398 86.8299C399.105 86.8299 400 87.7253 400 88.8299V220H396V88.8299Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M404 68.2589C404 67.1543 404.895 66.2589 406 66.2589C407.105 66.2589 408 67.1543 408 68.2589V220H404V68.2589Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M412 46.6052C412 45.5007 412.895 44.6052 414 44.6052C415.105 44.6052 416 45.5007 416 46.6052V220H412V46.6052Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M420 45.5226C420 44.418 420.895 43.5226 422 43.5226C423.105 43.5226 424 44.418 424 45.5226V220H420V45.5226Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M427.926 85.9671C427.926 84.8625 428.84 83.9671 429.944 83.9671C431.049 83.9671 431.963 84.8625 431.963 85.9671V220H427.926V85.9671Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M436 116.787C436 115.682 436.914 114.787 438.019 114.787C439.123 114.787 440.037 115.682 440.037 116.787V220H436V116.787Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M444.074 76.4023C444.074 75.2977 444.988 74.4023 446.093 74.4023C447.197 74.4023 448.111 75.2977 448.111 76.4023V220H444.074V76.4023Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M452.148 80.6533C452.148 79.5488 453.062 78.6533 454.167 78.6533C455.271 78.6533 456.185 79.5488 456.185 80.6533V220H452.148V80.6533Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M460.222 89.1554C460.222 88.0508 461.136 87.1554 462.241 87.1554C463.345 87.1554 464.259 88.0508 464.259 89.1554V220H460.222V89.1554Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M468.296 73.214C468.296 72.1094 469.21 71.214 470.315 71.214C471.419 71.214 472.333 72.1094 472.333 73.214V220H468.296V73.214Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M476.37 89.1554C476.37 88.0508 477.284 87.1554 478.389 87.1554C479.493 87.1554 480.407 88.0508 480.407 89.1554V220H476.37V89.1554Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M484.444 64.712C484.444 63.6074 485.358 62.712 486.463 62.712C487.567 62.712 488.481 63.6074 488.481 64.712V220H484.444V64.712Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M815.481 64.712C815.481 63.6074 816.395 62.712 817.5 62.712C818.605 62.712 819.518 63.6074 819.518 64.712V220H815.481V64.712Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M492.519 48.7706C492.519 47.666 493.433 46.7706 494.537 46.7706C495.642 46.7706 496.556 47.666 496.556 48.7706V220H492.519V48.7706Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M823.556 48.7706C823.556 47.666 824.47 46.7706 825.574 46.7706C826.679 46.7706 827.593 47.666 827.593 48.7706V220H823.556V48.7706Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M500.593 70.0257C500.593 68.9212 501.506 68.0257 502.611 68.0257C503.716 68.0257 504.63 68.9212 504.63 70.0257V220H500.593V70.0257Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M831.63 70.0257C831.63 68.9212 832.544 68.0257 833.648 68.0257C834.753 68.0257 835.667 68.9212 835.667 70.0257V220H831.63V70.0257Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M508.667 80.6533C508.667 79.5488 509.58 78.6533 510.685 78.6533C511.79 78.6533 512.704 79.5488 512.704 80.6533V220H508.667V80.6533Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M839.704 80.6533C839.704 79.5488 840.618 78.6533 841.722 78.6533C842.827 78.6533 843.741 79.5488 843.741 80.6533V220H839.704V80.6533Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M516.741 89.1554C516.741 88.0508 517.655 87.1554 518.759 87.1554C519.864 87.1554 520.778 88.0508 520.778 89.1554V220H516.741V89.1554Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M847.778 89.1554C847.778 88.0508 848.692 87.1554 849.796 87.1554C850.901 87.1554 851.815 88.0508 851.815 89.1554V220H847.778V89.1554Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M524.815 60.4609C524.815 59.3564 525.729 58.4609 526.833 58.4609C527.938 58.4609 528.852 59.3564 528.852 60.4609V220H524.815V60.4609Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M855.852 60.4609C855.852 59.3564 856.766 58.4609 857.87 58.4609C858.975 58.4609 859.889 59.3564 859.889 60.4609V220H855.852V60.4609Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M532.889 54.0844C532.889 52.9798 533.803 52.0844 534.907 52.0844C536.012 52.0844 536.926 52.9798 536.926 54.0844V220H532.889V54.0844Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M863.926 54.0844C863.926 52.9798 864.84 52.0844 865.944 52.0844C867.049 52.0844 867.963 52.9798 867.963 54.0844V220H863.926V54.0844Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M540.963 64.712C540.963 63.6074 541.877 62.712 542.981 62.712C544.086 62.712 545 63.6074 545 64.712V220H540.963V64.712Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M872 30.365C872 29.2604 872.895 28.365 874 28.365C875.105 28.365 876 29.2604 876 30.365V220H872V30.365Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M549.037 85.9671C549.037 84.8625 549.951 83.9671 551.056 83.9671C552.16 83.9671 553.074 84.8625 553.074 85.9671V220H549.037V85.9671Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M880 56.3494C880 55.2448 880.895 54.3494 882 54.3494C883.105 54.3494 884 55.2448 884 56.3494V220H880V56.3494Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M557.111 109.348C557.111 108.243 558.025 107.348 559.13 107.348C560.234 107.348 561.148 108.243 561.148 109.348V220H557.111V109.348Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M888 84.4992C888 83.3946 888.895 82.4992 890 82.4992C891.105 82.4992 892 83.3946 892 84.4992V220H888V84.4992Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M565.185 77.4651C565.185 76.3605 566.099 75.4651 567.204 75.4651C568.308 75.4651 569.222 76.3605 569.222 77.4651V220H565.185V77.4651Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M896 45.5226C896 44.418 896.895 43.5226 898 43.5226C899.105 43.5226 900 44.418 900 45.5226V220H896V45.5226Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M573.259 99.7829C573.259 98.6784 574.173 97.7829 575.278 97.7829C576.382 97.7829 577.296 98.6784 577.296 99.7829V220H573.259V99.7829Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M904 72.5897C904 71.4851 904.895 70.5897 906 70.5897C907.105 70.5897 908 71.4851 908 72.5897V220H904V72.5897Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M581.333 70.0257C581.333 68.9212 582.247 68.0257 583.352 68.0257C584.456 68.0257 585.37 68.9212 585.37 70.0257V220H581.333V70.0257Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M912 36.8611C912 35.7565 912.895 34.8611 914 34.8611C915.105 34.8611 916 35.7565 916 36.8611V220H912V36.8611Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M589.407 160.36C589.407 159.256 590.321 158.36 591.426 158.36C592.531 158.36 593.445 159.256 593.445 160.36V220H589.407V160.36Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M920 147.295C920 146.19 920.895 145.295 922 145.295C923.105 145.295 924 146.19 924 147.295V220H920V147.295Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M597.481 153.984C597.481 152.879 598.395 151.984 599.5 151.984C600.605 151.984 601.518 152.879 601.518 153.984V220H597.481V153.984Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M929 138.633C929 137.529 929.895 136.633 931 136.633C932.105 136.633 933 137.529 933 138.633V220H929V138.633Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M605.556 97.6574C605.556 96.5528 606.47 95.6574 607.574 95.6574C608.679 95.6574 609.593 96.5528 609.593 97.6574V220H605.556V97.6574Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M937 70.4243C937 69.3197 937.895 68.4243 939 68.4243C940.105 68.4243 941 69.3197 941 70.4243V220H937V70.4243Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M613.63 89.1554C613.63 88.0508 614.544 87.1554 615.648 87.1554C616.753 87.1554 617.667 88.0508 617.667 89.1554V220H613.63V89.1554Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M945 60.6801C945 59.5756 945.895 58.6801 947 58.6801C948.105 58.6801 949 59.5756 949 60.6801V220H945V60.6801Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M621.704 80.6533C621.704 79.5488 622.618 78.6533 623.722 78.6533C624.827 78.6533 625.741 79.5488 625.741 80.6533V220H621.704V80.6533Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M953 49.8533C953 48.7487 953.895 47.8533 955 47.8533C956.105 47.8533 957 48.7487 957 49.8533V220H953V49.8533Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M629.778 94.4692C629.778 93.3646 630.692 92.4692 631.796 92.4692C632.901 92.4692 633.815 93.3646 633.815 94.4692V220H629.778V94.4692Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M961 66.0936C961 64.989 961.895 64.0936 963 64.0936C964.105 64.0936 965 64.989 965 66.0936V220H961V66.0936Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M637.852 105.097C637.852 103.992 638.766 103.097 639.87 103.097C640.975 103.097 641.889 103.992 641.889 105.097V220H637.852V105.097Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M969 79.0858C969 77.9812 969.895 77.0858 971 77.0858C972.105 77.0858 973 77.9812 973 79.0858V220H969V79.0858Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M645.926 131.666C645.926 130.561 646.84 129.666 647.944 129.666C649.049 129.666 649.963 130.561 649.963 131.666V220H645.926V131.666Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M977 111.566C977 110.462 977.895 109.566 979 109.566C980.105 109.566 981 110.462 981 111.566V220H977V111.566Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M654 164.611C654 163.507 654.914 162.611 656.019 162.611C657.123 162.611 658.037 163.507 658.037 164.611V220H654V164.611Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M662.074 155.046C662.074 153.942 662.988 153.046 664.093 153.046C665.197 153.046 666.111 153.942 666.111 155.046V220H662.074V155.046Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M670.148 126.352C670.148 125.247 671.062 124.352 672.167 124.352C673.271 124.352 674.185 125.247 674.185 126.352V220H670.148V126.352Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M678.222 85.9671C678.222 84.8625 679.136 83.9671 680.241 83.9671C681.345 83.9671 682.259 84.8625 682.259 85.9671V220H678.222V85.9671Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M686.296 113.599C686.296 112.494 687.21 111.599 688.315 111.599C689.419 111.599 690.333 112.494 690.333 113.599V220H686.296V113.599Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M694.37 126.352C694.37 125.247 695.284 124.352 696.389 124.352C697.493 124.352 698.407 125.247 698.407 126.352V220H694.37V126.352Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M702.444 186.929C702.444 185.824 703.358 184.929 704.463 184.929C705.567 184.929 706.481 185.824 706.481 186.929V220H702.444V186.929Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M710.519 166.737C710.519 165.632 711.433 164.737 712.537 164.737C713.642 164.737 714.556 165.632 714.556 166.737V220H710.519V166.737Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M718.593 125.289C718.593 124.184 719.506 123.289 720.611 123.289C721.716 123.289 722.63 124.184 722.63 125.289V220H718.593V125.289Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M726.667 109.348C726.667 108.243 727.581 107.348 728.685 107.348C729.79 107.348 730.704 108.243 730.704 109.348V220H726.667V109.348Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M734.741 128.477C734.741 127.373 735.655 126.477 736.759 126.477C737.864 126.477 738.778 127.373 738.778 128.477V220H734.741V128.477Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M742.815 141.23C742.815 140.126 743.729 139.23 744.833 139.23C745.938 139.23 746.852 140.126 746.852 141.23V220H742.815V141.23Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M750.889 90.2182C750.889 89.1136 751.803 88.2182 752.907 88.2182C754.012 88.2182 754.926 89.1136 754.926 90.2182V220H750.889V90.2182Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M758.963 112.536C758.963 111.431 759.877 110.536 760.981 110.536C762.086 110.536 763 111.431 763 112.536V220H758.963V112.536Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M767.037 125.289C767.037 124.184 767.951 123.289 769.056 123.289C770.16 123.289 771.074 124.184 771.074 125.289V220H767.037V125.289Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M775.111 145.481C775.111 144.377 776.025 143.481 777.13 143.481C778.234 143.481 779.148 144.377 779.148 145.481V220H775.111V145.481Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M783.185 141.23C783.185 140.126 784.099 139.23 785.204 139.23C786.308 139.23 787.222 140.126 787.222 141.23V220H783.185V141.23Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M791.259 144.419C791.259 143.314 792.173 142.419 793.278 142.419C794.382 142.419 795.296 143.314 795.296 144.419V220H791.259V144.419Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M799.333 109.348C799.333 108.243 800.247 107.348 801.352 107.348C802.456 107.348 803.37 108.243 803.37 109.348V220H799.333V109.348Z"
        fill={bar}
      />
      <path
        opacity="0.5"
        d="M807.407 104.034C807.407 102.929 808.321 102.034 809.426 102.034C810.531 102.034 811.445 102.929 811.445 104.034V220H807.407V104.034Z"
        fill={bar}
      />
    </svg>
  );
};

export default memo(GraphPlaceholder);
