/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.internal.util;

import io.jenetics.internal.util.require;
import io.jenetics.util.Seq;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Predicate;

public final class Equality {
    public static final Predicate<Object> TRUE = a -> true;

    private Equality() {
        require.noInstance();
    }

    public static <T> Predicate<T> True() {
        return TRUE;
    }

    public static <T> Predicate<Predicate<T>> of(T self, Object other) {
        Objects.requireNonNull(self);
        return self == other ? p -> true : (other == null || self.getClass() != other.getClass() ? p -> false : p -> p.test(other));
    }

    public static boolean ofType(Object self, Object other) {
        Objects.requireNonNull(self);
        return self == other || other != null && self.getClass() == other.getClass();
    }

    public static boolean eq(boolean a, boolean b) {
        return a == b;
    }

    public static boolean eq(boolean[] a, boolean[] b) {
        return Arrays.equals(a, b);
    }

    public static boolean eq(byte a, byte b) {
        return a == b;
    }

    public static boolean eq(byte[] a, byte[] b) {
        return Arrays.equals(a, b);
    }

    public static boolean eq(char a, char b) {
        return a == b;
    }

    public static boolean eq(char[] a, char[] b) {
        return Arrays.equals(a, b);
    }

    public static boolean eq(short a, short b) {
        return a == b;
    }

    public static boolean eq(short[] a, short[] b) {
        return Arrays.equals(a, b);
    }

    public static boolean eq(int a, int b) {
        return a == b;
    }

    public static boolean eq(int[] a, int[] b) {
        return Arrays.equals(a, b);
    }

    public static boolean eq(long a, long b) {
        return a == b;
    }

    public static boolean eq(long[] a, long[] b) {
        return Arrays.equals(a, b);
    }

    public static boolean eq(float a, float b) {
        return Float.floatToIntBits(a) == Float.floatToIntBits(b);
    }

    public static boolean eq(float[] a, float[] b) {
        return Arrays.equals(a, b);
    }

    public static boolean eq(double a, double b) {
        return Double.doubleToLongBits(a) == Double.doubleToLongBits(b);
    }

    public static boolean eq(double[] a, double[] b) {
        return Arrays.equals(a, b);
    }

    public static boolean eq(Enum<?> a, Enum<?> b) {
        return a == b;
    }

    public static boolean eq(Object a, Object b) {
        return a != null ? a.equals(b) : b == null;
    }

    public static boolean eq(Object[] a, Object[] b) {
        return Arrays.equals(a, b);
    }

    public static boolean eq(Seq<?> a, Seq<?> b) {
        return Seq.equals(a, b);
    }
}

