/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.engine;

import io.jenetics.Gene;
import io.jenetics.Phenotype;
import io.jenetics.engine.Engine;
import io.jenetics.internal.util.Concurrency;
import io.jenetics.util.ISeq;
import io.jenetics.util.Seq;
import java.util.Objects;
import java.util.concurrent.Executor;

final class ConcurrentEvaluator<G extends Gene<?, G>, C extends Comparable<? super C>>
implements Engine.Evaluator<G, C> {
    private final Executor _executor;

    ConcurrentEvaluator(Executor executor) {
        this._executor = Objects.requireNonNull(executor);
    }

    @Override
    public ISeq<Phenotype<G, C>> evaluate(Seq<Phenotype<G, C>> population) {
        ISeq phenotypes = population.stream().filter(pt -> !pt.isEvaluated()).collect(ISeq.toISeq());
        if (phenotypes.nonEmpty()) {
            try (Concurrency c = Concurrency.with(this._executor);){
                c.execute(phenotypes);
            }
        }
        return population.asISeq();
    }
}

