/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics;

import io.jenetics.Gene;
import io.jenetics.util.ISeq;
import io.jenetics.util.RandomRegistry;
import java.io.Serializable;
import java.util.Objects;

public final class EnumGene<A>
implements Gene<A, EnumGene<A>>,
Comparable<EnumGene<A>>,
Serializable {
    private static final long serialVersionUID = 2L;
    private final ISeq<A> _validAlleles;
    private final int _alleleIndex;

    EnumGene(int alleleIndex, ISeq<? extends A> validAlleles) {
        if (validAlleles.isEmpty()) {
            throw new IllegalArgumentException("Array of valid alleles must be greater than zero.");
        }
        if (alleleIndex < 0 || alleleIndex >= validAlleles.length()) {
            throw new IndexOutOfBoundsException(String.format("Allele index is not in range [0, %d).", alleleIndex));
        }
        this._validAlleles = ISeq.upcast(validAlleles);
        this._alleleIndex = alleleIndex;
    }

    public ISeq<A> getValidAlleles() {
        return this._validAlleles;
    }

    public int getAlleleIndex() {
        return this._alleleIndex;
    }

    @Override
    public A getAllele() {
        return (A)this._validAlleles.get(this._alleleIndex);
    }

    @Override
    public boolean isValid() {
        return this._alleleIndex >= 0 && this._alleleIndex < this._validAlleles.length();
    }

    @Override
    public EnumGene<A> newInstance() {
        return new EnumGene<A>(RandomRegistry.getRandom().nextInt(this._validAlleles.length()), this._validAlleles);
    }

    @Override
    public EnumGene<A> newInstance(A value) {
        return new EnumGene<A>(this._validAlleles.indexOf(value), this._validAlleles);
    }

    @Override
    public int compareTo(EnumGene<A> gene) {
        int result = 0;
        if (this._alleleIndex > gene._alleleIndex) {
            result = 1;
        } else if (this._alleleIndex < gene._alleleIndex) {
            result = -1;
        }
        return result;
    }

    public int hashCode() {
        int hash = 17;
        hash += 31 * this._alleleIndex + 37;
        return hash += 31 * this._validAlleles.hashCode() + 37;
    }

    public boolean equals(Object obj) {
        return obj instanceof EnumGene && Objects.equals(((EnumGene)obj)._alleleIndex, this._alleleIndex) && Objects.equals(((EnumGene)obj)._validAlleles, this._validAlleles);
    }

    public String toString() {
        return Objects.toString(this.getAllele());
    }

    public static <A> EnumGene<A> of(int alleleIndex, ISeq<? extends A> validAlleles) {
        return new EnumGene<A>(alleleIndex, validAlleles);
    }

    public static <A> EnumGene<A> of(ISeq<? extends A> validAlleles) {
        return new EnumGene<A>(RandomRegistry.getRandom().nextInt(validAlleles.length()), validAlleles);
    }

    @SafeVarargs
    public static <A> EnumGene<A> of(int alleleIndex, A ... validAlleles) {
        return new EnumGene<A>(alleleIndex, ISeq.of(validAlleles));
    }

    @SafeVarargs
    public static <A> EnumGene<A> of(A ... validAlleles) {
        return EnumGene.of(ISeq.of(validAlleles));
    }
}

