/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoChangeStreamException;
import com.mongodb.MongoException;
import com.mongodb.ServerAddress;
import com.mongodb.ServerCursor;
import com.mongodb.assertions.Assertions;
import com.mongodb.internal.binding.ReadBinding;
import com.mongodb.internal.operation.AggregateResponseBatchCursor;
import com.mongodb.internal.operation.ChangeStreamBatchCursorHelper;
import com.mongodb.internal.operation.ChangeStreamOperation;
import com.mongodb.internal.operation.CommandBatchCursor;
import com.mongodb.internal.operation.SyncOperationHelper;
import com.mongodb.lang.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import org.bson.BsonDocument;
import org.bson.BsonTimestamp;
import org.bson.RawBsonDocument;
import org.bson.codecs.Decoder;

final class ChangeStreamBatchCursor<T>
implements AggregateResponseBatchCursor<T> {
    private final ReadBinding binding;
    private final ChangeStreamOperation<T> changeStreamOperation;
    private final int maxWireVersion;
    private CommandBatchCursor<RawBsonDocument> wrapped;
    private BsonDocument resumeToken;
    private final AtomicBoolean closed;

    ChangeStreamBatchCursor(ChangeStreamOperation<T> changeStreamOperation, CommandBatchCursor<RawBsonDocument> wrapped, ReadBinding binding, @Nullable BsonDocument resumeToken, int maxWireVersion) {
        this.changeStreamOperation = changeStreamOperation;
        this.binding = binding.retain();
        this.wrapped = wrapped;
        this.resumeToken = resumeToken;
        this.maxWireVersion = maxWireVersion;
        this.closed = new AtomicBoolean();
    }

    CommandBatchCursor<RawBsonDocument> getWrapped() {
        return this.wrapped;
    }

    @Override
    public boolean hasNext() {
        return this.resumeableOperation(commandBatchCursor -> {
            try {
                Boolean bl = commandBatchCursor.hasNext();
                return bl;
            }
            finally {
                this.cachePostBatchResumeToken((AggregateResponseBatchCursor<RawBsonDocument>)commandBatchCursor);
            }
        });
    }

    @Override
    public List<T> next() {
        return this.resumeableOperation(commandBatchCursor -> {
            try {
                List<T> list = ChangeStreamBatchCursor.convertAndProduceLastId((List<RawBsonDocument>)commandBatchCursor.next(), this.changeStreamOperation.getDecoder(), lastId -> {
                    this.resumeToken = lastId;
                });
                return list;
            }
            finally {
                this.cachePostBatchResumeToken((AggregateResponseBatchCursor<RawBsonDocument>)commandBatchCursor);
            }
        });
    }

    @Override
    public int available() {
        return this.wrapped.available();
    }

    @Override
    public List<T> tryNext() {
        return this.resumeableOperation(commandBatchCursor -> {
            try {
                List<RawBsonDocument> tryNext = commandBatchCursor.tryNext();
                List<T> list = tryNext == null ? null : ChangeStreamBatchCursor.convertAndProduceLastId(tryNext, this.changeStreamOperation.getDecoder(), lastId -> {
                    this.resumeToken = lastId;
                });
                return list;
            }
            finally {
                this.cachePostBatchResumeToken((AggregateResponseBatchCursor<RawBsonDocument>)commandBatchCursor);
            }
        });
    }

    @Override
    public void close() {
        if (!this.closed.getAndSet(true)) {
            this.wrapped.close();
            this.binding.release();
        }
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.wrapped.setBatchSize(batchSize);
    }

    @Override
    public int getBatchSize() {
        return this.wrapped.getBatchSize();
    }

    @Override
    public ServerCursor getServerCursor() {
        return this.wrapped.getServerCursor();
    }

    @Override
    public ServerAddress getServerAddress() {
        return this.wrapped.getServerAddress();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not implemented!");
    }

    @Override
    public BsonDocument getPostBatchResumeToken() {
        return this.wrapped.getPostBatchResumeToken();
    }

    @Override
    public BsonTimestamp getOperationTime() {
        return this.changeStreamOperation.getStartAtOperationTime();
    }

    @Override
    public boolean isFirstBatchEmpty() {
        return this.wrapped.isFirstBatchEmpty();
    }

    @Override
    public int getMaxWireVersion() {
        return this.maxWireVersion;
    }

    private void cachePostBatchResumeToken(AggregateResponseBatchCursor<RawBsonDocument> commandBatchCursor) {
        if (commandBatchCursor.getPostBatchResumeToken() != null) {
            this.resumeToken = commandBatchCursor.getPostBatchResumeToken();
        }
    }

    static <T> List<T> convertAndProduceLastId(List<RawBsonDocument> rawDocuments, Decoder<T> decoder, Consumer<BsonDocument> lastIdConsumer) {
        ArrayList<Object> results = new ArrayList<Object>();
        for (RawBsonDocument rawDocument : Assertions.assertNotNull(rawDocuments)) {
            if (!rawDocument.containsKey((Object)"_id")) {
                throw new MongoChangeStreamException("Cannot provide resume functionality when the resume token is missing.");
            }
            results.add(rawDocument.decode(decoder));
        }
        if (!rawDocuments.isEmpty()) {
            lastIdConsumer.accept(rawDocuments.get(rawDocuments.size() - 1).getDocument((Object)"_id"));
        }
        return results;
    }

    <R> R resumeableOperation(Function<AggregateResponseBatchCursor<RawBsonDocument>, R> function) {
        while (true) {
            try {
                return function.apply(this.wrapped);
            }
            catch (Throwable t) {
                if (!ChangeStreamBatchCursorHelper.isResumableError(t, this.maxWireVersion)) {
                    throw MongoException.fromThrowableNonNull(t);
                }
                this.wrapped.close();
                SyncOperationHelper.withReadConnectionSource(this.binding, source -> {
                    this.changeStreamOperation.setChangeStreamOptionsForResume(this.resumeToken, source.getServerDescription().getMaxWireVersion());
                    return null;
                });
                this.wrapped = ((ChangeStreamBatchCursor)this.changeStreamOperation.execute(this.binding)).getWrapped();
                this.binding.release();
                continue;
            }
            break;
        }
    }
}

