/*
 * Decompiled with CFR 0.152.
 */
package com.axlradius.radclient4.radutil;

import com.axlradius.radclient4.ClientReceiveException;
import com.axlradius.radclient4.ClientSendException;
import com.axlradius.radclient4.PacketType;
import com.axlradius.radclient4.RADIUSClient;
import com.axlradius.radclient4.TimeoutContext;
import com.axlradius.radclient4.attributes.AttributeList;
import com.axlradius.radclient4.dictionary.DefaultDictionary;
import com.axlradius.radclient4.radutil.Rand;
import com.axlradius.radclient4.radutil.Util;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;

public class radstatus {
    private static String f;
    private static int port;
    private static byte[] ai;
    private static String B;

    public static void main(String[] object) {
        String string;
        int n2;
        String string2;
        String string3 = null;
        if (((String[])object).length < 3) {
            radstatus.d("Too few arguments");
        }
        if ((string2 = object[0]).equalsIgnoreCase("auth")) {
            B = "auth";
            port = 1812;
        } else if (string2.equalsIgnoreCase("acct")) {
            port = 1813;
            B = "acct";
        } else {
            B = "unknown";
        }
        if (B.equals("unknown")) {
            radstatus.d("Unknown status port type: " + string2);
        }
        if ((n2 = (string = object[1]).indexOf(58)) >= 0) {
            f = string.substring(0, n2);
            try {
                string3 = string.substring(n2 + 1);
                port = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                radstatus.d("Server port number [" + string3 + "] not a number.");
            }
        } else {
            f = string;
        }
        ai = Util.toUTF8(object[2]);
        object = null;
        System.out.println("Radstatus running RADIUS client version 4.08b " + Rand.getVersion());
        try {
            object = new RADIUSClient(f, port, ai, TimeoutContext.SINGLE_PACKET.getContext());
            ((RADIUSClient)object).setDebug(true);
            ((RADIUSClient)object).addDictionary(new DefaultDictionary());
            InetAddress.getLocalHost();
        }
        catch (SocketException socketException) {
            System.err.println("Radius failed: " + socketException.getMessage());
            System.exit(1);
        }
        catch (UnknownHostException unknownHostException) {
            System.err.println("Radius failed: " + unknownHostException.getMessage());
            System.exit(1);
        }
        System.out.println("\n-------------------------------- Status -------------------------------");
        System.out.println("Sending to server " + f + ":" + port);
        try {
            AttributeList attributeList = new AttributeList();
            attributeList.add(80);
            int n3 = ((RADIUSClient)object).statusServer(attributeList);
            switch (n3) {
                case 0: {
                    System.out.println("Received bad packet: " + ((RADIUSClient)object).getErrorString());
                    break;
                }
                case 2: 
                case 5: {
                    System.out.println("The server responded");
                    AttributeList attributeList2 = ((RADIUSClient)object).getAttributes();
                    System.out.println("Attributes returned from server:\n" + attributeList2);
                    break;
                }
                default: {
                    new PacketType();
                    System.out.println("Unexpected packet type returned: " + PacketType.getName(n3));
                    break;
                }
            }
        }
        catch (ClientReceiveException clientReceiveException) {
            System.err.println("Radius authentication failed: " + clientReceiveException.getMessage());
            System.exit(1);
        }
        catch (ClientSendException clientSendException) {
            System.err.println("Radius authentication failed: " + clientSendException.getMessage());
            System.exit(1);
        }
        System.exit(0);
    }

    private static void d(String string) {
        System.out.println("Usage Error: " + string);
        System.out.println();
        System.out.println("radstatus status_check server[:port default is 1812] secretkey\n");
        System.out.println("status_check may be auth to check the authentication server or acct to check the accounting server");
        System.out.println();
        System.out.println("E.g. radstatus auth 192.168.1.1 testsecret");
        System.out.println("or radstatus acct 192.168.1.1 testsecret");
        System.exit(1);
    }
}

