/*
 * Decompiled with CFR 0.152.
 */
package com.axlradius.radclient4.auth.eap;

import com.axlradius.misc.b;
import com.axlradius.radclient4.attributes.Attribute;
import com.axlradius.radclient4.attributes.AttributeList;
import com.axlradius.radclient4.auth.eap.EAPException;
import com.axlradius.radclient4.auth.eap.EAPType;
import com.axlradius.radclient4.dictionary.BD;
import com.axlradius.radclient4.radutil.Util;
import java.util.ArrayList;
import java.util.List;

public class EAPPacket {
    public static final int CODE_REQUEST = 1;
    public static final int CODE_RESPONSE = 2;
    public static final int CODE_SUCCESS = 3;
    public static final int CODE_FAILURE = 4;
    public static final int CODE_MAXIMUM = 4;
    public static final int TYPE_UNDEFINED = 0;
    public static final int TYPE_IDENTITY = 1;
    public static final int TYPE_NOTIFICATION = 2;
    public static final int TYPE_NAK = 3;
    public static final int TYPE_MD5 = 4;
    public static final int TYPE_OTP = 5;
    public static final int TYPE_GTC = 6;
    public static final int TYPE_RSA_PUBLIC_KEY = 9;
    public static final int TYPE_DSS_UNILATERAL = 10;
    public static final int TYPE_KEA = 11;
    public static final int TYPE_KEA_VALIDATE = 12;
    public static final int TYPE_TLS = 13;
    public static final int TYPE_AXENT = 14;
    public static final int TYPE_RSASecurID = 15;
    public static final int TYPE_LEAP = 17;
    public static final int TYPE_SIM = 18;
    public static final int TYPE_SRP_SHA1 = 19;
    public static final int TYPE_TTLS = 21;
    public static final int TYPE_AKA = 23;
    public static final int TYPE_FAST = 43;
    public static final int TYPE_EKE = 53;
    public static final int TYPE_PEAP = 25;
    public static final int TYPE_PEAPV1 = 25;
    public static final int TYPE_PEAPV2 = 25;
    public static final int TYPE_MSCHAPV2 = 26;
    public static final int TYPE_MSCHAP_V2 = 29;
    public static final int TYPE_MS_AUTHENTICATION_TLV = 33;
    public static final int TYPE_HTTP_Digest = 38;
    public static final int TYPE_PSK = 47;
    public static final int TYPE_SAKE = 48;
    public static final int TYPE_IKEV2 = 49;
    public static final int TYPE_AKAPrime = 50;
    public static final int TYPE_EXPANDED_NAK = 254;
    public static final int TYPE_EXPANDED = 254;
    public static final int TYPE_EXPERIMENTAL = 255;
    public static final int MAX_ATTRIBUTE_LENGTH = 255;
    public static final int MINPACKET = 4;
    private int code;
    private int P;
    private int type = 0;
    private byte[] t;
    private int dataLength;
    private byte[] u;
    private boolean k;
    private int Q;
    private byte[] v;
    private int R;

    public EAPPacket() {
    }

    public EAPPacket(byte[] byArray) throws EAPException {
        this.f(byArray);
    }

    public EAPPacket(AttributeList attributeList) throws EAPException {
        this.f(this.a(attributeList));
    }

    public EAPPacket(int n2, int n3, int n4, byte[] byArray) {
        this.code = n2;
        this.setPacketIdentifier(n3);
        this.setData(n4, byArray);
    }

    public EAPPacket(int n2, int n3) {
        this.code = n2;
        this.setPacketIdentifier(n3);
    }

    public final AttributeList createExpandedNakResponse(int n2, EAPType[] eAPTypeArray) {
        this.setCode(1);
        this.setPacketIdentifier(n2);
        this.type = 254;
        if (eAPTypeArray == null || eAPTypeArray.length == 0) {
            byte[] byArray = new byte[]{-2, 0, 0, 0, 0, 0, 0, 3, -2, 0, 0, 0, 0, 0, 0, 0};
            this.t = byArray;
            this.dataLength = 16;
            return this.toAttributeList();
        }
        this.t = new byte[eAPTypeArray.length + 1 << 3];
        b b2 = new b(this.t);
        b2.writeByte(254);
        b2.b(0);
        b2.writeInt(3);
        for (int i2 = 0; i2 < eAPTypeArray.length; ++i2) {
            b2.writeByte(254);
            b2.b(eAPTypeArray[i2].getVendorId());
            b2.writeInt(eAPTypeArray[i2].getType());
        }
        this.dataLength = this.t.length;
        return this.toAttributeList();
    }

    public final void addVendorData(int n2, int n3, int n4) {
        if (this.t == null) {
            this.t = new byte[0];
        }
        byte[] byArray = new byte[this.dataLength + 8];
        System.arraycopy(this.t, 0, byArray, 0, this.dataLength);
        b b2 = new b(byArray);
        b2.seek(this.dataLength);
        b2.writeByte(n3);
        b2.b(n2);
        b2.writeInt(n4);
        this.t = byArray;
        this.dataLength += 8;
    }

    public int getCode() {
        return this.code;
    }

    public String getCodeName() {
        return EAPPacket.getCodeName(this.code);
    }

    public static String getCodeName(int n2) {
        String string;
        switch (n2) {
            case 1: {
                string = "REQUEST";
                break;
            }
            case 2: {
                string = "RESPONSE";
                break;
            }
            case 3: {
                string = "SUCCESS";
                break;
            }
            case 4: {
                string = "FAILURE";
                break;
            }
            default: {
                string = "UNKNOWN: " + n2;
            }
        }
        return string + "[" + n2 + "]";
    }

    public int getType() {
        return this.type;
    }

    public EAPType getEAPType() {
        if (this.isExpanded()) {
            b b2 = new b(this.t, 0);
            b2.a();
            int n2 = b2.readInt();
            return new EAPType(this.getVendorId(), n2);
        }
        return new EAPType(this.type);
    }

    public void setType(int n2) {
        this.type = n2;
    }

    public String getTypeName() {
        return EAPPacket.getTypeName(this.Q, this.type);
    }

    public static String getTypeName(int n2) {
        return EAPPacket.getTypeName(0, n2);
    }

    public static String getTypeName(EAPType eAPType) {
        if (eAPType == null) {
            return "NULL";
        }
        return EAPPacket.getTypeName(eAPType.getVendorId(), eAPType.getType());
    }

    public static String getTypeName(int n2, int n3) {
        String string;
        if (n2 != 0) {
            String string2 = BD.getVendor(n2);
            if (string2 == null) {
                return n2 + ": " + n3;
            }
            return string2 + " (" + n2 + "): " + n3;
        }
        switch (n3) {
            case 1: {
                string = "IDENTITY";
                break;
            }
            case 2: {
                string = "NOTIFICATION";
                break;
            }
            case 3: {
                string = "NAK";
                break;
            }
            case 4: {
                string = "EAP-MD5";
                break;
            }
            case 5: {
                string = "EAP-OTP";
                break;
            }
            case 6: {
                string = "EAP-GTC";
                break;
            }
            case 13: {
                string = "EAP-TLS";
                break;
            }
            case 21: {
                string = "EAP-TTLS";
                break;
            }
            case 17: {
                string = "EAP-LEAP";
                break;
            }
            case 25: {
                string = "EAP-PEAP";
                break;
            }
            case 47: {
                string = "EAP-PSK";
                break;
            }
            case 26: {
                string = "EAP-MSCHAPV2";
                break;
            }
            case 18: {
                string = "EAP-SIM";
                break;
            }
            case 23: {
                string = "EAP-AKA";
                break;
            }
            case 50: {
                string = "EAP-AKA'";
                break;
            }
            case 254: {
                string = "Vendor EXPANDED";
                break;
            }
            case 255: {
                string = "EAP-EXPERIMENTAL";
                break;
            }
            case 53: {
                string = "EAP-EKE";
                break;
            }
            case 43: {
                string = "EAP-FAST";
                break;
            }
            case 0: {
                string = "EAP-UNDEFINED";
                break;
            }
            default: {
                string = "EAP-UNKNOWN";
            }
        }
        return string;
    }

    public int getLength() {
        return this.dataLength + 4;
    }

    public byte[] getData() {
        this.code = this.getCode();
        if (this.code == 3 || this.code == 4) {
            return new byte[0];
        }
        if (this.u == null) {
            if (this.dataLength == 0) {
                return new byte[0];
            }
            this.u = new byte[this.dataLength - 1];
            System.arraycopy(this.t, 1, this.u, 0, this.u.length);
        }
        return this.u;
    }

    public byte[] getPayloadData() {
        return this.t;
    }

    public byte[] getEAPPacketData() {
        return this.f();
    }

    public String getIdentity() {
        int n2;
        if (this.type != 1) {
            return null;
        }
        Object[] objectArray = this.getData();
        char[] cArray = new String((byte[])objectArray).toCharArray();
        for (n2 = 0; n2 < cArray.length && cArray[n2] != '\u0000'; ++n2) {
        }
        if (n2 < cArray.length) {
            objectArray = new char[n2];
            System.arraycopy(cArray, 0, objectArray, 0, n2);
            return new String((char[])objectArray);
        }
        return Util.toUTF8(objectArray);
    }

    public byte[] getIdentityBytes() {
        if (this.type != 1) {
            return null;
        }
        return Util.toUTF8(this.getIdentity());
    }

    public int getPacketIdentifier() {
        return this.P;
    }

    public boolean isEAPStart() {
        return this.k;
    }

    public boolean isEAPType(int n2) {
        return this.type == n2;
    }

    public final AttributeList createStartRequest(int n2) {
        this.setCode(1);
        this.setPacketIdentifier(n2);
        this.j();
        return this.toAttributeList();
    }

    public final AttributeList createStartResponse(int n2) {
        this.setCode(2);
        this.setPacketIdentifier(n2);
        this.j();
        return this.toAttributeList();
    }

    public void setCode(int n2) {
        this.code = n2;
    }

    private void j() {
        this.t = new byte[0];
        this.dataLength = 0;
    }

    public void setData(byte[] byArray) {
        byte[] byArray2;
        int n2 = 0;
        if (byArray == null || byArray.length == 0) {
            byArray2 = new byte[1];
        } else {
            n2 = byArray[0] & 0xFF;
            byArray2 = new byte[byArray.length - 1];
            System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
        }
        this.setData(n2, byArray2);
    }

    public void setData(int n2, byte[] byArray) {
        this.type = n2;
        int n3 = byArray.length;
        byte[] byArray2 = byArray;
        if (byArray == null) {
            byArray2 = new byte[]{};
        }
        this.dataLength = n3 + 1;
        this.t = new byte[this.dataLength];
        this.t[0] = (byte)n2;
        System.arraycopy(byArray2, 0, this.t, 1, n3);
    }

    public void setPacketIdentifier(int n2) {
        this.P = n2;
    }

    private byte[] f() {
        int n2 = this.getLength();
        this.v = new byte[n2];
        this.v[0] = (byte)this.code;
        this.v[1] = (byte)this.P;
        this.v[2] = (byte)(n2 >>> 8);
        this.v[3] = (byte)n2;
        if (this.dataLength > 0) {
            System.arraycopy(this.t, 0, this.v, 4, this.dataLength);
        }
        return this.v;
    }

    private void f(byte[] byArray) throws EAPException {
        this.type = 0;
        if (byArray == null) {
            throw new EAPException("No EAP attribute data available.");
        }
        if (byArray.length < 4) {
            throw new EAPException("EAP packet too small - " + byArray.length + " < minimum packet size (4)", this);
        }
        if (byArray.length == 0) {
            this.k = true;
            this.t = new byte[0];
            this.dataLength = 0;
            return;
        }
        this.k = false;
        if (byArray.length == 4) {
            this.code = byArray[0] & 0xFF;
            this.setPacketIdentifier(byArray[1] & 0xFF);
            this.t = new byte[0];
            this.dataLength = 0;
            return;
        }
        this.code = byArray[0] & 0xFF;
        if (this.code > 4) {
            throw new EAPException("EAP code is out of range 1 to 4, value is " + this.code, this);
        }
        int n2 = (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
        this.setPacketIdentifier(byArray[1] & 0xFF);
        if (n2 != byArray.length) {
            throw new EAPException("EAP Packet's physical size (" + byArray.length + ") doesn't match packet's stated length (" + n2 + ")", this);
        }
        if (n2 > 4) {
            this.type = byArray[4] & 0xFF;
            if (n2 > 5) {
                this.dataLength = byArray.length - 4;
                this.t = new byte[this.dataLength];
                System.arraycopy(byArray, 4, this.t, 0, this.dataLength);
                return;
            }
        }
        this.dataLength = 0;
        this.t = new byte[0];
    }

    public void setRequest() {
        this.code = 1;
    }

    public void setResponse() {
        this.code = 2;
    }

    public void setFailure() {
        this.code = 4;
    }

    public void setSuccess() {
        this.code = 3;
    }

    public AttributeList toAttributeList() {
        byte[] byArray;
        int n2;
        AttributeList attributeList = new AttributeList();
        byte[] byArray2 = this.f();
        int n3 = 0;
        for (n2 = byArray2.length; n2 > 253; n2 -= 253) {
            byArray = new byte[253];
            System.arraycopy(byArray2, n3, byArray, 0, 253);
            attributeList.add(79, byArray);
            n3 += 253;
        }
        if (n2 > 0) {
            byArray = new byte[n2];
            System.arraycopy(byArray2, n3, byArray, 0, n2);
            attributeList.add(79, byArray);
        }
        return attributeList;
    }

    public AttributeList createIdentityRequest(int n2, byte[] byArray) {
        this.setCode(1);
        this.setPacketIdentifier(n2);
        this.setData(1, byArray);
        return this.toAttributeList();
    }

    public AttributeList createIdentityResponse(int n2, byte[] byArray) {
        this.setCode(2);
        this.setPacketIdentifier(n2);
        this.setData(1, byArray);
        return this.toAttributeList();
    }

    public AttributeList createNotificationRequest(int n2, byte[] byArray) {
        this.setCode(1);
        this.setPacketIdentifier(n2);
        this.setData(2, byArray);
        return this.toAttributeList();
    }

    public AttributeList createNotificationResponse(int n2, byte[] byArray) {
        this.setCode(2);
        this.setPacketIdentifier(n2);
        this.setData(2, byArray);
        return this.toAttributeList();
    }

    public final AttributeList createFailure(int n2) {
        this.setCode(4);
        this.setPacketIdentifier(n2);
        this.j();
        return this.toAttributeList();
    }

    public final AttributeList createSuccess(int n2) {
        this.setCode(3);
        this.setPacketIdentifier(n2);
        this.j();
        return this.toAttributeList();
    }

    public final AttributeList createNAKResponse(int n2, byte[] byArray) {
        this.setCode(2);
        this.setPacketIdentifier(n2);
        this.setData(3, byArray);
        return this.toAttributeList();
    }

    public final AttributeList createNAKResponse(int n2, int n3) {
        byte[] byArray = new byte[1];
        byte[] byArray2 = byArray;
        byArray[0] = (byte)n3;
        return this.createNAKResponse(n2, byArray2);
    }

    public final AttributeList createNAKRequest(int n2, byte[] byArray) {
        this.setCode(1);
        this.setPacketIdentifier(n2);
        this.setData(3, byArray);
        return this.toAttributeList();
    }

    public boolean isNAK() {
        return this.type == 3 && this.code == 2;
    }

    public boolean isExpandedNAK() {
        if (this.code != 2) {
            return false;
        }
        if (!this.isExpanded()) {
            return false;
        }
        byte[] byArray = this.getPayloadData();
        if (byArray.length < 16) {
            return false;
        }
        if (byArray[1] != 0 || byArray[2] != 0 || byArray[3] != 0) {
            return false;
        }
        if (byArray[4] != 0 || byArray[5] != 0 || byArray[6] != 0 || byArray[7] != 3) {
            return false;
        }
        return byArray[8] == -2;
    }

    public boolean isExpanded() {
        if (this.type != 254) {
            return false;
        }
        return this.t.length >= 7;
    }

    public int getVendorId() {
        if (this.isExpanded()) {
            this.Q = b.b(this.getData(), 1);
        }
        return this.Q;
    }

    public byte[] getVendorData() {
        byte[] byArray;
        if (!this.isExpanded()) {
            return new byte[0];
        }
        byte[] byArray2 = this.getPayloadData();
        if (byArray2.length > 4) {
            byArray = new byte[byArray2.length - 4];
            System.arraycopy(byArray2, 4, byArray, 0, byArray.length);
        } else {
            byArray = new byte[]{};
        }
        return byArray;
    }

    public boolean isRequest() {
        return this.code == 1;
    }

    public boolean isResponse() {
        return this.code == 2;
    }

    public boolean isSuccess() {
        return this.code == 3;
    }

    public boolean isFailure() {
        return this.code == 4;
    }

    public boolean isIdentity() {
        return this.type == 1;
    }

    public boolean isNotification() {
        return this.type == 2;
    }

    public String toString() {
        StringBuilder stringBuilder;
        int n2;
        block51: {
            n2 = 0;
            stringBuilder = new StringBuilder("EAP Packet: ");
            if (this.R > 1) {
                stringBuilder.append("(In ").append(this.R).append(" EAP_Message attributes) ");
            }
            if (this.t == null) {
                this.t = new byte[0];
            }
            switch (this.getCode()) {
                case 1: {
                    stringBuilder.append("Request (").append(this.code).append(')');
                    break;
                }
                case 2: {
                    stringBuilder.append("Response (").append(this.code).append(')');
                    break;
                }
                case 3: {
                    stringBuilder.append("Success (").append(this.code).append(')');
                    break;
                }
                case 4: {
                    stringBuilder.append("Failure (").append(this.code).append(')');
                    break;
                }
                default: {
                    stringBuilder.append("Unknown Code (").append(this.code).append(')');
                }
            }
            stringBuilder.append(", ID ").append(this.getPacketIdentifier());
            stringBuilder.append(", Length: ").append(this.getLength());
            if (this.type != 0) {
                stringBuilder.append(", ").append(this.getTypeName()).append('[').append(this.type).append(']');
            }
            if (this.type == 13 | this.type == 21 || this.type == 25) {
                byte[] byArray = this.getData();
                int n3 = byArray.length;
                if (n3 <= 0) {
                    stringBuilder.append(" Error: Illegally formatted packet, missing flags or length field");
                    return stringBuilder.toString();
                }
                int n4 = byArray[0] & 0xE0;
                stringBuilder.append(", Flag: 0x").append(Integer.toHexString(n4)).append('(');
                switch (n4) {
                    case 128: {
                        stringBuilder.append('L');
                        break;
                    }
                    case 64: {
                        stringBuilder.append('M');
                        break;
                    }
                    case 32: {
                        stringBuilder.append('S');
                        break;
                    }
                    case 0: {
                        stringBuilder.append("None");
                        break;
                    }
                    case 192: {
                        stringBuilder.append("LM");
                        break;
                    }
                    default: {
                        stringBuilder.append("Unknown");
                    }
                }
                stringBuilder.append(')');
                if (this.type == 25) {
                    n2 = byArray[0] & 0x1F;
                    stringBuilder.append("-Version ").append(n2);
                }
                n2 = 1;
                if ((n4 & 0x80) == 128) {
                    if (n3 < 5) {
                        stringBuilder.append(" Error: Illegally formatted packet, missing flags or length field");
                        return stringBuilder.toString();
                    }
                    if (n3 >= 5) {
                        stringBuilder.append(", Data length ").append(b.a(byArray, 1));
                        n2 += 4;
                    }
                }
                if (n3 > n2) {
                    byte[] byArray2 = new byte[n3 - n2];
                    System.arraycopy(byArray, n2, byArray2, 0, byArray2.length);
                    stringBuilder.append(" Payload Length: ").append(byArray2.length);
                    stringBuilder.append(", Data ").append(Util.toHexString(byArray2));
                } else {
                    stringBuilder.append(" Payload Length: 0");
                }
                return stringBuilder.toString();
            }
            if (this.type == 26) {
                byte[] byArray = this.getData();
                int n5 = byArray[0] & 0xFF;
                stringBuilder.append(", Opcode: ");
                switch (n5) {
                    case 1: {
                        stringBuilder.append("Challenge");
                        break;
                    }
                    case 2: {
                        stringBuilder.append("Response");
                        break;
                    }
                    case 3: {
                        stringBuilder.append("Success");
                        break;
                    }
                    case 4: {
                        stringBuilder.append("Failure");
                        break;
                    }
                    case 7: {
                        stringBuilder.append("Change-Password");
                        break;
                    }
                    default: {
                        stringBuilder.append("Unknown");
                    }
                }
                stringBuilder.append("(").append(n5).append(")");
                if (byArray.length >= 8) {
                    stringBuilder.append(", MSChapId: ").append(byArray[1] & 0xFF);
                    int n6 = byArray[2] << 8 | byArray[3] & 0xFF;
                    stringBuilder.append(", MSLength: ").append(n6);
                    stringBuilder.append(", Data length = " + byArray.length);
                    if (n6 != this.getLength() - 5) {
                        stringBuilder.append(", MSLength / Data length don't match ");
                    } else {
                        stringBuilder.append(", Data");
                    }
                    stringBuilder.append(": ").append(Util.toHexString(byArray, 5, n6));
                }
                n2 = 1;
            } else if (this.isExpanded()) {
                try {
                    if (this.isExpandedNAK()) {
                        for (EAPType eAPType : this.a()) {
                            stringBuilder.append(eAPType).append(",");
                        }
                        stringBuilder.setLength(stringBuilder.length() - 1);
                        n2 = 1;
                        break block51;
                    }
                    byte[] byArray = this.getPayloadData();
                    stringBuilder.append(", Vendor X").append(this.getVendorId());
                    int n7 = b.a(byArray, 4);
                    stringBuilder.append(", Type ").append(n7);
                    byte[] byArray3 = this.getVendorData();
                    stringBuilder.append(", Data length = ").append(byArray3.length);
                    stringBuilder.append(", Data: ");
                    stringBuilder.append(" ").append(Util.toHexString(byArray3));
                    n2 = 1;
                }
                catch (EAPException eAPException) {
                    stringBuilder.append(", Malformed data: " + eAPException.getMessage() + ":Data " + Util.toHexString(this.t));
                }
            } else if (this.type == 3) {
                byte[] byArray = this.getData();
                if (byArray.length > 0) {
                    stringBuilder.append(" Requesting:");
                    for (int i2 = 0; i2 < byArray.length; ++i2) {
                        int n8 = byArray[i2] & 0xFF;
                        stringBuilder.append(' ').append(EAPPacket.getTypeName(n8)).append("[").append(n8).append("]");
                    }
                }
            } else if (this.type == 1) {
                byte[] byArray = this.getData();
                stringBuilder.append(", \"").append(Util.toUTF8(byArray)).append("\"");
            }
        }
        if (this.code == 3 || this.code == 4 && this.t.length == 0) {
            return stringBuilder.toString();
        }
        if (n2 == 0) {
            if (this.t != null) {
                stringBuilder.append(", ").append(new Attribute(0).displayData(this.t));
                stringBuilder.append(" - ").append(this.t.length).append(" bytes");
            } else {
                stringBuilder.append(", No Data");
            }
        }
        return stringBuilder.toString();
    }

    private byte[] a(AttributeList attributeList) throws EAPException {
        int n2;
        Attribute[] attributeArray = attributeList.toArray(79);
        if (attributeArray.length == 0) {
            throw new EAPException("Packet does not contain any EAP-Message attributes.", this);
        }
        this.R = attributeArray.length;
        if (attributeArray.length == 1) {
            return attributeArray[0].getData();
        }
        int n3 = 0;
        for (n2 = 0; n2 < attributeArray.length; ++n2) {
            n3 += attributeArray[n2].getDataLength();
        }
        byte[] byArray = new byte[n3];
        n3 = 0;
        for (n2 = 0; n2 < attributeArray.length; ++n2) {
            System.arraycopy(attributeArray[n2].getData(), 0, byArray, n3, attributeArray[n2].getDataLength());
            n3 += attributeArray[n2].getDataLength();
        }
        return byArray;
    }

    private List<EAPType> a() throws EAPException {
        if (!this.isExpandedNAK()) {
            return null;
        }
        if (this.code != 2) {
            throw new EAPException("Packet is not a response.");
        }
        Object object = this.getPayloadData();
        int n2 = ((byte[])object).length;
        if (n2 < 16) {
            throw new EAPException("Not an Expanded Nak packet - too short.");
        }
        object = new b((byte[])object, 0);
        if (n2 % 8 != 0) {
            throw new EAPException("Not an Expanded Nak packet - wrong size.");
        }
        ArrayList<EAPType> arrayList = new ArrayList<EAPType>(n2 /= 8);
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = object.readUnsignedByte();
            if (n3 != 254) {
                throw new EAPException("Not an Expanded Nak packet - wrong type found.");
            }
            int n4 = object.a();
            int n5 = object.readInt();
            if (n4 > 0 && n4 < 4) {
                throw new EAPException("Not an Expanded Nak packet - illegal vendor id '" + n4 + "'.");
            }
            if (n3 != 254) {
                throw new EAPException("Not an Expanded Nak packet - wrong sub-type found '" + n3 + "'.");
            }
            if (i2 == 0) {
                if (n4 != 0) {
                    throw new EAPException("Not an Expanded Nak packet - Vendor is not IEFT (0) found '" + n4 + "'.");
                }
                if (n5 == 3) continue;
                throw new EAPException("Not an Expanded Nak packet - Type is not NAK (3) found '" + n5 + "'.");
            }
            EAPType eAPType = new EAPType(this.Q, n5);
            arrayList.add(eAPType);
        }
        return arrayList;
    }

    public void clean() {
        this.code = 0;
        this.P = 0;
        this.type = 0;
        Util.clean(this.t);
        this.dataLength = 0;
        Util.clean(this.u);
        this.k = false;
        this.Q = 0;
        Util.clean(this.v);
        this.R = 0;
    }
}

