/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.client.shadow;

import com.amazonaws.services.iot.client.AWSIotMessage;
import com.amazonaws.services.iot.client.AWSIotQos;
import com.amazonaws.services.iot.client.AWSIotTopic;
import com.amazonaws.services.iot.client.shadow.AbstractAwsIotDevice;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.logging.Logger;

public class AwsIotDeviceDeltaListener
extends AWSIotTopic {
    private static final Logger LOGGER = Logger.getLogger(AwsIotDeviceDeltaListener.class.getName());
    private final AbstractAwsIotDevice device;

    public AwsIotDeviceDeltaListener(String topic, AWSIotQos qos, AbstractAwsIotDevice device) {
        super(topic, qos);
        this.device = device;
    }

    @Override
    public void onMessage(AWSIotMessage message) {
        JsonNode node;
        JsonNode rootNode;
        String payload = message.getStringPayload();
        if (payload == null) {
            LOGGER.warning("Received empty delta for device " + this.device.getThingName());
            return;
        }
        try {
            rootNode = this.device.getJsonObjectMapper().readTree(payload);
            if (!rootNode.isObject()) {
                throw new IOException();
            }
        }
        catch (IOException e) {
            LOGGER.warning("Received invalid delta for device " + this.device.getThingName());
            return;
        }
        if (this.device.enableVersioning) {
            long localVersion;
            node = rootNode.get("version");
            if (node == null) {
                LOGGER.warning("Missing version field in delta for device " + this.device.getThingName());
                return;
            }
            long receivedVersion = node.longValue();
            if (receivedVersion < (localVersion = this.device.getLocalVersion().get())) {
                LOGGER.warning("An old version of delta received for " + this.device.getThingName() + ", local " + localVersion + ", received " + receivedVersion);
                return;
            }
            this.device.getLocalVersion().set(receivedVersion);
            LOGGER.info("Local version number updated to " + receivedVersion);
        }
        if ((node = rootNode.get("state")) == null) {
            LOGGER.warning("Missing state field in delta for device " + this.device.getThingName());
            return;
        }
        this.device.onShadowUpdate(node.toString());
    }

    @Override
    public void onSuccess() {
    }

    @Override
    public void onFailure() {
        LOGGER.warning("Failed to subscribe to device topic " + this.topic);
    }

    @Override
    public void onTimeout() {
        LOGGER.warning("Timeout when subscribing to device topic " + this.topic);
    }
}

