/*
 * Decompiled with CFR 0.152.
 */
package org.vinniks.parsla.parser;

import java.util.ArrayDeque;
import java.util.Deque;
import org.vinniks.parsla.parser.AbstractCompiledTokenItem;
import org.vinniks.parsla.parser.AbstractParseTreeNode;
import org.vinniks.parsla.parser.CompiledRuleItem;
import org.vinniks.parsla.parser.ParserOutputListener;
import org.vinniks.parsla.parser.RuleParseTreeNode;
import org.vinniks.parsla.parser.TokenParseTreeNode;

class ParserOutput<P> {
    private final ParserOutputListener<P> listener;
    private final Deque<Integer> levelStack;

    ParserOutput(ParserOutputListener<P> listener) {
        this.listener = listener;
        this.levelStack = new ArrayDeque<Integer>();
        this.levelStack.push(0);
    }

    void next(AbstractParseTreeNode<?, P> parseTreeNode) {
        RuleParseTreeNode genericRuleNode;
        if (parseTreeNode.getParent() != null) {
            this.next(parseTreeNode.getParent());
        }
        this.ensureSiblingLevel(parseTreeNode.getLevel());
        if (parseTreeNode instanceof TokenParseTreeNode) {
            boolean outputValue;
            TokenParseTreeNode genericTokenNode = (TokenParseTreeNode)parseTreeNode;
            TokenParseTreeNode tokenNode = genericTokenNode;
            boolean bl = outputValue = ((AbstractCompiledTokenItem)tokenNode.getItem()).outputValue() && tokenNode.getToken().getValue() != null;
            if (((AbstractCompiledTokenItem)tokenNode.getItem()).outputType()) {
                if (outputValue) {
                    this.listener.enter(tokenNode.getPosition(), tokenNode.getToken().getType());
                    this.listener.tap(tokenNode.getPosition(), tokenNode.getToken().getValue());
                    this.listener.exit();
                } else {
                    this.listener.tap(tokenNode.getPosition(), tokenNode.getToken().getType());
                }
            } else if (outputValue) {
                this.listener.tap(tokenNode.getPosition(), tokenNode.getToken().getValue());
            }
        } else if (parseTreeNode instanceof RuleParseTreeNode && ((genericRuleNode = (RuleParseTreeNode)parseTreeNode).isOutputOption() || ((CompiledRuleItem)genericRuleNode.getItem()).isOutput())) {
            RuleParseTreeNode ruleNode = genericRuleNode;
            this.listener.enter(ruleNode.getPosition(), ((CompiledRuleItem)ruleNode.getItem()).getRuleName());
            this.levelStack.push(parseTreeNode.getLevel());
        }
    }

    void end() {
        this.ensureSiblingLevel(2);
    }

    private void ensureSiblingLevel(int level) {
        Integer topLevel = this.levelStack.peek();
        while (level <= topLevel) {
            this.levelStack.pop();
            this.listener.exit();
            topLevel = this.levelStack.peek();
        }
    }
}

