/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.trafficflow;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.ubnt.ace.o0oO;
import com.ubnt.model.A;
import com.ubnt.model.api.trafficflow.ImmutableTrafficFlowDto;
import com.ubnt.model.api.trafficflow.TrafficFlowDataDto;
import com.ubnt.model.api.trafficflow.TrafficFlowEndpointDto;
import com.ubnt.model.api.trafficflow.TrafficFlowFileDto;
import com.ubnt.model.api.trafficflow.TrafficFlowInOutDto;
import com.ubnt.model.api.trafficflow.TrafficFlowIpsDto;
import com.ubnt.model.api.trafficflow.TrafficFlowNextAiDto;
import com.ubnt.model.api.trafficflow.TrafficFlowPolicyDto;
import com.ubnt.model.api.trafficflow.TrafficFlowZeroDayDto;
import com.ubnt.model.float;
import com.ubnt.return.C;
import com.ubnt.service.trafficflow.B;
import com.ubnt.service.trafficflow.D;
import com.ubnt.service.trafficflow.OOoo;
import com.ubnt.service.trafficflow.TrafficFlowDocument;
import com.ubnt.service.trafficflow.TrafficFlowInOutDocumentPart;
import com.ubnt.service.trafficflow.TrafficFlowIpsDocumentPart;
import com.ubnt.service.trafficflow.TrafficFlowPolicyDocumentPart;
import com.ubnt.service.trafficflow.a;
import com.ubnt.service.trafficflow.oOo0;
import com.ubnt.service.trafficflow.search.F;
import com.ubnt.super;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.bson.types.ObjectId;
import org.immutables.value.Value;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@Value.Immutable
@C
public interface TrafficFlowDto {
    public static final List<a> DNS_FILTER_TYPES = List.of(a.voidinterface, a.\u00d60o000, a.OOo000, a.intthissuper);

    @JsonProperty(value="id")
    public String id();

    @JsonProperty(value="policies")
    public List<TrafficFlowPolicyDto> policies();

    @JsonProperty(value="action")
    public oOo0 action();

    @JsonProperty(value="category")
    public Optional<B> category();

    @JsonProperty(value="time")
    public long time();

    @JsonProperty(value="direction")
    public D direction();

    @JsonProperty(value="protocol")
    public Optional<float> protocol();

    @JsonProperty(value="service")
    public Optional<A> service();

    @JsonProperty(value="source")
    public TrafficFlowEndpointDto source();

    @JsonProperty(value="destination")
    public TrafficFlowEndpointDto destination();

    @JsonProperty(value="risk")
    public OOoo risk();

    @JsonProperty(value="count")
    public int count();

    @JsonProperty(value="in")
    public Optional<TrafficFlowInOutDto> in();

    @JsonProperty(value="out")
    public Optional<TrafficFlowInOutDto> out();

    @JsonProperty(value="traffic_data")
    public Optional<TrafficFlowDataDto> data();

    @JsonProperty(value="next_ai")
    public List<TrafficFlowNextAiDto> nextAi();

    @JsonProperty(value="zero_day")
    public Optional<TrafficFlowZeroDayDto> zeroDay();

    @JsonProperty(value="ips")
    public Optional<TrafficFlowIpsDto> ips();

    @JsonProperty(value="file")
    public Optional<TrafficFlowFileDto> file();

    @JsonProperty(value="flow_start_time")
    public Optional<Long> flowStartTime();

    @JsonProperty(value="flow_end_time")
    public Optional<Long> flowEndTime();

    @JsonProperty(value="duration_milliseconds")
    public Optional<Long> duration();

    public static TrafficFlowDto fromDocument(TrafficFlowDocument trafficFlowDocument, F f2) {
        List<TrafficFlowPolicyDocumentPart> list = trafficFlowDocument.getPolicies() == null ? List.of() : trafficFlowDocument.getPolicies();
        Optional<Long> optional = Optional.ofNullable(trafficFlowDocument.getFlowStartTime());
        Optional<Long> optional2 = Optional.ofNullable(trafficFlowDocument.getFlowEndTime());
        Optional<Long> optional3 = o0oO.oO0000(optional, optional2).map(pair -> (Long)pair.getRight() - (Long)pair.getLeft());
        OOoo oOoo2 = trafficFlowDocument.getRisk();
        Optional<float> optional4 = Optional.ofNullable(trafficFlowDocument.getProtocol()).filter(float_ -> float_ != float.\u00f4\u00d20000);
        boolean bl = TrafficFlowDto.hasDnsFilterPolicy(list);
        return ImmutableTrafficFlowDto.builder().id(trafficFlowDocument.getId()).policies(com.ubnt.service.trafficflow.C.\u00d300000(list, f2)).action(trafficFlowDocument.getAction()).category(Optional.ofNullable(trafficFlowDocument.getCategory())).time(trafficFlowDocument.getTime()).direction(trafficFlowDocument.getDirection()).protocol(optional4).service(com.ubnt.service.trafficflow.C.\u00d500000(trafficFlowDocument)).source(TrafficFlowEndpointDto.fromDocument(trafficFlowDocument.getSource(), f2)).destination(TrafficFlowEndpointDto.fromDocument(trafficFlowDocument.getDestination(), f2, bl)).risk(oOoo2).count(trafficFlowDocument.getCount()).in(TrafficFlowDto.\u00d400000(trafficFlowDocument.getIn(), f2)).out(TrafficFlowDto.\u00d400000(trafficFlowDocument.getOut(), f2)).data(Optional.ofNullable(trafficFlowDocument.getData()).map(TrafficFlowDataDto::fromDocument)).nextAi(TrafficFlowDto.o00000(trafficFlowDocument)).zeroDay(TrafficFlowDto.void(trafficFlowDocument)).ips(TrafficFlowDto.\u00f400000(trafficFlowDocument, list, oOoo2, optional4.orElse(null))).file(TrafficFlowDto.\u00d200000(trafficFlowDocument)).flowStartTime(optional).flowEndTime(optional2).duration(optional3).build();
    }

    @VisibleForTesting
    public static boolean hasDnsFilterPolicy(List<TrafficFlowPolicyDocumentPart> list) {
        return list.stream().anyMatch(trafficFlowPolicyDocumentPart -> DNS_FILTER_TYPES.contains((Object)trafficFlowPolicyDocumentPart.getType()));
    }

    public static ImmutableTrafficFlowDto.Builder builder() {
        return ImmutableTrafficFlowDto.builder();
    }

    private static Optional<TrafficFlowInOutDto> \u00d400000(TrafficFlowInOutDocumentPart trafficFlowInOutDocumentPart, F f2) {
        return Optional.ofNullable(trafficFlowInOutDocumentPart).map(TrafficFlowInOutDocumentPart::getNetworkId).map(ObjectId::toHexString).map(string -> TrafficFlowInOutDto.of(string, f2.OO0000((String)string).orElse(null)));
    }

    private static List<TrafficFlowNextAiDto> o00000(TrafficFlowDocument trafficFlowDocument) {
        return Optional.ofNullable(trafficFlowDocument.getNextAi()).stream().flatMap(Collection::stream).map(TrafficFlowNextAiDto::fromDocument).toList();
    }

    private static Optional<TrafficFlowZeroDayDto> void(TrafficFlowDocument trafficFlowDocument) {
        return Optional.ofNullable(trafficFlowDocument.getZeroDay()).map(TrafficFlowZeroDayDto::fromDocument);
    }

    private static Optional<TrafficFlowIpsDto> \u00f400000(TrafficFlowDocument trafficFlowDocument, List<TrafficFlowPolicyDocumentPart> list, OOoo oOoo2, @Nullable float float_) {
        return Optional.ofNullable(trafficFlowDocument.getIps()).filter(Predicate.not(TrafficFlowIpsDocumentPart::containsOnlyAlarmId)).map(trafficFlowIpsDocumentPart -> TrafficFlowIpsDto.fromDocument(trafficFlowIpsDocumentPart, list, oOoo2, float_, trafficFlowDocument.getSource(), trafficFlowDocument.getDestination()));
    }

    private static Optional<TrafficFlowFileDto> \u00d200000(TrafficFlowDocument trafficFlowDocument) {
        return super.\u00f6o0000(trafficFlowDocument.getFiles()).map(TrafficFlowFileDto::fromDocument);
    }
}

