/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.data.mdnsproxy;

import com.ubnt.data.X;
import com.ubnt.data.mdnsproxy.ApScopeMode;
import com.ubnt.data.mdnsproxy.MdnsCustomService;
import com.ubnt.data.mdnsproxy.MdnsPredefinedService;
import com.ubnt.data.mdnsproxy.ServicesMode;
import java.beans.ConstructorProperties;
import java.util.List;
import lombok.Generated;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class MdnsProxyCustom {
    protected final List<String> networkConfIds;
    protected final ApScopeMode apScopeMode;
    protected final List<String> apMacs;
    protected final List<String> apGroupIds;
    protected final boolean isolationEnabled;
    protected final ServicesMode servicesMode;
    protected final List<MdnsPredefinedService> mdnsPredefinedServices;
    protected final List<MdnsCustomService> mdnsCustomServices;

    public static MdnsProxyCustom of(X x2) {
        return MdnsProxyCustom.builder().networkConfIds(x2.getStringList("networkconf_ids")).apScopeMode(ApScopeMode.fromString(x2.getString("ap_scope_mode")).orElse(ApScopeMode.ALL)).apMacs(x2.getStringList("ap_macs")).apGroupIds(x2.getStringList("ap_group_ids")).isolationEnabled(x2.is("isolation_enabled", false)).servicesMode(ServicesMode.fromStringValue(x2.getString("services_mode")).orElse(ServicesMode.ALL)).mdnsPredefinedServices(x2.getList("predefined_services").stream().map(MdnsPredefinedService::of).toList()).mdnsCustomServices(x2.getList("custom_services").stream().map(MdnsCustomService::of).toList()).build();
    }

    public X toLegacy() {
        return new X().append("networkconf_ids", this.networkConfIds).append("ap_scope_mode", (Object)this.apScopeMode).append("ap_macs", this.apMacs).append("ap_group_ids", this.apGroupIds).append("isolation_enabled", this.isolationEnabled).append("services_mode", (Object)this.servicesMode).append("predefined_services", this.mdnsPredefinedServices.stream().map(MdnsPredefinedService::toLegacy).toList()).append("custom_services", this.mdnsCustomServices.stream().map(MdnsCustomService::toLegacy).toList());
    }

    @ConstructorProperties(value={"networkConfIds", "apScopeMode", "apMacs", "apGroupIds", "isolationEnabled", "servicesMode", "mdnsPredefinedServices", "mdnsCustomServices"})
    @Generated
    MdnsProxyCustom(List<String> list, ApScopeMode apScopeMode, List<String> list2, List<String> list3, boolean bl, ServicesMode servicesMode, List<MdnsPredefinedService> list4, List<MdnsCustomService> list5) {
        this.networkConfIds = list;
        this.apScopeMode = apScopeMode;
        this.apMacs = list2;
        this.apGroupIds = list3;
        this.isolationEnabled = bl;
        this.servicesMode = servicesMode;
        this.mdnsPredefinedServices = list4;
        this.mdnsCustomServices = list5;
    }

    @Generated
    public static MdnsProxyCustomBuilder builder() {
        return new MdnsProxyCustomBuilder();
    }

    @Generated
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MdnsProxyCustom)) {
            return false;
        }
        MdnsProxyCustom mdnsProxyCustom = (MdnsProxyCustom)object;
        if (!mdnsProxyCustom.canEqual(this)) {
            return false;
        }
        if (this.isolationEnabled() != mdnsProxyCustom.isolationEnabled()) {
            return false;
        }
        List<String> list = this.networkConfIds();
        List<String> list2 = mdnsProxyCustom.networkConfIds();
        if (list == null ? list2 != null : !((Object)list).equals(list2)) {
            return false;
        }
        ApScopeMode apScopeMode = this.apScopeMode();
        ApScopeMode apScopeMode2 = mdnsProxyCustom.apScopeMode();
        if (apScopeMode == null ? apScopeMode2 != null : !((Object)((Object)apScopeMode)).equals((Object)apScopeMode2)) {
            return false;
        }
        List<String> list3 = this.apMacs();
        List<String> list4 = mdnsProxyCustom.apMacs();
        if (list3 == null ? list4 != null : !((Object)list3).equals(list4)) {
            return false;
        }
        List<String> list5 = this.apGroupIds();
        List<String> list6 = mdnsProxyCustom.apGroupIds();
        if (list5 == null ? list6 != null : !((Object)list5).equals(list6)) {
            return false;
        }
        ServicesMode servicesMode = this.servicesMode();
        ServicesMode servicesMode2 = mdnsProxyCustom.servicesMode();
        if (servicesMode == null ? servicesMode2 != null : !((Object)((Object)servicesMode)).equals((Object)servicesMode2)) {
            return false;
        }
        List<MdnsPredefinedService> list7 = this.mdnsPredefinedServices();
        List<MdnsPredefinedService> list8 = mdnsProxyCustom.mdnsPredefinedServices();
        if (list7 == null ? list8 != null : !((Object)list7).equals(list8)) {
            return false;
        }
        List<MdnsCustomService> list9 = this.mdnsCustomServices();
        List<MdnsCustomService> list10 = mdnsProxyCustom.mdnsCustomServices();
        return !(list9 == null ? list10 != null : !((Object)list9).equals(list10));
    }

    @Generated
    protected boolean canEqual(Object object) {
        return object instanceof MdnsProxyCustom;
    }

    @Generated
    public int hashCode() {
        int n2 = 1;
        n2 = n2 * 59 + (this.isolationEnabled() ? 79 : 97);
        List<String> list = this.networkConfIds();
        n2 = n2 * 59 + (list == null ? 43 : ((Object)list).hashCode());
        ApScopeMode apScopeMode = this.apScopeMode();
        n2 = n2 * 59 + (apScopeMode == null ? 43 : ((Object)((Object)apScopeMode)).hashCode());
        List<String> list2 = this.apMacs();
        n2 = n2 * 59 + (list2 == null ? 43 : ((Object)list2).hashCode());
        List<String> list3 = this.apGroupIds();
        n2 = n2 * 59 + (list3 == null ? 43 : ((Object)list3).hashCode());
        ServicesMode servicesMode = this.servicesMode();
        n2 = n2 * 59 + (servicesMode == null ? 43 : ((Object)((Object)servicesMode)).hashCode());
        List<MdnsPredefinedService> list4 = this.mdnsPredefinedServices();
        n2 = n2 * 59 + (list4 == null ? 43 : ((Object)list4).hashCode());
        List<MdnsCustomService> list5 = this.mdnsCustomServices();
        n2 = n2 * 59 + (list5 == null ? 43 : ((Object)list5).hashCode());
        return n2;
    }

    @Generated
    public List<String> networkConfIds() {
        return this.networkConfIds;
    }

    @Generated
    public ApScopeMode apScopeMode() {
        return this.apScopeMode;
    }

    @Generated
    public List<String> apMacs() {
        return this.apMacs;
    }

    @Generated
    public List<String> apGroupIds() {
        return this.apGroupIds;
    }

    @Generated
    public boolean isolationEnabled() {
        return this.isolationEnabled;
    }

    @Generated
    public ServicesMode servicesMode() {
        return this.servicesMode;
    }

    @Generated
    public List<MdnsPredefinedService> mdnsPredefinedServices() {
        return this.mdnsPredefinedServices;
    }

    @Generated
    public List<MdnsCustomService> mdnsCustomServices() {
        return this.mdnsCustomServices;
    }

    public static class MdnsProxyCustomBuilder {
        @Generated
        private List<String> networkConfIds = List.of();
        @Generated
        private ApScopeMode apScopeMode = ApScopeMode.ALL;
        @Generated
        private List<String> apMacs = List.of();
        @Generated
        private List<String> apGroupIds = List.of();
        @Generated
        private boolean isolationEnabled;
        @Generated
        private ServicesMode servicesMode = ServicesMode.ALL;
        @Generated
        private List<MdnsPredefinedService> mdnsPredefinedServices = List.of();
        @Generated
        private List<MdnsCustomService> mdnsCustomServices = List.of();

        @Generated
        public MdnsProxyCustomBuilder networkConfIds(List<String> list) {
            this.networkConfIds = list;
            return this;
        }

        @Generated
        public MdnsProxyCustomBuilder apScopeMode(ApScopeMode apScopeMode) {
            this.apScopeMode = apScopeMode;
            return this;
        }

        @Generated
        public MdnsProxyCustomBuilder apMacs(List<String> list) {
            this.apMacs = list;
            return this;
        }

        @Generated
        public MdnsProxyCustomBuilder apGroupIds(List<String> list) {
            this.apGroupIds = list;
            return this;
        }

        @Generated
        public MdnsProxyCustomBuilder isolationEnabled(boolean bl) {
            this.isolationEnabled = bl;
            return this;
        }

        @Generated
        public MdnsProxyCustomBuilder servicesMode(ServicesMode servicesMode) {
            this.servicesMode = servicesMode;
            return this;
        }

        @Generated
        public MdnsProxyCustomBuilder mdnsPredefinedServices(List<MdnsPredefinedService> list) {
            this.mdnsPredefinedServices = list;
            return this;
        }

        @Generated
        public MdnsProxyCustomBuilder mdnsCustomServices(List<MdnsCustomService> list) {
            this.mdnsCustomServices = list;
            return this;
        }

        @Generated
        public MdnsProxyCustom build() {
            return new MdnsProxyCustom(this.networkConfIds, this.apScopeMode, this.apMacs, this.apGroupIds, this.isolationEnabled, this.servicesMode, this.mdnsPredefinedServices, this.mdnsCustomServices);
        }

        @Generated
        public String toString() {
            return "MdnsProxyCustom.MdnsProxyCustomBuilder(networkConfIds=" + String.valueOf(this.networkConfIds) + ", apScopeMode=" + String.valueOf((Object)this.apScopeMode) + ", apMacs=" + String.valueOf(this.apMacs) + ", apGroupIds=" + String.valueOf(this.apGroupIds) + ", isolationEnabled=" + this.isolationEnabled + ", servicesMode=" + String.valueOf((Object)this.servicesMode) + ", mdnsPredefinedServices=" + String.valueOf(this.mdnsPredefinedServices) + ", mdnsCustomServices=" + String.valueOf(this.mdnsCustomServices) + ")";
        }
    }
}

