// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/identity/accesscontextmanager/v1/access_context_manager.proto

package accesscontextmanagerpb

import (
	iampb "cloud.google.com/go/iam/apiv1/iampb"
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The format used in an `AccessLevel`.
type LevelFormat int32

const (
	// The format was not specified.
	LevelFormat_LEVEL_FORMAT_UNSPECIFIED LevelFormat = 0
	// Uses the format the resource was defined in. BasicLevels are returned as
	// BasicLevels, CustomLevels are returned as CustomLevels.
	LevelFormat_AS_DEFINED LevelFormat = 1
	// Use Cloud Common Expression Language when returning the resource.  Both
	// BasicLevels and CustomLevels are returned as CustomLevels.
	LevelFormat_CEL LevelFormat = 2
)

// Enum value maps for LevelFormat.
var (
	LevelFormat_name = map[int32]string{
		0: "LEVEL_FORMAT_UNSPECIFIED",
		1: "AS_DEFINED",
		2: "CEL",
	}
	LevelFormat_value = map[string]int32{
		"LEVEL_FORMAT_UNSPECIFIED": 0,
		"AS_DEFINED":               1,
		"CEL":                      2,
	}
)

func (x LevelFormat) Enum() *LevelFormat {
	p := new(LevelFormat)
	*p = x
	return p
}

func (x LevelFormat) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LevelFormat) Descriptor() protoreflect.EnumDescriptor {
	return file_google_identity_accesscontextmanager_v1_access_context_manager_proto_enumTypes[0].Descriptor()
}

func (LevelFormat) Type() protoreflect.EnumType {
	return &file_google_identity_accesscontextmanager_v1_access_context_manager_proto_enumTypes[0]
}

func (x LevelFormat) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LevelFormat.Descriptor instead.
func (LevelFormat) EnumDescriptor() ([]byte, []int) {
	return file_google_identity_accesscontextmanager_v1_access_context_manager_proto_rawDescGZIP(), []int{0}
}

// A request to list all `AccessPolicies` for a container.
type ListAccessPoliciesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name for the container to list AccessPolicy instances
	// from.
	//
	// Format:
	// `organizations/{org_id}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Number of AccessPolicy instances to include in the list. Default 100.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Next page token for the next batch of AccessPolicy instances. Defaults to
	// the first page of results.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListAccessPoliciesRequest) Reset() {
	*x = ListAccessPoliciesRequest{}
	mi := &file_google_identity_accesscontextmanager_v1_access_context_manager_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListAccessPoliciesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAccessPoliciesRequest) ProtoMessage() {}

func (x *ListAccessPoliciesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_identity_accesscontextmanager_v1_access_context_manager_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAccessPoliciesRequest.ProtoReflect.Descriptor instead.
func (*ListAccessPoliciesRequest) Descriptor() ([]byte, []int) {
	return file_google_identity_accesscontextmanager_v1_access_context_manager_proto_rawDescGZIP(), []int{0}
}

func (x *ListAccessPoliciesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListAccessPoliciesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAccessPoliciesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// A response to `ListAccessPoliciesRequest`.
type ListAccessPoliciesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of the AccessPolicy instances.
	AccessPolicies []*AccessPolicy `protobuf:"bytes,1,rep,name=access_policies,json=accessPolicies,proto3" json:"access_policies,omitempty"`
	// The pagination token to retrieve the next page of results. If the value is
	// empty, no further results remain.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListAccessPoliciesResponse) Reset() {
	*x = ListAccessPoliciesResponse{}
	mi := &file_google_identity_accesscontextmanager_v1_access_context_manager_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListAccessPoliciesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAccessPoliciesResponse) ProtoMessage() {}

func (x *ListAccessPoliciesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_identity_accesscontextmanager_v1_access_context_manager_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAccessPoliciesResponse.ProtoReflect.Descriptor instead.
func (*ListAccessPoliciesResponse) Descriptor() ([]byte, []int) {
	return file_google_identity_accesscontextmanager_v1_access_context_manager_proto_rawDescGZIP(), []int{1}
}

func (x *ListAccessPoliciesResponse) GetAccessPolicies() []*AccessPolicy {
	if x != nil {
		return x.AccessPolicies
	}
	return nil
}

func (x *ListAccessPoliciesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// A request to get a particular `AccessPolicy`.
type GetAccessPolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name for the access policy to get.
	//
	// Format `accessPolicies/{policy_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetAccessPolicyRequest) Reset() {
	*x = GetAccessPolicyRequest{}
	mi := &file_google_identity_accesscontextmanager_v1_access_context_manager_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetAccessPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAccessPolicyRequest) ProtoMessage() {}

func (x *GetAccessPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_identity_accesscontextmanager_v1_access_context_manager_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAccessPolicyRequest.ProtoReflect.Descriptor instead.
func (*GetAccessPolicyRequest) Descriptor() ([]byte, []int) {
	return file_google_identity_accesscontextmanager_v1_access_context_manager_proto_rawDescGZIP(), []int{2}
}

func (x *GetAccessPolicyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// A request to update an `AccessPolicy`.
type UpdateAccessPolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The updated AccessPolicy.
	Policy *AccessPolicy `protobuf:"bytes,1,opt,name=policy,proto3" json:"policy,omitempty"`
	// Required. Mask to control which fields get updated. Must be non-empty.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateAccessPolicyRequest) Reset() {
	*x = UpdateAccessPolicyRequest{}
	mi := &file_google_identity_accesscontextmanager_v1_access_context_manager_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateAccessPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateAccessPolicyRequest) ProtoMessage() {}

func (x *UpdateAccessPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_identity_accesscontextmanager_v1_access_context_manager_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateAccessPolicyRequest.ProtoReflect.Descriptor instead.
func (*UpdateAccessPolicyRequest) Descriptor() ([]byte, []int) {
	return file_google_identity_accesscontextmanager_v1_access_context_manager_proto_rawDescGZIP(), []int{3}
}

func (x *UpdateAccessPolicyRequest) GetPolicy() *AccessPolicy {
	if x != nil {
		return x.Policy
	}
	return nil
}

func (x *UpdateAccessPolicyRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// A request to delete an `AccessPolicy`.
type DeleteAccessPolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name for the access policy to delete.
	//
	// Format `accessPolicies/{policy_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteAccessPolicyRequest) Reset() {
	*x = DeleteAccessPolicyRequest{}
	mi := &file_google_identity_accesscontextmanager_v1_access_context_manager_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteAccessPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteAccessPolicyRequest) ProtoMessage() {}

func (x *DeleteAccessPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_identity_accesscontextmanager_v1_access_context_manager_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteAccessPolicyRequest.ProtoReflect.Descriptor instead.
func (*DeleteAccessPolicyRequest) Descriptor() ([]byte, []int) {
	return file_google_identity_accesscontextmanager_v1_access_context_manager_proto_rawDescGZIP(), []int{4}
}

func (x *DeleteAccessPolicyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// A request to list all `AccessLevels` in an `AccessPolicy`.
type ListAccessLevelsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name for the access policy to list [Access Levels]
	// [google.identity.accesscontextmanager.v1.AccessLevel] from.
	//
	// Format:
	// `accessPolicies/{policy_id}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Number of [Access Levels]
	// [google.identity.accesscontextmanager.v1.AccessLevel] to include in
	// the list. Default 100.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Next page token for the next batch of [Access Level]
	// [google.identity.accesscontextmanager.v1.AccessLevel] instances.
	// Defaults to the first page of results.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Whether to return `BasicLevels` in the Cloud Common Expression language, as
	// `CustomLevels`, rather than as `BasicLevels`. Defaults to returning
	// `AccessLevels` in the format they were defined.
	AccessLevelFormat LevelFormat `protobuf:"varint,4,opt,name=access_level_format,json=accessLevelFormat,proto3,enum=google.identity.accesscontextmanager.v1.LevelFormat" json:"access_level_format,omitempty"`
}

func (x *ListAccessLevelsRequest) Reset() {
	*x = ListAccessLevelsRequest{}
	mi := &file_google_identity_accesscontextmanager_v1_access_context_manager_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListAccessLevelsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAccessLevelsRequest) ProtoMessage() {}

func (x *ListAccessLevelsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_identity_accesscontextmanager_v1_access_context_manager_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAccessLevelsRequest.ProtoReflect.Descriptor instead.
func (*ListAccessLevelsRequest) Descriptor() ([]byte, []int) {
	return file_google_identity_accesscontextmanager_v1_access_context_manager_proto_rawDescGZIP(), []int{5}
}

func (x *ListAccessLevelsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListAccessLevelsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAccessLevelsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListAccessLevelsRequest) GetAccessLevelFormat() LevelFormat {
	if x != nil {
		return x.AccessLevelFormat
	}
	return LevelFormat_LEVEL_FORMAT_UNSPECIFIED
}

// A response to `ListAccessLevelsRequest`.
type ListAccessLevelsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of the [Access Level]
	// [google.identity.accesscontextmanager.v1.AccessLevel] instances.
	AccessLevels []*AccessLevel `protobuf:"bytes,1,rep,name=access_levels,json=accessLevels,proto3" json:"access_levels,omitempty"`
	// The pagination token to retrieve the next page of results. If the value is
	// empty, no further results remain.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListAccessLevelsResponse) Reset() {
	*x = ListAccessLevelsResponse{}
	mi := &file_google_identity_accesscontextmanager_v1_access_context_manager_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListAccessLevelsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAccessLevelsResponse) ProtoMessage() {}

func (x *ListAccessLevelsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_identity_accesscontextmanager_v1_access_context_manager_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAccessLevelsResponse.ProtoReflect.Descriptor instead.
func (*ListAccessLevelsResponse) Descriptor() ([]byte, []int) {
	return file_google_identity_accesscontextmanager_v1_access_context_manager_proto_rawDescGZIP(), []int{6}
}

func (x *ListAccessLevelsResponse) GetAccessLevels() []*AccessLevel {
	if x != nil {
		return x.AccessLevels
	}
	return nil
}

func (x *ListAccessLevelsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// A request to get a particular `AccessLevel`.
type GetAccessLevelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name for the [Access Level]
	// [google.identity.accesscontextmanager.v1.AccessLevel].
	//
	// Format:
	// `accessPolicies/{policy_id}/accessLevels/{access_level_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Whether to return `BasicLevels` in the Cloud Common Expression
	// Language rather than as `BasicLevels`. Defaults to AS_DEFINED, where
	// [Access Levels] [google.identity.accesscontextmanager.v1.AccessLevel]
	// are returned as `BasicLevels` or `CustomLevels` based on how they were
	// created. If set to CEL, all [Access Levels]
	// [google.identity.accesscontextmanager.v1.AccessLevel] are returned as
	// `CustomLevels`. In the CEL case, `BasicLevels` are translated to equivalent
	// `CustomLevels`.
	AccessLevelFormat LevelFormat `protobuf:"varint,2,opt,name=access_level_format,json=accessLevelFormat,proto3,enum=google.identity.accesscontextmanager.v1.LevelFormat" json:"access_level_format,omitempty"`
}

func (x *GetAccessLevelRequest) Reset() {
	*x = GetAccessLevelRequest{}
	mi := &file_google_identity_accesscontextmanager_v1_access_context_manager_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetAccessLevelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAccessLevelRequest) ProtoMessage() {}

func (x *GetAccessLevelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_identity_accesscontextmanager_v1_access_context_manager_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAccessLevelRequest.ProtoReflect.Descriptor instead.
func (*GetAccessLevelRequest) Descriptor() ([]byte, []int) {
	return file_google_identity_accesscontextmanager_v1_access_context_manager_proto_rawDescGZIP(), []int{7}
}

func (x *GetAccessLevelRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetAccessLevelRequest) GetAccessLevelFormat() LevelFormat {
	if x != nil {
		return x.AccessLevelFormat
	}
	return LevelFormat_LEVEL_FORMAT_UNSPECIFIED
}

// A request to create an `AccessLevel`.
type CreateAccessLevelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name for the access policy which owns this [Access
	// Level] [google.identity.accesscontextmanager.v1.AccessLevel].
	//
	// Format: `accessPolicies/{policy_id}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The [Access Level]
	// [google.identity.accesscontextmanager.v1.AccessLevel] to create.
	// Syntactic correctness of the [Access Level]
	// [google.identity.accesscontextmanager.v1.AccessLevel] is a
	// precondition for creation.
	AccessLevel *AccessLevel `protobuf:"bytes,2,opt,name=access_level,json=accessLevel,proto3" json:"access_level,omitempty"`
}

func (x *CreateAccessLevelRequest) Reset() {
	*x = CreateAccessLevelRequest{}
	mi := &file_google_identity_accesscontextmanager_v1_access_context_manager_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateAccessLevelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateAccessLevelRequest) ProtoMessage() {}

func (x *CreateAccessLevelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_identity_accesscontextmanager_v1_access_context_manager_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateAccessLevelRequest.ProtoReflect.Descriptor instead.
func (*CreateAccessLevelRequest) Descriptor() ([]byte, []int) {
	return file_google_identity_accesscontextmanager_v1_access_context_manager_proto_rawDescGZIP(), []int{8}
}

func (x *CreateAccessLevelRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateAccessLevelRequest) GetAccessLevel() *AccessLevel {
	if x != nil {
		return x.AccessLevel
	}
	return nil
}

// A request to update an `AccessLevel`.
type UpdateAccessLevelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The updated [Access Level]
	// [google.identity.accesscontextmanager.v1.AccessLevel]. Syntactic
	// correctness of the [Access Level]
	// [google.identity.accesscontextmanager.v1.AccessLevel] is a
	// precondition for creation.
	AccessLevel *AccessLevel `protobuf:"bytes,1,opt,name=access_level,json=accessLevel,proto3" json:"access_level,omitempty"`
	// Required. Mask to control which fields get updated. Must be non-empty.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateAccessLevelRequest) Reset() {
	*x = UpdateAccessLevelRequest{}
	mi := &file_google_identity_accesscontextmanager_v1_access_context_manager_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateAccessLevelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateAccessLevelRequest) ProtoMessage() {}

func (x *UpdateAccessLevelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_identity_accesscontextmanager_v1_access_context_manager_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateAccessLevelRequest.ProtoReflect.Descriptor instead.
func (*UpdateAccessLevelRequest) Descriptor() ([]byte, []int) {
	return file_google_identity_accesscontextmanager_v1_access_context_manager_proto_rawDescGZIP(), []int{9}
}

func (x *UpdateAccessLevelRequest) GetAccessLevel() *AccessLevel {
	if x != nil {
		return x.AccessLevel
	}
	return nil
}

func (x *UpdateAccessLevelRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// A request to delete an `AccessLevel`.
type DeleteAccessLevelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name for the [Access Level]
	// [google.identity.accesscontextmanager.v1.AccessLevel].
	//
	// Format:
	// `accessPolicies/{policy_id}/accessLevels/{access_level_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteAccessLevelRequest) Reset() {
	*x = DeleteAccessLevelRequest{}
	mi := &file_google_identity_accesscontextmanager_v1_access_context_manager_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteAccessLevelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteAccessLevelRequest) ProtoMessage() {}

func (x *DeleteAccessLevelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_identity_accesscontextmanager_v1_access_context_manager_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteAccessLevelRequest.ProtoReflect.Descriptor instead.
func (*DeleteAccessLevelRequest) Descriptor() ([]byte, []int) {
	return file_google_identity_accesscontextmanager_v1_access_context_manager_proto_rawDescGZIP(), []int{10}
}

func (x *DeleteAccessLevelRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// A request to replace all existing Access Levels in an Access Policy with
// the Access Levels provided. This is done atomically.
type ReplaceAccessLevelsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name for the access policy which owns these
	// [Access Levels]
	// [google.identity.accesscontextmanager.v1.AccessLevel].
	//
	// Format: `accessPolicies/{policy_id}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The desired [Access Levels]
	// [google.identity.accesscontextmanager.v1.AccessLevel] that should
	// replace all existing [Access Levels]
	// [google.identity.accesscontextmanager.v1.AccessLevel] in the
	// [Access Policy]
	// [google.identity.accesscontextmanager.v1.AccessPolicy].
	AccessLevels []*AccessLevel `protobuf:"bytes,2,rep,name=access_levels,json=accessLevels,proto3" json:"access_levels,omitempty"`
	// Optional. The etag for the version of the [Access Policy]
	// [google.identity.accesscontextmanager.v1.AccessPolicy] that this
	// replace operation is to be performed on. If, at the time of replace, the
	// etag for the Access Policy stored in Access Context Manager is different
	// from the specified etag, then the replace operation will not be performed
	// and the call will fail. This field is not required. If etag is not
	// provided, the operation will be performed as if a valid etag is provided.
	Etag string `protobuf:"bytes,4,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *ReplaceAccessLevelsRequest) Reset() {
	*x = ReplaceAccessLevelsRequest{}
	mi := &file_google_identity_accesscontextmanager_v1_access_context_manager_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReplaceAccessLevelsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReplaceAccessLevelsRequest) ProtoMessage() {}

func (x *ReplaceAccessLevelsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_identity_accesscontextmanager_v1_access_context_manager_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReplaceAccessLevelsRequest.ProtoReflect.Descriptor instead.
func (*ReplaceAccessLevelsRequest) Descriptor() ([]byte, []int) {
	return file_google_identity_accesscontextmanager_v1_access_context_manager_proto_rawDescGZIP(), []int{11}
}

func (x *ReplaceAccessLevelsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ReplaceAccessLevelsRequest) GetAccessLevels() []*AccessLevel {
	if x != nil {
		return x.AccessLevels
	}
	return nil
}

func (x *ReplaceAccessLevelsRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// A response to ReplaceAccessLevelsRequest. This will be put inside of
// Operation.response field.
type ReplaceAccessLevelsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of the [Access Level]
	// [google.identity.accesscontextmanager.v1.AccessLevel] instances.
	AccessLevels []*AccessLevel `protobuf:"bytes,1,rep,name=access_levels,json=accessLevels,proto3" json:"access_levels,omitempty"`
}

func (x *ReplaceAccessLevelsResponse) Reset() {
	*x = ReplaceAccessLevelsResponse{}
	mi := &file_google_identity_accesscontextmanager_v1_access_context_manager_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReplaceAccessLevelsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReplaceAccessLevelsResponse) ProtoMessage() {}

func (x *ReplaceAccessLevelsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_identity_accesscontextmanager_v1_access_context_manager_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReplaceAccessLevelsResponse.ProtoReflect.Descriptor instead.
func (*ReplaceAccessLevelsResponse) Descriptor() ([]byte, []int) {
	return file_google_identity_accesscontextmanager_v1_access_context_manager_proto_rawDescGZIP(), []int{12}
}

func (x *ReplaceAccessLevelsResponse) GetAccessLevels() []*AccessLevel {
	if x != nil {
		return x.AccessLevels
	}
	return nil
}

// A request to list all `ServicePerimeters` in an `AccessPolicy`.
type ListServicePerimetersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name for the access policy to list [Service Perimeters]
	// [google.identity.accesscontextmanager.v1.ServicePerimeter] from.
	//
	// Format:
	// `accessPolicies/{policy_id}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Number of [Service Perimeters]
	// [google.identity.accesscontextmanager.v1.ServicePerimeter] to include
	// in the list. Default 100.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Next page token for the next batch of [Service Perimeter]
	// [google.identity.accesscontextmanager.v1.ServicePerimeter] instances.
	// Defaults to the first page of results.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListServicePerimetersRequest) Reset() {
	*x = ListServicePerimetersRequest{}
	mi := &file_google_identity_accesscontextmanager_v1_access_context_manager_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListServicePerimetersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListServicePerimetersRequest) ProtoMessage() {}

func (x *ListServicePerimetersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_identity_accesscontextmanager_v1_access_context_manager_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListServicePerimetersRequest.ProtoReflect.Descriptor instead.
func (*ListServicePerimetersRequest) Descriptor() ([]byte, []int) {
	return file_google_identity_accesscontextmanager_v1_access_context_manager_proto_rawDescGZIP(), []int{13}
}

func (x *ListServicePerimetersRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListServicePerimetersRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListServicePerimetersRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// A response to `ListServicePerimetersRequest`.
type ListServicePerimetersResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of the [Service Perimeter]
	// [google.identity.accesscontextmanager.v1.ServicePerimeter] instances.
	ServicePerimeters []*ServicePerimeter `protobuf:"bytes,1,rep,name=service_perimeters,json=servicePerimeters,proto3" json:"service_perimeters,omitempty"`
	// The pagination token to retrieve the next page of results. If the value is
	// empty, no further results remain.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListServicePerimetersResponse) Reset() {
	*x = ListServicePerimetersResponse{}
	mi := &file_google_identity_accesscontextmanager_v1_access_context_manager_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListServicePerimetersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListServicePerimetersResponse) ProtoMessage() {}

func (x *ListServicePerimetersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_identity_accesscontextmanager_v1_access_context_manager_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListServicePerimetersResponse.ProtoReflect.Descriptor instead.
func (*ListServicePerimetersResponse) Descriptor() ([]byte, []int) {
	return file_google_identity_accesscontextmanager_v1_access_context_manager_proto_rawDescGZIP(), []int{14}
}

func (x *ListServicePerimetersResponse) GetServicePerimeters() []*ServicePerimeter {
	if x != nil {
		return x.ServicePerimeters
	}
	return nil
}

func (x *ListServicePerimetersResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// A request to get a particular `ServicePerimeter`.
type GetServicePerimeterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name for the [Service Perimeter]
	// [google.identity.accesscontextmanager.v1.ServicePerimeter].
	//
	// Format:
	// `accessPolicies/{policy_id}/servicePerimeters/{service_perimeters_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetServicePerimeterRequest) Reset() {
	*x = GetServicePerimeterRequest{}
	mi := &file_google_identity_accesscontextmanager_v1_access_context_manager_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetServicePerimeterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetServicePerimeterRequest) ProtoMessage() {}

func (x *GetServicePerimeterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_identity_accesscontextmanager_v1_access_context_manager_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetServicePerimeterRequest.ProtoReflect.Descriptor instead.
func (*GetServicePerimeterRequest) Descriptor() ([]byte, []int) {
	return file_google_identity_accesscontextmanager_v1_access_context_manager_proto_rawDescGZIP(), []int{15}
}

func (x *GetServicePerimeterRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// A request to create a `ServicePerimeter`.
type CreateServicePerimeterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name for the access policy which owns this [Service
	// Perimeter] [google.identity.accesscontextmanager.v1.ServicePerimeter].
	//
	// Format: `accessPolicies/{policy_id}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The [Service Perimeter]
	// [google.identity.accesscontextmanager.v1.ServicePerimeter] to create.
	// Syntactic correctness of the [Service Perimeter]
	// [google.identity.accesscontextmanager.v1.ServicePerimeter] is a
	// precondition for creation.
	ServicePerimeter *ServicePerimeter `protobuf:"bytes,2,opt,name=service_perimeter,json=servicePerimeter,proto3" json:"service_perimeter,omitempty"`
}

func (x *CreateServicePerimeterRequest) Reset() {
	*x = CreateServicePerimeterRequest{}
	mi := &file_google_identity_accesscontextmanager_v1_access_context_manager_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateServicePerimeterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateServicePerimeterRequest) ProtoMessage() {}

func (x *CreateServicePerimeterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_identity_accesscontextmanager_v1_access_context_manager_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateServicePerimeterRequest.ProtoReflect.Descriptor instead.
func (*CreateServicePerimeterRequest) Descriptor() ([]byte, []int) {
	return file_google_identity_accesscontextmanager_v1_access_context_manager_proto_rawDescGZIP(), []int{16}
}

func (x *CreateServicePerimeterRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateServicePerimeterRequest) GetServicePerimeter() *ServicePerimeter {
	if x != nil {
		return x.ServicePerimeter
	}
	return nil
}

// A request to update a `ServicePerimeter`.
type UpdateServicePerimeterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The updated `ServicePerimeter`. Syntactic correctness of the
	// `ServicePerimeter` is a precondition for creation.
	ServicePerimeter *ServicePerimeter `protobuf:"bytes,1,opt,name=service_perimeter,json=servicePerimeter,proto3" json:"service_perimeter,omitempty"`
	// Required. Mask to control which fields get updated. Must be non-empty.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateServicePerimeterRequest) Reset() {
	*x = UpdateServicePerimeterRequest{}
	mi := &file_google_identity_accesscontextmanager_v1_access_context_manager_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateServicePerimeterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateServicePerimeterRequest) ProtoMessage() {}

func (x *UpdateServicePerimeterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_identity_accesscontextmanager_v1_access_context_manager_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateServicePerimeterRequest.ProtoReflect.Descriptor instead.
func (*UpdateServicePerimeterRequest) Descriptor() ([]byte, []int) {
	return file_google_identity_accesscontextmanager_v1_access_context_manager_proto_rawDescGZIP(), []int{17}
}

func (x *UpdateServicePerimeterRequest) GetServicePerimeter() *ServicePerimeter {
	if x != nil {
		return x.ServicePerimeter
	}
	return nil
}

func (x *UpdateServicePerimeterRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// A request to delete a `ServicePerimeter`.
type DeleteServicePerimeterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name for the [Service Perimeter]
	// [google.identity.accesscontextmanager.v1.ServicePerimeter].
	//
	// Format:
	// `accessPolicies/{policy_id}/servicePerimeters/{service_perimeter_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteServicePerimeterRequest) Reset() {
	*x = DeleteServicePerimeterRequest{}
	mi := &file_google_identity_accesscontextmanager_v1_access_context_manager_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteServicePerimeterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteServicePerimeterRequest) ProtoMessage() {}

func (x *DeleteServicePerimeterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_identity_accesscontextmanager_v1_access_context_manager_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteServicePerimeterRequest.ProtoReflect.Descriptor instead.
func (*DeleteServicePerimeterRequest) Descriptor() ([]byte, []int) {
	return file_google_identity_accesscontextmanager_v1_access_context_manager_proto_rawDescGZIP(), []int{18}
}

func (x *DeleteServicePerimeterRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// A request to replace all existing Service Perimeters in an Access Policy
// with the Service Perimeters provided. This is done atomically.
type ReplaceServicePerimetersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name for the access policy which owns these
	// [Service Perimeters]
	// [google.identity.accesscontextmanager.v1.ServicePerimeter].
	//
	// Format: `accessPolicies/{policy_id}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The desired [Service Perimeters]
	// [google.identity.accesscontextmanager.v1.ServicePerimeter] that should
	// replace all existing [Service Perimeters]
	// [google.identity.accesscontextmanager.v1.ServicePerimeter] in the
	// [Access Policy]
	// [google.identity.accesscontextmanager.v1.AccessPolicy].
	ServicePerimeters []*ServicePerimeter `protobuf:"bytes,2,rep,name=service_perimeters,json=servicePerimeters,proto3" json:"service_perimeters,omitempty"`
	// Optional. The etag for the version of the [Access Policy]
	// [google.identity.accesscontextmanager.v1.AccessPolicy] that this
	// replace operation is to be performed on. If, at the time of replace, the
	// etag for the Access Policy stored in Access Context Manager is different
	// from the specified etag, then the replace operation will not be performed
	// and the call will fail. This field is not required. If etag is not
	// provided, the operation will be performed as if a valid etag is provided.
	Etag string `protobuf:"bytes,3,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *ReplaceServicePerimetersRequest) Reset() {
	*x = ReplaceServicePerimetersRequest{}
	mi := &file_google_identity_accesscontextmanager_v1_access_context_manager_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReplaceServicePerimetersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReplaceServicePerimetersRequest) ProtoMessage() {}

func (x *ReplaceServicePerimetersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_identity_accesscontextmanager_v1_access_context_manager_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReplaceServicePerimetersRequest.ProtoReflect.Descriptor instead.
func (*ReplaceServicePerimetersRequest) Descriptor() ([]byte, []int) {
	return file_google_identity_accesscontextmanager_v1_access_context_manager_proto_rawDescGZIP(), []int{19}
}

func (x *ReplaceServicePerimetersRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ReplaceServicePerimetersRequest) GetServicePerimeters() []*ServicePerimeter {
	if x != nil {
		return x.ServicePerimeters
	}
	return nil
}

func (x *ReplaceServicePerimetersRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// A response to ReplaceServicePerimetersRequest. This will be put inside of
// Operation.response field.
type ReplaceServicePerimetersResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of the [Service Perimeter]
	// [google.identity.accesscontextmanager.v1.ServicePerimeter] instances.
	ServicePerimeters []*ServicePerimeter `protobuf:"bytes,1,rep,name=service_perimeters,json=servicePerimeters,proto3" json:"service_perimeters,omitempty"`
}

func (x *ReplaceServicePerimetersResponse) Reset() {
	*x = ReplaceServicePerimetersResponse{}
	mi := &file_google_identity_accesscontextmanager_v1_access_context_manager_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReplaceServicePerimetersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReplaceServicePerimetersResponse) ProtoMessage() {}

func (x *ReplaceServicePerimetersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_identity_accesscontextmanager_v1_access_context_manager_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReplaceServicePerimetersResponse.ProtoReflect.Descriptor instead.
func (*ReplaceServicePerimetersResponse) Descriptor() ([]byte, []int) {
	return file_google_identity_accesscontextmanager_v1_access_context_manager_proto_rawDescGZIP(), []int{20}
}

func (x *ReplaceServicePerimetersResponse) GetServicePerimeters() []*ServicePerimeter {
	if x != nil {
		return x.ServicePerimeters
	}
	return nil
}

// A request to commit dry-run specs in all [Service Perimeters]
// [google.identity.accesscontextmanager.v1.ServicePerimeter] belonging to
// an [Access Policy][google.identity.accesscontextmanager.v1.AccessPolicy].
type CommitServicePerimetersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name for the parent [Access Policy]
	// [google.identity.accesscontextmanager.v1.AccessPolicy] which owns all
	// [Service Perimeters]
	// [google.identity.accesscontextmanager.v1.ServicePerimeter] in scope for
	// the commit operation.
	//
	// Format: `accessPolicies/{policy_id}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The etag for the version of the [Access Policy]
	// [google.identity.accesscontextmanager.v1.AccessPolicy] that this
	// commit operation is to be performed on. If, at the time of commit, the
	// etag for the Access Policy stored in Access Context Manager is different
	// from the specified etag, then the commit operation will not be performed
	// and the call will fail. This field is not required. If etag is not
	// provided, the operation will be performed as if a valid etag is provided.
	Etag string `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *CommitServicePerimetersRequest) Reset() {
	*x = CommitServicePerimetersRequest{}
	mi := &file_google_identity_accesscontextmanager_v1_access_context_manager_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CommitServicePerimetersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommitServicePerimetersRequest) ProtoMessage() {}

func (x *CommitServicePerimetersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_identity_accesscontextmanager_v1_access_context_manager_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommitServicePerimetersRequest.ProtoReflect.Descriptor instead.
func (*CommitServicePerimetersRequest) Descriptor() ([]byte, []int) {
	return file_google_identity_accesscontextmanager_v1_access_context_manager_proto_rawDescGZIP(), []int{21}
}

func (x *CommitServicePerimetersRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CommitServicePerimetersRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// A response to CommitServicePerimetersRequest. This will be put inside of
// Operation.response field.
type CommitServicePerimetersResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of all the [Service Perimeter]
	// [google.identity.accesscontextmanager.v1.ServicePerimeter] instances in
	// the [Access Policy]
	// [google.identity.accesscontextmanager.v1.AccessPolicy].
	ServicePerimeters []*ServicePerimeter `protobuf:"bytes,1,rep,name=service_perimeters,json=servicePerimeters,proto3" json:"service_perimeters,omitempty"`
}

func (x *CommitServicePerimetersResponse) Reset() {
	*x = CommitServicePerimetersResponse{}
	mi := &file_google_identity_accesscontextmanager_v1_access_context_manager_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CommitServicePerimetersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommitServicePerimetersResponse) ProtoMessage() {}

func (x *CommitServicePerimetersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_identity_accesscontextmanager_v1_access_context_manager_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommitServicePerimetersResponse.ProtoReflect.Descriptor instead.
func (*CommitServicePerimetersResponse) Descriptor() ([]byte, []int) {
	return file_google_identity_accesscontextmanager_v1_access_context_manager_proto_rawDescGZIP(), []int{22}
}

func (x *CommitServicePerimetersResponse) GetServicePerimeters() []*ServicePerimeter {
	if x != nil {
		return x.ServicePerimeters
	}
	return nil
}

// Request of [ListGcpUserAccessBindings]
// [google.identity.accesscontextmanager.v1.AccessContextManager.ListGcpUserAccessBindings].
type ListGcpUserAccessBindingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example: "organizations/256"
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Maximum number of items to return. The server may return fewer items.
	// If left blank, the server may return any number of items.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. If left blank, returns the first page. To enumerate all items, use the
	// [next_page_token]
	// [google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsResponse.next_page_token]
	// from your previous list operation.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListGcpUserAccessBindingsRequest) Reset() {
	*x = ListGcpUserAccessBindingsRequest{}
	mi := &file_google_identity_accesscontextmanager_v1_access_context_manager_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListGcpUserAccessBindingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListGcpUserAccessBindingsRequest) ProtoMessage() {}

func (x *ListGcpUserAccessBindingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_identity_accesscontextmanager_v1_access_context_manager_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListGcpUserAccessBindingsRequest.ProtoReflect.Descriptor instead.
func (*ListGcpUserAccessBindingsRequest) Descriptor() ([]byte, []int) {
	return file_google_identity_accesscontextmanager_v1_access_context_manager_proto_rawDescGZIP(), []int{23}
}

func (x *ListGcpUserAccessBindingsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListGcpUserAccessBindingsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListGcpUserAccessBindingsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response of [ListGcpUserAccessBindings]
// [google.identity.accesscontextmanager.v1.AccessContextManager.ListGcpUserAccessBindings].
type ListGcpUserAccessBindingsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [GcpUserAccessBinding]
	// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding]
	GcpUserAccessBindings []*GcpUserAccessBinding `protobuf:"bytes,1,rep,name=gcp_user_access_bindings,json=gcpUserAccessBindings,proto3" json:"gcp_user_access_bindings,omitempty"`
	// Token to get the next page of items. If blank, there are no more items.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListGcpUserAccessBindingsResponse) Reset() {
	*x = ListGcpUserAccessBindingsResponse{}
	mi := &file_google_identity_accesscontextmanager_v1_access_context_manager_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListGcpUserAccessBindingsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListGcpUserAccessBindingsResponse) ProtoMessage() {}

func (x *ListGcpUserAccessBindingsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_identity_accesscontextmanager_v1_access_context_manager_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListGcpUserAccessBindingsResponse.ProtoReflect.Descriptor instead.
func (*ListGcpUserAccessBindingsResponse) Descriptor() ([]byte, []int) {
	return file_google_identity_accesscontextmanager_v1_access_context_manager_proto_rawDescGZIP(), []int{24}
}

func (x *ListGcpUserAccessBindingsResponse) GetGcpUserAccessBindings() []*GcpUserAccessBinding {
	if x != nil {
		return x.GcpUserAccessBindings
	}
	return nil
}

func (x *ListGcpUserAccessBindingsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request of [GetGcpUserAccessBinding]
// [google.identity.accesscontextmanager.v1.AccessContextManager.GetGcpUserAccessBinding].
type GetGcpUserAccessBindingRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example: "organizations/256/gcpUserAccessBindings/b3-BhcX_Ud5N"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetGcpUserAccessBindingRequest) Reset() {
	*x = GetGcpUserAccessBindingRequest{}
	mi := &file_google_identity_accesscontextmanager_v1_access_context_manager_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetGcpUserAccessBindingRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGcpUserAccessBindingRequest) ProtoMessage() {}

func (x *GetGcpUserAccessBindingRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_identity_accesscontextmanager_v1_access_context_manager_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGcpUserAccessBindingRequest.ProtoReflect.Descriptor instead.
func (*GetGcpUserAccessBindingRequest) Descriptor() ([]byte, []int) {
	return file_google_identity_accesscontextmanager_v1_access_context_manager_proto_rawDescGZIP(), []int{25}
}

func (x *GetGcpUserAccessBindingRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request of [CreateGcpUserAccessBinding]
// [google.identity.accesscontextmanager.v1.AccessContextManager.CreateGcpUserAccessBinding].
type CreateGcpUserAccessBindingRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example: "organizations/256"
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. [GcpUserAccessBinding]
	// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding]
	GcpUserAccessBinding *GcpUserAccessBinding `protobuf:"bytes,2,opt,name=gcp_user_access_binding,json=gcpUserAccessBinding,proto3" json:"gcp_user_access_binding,omitempty"`
}

func (x *CreateGcpUserAccessBindingRequest) Reset() {
	*x = CreateGcpUserAccessBindingRequest{}
	mi := &file_google_identity_accesscontextmanager_v1_access_context_manager_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateGcpUserAccessBindingRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateGcpUserAccessBindingRequest) ProtoMessage() {}

func (x *CreateGcpUserAccessBindingRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_identity_accesscontextmanager_v1_access_context_manager_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateGcpUserAccessBindingRequest.ProtoReflect.Descriptor instead.
func (*CreateGcpUserAccessBindingRequest) Descriptor() ([]byte, []int) {
	return file_google_identity_accesscontextmanager_v1_access_context_manager_proto_rawDescGZIP(), []int{26}
}

func (x *CreateGcpUserAccessBindingRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateGcpUserAccessBindingRequest) GetGcpUserAccessBinding() *GcpUserAccessBinding {
	if x != nil {
		return x.GcpUserAccessBinding
	}
	return nil
}

// Request of [UpdateGcpUserAccessBinding]
// [google.identity.accesscontextmanager.v1.AccessContextManager.UpdateGcpUserAccessBinding].
type UpdateGcpUserAccessBindingRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. [GcpUserAccessBinding]
	// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding]
	GcpUserAccessBinding *GcpUserAccessBinding `protobuf:"bytes,1,opt,name=gcp_user_access_binding,json=gcpUserAccessBinding,proto3" json:"gcp_user_access_binding,omitempty"`
	// Required. Only the fields specified in this mask are updated. Because name and
	// group_key cannot be changed, update_mask is required and must always be:
	//
	// update_mask {
	// paths: "access_levels"
	// }
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateGcpUserAccessBindingRequest) Reset() {
	*x = UpdateGcpUserAccessBindingRequest{}
	mi := &file_google_identity_accesscontextmanager_v1_access_context_manager_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateGcpUserAccessBindingRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateGcpUserAccessBindingRequest) ProtoMessage() {}

func (x *UpdateGcpUserAccessBindingRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_identity_accesscontextmanager_v1_access_context_manager_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateGcpUserAccessBindingRequest.ProtoReflect.Descriptor instead.
func (*UpdateGcpUserAccessBindingRequest) Descriptor() ([]byte, []int) {
	return file_google_identity_accesscontextmanager_v1_access_context_manager_proto_rawDescGZIP(), []int{27}
}

func (x *UpdateGcpUserAccessBindingRequest) GetGcpUserAccessBinding() *GcpUserAccessBinding {
	if x != nil {
		return x.GcpUserAccessBinding
	}
	return nil
}

func (x *UpdateGcpUserAccessBindingRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request of [DeleteGcpUserAccessBinding]
// [google.identity.accesscontextmanager.v1.AccessContextManager.DeleteGcpUserAccessBinding].
type DeleteGcpUserAccessBindingRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example: "organizations/256/gcpUserAccessBindings/b3-BhcX_Ud5N"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteGcpUserAccessBindingRequest) Reset() {
	*x = DeleteGcpUserAccessBindingRequest{}
	mi := &file_google_identity_accesscontextmanager_v1_access_context_manager_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteGcpUserAccessBindingRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteGcpUserAccessBindingRequest) ProtoMessage() {}

func (x *DeleteGcpUserAccessBindingRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_identity_accesscontextmanager_v1_access_context_manager_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteGcpUserAccessBindingRequest.ProtoReflect.Descriptor instead.
func (*DeleteGcpUserAccessBindingRequest) Descriptor() ([]byte, []int) {
	return file_google_identity_accesscontextmanager_v1_access_context_manager_proto_rawDescGZIP(), []int{28}
}

func (x *DeleteGcpUserAccessBindingRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Currently, a completed operation means nothing. In the future, this metadata
// and a completed operation may indicate that the binding has taken effect and
// is affecting access decisions for all users.
type GcpUserAccessBindingOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *GcpUserAccessBindingOperationMetadata) Reset() {
	*x = GcpUserAccessBindingOperationMetadata{}
	mi := &file_google_identity_accesscontextmanager_v1_access_context_manager_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GcpUserAccessBindingOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GcpUserAccessBindingOperationMetadata) ProtoMessage() {}

func (x *GcpUserAccessBindingOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_identity_accesscontextmanager_v1_access_context_manager_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GcpUserAccessBindingOperationMetadata.ProtoReflect.Descriptor instead.
func (*GcpUserAccessBindingOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_identity_accesscontextmanager_v1_access_context_manager_proto_rawDescGZIP(), []int{29}
}

// Metadata of Access Context Manager's Long Running Operations.
type AccessContextManagerOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *AccessContextManagerOperationMetadata) Reset() {
	*x = AccessContextManagerOperationMetadata{}
	mi := &file_google_identity_accesscontextmanager_v1_access_context_manager_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AccessContextManagerOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AccessContextManagerOperationMetadata) ProtoMessage() {}

func (x *AccessContextManagerOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_identity_accesscontextmanager_v1_access_context_manager_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AccessContextManagerOperationMetadata.ProtoReflect.Descriptor instead.
func (*AccessContextManagerOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_identity_accesscontextmanager_v1_access_context_manager_proto_rawDescGZIP(), []int{30}
}

var File_google_identity_accesscontextmanager_v1_access_context_manager_proto protoreflect.FileDescriptor

var file_google_identity_accesscontextmanager_v1_access_context_manager_proto_rawDesc = []byte{
	0x0a, 0x44, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x2f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x1a,
	0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x69, 0x61, 0x6d, 0x2f, 0x76,
	0x31, 0x2f, 0x69, 0x61, 0x6d, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x69, 0x61, 0x6d, 0x2f, 0x76,
	0x31, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3a,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2f,
	0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x6c,
	0x65, 0x76, 0x65, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3b, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2f, 0x61, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72,
	0x2f, 0x76, 0x31, 0x2f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x45, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2f, 0x76, 0x31,
	0x2f, 0x67, 0x63, 0x70, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x5f, 0x62, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2f,
	0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f,
	0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xa9, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x50, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x38, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x32, 0x0a, 0x30, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53,
	0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x22, 0xa4, 0x01, 0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x5e, 0x0a, 0x0f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x70, 0x6f, 0x6c, 0x69,
	0x63, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x61, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x52, 0x0e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65,
	0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74,
	0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x66, 0x0a, 0x16, 0x47, 0x65, 0x74,
	0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x38, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x32, 0x0a, 0x30, 0x61, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0xb1, 0x01, 0x0a, 0x19, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x52, 0x0a, 0x06, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x69, 0x0a, 0x19, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x4c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x38, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x32, 0x0a, 0x30, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0x8c, 0x02, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4c,
	0x65, 0x76, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4f, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x37, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x31, 0x12, 0x2f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74,
	0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x64, 0x0a, 0x13, 0x61, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x52, 0x11, 0x61, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x22,
	0x9d, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4c, 0x65,
	0x76, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x59, 0x0a, 0x0d,
	0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74,
	0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52, 0x0c, 0x61, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22,
	0xca, 0x01, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4c, 0x65, 0x76,
	0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x37, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x31, 0x0a,
	0x2f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4c, 0x65, 0x76, 0x65, 0x6c,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x64, 0x0a, 0x13, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74,
	0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x65,
	0x76, 0x65, 0x6c, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x52, 0x11, 0x61, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x22, 0xc9, 0x01, 0x0a,
	0x18, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4c, 0x65, 0x76,
	0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4f, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x37, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x31, 0x12, 0x2f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4c, 0x65, 0x76,
	0x65, 0x6c, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x5c, 0x0a, 0x0c, 0x61, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x61, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x22, 0xba, 0x01, 0x0a, 0x18, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5c, 0x0a, 0x0c, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f,
	0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x61, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4c, 0x65, 0x76, 0x65,
	0x6c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4c, 0x65,
	0x76, 0x65, 0x6c, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x67, 0x0a, 0x18, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x4b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x37, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x31, 0x0a, 0x2f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xe1,
	0x01, 0x0a, 0x1a, 0x52, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x4c, 0x65, 0x76, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4f, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x37, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x31, 0x12, 0x2f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x5e,
	0x0a, 0x0d, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0c, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x73, 0x12, 0x12,
	0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74,
	0x61, 0x67, 0x22, 0x78, 0x0a, 0x1b, 0x52, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x41, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x59, 0x0a, 0x0d, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x6c, 0x65, 0x76, 0x65,
	0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52, 0x0c,
	0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x73, 0x22, 0xb0, 0x01, 0x0a,
	0x1c, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x54, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3c, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x36, 0x12, 0x34, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65,
	0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22,
	0xb1, 0x01, 0x0a, 0x1d, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50,
	0x65, 0x72, 0x69, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x68, 0x0a, 0x12, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x70, 0x65, 0x72,
	0x69, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e,
	0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50,
	0x65, 0x72, 0x69, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x52, 0x11, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x50, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0x6e, 0x0a, 0x1a, 0x47, 0x65, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x50, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x50, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x3c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x36, 0x0a, 0x34, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0xe2, 0x01, 0x0a, 0x1d, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x54, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x36, 0x12, 0x34, 0x61,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x6b, 0x0a, 0x11, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50,
	0x65, 0x72, 0x69, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x22, 0xce, 0x01, 0x0a, 0x1d, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x6b, 0x0a, 0x11, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x65,
	0x72, 0x69, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x71, 0x0a, 0x1d, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x50, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x36,
	0x0a, 0x34, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x65, 0x72,
	0x69, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xfa, 0x01, 0x0a,
	0x1f, 0x52, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50,
	0x65, 0x72, 0x69, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x54, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x3c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x36, 0x12, 0x34, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x6d, 0x0a, 0x12, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x5f, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x11, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x22, 0x8c, 0x01, 0x0a, 0x20, 0x52, 0x65,
	0x70, 0x6c, 0x61, 0x63, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x68,
	0x0a, 0x12, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x61, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x52, 0x11, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x65,
	0x72, 0x69, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x22, 0x8a, 0x01, 0x0a, 0x1e, 0x43, 0x6f, 0x6d,
	0x6d, 0x69, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x54, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3c, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x36, 0x12, 0x34, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x50, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x65, 0x74, 0x61, 0x67, 0x22, 0x8b, 0x01, 0x0a, 0x1f, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x68, 0x0a, 0x12, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x52, 0x11, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x74,
	0x65, 0x72, 0x73, 0x22, 0xba, 0x01, 0x0a, 0x20, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x63, 0x70, 0x55,
	0x73, 0x65, 0x72, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x50, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x38, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x32,
	0x0a, 0x30, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x22, 0xc3, 0x01, 0x0a, 0x21, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x63, 0x70, 0x55, 0x73, 0x65, 0x72,
	0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x76, 0x0a, 0x18, 0x67, 0x63, 0x70, 0x5f, 0x75, 0x73,
	0x65, 0x72, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x62, 0x69, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x47, 0x63, 0x70, 0x55, 0x73, 0x65, 0x72, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x15, 0x67, 0x63, 0x70, 0x55, 0x73, 0x65, 0x72,
	0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x26,
	0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x76, 0x0a, 0x1e, 0x47, 0x65, 0x74, 0x47, 0x63, 0x70,
	0x55, 0x73, 0x65, 0x72, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x54, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x40, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x3a, 0x0a, 0x38,
	0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x63, 0x70, 0x55, 0x73, 0x65, 0x72, 0x41, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xf0,
	0x01, 0x0a, 0x21, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x47, 0x63, 0x70, 0x55, 0x73, 0x65, 0x72,
	0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x50, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x38, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x32, 0x0a, 0x30, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x79, 0x0a, 0x17, 0x67, 0x63, 0x70, 0x5f, 0x75, 0x73,
	0x65, 0x72, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x62, 0x69, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x47, 0x63, 0x70, 0x55, 0x73, 0x65, 0x72, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42,
	0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x14, 0x67, 0x63, 0x70,
	0x55, 0x73, 0x65, 0x72, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x22, 0xe0, 0x01, 0x0a, 0x21, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x47, 0x63, 0x70, 0x55,
	0x73, 0x65, 0x72, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x79, 0x0a, 0x17, 0x67, 0x63, 0x70, 0x5f, 0x75,
	0x73, 0x65, 0x72, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x62, 0x69, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x47, 0x63, 0x70, 0x55, 0x73, 0x65, 0x72, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x14, 0x67, 0x63,
	0x70, 0x55, 0x73, 0x65, 0x72, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d,
	0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x4d, 0x61, 0x73, 0x6b, 0x22, 0x79, 0x0a, 0x21, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x47, 0x63,
	0x70, 0x55, 0x73, 0x65, 0x72, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x54, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x40, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x3a, 0x0a,
	0x38, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x63, 0x70, 0x55, 0x73, 0x65, 0x72, 0x41, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0x27, 0x0a, 0x25, 0x47, 0x63, 0x70, 0x55, 0x73, 0x65, 0x72, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x27, 0x0a, 0x25, 0x41, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x2a, 0x44, 0x0a, 0x0b, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74,
	0x12, 0x1c, 0x0a, 0x18, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x5f, 0x46, 0x4f, 0x52, 0x4d, 0x41, 0x54,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0e,
	0x0a, 0x0a, 0x41, 0x53, 0x5f, 0x44, 0x45, 0x46, 0x49, 0x4e, 0x45, 0x44, 0x10, 0x01, 0x12, 0x07,
	0x0a, 0x03, 0x43, 0x45, 0x4c, 0x10, 0x02, 0x32, 0xf1, 0x32, 0x0a, 0x14, 0x41, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72,
	0x12, 0xb9, 0x01, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x12, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x43, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x61, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x1a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x14, 0x12, 0x12, 0x2f, 0x76, 0x31, 0x2f, 0x61, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x12, 0xb5, 0x01, 0x0a,
	0x0f, 0x47, 0x65, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x41, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78,
	0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x2a, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1d, 0x12, 0x1b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc1, 0x01, 0x0a, 0x12, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x35, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x61, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x55, 0xca, 0x41, 0x35, 0x0a, 0x0c, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x12, 0x25, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x78, 0x74, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x17, 0x3a, 0x01, 0x2a, 0x22, 0x12, 0x2f, 0x76, 0x31, 0x2f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x12, 0xf8, 0x01, 0x0a, 0x12, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12,
	0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e,
	0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x7f, 0xca, 0x41, 0x35, 0x0a, 0x0c, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x25, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e,
	0x74, 0x65, 0x78, 0x74, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x12, 0x70,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2c, 0x3a, 0x06, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x32,
	0x22, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0xe4, 0x01, 0x0a, 0x12, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x42, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x61, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6b, 0xca,
	0x41, 0x3e, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x25, 0x41, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1d, 0x2a, 0x1b, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd4, 0x01, 0x0a, 0x10, 0x4c,
	0x69, 0x73, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x73, 0x12,
	0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78,
	0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3b, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x2c, 0x12, 0x2a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4c, 0x65, 0x76, 0x65, 0x6c,
	0x73, 0x12, 0xc1, 0x01, 0x0a, 0x0e, 0x47, 0x65, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4c,
	0x65, 0x76, 0x65, 0x6c, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47,
	0x65, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x22, 0x39, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2c, 0x12, 0x2a, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4c, 0x65, 0x76, 0x65,
	0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x85, 0x02, 0x0a, 0x11, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x41, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x61, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x8d, 0x01,
	0xca, 0x41, 0x34, 0x0a, 0x0b, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4c, 0x65, 0x76, 0x65, 0x6c,
	0x12, 0x25, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x4d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x13, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x2c, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x3a, 0x3a, 0x0c, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x6c, 0x65, 0x76, 0x65,
	0x6c, 0x22, 0x2a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x73, 0x12, 0x97, 0x02,
	0x0a, 0x11, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4c, 0x65,
	0x76, 0x65, 0x6c, 0x12, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74,
	0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x9f, 0x01, 0xca, 0x41, 0x34, 0x0a, 0x0b, 0x41, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x25, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda,
	0x41, 0x18, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x2c, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x47,
	0x3a, 0x0c, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x32, 0x37,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x6c, 0x65, 0x76, 0x65,
	0x6c, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4c, 0x65,
	0x76, 0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xf1, 0x01, 0x0a, 0x11, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x41, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e,
	0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x7a, 0xca, 0x41, 0x3e, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x25, 0x41, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x72, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2c, 0x2a,
	0x2a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x83, 0x02, 0x0a, 0x13,
	0x52, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4c, 0x65, 0x76,
	0x65, 0x6c, 0x73, 0x12, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74,
	0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65,
	0x70, 0x6c, 0x61, 0x63, 0x65, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4c, 0x65, 0x76, 0x65, 0x6c,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x87, 0x01, 0xca, 0x41, 0x44, 0x0a, 0x1b, 0x52,
	0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4c, 0x65, 0x76, 0x65,
	0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x25, 0x41, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3a, 0x3a, 0x01, 0x2a, 0x22, 0x35, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x4c, 0x65, 0x76, 0x65, 0x6c, 0x73, 0x3a, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x41, 0x6c,
	0x6c, 0x12, 0xe8, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x50, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x45, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x61, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x50, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x40, 0xda, 0x41, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x12, 0x2f, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0xd5, 0x01, 0x0a,
	0x13, 0x47, 0x65, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x12, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47,
	0x65, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x74,
	0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x61, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x22, 0x3e, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x31, 0x12, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xa3, 0x02, 0x0a, 0x16, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x12,
	0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xa1, 0x01, 0xca, 0x41, 0x39, 0x0a, 0x10, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x12, 0x25,
	0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x4d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x72, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x18, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x44, 0x3a, 0x11, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f,
	0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x22, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x50, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0xba, 0x02, 0x0a, 0x16, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x12, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x65, 0x72,
	0x69, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xb8, 0x01, 0xca,
	0x41, 0x39, 0x0a, 0x10, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x12, 0x25, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x78, 0x74, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x1d, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x2c,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x56, 0x3a, 0x11, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x69, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x32, 0x41, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x2e, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73,
	0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x80, 0x02, 0x0a, 0x16, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x74,
	0x65, 0x72, 0x12, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x7f, 0xca, 0x41, 0x3e, 0x0a, 0x15,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x25, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e,
	0x74, 0x65, 0x78, 0x74, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x2a, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x65, 0x72,
	0x69, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x97, 0x02, 0x0a, 0x18, 0x52,
	0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x65, 0x72,
	0x69, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x50, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72,
	0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x91, 0x01, 0xca, 0x41, 0x49, 0x0a, 0x20, 0x52, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x25, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x3f, 0x3a, 0x01, 0x2a, 0x22, 0x3a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50,
	0x65, 0x72, 0x69, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x3a, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x63,
	0x65, 0x41, 0x6c, 0x6c, 0x12, 0x90, 0x02, 0x0a, 0x17, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73,
	0x12, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x69,
	0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x8c, 0x01, 0xca, 0x41, 0x48, 0x0a, 0x1f,
	0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x65, 0x72,
	0x69, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x25, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x4d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x72, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x3a, 0x01, 0x2a, 0x22,
	0x36, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73,
	0x3a, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x12, 0xf7, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74,
	0x47, 0x63, 0x70, 0x55, 0x73, 0x65, 0x72, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x47, 0x63, 0x70, 0x55, 0x73, 0x65, 0x72, 0x41, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x47,
	0x63, 0x70, 0x55, 0x73, 0x65, 0x72, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x43, 0xda, 0x41,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x34, 0x12, 0x32, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x67, 0x63, 0x70, 0x55,
	0x73, 0x65, 0x72, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x73, 0x12, 0xe4, 0x01, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x47, 0x63, 0x70, 0x55, 0x73, 0x65, 0x72,
	0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x47, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e,
	0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x47, 0x63, 0x70, 0x55, 0x73,
	0x65, 0x72, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x47, 0x63, 0x70, 0x55, 0x73, 0x65, 0x72, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x22, 0x41, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x34, 0x12, 0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x67, 0x63, 0x70, 0x55, 0x73, 0x65, 0x72, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xbe, 0x02, 0x0a, 0x1a, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x47, 0x63, 0x70, 0x55, 0x73, 0x65, 0x72, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x47, 0x63, 0x70, 0x55, 0x73, 0x65, 0x72, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e,
	0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0xb4, 0x01, 0xca, 0x41, 0x3d, 0x0a, 0x14, 0x47, 0x63, 0x70, 0x55, 0x73, 0x65,
	0x72, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x25,
	0x47, 0x63, 0x70, 0x55, 0x73, 0x65, 0x72, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x1e, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x67,
	0x63, 0x70, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x62,
	0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4d, 0x3a, 0x17, 0x67, 0x63,
	0x70, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x62, 0x69,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x22, 0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x67, 0x63, 0x70, 0x55, 0x73, 0x65, 0x72, 0x41, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x12, 0xdb, 0x02, 0x0a, 0x1a, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x47, 0x63, 0x70, 0x55, 0x73, 0x65, 0x72, 0x41, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x47, 0x63, 0x70, 0x55, 0x73, 0x65, 0x72,
	0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0xd1, 0x01, 0xca, 0x41, 0x3d, 0x0a, 0x14, 0x47, 0x63, 0x70, 0x55, 0x73,
	0x65, 0x72, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x12,
	0x25, 0x47, 0x63, 0x70, 0x55, 0x73, 0x65, 0x72, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x23, 0x67, 0x63, 0x70, 0x5f, 0x75, 0x73, 0x65,
	0x72, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x62, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x65, 0x3a, 0x17, 0x67, 0x63, 0x70, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x61, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x5f, 0x62, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x32, 0x4a, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x67, 0x63, 0x70, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x5f, 0x62, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x67,
	0x63, 0x70, 0x55, 0x73, 0x65, 0x72, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x8c, 0x02, 0x0a, 0x1a, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x47, 0x63, 0x70, 0x55, 0x73, 0x65, 0x72, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42,
	0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x47, 0x63, 0x70, 0x55, 0x73, 0x65, 0x72, 0x41, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x82, 0x01, 0xca, 0x41, 0x3e, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x25,
	0x47, 0x63, 0x70, 0x55, 0x73, 0x65, 0x72, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x34, 0x2a, 0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72,
	0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x67, 0x63,
	0x70, 0x55, 0x73, 0x65, 0x72, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x82, 0x01, 0x0a, 0x0c, 0x53, 0x65, 0x74, 0x49, 0x61,
	0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x15, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x22, 0x37, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x3a, 0x01, 0x2a, 0x22, 0x2c, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x61, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73,
	0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x82, 0x01, 0x0a, 0x0c,
	0x47, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x22, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74,
	0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31,
	0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x37, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x3a,
	0x01, 0x2a, 0x22, 0x2c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x3d, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x67, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x12, 0xbf, 0x02, 0x0a, 0x12, 0x54, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d,
	0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50,
	0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76,
	0x31, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xd3, 0x01, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0xcc, 0x01, 0x3a, 0x01, 0x2a, 0x5a, 0x46, 0x3a, 0x01, 0x2a, 0x22, 0x41,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x61, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x61,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x74,
	0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x5a, 0x4b, 0x3a, 0x01, 0x2a, 0x22, 0x46, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x65,
	0x72, 0x69, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x74, 0x65, 0x73, 0x74,
	0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x32,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x61, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x74, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x1a, 0x57, 0xca, 0x41, 0x23, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74,
	0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xb0, 0x02, 0x0a, 0x2b,
	0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78,
	0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x42, 0x19, 0x41, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x72, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x5c, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x72, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x70, 0x62, 0x3b,
	0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x72, 0x70, 0x62, 0xa2, 0x02, 0x04, 0x47, 0x41, 0x43, 0x4d, 0xaa, 0x02, 0x27,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e,
	0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x4d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x72, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x27, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x5c, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5c, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x5c, 0x56,
	0x31, 0xea, 0x02, 0x2a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x49, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x3a, 0x3a, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x78, 0x74, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_identity_accesscontextmanager_v1_access_context_manager_proto_rawDescOnce sync.Once
	file_google_identity_accesscontextmanager_v1_access_context_manager_proto_rawDescData = file_google_identity_accesscontextmanager_v1_access_context_manager_proto_rawDesc
)

func file_google_identity_accesscontextmanager_v1_access_context_manager_proto_rawDescGZIP() []byte {
	file_google_identity_accesscontextmanager_v1_access_context_manager_proto_rawDescOnce.Do(func() {
		file_google_identity_accesscontextmanager_v1_access_context_manager_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_identity_accesscontextmanager_v1_access_context_manager_proto_rawDescData)
	})
	return file_google_identity_accesscontextmanager_v1_access_context_manager_proto_rawDescData
}

var file_google_identity_accesscontextmanager_v1_access_context_manager_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_identity_accesscontextmanager_v1_access_context_manager_proto_msgTypes = make([]protoimpl.MessageInfo, 31)
var file_google_identity_accesscontextmanager_v1_access_context_manager_proto_goTypes = []any{
	(LevelFormat)(0),                              // 0: google.identity.accesscontextmanager.v1.LevelFormat
	(*ListAccessPoliciesRequest)(nil),             // 1: google.identity.accesscontextmanager.v1.ListAccessPoliciesRequest
	(*ListAccessPoliciesResponse)(nil),            // 2: google.identity.accesscontextmanager.v1.ListAccessPoliciesResponse
	(*GetAccessPolicyRequest)(nil),                // 3: google.identity.accesscontextmanager.v1.GetAccessPolicyRequest
	(*UpdateAccessPolicyRequest)(nil),             // 4: google.identity.accesscontextmanager.v1.UpdateAccessPolicyRequest
	(*DeleteAccessPolicyRequest)(nil),             // 5: google.identity.accesscontextmanager.v1.DeleteAccessPolicyRequest
	(*ListAccessLevelsRequest)(nil),               // 6: google.identity.accesscontextmanager.v1.ListAccessLevelsRequest
	(*ListAccessLevelsResponse)(nil),              // 7: google.identity.accesscontextmanager.v1.ListAccessLevelsResponse
	(*GetAccessLevelRequest)(nil),                 // 8: google.identity.accesscontextmanager.v1.GetAccessLevelRequest
	(*CreateAccessLevelRequest)(nil),              // 9: google.identity.accesscontextmanager.v1.CreateAccessLevelRequest
	(*UpdateAccessLevelRequest)(nil),              // 10: google.identity.accesscontextmanager.v1.UpdateAccessLevelRequest
	(*DeleteAccessLevelRequest)(nil),              // 11: google.identity.accesscontextmanager.v1.DeleteAccessLevelRequest
	(*ReplaceAccessLevelsRequest)(nil),            // 12: google.identity.accesscontextmanager.v1.ReplaceAccessLevelsRequest
	(*ReplaceAccessLevelsResponse)(nil),           // 13: google.identity.accesscontextmanager.v1.ReplaceAccessLevelsResponse
	(*ListServicePerimetersRequest)(nil),          // 14: google.identity.accesscontextmanager.v1.ListServicePerimetersRequest
	(*ListServicePerimetersResponse)(nil),         // 15: google.identity.accesscontextmanager.v1.ListServicePerimetersResponse
	(*GetServicePerimeterRequest)(nil),            // 16: google.identity.accesscontextmanager.v1.GetServicePerimeterRequest
	(*CreateServicePerimeterRequest)(nil),         // 17: google.identity.accesscontextmanager.v1.CreateServicePerimeterRequest
	(*UpdateServicePerimeterRequest)(nil),         // 18: google.identity.accesscontextmanager.v1.UpdateServicePerimeterRequest
	(*DeleteServicePerimeterRequest)(nil),         // 19: google.identity.accesscontextmanager.v1.DeleteServicePerimeterRequest
	(*ReplaceServicePerimetersRequest)(nil),       // 20: google.identity.accesscontextmanager.v1.ReplaceServicePerimetersRequest
	(*ReplaceServicePerimetersResponse)(nil),      // 21: google.identity.accesscontextmanager.v1.ReplaceServicePerimetersResponse
	(*CommitServicePerimetersRequest)(nil),        // 22: google.identity.accesscontextmanager.v1.CommitServicePerimetersRequest
	(*CommitServicePerimetersResponse)(nil),       // 23: google.identity.accesscontextmanager.v1.CommitServicePerimetersResponse
	(*ListGcpUserAccessBindingsRequest)(nil),      // 24: google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsRequest
	(*ListGcpUserAccessBindingsResponse)(nil),     // 25: google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsResponse
	(*GetGcpUserAccessBindingRequest)(nil),        // 26: google.identity.accesscontextmanager.v1.GetGcpUserAccessBindingRequest
	(*CreateGcpUserAccessBindingRequest)(nil),     // 27: google.identity.accesscontextmanager.v1.CreateGcpUserAccessBindingRequest
	(*UpdateGcpUserAccessBindingRequest)(nil),     // 28: google.identity.accesscontextmanager.v1.UpdateGcpUserAccessBindingRequest
	(*DeleteGcpUserAccessBindingRequest)(nil),     // 29: google.identity.accesscontextmanager.v1.DeleteGcpUserAccessBindingRequest
	(*GcpUserAccessBindingOperationMetadata)(nil), // 30: google.identity.accesscontextmanager.v1.GcpUserAccessBindingOperationMetadata
	(*AccessContextManagerOperationMetadata)(nil), // 31: google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata
	(*AccessPolicy)(nil),                          // 32: google.identity.accesscontextmanager.v1.AccessPolicy
	(*fieldmaskpb.FieldMask)(nil),                 // 33: google.protobuf.FieldMask
	(*AccessLevel)(nil),                           // 34: google.identity.accesscontextmanager.v1.AccessLevel
	(*ServicePerimeter)(nil),                      // 35: google.identity.accesscontextmanager.v1.ServicePerimeter
	(*GcpUserAccessBinding)(nil),                  // 36: google.identity.accesscontextmanager.v1.GcpUserAccessBinding
	(*iampb.SetIamPolicyRequest)(nil),             // 37: google.iam.v1.SetIamPolicyRequest
	(*iampb.GetIamPolicyRequest)(nil),             // 38: google.iam.v1.GetIamPolicyRequest
	(*iampb.TestIamPermissionsRequest)(nil),       // 39: google.iam.v1.TestIamPermissionsRequest
	(*longrunningpb.Operation)(nil),               // 40: google.longrunning.Operation
	(*iampb.Policy)(nil),                          // 41: google.iam.v1.Policy
	(*iampb.TestIamPermissionsResponse)(nil),      // 42: google.iam.v1.TestIamPermissionsResponse
}
var file_google_identity_accesscontextmanager_v1_access_context_manager_proto_depIdxs = []int32{
	32, // 0: google.identity.accesscontextmanager.v1.ListAccessPoliciesResponse.access_policies:type_name -> google.identity.accesscontextmanager.v1.AccessPolicy
	32, // 1: google.identity.accesscontextmanager.v1.UpdateAccessPolicyRequest.policy:type_name -> google.identity.accesscontextmanager.v1.AccessPolicy
	33, // 2: google.identity.accesscontextmanager.v1.UpdateAccessPolicyRequest.update_mask:type_name -> google.protobuf.FieldMask
	0,  // 3: google.identity.accesscontextmanager.v1.ListAccessLevelsRequest.access_level_format:type_name -> google.identity.accesscontextmanager.v1.LevelFormat
	34, // 4: google.identity.accesscontextmanager.v1.ListAccessLevelsResponse.access_levels:type_name -> google.identity.accesscontextmanager.v1.AccessLevel
	0,  // 5: google.identity.accesscontextmanager.v1.GetAccessLevelRequest.access_level_format:type_name -> google.identity.accesscontextmanager.v1.LevelFormat
	34, // 6: google.identity.accesscontextmanager.v1.CreateAccessLevelRequest.access_level:type_name -> google.identity.accesscontextmanager.v1.AccessLevel
	34, // 7: google.identity.accesscontextmanager.v1.UpdateAccessLevelRequest.access_level:type_name -> google.identity.accesscontextmanager.v1.AccessLevel
	33, // 8: google.identity.accesscontextmanager.v1.UpdateAccessLevelRequest.update_mask:type_name -> google.protobuf.FieldMask
	34, // 9: google.identity.accesscontextmanager.v1.ReplaceAccessLevelsRequest.access_levels:type_name -> google.identity.accesscontextmanager.v1.AccessLevel
	34, // 10: google.identity.accesscontextmanager.v1.ReplaceAccessLevelsResponse.access_levels:type_name -> google.identity.accesscontextmanager.v1.AccessLevel
	35, // 11: google.identity.accesscontextmanager.v1.ListServicePerimetersResponse.service_perimeters:type_name -> google.identity.accesscontextmanager.v1.ServicePerimeter
	35, // 12: google.identity.accesscontextmanager.v1.CreateServicePerimeterRequest.service_perimeter:type_name -> google.identity.accesscontextmanager.v1.ServicePerimeter
	35, // 13: google.identity.accesscontextmanager.v1.UpdateServicePerimeterRequest.service_perimeter:type_name -> google.identity.accesscontextmanager.v1.ServicePerimeter
	33, // 14: google.identity.accesscontextmanager.v1.UpdateServicePerimeterRequest.update_mask:type_name -> google.protobuf.FieldMask
	35, // 15: google.identity.accesscontextmanager.v1.ReplaceServicePerimetersRequest.service_perimeters:type_name -> google.identity.accesscontextmanager.v1.ServicePerimeter
	35, // 16: google.identity.accesscontextmanager.v1.ReplaceServicePerimetersResponse.service_perimeters:type_name -> google.identity.accesscontextmanager.v1.ServicePerimeter
	35, // 17: google.identity.accesscontextmanager.v1.CommitServicePerimetersResponse.service_perimeters:type_name -> google.identity.accesscontextmanager.v1.ServicePerimeter
	36, // 18: google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsResponse.gcp_user_access_bindings:type_name -> google.identity.accesscontextmanager.v1.GcpUserAccessBinding
	36, // 19: google.identity.accesscontextmanager.v1.CreateGcpUserAccessBindingRequest.gcp_user_access_binding:type_name -> google.identity.accesscontextmanager.v1.GcpUserAccessBinding
	36, // 20: google.identity.accesscontextmanager.v1.UpdateGcpUserAccessBindingRequest.gcp_user_access_binding:type_name -> google.identity.accesscontextmanager.v1.GcpUserAccessBinding
	33, // 21: google.identity.accesscontextmanager.v1.UpdateGcpUserAccessBindingRequest.update_mask:type_name -> google.protobuf.FieldMask
	1,  // 22: google.identity.accesscontextmanager.v1.AccessContextManager.ListAccessPolicies:input_type -> google.identity.accesscontextmanager.v1.ListAccessPoliciesRequest
	3,  // 23: google.identity.accesscontextmanager.v1.AccessContextManager.GetAccessPolicy:input_type -> google.identity.accesscontextmanager.v1.GetAccessPolicyRequest
	32, // 24: google.identity.accesscontextmanager.v1.AccessContextManager.CreateAccessPolicy:input_type -> google.identity.accesscontextmanager.v1.AccessPolicy
	4,  // 25: google.identity.accesscontextmanager.v1.AccessContextManager.UpdateAccessPolicy:input_type -> google.identity.accesscontextmanager.v1.UpdateAccessPolicyRequest
	5,  // 26: google.identity.accesscontextmanager.v1.AccessContextManager.DeleteAccessPolicy:input_type -> google.identity.accesscontextmanager.v1.DeleteAccessPolicyRequest
	6,  // 27: google.identity.accesscontextmanager.v1.AccessContextManager.ListAccessLevels:input_type -> google.identity.accesscontextmanager.v1.ListAccessLevelsRequest
	8,  // 28: google.identity.accesscontextmanager.v1.AccessContextManager.GetAccessLevel:input_type -> google.identity.accesscontextmanager.v1.GetAccessLevelRequest
	9,  // 29: google.identity.accesscontextmanager.v1.AccessContextManager.CreateAccessLevel:input_type -> google.identity.accesscontextmanager.v1.CreateAccessLevelRequest
	10, // 30: google.identity.accesscontextmanager.v1.AccessContextManager.UpdateAccessLevel:input_type -> google.identity.accesscontextmanager.v1.UpdateAccessLevelRequest
	11, // 31: google.identity.accesscontextmanager.v1.AccessContextManager.DeleteAccessLevel:input_type -> google.identity.accesscontextmanager.v1.DeleteAccessLevelRequest
	12, // 32: google.identity.accesscontextmanager.v1.AccessContextManager.ReplaceAccessLevels:input_type -> google.identity.accesscontextmanager.v1.ReplaceAccessLevelsRequest
	14, // 33: google.identity.accesscontextmanager.v1.AccessContextManager.ListServicePerimeters:input_type -> google.identity.accesscontextmanager.v1.ListServicePerimetersRequest
	16, // 34: google.identity.accesscontextmanager.v1.AccessContextManager.GetServicePerimeter:input_type -> google.identity.accesscontextmanager.v1.GetServicePerimeterRequest
	17, // 35: google.identity.accesscontextmanager.v1.AccessContextManager.CreateServicePerimeter:input_type -> google.identity.accesscontextmanager.v1.CreateServicePerimeterRequest
	18, // 36: google.identity.accesscontextmanager.v1.AccessContextManager.UpdateServicePerimeter:input_type -> google.identity.accesscontextmanager.v1.UpdateServicePerimeterRequest
	19, // 37: google.identity.accesscontextmanager.v1.AccessContextManager.DeleteServicePerimeter:input_type -> google.identity.accesscontextmanager.v1.DeleteServicePerimeterRequest
	20, // 38: google.identity.accesscontextmanager.v1.AccessContextManager.ReplaceServicePerimeters:input_type -> google.identity.accesscontextmanager.v1.ReplaceServicePerimetersRequest
	22, // 39: google.identity.accesscontextmanager.v1.AccessContextManager.CommitServicePerimeters:input_type -> google.identity.accesscontextmanager.v1.CommitServicePerimetersRequest
	24, // 40: google.identity.accesscontextmanager.v1.AccessContextManager.ListGcpUserAccessBindings:input_type -> google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsRequest
	26, // 41: google.identity.accesscontextmanager.v1.AccessContextManager.GetGcpUserAccessBinding:input_type -> google.identity.accesscontextmanager.v1.GetGcpUserAccessBindingRequest
	27, // 42: google.identity.accesscontextmanager.v1.AccessContextManager.CreateGcpUserAccessBinding:input_type -> google.identity.accesscontextmanager.v1.CreateGcpUserAccessBindingRequest
	28, // 43: google.identity.accesscontextmanager.v1.AccessContextManager.UpdateGcpUserAccessBinding:input_type -> google.identity.accesscontextmanager.v1.UpdateGcpUserAccessBindingRequest
	29, // 44: google.identity.accesscontextmanager.v1.AccessContextManager.DeleteGcpUserAccessBinding:input_type -> google.identity.accesscontextmanager.v1.DeleteGcpUserAccessBindingRequest
	37, // 45: google.identity.accesscontextmanager.v1.AccessContextManager.SetIamPolicy:input_type -> google.iam.v1.SetIamPolicyRequest
	38, // 46: google.identity.accesscontextmanager.v1.AccessContextManager.GetIamPolicy:input_type -> google.iam.v1.GetIamPolicyRequest
	39, // 47: google.identity.accesscontextmanager.v1.AccessContextManager.TestIamPermissions:input_type -> google.iam.v1.TestIamPermissionsRequest
	2,  // 48: google.identity.accesscontextmanager.v1.AccessContextManager.ListAccessPolicies:output_type -> google.identity.accesscontextmanager.v1.ListAccessPoliciesResponse
	32, // 49: google.identity.accesscontextmanager.v1.AccessContextManager.GetAccessPolicy:output_type -> google.identity.accesscontextmanager.v1.AccessPolicy
	40, // 50: google.identity.accesscontextmanager.v1.AccessContextManager.CreateAccessPolicy:output_type -> google.longrunning.Operation
	40, // 51: google.identity.accesscontextmanager.v1.AccessContextManager.UpdateAccessPolicy:output_type -> google.longrunning.Operation
	40, // 52: google.identity.accesscontextmanager.v1.AccessContextManager.DeleteAccessPolicy:output_type -> google.longrunning.Operation
	7,  // 53: google.identity.accesscontextmanager.v1.AccessContextManager.ListAccessLevels:output_type -> google.identity.accesscontextmanager.v1.ListAccessLevelsResponse
	34, // 54: google.identity.accesscontextmanager.v1.AccessContextManager.GetAccessLevel:output_type -> google.identity.accesscontextmanager.v1.AccessLevel
	40, // 55: google.identity.accesscontextmanager.v1.AccessContextManager.CreateAccessLevel:output_type -> google.longrunning.Operation
	40, // 56: google.identity.accesscontextmanager.v1.AccessContextManager.UpdateAccessLevel:output_type -> google.longrunning.Operation
	40, // 57: google.identity.accesscontextmanager.v1.AccessContextManager.DeleteAccessLevel:output_type -> google.longrunning.Operation
	40, // 58: google.identity.accesscontextmanager.v1.AccessContextManager.ReplaceAccessLevels:output_type -> google.longrunning.Operation
	15, // 59: google.identity.accesscontextmanager.v1.AccessContextManager.ListServicePerimeters:output_type -> google.identity.accesscontextmanager.v1.ListServicePerimetersResponse
	35, // 60: google.identity.accesscontextmanager.v1.AccessContextManager.GetServicePerimeter:output_type -> google.identity.accesscontextmanager.v1.ServicePerimeter
	40, // 61: google.identity.accesscontextmanager.v1.AccessContextManager.CreateServicePerimeter:output_type -> google.longrunning.Operation
	40, // 62: google.identity.accesscontextmanager.v1.AccessContextManager.UpdateServicePerimeter:output_type -> google.longrunning.Operation
	40, // 63: google.identity.accesscontextmanager.v1.AccessContextManager.DeleteServicePerimeter:output_type -> google.longrunning.Operation
	40, // 64: google.identity.accesscontextmanager.v1.AccessContextManager.ReplaceServicePerimeters:output_type -> google.longrunning.Operation
	40, // 65: google.identity.accesscontextmanager.v1.AccessContextManager.CommitServicePerimeters:output_type -> google.longrunning.Operation
	25, // 66: google.identity.accesscontextmanager.v1.AccessContextManager.ListGcpUserAccessBindings:output_type -> google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsResponse
	36, // 67: google.identity.accesscontextmanager.v1.AccessContextManager.GetGcpUserAccessBinding:output_type -> google.identity.accesscontextmanager.v1.GcpUserAccessBinding
	40, // 68: google.identity.accesscontextmanager.v1.AccessContextManager.CreateGcpUserAccessBinding:output_type -> google.longrunning.Operation
	40, // 69: google.identity.accesscontextmanager.v1.AccessContextManager.UpdateGcpUserAccessBinding:output_type -> google.longrunning.Operation
	40, // 70: google.identity.accesscontextmanager.v1.AccessContextManager.DeleteGcpUserAccessBinding:output_type -> google.longrunning.Operation
	41, // 71: google.identity.accesscontextmanager.v1.AccessContextManager.SetIamPolicy:output_type -> google.iam.v1.Policy
	41, // 72: google.identity.accesscontextmanager.v1.AccessContextManager.GetIamPolicy:output_type -> google.iam.v1.Policy
	42, // 73: google.identity.accesscontextmanager.v1.AccessContextManager.TestIamPermissions:output_type -> google.iam.v1.TestIamPermissionsResponse
	48, // [48:74] is the sub-list for method output_type
	22, // [22:48] is the sub-list for method input_type
	22, // [22:22] is the sub-list for extension type_name
	22, // [22:22] is the sub-list for extension extendee
	0,  // [0:22] is the sub-list for field type_name
}

func init() { file_google_identity_accesscontextmanager_v1_access_context_manager_proto_init() }
func file_google_identity_accesscontextmanager_v1_access_context_manager_proto_init() {
	if File_google_identity_accesscontextmanager_v1_access_context_manager_proto != nil {
		return
	}
	file_google_identity_accesscontextmanager_v1_access_level_proto_init()
	file_google_identity_accesscontextmanager_v1_access_policy_proto_init()
	file_google_identity_accesscontextmanager_v1_gcp_user_access_binding_proto_init()
	file_google_identity_accesscontextmanager_v1_service_perimeter_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_identity_accesscontextmanager_v1_access_context_manager_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   31,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_identity_accesscontextmanager_v1_access_context_manager_proto_goTypes,
		DependencyIndexes: file_google_identity_accesscontextmanager_v1_access_context_manager_proto_depIdxs,
		EnumInfos:         file_google_identity_accesscontextmanager_v1_access_context_manager_proto_enumTypes,
		MessageInfos:      file_google_identity_accesscontextmanager_v1_access_context_manager_proto_msgTypes,
	}.Build()
	File_google_identity_accesscontextmanager_v1_access_context_manager_proto = out.File
	file_google_identity_accesscontextmanager_v1_access_context_manager_proto_rawDesc = nil
	file_google_identity_accesscontextmanager_v1_access_context_manager_proto_goTypes = nil
	file_google_identity_accesscontextmanager_v1_access_context_manager_proto_depIdxs = nil
}
