/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.app.services;

import com.dtolabs.rundeck.core.common.IFramework;
import com.dtolabs.rundeck.core.common.INodeSet;
import com.dtolabs.rundeck.core.common.IProjectNodes;
import com.dtolabs.rundeck.core.common.IProjectNodesFactory;
import com.dtolabs.rundeck.core.common.IRundeckProjectConfig;
import com.dtolabs.rundeck.core.common.ProjectNodeSupport;
import com.dtolabs.rundeck.core.nodes.ProjectNodeService;
import com.dtolabs.rundeck.plugins.ServiceNameConstants;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.rundeck.app.services.EnhancedNodeService;
import org.rundeck.app.services.ProjectNodesEnhancer;
import org.rundeck.core.projects.ProjectPluginListConfigurable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import rundeck.services.FrameworkService;
import rundeck.services.NodeService;
import rundeck.services.PluginService;
import rundeck.services.feature.FeatureService;

public class EnhancedNodeService
implements IProjectNodesFactory,
ProjectNodeService,
InitializingBean,
ProjectPluginListConfigurable,
GroovyObject {
    private static final Logger LOG;
    @Autowired
    private NodeService nodeService;
    @Autowired
    private FrameworkService frameworkService;
    @Autowired
    private PluginService pluginService;
    @Autowired
    private FeatureService featureService;
    private Map<String, ProjectNodesEnhancer> loadedPlugins;
    private boolean enabled;
    private String serviceName;
    private String propertyPrefix;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public EnhancedNodeService() {
        MetaClass metaClass;
        String string;
        String string2;
        Map map;
        this.loadedPlugins = map = Collections.synchronizedMap(ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
        this.serviceName = string2 = ServiceNameConstants.NodeEnhancer;
        this.propertyPrefix = string = ProjectNodeSupport.NODE_ENHANCER_PROP_PREFIX;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public void afterPropertiesSet() throws Exception {
        boolean bl;
        this.enabled = bl = this.featureService.featurePresent("enhancedNodes", false);
    }

    public IProjectNodes getNodes(String projectName, List<String> excludePlugin) {
        if (!this.enabled) {
            return this.nodeService.getNodes(projectName);
        }
        ProjectNodesEnhancer enhancer = (ProjectNodesEnhancer)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt((Map)this.loadedPlugins, (Object)projectName), ProjectNodesEnhancer.class);
        if (enhancer == null) {
            enhancer = this.loadPlugins(projectName);
        }
        enhancer.setIgnorePlugins(this.getExcludedPlugins(projectName, enhancer, excludePlugin));
        return enhancer.withProjectNodes(this.nodeService.getNodes(projectName));
    }

    /*
     * WARNING - void declaration
     */
    public List getExcludedPlugins(String projectName, ProjectNodesEnhancer enhancer, List excludePlugin) {
        ProjectNodesEnhancer projectNodesEnhancer;
        void var3_3;
        Reference projectName2 = new Reference((Object)projectName);
        Reference excludePlugin2 = new Reference((Object)var3_3);
        if (!DefaultTypeTransformation.booleanUnbox((Object)((List)excludePlugin2.get()))) {
            excludePlugin2.set((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        }
        List list = (projectNodesEnhancer = enhancer) != null ? projectNodesEnhancer.getPlugins() : null;
        List list2 = list != null ? DefaultGroovyMethods.each((List)list, (Closure)new _getExcludedPlugins_closure1((Object)this, (Object)this, projectName2, excludePlugin2)) : null;
        return (List)excludePlugin2.get();
    }

    public IProjectNodes getNodes(String name) {
        return this.getNodes(name, null);
    }

    private ProjectNodesEnhancer loadPlugins(String project) {
        Reference project2 = new Reference((Object)project);
        IFramework framework = this.frameworkService.getRundeckFramework();
        IRundeckProjectConfig rdprojectconfig = framework.getFrameworkProjectMgr().loadProjectConfig((String)project2.get());
        List plugins = ProjectNodeSupport.listPluginConfigurations((Map)rdprojectconfig.getProjectProperties(), (String)this.propertyPrefix, (String)this.serviceName);
        ProjectNodesEnhancer projectNodesEnhancer = new ProjectNodesEnhancer();
        String string = (String)project2.get();
        projectNodesEnhancer.setProject(string);
        Reference cacheItem = new Reference((Object)projectNodesEnhancer);
        DefaultGroovyMethods.eachWithIndex((List)plugins, (Closure)new _loadPlugins_closure2((Object)this, (Object)this, project2, cacheItem));
        long l = System.currentTimeMillis();
        ((ProjectNodesEnhancer)cacheItem.get()).setLoadedTime(l);
        ProjectNodesEnhancer projectNodesEnhancer2 = (ProjectNodesEnhancer)cacheItem.get();
        ScriptBytecodeAdapter.invokeMethodN(EnhancedNodeService.class, (Object)this.loadedPlugins, (String)"putAt", (Object[])new Object[]{(String)project2.get(), projectNodesEnhancer2});
        return (ProjectNodesEnhancer)cacheItem.get();
    }

    public void refreshProjectNodes(String name) {
        if (this.enabled) {
            this.loadedPlugins.remove(name);
        }
        this.nodeService.refreshProjectNodes(name);
    }

    public INodeSet getNodeSet(String name) {
        if (!this.enabled) {
            return this.nodeService.getNodeSet(name);
        }
        return this.getNodes(name).getNodeSet();
    }

    public INodeSet getNodeSet(String name, List<String> excludePlugins) {
        if (!this.enabled) {
            return this.nodeService.getNodeSet(name);
        }
        return this.getNodes(name, excludePlugins).getNodeSet();
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != EnhancedNodeService.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ Logger pfaccess$0(EnhancedNodeService $that) {
        return (Logger)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.getField(EnhancedNodeService.class, EnhancedNodeService.class, (String)"LOG"), Logger.class);
    }

    public static /* synthetic */ PluginService pfaccess$1(EnhancedNodeService $that) {
        return $that.pluginService;
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Logger logger;
        LOG = logger = LoggerFactory.getLogger(EnhancedNodeService.class);
    }

    @Generated
    public NodeService getNodeService() {
        return this.nodeService;
    }

    @Generated
    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    @Generated
    public FrameworkService getFrameworkService() {
        return this.frameworkService;
    }

    @Generated
    public void setFrameworkService(FrameworkService frameworkService) {
        this.frameworkService = frameworkService;
    }

    @Generated
    public PluginService getPluginService() {
        return this.pluginService;
    }

    @Generated
    public void setPluginService(PluginService pluginService) {
        this.pluginService = pluginService;
    }

    @Generated
    public FeatureService getFeatureService() {
        return this.featureService;
    }

    @Generated
    public void setFeatureService(FeatureService featureService) {
        this.featureService = featureService;
    }

    @Generated
    public String getServiceName() {
        return this.serviceName;
    }

    @Generated
    public void setServiceName(String string) {
        this.serviceName = string;
    }

    @Generated
    public String getPropertyPrefix() {
        return this.propertyPrefix;
    }

    @Generated
    public void setPropertyPrefix(String string) {
        this.propertyPrefix = string;
    }
}

